//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/legacyTaskSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdLegacyTaskSchemaTokens,
    HD_LEGACY_TASK_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdLegacyTaskFactoryDataSourceHandle
HdLegacyTaskSchema::GetFactory() const
{
    return _GetTypedDataSource<HdLegacyTaskFactoryDataSource>(
        HdLegacyTaskSchemaTokens->factory);
}

HdSampledDataSourceHandle
HdLegacyTaskSchema::GetParameters() const
{
    return _GetTypedDataSource<HdSampledDataSource>(
        HdLegacyTaskSchemaTokens->parameters);
}

HdRprimCollectionDataSourceHandle
HdLegacyTaskSchema::GetCollection() const
{
    return _GetTypedDataSource<HdRprimCollectionDataSource>(
        HdLegacyTaskSchemaTokens->collection);
}

HdTokenVectorDataSourceHandle
HdLegacyTaskSchema::GetRenderTags() const
{
    return _GetTypedDataSource<HdTokenVectorDataSource>(
        HdLegacyTaskSchemaTokens->renderTags);
}

/*static*/
HdContainerDataSourceHandle
HdLegacyTaskSchema::BuildRetained(
        const HdLegacyTaskFactoryDataSourceHandle &factory,
        const HdSampledDataSourceHandle &parameters,
        const HdRprimCollectionDataSourceHandle &collection,
        const HdTokenVectorDataSourceHandle &renderTags
)
{
    TfToken _names[4];
    HdDataSourceBaseHandle _values[4];

    size_t _count = 0;

    if (factory) {
        _names[_count] = HdLegacyTaskSchemaTokens->factory;
        _values[_count++] = factory;
    }

    if (parameters) {
        _names[_count] = HdLegacyTaskSchemaTokens->parameters;
        _values[_count++] = parameters;
    }

    if (collection) {
        _names[_count] = HdLegacyTaskSchemaTokens->collection;
        _values[_count++] = collection;
    }

    if (renderTags) {
        _names[_count] = HdLegacyTaskSchemaTokens->renderTags;
        _values[_count++] = renderTags;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdLegacyTaskSchema::Builder &
HdLegacyTaskSchema::Builder::SetFactory(
    const HdLegacyTaskFactoryDataSourceHandle &factory)
{
    _factory = factory;
    return *this;
}

HdLegacyTaskSchema::Builder &
HdLegacyTaskSchema::Builder::SetParameters(
    const HdSampledDataSourceHandle &parameters)
{
    _parameters = parameters;
    return *this;
}

HdLegacyTaskSchema::Builder &
HdLegacyTaskSchema::Builder::SetCollection(
    const HdRprimCollectionDataSourceHandle &collection)
{
    _collection = collection;
    return *this;
}

HdLegacyTaskSchema::Builder &
HdLegacyTaskSchema::Builder::SetRenderTags(
    const HdTokenVectorDataSourceHandle &renderTags)
{
    _renderTags = renderTags;
    return *this;
}

HdContainerDataSourceHandle
HdLegacyTaskSchema::Builder::Build()
{
    return HdLegacyTaskSchema::BuildRetained(
        _factory,
        _parameters,
        _collection,
        _renderTags
    );
}

/*static*/
HdLegacyTaskSchema
HdLegacyTaskSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdLegacyTaskSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdLegacyTaskSchemaTokens->task))
        : nullptr);
}

/*static*/
const TfToken &
HdLegacyTaskSchema::GetSchemaToken()
{
    return HdLegacyTaskSchemaTokens->task;
}

/*static*/
const HdDataSourceLocator &
HdLegacyTaskSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdLegacyTaskSchema::GetFactoryLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdLegacyTaskSchemaTokens->factory);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdLegacyTaskSchema::GetParametersLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdLegacyTaskSchemaTokens->parameters);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdLegacyTaskSchema::GetCollectionLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdLegacyTaskSchemaTokens->collection);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdLegacyTaskSchema::GetRenderTagsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdLegacyTaskSchemaTokens->renderTags);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE