// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef NAMESCHEMEATTRIBUTES_H
#define NAMESCHEMEATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

#include <map>
#include <Namescheme.h>
#include <vector>

// ****************************************************************************
// Class: NameschemeAttributes
//
// Purpose:
//    Information and methods to manage nameschemes
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API NameschemeAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    NameschemeAttributes();
    NameschemeAttributes(const NameschemeAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    NameschemeAttributes(private_tmfs_t tmfs);
    NameschemeAttributes(const NameschemeAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~NameschemeAttributes();

    virtual NameschemeAttributes& operator = (const NameschemeAttributes &obj);
    virtual bool operator == (const NameschemeAttributes &obj) const;
    virtual bool operator != (const NameschemeAttributes &obj) const;
private:
    void Init();
    void Copy(const NameschemeAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectNamescheme();
    void SelectExternalArrayNames();
    void SelectExternalArrayOffsets();
    void SelectExternalArrayData();
    void SelectAllExplicitNames();
    void SelectExplicitIds();
    void SelectExplicitNames();

    // Property setting methods
    void SetNamescheme(const std::string &namescheme_);
    void SetExternalArrayNames(const stringVector &externalArrayNames_);
    void SetExternalArrayOffsets(const intVector &externalArrayOffsets_);
    void SetExternalArrayData(const intVector &externalArrayData_);
    void SetAllExplicitNames(const stringVector &allExplicitNames_);
    void SetExplicitIds(const intVector &explicitIds_);
    void SetExplicitNames(const stringVector &explicitNames_);

    // Property getting methods
    const std::string  &GetNamescheme() const;
          std::string  &GetNamescheme();
    const stringVector &GetExternalArrayNames() const;
          stringVector &GetExternalArrayNames();
    const intVector    &GetExternalArrayOffsets() const;
          intVector    &GetExternalArrayOffsets();
    const intVector    &GetExternalArrayData() const;
          intVector    &GetExternalArrayData();
    const stringVector &GetAllExplicitNames() const;
          stringVector &GetAllExplicitNames();
    const intVector    &GetExplicitIds() const;
          intVector    &GetExplicitIds();
    const stringVector &GetExplicitNames() const;
          stringVector &GetExplicitNames();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void AddExternalArray(const char *name, const int *data, int len);
    void AddExternalArray(const std::string &name, const std::vector<int> &data);
    void SetAllNames(const char *const *const names, int count);
    void SetName(int i, const char *name);
    void SetName(int i, const std::string &n);
    const char *GetName(int n) const;
    void SetAllNames(const std::vector<std::string> &names);
    void CheckIfGetNameCalled();

    // IDs that can be used to identify fields in case statements
    enum {
        ID_namescheme = 0,
        ID_externalArrayNames,
        ID_externalArrayOffsets,
        ID_externalArrayData,
        ID_allExplicitNames,
        ID_explicitIds,
        ID_explicitNames,
        ID__LAST
    };

private:
    std::string  namescheme;
    stringVector externalArrayNames;
    intVector    externalArrayOffsets;
    intVector    externalArrayData;
    stringVector allExplicitNames;
    intVector    explicitIds;
    stringVector explicitNames;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define NAMESCHEMEATTRIBUTES_TMFS "ss*i*i*s*i*s*"

#endif
