// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef COLORATTRIBUTE_H
#define COLORATTRIBUTE_H
#include <state_exports.h>
#include <AttributeSubject.h>



// ****************************************************************************
// Class: ColorAttribute
//
// Purpose:
//    This class contains RGBA color information
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ColorAttribute : public AttributeSubject
{
public:

    // These constructors are for objects of this class
    ColorAttribute();
    ColorAttribute(const ColorAttribute &obj);
protected:
    // These constructors are for objects derived from this class
    ColorAttribute(private_tmfs_t tmfs);
    ColorAttribute(const ColorAttribute &obj, private_tmfs_t tmfs);
public:
    virtual ~ColorAttribute();

    virtual ColorAttribute& operator = (const ColorAttribute &obj);
    virtual bool operator == (const ColorAttribute &obj) const;
    virtual bool operator != (const ColorAttribute &obj) const;
private:
    void Init();
    void Copy(const ColorAttribute &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectColor();

    // Property setting methods
    void SetColor(const unsigned char *color_);

    // Property getting methods
    const unsigned char *GetColor() const;
          unsigned char *GetColor();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    ColorAttribute(int red, int green, int blue, int alpha = 255);
    void SetRgb(int red, int green, int blue);
    void GetRgb(double c[3]) const;
    void SetRgba(int red, int green, int blue, int alpha);
    void GetRgba(double c[4]) const;
    void SetRed(int red);
    void SetGreen(int green);
    void SetBlue(int blue);
    void SetAlpha(int alpha);
    int Red() const;
    int Green() const;
    int Blue() const;
    int Alpha() const;
    void SetRgba2(double c[4]);
    bool SetByName(const char *const colorName);
    const char *GetByName() const;
    static bool RgbStrToRgb(const char *const s, unsigned char rgb[3]);
    static void RgbToRgbStr(unsigned char rgb[3], char *s);
    static ColorAttribute Blend(const ColorAttribute &a, const ColorAttribute &b, double t);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_color = 0,
        ID__LAST
    };

private:
    unsigned char color[4];

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define COLORATTRIBUTE_TMFS "U"

#endif
