/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt2_modulator_bc = R"doc(Modulates DVB-T2 cells.

Input: Bit interleaved (with column twist and bit to cell word de-multiplexing) cells. 
 Output: QPSK, 16QAM, 64QAM or 256QAM modulated complex IQ values (cells).

Constructor Specific Documentation:

Create a DVB-T2 constellation modulator.

Args:
    framesize : FEC frame size (normal or short).
    constellation : DVB-T2 constellation.
    rotation : DVB-T2 constellation rotation (on or off).)doc";


static const char* __doc_gr_dtv_dvbt2_modulator_bc_dvbt2_modulator_bc = R"doc()doc";


static const char* __doc_gr_dtv_dvbt2_modulator_bc_make = R"doc(Modulates DVB-T2 cells.

Input: Bit interleaved (with column twist and bit to cell word de-multiplexing) cells. 
 Output: QPSK, 16QAM, 64QAM or 256QAM modulated complex IQ values (cells).

Constructor Specific Documentation:

Create a DVB-T2 constellation modulator.

Args:
    framesize : FEC frame size (normal or short).
    constellation : DVB-T2 constellation.
    rotation : DVB-T2 constellation rotation (on or off).)doc";
