/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkLabelVotingImageFilter.h"
#include "itkLabelVotingImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
LabelVotingImageFilter::LabelVotingImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
LabelVotingImageFilter::~LabelVotingImageFilter() = default;

//
// ToString
//
std::string LabelVotingImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::LabelVotingImageFilter\n";
  out << "  LabelForUndecidedPixels: ";
  this->ToStringHelper(out, this->m_LabelForUndecidedPixels);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//-----------------------------------------------------------------------------

//
// Execute no paramters
//
Image LabelVotingImageFilter::Execute ( const Image& image1 )
{
  std::vector<Image> images;
  images.push_back( image1 );
  return this->Execute( images );
}

Image LabelVotingImageFilter::Execute ( const Image& image1, const Image& image2 )
{
  std::vector<Image> images;
  images.push_back( image1 );
  images.push_back( image2 );
  return this->Execute( images );
}

Image LabelVotingImageFilter::Execute ( const Image& image1, const Image& image2, const Image& image3 )
{
  std::vector<Image> images;
  images.push_back( image1 );
  images.push_back( image2 );
  images.push_back( image3 );
  return this->Execute( images );
}

Image LabelVotingImageFilter::Execute ( const Image& image1, const Image& image2, const Image& image3, const Image& image4 )
{
  std::vector<Image> images;
  images.push_back( image1 );
  images.push_back( image2 );
  images.push_back( image3 );
  images.push_back( image4 );
  return this->Execute( images );
}

Image LabelVotingImageFilter::Execute ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, const Image& image5 )
{
  std::vector<Image> images;
  images.push_back( image1 );
  images.push_back( image2 );
  images.push_back( image3 );
  images.push_back( image4 );
  images.push_back( image5 );
  return this->Execute( images );
}



Image LabelVotingImageFilter::Execute ( const std::vector<Image> &images )
{
  if ( images.empty() )
    {
    sitkExceptionMacro( "Atleast one input is required" );
    }

  PixelIDValueEnum type = images.front().GetPixelID();
  unsigned int dimension = images.front().GetDimension();

  unsigned int inputIndex = 1;
  for( std::vector<Image>::const_iterator i = images.begin(); i != images.end(); ++i )
    {
    CheckImageMatchingDimension(images.front(), *i, "image" + std::to_string(inputIndex));
    CheckImageMatchingPixelType(images.front(), *i, "image" + std::to_string(inputIndex));
    ++inputIndex;
    }

    return this->m_MemberFactory->GetMemberFunction( type, dimension )( images );
}

//-----------------------------------------------------------------------------


sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");


//
// ExecuteInternal
//
template <class TImageType>
Image LabelVotingImageFilter::ExecuteInternal ( const std::vector<Image> &images )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;


  using FilterType =  itk::LabelVotingImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  for ( unsigned int i = 0; i < images.size(); ++i )
    {
    // Get the pointer to the ITK image contained in image1
    typename InputImageType::ConstPointer image = this->CastImageToITK<InputImageType>( images[i] );

    filter->SetInput( i, image );
    }


  if (m_LabelForUndecidedPixels!=std::numeric_limits<uint64_t>::max()) filter->SetLabelForUndecidedPixels(this->m_LabelForUndecidedPixels);





  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

 }

sitkClangDiagnosticPop();

//
// Function to run the Execute method of this filter
//
Image LabelVoting ( const std::vector<Image> & images, uint64_t labelForUndecidedPixels )
{
  LabelVotingImageFilter filter;
  filter.SetLabelForUndecidedPixels( labelForUndecidedPixels );

  return filter.Execute ( images );
}
Image LabelVoting ( const Image& image1, uint64_t labelForUndecidedPixels )
{
  LabelVotingImageFilter filter;
  filter.SetLabelForUndecidedPixels( labelForUndecidedPixels );
  return filter.Execute ( image1 );
}

Image LabelVoting ( const Image& image1, const Image& image2, uint64_t labelForUndecidedPixels )
{
  LabelVotingImageFilter filter;
  filter.SetLabelForUndecidedPixels( labelForUndecidedPixels );
  return filter.Execute ( image1, image2 );
}

Image LabelVoting ( const Image& image1, const Image& image2, const Image& image3, uint64_t labelForUndecidedPixels )
{
  LabelVotingImageFilter filter;
  filter.SetLabelForUndecidedPixels( labelForUndecidedPixels );
  return filter.Execute ( image1, image2, image3 );
}

Image LabelVoting ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, uint64_t labelForUndecidedPixels )
{
  LabelVotingImageFilter filter;
  filter.SetLabelForUndecidedPixels( labelForUndecidedPixels );
  return filter.Execute ( image1, image2, image3, image4 );
}

Image LabelVoting ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, const Image& image5, uint64_t labelForUndecidedPixels )
{
  LabelVotingImageFilter filter;
  filter.SetLabelForUndecidedPixels( labelForUndecidedPixels );
  return filter.Execute ( image1, image2, image3, image4, image5 );
}



}
