static const char init_js[] =
  "/* -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*- */\n"
  "\n"
  "function Action() {\n"
  "    this.lookup = function(name) {\n"
  "        return this[\"_detail_\" + name];\n"
  "    },\n"
  "\n"
  "    this.toString = function() {\n"
  "        var ret = \"[Action id='\" + this.id + \"'\";\n"
  "        for (var i in this) {\n"
  "            if (i.indexOf(\"_detail_\") == 0) {\n"
  "                var key = i.substr(8);\n"
  "                var value = this[i];\n"
  "                ret += \" \" + key + \"='\" + value + \"'\";\n"
  "            }\n"
  "        }\n"
  "        ret += \"]\";\n"
  "        return ret;\n"
  "    };\n"
  "};\n"
  "\n"
  "function Subject() {\n"
  "    this.isInGroup = function(group) {\n"
  "        for (var n = 0; n < this.groups.length; n++) {\n"
  "            if (this.groups[n] == group)\n"
  "                return true;\n"
  "        }\n"
  "        return false;\n"
  "    };\n"
  "\n"
  "    this.isInNetGroup = function(netGroup) {\n"
  "        return polkit._userIsInNetGroup(this.user, netGroup);\n"
  "    };\n"
  "\n"
  "    this.toString = function() {\n"
  "        var ret = \"[Subject\";\n"
  "        for (var i in this) {\n"
  "            if (typeof this[i] != \"function\") {\n"
  "                if (typeof this[i] == \"string\")\n"
  "                    ret += \" \" + i + \"='\" + this[i] + \"'\";\n"
  "                else\n"
  "                    ret += \" \" + i + \"=\" + this[i];\n"
  "            }\n"
  "        }\n"
  "        ret += \"]\";\n"
  "        return ret;\n"
  "    };\n"
  "};\n"
  "\n"
  "polkit._adminRuleFuncs = [];\n"
  "polkit.addAdminRule = function(callback) {this._adminRuleFuncs.push(callback);};\n"
  "polkit._runAdminRules = function(action, subject) {\n"
  "    var ret = null;\n"
  "    for (var n = 0; n < this._adminRuleFuncs.length; n++) {\n"
  "        var func = this._adminRuleFuncs[n];\n"
  "        var func_ret = func(action, subject);\n"
  "        if (func_ret) {\n"
  "            ret = func_ret;\n"
  "            break\n"
  "        }\n"
  "    }\n"
  "    return ret ? ret.join(\",\") : \"\";\n"
  "};\n"
  "\n"
  "polkit._ruleFuncs = [];\n"
  "polkit.addRule = function(callback) {this._ruleFuncs.push(callback);};\n"
  "polkit._runRules = function(action, subject) {\n"
  "    var ret = null;\n"
  "    for (var n = 0; n < this._ruleFuncs.length; n++) {\n"
  "        var func = this._ruleFuncs[n];\n"
  "        var func_ret = func(action, subject);\n"
  "        if (func_ret) {\n"
  "            ret = func_ret;\n"
  "            break\n"
  "        }\n"
  "    }\n"
  "    return ret;\n"
  "};\n"
  "\n"
  "polkit._deleteRules = function() {\n"
  "    this._adminRuleFuncs = [];\n"
  "    this._ruleFuncs = [];\n"
  "};\n"
  "\n"
  "polkit.Result = {\n"
  "    NO              : \"no\",\n"
  "    YES             : \"yes\",\n"
  "    AUTH_SELF       : \"auth_self\",\n"
  "    AUTH_SELF_KEEP  : \"auth_self_keep\",\n"
  "    AUTH_ADMIN      : \"auth_admin\",\n"
  "    AUTH_ADMIN_KEEP : \"auth_admin_keep\",\n"
  "    NOT_HANDLED     : null\n"
  "};\n";
