// python wrapper for vtkPVServerInformation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVServerInformation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVServerInformation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVServerInformation_ClassNew(); }

#ifndef DECLARED_PyvtkPVInformation_ClassNew
extern "C" { PyObject *PyvtkPVInformation_ClassNew(); }
#define DECLARED_PyvtkPVInformation_ClassNew
#endif

static PyObject *
PyvtkPVServerInformation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVServerInformation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVServerInformation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVServerInformation *tempr = vtkPVServerInformation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVServerInformation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVServerInformation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVServerInformation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVServerInformation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_SetRemoteRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRemoteRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRemoteRendering(temp0);
    }
    else
    {
      op->vtkPVServerInformation::SetRemoteRendering(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetRemoteRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRemoteRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRemoteRendering() :
      op->vtkPVServerInformation::GetRemoteRendering());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetIsInTileDisplay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsInTileDisplay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsInTileDisplay() :
      op->vtkPVServerInformation::GetIsInTileDisplay());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetIsInCave(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsInCave");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsInCave() :
      op->vtkPVServerInformation::GetIsInCave());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_DeepCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DeepCopy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  vtkPVServerInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVServerInformation"))
  {
    if (ap.IsBound())
    {
      op->DeepCopy(temp0);
    }
    else
    {
      op->vtkPVServerInformation::DeepCopy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_CopyFromObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyFromObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  vtkObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObject"))
  {
    if (ap.IsBound())
    {
      op->CopyFromObject(temp0);
    }
    else
    {
      op->vtkPVServerInformation::CopyFromObject(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_AddInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  vtkPVInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVInformation"))
  {
    if (ap.IsBound())
    {
      op->AddInformation(temp0);
    }
    else
    {
      op->vtkPVServerInformation::AddInformation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_SetUseIceT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseIceT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseIceT(temp0);
    }
    else
    {
      op->vtkPVServerInformation::SetUseIceT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetUseIceT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseIceT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetUseIceT() :
      op->vtkPVServerInformation::GetUseIceT());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_SetNVPipeSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNVPipeSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNVPipeSupport(temp0);
    }
    else
    {
      op->vtkPVServerInformation::SetNVPipeSupport(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetNVPipeSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNVPipeSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNVPipeSupport() :
      op->vtkPVServerInformation::GetNVPipeSupport());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_SetTimeout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeout(temp0);
    }
    else
    {
      op->vtkPVServerInformation::SetTimeout(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetTimeout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeout() :
      op->vtkPVServerInformation::GetTimeout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetTimeoutCommand(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeoutCommand");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetTimeoutCommand() :
      &op->vtkPVServerInformation::GetTimeoutCommand());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetTimeoutCommandInterval(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeoutCommandInterval");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeoutCommandInterval() :
      op->vtkPVServerInformation::GetTimeoutCommandInterval());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetTileDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTileDimensions() :
      op->vtkPVServerInformation::GetTileDimensions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetNumberOfProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfProcesses() :
      op->vtkPVServerInformation::GetNumberOfProcesses());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_IsMPIInitialized(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsMPIInitialized");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsMPIInitialized() :
      op->vtkPVServerInformation::IsMPIInitialized());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetMultiClientsEnable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMultiClientsEnable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMultiClientsEnable() :
      op->vtkPVServerInformation::GetMultiClientsEnable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetClientId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetClientId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetClientId() :
      op->vtkPVServerInformation::GetClientId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_SetIdTypeSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIdTypeSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIdTypeSize(temp0);
    }
    else
    {
      op->vtkPVServerInformation::SetIdTypeSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetIdTypeSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIdTypeSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetIdTypeSize() :
      op->vtkPVServerInformation::GetIdTypeSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetSMPBackendName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSMPBackendName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetSMPBackendName() :
      op->vtkPVServerInformation::GetSMPBackendName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetSMPMaxNumberOfThreads(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSMPMaxNumberOfThreads");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSMPMaxNumberOfThreads() :
      op->vtkPVServerInformation::GetSMPMaxNumberOfThreads());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerInformation_GetAcceleratedFiltersOverrideAvailable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAcceleratedFiltersOverrideAvailable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVServerInformation *op = static_cast<vtkPVServerInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAcceleratedFiltersOverrideAvailable() :
      op->vtkPVServerInformation::GetAcceleratedFiltersOverrideAvailable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVServerInformation_Methods[] = {
  {"IsTypeOf", PyvtkPVServerInformation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVServerInformation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVServerInformation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVServerInformation\nC++: static vtkPVServerInformation *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVServerInformation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVServerInformation\nC++: vtkPVServerInformation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVServerInformation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVServerInformation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetRemoteRendering", PyvtkPVServerInformation_SetRemoteRendering, METH_VARARGS,
   "SetRemoteRendering(self, _arg:int) -> None\nC++: virtual void SetRemoteRendering(int _arg)\n\nThis flag indicates whether the server can render remotely. If it\nis off, all rendering has to be on the client. This is only off\nwhen the user starts the server with the --disable-composite\ncommand line option.\n"},
  {"GetRemoteRendering", PyvtkPVServerInformation_GetRemoteRendering, METH_VARARGS,
   "GetRemoteRendering(self) -> int\nC++: virtual int GetRemoteRendering()\n\n"},
  {"GetIsInTileDisplay", PyvtkPVServerInformation_GetIsInTileDisplay, METH_VARARGS,
   "GetIsInTileDisplay(self) -> bool\nC++: virtual bool GetIsInTileDisplay()\n\nReturns true if server is in tile-display mode.\n"},
  {"GetIsInCave", PyvtkPVServerInformation_GetIsInCave, METH_VARARGS,
   "GetIsInCave(self) -> bool\nC++: virtual bool GetIsInCave()\n\nReturns true if server is in CAVE mode.\n"},
  {"DeepCopy", PyvtkPVServerInformation_DeepCopy, METH_VARARGS,
   "DeepCopy(self, info:vtkPVServerInformation) -> None\nC++: void DeepCopy(vtkPVServerInformation *info)\n\n"},
  {"CopyFromObject", PyvtkPVServerInformation_CopyFromObject, METH_VARARGS,
   "CopyFromObject(self, __a:vtkObject) -> None\nC++: void CopyFromObject(vtkObject *) override;\n\nTransfer information about a single object into this object.\n"},
  {"AddInformation", PyvtkPVServerInformation_AddInformation, METH_VARARGS,
   "AddInformation(self, __a:vtkPVInformation) -> None\nC++: void AddInformation(vtkPVInformation *) override;\n\nMerge another information object.\n"},
  {"SetUseIceT", PyvtkPVServerInformation_SetUseIceT, METH_VARARGS,
   "SetUseIceT(self, _arg:int) -> None\nC++: virtual void SetUseIceT(int _arg)\n\nReturns 1 if IceT is available.\n"},
  {"GetUseIceT", PyvtkPVServerInformation_GetUseIceT, METH_VARARGS,
   "GetUseIceT(self) -> int\nC++: virtual int GetUseIceT()\n\n"},
  {"SetNVPipeSupport", PyvtkPVServerInformation_SetNVPipeSupport, METH_VARARGS,
   "SetNVPipeSupport(self, _arg:bool) -> None\nC++: virtual void SetNVPipeSupport(bool _arg)\n\n"},
  {"GetNVPipeSupport", PyvtkPVServerInformation_GetNVPipeSupport, METH_VARARGS,
   "GetNVPipeSupport(self) -> bool\nC++: virtual bool GetNVPipeSupport()\n\n"},
  {"SetTimeout", PyvtkPVServerInformation_SetTimeout, METH_VARARGS,
   "SetTimeout(self, _arg:int) -> None\nC++: virtual void SetTimeout(int _arg)\n\nGet/Set the time after which the server timesout.\n"},
  {"GetTimeout", PyvtkPVServerInformation_GetTimeout, METH_VARARGS,
   "GetTimeout(self) -> int\nC++: virtual int GetTimeout()\n\n"},
  {"GetTimeoutCommand", PyvtkPVServerInformation_GetTimeoutCommand, METH_VARARGS,
   "GetTimeoutCommand(self) -> str\nC++: const std::string &GetTimeoutCommand()\n\nGet the timeout command used by the server to retrieve remaining\ntime.\n"},
  {"GetTimeoutCommandInterval", PyvtkPVServerInformation_GetTimeoutCommandInterval, METH_VARARGS,
   "GetTimeoutCommandInterval(self) -> int\nC++: virtual int GetTimeoutCommandInterval()\n\nGet the time interval in seconds between consecutive calls of\nTimeoutCommand. Defaults to 60.\n"},
  {"GetTileDimensions", PyvtkPVServerInformation_GetTileDimensions, METH_VARARGS,
   "GetTileDimensions(self) -> (int, int)\nC++: virtual int *GetTileDimensions()\n\nWhen in tile display mode, returns the tile dimensions.\n"},
  {"GetNumberOfProcesses", PyvtkPVServerInformation_GetNumberOfProcesses, METH_VARARGS,
   "GetNumberOfProcesses(self) -> int\nC++: virtual int GetNumberOfProcesses()\n\nGet the number of processes.\n"},
  {"IsMPIInitialized", PyvtkPVServerInformation_IsMPIInitialized, METH_VARARGS,
   "IsMPIInitialized(self) -> bool\nC++: virtual bool IsMPIInitialized()\n\nReturn whether MPI is initialized or not.\n"},
  {"GetMultiClientsEnable", PyvtkPVServerInformation_GetMultiClientsEnable, METH_VARARGS,
   "GetMultiClientsEnable(self) -> int\nC++: virtual int GetMultiClientsEnable()\n\nReturn true if the server allow server client to connect to\nitself\n"},
  {"GetClientId", PyvtkPVServerInformation_GetClientId, METH_VARARGS,
   "GetClientId(self) -> int\nC++: virtual int GetClientId()\n\nGet the id that correspond to the current client\n"},
  {"SetIdTypeSize", PyvtkPVServerInformation_SetIdTypeSize, METH_VARARGS,
   "SetIdTypeSize(self, _arg:int) -> None\nC++: virtual void SetIdTypeSize(int _arg)\n\nSet/Get vtkIdType size, which can be 32 or 64\n"},
  {"GetIdTypeSize", PyvtkPVServerInformation_GetIdTypeSize, METH_VARARGS,
   "GetIdTypeSize(self) -> int\nC++: virtual int GetIdTypeSize()\n\n"},
  {"GetSMPBackendName", PyvtkPVServerInformation_GetSMPBackendName, METH_VARARGS,
   "GetSMPBackendName(self) -> str\nC++: virtual std::string GetSMPBackendName()\n\nGet the SMP Tools backend name of the server.\n"},
  {"GetSMPMaxNumberOfThreads", PyvtkPVServerInformation_GetSMPMaxNumberOfThreads, METH_VARARGS,
   "GetSMPMaxNumberOfThreads(self) -> int\nC++: virtual int GetSMPMaxNumberOfThreads()\n\nGet the max number of threads of the server.\n"},
  {"GetAcceleratedFiltersOverrideAvailable", PyvtkPVServerInformation_GetAcceleratedFiltersOverrideAvailable, METH_VARARGS,
   "GetAcceleratedFiltersOverrideAvailable(self) -> int\nC++: virtual int GetAcceleratedFiltersOverrideAvailable()\n\nReturn true if Viskores accelerated filters override is enabled\nin this build.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVServerInformation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("remote_rendering"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetRemoteRendering(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVServerInformation_SetRemoteRendering(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVServerInformation_SetRemoteRendering(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRemoteRendering/SetRemoteRendering\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_ice_t"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetUseIceT(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVServerInformation_SetUseIceT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVServerInformation_SetUseIceT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseIceT/SetUseIceT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("nv_pipe_support"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetNVPipeSupport(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVServerInformation_SetNVPipeSupport(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVServerInformation_SetNVPipeSupport(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNVPipeSupport/SetNVPipeSupport\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("timeout"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetTimeout(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVServerInformation_SetTimeout(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVServerInformation_SetTimeout(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeout/SetTimeout\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("id_type_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetIdTypeSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVServerInformation_SetIdTypeSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVServerInformation_SetIdTypeSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIdTypeSize/SetIdTypeSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_in_tile_display"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetIsInTileDisplay(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIsInTileDisplay\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_in_cave"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetIsInCave(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIsInCave\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("timeout_command"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetTimeoutCommand(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeoutCommand\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("timeout_command_interval"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetTimeoutCommandInterval(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeoutCommandInterval\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tile_dimensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetTileDimensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTileDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("multi_clients_enable"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetMultiClientsEnable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMultiClientsEnable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("client_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetClientId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetClientId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("smp_backend_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetSMPBackendName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSMPBackendName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("smp_max_number_of_threads"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetSMPMaxNumberOfThreads(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSMPMaxNumberOfThreads\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("accelerated_filters_override_available"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetAcceleratedFiltersOverrideAvailable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAcceleratedFiltersOverrideAvailable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_processes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerInformation_GetNumberOfProcesses(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfProcesses\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVServerInformation_Doc =
  "vtkPVServerInformation - Gets features of the server.\n\n"
  "Superclass: vtkPVInformation\n\n"
  "This objects is used by the client to get the features supported by\n"
  "the server. At the moment, server information is only on the root.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVServerInformation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVServerInformation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVServerInformation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVServerInformation_StaticNew()
{
  return vtkPVServerInformation::New();
}

PyObject *PyvtkPVServerInformation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVServerInformation_Type, PyvtkPVServerInformation_Methods,
    "vtkPVServerInformation",
 &PyvtkPVServerInformation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVInformation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVServerInformation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVServerInformation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVServerInformation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVServerInformation", o) != 0)
  {
    Py_DECREF(o);
  }

}

