// python wrapper for vtkPVMetaClipDataSet
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVMetaClipDataSet.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVMetaClipDataSet(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVMetaClipDataSet_ClassNew(); }

#ifndef DECLARED_PyvtkPVDataSetAlgorithmSelectorFilter_ClassNew
extern "C" { PyObject *PyvtkPVDataSetAlgorithmSelectorFilter_ClassNew(); }
#define DECLARED_PyvtkPVDataSetAlgorithmSelectorFilter_ClassNew
#endif

static PyObject *
PyvtkPVMetaClipDataSet_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVMetaClipDataSet::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVMetaClipDataSet::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVMetaClipDataSet *tempr = vtkPVMetaClipDataSet::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVMetaClipDataSet *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVMetaClipDataSet::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVMetaClipDataSet::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVMetaClipDataSet::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_PreserveInputCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PreserveInputCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->PreserveInputCells(temp0);
    }
    else
    {
      op->vtkPVMetaClipDataSet::PreserveInputCells(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_SetImplicitFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImplicitFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  vtkImplicitFunction *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkImplicitFunction"))
  {
    if (ap.IsBound())
    {
      op->SetImplicitFunction(temp0);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetImplicitFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_SetInsideOut(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInsideOut");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInsideOut(temp0);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetInsideOut(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_SetClipFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetClipFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  vtkImplicitFunction *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkImplicitFunction"))
  {
    if (ap.IsBound())
    {
      op->SetClipFunction(temp0);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetClipFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_SetDataSetClipFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataSetClipFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  vtkImplicitFunction *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkImplicitFunction"))
  {
    if (ap.IsBound())
    {
      op->SetDataSetClipFunction(temp0);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetDataSetClipFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_SetHyperTreeGridClipFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHyperTreeGridClipFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  vtkImplicitFunction *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkImplicitFunction"))
  {
    if (ap.IsBound())
    {
      op->SetHyperTreeGridClipFunction(temp0);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetHyperTreeGridClipFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_SetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetValue(temp0);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_SetInputArrayToProcess_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVMetaClipDataSet_SetInputArrayToProcess_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  int temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVMetaClipDataSet_SetInputArrayToProcess_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  int temp0;
  vtkInformation *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkInformation"))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetInputArrayToProcess(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVMetaClipDataSet_SetInputArrayToProcess_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  int temp0;
  int temp1;
  int temp2;
  const char *temp3 = nullptr;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVMetaClipDataSet_SetInputArrayToProcess_Methods[] = {
  {"SetInputArrayToProcess", PyvtkPVMetaClipDataSet_SetInputArrayToProcess_s1, METH_VARARGS,
   "@iiiiz"},
  {"SetInputArrayToProcess", PyvtkPVMetaClipDataSet_SetInputArrayToProcess_s2, METH_VARARGS,
   "@iiiii"},
  {"SetInputArrayToProcess", PyvtkPVMetaClipDataSet_SetInputArrayToProcess_s4, METH_VARARGS,
   "@iiizz"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVMetaClipDataSet_SetInputArrayToProcess(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVMetaClipDataSet_SetInputArrayToProcess_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVMetaClipDataSet_SetInputArrayToProcess_s3(self, args);
    case 5:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetInputArrayToProcess");
  return nullptr;
}


static PyObject *
PyvtkPVMetaClipDataSet_SetExactBoxClip(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExactBoxClip");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExactBoxClip(temp0);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetExactBoxClip(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_GetExactBoxClip(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExactBoxClip");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExactBoxClip() :
      op->vtkPVMetaClipDataSet::GetExactBoxClip());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_ExactBoxClipOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExactBoxClipOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExactBoxClipOn();
    }
    else
    {
      op->vtkPVMetaClipDataSet::ExactBoxClipOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_ExactBoxClipOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExactBoxClipOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExactBoxClipOff();
    }
    else
    {
      op->vtkPVMetaClipDataSet::ExactBoxClipOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_SetUseValueAsOffset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseValueAsOffset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseValueAsOffset(temp0);
    }
    else
    {
      op->vtkPVMetaClipDataSet::SetUseValueAsOffset(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_ProcessRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  vtkInformation *temp0 = nullptr;
  vtkCollection *temp1 = nullptr;
  vtkInformationVector *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkCollection") &&
      ap.GetVTKObject(temp2, "vtkInformationVector"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessRequest(temp0, temp1, temp2) :
      op->vtkPVMetaClipDataSet::ProcessRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMetaClipDataSet_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMetaClipDataSet *op = static_cast<vtkPVMetaClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkPVMetaClipDataSet::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVMetaClipDataSet_Methods[] = {
  {"IsTypeOf", PyvtkPVMetaClipDataSet_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVMetaClipDataSet_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVMetaClipDataSet_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVMetaClipDataSet\nC++: static vtkPVMetaClipDataSet *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVMetaClipDataSet_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVMetaClipDataSet\nC++: vtkPVMetaClipDataSet *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVMetaClipDataSet_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVMetaClipDataSet_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"PreserveInputCells", PyvtkPVMetaClipDataSet_PreserveInputCells, METH_VARARGS,
   "PreserveInputCells(self, keepCellAsIs:int) -> None\nC++: void PreserveInputCells(int keepCellAsIs)\n\nEnable or disable the Extract Cells By Regions.\n"},
  {"SetImplicitFunction", PyvtkPVMetaClipDataSet_SetImplicitFunction, METH_VARARGS,
   "SetImplicitFunction(self, func:vtkImplicitFunction) -> None\nC++: void SetImplicitFunction(vtkImplicitFunction *func)\n\n"},
  {"SetInsideOut", PyvtkPVMetaClipDataSet_SetInsideOut, METH_VARARGS,
   "SetInsideOut(self, insideOut:int) -> None\nC++: void SetInsideOut(int insideOut)\n\n"},
  {"SetClipFunction", PyvtkPVMetaClipDataSet_SetClipFunction, METH_VARARGS,
   "SetClipFunction(self, func:vtkImplicitFunction) -> None\nC++: void SetClipFunction(vtkImplicitFunction *func)\n\nExpose method from vtkCutter\n"},
  {"SetDataSetClipFunction", PyvtkPVMetaClipDataSet_SetDataSetClipFunction, METH_VARARGS,
   "SetDataSetClipFunction(self, func:vtkImplicitFunction) -> None\nC++: void SetDataSetClipFunction(vtkImplicitFunction *func)\n\nSets the clip function for vtkDataSet inputs\n"},
  {"SetHyperTreeGridClipFunction", PyvtkPVMetaClipDataSet_SetHyperTreeGridClipFunction, METH_VARARGS,
   "SetHyperTreeGridClipFunction(self, func:vtkImplicitFunction)\n    -> None\nC++: void SetHyperTreeGridClipFunction(vtkImplicitFunction *func)\n\nSets the clip function for vtkHyperTreeGrid inputs\n"},
  {"SetValue", PyvtkPVMetaClipDataSet_SetValue, METH_VARARGS,
   "SetValue(self, value:float) -> None\nC++: void SetValue(double value)\n\nExpose method from vtkClip\n"},
  {"SetInputArrayToProcess", PyvtkPVMetaClipDataSet_SetInputArrayToProcess, METH_VARARGS,
   "SetInputArrayToProcess(self, idx:int, port:int, connection:int,\n    fieldAssociation:int, name:str) -> None\nC++: void SetInputArrayToProcess(int idx, int port,\n    int connection, int fieldAssociation, const char *name)\n    override;\nSetInputArrayToProcess(self, idx:int, port:int, connection:int,\n    fieldAssociation:int, fieldAttributeType:int) -> None\nC++: void SetInputArrayToProcess(int idx, int port,\n    int connection, int fieldAssociation, int fieldAttributeType)\n    override;\nSetInputArrayToProcess(self, idx:int, info:vtkInformation) -> None\nC++: void SetInputArrayToProcess(int idx, vtkInformation *info)\n    override;\nSetInputArrayToProcess(self, idx:int, port:int, connection:int,\n    fieldName:str, fieldType:str) -> None\nC++: void SetInputArrayToProcess(int idx, int port,\n    int connection, const char *fieldName, const char *fieldType)\n    override;\n\nSet the input data arrays that this algorithm will process.\n\nArray is expected to be in the input data object specified by\n(port, connection), and is stored under the given\nfieldAssociation with given name Internally, this algorithm\nreferences it at idx position.\n\nFull signature with array name.\n\n@param idx the intern index of the array, in vtkAlgorithm scope.\nUseful for algorithm expecting different arrays to work.\n@param port the algorithm input port of the data object where to\n    look for the requested array.\nSee @ref GetInputDataObject\n@param connection the algorithm input connection of the data\n    object where to look for the\nrequested array. See @ref GetInputDataObject\n@param fieldAssociation the field in the data object where the\n    array is stored.\nSee vtkDataObject::FieldAssociations for detail.\n@param name the name of the array to process\n"},
  {"SetExactBoxClip", PyvtkPVMetaClipDataSet_SetExactBoxClip, METH_VARARGS,
   "SetExactBoxClip(self, _arg:bool) -> None\nC++: virtual void SetExactBoxClip(bool _arg)\n\nFor clipping a box we will only get an approximate box from the\nvtkPVBox implicit function which can give undesired results. In\norder to get the exact box geometry output we need to perform 6\nplane clips which is very expensive. The default is to not use\nthe exact option. Additionally, the exact box clip must have\ninside out enabled.\n"},
  {"GetExactBoxClip", PyvtkPVMetaClipDataSet_GetExactBoxClip, METH_VARARGS,
   "GetExactBoxClip(self) -> bool\nC++: virtual bool GetExactBoxClip()\n\n"},
  {"ExactBoxClipOn", PyvtkPVMetaClipDataSet_ExactBoxClipOn, METH_VARARGS,
   "ExactBoxClipOn(self) -> None\nC++: virtual void ExactBoxClipOn()\n\n"},
  {"ExactBoxClipOff", PyvtkPVMetaClipDataSet_ExactBoxClipOff, METH_VARARGS,
   "ExactBoxClipOff(self) -> None\nC++: virtual void ExactBoxClipOff()\n\n"},
  {"SetUseValueAsOffset", PyvtkPVMetaClipDataSet_SetUseValueAsOffset, METH_VARARGS,
   "SetUseValueAsOffset(self, __a:int) -> None\nC++: void SetUseValueAsOffset(int)\n\nExpose method from vtkClip\n"},
  {"ProcessRequest", PyvtkPVMetaClipDataSet_ProcessRequest, METH_VARARGS,
   "ProcessRequest(self, request:vtkInformation, inInfo:vtkCollection,\n     outInfo:vtkInformationVector) -> int\nC++: int ProcessRequest(vtkInformation *request,\n    vtkCollection *inInfo, vtkInformationVector *outInfo)\n    override;\n\nForward those methods to the underneath filters\n"},
  {"GetMTime", PyvtkPVMetaClipDataSet_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nOverride GetMTime because the implicit functions need to be taken\ninto account.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVMetaClipDataSet_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("implicit_function"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVMetaClipDataSet_SetImplicitFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVMetaClipDataSet_SetImplicitFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetImplicitFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("inside_out"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVMetaClipDataSet_SetInsideOut(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVMetaClipDataSet_SetInsideOut(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInsideOut\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("clip_function"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVMetaClipDataSet_SetClipFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVMetaClipDataSet_SetClipFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetClipFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_set_clip_function"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVMetaClipDataSet_SetDataSetClipFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVMetaClipDataSet_SetDataSetClipFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDataSetClipFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("hyper_tree_grid_clip_function"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVMetaClipDataSet_SetHyperTreeGridClipFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVMetaClipDataSet_SetHyperTreeGridClipFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHyperTreeGridClipFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("value"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVMetaClipDataSet_SetValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVMetaClipDataSet_SetValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_array_to_process"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVMetaClipDataSet_SetInputArrayToProcess(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVMetaClipDataSet_SetInputArrayToProcess(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInputArrayToProcess\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exact_box_clip"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVMetaClipDataSet_GetExactBoxClip(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVMetaClipDataSet_SetExactBoxClip(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVMetaClipDataSet_SetExactBoxClip(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExactBoxClip/SetExactBoxClip\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_value_as_offset"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVMetaClipDataSet_SetUseValueAsOffset(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVMetaClipDataSet_SetUseValueAsOffset(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseValueAsOffset\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVMetaClipDataSet_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVMetaClipDataSet_Doc =
  "vtkPVMetaClipDataSet - Meta class for clip filter that will allow the\nuser to switch between a regular clip filter or an extract cell by\nregion filter.\n\n"
  "Superclass: vtkPVDataSetAlgorithmSelectorFilter\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVMetaClipDataSet_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkPVMetaClipDataSet", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVMetaClipDataSet_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVMetaClipDataSet_StaticNew()
{
  return vtkPVMetaClipDataSet::New();
}

PyObject *PyvtkPVMetaClipDataSet_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVMetaClipDataSet_Type, PyvtkPVMetaClipDataSet_Methods,
    "vtkPVMetaClipDataSet",
 &PyvtkPVMetaClipDataSet_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVDataSetAlgorithmSelectorFilter_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 2; c++)
  {
    static const struct { const char *name; unsigned int value; }
      constants[2] = {
        { "METACLIP_DATASET", 0 },
        { "METACLIP_HYPERTREEGRID", 1 },
      };

    o = PyLong_FromUnsignedLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVMetaClipDataSet_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVMetaClipDataSet(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVMetaClipDataSet_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVMetaClipDataSet", o) != 0)
  {
    Py_DECREF(o);
  }

}

