/* CalendarView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CalendarView.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011-2015 Maya Developers (http://launchpad.net/maya)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Maxwell Barvian
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <handy.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "elementary-calendar.h"
#include <glib/gi18n-lib.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <libecal/libecal.h>
#include <granite.h>

#define MAYA_VIEW_CALENDAR_VIEW_ACTION_GROUP_PREFIX "calendar"
#define MAYA_VIEW_CALENDAR_VIEW_ACTION_PREFIX MAYA_VIEW_CALENDAR_VIEW_ACTION_GROUP_PREFIX "."
#define MAYA_MAIN_WINDOW_ACTION_PREFIX "win."
#define MAYA_MAIN_WINDOW_ACTION_SHOW_TODAY "action_show_today"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_CALENDAR_VIEW (maya_view_calendar_view_get_type ())
#define MAYA_VIEW_CALENDAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView))
#define MAYA_VIEW_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarViewClass))
#define MAYA_VIEW_IS_CALENDAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW))
#define MAYA_VIEW_IS_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_CALENDAR_VIEW))
#define MAYA_VIEW_CALENDAR_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarViewClass))

typedef struct _MayaViewCalendarView MayaViewCalendarView;
typedef struct _MayaViewCalendarViewClass MayaViewCalendarViewClass;
typedef struct _MayaViewCalendarViewPrivate MayaViewCalendarViewPrivate;

#define CALENDAR_WIDGETS_TYPE_DATE_SWITCHER (calendar_widgets_date_switcher_get_type ())
#define CALENDAR_WIDGETS_DATE_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_WIDGETS_TYPE_DATE_SWITCHER, CalendarWidgetsDateSwitcher))
#define CALENDAR_WIDGETS_DATE_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_WIDGETS_TYPE_DATE_SWITCHER, CalendarWidgetsDateSwitcherClass))
#define CALENDAR_WIDGETS_IS_DATE_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_WIDGETS_TYPE_DATE_SWITCHER))
#define CALENDAR_WIDGETS_IS_DATE_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_WIDGETS_TYPE_DATE_SWITCHER))
#define CALENDAR_WIDGETS_DATE_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_WIDGETS_TYPE_DATE_SWITCHER, CalendarWidgetsDateSwitcherClass))

typedef struct _CalendarWidgetsDateSwitcher CalendarWidgetsDateSwitcher;
typedef struct _CalendarWidgetsDateSwitcherClass CalendarWidgetsDateSwitcherClass;

#define MAYA_VIEW_TYPE_WEEK_LABELS (maya_view_week_labels_get_type ())
#define MAYA_VIEW_WEEK_LABELS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_WEEK_LABELS, MayaViewWeekLabels))
#define MAYA_VIEW_WEEK_LABELS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_WEEK_LABELS, MayaViewWeekLabelsClass))
#define MAYA_VIEW_IS_WEEK_LABELS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_WEEK_LABELS))
#define MAYA_VIEW_IS_WEEK_LABELS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_WEEK_LABELS))
#define MAYA_VIEW_WEEK_LABELS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_WEEK_LABELS, MayaViewWeekLabelsClass))

typedef struct _MayaViewWeekLabels MayaViewWeekLabels;
typedef struct _MayaViewWeekLabelsClass MayaViewWeekLabelsClass;

#define MAYA_VIEW_TYPE_HEADER (maya_view_header_get_type ())
#define MAYA_VIEW_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_HEADER, MayaViewHeader))
#define MAYA_VIEW_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_HEADER, MayaViewHeaderClass))
#define MAYA_VIEW_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_HEADER))
#define MAYA_VIEW_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_HEADER))
#define MAYA_VIEW_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_HEADER, MayaViewHeaderClass))

typedef struct _MayaViewHeader MayaViewHeader;
typedef struct _MayaViewHeaderClass MayaViewHeaderClass;

#define MAYA_VIEW_TYPE_GRID (maya_view_grid_get_type ())
#define MAYA_VIEW_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_GRID, MayaViewGrid))
#define MAYA_VIEW_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_GRID, MayaViewGridClass))
#define MAYA_VIEW_IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_GRID))
#define MAYA_VIEW_IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_GRID))
#define MAYA_VIEW_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_GRID, MayaViewGridClass))

typedef struct _MayaViewGrid MayaViewGrid;
typedef struct _MayaViewGridClass MayaViewGridClass;
enum  {
	MAYA_VIEW_CALENDAR_VIEW_0_PROPERTY,
	MAYA_VIEW_CALENDAR_VIEW_HEADER_BAR_PROPERTY,
	MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY,
	MAYA_VIEW_CALENDAR_VIEW_NUM_PROPERTIES
};
static GParamSpec* maya_view_calendar_view_properties[MAYA_VIEW_CALENDAR_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;

#define CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR (calendar_widgets_connectivity_info_bar_get_type ())
#define CALENDAR_WIDGETS_CONNECTIVITY_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR, CalendarWidgetsConnectivityInfoBar))
#define CALENDAR_WIDGETS_CONNECTIVITY_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR, CalendarWidgetsConnectivityInfoBarClass))
#define CALENDAR_WIDGETS_IS_CONNECTIVITY_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR))
#define CALENDAR_WIDGETS_IS_CONNECTIVITY_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR))
#define CALENDAR_WIDGETS_CONNECTIVITY_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR, CalendarWidgetsConnectivityInfoBarClass))

typedef struct _CalendarWidgetsConnectivityInfoBar CalendarWidgetsConnectivityInfoBar;
typedef struct _CalendarWidgetsConnectivityInfoBarClass CalendarWidgetsConnectivityInfoBarClass;

#define MAYA_VIEW_WIDGETS_TYPE_DYNAMIC_SPINNER (maya_view_widgets_dynamic_spinner_get_type ())
#define MAYA_VIEW_WIDGETS_DYNAMIC_SPINNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_WIDGETS_TYPE_DYNAMIC_SPINNER, MayaViewWidgetsDynamicSpinner))
#define MAYA_VIEW_WIDGETS_DYNAMIC_SPINNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_WIDGETS_TYPE_DYNAMIC_SPINNER, MayaViewWidgetsDynamicSpinnerClass))
#define MAYA_VIEW_WIDGETS_IS_DYNAMIC_SPINNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_WIDGETS_TYPE_DYNAMIC_SPINNER))
#define MAYA_VIEW_WIDGETS_IS_DYNAMIC_SPINNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_WIDGETS_TYPE_DYNAMIC_SPINNER))
#define MAYA_VIEW_WIDGETS_DYNAMIC_SPINNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_WIDGETS_TYPE_DYNAMIC_SPINNER, MayaViewWidgetsDynamicSpinnerClass))

typedef struct _MayaViewWidgetsDynamicSpinner MayaViewWidgetsDynamicSpinner;
typedef struct _MayaViewWidgetsDynamicSpinnerClass MayaViewWidgetsDynamicSpinnerClass;

#define CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER (calendar_widgets_source_popover_get_type ())
#define CALENDAR_WIDGETS_SOURCE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER, CalendarWidgetsSourcePopover))
#define CALENDAR_WIDGETS_SOURCE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER, CalendarWidgetsSourcePopoverClass))
#define CALENDAR_WIDGETS_IS_SOURCE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER))
#define CALENDAR_WIDGETS_IS_SOURCE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER))
#define CALENDAR_WIDGETS_SOURCE_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER, CalendarWidgetsSourcePopoverClass))

typedef struct _CalendarWidgetsSourcePopover CalendarWidgetsSourcePopover;
typedef struct _CalendarWidgetsSourcePopoverClass CalendarWidgetsSourcePopoverClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block24Data Block24Data;
enum  {
	MAYA_VIEW_CALENDAR_VIEW_ON_EVENT_ADD_SIGNAL,
	MAYA_VIEW_CALENDAR_VIEW_SELECTION_CHANGED_SIGNAL,
	MAYA_VIEW_CALENDAR_VIEW_NUM_SIGNALS
};
static guint maya_view_calendar_view_signals[MAYA_VIEW_CALENDAR_VIEW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MayaViewCalendarView {
	GtkBox parent_instance;
	MayaViewCalendarViewPrivate * priv;
	GtkSearchEntry* search_bar;
};

struct _MayaViewCalendarViewClass {
	GtkBoxClass parent_class;
};

struct _MayaViewCalendarViewPrivate {
	CalendarWidgetsDateSwitcher* month_switcher;
	CalendarWidgetsDateSwitcher* year_switcher;
	HdyHeaderBar* _header_bar;
	GDateTime* _selected_date;
	MayaViewWeekLabels* _weeks;
	MayaViewHeader* _header;
	MayaViewGrid* _days_grid;
	GtkStack* _stack;
	GtkLabel* _spacer;
};

struct _Block19Data {
	int _ref_count_;
	MayaViewCalendarView* self;
	ESource* source;
	GeeCollection* events;
};

struct _Block20Data {
	int _ref_count_;
	MayaViewCalendarView* self;
	ESource* source;
	GeeCollection* events;
};

struct _Block21Data {
	int _ref_count_;
	MayaViewCalendarView* self;
	ESource* source;
	GeeCollection* events;
};

struct _Block22Data {
	int _ref_count_;
	MayaViewCalendarView* self;
	GtkLabel* error_label;
	GtkInfoBar* error_bar;
	CalendarEventStore* calmodel;
};

struct _Block23Data {
	int _ref_count_;
	Block22Data * _data22_;
	GraniteServicesContract* contract;
};

struct _Block24Data {
	int _ref_count_;
	Block22Data * _data22_;
	gchar* message;
};

static gint MayaViewCalendarView_private_offset;
static gpointer maya_view_calendar_view_parent_class = NULL;
static GSettings* maya_view_calendar_view_show_weeks;
static GSettings* maya_view_calendar_view_show_weeks = NULL;
static GtkCssProvider* maya_view_calendar_view_style_provider;
static GtkCssProvider* maya_view_calendar_view_style_provider = NULL;
VALA_EXTERN GSettings* maya_application_wingpanel_settings;
VALA_EXTERN GSettings* maya_application_saved_state;

VALA_EXTERN GType maya_view_calendar_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewCalendarView, g_object_unref)
VALA_EXTERN GType calendar_widgets_date_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarWidgetsDateSwitcher, g_object_unref)
VALA_EXTERN GType maya_view_week_labels_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewWeekLabels, g_object_unref)
VALA_EXTERN GType maya_view_header_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewHeader, g_object_unref)
VALA_EXTERN GType maya_view_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewGrid, g_object_unref)
static void maya_view_calendar_view_action_export (MayaViewCalendarView* self);
static void maya_view_calendar_view_set_switcher_date (MayaViewCalendarView* self,
                                                GDateTime* date);
VALA_EXTERN void calendar_widgets_date_switcher_set_text (CalendarWidgetsDateSwitcher* self,
                                              const gchar* value);
static gboolean maya_view_calendar_view_real_scroll_event (GtkWidget* base,
                                                    GdkEventScroll* event);
VALA_EXTERN void maya_view_calendar_view_today (MayaViewCalendarView* self);
static void maya_view_calendar_view_sync_with_model (MayaViewCalendarView* self);
static MayaViewGrid* maya_view_calendar_view_get_days_grid (MayaViewCalendarView* self);
VALA_EXTERN void maya_view_grid_focus_date (MayaViewGrid* self,
                                GDateTime* date);
static void maya_view_calendar_view_on_show_weeks_changed (MayaViewCalendarView* self);
static MayaViewWeekLabels* maya_view_calendar_view_get_weeks (MayaViewCalendarView* self);
VALA_EXTERN void maya_view_week_labels_update (MayaViewWeekLabels* self,
                                   GDateTime* date,
                                   gint nr_of_weeks);
static void maya_view_calendar_view_update_spacer_visible (MayaViewCalendarView* self);
static GtkLabel* maya_view_calendar_view_get_spacer (MayaViewCalendarView* self);
static void maya_view_calendar_view_on_events_added (MayaViewCalendarView* self,
                                              ESource* source,
                                              GeeCollection* events);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static gboolean __lambda134_ (Block19Data* _data19_);
static void maya_view_calendar_view_add_event (MayaViewCalendarView* self,
                                        ESource* source,
                                        ECalComponent* event);
static gboolean ___lambda134__gsource_func (gpointer self);
static void maya_view_calendar_view_on_events_updated (MayaViewCalendarView* self,
                                                ESource* source,
                                                GeeCollection* events);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static gboolean __lambda135_ (Block20Data* _data20_);
static void maya_view_calendar_view_update_event (MayaViewCalendarView* self,
                                           ESource* source,
                                           ECalComponent* event);
static gboolean ___lambda135__gsource_func (gpointer self);
static void maya_view_calendar_view_on_events_removed (MayaViewCalendarView* self,
                                                ESource* source,
                                                GeeCollection* events);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gboolean __lambda136_ (Block21Data* _data21_);
static void maya_view_calendar_view_remove_event (MayaViewCalendarView* self,
                                           ESource* source,
                                           ECalComponent* event);
static gboolean ___lambda136__gsource_func (gpointer self);
static void maya_view_calendar_view_on_model_parameters_changed (MayaViewCalendarView* self);
VALA_EXTERN CalendarUtilDateRange* maya_view_grid_get_grid_range (MayaViewGrid* self);
static gboolean __lambda137_ (MayaViewCalendarView* self);
static void maya_view_calendar_view_remove_all_events (MayaViewCalendarView* self);
static gboolean ___lambda137__gsource_func (gpointer self);
static GtkGrid* maya_view_calendar_view_create_big_grid (MayaViewCalendarView* self);
static void maya_view_calendar_view_set_spacer (MayaViewCalendarView* self,
                                         GtkLabel* value);
VALA_EXTERN MayaViewWeekLabels* maya_view_week_labels_new (void);
VALA_EXTERN MayaViewWeekLabels* maya_view_week_labels_construct (GType object_type);
static void maya_view_calendar_view_set_weeks (MayaViewCalendarView* self,
                                        MayaViewWeekLabels* value);
VALA_EXTERN MayaViewHeader* maya_view_header_new (void);
VALA_EXTERN MayaViewHeader* maya_view_header_construct (GType object_type);
static void maya_view_calendar_view_set_header (MayaViewCalendarView* self,
                                         MayaViewHeader* value);
VALA_EXTERN MayaViewGrid* maya_view_grid_new (void);
VALA_EXTERN MayaViewGrid* maya_view_grid_construct (GType object_type);
static void maya_view_calendar_view_set_days_grid (MayaViewCalendarView* self,
                                            MayaViewGrid* value);
VALA_EXTERN GDateTime* maya_view_calendar_view_get_selected_date (MayaViewCalendarView* self);
static void __lambda132_ (MayaViewCalendarView* self,
                   GDateTime* date);
static void ___lambda132__maya_view_grid_on_event_add (MayaViewGrid* _sender,
                                                GDateTime* date,
                                                gpointer self);
static void __lambda133_ (MayaViewCalendarView* self,
                   GDateTime* date);
static void maya_view_calendar_view_set_selected_date (MayaViewCalendarView* self,
                                                GDateTime* value);
static void ___lambda133__maya_view_grid_selection_changed (MayaViewGrid* _sender,
                                                     GDateTime* new_date,
                                                     gpointer self);
static MayaViewHeader* maya_view_calendar_view_get_header (MayaViewCalendarView* self);
static GtkStack* maya_view_calendar_view_get_stack (MayaViewCalendarView* self);
VALA_EXTERN void maya_view_header_update_columns (MayaViewHeader* self,
                                      gint week_starts_on);
VALA_EXTERN void maya_view_grid_set_range (MayaViewGrid* self,
                               CalendarUtilDateRange* new_range,
                               GDateTime* month_start);
VALA_EXTERN void maya_view_grid_add_event (MayaViewGrid* self,
                               ECalComponent* event);
VALA_EXTERN void maya_view_grid_update_event (MayaViewGrid* self,
                                  ECalComponent* event);
VALA_EXTERN void maya_view_grid_remove_event (MayaViewGrid* self,
                                  ECalComponent* event);
VALA_EXTERN void maya_view_grid_remove_all_events (MayaViewGrid* self);
VALA_EXTERN MayaViewCalendarView* maya_view_calendar_view_new (void);
VALA_EXTERN MayaViewCalendarView* maya_view_calendar_view_construct (GType object_type);
VALA_EXTERN HdyHeaderBar* maya_view_calendar_view_get_header_bar (MayaViewCalendarView* self);
static void maya_view_calendar_view_set_header_bar (MayaViewCalendarView* self,
                                             HdyHeaderBar* value);
static void maya_view_calendar_view_set_stack (MayaViewCalendarView* self,
                                        GtkStack* value);
static GObject * maya_view_calendar_view_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void _maya_view_calendar_view_action_export_g_simple_action_activate (GSimpleAction* _sender,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void _maya_view_calendar_view______lambda138_ (Block23Data* _data23_);
static void __maya_view_calendar_view______lambda138__g_simple_action_activate (GSimpleAction* _sender,
                                                                         GVariant* parameter,
                                                                         gpointer self);
VALA_EXTERN GDateTime* maya_application_get_selected_datetime (void);
VALA_EXTERN GType calendar_widgets_connectivity_info_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarWidgetsConnectivityInfoBar, g_object_unref)
VALA_EXTERN CalendarWidgetsConnectivityInfoBar* calendar_widgets_connectivity_info_bar_new (void);
VALA_EXTERN CalendarWidgetsConnectivityInfoBar* calendar_widgets_connectivity_info_bar_construct (GType object_type);
VALA_EXTERN CalendarWidgetsDateSwitcher* calendar_widgets_date_switcher_new (gint width_chars);
VALA_EXTERN CalendarWidgetsDateSwitcher* calendar_widgets_date_switcher_construct (GType object_type,
                                                                       gint width_chars);
VALA_EXTERN GType maya_view_widgets_dynamic_spinner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewWidgetsDynamicSpinner, g_object_unref)
VALA_EXTERN MayaViewWidgetsDynamicSpinner* maya_view_widgets_dynamic_spinner_new (void);
VALA_EXTERN MayaViewWidgetsDynamicSpinner* maya_view_widgets_dynamic_spinner_construct (GType object_type);
VALA_EXTERN GType calendar_widgets_source_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarWidgetsSourcePopover, g_object_unref)
VALA_EXTERN CalendarWidgetsSourcePopover* calendar_widgets_source_popover_new (void);
VALA_EXTERN CalendarWidgetsSourcePopover* calendar_widgets_source_popover_construct (GType object_type);
static void _maya_view_calendar_view_on_model_parameters_changed_calendar_event_store_parameters_changed (CalendarEventStore* _sender,
                                                                                                   gpointer self);
static void _maya_view_calendar_view_on_events_added_calendar_event_store_events_added (CalendarEventStore* _sender,
                                                                                 ESource* source,
                                                                                 GeeCollection* events,
                                                                                 gpointer self);
static void _maya_view_calendar_view_on_events_updated_calendar_event_store_events_updated (CalendarEventStore* _sender,
                                                                                     ESource* source,
                                                                                     GeeCollection* events,
                                                                                     gpointer self);
static void _maya_view_calendar_view_on_events_removed_calendar_event_store_events_removed (CalendarEventStore* _sender,
                                                                                     ESource* source,
                                                                                     GeeCollection* events,
                                                                                     gpointer self);
static void _maya_view_calendar_view___lambda172_ (MayaViewCalendarView* self);
static void ___lambda173_ (MayaViewCalendarView* self,
                    GtkWidget* child);
static void ____lambda173__gfunc (gconstpointer data,
                           gpointer self);
static void __maya_view_calendar_view___lambda172__g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void _maya_view_calendar_view_on_show_weeks_changed_g_settings_changed (GSettings* _sender,
                                                                        const gchar* key,
                                                                        gpointer self);
static void _maya_view_calendar_view___lambda174_ (Block22Data* _data22_,
                                            gint id);
static void __maya_view_calendar_view___lambda174__gtk_info_bar_response (GtkInfoBar* _sender,
                                                                   gint response_id,
                                                                   gpointer self);
static void _maya_view_calendar_view___lambda175_ (Block22Data* _data22_,
                                            const gchar* message);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static gboolean __lambda176_ (Block24Data* _data24_);
static gboolean ___lambda176__gsource_func (gpointer self);
static void __maya_view_calendar_view___lambda175__calendar_event_store_error_received (CalendarEventStore* _sender,
                                                                                 const gchar* _error_,
                                                                                 gpointer self);
static void _maya_view_calendar_view___lambda177_ (MayaViewCalendarView* self);
static void __maya_view_calendar_view___lambda177__calendar_widgets_date_switcher_left_clicked (CalendarWidgetsDateSwitcher* _sender,
                                                                                         gpointer self);
static void _maya_view_calendar_view___lambda178_ (MayaViewCalendarView* self);
static void __maya_view_calendar_view___lambda178__calendar_widgets_date_switcher_right_clicked (CalendarWidgetsDateSwitcher* _sender,
                                                                                          gpointer self);
static void _maya_view_calendar_view___lambda179_ (MayaViewCalendarView* self);
static void __maya_view_calendar_view___lambda179__calendar_widgets_date_switcher_left_clicked (CalendarWidgetsDateSwitcher* _sender,
                                                                                         gpointer self);
static void _maya_view_calendar_view___lambda180_ (MayaViewCalendarView* self);
static void __maya_view_calendar_view___lambda180__calendar_widgets_date_switcher_right_clicked (CalendarWidgetsDateSwitcher* _sender,
                                                                                          gpointer self);
static void _maya_view_calendar_view___lambda181_ (Block22Data* _data22_);
static void __maya_view_calendar_view___lambda181__calendar_event_store_parameters_changed (CalendarEventStore* _sender,
                                                                                     gpointer self);
static void maya_view_calendar_view_finalize (GObject * obj);
static GType maya_view_calendar_view_get_type_once (void);
static void _vala_maya_view_calendar_view_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_maya_view_calendar_view_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
maya_view_calendar_view_get_instance_private (MayaViewCalendarView* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewCalendarView_private_offset);
}

static void
maya_view_calendar_view_action_export (MayaViewCalendarView* self)
{
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp0_;
	GtkFileFilter* _tmp1_;
	GtkFileChooserNative* filechooser = NULL;
	GtkFileChooserNative* _tmp2_;
	GtkFileChooserNative* _tmp3_;
	GtkFileChooserNative* _tmp4_;
	GtkFileFilter* _tmp5_;
	GtkFileChooserNative* _tmp6_;
	GtkFileChooserNative* _tmp7_;
	GtkFileChooserNative* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	maya_util_save_temp_selected_calendars ();
	_tmp0_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp0_);
	filter = _tmp0_;
	_tmp1_ = filter;
	gtk_file_filter_add_mime_type (_tmp1_, "text/calendar");
	_tmp2_ = gtk_file_chooser_native_new (_ ("Export Calendar…"), NULL, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("Save"), _ ("Cancel"));
	filechooser = _tmp2_;
	_tmp3_ = filechooser;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp3_, TRUE);
	_tmp4_ = filechooser;
	_tmp5_ = filter;
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp4_, _tmp5_);
	_tmp6_ = filechooser;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp6_, _ ("calendar.ics"));
	_tmp7_ = filechooser;
	if (gtk_native_dialog_run ((GtkNativeDialog*) _tmp7_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* destination = NULL;
		GtkFileChooserNative* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = filechooser;
		_tmp9_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp8_);
		destination = _tmp9_;
		_tmp10_ = destination;
		if (_tmp10_ == NULL) {
			GtkFileChooserNative* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = filechooser;
			_tmp12_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp11_);
			_g_free0 (destination);
			destination = _tmp12_;
		} else {
			const gchar* _tmp13_;
			_tmp13_ = destination;
			if (!g_str_has_suffix (_tmp13_, ".ics")) {
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = destination;
				_tmp15_ = g_strconcat (_tmp14_, ".ics", NULL);
				_g_free0 (destination);
				destination = _tmp15_;
			}
		}
		{
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp16_ = g_get_tmp_dir ();
			_tmp17_ = g_strconcat ("mv ", _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, "/calendar.ics ", NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = destination;
			_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
			_tmp23_ = _tmp22_;
			g_spawn_command_line_async (_tmp23_, &_inner_error0_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				_g_free0 (destination);
				_g_object_unref0 (filechooser);
				_g_object_unref0 (filter);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp24_;
			const gchar* _tmp25_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp24_ = e;
			_tmp25_ = _tmp24_->message;
			g_warning ("CalendarView.vala:256: %s", _tmp25_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (destination);
			_g_object_unref0 (filechooser);
			_g_object_unref0 (filter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (destination);
	}
	_tmp26_ = filechooser;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp26_);
	_g_object_unref0 (filechooser);
	_g_object_unref0 (filter);
}

static void
maya_view_calendar_view_set_switcher_date (MayaViewCalendarView* self,
                                           GDateTime* date)
{
	CalendarWidgetsDateSwitcher* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	CalendarWidgetsDateSwitcher* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	_tmp0_ = self->priv->month_switcher;
	_tmp1_ = g_date_time_format (date, "%OB");
	_tmp2_ = _tmp1_;
	calendar_widgets_date_switcher_set_text (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->year_switcher;
	_tmp4_ = g_date_time_format (date, "%Y");
	_tmp5_ = _tmp4_;
	calendar_widgets_date_switcher_set_text (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
}

static gboolean
maya_view_calendar_view_real_scroll_event (GtkWidget* base,
                                           GdkEventScroll* event)
{
	MayaViewCalendarView * self;
	gboolean result;
	self = (MayaViewCalendarView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	result = maya_gestures_utils_on_scroll_event (event);
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
maya_view_calendar_view_today (MayaViewCalendarView* self)
{
	GDateTime* today = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	CalendarEventStore* calmodel = NULL;
	CalendarEventStore* _tmp4_;
	GDateTime* start = NULL;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	CalendarEventStore* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	MayaViewGrid* _tmp14_;
	GDateTime* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = calendar_util_datetime_strip_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	today = _tmp3_;
	_tmp4_ = calendar_event_store_get_default ();
	calmodel = _tmp4_;
	_tmp5_ = today;
	_tmp6_ = _g_date_time_ref0 (_tmp5_);
	_tmp7_ = calendar_util_datetime_get_start_of_month (_tmp6_);
	start = _tmp7_;
	_tmp8_ = start;
	_tmp9_ = calmodel;
	_tmp10_ = calendar_event_store_get_month_start (_tmp9_);
	_tmp11_ = _tmp10_;
	if (!g_date_time_equal (_tmp8_, _tmp11_)) {
		CalendarEventStore* _tmp12_;
		GDateTime* _tmp13_;
		_tmp12_ = calmodel;
		_tmp13_ = start;
		calendar_event_store_set_month_start (_tmp12_, _tmp13_);
	}
	maya_view_calendar_view_sync_with_model (self);
	_tmp14_ = self->priv->_days_grid;
	_tmp15_ = today;
	maya_view_grid_focus_date (_tmp14_, _tmp15_);
	_g_date_time_unref0 (start);
	_g_object_unref0 (calmodel);
	_g_date_time_unref0 (today);
}

static void
maya_view_calendar_view_on_show_weeks_changed (MayaViewCalendarView* self)
{
	CalendarEventStore* model = NULL;
	CalendarEventStore* _tmp0_;
	MayaViewWeekLabels* _tmp1_;
	CalendarUtilDateRange* _tmp2_;
	CalendarUtilDateRange* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	model = _tmp0_;
	_tmp1_ = self->priv->_weeks;
	_tmp2_ = calendar_event_store_get_data_range (model);
	_tmp3_ = _tmp2_;
	_tmp4_ = calendar_util_date_range_get_first_dt (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = calendar_event_store_get_num_weeks (model);
	_tmp7_ = _tmp6_;
	maya_view_week_labels_update (_tmp1_, _tmp5_, _tmp7_);
	maya_view_calendar_view_update_spacer_visible (self);
	_g_object_unref0 (model);
}

static void
maya_view_calendar_view_update_spacer_visible (MayaViewCalendarView* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = maya_view_calendar_view_show_weeks;
	if (g_settings_get_boolean (_tmp0_, "show-weeks")) {
		GtkLabel* _tmp1_;
		_tmp1_ = self->priv->_spacer;
		gtk_widget_show ((GtkWidget*) _tmp1_);
	} else {
		GtkLabel* _tmp2_;
		_tmp2_ = self->priv->_spacer;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		MayaViewCalendarView* self;
		self = _data19_->self;
		_g_object_unref0 (_data19_->source);
		_g_object_unref0 (_data19_->events);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static gboolean
__lambda134_ (Block19Data* _data19_)
{
	MayaViewCalendarView* self;
	gboolean result;
	self = _data19_->self;
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data19_->events);
		_event_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ECalComponent* _tmp4_;
			_tmp1_ = _event_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _event_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			event = (ECalComponent*) _tmp3_;
			_tmp4_ = event;
			maya_view_calendar_view_add_event (self, _data19_->source, _tmp4_);
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda134__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda134_ (self);
	return result;
}

static void
maya_view_calendar_view_on_events_added (MayaViewCalendarView* self,
                                         ESource* source,
                                         GeeCollection* events)
{
	Block19Data* _data19_;
	ESource* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data19_->source);
	_data19_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (events);
	_g_object_unref0 (_data19_->events);
	_data19_->events = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda134__gsource_func, block19_data_ref (_data19_), block19_data_unref);
	block19_data_unref (_data19_);
	_data19_ = NULL;
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		MayaViewCalendarView* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->source);
		_g_object_unref0 (_data20_->events);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static gboolean
__lambda135_ (Block20Data* _data20_)
{
	MayaViewCalendarView* self;
	gboolean result;
	self = _data20_->self;
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data20_->events);
		_event_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ECalComponent* _tmp4_;
			_tmp1_ = _event_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _event_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			event = (ECalComponent*) _tmp3_;
			_tmp4_ = event;
			maya_view_calendar_view_update_event (self, _data20_->source, _tmp4_);
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda135__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda135_ (self);
	return result;
}

static void
maya_view_calendar_view_on_events_updated (MayaViewCalendarView* self,
                                           ESource* source,
                                           GeeCollection* events)
{
	Block20Data* _data20_;
	ESource* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data20_->source);
	_data20_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (events);
	_g_object_unref0 (_data20_->events);
	_data20_->events = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda135__gsource_func, block20_data_ref (_data20_), block20_data_unref);
	block20_data_unref (_data20_);
	_data20_ = NULL;
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		MayaViewCalendarView* self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->source);
		_g_object_unref0 (_data21_->events);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static gboolean
__lambda136_ (Block21Data* _data21_)
{
	MayaViewCalendarView* self;
	gboolean result;
	self = _data21_->self;
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data21_->events);
		_event_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ECalComponent* _tmp4_;
			_tmp1_ = _event_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _event_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			event = (ECalComponent*) _tmp3_;
			_tmp4_ = event;
			maya_view_calendar_view_remove_event (self, _data21_->source, _tmp4_);
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda136__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda136_ (self);
	return result;
}

static void
maya_view_calendar_view_on_events_removed (MayaViewCalendarView* self,
                                           ESource* source,
                                           GeeCollection* events)
{
	Block21Data* _data21_;
	ESource* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data21_->source);
	_data21_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (events);
	_g_object_unref0 (_data21_->events);
	_data21_->events = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda136__gsource_func, block21_data_ref (_data21_), block21_data_unref);
	block21_data_unref (_data21_);
	_data21_ = NULL;
}

static gboolean
__lambda137_ (MayaViewCalendarView* self)
{
	gboolean result;
	maya_view_calendar_view_remove_all_events (self);
	maya_view_calendar_view_sync_with_model (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda137__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda137_ ((MayaViewCalendarView*) self);
	return result;
}

static void
maya_view_calendar_view_on_model_parameters_changed (MayaViewCalendarView* self)
{
	CalendarEventStore* model = NULL;
	CalendarEventStore* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MayaViewGrid* _tmp2_;
	CalendarUtilDateRange* _tmp3_;
	CalendarUtilDateRange* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	model = _tmp0_;
	_tmp2_ = self->priv->_days_grid;
	_tmp3_ = maya_view_grid_get_grid_range (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		CalendarEventStore* _tmp5_;
		CalendarUtilDateRange* _tmp6_;
		CalendarUtilDateRange* _tmp7_;
		MayaViewGrid* _tmp8_;
		CalendarUtilDateRange* _tmp9_;
		CalendarUtilDateRange* _tmp10_;
		_tmp5_ = model;
		_tmp6_ = calendar_event_store_get_data_range (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->_days_grid;
		_tmp9_ = maya_view_grid_get_grid_range (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp1_ = calendar_util_date_range_equals (_tmp7_, _tmp10_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_g_object_unref0 (model);
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda137__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (model);
}

static void
__lambda132_ (MayaViewCalendarView* self,
              GDateTime* date)
{
	g_return_if_fail (date != NULL);
	g_signal_emit (self, maya_view_calendar_view_signals[MAYA_VIEW_CALENDAR_VIEW_ON_EVENT_ADD_SIGNAL], 0, date);
}

static void
___lambda132__maya_view_grid_on_event_add (MayaViewGrid* _sender,
                                           GDateTime* date,
                                           gpointer self)
{
	__lambda132_ ((MayaViewCalendarView*) self, date);
}

static void
__lambda133_ (MayaViewCalendarView* self,
              GDateTime* date)
{
	g_return_if_fail (date != NULL);
	maya_view_calendar_view_set_selected_date (self, date);
	g_signal_emit (self, maya_view_calendar_view_signals[MAYA_VIEW_CALENDAR_VIEW_SELECTION_CHANGED_SIGNAL], 0, date);
}

static void
___lambda133__maya_view_grid_selection_changed (MayaViewGrid* _sender,
                                                GDateTime* new_date,
                                                gpointer self)
{
	__lambda133_ ((MayaViewCalendarView*) self, new_date);
}

static GtkGrid*
maya_view_calendar_view_create_big_grid (MayaViewCalendarView* self)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkStyleContext* spacer_context = NULL;
	GtkLabel* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkCssProvider* _tmp5_;
	MayaViewWeekLabels* _tmp6_;
	MayaViewWeekLabels* _tmp7_;
	MayaViewHeader* _tmp8_;
	MayaViewHeader* _tmp9_;
	MayaViewGrid* _tmp10_;
	MayaViewGrid* _tmp11_;
	MayaViewGrid* _tmp12_;
	GDateTime* _tmp13_;
	MayaViewGrid* _tmp14_;
	MayaViewGrid* _tmp15_;
	GtkGrid* new_big_grid = NULL;
	GtkGrid* _tmp16_;
	GtkLabel* _tmp17_;
	MayaViewHeader* _tmp18_;
	MayaViewGrid* _tmp19_;
	MayaViewWeekLabels* _tmp20_;
	GtkGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	maya_view_calendar_view_set_spacer (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_spacer;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->_spacer;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	spacer_context = _tmp4_;
	_tmp5_ = maya_view_calendar_view_style_provider;
	gtk_style_context_add_provider (spacer_context, (GtkStyleProvider*) _tmp5_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	gtk_style_context_add_class (spacer_context, "weeks");
	_tmp6_ = maya_view_week_labels_new ();
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	maya_view_calendar_view_set_weeks (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = maya_view_header_new ();
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	maya_view_calendar_view_set_header (self, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = maya_view_grid_new ();
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	maya_view_calendar_view_set_days_grid (self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = self->priv->_days_grid;
	_tmp13_ = self->priv->_selected_date;
	maya_view_grid_focus_date (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->_days_grid;
	g_signal_connect_object (_tmp14_, "on-event-add", (GCallback) ___lambda132__maya_view_grid_on_event_add, self, 0);
	_tmp15_ = self->priv->_days_grid;
	g_signal_connect_object (_tmp15_, "selection-changed", (GCallback) ___lambda133__maya_view_grid_selection_changed, self, 0);
	_tmp16_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp16_);
	new_big_grid = _tmp16_;
	_tmp17_ = self->priv->_spacer;
	gtk_grid_attach (new_big_grid, (GtkWidget*) _tmp17_, 0, 0, 1, 1);
	_tmp18_ = self->priv->_header;
	gtk_grid_attach (new_big_grid, (GtkWidget*) _tmp18_, 1, 0, 1, 1);
	_tmp19_ = self->priv->_days_grid;
	gtk_grid_attach (new_big_grid, (GtkWidget*) _tmp19_, 1, 1, 1, 1);
	_tmp20_ = self->priv->_weeks;
	gtk_grid_attach (new_big_grid, (GtkWidget*) _tmp20_, 0, 1, 1, 1);
	gtk_widget_show_all ((GtkWidget*) new_big_grid);
	g_object_set ((GtkWidget*) new_big_grid, "expand", TRUE, NULL);
	maya_view_calendar_view_update_spacer_visible (self);
	result = new_big_grid;
	return result;
}

static void
maya_view_calendar_view_sync_with_model (MayaViewCalendarView* self)
{
	CalendarEventStore* model = NULL;
	CalendarEventStore* _tmp0_;
	GDateTime* previous_first = NULL;
	MayaViewGrid* _tmp1_;
	GtkGrid* big_grid = NULL;
	GtkGrid* _tmp32_;
	GtkStack* _tmp33_;
	GtkGrid* _tmp34_;
	MayaViewHeader* _tmp35_;
	CalendarEventStore* _tmp36_;
	GDateWeekday _tmp37_;
	GDateWeekday _tmp38_;
	MayaViewWeekLabels* _tmp39_;
	CalendarEventStore* _tmp40_;
	CalendarUtilDateRange* _tmp41_;
	CalendarUtilDateRange* _tmp42_;
	GDateTime* _tmp43_;
	GDateTime* _tmp44_;
	CalendarEventStore* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	MayaViewGrid* _tmp48_;
	CalendarEventStore* _tmp49_;
	CalendarUtilDateRange* _tmp50_;
	CalendarUtilDateRange* _tmp51_;
	CalendarEventStore* _tmp52_;
	GDateTime* _tmp53_;
	GDateTime* _tmp54_;
	GDateTime* _tmp55_;
	GDateTime* _tmp63_;
	GtkStack* _tmp72_;
	GtkGrid* _tmp73_;
	g_return_if_fail (self != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	model = _tmp0_;
	previous_first = NULL;
	_tmp1_ = self->priv->_days_grid;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		MayaViewGrid* _tmp3_;
		CalendarUtilDateRange* _tmp4_;
		CalendarUtilDateRange* _tmp5_;
		MayaViewGrid* _tmp23_;
		CalendarUtilDateRange* _tmp24_;
		CalendarUtilDateRange* _tmp25_;
		_tmp3_ = self->priv->_days_grid;
		_tmp4_ = maya_view_grid_get_grid_range (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			gboolean _tmp6_ = FALSE;
			CalendarEventStore* _tmp7_;
			CalendarUtilDateRange* _tmp8_;
			CalendarUtilDateRange* _tmp9_;
			MayaViewGrid* _tmp10_;
			CalendarUtilDateRange* _tmp11_;
			CalendarUtilDateRange* _tmp12_;
			_tmp7_ = model;
			_tmp8_ = calendar_event_store_get_data_range (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = self->priv->_days_grid;
			_tmp11_ = maya_view_grid_get_grid_range (_tmp10_);
			_tmp12_ = _tmp11_;
			if (calendar_util_date_range_equals (_tmp9_, _tmp12_)) {
				_tmp6_ = TRUE;
			} else {
				MayaViewGrid* _tmp13_;
				CalendarUtilDateRange* _tmp14_;
				CalendarUtilDateRange* _tmp15_;
				GDateTime* _tmp16_;
				GDateTime* _tmp17_;
				CalendarEventStore* _tmp18_;
				CalendarUtilDateRange* _tmp19_;
				CalendarUtilDateRange* _tmp20_;
				GDateTime* _tmp21_;
				GDateTime* _tmp22_;
				_tmp13_ = self->priv->_days_grid;
				_tmp14_ = maya_view_grid_get_grid_range (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = calendar_util_date_range_get_first_dt (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = model;
				_tmp19_ = calendar_event_store_get_data_range (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = calendar_util_date_range_get_first_dt (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp6_ = g_date_time_compare (_tmp17_, _tmp22_) == 0;
			}
			_tmp2_ = _tmp6_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_g_date_time_unref0 (previous_first);
			_g_object_unref0 (model);
			return;
		}
		_tmp23_ = self->priv->_days_grid;
		_tmp24_ = maya_view_grid_get_grid_range (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ != NULL) {
			MayaViewGrid* _tmp26_;
			CalendarUtilDateRange* _tmp27_;
			CalendarUtilDateRange* _tmp28_;
			GDateTime* _tmp29_;
			GDateTime* _tmp30_;
			GDateTime* _tmp31_;
			_tmp26_ = self->priv->_days_grid;
			_tmp27_ = maya_view_grid_get_grid_range (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = calendar_util_date_range_get_first_dt (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _g_date_time_ref0 (_tmp30_);
			_g_date_time_unref0 (previous_first);
			previous_first = _tmp31_;
		}
	}
	_tmp32_ = maya_view_calendar_view_create_big_grid (self);
	big_grid = _tmp32_;
	_tmp33_ = self->priv->_stack;
	_tmp34_ = big_grid;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->_header;
	_tmp36_ = model;
	_tmp37_ = calendar_event_store_get_week_starts_on (_tmp36_);
	_tmp38_ = _tmp37_;
	maya_view_header_update_columns (_tmp35_, (gint) _tmp38_);
	_tmp39_ = self->priv->_weeks;
	_tmp40_ = model;
	_tmp41_ = calendar_event_store_get_data_range (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = calendar_util_date_range_get_first_dt (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = model;
	_tmp46_ = calendar_event_store_get_num_weeks (_tmp45_);
	_tmp47_ = _tmp46_;
	maya_view_week_labels_update (_tmp39_, _tmp44_, _tmp47_);
	_tmp48_ = self->priv->_days_grid;
	_tmp49_ = model;
	_tmp50_ = calendar_event_store_get_data_range (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = model;
	_tmp53_ = calendar_event_store_get_month_start (_tmp52_);
	_tmp54_ = _tmp53_;
	maya_view_grid_set_range (_tmp48_, _tmp51_, _tmp54_);
	_tmp55_ = self->priv->_selected_date;
	if (_tmp55_ != NULL) {
		GDateTime* bumpdate = NULL;
		CalendarEventStore* _tmp56_;
		GDateTime* _tmp57_;
		GDateTime* _tmp58_;
		GDateTime* _tmp59_;
		GDateTime* _tmp60_;
		MayaViewGrid* _tmp61_;
		GDateTime* _tmp62_;
		_tmp56_ = model;
		_tmp57_ = calendar_event_store_get_month_start (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_selected_date;
		_tmp60_ = g_date_time_add_days (_tmp58_, g_date_time_get_day_of_month (_tmp59_) - 1);
		bumpdate = _tmp60_;
		_tmp61_ = self->priv->_days_grid;
		_tmp62_ = bumpdate;
		maya_view_grid_focus_date (_tmp61_, _tmp62_);
		_g_date_time_unref0 (bumpdate);
	}
	_tmp63_ = previous_first;
	if (_tmp63_ != NULL) {
		GDateTime* _tmp64_;
		MayaViewGrid* _tmp65_;
		CalendarUtilDateRange* _tmp66_;
		CalendarUtilDateRange* _tmp67_;
		GDateTime* _tmp68_;
		GDateTime* _tmp69_;
		_tmp64_ = previous_first;
		_tmp65_ = self->priv->_days_grid;
		_tmp66_ = maya_view_grid_get_grid_range (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = calendar_util_date_range_get_first_dt (_tmp67_);
		_tmp69_ = _tmp68_;
		if (g_date_time_compare (_tmp64_, _tmp69_) == -1) {
			GtkStack* _tmp70_;
			_tmp70_ = self->priv->_stack;
			gtk_stack_set_transition_type (_tmp70_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
		} else {
			GtkStack* _tmp71_;
			_tmp71_ = self->priv->_stack;
			gtk_stack_set_transition_type (_tmp71_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
		}
	}
	_tmp72_ = self->priv->_stack;
	_tmp73_ = big_grid;
	gtk_stack_set_visible_child (_tmp72_, (GtkWidget*) _tmp73_);
	_g_object_unref0 (big_grid);
	_g_date_time_unref0 (previous_first);
	_g_object_unref0 (model);
}

static void
maya_view_calendar_view_add_event (MayaViewCalendarView* self,
                                   ESource* source,
                                   ECalComponent* event)
{
	gconstpointer _tmp0_;
	MayaViewGrid* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = g_object_get_data ((GObject*) event, "source");
	_vala_assert (((ESource*) _tmp0_) != NULL, "event.get_data<E.Source> (\"source\") != null");
	_tmp1_ = self->priv->_days_grid;
	maya_view_grid_add_event (_tmp1_, event);
}

static void
maya_view_calendar_view_update_event (MayaViewCalendarView* self,
                                      ESource* source,
                                      ECalComponent* event)
{
	MayaViewGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->_days_grid;
	maya_view_grid_update_event (_tmp0_, event);
}

static void
maya_view_calendar_view_remove_event (MayaViewCalendarView* self,
                                      ESource* source,
                                      ECalComponent* event)
{
	MayaViewGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->_days_grid;
	maya_view_grid_remove_event (_tmp0_, event);
}

static void
maya_view_calendar_view_remove_all_events (MayaViewCalendarView* self)
{
	MayaViewGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_days_grid;
	maya_view_grid_remove_all_events (_tmp0_);
}

MayaViewCalendarView*
maya_view_calendar_view_construct (GType object_type)
{
	MayaViewCalendarView * self = NULL;
	self = (MayaViewCalendarView*) g_object_new (object_type, NULL);
	return self;
}

MayaViewCalendarView*
maya_view_calendar_view_new (void)
{
	return maya_view_calendar_view_construct (MAYA_VIEW_TYPE_CALENDAR_VIEW);
}

HdyHeaderBar*
maya_view_calendar_view_get_header_bar (MayaViewCalendarView* self)
{
	HdyHeaderBar* result;
	HdyHeaderBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_header_bar;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_header_bar (MayaViewCalendarView* self,
                                        HdyHeaderBar* value)
{
	HdyHeaderBar* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_calendar_view_get_header_bar (self);
	if (old_value != value) {
		HdyHeaderBar* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_header_bar);
		self->priv->_header_bar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_calendar_view_properties[MAYA_VIEW_CALENDAR_VIEW_HEADER_BAR_PROPERTY]);
	}
}

GDateTime*
maya_view_calendar_view_get_selected_date (MayaViewCalendarView* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_date;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_selected_date (MayaViewCalendarView* self,
                                           GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_calendar_view_get_selected_date (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_selected_date);
		self->priv->_selected_date = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_calendar_view_properties[MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY]);
	}
}

static MayaViewWeekLabels*
maya_view_calendar_view_get_weeks (MayaViewCalendarView* self)
{
	MayaViewWeekLabels* result;
	MayaViewWeekLabels* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_weeks;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_weeks (MayaViewCalendarView* self,
                                   MayaViewWeekLabels* value)
{
	MayaViewWeekLabels* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_weeks);
	self->priv->_weeks = _tmp0_;
}

static MayaViewHeader*
maya_view_calendar_view_get_header (MayaViewCalendarView* self)
{
	MayaViewHeader* result;
	MayaViewHeader* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_header;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_header (MayaViewCalendarView* self,
                                    MayaViewHeader* value)
{
	MayaViewHeader* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_header);
	self->priv->_header = _tmp0_;
}

static MayaViewGrid*
maya_view_calendar_view_get_days_grid (MayaViewCalendarView* self)
{
	MayaViewGrid* result;
	MayaViewGrid* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_days_grid;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_days_grid (MayaViewCalendarView* self,
                                       MayaViewGrid* value)
{
	MayaViewGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_days_grid);
	self->priv->_days_grid = _tmp0_;
}

static GtkStack*
maya_view_calendar_view_get_stack (MayaViewCalendarView* self)
{
	GtkStack* result;
	GtkStack* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stack;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_stack (MayaViewCalendarView* self,
                                   GtkStack* value)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_stack);
	self->priv->_stack = _tmp0_;
}

static GtkLabel*
maya_view_calendar_view_get_spacer (MayaViewCalendarView* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_spacer;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_spacer (MayaViewCalendarView* self,
                                    GtkLabel* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_spacer);
	self->priv->_spacer = _tmp0_;
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		MayaViewCalendarView* self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->calmodel);
		_g_object_unref0 (_data22_->error_bar);
		_g_object_unref0 (_data22_->error_label);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static void
_maya_view_calendar_view_action_export_g_simple_action_activate (GSimpleAction* _sender,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	maya_view_calendar_view_action_export ((MayaViewCalendarView*) self);
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		MayaViewCalendarView* self;
		self = _data23_->_data22_->self;
		_g_object_unref0 (_data23_->contract);
		block22_data_unref (_data23_->_data22_);
		_data23_->_data22_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}

static void
_maya_view_calendar_view______lambda138_ (Block23Data* _data23_)
{
	Block22Data* _data22_;
	MayaViewCalendarView* self;
	gchar* file_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* cal_file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	maya_util_save_temp_selected_calendars ();
	_tmp0_ = g_get_tmp_dir ();
	_tmp1_ = g_strconcat (_tmp0_, "/calendar.ics", NULL);
	file_path = _tmp1_;
	_tmp2_ = file_path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	cal_file = _tmp3_;
	{
		GraniteServicesContract* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = _data23_->contract;
		_tmp5_ = cal_file;
		granite_services_contract_execute_with_file (_tmp4_, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("CalendarView.vala:87: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (cal_file);
		_g_free0 (file_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (cal_file);
	_g_free0 (file_path);
}

static void
__maya_view_calendar_view______lambda138__g_simple_action_activate (GSimpleAction* _sender,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	_maya_view_calendar_view______lambda138_ (self);
}

static void
_maya_view_calendar_view_on_model_parameters_changed_calendar_event_store_parameters_changed (CalendarEventStore* _sender,
                                                                                              gpointer self)
{
	maya_view_calendar_view_on_model_parameters_changed ((MayaViewCalendarView*) self);
}

static void
_maya_view_calendar_view_on_events_added_calendar_event_store_events_added (CalendarEventStore* _sender,
                                                                            ESource* source,
                                                                            GeeCollection* events,
                                                                            gpointer self)
{
	maya_view_calendar_view_on_events_added ((MayaViewCalendarView*) self, source, events);
}

static void
_maya_view_calendar_view_on_events_updated_calendar_event_store_events_updated (CalendarEventStore* _sender,
                                                                                ESource* source,
                                                                                GeeCollection* events,
                                                                                gpointer self)
{
	maya_view_calendar_view_on_events_updated ((MayaViewCalendarView*) self, source, events);
}

static void
_maya_view_calendar_view_on_events_removed_calendar_event_store_events_removed (CalendarEventStore* _sender,
                                                                                ESource* source,
                                                                                GeeCollection* events,
                                                                                gpointer self)
{
	maya_view_calendar_view_on_events_removed ((MayaViewCalendarView*) self, source, events);
}

static void
___lambda173_ (MayaViewCalendarView* self,
               GtkWidget* child)
{
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (child != NULL);
	_tmp0_ = self->priv->_stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	if (child != _tmp2_) {
		gtk_widget_destroy (child);
	}
}

static void
____lambda173__gfunc (gconstpointer data,
                      gpointer self)
{
	___lambda173_ ((MayaViewCalendarView*) self, (GtkWidget*) data);
}

static void
_maya_view_calendar_view___lambda172_ (MayaViewCalendarView* self)
{
	GtkStack* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->_stack;
	_tmp1_ = gtk_stack_get_transition_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == FALSE) {
		GtkStack* _tmp3_;
		GList* _tmp4_;
		GList* _tmp5_;
		_tmp3_ = self->priv->_stack;
		_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
		_tmp5_ = _tmp4_;
		g_list_foreach (_tmp5_, ____lambda173__gfunc, self);
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (g_list_free (_tmp5_), NULL));
	}
}

static void
__maya_view_calendar_view___lambda172__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	_maya_view_calendar_view___lambda172_ ((MayaViewCalendarView*) self);
}

static void
_maya_view_calendar_view_on_show_weeks_changed_g_settings_changed (GSettings* _sender,
                                                                   const gchar* key,
                                                                   gpointer self)
{
	maya_view_calendar_view_on_show_weeks_changed ((MayaViewCalendarView*) self);
}

static void
_maya_view_calendar_view___lambda174_ (Block22Data* _data22_,
                                       gint id)
{
	MayaViewCalendarView* self;
	GtkInfoBar* _tmp0_;
	self = _data22_->self;
	_tmp0_ = _data22_->error_bar;
	gtk_info_bar_set_revealed (_tmp0_, FALSE);
}

static void
__maya_view_calendar_view___lambda174__gtk_info_bar_response (GtkInfoBar* _sender,
                                                              gint response_id,
                                                              gpointer self)
{
	_maya_view_calendar_view___lambda174_ (self, response_id);
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		MayaViewCalendarView* self;
		self = _data24_->_data22_->self;
		_g_free0 (_data24_->message);
		block22_data_unref (_data24_->_data22_);
		_data24_->_data22_ = NULL;
		g_slice_free (Block24Data, _data24_);
	}
}

static gboolean
__lambda176_ (Block24Data* _data24_)
{
	Block22Data* _data22_;
	MayaViewCalendarView* self;
	GtkLabel* _tmp0_;
	GtkInfoBar* _tmp1_;
	gboolean result;
	_data22_ = _data24_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data22_->error_label;
	gtk_label_set_label (_tmp0_, _data24_->message);
	_tmp1_ = _data22_->error_bar;
	gtk_info_bar_set_revealed (_tmp1_, TRUE);
	result = FALSE;
	return result;
}

static gboolean
___lambda176__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda176_ (self);
	return result;
}

static void
_maya_view_calendar_view___lambda175_ (Block22Data* _data22_,
                                       const gchar* message)
{
	MayaViewCalendarView* self;
	Block24Data* _data24_;
	gchar* _tmp0_;
	self = _data22_->self;
	g_return_if_fail (message != NULL);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->_data22_ = block22_data_ref (_data22_);
	_tmp0_ = g_strdup (message);
	_g_free0 (_data24_->message);
	_data24_->message = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda176__gsource_func, block24_data_ref (_data24_), block24_data_unref);
	block24_data_unref (_data24_);
	_data24_ = NULL;
}

static void
__maya_view_calendar_view___lambda175__calendar_event_store_error_received (CalendarEventStore* _sender,
                                                                            const gchar* _error_,
                                                                            gpointer self)
{
	_maya_view_calendar_view___lambda175_ (self, _error_);
}

static void
_maya_view_calendar_view___lambda177_ (MayaViewCalendarView* self)
{
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp1_;
	_tmp0_ = calendar_event_store_get_default ();
	_tmp1_ = _tmp0_;
	calendar_event_store_change_month (_tmp1_, -1);
	_g_object_unref0 (_tmp1_);
}

static void
__maya_view_calendar_view___lambda177__calendar_widgets_date_switcher_left_clicked (CalendarWidgetsDateSwitcher* _sender,
                                                                                    gpointer self)
{
	_maya_view_calendar_view___lambda177_ ((MayaViewCalendarView*) self);
}

static void
_maya_view_calendar_view___lambda178_ (MayaViewCalendarView* self)
{
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp1_;
	_tmp0_ = calendar_event_store_get_default ();
	_tmp1_ = _tmp0_;
	calendar_event_store_change_month (_tmp1_, 1);
	_g_object_unref0 (_tmp1_);
}

static void
__maya_view_calendar_view___lambda178__calendar_widgets_date_switcher_right_clicked (CalendarWidgetsDateSwitcher* _sender,
                                                                                     gpointer self)
{
	_maya_view_calendar_view___lambda178_ ((MayaViewCalendarView*) self);
}

static void
_maya_view_calendar_view___lambda179_ (MayaViewCalendarView* self)
{
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp1_;
	_tmp0_ = calendar_event_store_get_default ();
	_tmp1_ = _tmp0_;
	calendar_event_store_change_year (_tmp1_, -1);
	_g_object_unref0 (_tmp1_);
}

static void
__maya_view_calendar_view___lambda179__calendar_widgets_date_switcher_left_clicked (CalendarWidgetsDateSwitcher* _sender,
                                                                                    gpointer self)
{
	_maya_view_calendar_view___lambda179_ ((MayaViewCalendarView*) self);
}

static void
_maya_view_calendar_view___lambda180_ (MayaViewCalendarView* self)
{
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp1_;
	_tmp0_ = calendar_event_store_get_default ();
	_tmp1_ = _tmp0_;
	calendar_event_store_change_year (_tmp1_, 1);
	_g_object_unref0 (_tmp1_);
}

static void
__maya_view_calendar_view___lambda180__calendar_widgets_date_switcher_right_clicked (CalendarWidgetsDateSwitcher* _sender,
                                                                                     gpointer self)
{
	_maya_view_calendar_view___lambda180_ ((MayaViewCalendarView*) self);
}

static void
_maya_view_calendar_view___lambda181_ (Block22Data* _data22_)
{
	MayaViewCalendarView* self;
	CalendarEventStore* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	self = _data22_->self;
	_tmp0_ = _data22_->calmodel;
	_tmp1_ = calendar_event_store_get_month_start (_tmp0_);
	_tmp2_ = _tmp1_;
	maya_view_calendar_view_set_switcher_date (self, _tmp2_);
}

static void
__maya_view_calendar_view___lambda181__calendar_event_store_parameters_changed (CalendarEventStore* _sender,
                                                                                gpointer self)
{
	_maya_view_calendar_view___lambda181_ (self);
}

static GObject *
maya_view_calendar_view_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewCalendarView * self;
	Block22Data* _data22_;
	GSimpleAction* export_action = NULL;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp2_;
	GSimpleActionGroup* _tmp3_;
	GSimpleAction* _tmp4_;
	GMenu* contractor_menu = NULL;
	GMenu* _tmp5_;
	GMenu* _tmp33_;
	GSimpleActionGroup* _tmp34_;
	GDateTime* _tmp35_;
	GDateTime* _tmp36_;
	GtkLabel* _tmp37_;
	GtkLabel* _tmp38_;
	GtkInfoBar* _tmp39_ = NULL;
	GtkInfoBar* _tmp40_;
	GtkContainer* _tmp41_;
	GtkLabel* _tmp42_;
	CalendarWidgetsConnectivityInfoBar* info_bar = NULL;
	CalendarWidgetsConnectivityInfoBar* _tmp43_;
	GtkApplication* application_instance = NULL;
	GApplication* _tmp44_;
	GtkApplication* _tmp45_;
	GtkButton* button_today = NULL;
	gchar* _tmp46_;
	GtkButton* _tmp47_ = NULL;
	GtkButton* _tmp48_;
	GtkApplication* _tmp49_;
	GtkButton* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar** _tmp53_;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gchar* _tmp56_;
	gchar* _tmp57_;
	CalendarWidgetsDateSwitcher* _tmp58_ = NULL;
	CalendarWidgetsDateSwitcher* _tmp59_ = NULL;
	CalendarEventStore* _tmp60_;
	CalendarEventStore* _tmp61_;
	GDateTime* _tmp62_;
	GDateTime* _tmp63_;
	MayaViewWidgetsDynamicSpinner* spinner = NULL;
	MayaViewWidgetsDynamicSpinner* _tmp64_;
	GtkMenuButton* contractor = NULL;
	GtkImage* _tmp65_;
	GMenu* _tmp66_;
	GtkMenu* _tmp67_;
	gchar* _tmp68_;
	GtkMenuButton* _tmp69_ = NULL;
	CalendarWidgetsSourcePopover* source_popover = NULL;
	CalendarWidgetsSourcePopover* _tmp70_;
	GtkMenuButton* menu_button = NULL;
	GtkImage* _tmp71_;
	CalendarWidgetsSourcePopover* _tmp72_;
	GtkPopover* _tmp73_;
	gchar* _tmp74_;
	GtkMenuButton* _tmp75_ = NULL;
	HdyHeaderBar* _tmp76_ = NULL;
	HdyHeaderBar* _tmp77_;
	HdyHeaderBar* _tmp78_;
	CalendarWidgetsDateSwitcher* _tmp79_;
	HdyHeaderBar* _tmp80_;
	CalendarWidgetsDateSwitcher* _tmp81_;
	HdyHeaderBar* _tmp82_;
	GtkButton* _tmp83_;
	HdyHeaderBar* _tmp84_;
	GtkMenuButton* _tmp85_;
	HdyHeaderBar* _tmp86_;
	GtkMenuButton* _tmp87_;
	HdyHeaderBar* _tmp88_;
	MayaViewWidgetsDynamicSpinner* _tmp89_;
	HdyHeaderBar* _tmp90_;
	GtkStyleContext* _tmp91_;
	GtkStack* _tmp92_;
	GtkStack* _tmp93_;
	GtkStack* _tmp94_;
	CalendarEventStore* model = NULL;
	CalendarEventStore* _tmp95_;
	CalendarEventStore* _tmp96_;
	CalendarEventStore* _tmp97_;
	CalendarEventStore* _tmp98_;
	CalendarEventStore* _tmp99_;
	GtkStack* _tmp100_;
	GSettings* _tmp101_;
	GSettings* _tmp102_;
	GVariant* _tmp103_;
	GVariant* _tmp104_;
	GdkEventMask _tmp105_;
	GdkEventMask _tmp106_;
	GdkEventMask _tmp107_;
	GdkEventMask _tmp108_;
	GdkEventMask _tmp109_;
	GdkEventMask _tmp110_;
	GdkEventMask _tmp111_;
	GdkEventMask _tmp112_;
	GtkStyleContext* _tmp113_;
	HdyHeaderBar* _tmp114_;
	GtkInfoBar* _tmp115_;
	CalendarWidgetsConnectivityInfoBar* _tmp116_;
	GtkStack* _tmp117_;
	GtkInfoBar* _tmp118_;
	CalendarEventStore* _tmp119_;
	CalendarEventStore* _tmp120_;
	CalendarWidgetsDateSwitcher* _tmp121_;
	CalendarWidgetsDateSwitcher* _tmp122_;
	CalendarWidgetsDateSwitcher* _tmp123_;
	CalendarWidgetsDateSwitcher* _tmp124_;
	CalendarEventStore* _tmp125_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (maya_view_calendar_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = g_simple_action_new ("export", NULL);
	export_action = _tmp0_;
	_tmp1_ = export_action;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) _maya_view_calendar_view_action_export_g_simple_action_activate, self, 0);
	_tmp2_ = g_simple_action_group_new ();
	action_group = _tmp2_;
	_tmp3_ = action_group;
	_tmp4_ = export_action;
	g_action_map_add_action ((GActionMap*) _tmp3_, (GAction*) _tmp4_);
	_tmp5_ = g_menu_new ();
	contractor_menu = _tmp5_;
	{
		GeeList* contracts = NULL;
		GeeList* _tmp6_;
		gint i = 0;
		_tmp6_ = granite_services_contractor_proxy_get_contracts_by_mime ("text/calender", &_inner_error0_);
		contracts = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		i = 0;
		{
			GeeList* _contract_list = NULL;
			GeeList* _tmp7_;
			gint _contract_size = 0;
			GeeList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _contract_index = 0;
			_tmp7_ = contracts;
			_contract_list = _tmp7_;
			_tmp8_ = _contract_list;
			_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
			_tmp10_ = _tmp9_;
			_contract_size = _tmp10_;
			_contract_index = -1;
			while (TRUE) {
				Block23Data* _data23_;
				gint _tmp11_;
				gint _tmp12_;
				GeeList* _tmp13_;
				gpointer _tmp14_;
				GSimpleAction* contract_action = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_;
				GSimpleAction* _tmp17_;
				GSimpleAction* _tmp18_;
				GSimpleAction* _tmp19_;
				GSimpleActionGroup* _tmp20_;
				GSimpleAction* _tmp21_;
				GMenu* _tmp22_;
				GraniteServicesContract* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gint _tmp30_;
				_data23_ = g_slice_new0 (Block23Data);
				_data23_->_ref_count_ = 1;
				_data23_->_data22_ = block22_data_ref (_data22_);
				_contract_index = _contract_index + 1;
				_tmp11_ = _contract_index;
				_tmp12_ = _contract_size;
				if (!(_tmp11_ < _tmp12_)) {
					block23_data_unref (_data23_);
					_data23_ = NULL;
					break;
				}
				_tmp13_ = _contract_list;
				_tmp14_ = gee_list_get (_tmp13_, _contract_index);
				_data23_->contract = (GraniteServicesContract*) _tmp14_;
				_tmp15_ = g_strdup_printf ("contract-%i", i);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_simple_action_new (_tmp16_, NULL);
				_tmp18_ = _tmp17_;
				_g_free0 (_tmp16_);
				contract_action = _tmp18_;
				_tmp19_ = contract_action;
				g_signal_connect_data (_tmp19_, "activate", (GCallback) __maya_view_calendar_view______lambda138__g_simple_action_activate, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
				_tmp20_ = action_group;
				_tmp21_ = contract_action;
				g_action_map_add_action ((GActionMap*) _tmp20_, (GAction*) _tmp21_);
				_tmp22_ = contractor_menu;
				_tmp23_ = _data23_->contract;
				_tmp24_ = granite_services_contract_get_display_name (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strdup_printf ("contract-%i", i);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strconcat (MAYA_VIEW_CALENDAR_VIEW_ACTION_PREFIX, _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				g_menu_append (_tmp22_, _tmp25_, _tmp29_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp27_);
				_g_free0 (_tmp25_);
				_tmp30_ = i;
				i = _tmp30_ + 1;
				_g_object_unref0 (contract_action);
				block23_data_unref (_data23_);
				_data23_ = NULL;
			}
		}
		_g_object_unref0 (contracts);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = _error_;
		_tmp32_ = _tmp31_->message;
		g_critical ("CalendarView.vala:100: %s", _tmp32_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (contractor_menu);
		_g_object_unref0 (action_group);
		_g_object_unref0 (export_action);
		block22_data_unref (_data22_);
		_data22_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp33_ = contractor_menu;
	g_menu_append (_tmp33_, _ ("Export Calendar…"), "calendar.export");
	_tmp34_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, MAYA_VIEW_CALENDAR_VIEW_ACTION_GROUP_PREFIX, (GActionGroup*) _tmp34_);
	_tmp35_ = maya_application_get_selected_datetime ();
	_tmp36_ = _tmp35_;
	maya_view_calendar_view_set_selected_date (self, _tmp36_);
	_g_date_time_unref0 (_tmp36_);
	_tmp37_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp37_);
	_data22_->error_label = _tmp37_;
	_tmp38_ = _data22_->error_label;
	gtk_widget_show ((GtkWidget*) _tmp38_);
	_tmp39_ = (GtkInfoBar*) gtk_info_bar_new ();
	gtk_info_bar_set_message_type (_tmp39_, GTK_MESSAGE_ERROR);
	gtk_info_bar_set_revealed (_tmp39_, FALSE);
	gtk_info_bar_set_show_close_button (_tmp39_, TRUE);
	g_object_ref_sink (_tmp39_);
	_data22_->error_bar = _tmp39_;
	_tmp40_ = _data22_->error_bar;
	_tmp41_ = gtk_info_bar_get_content_area (_tmp40_);
	_tmp42_ = _data22_->error_label;
	gtk_container_add (_tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = calendar_widgets_connectivity_info_bar_new ();
	g_object_ref_sink (_tmp43_);
	info_bar = _tmp43_;
	_tmp44_ = g_application_get_default ();
	_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_application_get_type (), GtkApplication));
	application_instance = _tmp45_;
	_tmp46_ = g_strdup (MAYA_MAIN_WINDOW_ACTION_PREFIX MAYA_MAIN_WINDOW_ACTION_SHOW_TODAY);
	_tmp47_ = (GtkButton*) gtk_button_new_from_icon_name ("calendar-go-today", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp47_, _tmp46_);
	_g_free0 (_tmp46_);
	g_object_ref_sink (_tmp47_);
	button_today = _tmp47_;
	_tmp48_ = button_today;
	_tmp49_ = application_instance;
	_tmp50_ = button_today;
	_tmp51_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp54_ = _tmp53_ = gtk_application_get_accels_for_action (_tmp49_, _tmp52_);
	_tmp55_ = _tmp54_;
	_tmp55__length1 = _vala_array_length (_tmp53_);
	_tmp56_ = granite_markup_accel_tooltip (_tmp55_, (gint) _vala_array_length (_tmp53_), _ ("Go to today's date"));
	_tmp57_ = _tmp56_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp48_, _tmp57_);
	_g_free0 (_tmp57_);
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
	_tmp58_ = calendar_widgets_date_switcher_new (10);
	gtk_widget_set_valign ((GtkWidget*) _tmp58_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (self->priv->month_switcher);
	self->priv->month_switcher = _tmp58_;
	_tmp59_ = calendar_widgets_date_switcher_new (-1);
	gtk_widget_set_valign ((GtkWidget*) _tmp59_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->year_switcher);
	self->priv->year_switcher = _tmp59_;
	_tmp60_ = calendar_event_store_get_default ();
	_data22_->calmodel = _tmp60_;
	_tmp61_ = _data22_->calmodel;
	_tmp62_ = calendar_event_store_get_month_start (_tmp61_);
	_tmp63_ = _tmp62_;
	maya_view_calendar_view_set_switcher_date (self, _tmp63_);
	_tmp64_ = maya_view_widgets_dynamic_spinner_new ();
	g_object_ref_sink (_tmp64_);
	spinner = _tmp64_;
	_tmp65_ = (GtkImage*) gtk_image_new_from_icon_name ("document-export", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp65_);
	_tmp66_ = contractor_menu;
	_tmp67_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) _tmp66_);
	g_object_ref_sink (_tmp67_);
	_tmp68_ = g_strdup (_ ("Export or Share the default Calendar"));
	_tmp69_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp69_, (GtkWidget*) _tmp65_);
	_g_object_unref0 (_tmp65_);
	gtk_menu_button_set_popup (_tmp69_, _tmp67_);
	_g_object_unref0 (_tmp67_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp69_, _tmp68_);
	_g_free0 (_tmp68_);
	g_object_ref_sink (_tmp69_);
	contractor = _tmp69_;
	_tmp70_ = calendar_widgets_source_popover_new ();
	g_object_ref_sink (_tmp70_);
	source_popover = _tmp70_;
	_tmp71_ = (GtkImage*) gtk_image_new_from_icon_name ("open-menu", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp71_);
	_tmp72_ = source_popover;
	_tmp73_ = _g_object_ref0 ((GtkPopover*) _tmp72_);
	_tmp74_ = g_strdup (_ ("Manage Calendars"));
	_tmp75_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp75_, (GtkWidget*) _tmp71_);
	_g_object_unref0 (_tmp71_);
	gtk_menu_button_set_popover (_tmp75_, _tmp73_);
	_g_object_unref0 (_tmp73_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp75_, _tmp74_);
	_g_free0 (_tmp74_);
	g_object_ref_sink (_tmp75_);
	menu_button = _tmp75_;
	_tmp76_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_show_close_button (_tmp76_, TRUE);
	g_object_ref_sink (_tmp76_);
	_tmp77_ = _tmp76_;
	maya_view_calendar_view_set_header_bar (self, _tmp77_);
	_g_object_unref0 (_tmp77_);
	_tmp78_ = self->priv->_header_bar;
	_tmp79_ = self->priv->month_switcher;
	hdy_header_bar_pack_start (_tmp78_, (GtkWidget*) _tmp79_);
	_tmp80_ = self->priv->_header_bar;
	_tmp81_ = self->priv->year_switcher;
	hdy_header_bar_pack_start (_tmp80_, (GtkWidget*) _tmp81_);
	_tmp82_ = self->priv->_header_bar;
	_tmp83_ = button_today;
	hdy_header_bar_pack_start (_tmp82_, (GtkWidget*) _tmp83_);
	_tmp84_ = self->priv->_header_bar;
	_tmp85_ = menu_button;
	hdy_header_bar_pack_end (_tmp84_, (GtkWidget*) _tmp85_);
	_tmp86_ = self->priv->_header_bar;
	_tmp87_ = contractor;
	hdy_header_bar_pack_end (_tmp86_, (GtkWidget*) _tmp87_);
	_tmp88_ = self->priv->_header_bar;
	_tmp89_ = spinner;
	hdy_header_bar_pack_end (_tmp88_, (GtkWidget*) _tmp89_);
	_tmp90_ = self->priv->_header_bar;
	_tmp91_ = gtk_widget_get_style_context ((GtkWidget*) _tmp90_);
	gtk_style_context_add_class (_tmp91_, GTK_STYLE_CLASS_FLAT);
	_tmp92_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp92_);
	_tmp93_ = _tmp92_;
	maya_view_calendar_view_set_stack (self, _tmp93_);
	_g_object_unref0 (_tmp93_);
	_tmp94_ = self->priv->_stack;
	g_object_set ((GtkWidget*) _tmp94_, "expand", TRUE, NULL);
	maya_view_calendar_view_sync_with_model (self);
	_tmp95_ = calendar_event_store_get_default ();
	model = _tmp95_;
	_tmp96_ = model;
	g_signal_connect_object (_tmp96_, "parameters-changed", (GCallback) _maya_view_calendar_view_on_model_parameters_changed_calendar_event_store_parameters_changed, self, 0);
	_tmp97_ = model;
	g_signal_connect_object (_tmp97_, "events-added", (GCallback) _maya_view_calendar_view_on_events_added_calendar_event_store_events_added, self, 0);
	_tmp98_ = model;
	g_signal_connect_object (_tmp98_, "events-updated", (GCallback) _maya_view_calendar_view_on_events_updated_calendar_event_store_events_updated, self, 0);
	_tmp99_ = model;
	g_signal_connect_object (_tmp99_, "events-removed", (GCallback) _maya_view_calendar_view_on_events_removed_calendar_event_store_events_removed, self, 0);
	_tmp100_ = self->priv->_stack;
	g_signal_connect_object ((GObject*) _tmp100_, "notify::transition-running", (GCallback) __maya_view_calendar_view___lambda172__g_object_notify, self, 0);
	_tmp101_ = maya_view_calendar_view_show_weeks;
	g_signal_connect_object (_tmp101_, "changed::show-weeks", (GCallback) _maya_view_calendar_view_on_show_weeks_changed_g_settings_changed, self, 0);
	_tmp102_ = maya_view_calendar_view_show_weeks;
	_tmp103_ = g_settings_get_value (_tmp102_, "show-weeks");
	_tmp104_ = _tmp103_;
	_g_variant_unref0 (_tmp104_);
	_tmp105_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp106_ = _tmp105_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp106_ | GDK_BUTTON_PRESS_MASK);
	_tmp107_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp108_ = _tmp107_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp108_ | GDK_KEY_PRESS_MASK);
	_tmp109_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp110_ = _tmp109_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp110_ | GDK_SCROLL_MASK);
	_tmp111_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp112_ = _tmp111_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp112_ | GDK_SMOOTH_SCROLL_MASK);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp113_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp113_, GTK_STYLE_CLASS_VIEW);
	_tmp114_ = self->priv->_header_bar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp114_);
	_tmp115_ = _data22_->error_bar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp115_);
	_tmp116_ = info_bar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp116_);
	_tmp117_ = self->priv->_stack;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp117_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp118_ = _data22_->error_bar;
	g_signal_connect_data (_tmp118_, "response", (GCallback) __maya_view_calendar_view___lambda174__gtk_info_bar_response, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	_tmp119_ = calendar_event_store_get_default ();
	_tmp120_ = _tmp119_;
	g_signal_connect_data (_tmp120_, "error-received", (GCallback) __maya_view_calendar_view___lambda175__calendar_event_store_error_received, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	_g_object_unref0 (_tmp120_);
	_tmp121_ = self->priv->month_switcher;
	g_signal_connect_object (_tmp121_, "left-clicked", (GCallback) __maya_view_calendar_view___lambda177__calendar_widgets_date_switcher_left_clicked, self, 0);
	_tmp122_ = self->priv->month_switcher;
	g_signal_connect_object (_tmp122_, "right-clicked", (GCallback) __maya_view_calendar_view___lambda178__calendar_widgets_date_switcher_right_clicked, self, 0);
	_tmp123_ = self->priv->year_switcher;
	g_signal_connect_object (_tmp123_, "left-clicked", (GCallback) __maya_view_calendar_view___lambda179__calendar_widgets_date_switcher_left_clicked, self, 0);
	_tmp124_ = self->priv->year_switcher;
	g_signal_connect_object (_tmp124_, "right-clicked", (GCallback) __maya_view_calendar_view___lambda180__calendar_widgets_date_switcher_right_clicked, self, 0);
	_tmp125_ = _data22_->calmodel;
	g_signal_connect_data (_tmp125_, "parameters-changed", (GCallback) __maya_view_calendar_view___lambda181__calendar_event_store_parameters_changed, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	_g_object_unref0 (model);
	_g_object_unref0 (menu_button);
	_g_object_unref0 (source_popover);
	_g_object_unref0 (contractor);
	_g_object_unref0 (spinner);
	_g_object_unref0 (button_today);
	_g_object_unref0 (application_instance);
	_g_object_unref0 (info_bar);
	_g_object_unref0 (contractor_menu);
	_g_object_unref0 (action_group);
	_g_object_unref0 (export_action);
	block22_data_unref (_data22_);
	_data22_ = NULL;
	return obj;
}

static void
maya_view_calendar_view_class_init (MayaViewCalendarViewClass * klass,
                                    gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GSettings* _tmp2_;
	maya_view_calendar_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewCalendarView_private_offset);
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) maya_view_calendar_view_real_scroll_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_maya_view_calendar_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_maya_view_calendar_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = maya_view_calendar_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_calendar_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_CALENDAR_VIEW_HEADER_BAR_PROPERTY, maya_view_calendar_view_properties[MAYA_VIEW_CALENDAR_VIEW_HEADER_BAR_PROPERTY] = g_param_spec_object ("header-bar", "header-bar", "header-bar", hdy_header_bar_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY, maya_view_calendar_view_properties[MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY] = g_param_spec_boxed ("selected-date", "selected-date", "selected-date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	maya_view_calendar_view_signals[MAYA_VIEW_CALENDAR_VIEW_ON_EVENT_ADD_SIGNAL] = g_signal_new ("on-event-add", MAYA_VIEW_TYPE_CALENDAR_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_DATE_TIME);
	maya_view_calendar_view_signals[MAYA_VIEW_CALENDAR_VIEW_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", MAYA_VIEW_TYPE_CALENDAR_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_DATE_TIME);
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (maya_view_calendar_view_style_provider);
	maya_view_calendar_view_style_provider = _tmp0_;
	_tmp1_ = maya_view_calendar_view_style_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/calendar/WeekLabels.css");
	_tmp2_ = maya_application_wingpanel_settings;
	if (_tmp2_ != NULL) {
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		_tmp3_ = maya_application_wingpanel_settings;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (maya_view_calendar_view_show_weeks);
		maya_view_calendar_view_show_weeks = _tmp4_;
	} else {
		GSettings* _tmp5_;
		GSettings* _tmp6_;
		_tmp5_ = maya_application_saved_state;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (maya_view_calendar_view_show_weeks);
		maya_view_calendar_view_show_weeks = _tmp6_;
	}
}

static void
maya_view_calendar_view_instance_init (MayaViewCalendarView * self,
                                       gpointer klass)
{
	self->priv = maya_view_calendar_view_get_instance_private (self);
}

static void
maya_view_calendar_view_finalize (GObject * obj)
{
	MayaViewCalendarView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView);
	_g_object_unref0 (self->search_bar);
	_g_object_unref0 (self->priv->month_switcher);
	_g_object_unref0 (self->priv->year_switcher);
	_g_object_unref0 (self->priv->_header_bar);
	_g_date_time_unref0 (self->priv->_selected_date);
	_g_object_unref0 (self->priv->_weeks);
	_g_object_unref0 (self->priv->_header);
	_g_object_unref0 (self->priv->_days_grid);
	_g_object_unref0 (self->priv->_stack);
	_g_object_unref0 (self->priv->_spacer);
	G_OBJECT_CLASS (maya_view_calendar_view_parent_class)->finalize (obj);
}

/**
 * Represents the entire calendar, including the headers, the week labels and the grid.
 */
static GType
maya_view_calendar_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewCalendarViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_calendar_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewCalendarView), 0, (GInstanceInitFunc) maya_view_calendar_view_instance_init, NULL };
	GType maya_view_calendar_view_type_id;
	maya_view_calendar_view_type_id = g_type_register_static (gtk_box_get_type (), "MayaViewCalendarView", &g_define_type_info, 0);
	MayaViewCalendarView_private_offset = g_type_add_instance_private (maya_view_calendar_view_type_id, sizeof (MayaViewCalendarViewPrivate));
	return maya_view_calendar_view_type_id;
}

GType
maya_view_calendar_view_get_type (void)
{
	static volatile gsize maya_view_calendar_view_type_id__once = 0;
	if (g_once_init_enter (&maya_view_calendar_view_type_id__once)) {
		GType maya_view_calendar_view_type_id;
		maya_view_calendar_view_type_id = maya_view_calendar_view_get_type_once ();
		g_once_init_leave (&maya_view_calendar_view_type_id__once, maya_view_calendar_view_type_id);
	}
	return maya_view_calendar_view_type_id__once;
}

static void
_vala_maya_view_calendar_view_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	MayaViewCalendarView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView);
	switch (property_id) {
		case MAYA_VIEW_CALENDAR_VIEW_HEADER_BAR_PROPERTY:
		g_value_set_object (value, maya_view_calendar_view_get_header_bar (self));
		break;
		case MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY:
		g_value_set_boxed (value, maya_view_calendar_view_get_selected_date (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_maya_view_calendar_view_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	MayaViewCalendarView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView);
	switch (property_id) {
		case MAYA_VIEW_CALENDAR_VIEW_HEADER_BAR_PROPERTY:
		maya_view_calendar_view_set_header_bar (self, g_value_get_object (value));
		break;
		case MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY:
		maya_view_calendar_view_set_selected_date (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

