// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/data"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolProfile = sync.Pool{
		New: func() any {
			return &otlpprofiles.Profile{}
		},
	}
)

func NewOrigProfile() *otlpprofiles.Profile {
	if !UseProtoPooling.IsEnabled() {
		return &otlpprofiles.Profile{}
	}
	return protoPoolProfile.Get().(*otlpprofiles.Profile)
}

func DeleteOrigProfile(orig *otlpprofiles.Profile, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteOrigValueType(&orig.SampleType, false)
	for i := range orig.Sample {
		DeleteOrigSample(orig.Sample[i], true)
	}
	DeleteOrigValueType(&orig.PeriodType, false)
	DeleteOrigProfileID(&orig.ProfileId, false)

	orig.Reset()
	if nullable {
		protoPoolProfile.Put(orig)
	}
}

func CopyOrigProfile(dest, src *otlpprofiles.Profile) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	CopyOrigValueType(&dest.SampleType, &src.SampleType)
	dest.Sample = CopyOrigSampleSlice(dest.Sample, src.Sample)
	dest.TimeUnixNano = src.TimeUnixNano
	dest.DurationNano = src.DurationNano
	CopyOrigValueType(&dest.PeriodType, &src.PeriodType)
	dest.Period = src.Period
	dest.CommentStrindices = CopyOrigInt32Slice(dest.CommentStrindices, src.CommentStrindices)
	dest.ProfileId = src.ProfileId
	dest.DroppedAttributesCount = src.DroppedAttributesCount
	dest.OriginalPayloadFormat = src.OriginalPayloadFormat
	dest.OriginalPayload = CopyOrigByteSlice(dest.OriginalPayload, src.OriginalPayload)
	dest.AttributeIndices = CopyOrigInt32Slice(dest.AttributeIndices, src.AttributeIndices)
}

func GenTestOrigProfile() *otlpprofiles.Profile {
	orig := NewOrigProfile()
	orig.SampleType = *GenTestOrigValueType()
	orig.Sample = GenerateOrigTestSampleSlice()
	orig.TimeUnixNano = 1234567890
	orig.DurationNano = 1234567890
	orig.PeriodType = *GenTestOrigValueType()
	orig.Period = int64(13)
	orig.CommentStrindices = GenerateOrigTestInt32Slice()
	orig.ProfileId = data.ProfileID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	orig.DroppedAttributesCount = uint32(13)
	orig.OriginalPayloadFormat = "test_originalpayloadformat"
	orig.OriginalPayload = GenerateOrigTestByteSlice()
	orig.AttributeIndices = GenerateOrigTestInt32Slice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigProfile(orig *otlpprofiles.Profile, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("sampleType")
	MarshalJSONOrigValueType(&orig.SampleType, dest)
	if len(orig.Sample) > 0 {
		dest.WriteObjectField("sample")
		dest.WriteArrayStart()
		MarshalJSONOrigSample(orig.Sample[0], dest)
		for i := 1; i < len(orig.Sample); i++ {
			dest.WriteMore()
			MarshalJSONOrigSample(orig.Sample[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.DurationNano != uint64(0) {
		dest.WriteObjectField("durationNano")
		dest.WriteUint64(orig.DurationNano)
	}
	dest.WriteObjectField("periodType")
	MarshalJSONOrigValueType(&orig.PeriodType, dest)
	if orig.Period != int64(0) {
		dest.WriteObjectField("period")
		dest.WriteInt64(orig.Period)
	}
	if len(orig.CommentStrindices) > 0 {
		dest.WriteObjectField("commentStrindices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.CommentStrindices[0])
		for i := 1; i < len(orig.CommentStrindices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.CommentStrindices[i])
		}
		dest.WriteArrayEnd()
	}
	if orig.ProfileId != data.ProfileID([16]byte{}) {
		dest.WriteObjectField("profileId")
		MarshalJSONOrigProfileID(&orig.ProfileId, dest)
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	if orig.OriginalPayloadFormat != "" {
		dest.WriteObjectField("originalPayloadFormat")
		dest.WriteString(orig.OriginalPayloadFormat)
	}

	if len(orig.OriginalPayload) > 0 {
		dest.WriteObjectField("originalPayload")
		dest.WriteBytes(orig.OriginalPayload)
	}
	if len(orig.AttributeIndices) > 0 {
		dest.WriteObjectField("attributeIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.AttributeIndices[0])
		for i := 1; i < len(orig.AttributeIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.AttributeIndices[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigProfile unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigProfile(orig *otlpprofiles.Profile, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "sampleType", "sample_type":
			UnmarshalJSONOrigValueType(&orig.SampleType, iter)
		case "sample":
			for iter.ReadArray() {
				orig.Sample = append(orig.Sample, NewOrigSample())
				UnmarshalJSONOrigSample(orig.Sample[len(orig.Sample)-1], iter)
			}

		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "durationNano", "duration_nano":
			orig.DurationNano = iter.ReadUint64()
		case "periodType", "period_type":
			UnmarshalJSONOrigValueType(&orig.PeriodType, iter)
		case "period":
			orig.Period = iter.ReadInt64()
		case "commentStrindices", "comment_strindices":
			for iter.ReadArray() {
				orig.CommentStrindices = append(orig.CommentStrindices, iter.ReadInt32())
			}

		case "profileId", "profile_id":
			UnmarshalJSONOrigProfileID(&orig.ProfileId, iter)
		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		case "originalPayloadFormat", "original_payload_format":
			orig.OriginalPayloadFormat = iter.ReadString()
		case "originalPayload", "original_payload":
			orig.OriginalPayload = iter.ReadBytes()
		case "attributeIndices", "attribute_indices":
			for iter.ReadArray() {
				orig.AttributeIndices = append(orig.AttributeIndices, iter.ReadInt32())
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigProfile(orig *otlpprofiles.Profile) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigValueType(&orig.SampleType)
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.Sample {
		l = SizeProtoOrigSample(orig.Sample[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	if orig.DurationNano != 0 {
		n += 1 + proto.Sov(uint64(orig.DurationNano))
	}
	l = SizeProtoOrigValueType(&orig.PeriodType)
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.Period != 0 {
		n += 1 + proto.Sov(uint64(orig.Period))
	}
	if len(orig.CommentStrindices) > 0 {
		l = 0
		for _, e := range orig.CommentStrindices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = SizeProtoOrigProfileID(&orig.ProfileId)
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.DroppedAttributesCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	l = len(orig.OriginalPayloadFormat)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.OriginalPayload)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if len(orig.AttributeIndices) > 0 {
		l = 0
		for _, e := range orig.AttributeIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigProfile(orig *otlpprofiles.Profile, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigValueType(&orig.SampleType, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.Sample) - 1; i >= 0; i-- {
		l = MarshalProtoOrigSample(orig.Sample[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	if orig.DurationNano != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DurationNano))
		pos--
		buf[pos] = 0x20
	}

	l = MarshalProtoOrigValueType(&orig.PeriodType, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x2a

	if orig.Period != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Period))
		pos--
		buf[pos] = 0x30
	}
	l = len(orig.CommentStrindices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.CommentStrindices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x3a
	}

	l = MarshalProtoOrigProfileID(&orig.ProfileId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x42

	if orig.DroppedAttributesCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x48
	}
	l = len(orig.OriginalPayloadFormat)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.OriginalPayloadFormat)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x52
	}
	l = len(orig.OriginalPayload)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.OriginalPayload)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x5a
	}
	l = len(orig.AttributeIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x62
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigProfile(orig *otlpprofiles.Profile, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleType", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigValueType(&orig.SampleType, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Sample", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Sample = append(orig.Sample, NewOrigSample())
			err = UnmarshalProtoOrigSample(orig.Sample[len(orig.Sample)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 4:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DurationNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.DurationNano = uint64(num)

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field PeriodType", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigValueType(&orig.PeriodType, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 6:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Period", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Period = int64(num)
		case 7:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.CommentStrindices = append(orig.CommentStrindices, int32(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field CommentStrindices", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.CommentStrindices = append(orig.CommentStrindices, int32(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field CommentStrindices", wireType)
			}

		case 8:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ProfileId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigProfileID(&orig.ProfileId, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 9:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.DroppedAttributesCount = uint32(num)

		case 10:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPayloadFormat", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.OriginalPayloadFormat = string(buf[startPos:pos])

		case 11:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPayload", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			if length != 0 {
				orig.OriginalPayload = make([]byte, length)
				copy(orig.OriginalPayload, buf[startPos:pos])
			}
		case 12:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field AttributeIndices", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
