// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolLocation = sync.Pool{
		New: func() any {
			return &otlpprofiles.Location{}
		},
	}
)

func NewOrigLocation() *otlpprofiles.Location {
	if !UseProtoPooling.IsEnabled() {
		return &otlpprofiles.Location{}
	}
	return protoPoolLocation.Get().(*otlpprofiles.Location)
}

func DeleteOrigLocation(orig *otlpprofiles.Location, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.Line {
		DeleteOrigLine(orig.Line[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolLocation.Put(orig)
	}
}

func CopyOrigLocation(dest, src *otlpprofiles.Location) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.MappingIndex = src.MappingIndex
	dest.Address = src.Address
	dest.Line = CopyOrigLineSlice(dest.Line, src.Line)
	dest.AttributeIndices = CopyOrigInt32Slice(dest.AttributeIndices, src.AttributeIndices)
}

func GenTestOrigLocation() *otlpprofiles.Location {
	orig := NewOrigLocation()
	orig.MappingIndex = int32(13)
	orig.Address = uint64(13)
	orig.Line = GenerateOrigTestLineSlice()
	orig.AttributeIndices = GenerateOrigTestInt32Slice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigLocation(orig *otlpprofiles.Location, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.MappingIndex != int32(0) {
		dest.WriteObjectField("mappingIndex")
		dest.WriteInt32(orig.MappingIndex)
	}
	if orig.Address != uint64(0) {
		dest.WriteObjectField("address")
		dest.WriteUint64(orig.Address)
	}
	if len(orig.Line) > 0 {
		dest.WriteObjectField("line")
		dest.WriteArrayStart()
		MarshalJSONOrigLine(orig.Line[0], dest)
		for i := 1; i < len(orig.Line); i++ {
			dest.WriteMore()
			MarshalJSONOrigLine(orig.Line[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.AttributeIndices) > 0 {
		dest.WriteObjectField("attributeIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.AttributeIndices[0])
		for i := 1; i < len(orig.AttributeIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.AttributeIndices[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigLocation unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigLocation(orig *otlpprofiles.Location, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "mappingIndex", "mapping_index":
			orig.MappingIndex = iter.ReadInt32()
		case "address":
			orig.Address = iter.ReadUint64()
		case "line":
			for iter.ReadArray() {
				orig.Line = append(orig.Line, NewOrigLine())
				UnmarshalJSONOrigLine(orig.Line[len(orig.Line)-1], iter)
			}

		case "attributeIndices", "attribute_indices":
			for iter.ReadArray() {
				orig.AttributeIndices = append(orig.AttributeIndices, iter.ReadInt32())
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigLocation(orig *otlpprofiles.Location) int {
	var n int
	var l int
	_ = l
	if orig.MappingIndex != 0 {
		n += 1 + proto.Sov(uint64(orig.MappingIndex))
	}
	if orig.Address != 0 {
		n += 1 + proto.Sov(uint64(orig.Address))
	}
	for i := range orig.Line {
		l = SizeProtoOrigLine(orig.Line[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if len(orig.AttributeIndices) > 0 {
		l = 0
		for _, e := range orig.AttributeIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigLocation(orig *otlpprofiles.Location, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.MappingIndex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.MappingIndex))
		pos--
		buf[pos] = 0x8
	}
	if orig.Address != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Address))
		pos--
		buf[pos] = 0x10
	}
	for i := len(orig.Line) - 1; i >= 0; i-- {
		l = MarshalProtoOrigLine(orig.Line[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	l = len(orig.AttributeIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x22
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigLocation(orig *otlpprofiles.Location, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field MappingIndex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.MappingIndex = int32(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Address = uint64(num)

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Line", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Line = append(orig.Line, NewOrigLine())
			err = UnmarshalProtoOrigLine(orig.Line[len(orig.Line)-1], buf[startPos:pos])
			if err != nil {
				return err
			}
		case 4:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field AttributeIndices", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
