/*
  SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "textautogeneratedialog.h"

#include "textautogeneratestackwidget.h"

#include <KConfigGroup>
#include <KLocalizedString>
#include <KSharedConfig>
#include <KWindowConfig>
#include <QDialogButtonBox>
#include <QVBoxLayout>
#include <QWindow>

namespace
{
const char myTextAutoGenerateDialogGroupName[] = "TextAutoGenerateDialog";
}
using namespace TextAutoGenerateText;
using namespace Qt::Literals::StringLiterals;
TextAutoGenerateDialog::TextAutoGenerateDialog(QWidget *parent)
    : TextAutoGenerateDialog(new TextAutoGenerateText::TextAutoGenerateManager(parent), parent)
{
}

TextAutoGenerateDialog::TextAutoGenerateDialog(TextAutoGenerateText::TextAutoGenerateManager *manager, QWidget *parent)
    : QDialog(parent)
    , mTextAutoGenerateManager(manager)
    , mTextAutoGenerateWidget(new TextAutoGenerateStackWidget(mTextAutoGenerateManager, this))
{
    setWindowTitle(i18nc("@title:window", "Conversation"));

    auto mainLayout = new QVBoxLayout(this);
    mainLayout->setObjectName(u"mainLayout"_s);

    mTextAutoGenerateWidget->setObjectName(u"mTextAutoGenerateWidget"_s);
    mainLayout->addWidget(mTextAutoGenerateWidget);

    auto button = new QDialogButtonBox(QDialogButtonBox::Close, this);
    button->setObjectName(u"button"_s);
    mainLayout->addWidget(button);
    connect(button, &QDialogButtonBox::rejected, this, &TextAutoGenerateDialog::reject);
    readConfig();
}

TextAutoGenerateDialog::~TextAutoGenerateDialog()
{
    writeConfig();
}

void TextAutoGenerateDialog::readConfig()
{
    create(); // ensure a window is created
    windowHandle()->resize(QSize(400, 300));
    const KConfigGroup group(KSharedConfig::openStateConfig(), QLatin1StringView(myTextAutoGenerateDialogGroupName));
    KWindowConfig::restoreWindowSize(windowHandle(), group);
    resize(windowHandle()->size()); // workaround for QTBUG-40584
}

void TextAutoGenerateDialog::writeConfig()
{
    KConfigGroup group(KSharedConfig::openStateConfig(), QLatin1StringView(myTextAutoGenerateDialogGroupName));
    KWindowConfig::saveWindowSize(windowHandle(), group);
}

void TextAutoGenerateDialog::ask(const TextAutoGenerateText::TextAutoGenerateManager::AskMessageInfo &info)
{
    mTextAutoGenerateManager->ask(info);
}

#include "moc_textautogeneratedialog.cpp"
