
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kformat_wrapper.h"

// Argument includes
#include <QString>
#include <kformat.h>
#include <qdatetime.h>
#include <qlocale.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KFormat_Type = nullptr;
static PyTypeObject *Sbk_KFormat_TypeF(void)
{
    return _Sbk_KFormat_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KFormat >()))
        return -1;

    ::KFormat *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    if (PyArg_ParseTuple(args, "|O:KFormat", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KFormat::KFormat(KFormat)
    // 1: KFormat::KFormat(const QLocale&=)
    if (numArgs == 0) {
        overloadId = 1; // KFormat(QLocale)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KFormat(QLocale)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KFormat(KFormat)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KFormat(const KFormat &other)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KFormat cppArg0_local;
            ::KFormat *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // KFormat(KFormat)
                cptr = new ::KFormat(*cppArg0);
            }
            break;
        }
        case 1: // KFormat(const QLocale &locale)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"locale", 0}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QLocale cppArg0_local = QLocale();
            ::QLocale *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0]) {
                if (pythonToCpp[0].isValue())
                    pythonToCpp[0](pyArgs[0], &cppArg0_local);
                else
                    pythonToCpp[0](pyArgs[0], &cppArg0);
                }

            if (Shiboken::Errors::occurred() == nullptr) {
                // KFormat(QLocale)
                cptr = new ::KFormat(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KFormat >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KFormatFunc_formatByteSize(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFormat *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "formatByteSize", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:formatByteSize", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KFormat::formatByteSize(double,int=,KFormat::BinaryUnitDialect=,KFormat::BinarySizeUnits=)const->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // formatByteSize(double,int,KFormat::BinaryUnitDialect,KFormat::BinarySizeUnits)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // formatByteSize(double,int,KFormat::BinaryUnitDialect,KFormat::BinarySizeUnits)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_BinaryUnitDialect_IDX])))->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // formatByteSize(double,int,KFormat::BinaryUnitDialect,KFormat::BinarySizeUnits)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_BinarySizeUnits_IDX])))->converter, (pyArgs[3])))) {
                    overloadId = 0; // formatByteSize(double,int,KFormat::BinaryUnitDialect,KFormat::BinarySizeUnits)const
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "formatByteSize", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"precision", 1}, {"dialect", 2}, {"units", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_BinaryUnitDialect_IDX])))->converter, (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_BinarySizeUnits_IDX])))->converter, (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "formatByteSize", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);
            }
        }
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 1;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::KFormat::BinaryUnitDialect cppArg2(KFormat::DefaultBinaryDialect);
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::KFormat::BinarySizeUnits cppArg3(KFormat::DefaultBinaryUnits);
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // formatByteSize(double,int,KFormat::BinaryUnitDialect,KFormat::BinarySizeUnits)const
            QString cppResult = const_cast<const ::KFormat *>(cppSelf)->formatByteSize(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFormatFunc_formatDecimalDuration(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFormat *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "formatDecimalDuration", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    if (PyArg_ParseTuple(args, "|OO:formatDecimalDuration", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KFormat::formatDecimalDuration(quint64,int=)const->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // formatDecimalDuration(quint64,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // formatDecimalDuration(quint64,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "formatDecimalDuration", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"decimalPlaces", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "formatDecimalDuration", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);
            }
        }
        quint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 2;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // formatDecimalDuration(quint64,int)const
            QString cppResult = const_cast<const ::KFormat *>(cppSelf)->formatDecimalDuration(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFormatFunc_formatDistance(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFormat *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "formatDistance", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    if (PyArg_ParseTuple(args, "|OO:formatDistance", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KFormat::formatDistance(double,QFlags<KFormat::DistanceFormatOption>=)const->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // formatDistance(double,QFlags<KFormat::DistanceFormatOption>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KFormat_DistanceFormatOption_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 0; // formatDistance(double,QFlags<KFormat::DistanceFormatOption>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "formatDistance", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"arg__2", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KFormat_DistanceFormatOption_IDX])))->flagsConverter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "formatDistance", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);
            }
        }
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<KFormat::DistanceFormatOption> cppArg1(KFormat::DistanceFormatOption::LocaleDistanceUnits);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // formatDistance(double,QFlags<KFormat::DistanceFormatOption>)const
            QString cppResult = const_cast<const ::KFormat *>(cppSelf)->formatDistance(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFormatFunc_formatDuration(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFormat *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "formatDuration", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    if (PyArg_ParseTuple(args, "|OO:formatDuration", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KFormat::formatDuration(quint64,QFlags<KFormat::DurationFormatOption>=)const->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // formatDuration(quint64,QFlags<KFormat::DurationFormatOption>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KFormat_DurationFormatOption_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 0; // formatDuration(quint64,QFlags<KFormat::DurationFormatOption>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "formatDuration", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"options", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KFormat_DurationFormatOption_IDX])))->flagsConverter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "formatDuration", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);
            }
        }
        quint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<KFormat::DurationFormatOption> cppArg1(KFormat::DefaultDuration);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // formatDuration(quint64,QFlags<KFormat::DurationFormatOption>)const
            QString cppResult = const_cast<const ::KFormat *>(cppSelf)->formatDuration(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFormatFunc_formatRelativeDate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFormat *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "formatRelativeDate", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KFormat::formatRelativeDate(QDate,QLocale::FormatType)const->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_FormatType_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // formatRelativeDate(QDate,QLocale::FormatType)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "formatRelativeDate", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QLocale::FormatType cppArg1{QLocale::LongFormat};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // formatRelativeDate(QDate,QLocale::FormatType)const
            QString cppResult = const_cast<const ::KFormat *>(cppSelf)->formatRelativeDate(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFormatFunc_formatRelativeDateTime(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFormat *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "formatRelativeDateTime", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KFormat::formatRelativeDateTime(QDateTime,QLocale::FormatType)const->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_FormatType_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // formatRelativeDateTime(QDateTime,QLocale::FormatType)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "formatRelativeDateTime", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QLocale::FormatType cppArg1{QLocale::LongFormat};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // formatRelativeDateTime(QDateTime,QLocale::FormatType)const
            QString cppResult = const_cast<const ::KFormat *>(cppSelf)->formatRelativeDateTime(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFormatFunc_formatSpelloutDuration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFormat *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KFormat::formatSpelloutDuration(quint64)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyArg)))) {
        overloadId = 0; // formatSpelloutDuration(quint64)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "formatSpelloutDuration", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    // Call function/method
    {
        quint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // formatSpelloutDuration(quint64)const
            QString cppResult = const_cast<const ::KFormat *>(cppSelf)->formatSpelloutDuration(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFormatFunc_formatTime(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFormat *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "formatTime", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KFormat::formatTime(QDateTime,QLocale::FormatType)const->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_FormatType_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // formatTime(QDateTime,QLocale::FormatType)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "formatTime", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QLocale::FormatType cppArg1{QLocale::LongFormat};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // formatTime(QDateTime,QLocale::FormatType)const
            QString cppResult = const_cast<const ::KFormat *>(cppSelf)->formatTime(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFormatFunc_formatValue(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFormat *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "formatValue", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:formatValue", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KFormat::formatValue(double,KFormat::Unit,int=,KFormat::UnitPrefix=,KFormat::BinaryUnitDialect=)const->QString
    // 1: KFormat::formatValue(double,QString,int=,KFormat::UnitPrefix=)const->QString
    // 2: KFormat::formatValue(double,QString,int,KFormat::UnitPrefix,KFormat::BinaryUnitDialect)const->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // formatValue(double,QString,int,KFormat::UnitPrefix)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // formatValue(double,QString,int,KFormat::UnitPrefix)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_UnitPrefix_IDX])))->converter, (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 1; // formatValue(double,QString,int,KFormat::UnitPrefix)const
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_BinaryUnitDialect_IDX])))->converter, (pyArgs[4])))) {
                        overloadId = 2; // formatValue(double,QString,int,KFormat::UnitPrefix,KFormat::BinaryUnitDialect)const
                    }
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_Unit_IDX])))->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // formatValue(double,KFormat::Unit,int,KFormat::UnitPrefix,KFormat::BinaryUnitDialect)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // formatValue(double,KFormat::Unit,int,KFormat::UnitPrefix,KFormat::BinaryUnitDialect)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_UnitPrefix_IDX])))->converter, (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // formatValue(double,KFormat::Unit,int,KFormat::UnitPrefix,KFormat::BinaryUnitDialect)const
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_BinaryUnitDialect_IDX])))->converter, (pyArgs[4])))) {
                        overloadId = 0; // formatValue(double,KFormat::Unit,int,KFormat::UnitPrefix,KFormat::BinaryUnitDialect)const
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "formatValue", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // formatValue(double value, KFormat::Unit unit, int precision, KFormat::UnitPrefix prefix, KFormat::BinaryUnitDialect dialect) const
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"precision", 2}, {"prefix", 3}, {"dialect", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_UnitPrefix_IDX])))->converter, (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_BinaryUnitDialect_IDX])))->converter, (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "formatValue", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);
                }
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::KFormat::Unit cppArg1{KFormat::Unit::Other};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 1;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::KFormat::UnitPrefix cppArg3(KFormat::UnitPrefix::AutoAdjust);
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            ::KFormat::BinaryUnitDialect cppArg4(KFormat::DefaultBinaryDialect);
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // formatValue(double,KFormat::Unit,int,KFormat::UnitPrefix,KFormat::BinaryUnitDialect)const
                QString cppResult = const_cast<const ::KFormat *>(cppSelf)->formatValue(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 1: // formatValue(double value, const QString &unit, int precision, KFormat::UnitPrefix prefix) const
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"precision", 2}, {"prefix", 3}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_UnitPrefix_IDX])))->converter, (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "formatValue", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);
                }
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 1;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::KFormat::UnitPrefix cppArg3(KFormat::UnitPrefix::AutoAdjust);
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // formatValue(double,QString,int,KFormat::UnitPrefix)const
                QString cppResult = const_cast<const ::KFormat *>(cppSelf)->formatValue(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 2: // formatValue(double value, const QString &unit, int precision, KFormat::UnitPrefix prefix, KFormat::BinaryUnitDialect dialect) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "formatValue", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]);
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::KFormat::UnitPrefix cppArg3{KFormat::UnitPrefix::Yocto};
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::KFormat::BinaryUnitDialect cppArg4{KFormat::IECBinaryDialect};
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // formatValue(double,QString,int,KFormat::UnitPrefix,KFormat::BinaryUnitDialect)const
                QString cppResult = const_cast<const ::KFormat *>(cppSelf)->formatValue(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFormat__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KFormat *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KFormat_EnumFlagInfo[] = {
    "BinarySizeUnits:IntEnum",
    "BinaryUnitDialect:IntEnum",
    "DistanceFormatOption:IntFlag:DistanceFormatOptions",
    "DurationFormatOption:IntFlag:DurationFormatOptions",
    "Unit:IntEnum",
    "UnitPrefix:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KFormat_methods[] = {
    {"formatByteSize", reinterpret_cast<PyCFunction>(Sbk_KFormatFunc_formatByteSize), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"formatDecimalDuration", reinterpret_cast<PyCFunction>(Sbk_KFormatFunc_formatDecimalDuration), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"formatDistance", reinterpret_cast<PyCFunction>(Sbk_KFormatFunc_formatDistance), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"formatDuration", reinterpret_cast<PyCFunction>(Sbk_KFormatFunc_formatDuration), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"formatRelativeDate", reinterpret_cast<PyCFunction>(Sbk_KFormatFunc_formatRelativeDate), METH_VARARGS, nullptr},
    {"formatRelativeDateTime", reinterpret_cast<PyCFunction>(Sbk_KFormatFunc_formatRelativeDateTime), METH_VARARGS, nullptr},
    {"formatSpelloutDuration", reinterpret_cast<PyCFunction>(Sbk_KFormatFunc_formatSpelloutDuration), METH_O, nullptr},
    {"formatTime", reinterpret_cast<PyCFunction>(Sbk_KFormatFunc_formatTime), METH_VARARGS, nullptr},
    {"formatValue", reinterpret_cast<PyCFunction>(Sbk_KFormatFunc_formatValue), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KFormat__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KFormat_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KFormat_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KFormat_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KFormat_spec = {
    "1:KCoreAddons.KFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC,
    Sbk_KFormat_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KFormat_BinarySizeUnits(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFormat::BinarySizeUnits>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFormat::BinarySizeUnits *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFormat_BinarySizeUnits_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_BinarySizeUnits_IDX])))
        return Enum_PythonToCpp_KFormat_BinarySizeUnits;
    return {};
}

static PyObject *KFormat_BinarySizeUnits_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFormat::BinarySizeUnits>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFormat::BinarySizeUnits *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KFormat_Unit(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFormat::Unit>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFormat::Unit *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFormat_Unit_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_Unit_IDX])))
        return Enum_PythonToCpp_KFormat_Unit;
    return {};
}

static PyObject *KFormat_Unit_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFormat::Unit>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFormat::Unit *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KFormat_UnitPrefix(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFormat::UnitPrefix>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFormat::UnitPrefix *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFormat_UnitPrefix_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_UnitPrefix_IDX])))
        return Enum_PythonToCpp_KFormat_UnitPrefix;
    return {};
}

static PyObject *KFormat_UnitPrefix_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFormat::UnitPrefix>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFormat::UnitPrefix *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KFormat_BinaryUnitDialect(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFormat::BinaryUnitDialect>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFormat::BinaryUnitDialect *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFormat_BinaryUnitDialect_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_BinaryUnitDialect_IDX])))
        return Enum_PythonToCpp_KFormat_BinaryUnitDialect;
    return {};
}

static PyObject *KFormat_BinaryUnitDialect_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFormat::BinaryUnitDialect>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFormat::BinaryUnitDialect *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KFormat_DurationFormatOption(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFormat::DurationFormatOption>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFormat::DurationFormatOption *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFormat_DurationFormatOption_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_DurationFormatOption_IDX])))
        return Enum_PythonToCpp_KFormat_DurationFormatOption;
    return {};
}

static PyObject *KFormat_DurationFormatOption_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFormat::DurationFormatOption>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFormat::DurationFormatOption *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KFormat_DurationFormatOption(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KFormat::DurationFormatOption>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KFormat::DurationFormatOption> *>(cppOut) = value;

}

static PyObject *KFormat_DurationFormatOption_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KFormat::DurationFormatOption> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_DurationFormatOption_IDX]), flags.toInt());

}

static void Enum_PythonToCpp_KFormat_DistanceFormatOption(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFormat::DistanceFormatOption>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFormat::DistanceFormatOption *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFormat_DistanceFormatOption_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_DistanceFormatOption_IDX])))
        return Enum_PythonToCpp_KFormat_DistanceFormatOption;
    return {};
}

static PyObject *KFormat_DistanceFormatOption_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFormat::DistanceFormatOption>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFormat::DistanceFormatOption *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KFormat_DistanceFormatOption(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KFormat::DistanceFormatOption>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KFormat::DistanceFormatOption> *>(cppOut) = value;

}

static PyObject *KFormat_DistanceFormatOption_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KFormat::DistanceFormatOption> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_DistanceFormatOption_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KFormat_PythonToCpp_KFormat_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KFormat_PythonToCpp_KFormat_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KFormat_TypeF()))
        return KFormat_PythonToCpp_KFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KFormat_PTR_CppToPython_KFormat(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KFormat_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KFormat_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *KFormat_COPY_CppToPython_KFormat(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KFormat *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KFormat_TypeF(), new ::KFormat(*source), true, true);
}

// Python to C++ copy conversion.
static void KFormat_PythonToCpp_KFormat_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KFormat *>(cppOut) = *reinterpret_cast< ::KFormat *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_KFormat_PythonToCpp_KFormat_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KFormat_TypeF()))
        return KFormat_PythonToCpp_KFormat_COPY;
    return {};
}

// Implicit conversions.
static void PySide6_QtCore_constQLocaleREF_PythonToCpp_KFormat(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KFormat *>(cppOut) = ::KFormat( *reinterpret_cast< ::QLocale *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_IDX]), reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide6_QtCore_constQLocaleREF_PythonToCpp_KFormat_Convertible(PyObject *pyIn)
{
    if (SbkObject_TypeCheck(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_IDX]), pyIn))
        return PySide6_QtCore_constQLocaleREF_PythonToCpp_KFormat;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KFormat_SignatureStrings[] = {
    "1:KCoreAddons.KFormat(self,other:KCoreAddons.KFormat)",
    "0:KCoreAddons.KFormat(self,locale:typing.Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]=QLocale())",
    "KCoreAddons.KFormat.formatByteSize(self,size:double,precision:int=1,dialect:KCoreAddons.KFormat.BinaryUnitDialect=KFormat.DefaultBinaryDialect,units:KCoreAddons.KFormat.BinarySizeUnits=KFormat.DefaultBinaryUnits)->QString",
    "KCoreAddons.KFormat.formatDecimalDuration(self,msecs:quint64,decimalPlaces:int=2)->QString",
    "KCoreAddons.KFormat.formatDistance(self,distance:double,arg__2:KCoreAddons.KFormat.DistanceFormatOption=KFormat.DistanceFormatOption.LocaleDistanceUnits)->QString",
    "KCoreAddons.KFormat.formatDuration(self,msecs:quint64,options:KCoreAddons.KFormat.DurationFormatOption=KFormat.DefaultDuration)->QString",
    "KCoreAddons.KFormat.formatRelativeDate(self,date:PySide6.QtCore.QDate,format:PySide6.QtCore.QLocale.FormatType)->QString",
    "KCoreAddons.KFormat.formatRelativeDateTime(self,dateTime:PySide6.QtCore.QDateTime,format:PySide6.QtCore.QLocale.FormatType)->QString",
    "KCoreAddons.KFormat.formatSpelloutDuration(self,msecs:quint64)->QString",
    "KCoreAddons.KFormat.formatTime(self,dateTime:PySide6.QtCore.QDateTime,format:PySide6.QtCore.QLocale.FormatType)->QString",
    "2:KCoreAddons.KFormat.formatValue(self,value:double,unit:KCoreAddons.KFormat.Unit,precision:int=1,prefix:KCoreAddons.KFormat.UnitPrefix=KFormat.UnitPrefix.AutoAdjust,dialect:KCoreAddons.KFormat.BinaryUnitDialect=KFormat.DefaultBinaryDialect)->QString",
    "1:KCoreAddons.KFormat.formatValue(self,value:double,unit:QString,precision:int=1,prefix:KCoreAddons.KFormat.UnitPrefix=KFormat.UnitPrefix.AutoAdjust)->QString",
    "0:KCoreAddons.KFormat.formatValue(self,value:double,unit:QString,precision:int,prefix:KCoreAddons.KFormat.UnitPrefix,dialect:KCoreAddons.KFormat.BinaryUnitDialect)->QString",
    "KCoreAddons.KFormat.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t KFormat_SignatureByteSize = 435;
static constexpr uint8_t KFormat_SignatureBytes[435] = {
    0x78, 0xda, 0xb5, 0x55, 0xdf, 0x4f, 0x83, 0x30, 0x10, 0x7e, 0xdf, 0x5f, 0xe1, 0xe3, 0x48, 0xb0,
    0xd9, 0x16, 0xb3, 0x07, 0x12, 0x4c, 0x36, 0x89, 0x2f, 0x5b, 0xe2, 0x26, 0xd3, 0x17, 0x63, 0x48,
    0xa5, 0x05, 0x6b, 0x0a, 0xc5, 0xfe, 0x58, 0xc4, 0xbf, 0xde, 0x96, 0x42, 0xb2, 0xb8, 0x0e, 0x37,
    0xb3, 0x3d, 0xd1, 0xeb, 0xdd, 0x7d, 0xf7, 0x7d, 0x77, 0x07, 0x8c, 0x83, 0xc5, 0x1d, 0xe3, 0x78,
    0x86, 0x10, 0x2b, 0x05, 0x58, 0xdc, 0x33, 0x5e, 0x40, 0x39, 0x14, 0x98, 0x66, 0x3e, 0x93, 0xef,
    0x98, 0xbb, 0xdc, 0xde, 0x60, 0x74, 0x38, 0x8b, 0xb2, 0x14, 0x52, 0x1c, 0xc8, 0xba, 0x22, 0x65,
    0x0e, 0x9e, 0x4a, 0xc2, 0xca, 0x97, 0x55, 0x1d, 0x13, 0x84, 0xa7, 0x60, 0x2d, 0x4d, 0x16, 0x58,
    0x2f, 0x9b, 0x18, 0xff, 0xca, 0x7d, 0x0f, 0x96, 0xb0, 0xcc, 0x15, 0xcc, 0xf1, 0x6b, 0xd8, 0xde,
    0x0c, 0x3d, 0x6f, 0xe0, 0x28, 0x08, 0xb2, 0xe6, 0x31, 0xaf, 0x25, 0x8e, 0xc9, 0x37, 0xb6, 0xf5,
    0x85, 0x3e, 0x05, 0x88, 0xa9, 0x37, 0x5d, 0xa0, 0xe2, 0x38, 0x25, 0x42, 0x33, 0x08, 0x48, 0x29,
    0xc3, 0xb1, 0x8f, 0x88, 0x06, 0x4b, 0xa5, 0x8b, 0x3c, 0x98, 0x93, 0x12, 0xf2, 0x5a, 0xf3, 0x95,
    0x91, 0x8d, 0x0a, 0x3b, 0x4f, 0x84, 0x33, 0xa8, 0xa8, 0xb4, 0x01, 0xad, 0xd3, 0x57, 0x3a, 0x50,
    0xf4, 0x00, 0x19, 0x42, 0x06, 0x4c, 0xb8, 0x61, 0x1a, 0x97, 0x77, 0x7d, 0xbb, 0x8e, 0x25, 0xd7,
    0x7d, 0xea, 0x51, 0x17, 0x69, 0x09, 0x05, 0xa4, 0x91, 0xe2, 0x50, 0x6a, 0x25, 0x56, 0x64, 0x21,
    0x70, 0x2a, 0x82, 0x4f, 0xa5, 0x65, 0x4d, 0x6f, 0x7c, 0x64, 0x43, 0x56, 0x14, 0xa6, 0x58, 0x34,
    0x52, 0x27, 0xc7, 0x41, 0x13, 0x21, 0x61, 0x99, 0xb6, 0x8d, 0x43, 0xad, 0xd5, 0x35, 0x0f, 0xf2,
    0x3c, 0x49, 0x26, 0x4e, 0x89, 0x5d, 0xa2, 0x35, 0x1f, 0x2a, 0x43, 0x2c, 0xec, 0x73, 0x02, 0x3b,
    0xc7, 0xce, 0x75, 0x82, 0xfa, 0x1e, 0xd9, 0xac, 0x81, 0x76, 0x0f, 0xa1, 0xcb, 0x73, 0x33, 0xb4,
    0x93, 0xe8, 0x62, 0x8e, 0x22, 0xf2, 0x88, 0xa9, 0x0e, 0xde, 0xe2, 0x08, 0xca, 0xae, 0x5f, 0xfa,
    0x14, 0xfc, 0xde, 0x60, 0xe3, 0xf6, 0x6d, 0x46, 0x70, 0x60, 0xbb, 0x2d, 0xec, 0xa6, 0xae, 0xf0,
    0xc9, 0x85, 0x37, 0xa4, 0xd8, 0x29, 0x6e, 0x2c, 0x27, 0x01, 0xe3, 0x38, 0x2f, 0x89, 0xb8, 0xc2,
    0x94, 0x32, 0xd5, 0x37, 0x8e, 0xa3, 0x70, 0x2e, 0x2c, 0xc0, 0xbd, 0xad, 0x16, 0xe8, 0x19, 0x52,
    0xd5, 0xd6, 0xde, 0x9a, 0x63, 0xb7, 0xe6, 0xe6, 0x45, 0x76, 0xa6, 0x99, 0x25, 0xdd, 0xfb, 0x82,
    0x68, 0x3b, 0x23, 0x5f, 0x07, 0xe3, 0x57, 0x8d, 0x3b, 0xdc, 0xbf, 0x02, 0x33, 0x25, 0xd9, 0x0c,
    0x7d, 0x28, 0x21, 0xcf, 0xf8, 0x15, 0xda, 0x91, 0x3e, 0xfe, 0xaf, 0xf4, 0x16, 0xe0, 0x12, 0x4a,
    0x77, 0xe8, 0x8d, 0xce, 0x4a, 0xef, 0x38, 0x72, 0xa7, 0x35, 0xfa, 0x8f, 0xfd, 0x4d, 0x92, 0x94,
    0x55, 0x75, 0x92, 0x34, 0x3c, 0x75, 0x6c, 0xfb, 0x7f, 0x4b, 0x62, 0x6d, 0x0e, 0x7e, 0x00, 0x3c,
    0x07, 0xac, 0xb6
};
#endif

PyTypeObject *init_KFormat(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX].type;

    Shiboken::AutoDecRef Sbk_KFormat_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KFormat",
        "KFormat",
        &Sbk_KFormat_spec,
        &Shiboken::callCppDestructor< ::KFormat >,
        Sbk_KFormat_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_KFormat_Type; // references _Sbk_KFormat_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KFormat_SignatureStrings);
#else
    InitSignatureBytes(pyType, KFormat_SignatureBytes, KFormat_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KFormat_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KFormat_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KFormat_PythonToCpp_KFormat_PTR,
        is_KFormat_PythonToCpp_KFormat_PTR_Convertible,
        KFormat_PTR_CppToPython_KFormat,
        KFormat_COPY_CppToPython_KFormat);

    Shiboken::Conversions::registerConverterName(converter, "KFormat");
    Shiboken::Conversions::registerConverterName(converter, "KFormat*");
    Shiboken::Conversions::registerConverterName(converter, "KFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KFormat_PythonToCpp_KFormat_COPY,
        is_KFormat_PythonToCpp_KFormat_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide6_QtCore_constQLocaleREF_PythonToCpp_KFormat,
        is_PySide6_QtCore_constQLocaleREF_PythonToCpp_KFormat_Convertible);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KFormat_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'BinarySizeUnits'.
    const char *BinarySizeUnits_Initializer[] = {
        "DefaultBinaryUnits",
        "UnitByte",
        "UnitKiloByte",
        "UnitMegaByte",
        "UnitGigaByte",
        "UnitTeraByte",
        "UnitPetaByte",
        "UnitExaByte",
        "UnitZettaByte",
        "UnitYottaByte",
        "UnitLastUnit",
        nullptr};
    // "int8_t" used instead of "int"
    constexpr int8_t BinarySizeUnits_InitializerValues[] = {
        int8_t(KFormat::BinarySizeUnits::DefaultBinaryUnits), // -0x01 -1
        int8_t(KFormat::BinarySizeUnits::UnitByte),           //  0x00  0
        int8_t(KFormat::BinarySizeUnits::UnitKiloByte),       //  0x01  1
        int8_t(KFormat::BinarySizeUnits::UnitMegaByte),       //  0x02  2
        int8_t(KFormat::BinarySizeUnits::UnitGigaByte),       //  0x03  3
        int8_t(KFormat::BinarySizeUnits::UnitTeraByte),       //  0x04  4
        int8_t(KFormat::BinarySizeUnits::UnitPetaByte),       //  0x05  5
        int8_t(KFormat::BinarySizeUnits::UnitExaByte),        //  0x06  6
        int8_t(KFormat::BinarySizeUnits::UnitZettaByte),      //  0x07  7
        int8_t(KFormat::BinarySizeUnits::UnitYottaByte),      //  0x08  8
        int8_t(KFormat::BinarySizeUnits::UnitLastUnit)        //  0x08  8
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFormat_TypeF(),
        "1:KCoreAddons.KFormat.BinarySizeUnits",
        BinarySizeUnits_Initializer, BinarySizeUnits_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KFormat_BinarySizeUnits_IDX].type = EType;
    // Register converter for enum 'KFormat::BinarySizeUnits'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFormat_BinarySizeUnits_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFormat_BinarySizeUnits,
            is_Enum_PythonToCpp_KFormat_BinarySizeUnits_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFormat::BinarySizeUnits");
        Shiboken::Conversions::registerConverterAlias(converter, "BinarySizeUnits");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'BinarySizeUnits' enum.

    // Initialization of enum 'Unit'.
    const char *Unit_Initializer[] = {
        "Other",
        "Bit",
        "Byte",
        "Meter",
        "Hertz",
        nullptr};
    // "int8_t" used instead of "int"
    constexpr int8_t Unit_InitializerValues[] = {
        int8_t(KFormat::Unit::Other), //  0x00  0
        int8_t(KFormat::Unit::Bit),   //  0x01  1
        int8_t(KFormat::Unit::Byte),  //  0x02  2
        int8_t(KFormat::Unit::Meter), //  0x03  3
        int8_t(KFormat::Unit::Hertz)  //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFormat_TypeF(),
        "1:KCoreAddons.KFormat.Unit",
        Unit_Initializer, Unit_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KFormat_Unit_IDX].type = EType;
    // Register converter for enum 'KFormat::Unit'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFormat_Unit_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFormat_Unit,
            is_Enum_PythonToCpp_KFormat_Unit_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFormat::Unit");
        Shiboken::Conversions::registerConverterAlias(converter, "Unit");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Unit' enum.

    // Initialization of enum 'UnitPrefix'.
    const char *UnitPrefix_Initializer[] = {
        "AutoAdjust",
        "Yocto",
        "Zepto",
        "Atto",
        "Femto",
        "Pico",
        "Nano",
        "Micro",
        "Milli",
        "Centi",
        "Deci",
        "Unity",
        "Deca",
        "Hecto",
        "Kilo",
        "Mega",
        "Giga",
        "Tera",
        "Peta",
        "Exa",
        "Zetta",
        "Yotta",
        nullptr};
    // "int8_t" used instead of "int"
    constexpr int8_t UnitPrefix_InitializerValues[] = {
        int8_t(KFormat::UnitPrefix::AutoAdjust), // -0x80 -128
        int8_t(KFormat::UnitPrefix::Yocto),      //  0x00  0
        int8_t(KFormat::UnitPrefix::Zepto),      //  0x01  1
        int8_t(KFormat::UnitPrefix::Atto),       //  0x02  2
        int8_t(KFormat::UnitPrefix::Femto),      //  0x03  3
        int8_t(KFormat::UnitPrefix::Pico),       //  0x04  4
        int8_t(KFormat::UnitPrefix::Nano),       //  0x05  5
        int8_t(KFormat::UnitPrefix::Micro),      //  0x06  6
        int8_t(KFormat::UnitPrefix::Milli),      //  0x07  7
        int8_t(KFormat::UnitPrefix::Centi),      //  0x08  8
        int8_t(KFormat::UnitPrefix::Deci),       //  0x09  9
        int8_t(KFormat::UnitPrefix::Unity),      //  0x0a  10
        int8_t(KFormat::UnitPrefix::Deca),       //  0x0b  11
        int8_t(KFormat::UnitPrefix::Hecto),      //  0x0c  12
        int8_t(KFormat::UnitPrefix::Kilo),       //  0x0d  13
        int8_t(KFormat::UnitPrefix::Mega),       //  0x0e  14
        int8_t(KFormat::UnitPrefix::Giga),       //  0x0f  15
        int8_t(KFormat::UnitPrefix::Tera),       //  0x10  16
        int8_t(KFormat::UnitPrefix::Peta),       //  0x11  17
        int8_t(KFormat::UnitPrefix::Exa),        //  0x12  18
        int8_t(KFormat::UnitPrefix::Zetta),      //  0x13  19
        int8_t(KFormat::UnitPrefix::Yotta)       //  0x14  20
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFormat_TypeF(),
        "1:KCoreAddons.KFormat.UnitPrefix",
        UnitPrefix_Initializer, UnitPrefix_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KFormat_UnitPrefix_IDX].type = EType;
    // Register converter for enum 'KFormat::UnitPrefix'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFormat_UnitPrefix_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFormat_UnitPrefix,
            is_Enum_PythonToCpp_KFormat_UnitPrefix_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFormat::UnitPrefix");
        Shiboken::Conversions::registerConverterAlias(converter, "UnitPrefix");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'UnitPrefix' enum.

    // Initialization of enum 'BinaryUnitDialect'.
    const char *BinaryUnitDialect_Initializer[] = {
        "DefaultBinaryDialect",
        "IECBinaryDialect",
        "JEDECBinaryDialect",
        "MetricBinaryDialect",
        "LastBinaryDialect",
        nullptr};
    // "int8_t" used instead of "int"
    constexpr int8_t BinaryUnitDialect_InitializerValues[] = {
        int8_t(KFormat::BinaryUnitDialect::DefaultBinaryDialect), // -0x01 -1
        int8_t(KFormat::BinaryUnitDialect::IECBinaryDialect),     //  0x00  0
        int8_t(KFormat::BinaryUnitDialect::JEDECBinaryDialect),   //  0x01  1
        int8_t(KFormat::BinaryUnitDialect::MetricBinaryDialect),  //  0x02  2
        int8_t(KFormat::BinaryUnitDialect::LastBinaryDialect)     //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFormat_TypeF(),
        "1:KCoreAddons.KFormat.BinaryUnitDialect",
        BinaryUnitDialect_Initializer, BinaryUnitDialect_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KFormat_BinaryUnitDialect_IDX].type = EType;
    // Register converter for enum 'KFormat::BinaryUnitDialect'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFormat_BinaryUnitDialect_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFormat_BinaryUnitDialect,
            is_Enum_PythonToCpp_KFormat_BinaryUnitDialect_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFormat::BinaryUnitDialect");
        Shiboken::Conversions::registerConverterAlias(converter, "BinaryUnitDialect");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'BinaryUnitDialect' enum.

    // Initialization of enum 'DurationFormatOption'.
    const char *DurationFormatOption_Initializer[] = {
        "DefaultDuration",
        "InitialDuration",
        "ShowMilliseconds",
        "HideSeconds",
        "FoldHours",
        "AbbreviatedDuration",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t DurationFormatOption_InitializerValues[] = {
        uint8_t(KFormat::DurationFormatOption::DefaultDuration),    //  0x00  0
        uint8_t(KFormat::DurationFormatOption::InitialDuration),    //  0x01  1
        uint8_t(KFormat::DurationFormatOption::ShowMilliseconds),   //  0x02  2
        uint8_t(KFormat::DurationFormatOption::HideSeconds),        //  0x04  4
        uint8_t(KFormat::DurationFormatOption::FoldHours),          //  0x08  8
        uint8_t(KFormat::DurationFormatOption::AbbreviatedDuration) //  0x10  16
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFormat_TypeF(),
        "1:KCoreAddons.KFormat.DurationFormatOption",
        DurationFormatOption_Initializer, DurationFormatOption_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KFormat_DurationFormatOption_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKCoreAddonsTypeStructs[SBK_QFlags_KFormat_DurationFormatOption_IDX].type =
        EType;
    // Register converter for enum 'KFormat::DurationFormatOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFormat_DurationFormatOption_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFormat_DurationFormatOption,
            is_Enum_PythonToCpp_KFormat_DurationFormatOption_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFormat::DurationFormatOption");
        Shiboken::Conversions::registerConverterAlias(converter, "DurationFormatOption");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KFormat_DurationFormatOption_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KFormat_DurationFormatOption,
            is_Enum_PythonToCpp_KFormat_DurationFormatOption_Convertible);
        // Register converter for flag 'QFlags<KFormat::DurationFormatOption>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KFormat::DurationFormatOption>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KFormat::DurationFormatOptions");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'DurationFormatOption' enum/flags.

    // Initialization of enum 'DistanceFormatOption'.
    const char *DistanceFormatOption_Initializer[] = {
        "LocaleDistanceUnits",
        "MetricDistanceUnits",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t DistanceFormatOption_InitializerValues[] = {
        uint8_t(KFormat::DistanceFormatOption::LocaleDistanceUnits), //  0x00  0
        uint8_t(KFormat::DistanceFormatOption::MetricDistanceUnits)  //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFormat_TypeF(),
        "1:KCoreAddons.KFormat.DistanceFormatOption",
        DistanceFormatOption_Initializer, DistanceFormatOption_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KFormat_DistanceFormatOption_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKCoreAddonsTypeStructs[SBK_QFlags_KFormat_DistanceFormatOption_IDX].type =
        EType;
    // Register converter for enum 'KFormat::DistanceFormatOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFormat_DistanceFormatOption_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFormat_DistanceFormatOption,
            is_Enum_PythonToCpp_KFormat_DistanceFormatOption_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFormat::DistanceFormatOption");
        Shiboken::Conversions::registerConverterAlias(converter, "DistanceFormatOption");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KFormat_DistanceFormatOption_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KFormat_DistanceFormatOption,
            is_Enum_PythonToCpp_KFormat_DistanceFormatOption_Convertible);
        // Register converter for flag 'QFlags<KFormat::DistanceFormatOption>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KFormat::DistanceFormatOption>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KFormat::DistanceFormatOptions");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'DistanceFormatOption' enum/flags.

    qRegisterMetaType< ::KFormat >("KFormat");
    qRegisterMetaType< ::KFormat::BinarySizeUnits >("KFormat::BinarySizeUnits");
    qRegisterMetaType< ::KFormat::Unit >("KFormat::Unit");
    qRegisterMetaType< ::KFormat::UnitPrefix >("KFormat::UnitPrefix");
    qRegisterMetaType< ::KFormat::BinaryUnitDialect >("KFormat::BinaryUnitDialect");
    qRegisterMetaType< ::KFormat::DurationFormatOption >("KFormat::DurationFormatOption");
    qRegisterMetaType< ::KFormat::DistanceFormatOption >("KFormat::DistanceFormatOption");

    return pyType;
}
