/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         CISAparse
#define yylex           CISAlex
#define yyerror         CISAerror
#define yydebug         CISAdebug
#define yynerrs         CISAnerrs
#define yylval          CISAlval
#define yychar          CISAchar

/* First part of user prologue.  */
#line 9 "CISA.y"

#include <stdio.h>
#include <math.h>
#include <string>
#include <vector>

#include "visa_igc_common_header.h"
#include "Common_ISA.h"
#include "Common_ISA_util.h"
#include "Common_ISA_framework.h"
#include "JitterDataStruct.h"
#include "VISAKernel.h"

static int lscCheckExecSize(
    CISA_IR_Builder* pBuilder,
    LSC_SFID sfid,
    LSC_OP op,
    LSC_DATA_ORDER data_order,
    int exec_size);

void CISAerror(CISA_IR_Builder* builder, char const* msg);
int yylex(CISA_IR_Builder *pBuilder);
extern int CISAlineno;

[[maybe_unused]] static bool streq(const char *sym0, const char *sym1);
static bool ParseAlign(CISA_IR_Builder* pBuilder, const char *sym, VISA_Align &value);
static bool AlignBytesToVisaAlignment(int bytes, VISA_Align &val);
static bool ParseEMask(const char* sym, VISA_EMask_Ctrl &emask);

//
// check if the cond is true.
// if cond is false, then print errorMessage (syntax error) and YYABORT
#define MUST_HOLD(cond, errorMessage) \
  {if (!(cond)) {pBuilder->RecordParseError(CISAlineno, errorMessage); YYABORT;}}
#define PARSE_ERROR_AT(LINE,...)\
  {pBuilder->RecordParseError(LINE, __VA_ARGS__); YYABORT;}
#define PARSE_ERROR(...)\
    PARSE_ERROR_AT(CISAlineno, __VA_ARGS__)

// Use this to wrap API calls that return false, nullptr, or 0 on failure
// It's assumed that the API call reported the parse error
#define ABORT_ON_FAIL(X) \
    do \
        if (!(X)) \
            YYABORT;\
    while (0)
#define TRACE(S) \
    do { \
      if (CISAout && pBuilder->debugParse()) \
          fprintf(CISAout, "line %d: %s", CISAlineno, S); \
    } while (0)

std::deque<const char*> switchLabels;
std::vector<VISA_opnd*> RTRWOperandsVec;

VISA_RawOpnd* rawOperandArray[16];

// global var for non-kernel attribute option.
// The var needs to be cleared before each use.
std::vector<attr_gen_struct*> AttrOptVar;


#line 141 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "CISA.tab.hpp"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_ALIGN_KEYWORD = 3,              /* ALIGN_KEYWORD  */
  YYSYMBOL_ATOMIC_SUB_OP = 4,              /* ATOMIC_SUB_OP  */
  YYSYMBOL_DIRECTIVE_DECL = 5,             /* DIRECTIVE_DECL  */
  YYSYMBOL_DIRECTIVE_FUNC = 6,             /* DIRECTIVE_FUNC  */
  YYSYMBOL_DIRECTIVE_FUNCDECL = 7,         /* DIRECTIVE_FUNCDECL  */
  YYSYMBOL_DIRECTIVE_GLOBAL_FUNC = 8,      /* DIRECTIVE_GLOBAL_FUNC  */
  YYSYMBOL_DIRECTIVE_IMPLICIT = 9,         /* DIRECTIVE_IMPLICIT  */
  YYSYMBOL_DIRECTIVE_INPUT = 10,           /* DIRECTIVE_INPUT  */
  YYSYMBOL_DIRECTIVE_KERNEL = 11,          /* DIRECTIVE_KERNEL  */
  YYSYMBOL_DIRECTIVE_KERNEL_ATTR = 12,     /* DIRECTIVE_KERNEL_ATTR  */
  YYSYMBOL_DIRECTIVE_VERSION = 13,         /* DIRECTIVE_VERSION  */
  YYSYMBOL_ALIAS_EQ = 14,                  /* ALIAS_EQ  */
  YYSYMBOL_ALIGN_EQ = 15,                  /* ALIGN_EQ  */
  YYSYMBOL_ATTR_EQ = 16,                   /* ATTR_EQ  */
  YYSYMBOL_OFFSET_EQ = 17,                 /* OFFSET_EQ  */
  YYSYMBOL_NUM_ELTS_EQ = 18,               /* NUM_ELTS_EQ  */
  YYSYMBOL_V_NAME_EQ = 19,                 /* V_NAME_EQ  */
  YYSYMBOL_SIZE_EQ = 20,                   /* SIZE_EQ  */
  YYSYMBOL_V_TYPE_EQ_G = 21,               /* V_TYPE_EQ_G  */
  YYSYMBOL_V_TYPE_EQ_P = 22,               /* V_TYPE_EQ_P  */
  YYSYMBOL_V_TYPE_EQ_A = 23,               /* V_TYPE_EQ_A  */
  YYSYMBOL_V_TYPE_EQ_S = 24,               /* V_TYPE_EQ_S  */
  YYSYMBOL_V_TYPE_EQ_T = 25,               /* V_TYPE_EQ_T  */
  YYSYMBOL_CPS = 26,                       /* CPS  */
  YYSYMBOL_NON_UNIFORM_SAMPLER = 27,       /* NON_UNIFORM_SAMPLER  */
  YYSYMBOL_PIXEL_NULL_MASK = 28,           /* PIXEL_NULL_MASK  */
  YYSYMBOL_RAW_SEND_STRING = 29,           /* RAW_SEND_STRING  */
  YYSYMBOL_RAW_SENDC_STRING = 30,          /* RAW_SENDC_STRING  */
  YYSYMBOL_RAW_SENDS_STRING = 31,          /* RAW_SENDS_STRING  */
  YYSYMBOL_RAW_SENDS_EOT_STRING = 32,      /* RAW_SENDS_EOT_STRING  */
  YYSYMBOL_RAW_SENDSC_STRING = 33,         /* RAW_SENDSC_STRING  */
  YYSYMBOL_RAW_SENDSC_EOT_STRING = 34,     /* RAW_SENDSC_EOT_STRING  */
  YYSYMBOL_SAT = 35,                       /* SAT  */
  YYSYMBOL_SRCMOD_ABS = 36,                /* SRCMOD_ABS  */
  YYSYMBOL_SRCMOD_NEG = 37,                /* SRCMOD_NEG  */
  YYSYMBOL_SRCMOD_NEGABS = 38,             /* SRCMOD_NEGABS  */
  YYSYMBOL_SRCMOD_NOT = 39,                /* SRCMOD_NOT  */
  YYSYMBOL_BFN_OP = 40,                    /* BFN_OP  */
  YYSYMBOL_DPAS_OP = 41,                   /* DPAS_OP  */
  YYSYMBOL_SVM_ALIGNED = 42,               /* SVM_ALIGNED  */
  YYSYMBOL_SVM_UNALIGNED = 43,             /* SVM_UNALIGNED  */
  YYSYMBOL_NBARRIER_SIGNAL = 44,           /* NBARRIER_SIGNAL  */
  YYSYMBOL_NBARRIER_WAIT = 45,             /* NBARRIER_WAIT  */
  YYSYMBOL_ITYPE = 46,                     /* ITYPE  */
  YYSYMBOL_DECL_DATA_TYPE = 47,            /* DECL_DATA_TYPE  */
  YYSYMBOL_DFTYPE = 48,                    /* DFTYPE  */
  YYSYMBOL_FTYPE = 49,                     /* FTYPE  */
  YYSYMBOL_HFTYPE = 50,                    /* HFTYPE  */
  YYSYMBOL_BFTYPE = 51,                    /* BFTYPE  */
  YYSYMBOL_VTYPE = 52,                     /* VTYPE  */
  YYSYMBOL_COND_MOD = 53,                  /* COND_MOD  */
  YYSYMBOL_LANGLE = 54,                    /* LANGLE  */
  YYSYMBOL_RANGLE = 55,                    /* RANGLE  */
  YYSYMBOL_LBRACK = 56,                    /* LBRACK  */
  YYSYMBOL_RBRACK = 57,                    /* RBRACK  */
  YYSYMBOL_IND_LBRACK = 58,                /* IND_LBRACK  */
  YYSYMBOL_LPAREN = 59,                    /* LPAREN  */
  YYSYMBOL_RPAREN = 60,                    /* RPAREN  */
  YYSYMBOL_LBRACE = 61,                    /* LBRACE  */
  YYSYMBOL_RBRACE = 62,                    /* RBRACE  */
  YYSYMBOL_DOT = 63,                       /* DOT  */
  YYSYMBOL_COMMA = 64,                     /* COMMA  */
  YYSYMBOL_SEMI = 65,                      /* SEMI  */
  YYSYMBOL_COLON = 66,                     /* COLON  */
  YYSYMBOL_SLASH = 67,                     /* SLASH  */
  YYSYMBOL_PERCENT = 68,                   /* PERCENT  */
  YYSYMBOL_EQUALS = 69,                    /* EQUALS  */
  YYSYMBOL_PLUS = 70,                      /* PLUS  */
  YYSYMBOL_MINUS = 71,                     /* MINUS  */
  YYSYMBOL_TIMES = 72,                     /* TIMES  */
  YYSYMBOL_AMP = 73,                       /* AMP  */
  YYSYMBOL_CIRC = 74,                      /* CIRC  */
  YYSYMBOL_PIPE = 75,                      /* PIPE  */
  YYSYMBOL_TILDE = 76,                     /* TILDE  */
  YYSYMBOL_BANG = 77,                      /* BANG  */
  YYSYMBOL_QUESTION = 78,                  /* QUESTION  */
  YYSYMBOL_LEQ = 79,                       /* LEQ  */
  YYSYMBOL_GEQ = 80,                       /* GEQ  */
  YYSYMBOL_EQ = 81,                        /* EQ  */
  YYSYMBOL_NEQ = 82,                       /* NEQ  */
  YYSYMBOL_SHL = 83,                       /* SHL  */
  YYSYMBOL_SHRS = 84,                      /* SHRS  */
  YYSYMBOL_SHRZ = 85,                      /* SHRZ  */
  YYSYMBOL_LABEL = 86,                     /* LABEL  */
  YYSYMBOL_IDENT = 87,                     /* IDENT  */
  YYSYMBOL_BUILTIN_NULL = 88,              /* BUILTIN_NULL  */
  YYSYMBOL_BUILTIN = 89,                   /* BUILTIN  */
  YYSYMBOL_STRING_LIT = 90,                /* STRING_LIT  */
  YYSYMBOL_NEWLINE = 91,                   /* NEWLINE  */
  YYSYMBOL_BUILD_OPTION_LINE = 92,         /* BUILD_OPTION_LINE  */
  YYSYMBOL_UNIFORM = 93,                   /* UNIFORM  */
  YYSYMBOL_RTWRITE_OPTION = 94,            /* RTWRITE_OPTION  */
  YYSYMBOL_MEDIA_MODE = 95,                /* MEDIA_MODE  */
  YYSYMBOL_OWORD_MODIFIER = 96,            /* OWORD_MODIFIER  */
  YYSYMBOL_SAMPLER_CHANNEL = 97,           /* SAMPLER_CHANNEL  */
  YYSYMBOL_CHANNEL_OUTPUT = 98,            /* CHANNEL_OUTPUT  */
  YYSYMBOL_EXECMODE = 99,                  /* EXECMODE  */
  YYSYMBOL_CNTRL = 100,                    /* CNTRL  */
  YYSYMBOL_FENCE_OPTIONS = 101,            /* FENCE_OPTIONS  */
  YYSYMBOL_ADDR_ADD_OP = 102,              /* ADDR_ADD_OP  */
  YYSYMBOL_UNARY_LOGIC_OP = 103,           /* UNARY_LOGIC_OP  */
  YYSYMBOL_BINARY_LOGIC_OP = 104,          /* BINARY_LOGIC_OP  */
  YYSYMBOL_TERNARY_LOGIC_OP = 105,         /* TERNARY_LOGIC_OP  */
  YYSYMBOL_QUATERNARY_LOGIC_OP = 106,      /* QUATERNARY_LOGIC_OP  */
  YYSYMBOL_SEL_OP = 107,                   /* SEL_OP  */
  YYSYMBOL_MIN_OP = 108,                   /* MIN_OP  */
  YYSYMBOL_MAX_OP = 109,                   /* MAX_OP  */
  YYSYMBOL_ANTI_TRIG_OP = 110,             /* ANTI_TRIG_OP  */
  YYSYMBOL_MATH2_OP = 111,                 /* MATH2_OP  */
  YYSYMBOL_MATH3_OP = 112,                 /* MATH3_OP  */
  YYSYMBOL_ARITH2_OP = 113,                /* ARITH2_OP  */
  YYSYMBOL_ARITH3_OP = 114,                /* ARITH3_OP  */
  YYSYMBOL_ARITH4_OP = 115,                /* ARITH4_OP  */
  YYSYMBOL_ARITH4_OP2 = 116,               /* ARITH4_OP2  */
  YYSYMBOL_ARITH5_OP2 = 117,               /* ARITH5_OP2  */
  YYSYMBOL_CMP_OP = 118,                   /* CMP_OP  */
  YYSYMBOL_SVM_OP = 119,                   /* SVM_OP  */
  YYSYMBOL_SVM_SCATTER_OP = 120,           /* SVM_SCATTER_OP  */
  YYSYMBOL_SVM_GATHER4SCALED_OP = 121,     /* SVM_GATHER4SCALED_OP  */
  YYSYMBOL_SVM_SCATTER4SCALED_OP = 122,    /* SVM_SCATTER4SCALED_OP  */
  YYSYMBOL_SVM_ATOMIC_OP = 123,            /* SVM_ATOMIC_OP  */
  YYSYMBOL_OWORD_OP = 124,                 /* OWORD_OP  */
  YYSYMBOL_MEDIA_OP = 125,                 /* MEDIA_OP  */
  YYSYMBOL_SCATTER_OP = 126,               /* SCATTER_OP  */
  YYSYMBOL_SCATTER_TYPED_OP = 127,         /* SCATTER_TYPED_OP  */
  YYSYMBOL_SCATTER_SCALED_OP = 128,        /* SCATTER_SCALED_OP  */
  YYSYMBOL_SCATTER4_SCALED_OP = 129,       /* SCATTER4_SCALED_OP  */
  YYSYMBOL_BARRIER_OP = 130,               /* BARRIER_OP  */
  YYSYMBOL_SBARRIER_SIGNAL = 131,          /* SBARRIER_SIGNAL  */
  YYSYMBOL_SBARRIER_WAIT = 132,            /* SBARRIER_WAIT  */
  YYSYMBOL_DWORD_ATOMIC_OP = 133,          /* DWORD_ATOMIC_OP  */
  YYSYMBOL_TYPED_ATOMIC_OP = 134,          /* TYPED_ATOMIC_OP  */
  YYSYMBOL_SAMPLE_OP = 135,                /* SAMPLE_OP  */
  YYSYMBOL_SAMPLE_UNORM_OP = 136,          /* SAMPLE_UNORM_OP  */
  YYSYMBOL_VME_IME_OP = 137,               /* VME_IME_OP  */
  YYSYMBOL_VME_SIC_OP = 138,               /* VME_SIC_OP  */
  YYSYMBOL_VME_FBR_OP = 139,               /* VME_FBR_OP  */
  YYSYMBOL_BRANCH_OP = 140,                /* BRANCH_OP  */
  YYSYMBOL_RET_OP = 141,                   /* RET_OP  */
  YYSYMBOL_IFCALL = 142,                   /* IFCALL  */
  YYSYMBOL_FCALL = 143,                    /* FCALL  */
  YYSYMBOL_FADDR = 144,                    /* FADDR  */
  YYSYMBOL_SWITCHJMP_OP = 145,             /* SWITCHJMP_OP  */
  YYSYMBOL_MOVS_OP = 146,                  /* MOVS_OP  */
  YYSYMBOL_SETP_OP = 147,                  /* SETP_OP  */
  YYSYMBOL_MOV_OP = 148,                   /* MOV_OP  */
  YYSYMBOL_FILE_OP = 149,                  /* FILE_OP  */
  YYSYMBOL_LOC_OP = 150,                   /* LOC_OP  */
  YYSYMBOL_CACHE_FLUSH_OP = 151,           /* CACHE_FLUSH_OP  */
  YYSYMBOL_WAIT_OP = 152,                  /* WAIT_OP  */
  YYSYMBOL_FENCE_GLOBAL_OP = 153,          /* FENCE_GLOBAL_OP  */
  YYSYMBOL_FENCE_LOCAL_OP = 154,           /* FENCE_LOCAL_OP  */
  YYSYMBOL_FENCE_SW_OP = 155,              /* FENCE_SW_OP  */
  YYSYMBOL_YIELD_OP = 156,                 /* YIELD_OP  */
  YYSYMBOL_SAMPLE_3D_OP = 157,             /* SAMPLE_3D_OP  */
  YYSYMBOL_LOAD_3D_OP = 158,               /* LOAD_3D_OP  */
  YYSYMBOL_SAMPLE4_3D_OP = 159,            /* SAMPLE4_3D_OP  */
  YYSYMBOL_RESINFO_OP_3D = 160,            /* RESINFO_OP_3D  */
  YYSYMBOL_SAMPLEINFO_OP_3D = 161,         /* SAMPLEINFO_OP_3D  */
  YYSYMBOL_RTWRITE_OP_3D = 162,            /* RTWRITE_OP_3D  */
  YYSYMBOL_URBWRITE_OP_3D = 163,           /* URBWRITE_OP_3D  */
  YYSYMBOL_LIFETIME_START_OP = 164,        /* LIFETIME_START_OP  */
  YYSYMBOL_LIFETIME_END_OP = 165,          /* LIFETIME_END_OP  */
  YYSYMBOL_AVS_OP = 166,                   /* AVS_OP  */
  YYSYMBOL_BREAKPOINT_OP = 167,            /* BREAKPOINT_OP  */
  YYSYMBOL_CALL_OP = 168,                  /* CALL_OP  */
  YYSYMBOL_PRED_CNTL = 169,                /* PRED_CNTL  */
  YYSYMBOL_F32_LIT = 170,                  /* F32_LIT  */
  YYSYMBOL_F64_LIT = 171,                  /* F64_LIT  */
  YYSYMBOL_DEC_LIT = 172,                  /* DEC_LIT  */
  YYSYMBOL_HEX_LIT = 173,                  /* HEX_LIT  */
  YYSYMBOL_BUILTIN_SIZEOF = 174,           /* BUILTIN_SIZEOF  */
  YYSYMBOL_BUILTIN_DISPATCH_SIMD_SIZE = 175, /* BUILTIN_DISPATCH_SIMD_SIZE  */
  YYSYMBOL_QW_SCATTER_OP = 176,            /* QW_SCATTER_OP  */
  YYSYMBOL_LSC_CACHING_OPT = 177,          /* LSC_CACHING_OPT  */
  YYSYMBOL_OV = 178,                       /* OV  */
  YYSYMBOL_LSC_ADDR_SIZE_TK = 179,         /* LSC_ADDR_SIZE_TK  */
  YYSYMBOL_LSC_DATA_SHAPE_TK = 180,        /* LSC_DATA_SHAPE_TK  */
  YYSYMBOL_LSC_DATA_SHAPE_TK_CHMASK = 181, /* LSC_DATA_SHAPE_TK_CHMASK  */
  YYSYMBOL_LSC_DATA_SHAPE_TK_BLOCK2D = 182, /* LSC_DATA_SHAPE_TK_BLOCK2D  */
  YYSYMBOL_LSC_AM_FLAT = 183,              /* LSC_AM_FLAT  */
  YYSYMBOL_LSC_AM_BTI = 184,               /* LSC_AM_BTI  */
  YYSYMBOL_LSC_AM_BSS = 185,               /* LSC_AM_BSS  */
  YYSYMBOL_LSC_AM_SS = 186,                /* LSC_AM_SS  */
  YYSYMBOL_LSC_AM_ARG = 187,               /* LSC_AM_ARG  */
  YYSYMBOL_LSC_FENCE_OP_TYPE = 188,        /* LSC_FENCE_OP_TYPE  */
  YYSYMBOL_LSC_FENCE_SCOPE = 189,          /* LSC_FENCE_SCOPE  */
  YYSYMBOL_LSC_SFID_UNTYPED_TOKEN = 190,   /* LSC_SFID_UNTYPED_TOKEN  */
  YYSYMBOL_LSC_SFID_TYPED_TOKEN = 191,     /* LSC_SFID_TYPED_TOKEN  */
  YYSYMBOL_LSC_LOAD_MNEMONIC = 192,        /* LSC_LOAD_MNEMONIC  */
  YYSYMBOL_LSC_LOAD_STRIDED_MNEMONIC = 193, /* LSC_LOAD_STRIDED_MNEMONIC  */
  YYSYMBOL_LSC_LOAD_BLOCK2D_MNEMONIC = 194, /* LSC_LOAD_BLOCK2D_MNEMONIC  */
  YYSYMBOL_LSC_STORE_MNEMONIC = 195,       /* LSC_STORE_MNEMONIC  */
  YYSYMBOL_LSC_STORE_STRIDED_MNEMONIC = 196, /* LSC_STORE_STRIDED_MNEMONIC  */
  YYSYMBOL_LSC_STORE_BLOCK2D_MNEMONIC = 197, /* LSC_STORE_BLOCK2D_MNEMONIC  */
  YYSYMBOL_LSC_ATOMIC_MNEMONIC = 198,      /* LSC_ATOMIC_MNEMONIC  */
  YYSYMBOL_LSC_READ_STATE_INFO_MNEMONIC = 199, /* LSC_READ_STATE_INFO_MNEMONIC  */
  YYSYMBOL_LSC_LOAD_MSRT_MNEMONIC = 200,   /* LSC_LOAD_MSRT_MNEMONIC  */
  YYSYMBOL_LSC_STORE_MSRT_MNEMONIC = 201,  /* LSC_STORE_MSRT_MNEMONIC  */
  YYSYMBOL_LSC_FENCE_MNEMONIC = 202,       /* LSC_FENCE_MNEMONIC  */
  YYSYMBOL_FCVT_OP = 203,                  /* FCVT_OP  */
  YYSYMBOL_LSC_DATA_SHAPE_TK_TYPED_BLOCK2D = 204, /* LSC_DATA_SHAPE_TK_TYPED_BLOCK2D  */
  YYSYMBOL_YYACCEPT = 205,                 /* $accept  */
  YYSYMBOL_Listing = 206,                  /* Listing  */
  YYSYMBOL_ListingHeader = 207,            /* ListingHeader  */
  YYSYMBOL_Statements = 208,               /* Statements  */
  YYSYMBOL_Newlines = 209,                 /* Newlines  */
  YYSYMBOL_NewlinesOpt = 210,              /* NewlinesOpt  */
  YYSYMBOL_Statement = 211,                /* Statement  */
  YYSYMBOL_Scope = 212,                    /* Scope  */
  YYSYMBOL_ScopeStart = 213,               /* ScopeStart  */
  YYSYMBOL_ScopeEnd = 214,                 /* ScopeEnd  */
  YYSYMBOL_IdentOrStringLit = 215,         /* IdentOrStringLit  */
  YYSYMBOL_DirectiveKernel = 216,          /* DirectiveKernel  */
  YYSYMBOL_DirectiveGlobalFunction = 217,  /* DirectiveGlobalFunction  */
  YYSYMBOL_DirectiveVersion = 218,         /* DirectiveVersion  */
  YYSYMBOL_DirectiveDecl = 219,            /* DirectiveDecl  */
  YYSYMBOL_DeclFunction = 220,             /* DeclFunction  */
  YYSYMBOL_DeclVariable = 221,             /* DeclVariable  */
  YYSYMBOL_DeclAddress = 222,              /* DeclAddress  */
  YYSYMBOL_DeclPredicate = 223,            /* DeclPredicate  */
  YYSYMBOL_DeclSampler = 224,              /* DeclSampler  */
  YYSYMBOL_VNameEqOpt = 225,               /* VNameEqOpt  */
  YYSYMBOL_DeclSurface = 226,              /* DeclSurface  */
  YYSYMBOL_DirectiveInput = 227,           /* DirectiveInput  */
  YYSYMBOL_DirectiveImplicitInput = 228,   /* DirectiveImplicitInput  */
  YYSYMBOL_InputOffset = 229,              /* InputOffset  */
  YYSYMBOL_InputSize = 230,                /* InputSize  */
  YYSYMBOL_DirectiveAttr = 231,            /* DirectiveAttr  */
  YYSYMBOL_DirectiveFunc = 232,            /* DirectiveFunc  */
  YYSYMBOL_AlignAttrOpt = 233,             /* AlignAttrOpt  */
  YYSYMBOL_Align = 234,                    /* Align  */
  YYSYMBOL_AliasAttrOpt = 235,             /* AliasAttrOpt  */
  YYSYMBOL_OneAttr = 236,                  /* OneAttr  */
  YYSYMBOL_AttrOpt = 237,                  /* AttrOpt  */
  YYSYMBOL_GenAttrOpt = 238,               /* GenAttrOpt  */
  YYSYMBOL_Instruction = 239,              /* Instruction  */
  YYSYMBOL_Label = 240,                    /* Label  */
  YYSYMBOL_LogicInstruction = 241,         /* LogicInstruction  */
  YYSYMBOL_UnaryLogicInstruction = 242,    /* UnaryLogicInstruction  */
  YYSYMBOL_MathInstruction_2OPND = 243,    /* MathInstruction_2OPND  */
  YYSYMBOL_MathInstruction_3OPND = 244,    /* MathInstruction_3OPND  */
  YYSYMBOL_ArithInstruction_2OPND = 245,   /* ArithInstruction_2OPND  */
  YYSYMBOL_ArithInstruction_3OPND = 246,   /* ArithInstruction_3OPND  */
  YYSYMBOL_ArithInstruction_4OPND = 247,   /* ArithInstruction_4OPND  */
  YYSYMBOL_DpasInstruction = 248,          /* DpasInstruction  */
  YYSYMBOL_BfnInstruction = 249,           /* BfnInstruction  */
  YYSYMBOL_QwScatterInstruction = 250,     /* QwScatterInstruction  */
  YYSYMBOL_FCvtInstruction = 251,          /* FCvtInstruction  */
  YYSYMBOL_AntiTrigInstruction = 252,      /* AntiTrigInstruction  */
  YYSYMBOL_AddrAddInstruction = 253,       /* AddrAddInstruction  */
  YYSYMBOL_SetpInstruction = 254,          /* SetpInstruction  */
  YYSYMBOL_SelInstruction = 255,           /* SelInstruction  */
  YYSYMBOL_MinInstruction = 256,           /* MinInstruction  */
  YYSYMBOL_MaxInstruction = 257,           /* MaxInstruction  */
  YYSYMBOL_MovInstruction = 258,           /* MovInstruction  */
  YYSYMBOL_BreakpointInstruction = 259,    /* BreakpointInstruction  */
  YYSYMBOL_MovsInstruction = 260,          /* MovsInstruction  */
  YYSYMBOL_CmpInstruction = 261,           /* CmpInstruction  */
  YYSYMBOL_MediaInstruction = 262,         /* MediaInstruction  */
  YYSYMBOL_MediaInstructionPlaneID = 263,  /* MediaInstructionPlaneID  */
  YYSYMBOL_ScatterInstruction = 264,       /* ScatterInstruction  */
  YYSYMBOL_ScatterTypedInstruction = 265,  /* ScatterTypedInstruction  */
  YYSYMBOL_Scatter4ScaledInstruction = 266, /* Scatter4ScaledInstruction  */
  YYSYMBOL_ScatterScaledInstruction = 267, /* ScatterScaledInstruction  */
  YYSYMBOL_SynchronizationInstruction = 268, /* SynchronizationInstruction  */
  YYSYMBOL_DwordAtomicInstruction = 269,   /* DwordAtomicInstruction  */
  YYSYMBOL_TypedAtomicInstruction = 270,   /* TypedAtomicInstruction  */
  YYSYMBOL_Atomic16Opt = 271,              /* Atomic16Opt  */
  YYSYMBOL_SampleUnormInstruction = 272,   /* SampleUnormInstruction  */
  YYSYMBOL_SampleInstruction = 273,        /* SampleInstruction  */
  YYSYMBOL_SamplerAddrOperand = 274,       /* SamplerAddrOperand  */
  YYSYMBOL_Sample3dInstruction = 275,      /* Sample3dInstruction  */
  YYSYMBOL_CPSEnableOpt = 276,             /* CPSEnableOpt  */
  YYSYMBOL_NonUniformSamplerEnableOpt = 277, /* NonUniformSamplerEnableOpt  */
  YYSYMBOL_Load3dInstruction = 278,        /* Load3dInstruction  */
  YYSYMBOL_Gather43dInstruction = 279,     /* Gather43dInstruction  */
  YYSYMBOL_PixelNullMaskEnableOpt = 280,   /* PixelNullMaskEnableOpt  */
  YYSYMBOL_ResInfo3dInstruction = 281,     /* ResInfo3dInstruction  */
  YYSYMBOL_SampleInfo3dInstruction = 282,  /* SampleInfo3dInstruction  */
  YYSYMBOL_RTWriteOperands = 283,          /* RTWriteOperands  */
  YYSYMBOL_RTWriteInstruction = 284,       /* RTWriteInstruction  */
  YYSYMBOL_RTWriteModeOpt = 285,           /* RTWriteModeOpt  */
  YYSYMBOL_URBWriteInstruction = 286,      /* URBWriteInstruction  */
  YYSYMBOL_AVSInstruction = 287,           /* AVSInstruction  */
  YYSYMBOL_VMEInstruction = 288,           /* VMEInstruction  */
  YYSYMBOL_OwordInstruction = 289,         /* OwordInstruction  */
  YYSYMBOL_SvmInstruction = 290,           /* SvmInstruction  */
  YYSYMBOL_AtomicBitwidthOpt = 291,        /* AtomicBitwidthOpt  */
  YYSYMBOL_LscInstruction = 292,           /* LscInstruction  */
  YYSYMBOL_LscUntypedLoad = 293,           /* LscUntypedLoad  */
  YYSYMBOL_LscUntypedStridedLoad = 294,    /* LscUntypedStridedLoad  */
  YYSYMBOL_LscUntypedBlock2dLoad = 295,    /* LscUntypedBlock2dLoad  */
  YYSYMBOL_LscUntypedStore = 296,          /* LscUntypedStore  */
  YYSYMBOL_LscUntypedStridedStore = 297,   /* LscUntypedStridedStore  */
  YYSYMBOL_LscUntypedBlock2dStore = 298,   /* LscUntypedBlock2dStore  */
  YYSYMBOL_LscUntypedAtomic = 299,         /* LscUntypedAtomic  */
  YYSYMBOL_LscTypedMSRTLoad = 300,         /* LscTypedMSRTLoad  */
  YYSYMBOL_LscTypedMSRTStore = 301,        /* LscTypedMSRTStore  */
  YYSYMBOL_LscTypedLoad = 302,             /* LscTypedLoad  */
  YYSYMBOL_LscTypedStore = 303,            /* LscTypedStore  */
  YYSYMBOL_LscTypedAtomic = 304,           /* LscTypedAtomic  */
  YYSYMBOL_LscTypedReadStateInfo = 305,    /* LscTypedReadStateInfo  */
  YYSYMBOL_LscFence = 306,                 /* LscFence  */
  YYSYMBOL_LscSfid = 307,                  /* LscSfid  */
  YYSYMBOL_LscCacheOpts = 308,             /* LscCacheOpts  */
  YYSYMBOL_OVOpt = 309,                    /* OVOpt  */
  YYSYMBOL_LscUntypedAddrOperand = 310,    /* LscUntypedAddrOperand  */
  YYSYMBOL_LscUntypedStridedAddrOperand = 311, /* LscUntypedStridedAddrOperand  */
  YYSYMBOL_LscUntypedBlock2dAddrOperand = 312, /* LscUntypedBlock2dAddrOperand  */
  YYSYMBOL_LscTypedAddrWithOffsetOperand = 313, /* LscTypedAddrWithOffsetOperand  */
  YYSYMBOL_LscTypedAddrWithOffsetOperandList = 314, /* LscTypedAddrWithOffsetOperandList  */
  YYSYMBOL_LscTypedAddrOperandWithOffsets = 315, /* LscTypedAddrOperandWithOffsets  */
  YYSYMBOL_LscAddrImmOffsetOpt = 316,      /* LscAddrImmOffsetOpt  */
  YYSYMBOL_LscAddrImmScaleOpt = 317,       /* LscAddrImmScaleOpt  */
  YYSYMBOL_LscAddrModelOpt = 318,          /* LscAddrModelOpt  */
  YYSYMBOL_LscAddrModelStateful = 319,     /* LscAddrModelStateful  */
  YYSYMBOL_LscVectorOpRegOrImm32 = 320,    /* LscVectorOpRegOrImm32  */
  YYSYMBOL_LscVectorOpImm32 = 321,         /* LscVectorOpImm32  */
  YYSYMBOL_LscVectorOpReg = 322,           /* LscVectorOpReg  */
  YYSYMBOL_LscDataOperand = 323,           /* LscDataOperand  */
  YYSYMBOL_LscDataOperand2D = 324,         /* LscDataOperand2D  */
  YYSYMBOL_LscPayloadReg = 325,            /* LscPayloadReg  */
  YYSYMBOL_LscPayloadNonNullReg = 326,     /* LscPayloadNonNullReg  */
  YYSYMBOL_LscInstructionXe2 = 327,        /* LscInstructionXe2  */
  YYSYMBOL_LscTypedBlock2dLoad = 328,      /* LscTypedBlock2dLoad  */
  YYSYMBOL_LscTypedBlock2dStore = 329,     /* LscTypedBlock2dStore  */
  YYSYMBOL_LscTypedBlock2dAddrOperand = 330, /* LscTypedBlock2dAddrOperand  */
  YYSYMBOL_LscDataOperandTyped2D = 331,    /* LscDataOperandTyped2D  */
  YYSYMBOL_LscUntypedApndCtrAtomic = 332,  /* LscUntypedApndCtrAtomic  */
  YYSYMBOL_SwitchLabels = 333,             /* SwitchLabels  */
  YYSYMBOL_BranchInstruction = 334,        /* BranchInstruction  */
  YYSYMBOL_FILE = 335,                     /* FILE  */
  YYSYMBOL_LOC = 336,                      /* LOC  */
  YYSYMBOL_RawSendInstruction = 337,       /* RawSendInstruction  */
  YYSYMBOL_LifetimeStartInst = 338,        /* LifetimeStartInst  */
  YYSYMBOL_LifetimeEndInst = 339,          /* LifetimeEndInst  */
  YYSYMBOL_RawSendsInstruction = 340,      /* RawSendsInstruction  */
  YYSYMBOL_NullaryInstruction = 341,       /* NullaryInstruction  */
  YYSYMBOL_OwordModifier = 342,            /* OwordModifier  */
  YYSYMBOL_Predicate = 343,                /* Predicate  */
  YYSYMBOL_PredSign = 344,                 /* PredSign  */
  YYSYMBOL_PredCtrlOpt = 345,              /* PredCtrlOpt  */
  YYSYMBOL_SatModOpt = 346,                /* SatModOpt  */
  YYSYMBOL_SrcModifier = 347,              /* SrcModifier  */
  YYSYMBOL_ConditionalModifier = 348,      /* ConditionalModifier  */
  YYSYMBOL_VecDstOperand_A = 349,          /* VecDstOperand_A  */
  YYSYMBOL_VecDstOperand_G = 350,          /* VecDstOperand_G  */
  YYSYMBOL_VecDstOperand_G_I = 351,        /* VecDstOperand_G_I  */
  YYSYMBOL_VecSrcOperand_G_I_IMM_A_AO = 352, /* VecSrcOperand_G_I_IMM_A_AO  */
  YYSYMBOL_VecSrcOperand_G_I_IMM_A = 353,  /* VecSrcOperand_G_I_IMM_A  */
  YYSYMBOL_VecSrcOperand_G_I_IMM = 354,    /* VecSrcOperand_G_I_IMM  */
  YYSYMBOL_VecSrcOperand_G_IMM = 355,      /* VecSrcOperand_G_IMM  */
  YYSYMBOL_VecSrcOperand_G_IMM_AO = 356,   /* VecSrcOperand_G_IMM_AO  */
  YYSYMBOL_VecSrcOperand_G_A = 357,        /* VecSrcOperand_G_A  */
  YYSYMBOL_VecSrcOperand_G_A_AO = 358,     /* VecSrcOperand_G_A_AO  */
  YYSYMBOL_VecSrcOperand_G = 359,          /* VecSrcOperand_G  */
  YYSYMBOL_VecSrcOpndSimple = 360,         /* VecSrcOpndSimple  */
  YYSYMBOL_VMEOpndIME = 361,               /* VMEOpndIME  */
  YYSYMBOL_VMEOpndFBR = 362,               /* VMEOpndFBR  */
  YYSYMBOL_SrcStateOperand = 363,          /* SrcStateOperand  */
  YYSYMBOL_DstStateOperand = 364,          /* DstStateOperand  */
  YYSYMBOL_RawOperand = 365,               /* RawOperand  */
  YYSYMBOL_RawOperandNonNull = 366,        /* RawOperandNonNull  */
  YYSYMBOL_RawOperandOffsetSuffix = 367,   /* RawOperandOffsetSuffix  */
  YYSYMBOL_RawOperandArray = 368,          /* RawOperandArray  */
  YYSYMBOL_DstAddrOperand = 369,           /* DstAddrOperand  */
  YYSYMBOL_DstGeneralOperand = 370,        /* DstGeneralOperand  */
  YYSYMBOL_DstIndirectOperand = 371,       /* DstIndirectOperand  */
  YYSYMBOL_SrcAddrOfOperand = 372,         /* SrcAddrOfOperand  */
  YYSYMBOL_AddrOfVar = 373,                /* AddrOfVar  */
  YYSYMBOL_SrcAddrOperand = 374,           /* SrcAddrOperand  */
  YYSYMBOL_SrcGeneralOperand = 375,        /* SrcGeneralOperand  */
  YYSYMBOL_SrcImmOperand = 376,            /* SrcImmOperand  */
  YYSYMBOL_FloatLit = 377,                 /* FloatLit  */
  YYSYMBOL_DoubleFloatLit = 378,           /* DoubleFloatLit  */
  YYSYMBOL_SrcIndirectOperand = 379,       /* SrcIndirectOperand  */
  YYSYMBOL_DstRegion = 380,                /* DstRegion  */
  YYSYMBOL_SrcRegionDirect = 381,          /* SrcRegionDirect  */
  YYSYMBOL_SrcRegionIndirect = 382,        /* SrcRegionIndirect  */
  YYSYMBOL_IndirectVarAccess = 383,        /* IndirectVarAccess  */
  YYSYMBOL_TwoDimOffset = 384,             /* TwoDimOffset  */
  YYSYMBOL_PredVar = 385,                  /* PredVar  */
  YYSYMBOL_AddrVarAccess = 386,            /* AddrVarAccess  */
  YYSYMBOL_AddrVarAccessWithWidth = 387,   /* AddrVarAccessWithWidth  */
  YYSYMBOL_SIMDMode = 388,                 /* SIMDMode  */
  YYSYMBOL_ElemNum = 389,                  /* ElemNum  */
  YYSYMBOL_ExecSize = 390,                 /* ExecSize  */
  YYSYMBOL_ExecSizeInt = 391,              /* ExecSizeInt  */
  YYSYMBOL_Var = 392,                      /* Var  */
  YYSYMBOL_VarNonNull = 393,               /* VarNonNull  */
  YYSYMBOL_IntExp = 394,                   /* IntExp  */
  YYSYMBOL_IntExpCond = 395,               /* IntExpCond  */
  YYSYMBOL_IntExpAND = 396,                /* IntExpAND  */
  YYSYMBOL_IntExpXOR = 397,                /* IntExpXOR  */
  YYSYMBOL_IntExpOR = 398,                 /* IntExpOR  */
  YYSYMBOL_IntExpCmp = 399,                /* IntExpCmp  */
  YYSYMBOL_IntExpRel = 400,                /* IntExpRel  */
  YYSYMBOL_IntExpNRA = 401,                /* IntExpNRA  */
  YYSYMBOL_IntExpShift = 402,              /* IntExpShift  */
  YYSYMBOL_IntExpAdd = 403,                /* IntExpAdd  */
  YYSYMBOL_IntExpMul = 404,                /* IntExpMul  */
  YYSYMBOL_IntExpUnr = 405,                /* IntExpUnr  */
  YYSYMBOL_IntExpPrim = 406,               /* IntExpPrim  */
  YYSYMBOL_DataType = 407,                 /* DataType  */
  YYSYMBOL_DataTypeIntOrVector = 408,      /* DataTypeIntOrVector  */
  YYSYMBOL_BuildOptions = 409              /* BuildOptions  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  5
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   3181

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  205
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  205
/* YYNRULES -- Number of rules.  */
#define YYNRULES  469
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1203

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   459


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   677,   677,   682,   684,   684,   686,   686,   687,   687,
     690,   691,   692,   693,   694,   695,   696,   697,   698,   699,
     700,   705,   706,   707,   711,   715,   718,   718,   725,   733,
     741,   748,   749,   750,   751,   752,   753,   755,   762,   770,
     778,   785,   789,   789,   792,   800,   805,   817,   824,   832,
     832,   833,   839,   843,   847,   851,   856,   862,   862,   864,
     868,   874,   881,   887,   892,   897,   903,   907,   911,   917,
     922,   928,   932,   942,   943,   944,   945,   946,   947,   948,
     949,   950,   951,   952,   953,   954,   955,   956,   957,   958,
     959,   960,   961,   962,   963,   964,   965,   966,   967,   968,
     969,   970,   971,   972,   973,   974,   975,   976,   977,   978,
     979,   980,   981,   982,   983,   984,   985,   986,   987,   988,
     989,   990,   991,   992,   993,   995,   999,  1005,  1010,  1016,
    1023,  1029,  1036,  1043,  1050,  1057,  1067,  1076,  1083,  1090,
    1099,  1109,  1115,  1122,  1128,  1137,  1147,  1154,  1161,  1169,
    1178,  1185,  1192,  1198,  1204,  1210,  1216,  1234,  1241,  1251,
    1259,  1266,  1273,  1282,  1291,  1300,  1308,  1311,  1314,  1317,
    1320,  1323,  1328,  1335,  1343,  1344,  1350,  1363,  1371,  1378,
    1383,  1388,  1405,  1405,  1407,  1407,  1410,  1427,  1445,  1445,
    1448,  1456,  1464,  1467,  1471,  1477,  1490,  1490,  1494,  1502,
    1514,  1530,  1536,  1549,  1557,  1564,  1572,  1578,  1584,  1590,
    1596,  1603,  1604,  1613,  1614,  1615,  1617,  1618,  1619,  1621,
    1624,  1625,  1626,  1627,  1628,  1629,  1631,  1659,  1692,  1722,
    1750,  1777,  1805,  1834,  1861,  1894,  1934,  1978,  2023,  2059,
    2098,  2103,  2103,  2106,  2107,  2109,  2109,  2113,  2122,  2128,
    2137,  2157,  2177,  2197,  2217,  2224,  2228,  2231,  2236,  2239,
    2244,  2250,  2258,  2271,  2272,  2273,  2278,  2279,  2282,  2283,
    2284,  2285,  2289,  2292,  2295,  2298,  2301,  2304,  2309,  2309,
    2313,  2323,  2331,  2339,  2353,  2357,  2363,  2368,  2371,  2375,
    2378,  2384,  2386,  2387,  2399,  2428,  2450,  2462,  2473,  2482,
    2504,  2507,  2510,  2517,  2521,  2525,  2529,  2535,  2540,  2547,
    2554,  2559,  2564,  2570,  2577,  2584,  2590,  2596,  2604,  2612,
    2620,  2630,  2635,  2640,  2645,  2650,  2655,  2660,  2665,  2670,
    2670,  2676,  2681,  2686,  2686,  2688,  2688,  2691,  2691,  2694,
    2695,  2696,  2697,  2699,  2699,  2704,  2705,  2707,  2708,  2712,
    2713,  2716,  2717,  2720,  2721,  2722,  2725,  2726,  2729,  2730,
    2731,  2734,  2735,  2738,  2739,  2741,  2743,  2753,  2760,  2768,
    2776,  2795,  2807,  2814,  2826,  2831,  2838,  2843,  2851,  2859,
    2865,  2870,  2892,  2896,  2902,  2912,  2920,  2927,  2937,  2943,
    2950,  2954,  2959,  2963,  2969,  2970,  2977,  2985,  2986,  2992,
    3002,  3010,  3019,  3037,  3051,  3054,  3065,  3076,  3081,  3086,
    3094,  3103,  3115,  3129,  3131,  3142,  3154,  3160,  3168,  3177,
    3177,  3178,  3178,  3181,  3183,  3184,  3186,  3187,  3189,  3190,
    3192,  3193,  3195,  3196,  3197,  3199,  3200,  3201,  3202,  3203,
    3222,  3225,  3226,  3227,  3228,  3230,  3231,  3232,  3234,  3235,
    3240,  3245,  3247,  3248,  3249,  3250,  3254,  3255,  3257,  3261,
    3265,  3271,  3280,  3281,  3282,  3283,  3284,  3286,  3287,  3290
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "ALIGN_KEYWORD",
  "ATOMIC_SUB_OP", "DIRECTIVE_DECL", "DIRECTIVE_FUNC",
  "DIRECTIVE_FUNCDECL", "DIRECTIVE_GLOBAL_FUNC", "DIRECTIVE_IMPLICIT",
  "DIRECTIVE_INPUT", "DIRECTIVE_KERNEL", "DIRECTIVE_KERNEL_ATTR",
  "DIRECTIVE_VERSION", "ALIAS_EQ", "ALIGN_EQ", "ATTR_EQ", "OFFSET_EQ",
  "NUM_ELTS_EQ", "V_NAME_EQ", "SIZE_EQ", "V_TYPE_EQ_G", "V_TYPE_EQ_P",
  "V_TYPE_EQ_A", "V_TYPE_EQ_S", "V_TYPE_EQ_T", "CPS",
  "NON_UNIFORM_SAMPLER", "PIXEL_NULL_MASK", "RAW_SEND_STRING",
  "RAW_SENDC_STRING", "RAW_SENDS_STRING", "RAW_SENDS_EOT_STRING",
  "RAW_SENDSC_STRING", "RAW_SENDSC_EOT_STRING", "SAT", "SRCMOD_ABS",
  "SRCMOD_NEG", "SRCMOD_NEGABS", "SRCMOD_NOT", "BFN_OP", "DPAS_OP",
  "SVM_ALIGNED", "SVM_UNALIGNED", "NBARRIER_SIGNAL", "NBARRIER_WAIT",
  "ITYPE", "DECL_DATA_TYPE", "DFTYPE", "FTYPE", "HFTYPE", "BFTYPE",
  "VTYPE", "COND_MOD", "LANGLE", "RANGLE", "LBRACK", "RBRACK",
  "IND_LBRACK", "LPAREN", "RPAREN", "LBRACE", "RBRACE", "DOT", "COMMA",
  "SEMI", "COLON", "SLASH", "PERCENT", "EQUALS", "PLUS", "MINUS", "TIMES",
  "AMP", "CIRC", "PIPE", "TILDE", "BANG", "QUESTION", "LEQ", "GEQ", "EQ",
  "NEQ", "SHL", "SHRS", "SHRZ", "LABEL", "IDENT", "BUILTIN_NULL",
  "BUILTIN", "STRING_LIT", "NEWLINE", "BUILD_OPTION_LINE", "UNIFORM",
  "RTWRITE_OPTION", "MEDIA_MODE", "OWORD_MODIFIER", "SAMPLER_CHANNEL",
  "CHANNEL_OUTPUT", "EXECMODE", "CNTRL", "FENCE_OPTIONS", "ADDR_ADD_OP",
  "UNARY_LOGIC_OP", "BINARY_LOGIC_OP", "TERNARY_LOGIC_OP",
  "QUATERNARY_LOGIC_OP", "SEL_OP", "MIN_OP", "MAX_OP", "ANTI_TRIG_OP",
  "MATH2_OP", "MATH3_OP", "ARITH2_OP", "ARITH3_OP", "ARITH4_OP",
  "ARITH4_OP2", "ARITH5_OP2", "CMP_OP", "SVM_OP", "SVM_SCATTER_OP",
  "SVM_GATHER4SCALED_OP", "SVM_SCATTER4SCALED_OP", "SVM_ATOMIC_OP",
  "OWORD_OP", "MEDIA_OP", "SCATTER_OP", "SCATTER_TYPED_OP",
  "SCATTER_SCALED_OP", "SCATTER4_SCALED_OP", "BARRIER_OP",
  "SBARRIER_SIGNAL", "SBARRIER_WAIT", "DWORD_ATOMIC_OP", "TYPED_ATOMIC_OP",
  "SAMPLE_OP", "SAMPLE_UNORM_OP", "VME_IME_OP", "VME_SIC_OP", "VME_FBR_OP",
  "BRANCH_OP", "RET_OP", "IFCALL", "FCALL", "FADDR", "SWITCHJMP_OP",
  "MOVS_OP", "SETP_OP", "MOV_OP", "FILE_OP", "LOC_OP", "CACHE_FLUSH_OP",
  "WAIT_OP", "FENCE_GLOBAL_OP", "FENCE_LOCAL_OP", "FENCE_SW_OP",
  "YIELD_OP", "SAMPLE_3D_OP", "LOAD_3D_OP", "SAMPLE4_3D_OP",
  "RESINFO_OP_3D", "SAMPLEINFO_OP_3D", "RTWRITE_OP_3D", "URBWRITE_OP_3D",
  "LIFETIME_START_OP", "LIFETIME_END_OP", "AVS_OP", "BREAKPOINT_OP",
  "CALL_OP", "PRED_CNTL", "F32_LIT", "F64_LIT", "DEC_LIT", "HEX_LIT",
  "BUILTIN_SIZEOF", "BUILTIN_DISPATCH_SIMD_SIZE", "QW_SCATTER_OP",
  "LSC_CACHING_OPT", "OV", "LSC_ADDR_SIZE_TK", "LSC_DATA_SHAPE_TK",
  "LSC_DATA_SHAPE_TK_CHMASK", "LSC_DATA_SHAPE_TK_BLOCK2D", "LSC_AM_FLAT",
  "LSC_AM_BTI", "LSC_AM_BSS", "LSC_AM_SS", "LSC_AM_ARG",
  "LSC_FENCE_OP_TYPE", "LSC_FENCE_SCOPE", "LSC_SFID_UNTYPED_TOKEN",
  "LSC_SFID_TYPED_TOKEN", "LSC_LOAD_MNEMONIC", "LSC_LOAD_STRIDED_MNEMONIC",
  "LSC_LOAD_BLOCK2D_MNEMONIC", "LSC_STORE_MNEMONIC",
  "LSC_STORE_STRIDED_MNEMONIC", "LSC_STORE_BLOCK2D_MNEMONIC",
  "LSC_ATOMIC_MNEMONIC", "LSC_READ_STATE_INFO_MNEMONIC",
  "LSC_LOAD_MSRT_MNEMONIC", "LSC_STORE_MSRT_MNEMONIC",
  "LSC_FENCE_MNEMONIC", "FCVT_OP", "LSC_DATA_SHAPE_TK_TYPED_BLOCK2D",
  "$accept", "Listing", "ListingHeader", "Statements", "Newlines",
  "NewlinesOpt", "Statement", "Scope", "ScopeStart", "ScopeEnd",
  "IdentOrStringLit", "DirectiveKernel", "DirectiveGlobalFunction",
  "DirectiveVersion", "DirectiveDecl", "DeclFunction", "DeclVariable",
  "DeclAddress", "DeclPredicate", "DeclSampler", "VNameEqOpt",
  "DeclSurface", "DirectiveInput", "DirectiveImplicitInput", "InputOffset",
  "InputSize", "DirectiveAttr", "DirectiveFunc", "AlignAttrOpt", "Align",
  "AliasAttrOpt", "OneAttr", "AttrOpt", "GenAttrOpt", "Instruction",
  "Label", "LogicInstruction", "UnaryLogicInstruction",
  "MathInstruction_2OPND", "MathInstruction_3OPND",
  "ArithInstruction_2OPND", "ArithInstruction_3OPND",
  "ArithInstruction_4OPND", "DpasInstruction", "BfnInstruction",
  "QwScatterInstruction", "FCvtInstruction", "AntiTrigInstruction",
  "AddrAddInstruction", "SetpInstruction", "SelInstruction",
  "MinInstruction", "MaxInstruction", "MovInstruction",
  "BreakpointInstruction", "MovsInstruction", "CmpInstruction",
  "MediaInstruction", "MediaInstructionPlaneID", "ScatterInstruction",
  "ScatterTypedInstruction", "Scatter4ScaledInstruction",
  "ScatterScaledInstruction", "SynchronizationInstruction",
  "DwordAtomicInstruction", "TypedAtomicInstruction", "Atomic16Opt",
  "SampleUnormInstruction", "SampleInstruction", "SamplerAddrOperand",
  "Sample3dInstruction", "CPSEnableOpt", "NonUniformSamplerEnableOpt",
  "Load3dInstruction", "Gather43dInstruction", "PixelNullMaskEnableOpt",
  "ResInfo3dInstruction", "SampleInfo3dInstruction", "RTWriteOperands",
  "RTWriteInstruction", "RTWriteModeOpt", "URBWriteInstruction",
  "AVSInstruction", "VMEInstruction", "OwordInstruction", "SvmInstruction",
  "AtomicBitwidthOpt", "LscInstruction", "LscUntypedLoad",
  "LscUntypedStridedLoad", "LscUntypedBlock2dLoad", "LscUntypedStore",
  "LscUntypedStridedStore", "LscUntypedBlock2dStore", "LscUntypedAtomic",
  "LscTypedMSRTLoad", "LscTypedMSRTStore", "LscTypedLoad", "LscTypedStore",
  "LscTypedAtomic", "LscTypedReadStateInfo", "LscFence", "LscSfid",
  "LscCacheOpts", "OVOpt", "LscUntypedAddrOperand",
  "LscUntypedStridedAddrOperand", "LscUntypedBlock2dAddrOperand",
  "LscTypedAddrWithOffsetOperand", "LscTypedAddrWithOffsetOperandList",
  "LscTypedAddrOperandWithOffsets", "LscAddrImmOffsetOpt",
  "LscAddrImmScaleOpt", "LscAddrModelOpt", "LscAddrModelStateful",
  "LscVectorOpRegOrImm32", "LscVectorOpImm32", "LscVectorOpReg",
  "LscDataOperand", "LscDataOperand2D", "LscPayloadReg",
  "LscPayloadNonNullReg", "LscInstructionXe2", "LscTypedBlock2dLoad",
  "LscTypedBlock2dStore", "LscTypedBlock2dAddrOperand",
  "LscDataOperandTyped2D", "LscUntypedApndCtrAtomic", "SwitchLabels",
  "BranchInstruction", "FILE", "LOC", "RawSendInstruction",
  "LifetimeStartInst", "LifetimeEndInst", "RawSendsInstruction",
  "NullaryInstruction", "OwordModifier", "Predicate", "PredSign",
  "PredCtrlOpt", "SatModOpt", "SrcModifier", "ConditionalModifier",
  "VecDstOperand_A", "VecDstOperand_G", "VecDstOperand_G_I",
  "VecSrcOperand_G_I_IMM_A_AO", "VecSrcOperand_G_I_IMM_A",
  "VecSrcOperand_G_I_IMM", "VecSrcOperand_G_IMM", "VecSrcOperand_G_IMM_AO",
  "VecSrcOperand_G_A", "VecSrcOperand_G_A_AO", "VecSrcOperand_G",
  "VecSrcOpndSimple", "VMEOpndIME", "VMEOpndFBR", "SrcStateOperand",
  "DstStateOperand", "RawOperand", "RawOperandNonNull",
  "RawOperandOffsetSuffix", "RawOperandArray", "DstAddrOperand",
  "DstGeneralOperand", "DstIndirectOperand", "SrcAddrOfOperand",
  "AddrOfVar", "SrcAddrOperand", "SrcGeneralOperand", "SrcImmOperand",
  "FloatLit", "DoubleFloatLit", "SrcIndirectOperand", "DstRegion",
  "SrcRegionDirect", "SrcRegionIndirect", "IndirectVarAccess",
  "TwoDimOffset", "PredVar", "AddrVarAccess", "AddrVarAccessWithWidth",
  "SIMDMode", "ElemNum", "ExecSize", "ExecSizeInt", "Var", "VarNonNull",
  "IntExp", "IntExpCond", "IntExpAND", "IntExpXOR", "IntExpOR",
  "IntExpCmp", "IntExpRel", "IntExpNRA", "IntExpShift", "IntExpAdd",
  "IntExpMul", "IntExpUnr", "IntExpPrim", "DataType",
  "DataTypeIntOrVector", "BuildOptions", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-1079)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-457)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     -34, -1079,    72,    13,    84, -1079, -1079,   -36,   -34, -1079,
      88,  2978,   -13,   110,    23,   116,    23,   132,   149,    23,
     152,   163,   939,   939,   173, -1079, -1079, -1079,   163,   202,
      33,   191,   162,   210, -1079, -1079, -1079,   181,   199,   244,
     229,   254,    23,   163,   163,   163,   237,   147, -1079,  2025,
     220,   252, -1079, -1079,   258,   264,   287,   301,   293, -1079,
     -67,   363,   -34, -1079, -1079,  2774, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
    1208, -1079, -1079,   269, -1079, -1079, -1079, -1079, -1079,   384,
     384, -1079,   334,   -43,   291, -1079, -1079, -1079, -1079,   229,
     667,   295,   667,   667, -1079, -1079, -1079, -1079, -1079,   117,
     347,     0, -1079,    -7,   939, -1079, -1079, -1079, -1079, -1079,
   -1079,   359,   365, -1079,     8, -1079, -1079, -1079,   229,   229,
   -1079,   163,   163,   163,   939, -1079,   163,   365,   263,   163,
     381,   343,   275,   229,   291,   939,   229,    -7,   939,   229,
     229, -1079, -1079,   229, -1079, -1079, -1079, -1079, -1079,   163,
     163, -1079, -1079,   229, -1079, -1079,   260, -1079,   163,  2571,
   -1079, -1079,  1387,   163,   163,   210,   210,   210,   210,   363,
     363,   363,   363,   363,   363,   363,   363,   363,   363,   363,
     363,   363,   363,   163,   163,   386,   354,   355,   452,   360,
     395,   362,   456,   457,   163,   163,   -10,   163,   363,   435,
     435,   435,   370,   163,   163,   409,   -19,   284,     1,   146,
     285,   160,   174,   282,   290,   292,   429,   459,   464,   466,
     467,   667,    80,   468,   453, -1079,   432,   425,   430,   291,
   -1079,   431,     6,   436,   667, -1079, -1079,   437, -1079,    -5,
     422,   423, -1079,   286,    -2, -1079,    55,    63, -1079,   135,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
     412, -1079,   359,   365,   939,   667, -1079,   283,   667,   446,
   -1079, -1079, -1079,   332, -1079,    28, -1079, -1079,   445,    -7,
     939,   939,   291,   229,   229, -1079,   191,   333,   229,   229,
     442,   291,   291,   443,   291, -1079, -1079, -1079,   461,    73,
     454,   229,   939, -1079,    98,   939,     2,     2,   229,   327,
     229, -1079, -1079,   -34, -1079,   345,   346,   210,   210,   210,
     210,   163,   163,   163,   163,   163,   163,   163,   163,   163,
     163,   163,   163,   163,   163,    -7,    -7,   349,   163,   163,
     460,   163,   353,   163,   465,   465,    23, -1079,   163,   939,
     440,   163, -1079,   505,   439,   447, -1079,   163,   361,    23,
     376,   357,   357,   357,   357,   357,   357,   357,   357,   357,
     357,   357,   357,   323,   357,   357,   524,   667,   667,   667,
     667, -1079,   488,   667,   538, -1079, -1079, -1079, -1079, -1079,
     383,   385,   291,   -25, -1079, -1079,   667,   667, -1079,   667,
     667,   667,   667,   667,   667,   667,   667,   667,   667,   667,
     667,   667,   667,   667,   667,   667,   667,   496,   283,   446,
     939,   320,    54, -1079, -1079, -1079, -1079, -1079, -1079,   494,
     667, -1079, -1079,   499,   229, -1079,  1908, -1079, -1079,   504,
   -1079, -1079,   502,   667,   939,   939,    73,   291,   291, -1079,
     939,  1122,   229,   507,   323,   229,   393,   291,   291,   939,
     291,   667,   283, -1079,   461,    -8, -1079,   509, -1079, -1079,
     511,   667, -1079,   229,   291, -1079,   291,   939, -1079,  2025,
     510,   410,   411,   210,   210,   210,   210,    -7,    -7,    -7,
      -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,    -7,
      -7,    -7,   229,   518,   939,   939,   433,   163,   229,   163,
     229,   438,   163,   163, -1079,   939,   448,   450,    -7, -1079,
     557,   163,   163,   229,   462, -1079,   163,   426,   434,   163,
     163,   163,   323,   163,   163,   163,   163,   231,   163,   163,
     430,   231, -1079, -1079,   431,   163,   163,   667,   538,   538,
     588,   588,   522, -1079, -1079,   551, -1079,   229,   667, -1079,
     562,   564,   422,   -11,   423, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079,    63,    63,   348,   348,   348, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079,   463,   667,   667,   667,   566, -1079,
   -1079, -1079, -1079, -1079, -1079,   667,   667,   569,   939,   939,
   -1079, -1079,   291,   177,   939,   939,   939, -1079,   291,   291,
     939,   572,   291, -1079,   589,   291,   578, -1079, -1079,    -8,
      -8,   576,   667,   667,   168,   590,   291, -1079,   939, -1079,
   -1079,   486,   489,   210,   210,   163,   163,   939,   939,   229,
     939,   229,   939,   939,   939,   939,   939,   939,   939,   939,
     939,   939,   939,   939,   939,   493,   291,   291, -1079,   291,
     291,   229,   939, -1079,   229,   229,   495,   498,   500,   798,
     798,    99, -1079,   563,   939,   939, -1079,   291,   229, -1079,
   -1079,   163,   323,   323,   323,   469,   231,   161,   231,   161,
     491,   620,   621,   622,   626,   323,   323,   323,   627,   323,
     231,   669, -1079, -1079,   598,   538,   538,   618, -1079,   145,
   -1079, -1079,   365,   628, -1079, -1079,   667,   634,   629,   631,
     635,   182,   640, -1079, -1079, -1079,   939,   291,   291,   291,
     291,   939, -1079,   291,   939, -1079, -1079, -1079, -1079, -1079,
     637,   188, -1079,    40, -1079,   939,  2025,  2025,   163,   163,
    2025,  2025,   939, -1079, -1079,   939,   229,   939,   939,   939,
     939,   939, -1079, -1079,   939, -1079,   939,   939,   939,   939,
     163,   291,   291,   291,   291,   939,   291,   291,   291,   527,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,   502,
     163,     2,     2,  2049,   291,   291,   323,   231,   240,   161,
     491,   531, -1079, -1079, -1079, -1079,   323,   658, -1079,   323,
     659, -1079,   323,   660,   661,   323,   366,   366,   366,   366,
   -1079,   161,   231,   222,   231,   323,   102,   705, -1079, -1079,
   -1079, -1079,   600, -1079,   522, -1079, -1079, -1079, -1079,   667,
   -1079, -1079,   667,   291, -1079,   291,   291,   291,   939,   291,
     662, -1079,   663,   939,   291,   291,  2025,  2025,  2025,  2025,
     939, -1079, -1079,   939,   939, -1079, -1079, -1079, -1079, -1079,
     939, -1079, -1079,   291, -1079, -1079,   291,   291,   291,   291,
     291,   291, -1079,   939,   291,     2, -1079, -1079,   291,   291,
     161, -1079, -1079, -1079, -1079, -1079, -1079, -1079,    40, -1079,
     222, -1079,    40,   229, -1079,   189, -1079, -1079,   238, -1079,
     242,   248,   657,   356,   323,   323,   323,   668, -1079,   431,
   -1079, -1079, -1079, -1079, -1079, -1079,   670,   538, -1079, -1079,
   -1079,   672,   674, -1079, -1079, -1079,   291,   939,   291, -1079,
   -1079,   939,   291,   291,  2025,  2025,   291,   291, -1079, -1079,
     939, -1079,   291,   291,   291,   291, -1079,   291,   291,     2,
     291,   291,   291, -1079, -1079,   222,   664,   666,   677,   358,
     222,    58, -1079,   667,   667,   559, -1079,   667, -1079,   667,
     667,   667,   667,   671,   323, -1079,   323, -1079,    31, -1079,
   -1079, -1079, -1079,   291, -1079,   939, -1079, -1079,   291,   291,
     291,   291, -1079, -1079, -1079,   291, -1079,   291,   291,     2,
   -1079,   291, -1079,   356, -1079,   222,   561,   667,   667,   356,
     366,   682,   685,   678, -1079,   686,   687,   691,   348,    63,
     229, -1079, -1079, -1079,   689, -1079,   939,   291,   291,   291,
     291, -1079, -1079,   291,   291,   291, -1079,   697,   692, -1079,
      63,    63,    38,   693,   667, -1079,   667, -1079, -1079, -1079,
     356,   667,   655,   291,   291, -1079, -1079,   291,   291, -1079,
     291,   581,   222,   366,   366,   694,   701,   707,   710,   939,
   -1079, -1079,   291, -1079, -1079,   706,   712,   713,   667, -1079,
   -1079, -1079,   679, -1079,   291,   222,   592,   366,   719,   939,
   -1079, -1079,   721,   726,   291,   366, -1079, -1079,   722,   356,
     366,   723,   731,   356,   366, -1079,   733,   734,   356, -1079,
   -1079,   739, -1079
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       8,     7,     0,     9,     0,     1,     6,     0,     8,     3,
       0,   331,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   333,    24,   125,   469,     0,   343,
       0,   329,     0,     0,   166,   167,   168,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
     324,   326,   328,   323,     0,     0,     0,     0,     0,   153,
       0,   337,     8,     5,    19,     0,    11,    12,    10,    36,
      31,    32,    33,    34,    35,    14,    13,    16,    15,    17,
      18,    73,    75,    76,    77,    78,    79,    80,   118,   119,
     120,   122,    81,    82,   103,   100,   101,   102,    99,   124,
      98,    83,    84,    86,    87,    89,    88,    90,    92,    93,
      95,    94,   108,   109,   110,   111,   112,   113,   114,    97,
      96,    85,    74,   121,   213,   214,   215,   216,   217,   218,
     219,   224,   225,   220,   221,   222,   223,   226,   123,   292,
     293,   291,    91,   104,   105,   106,   115,   116,   107,   117,
       0,    20,    30,     0,    26,    27,    56,    37,    29,    49,
      49,    28,    54,     0,     0,   340,   339,   341,   342,     0,
       0,     0,     0,     0,   421,   420,   422,   394,   397,   456,
     457,     0,   461,     0,     0,   353,   365,   355,   390,   392,
     354,     0,     0,   419,     0,   455,   171,   334,     0,     0,
     344,     0,     0,     0,     0,   330,     0,     0,     0,     0,
     413,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   311,   312,     0,   322,   356,   357,   325,   327,     0,
       0,   315,   316,     0,   241,   242,     0,   338,     0,   331,
       2,    23,   331,     0,     0,     0,     0,     0,     0,   337,
     337,   337,   337,   337,   337,   337,   337,   337,   337,   337,
     337,   337,   337,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   337,   188,
     188,   188,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    71,    46,    55,   418,     0,     0,     0,     0,
     371,     0,     0,     0,     0,   456,   457,     0,   423,   425,
     427,   429,   431,   434,   439,   440,   444,   447,   451,   457,
     391,   393,   452,   453,   454,   398,   395,   399,   396,   389,
       0,   459,     0,     0,   170,     0,   404,     0,     0,     0,
     467,   468,   388,   335,   410,     0,   345,   378,     0,     0,
       0,     0,     0,     0,     0,   415,   329,     0,     0,     0,
       0,     0,     0,     0,     0,   310,   347,   348,     0,     0,
       0,     0,     0,   346,     0,     0,     0,     0,     0,     0,
       0,     4,    25,     8,    21,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     211,     0,     0,     0,   174,   174,     0,   305,     0,     0,
       0,     0,   189,   182,     0,     0,   197,     0,     0,     0,
       0,   243,   243,   243,   243,   243,   243,   243,   243,   243,
     243,   243,   243,     0,   243,   243,     0,     0,     0,     0,
       0,    50,     0,     0,    71,    48,    45,    52,    53,   416,
       0,     0,     0,     0,   373,   408,     0,     0,   458,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   439,   463,   464,   465,   466,   400,   462,     0,
       0,   386,   336,     0,     0,   363,     0,   361,   364,   382,
     362,   385,     0,     0,     0,     0,   410,     0,     0,   206,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   380,     0,   300,   155,     0,   156,   154,
       0,     0,   146,     0,     0,   179,     0,     0,   240,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   303,     0,     0,     0,     0,   183,
     184,     0,     0,     0,     0,   304,     0,     0,   245,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     420,     0,   287,   288,   419,     0,     0,     0,    71,    71,
      42,    42,     0,    51,    47,     0,   372,     0,     0,   374,
       0,     0,   426,     0,   428,   430,   432,   433,   435,   436,
     437,   438,   445,   446,   441,   442,   443,   449,   450,   448,
     460,   401,   387,   169,     0,     0,   406,     0,     0,   332,
     384,   145,   358,   360,   359,     0,     0,     0,     0,     0,
     204,   205,     0,   161,     0,     0,     0,   414,     0,     0,
       0,     0,     0,   201,     0,     0,     0,   381,   379,   300,
     300,     0,     0,     0,     0,     0,     0,   191,     0,   143,
      22,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   212,     0,
       0,     0,     0,   175,     0,     0,     0,     0,     0,     0,
       0,     0,   185,     0,     0,     0,   192,     0,     0,   244,
     246,     0,     0,     0,     0,     0,     0,   268,     0,   268,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    57,    40,    39,     0,    71,    71,    68,    70,     0,
     417,   140,     0,     0,   407,   411,     0,     0,     0,     0,
       0,     0,     0,   158,   157,   203,     0,     0,     0,     0,
       0,     0,   367,     0,     0,   202,   402,   301,   302,   306,
       0,     0,   370,     0,   190,     0,     0,     0,     0,     0,
       0,     0,     0,   130,   131,     0,     0,     0,     0,     0,
       0,     0,   144,   132,     0,   134,     0,     0,     0,   136,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     308,   307,   151,   349,   351,   350,   352,   150,   152,   410,
       0,     0,     0,   195,     0,     0,     0,     0,     0,   268,
       0,     0,   298,   294,   269,   270,     0,     0,   271,     0,
       0,   249,     0,     0,     0,     0,     0,     0,     0,     0,
     295,   268,     0,     0,     0,     0,     0,    63,    58,    43,
      41,    44,     0,    72,     0,   366,   375,   424,   405,     0,
     409,   383,     0,     0,   160,     0,     0,     0,     0,     0,
       0,   369,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   126,   127,     0,     0,   147,   148,   149,   133,   135,
       0,   138,   139,     0,   209,   210,     0,     0,     0,     0,
       0,     0,   309,     0,     0,     0,   193,   194,     0,     0,
     268,   236,   284,   285,   228,   229,   286,   230,   266,   237,
       0,   231,   266,     0,   232,     0,   279,   278,   281,   280,
       0,     0,     0,   263,     0,   271,     0,     0,   289,   290,
     234,   235,    62,    59,    60,    61,     0,    71,    67,    66,
      69,     0,     0,   159,   162,   178,     0,     0,     0,   368,
     180,     0,     0,     0,     0,     0,     0,     0,   141,   128,
       0,   137,     0,     0,     0,     0,   164,     0,     0,     0,
       0,     0,     0,   142,   227,     0,     0,   258,     0,   255,
       0,     0,   276,     0,     0,     0,   272,     0,   274,     0,
       0,     0,     0,     0,     0,   299,     0,   239,     0,    38,
     403,   412,   177,     0,   200,     0,   313,   314,     0,     0,
       0,     0,   129,   207,   208,     0,   165,     0,     0,     0,
     376,     0,   198,   263,   267,     0,     0,     0,     0,   263,
       0,     0,     0,     0,   282,     0,     0,     0,   264,   265,
       0,   233,   238,    65,     0,   176,     0,     0,     0,     0,
       0,   163,   172,     0,     0,   186,   376,     0,   259,   262,
     256,   257,     0,     0,     0,   277,     0,   273,   275,   296,
     263,     0,     0,     0,     0,   319,   320,     0,     0,   377,
     187,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,     0,   376,   247,   260,     0,     0,     0,   283,
     297,    64,     0,   173,   181,     0,     0,     0,     0,     0,
     261,   248,     0,     0,     0,     0,   254,   199,     0,   263,
       0,     0,     0,   263,     0,   251,     0,     0,   263,   252,
     253,     0,   250
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1079, -1079, -1079,   558,   -44,     9,   560, -1079, -1079,   241,
      -3, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
     171, -1079, -1079, -1079,   644,   503, -1079, -1079, -1079, -1079,
   -1079,  -107, -1079,  -461, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079,   387, -1079, -1079,  -361,
   -1079, -1079, -1079, -1079, -1079,   151, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079, -1079,
   -1079, -1079, -1079,   776, -1079,  -737,   -71,   -69, -1058, -1079,
    -659, -1052,  -168,  -731,  -581,  -870,  -880,  -890,  -665,   -75,
    -449,  -895, -1079, -1079, -1079,    57,    46, -1079,  -261, -1079,
   -1079, -1079, -1079, -1079, -1079, -1079, -1079,   472, -1079, -1079,
   -1079,   889,   107, -1079,   230,   441,  -309,    79, -1079,   -22,
    -545, -1079, -1079, -1079,   159, -1079, -1079, -1079,   470, -1079,
    1335,  -896, -1079, -1078, -1079,  -188, -1079,  -312, -1079,   475,
   -1079,   250,   673,   675, -1079,  -349,  -329,   490,    71,  -174,
    -199, -1079,  -184, -1079,  -223,  2237,   373,    18,   885,  -101,
      49,   367,   369,   368,   371,   -39,  -343, -1079,  -481,  -484,
     579,  -788,  -456,   656, -1079
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     2,     8,    62,     3,     4,    63,    64,    65,   394,
     156,    66,    67,     9,    68,    69,    70,    71,    72,    73,
     785,    74,    75,    76,   302,   464,    77,    78,   907,   908,
    1007,   788,   789,   465,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   684,   103,
     104,   105,   106,   107,   108,   109,   592,   110,   111,   554,
     112,   600,   753,   113,   114,   433,   115,   116,   873,   117,
     437,   118,   119,   120,   121,   122,   587,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   236,   608,   761,   891,   892,   895,  1047,  1048,
     889,  1063,  1045,   887,   890,   985,   986,   987,   877,   880,
     878,  1049,   138,   139,   140,   775,   766,   141,   701,   142,
     143,   144,   145,   146,   147,   148,   149,   206,   150,   198,
     513,   238,   183,   201,   355,   381,   375,   862,   863,   864,
     224,   671,   515,   516,   185,   791,   213,   216,   546,   382,
     622,   310,   474,  1125,   356,   376,   377,   865,   519,   866,
     186,   187,   188,   189,   190,   543,   346,   347,   191,   349,
     353,   312,   521,   368,   209,   164,   306,   192,   193,   989,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     194,   195,   507,   508,   151
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     184,   196,   502,   634,   621,   652,   653,   998,   997,   993,
     654,   655,   656,   158,   709,   357,   161,    11,   239,   992,
     511,   385,   397,   398,   399,   400,   556,   990,   991,   542,
     886,   383,  1113,   364,   638,   932,   774,  1128,   893,   217,
     778,  1127,   661,   518,   174,   175,   176,  1132,  1150,   163,
     524,   169,   485,   486,   350,   796,   699,     1,   214,   340,
     351,   553,   479,   475,   165,   166,   167,   168,   479,   317,
     476,   240,     5,   480,   242,   202,   203,   487,   488,   700,
     174,   175,   176,   428,   998,  1174,   697,   341,  1157,   174,
     175,   176,   163,  1051,  1165,  1151,   462,     7,   879,   170,
     463,   514,  1153,  1002,     6,  1003,   581,   582,   485,   666,
     154,   901,   902,   155,   904,   174,   175,   176,   174,   175,
     176,   905,  1100,   234,   235,   489,   490,   541,  1101,   305,
     494,   495,   348,   487,   488,   496,    10,  1191,   491,   492,
     493,  1196,   648,   649,   650,   651,  1201,   639,   893,   998,
    1093,    12,   541,   541,   998,  1099,   223,   551,   676,   152,
     525,   170,   344,   765,   994,   335,   336,   782,   783,   499,
     662,   441,   442,   314,   563,   564,   565,   566,   172,   173,
    1107,   307,   362,   337,   338,   774,   888,   313,   888,  1004,
    1046,   444,   445,   373,  1046,   698,   380,   153,   696,   998,
     461,   343,   383,   468,   673,   544,   157,   913,   225,   914,
     544,   970,   315,   316,   181,   182,   354,   358,   971,   159,
    1140,   977,   163,  -456,   979,   335,   336,   981,   822,  -456,
    1133,   371,   667,  1044,   374,   379,   160,   384,   354,   162,
    1001,   343,   802,   996,   501,  1000,   667,   509,   931,  1052,
     197,   388,   667,  1053,   342,   200,   998,   207,   717,   718,
     720,   722,   723,   724,   725,   726,   727,   728,   729,   730,
     731,   732,   733,   208,   315,   316,   181,   182,   210,   998,
    1180,   934,   935,  1166,  1167,   938,   939,   205,   378,   750,
     296,   297,   298,   299,   300,  1189,   211,  1054,   888,   226,
    1193,  1055,  1056,   212,  1198,  1188,  1057,  1182,  1058,   174,
    1192,   176,  1059,   215,  1197,   881,   174,   175,   176,   222,
     995,   227,   500,   649,   910,   911,   765,   221,   966,   350,
    1065,   503,   504,   505,   506,   351,   446,   447,   527,   528,
     713,   714,   715,   716,   884,   771,   772,   773,   885,   239,
     449,   450,   544,   228,   170,   229,   628,   629,   630,   631,
     548,   230,   633,   552,   451,   452,   314,   483,   484,   719,
     721,   172,   173,   522,   231,   640,   641,   526,   174,   308,
     176,   530,   531,   734,   664,   665,   534,   535,   232,   888,
     233,  1024,  1025,  1026,  1027,   337,   338,   339,   237,   547,
     550,   301,   560,   304,   555,   555,   557,   596,   379,   668,
     174,   620,   176,   345,   357,   771,   772,   773,   489,   490,
     972,   973,   677,   594,   348,   170,  1061,  1062,  1097,  1098,
     378,   434,   435,   379,   379,   365,   605,   314,   817,   818,
     367,   369,   172,   173,   646,   647,   881,   370,   389,   417,
     704,   418,   419,   174,   175,   176,   420,   421,   422,   423,
     424,   425,   223,   432,   436,   177,   178,   179,   329,   181,
     182,   623,   440,   453,   443,   448,   456,   457,   663,  1078,
    1079,   454,   458,   455,   459,   460,   378,   378,   463,   470,
     828,   829,   469,   471,   473,   477,   481,   478,   482,   497,
     510,   512,   678,   679,   523,   533,   536,   539,   682,   685,
     964,   965,   170,   545,   517,   541,   558,   694,   561,   562,
     834,   583,   836,   586,   314,   589,   781,   597,   591,   172,
     173,   599,   670,   604,   607,   708,   601,   793,   315,   316,
     181,   182,   627,   467,   602,  1064,  1069,  1066,   606,   632,
     686,   868,   689,   690,   462,   305,   660,   636,   667,   669,
     675,   676,   736,   737,   798,   691,   799,   687,   702,  1009,
     703,   705,   392,   746,   800,   801,  1011,   544,  1109,  1012,
    1108,   735,   711,   712,   752,   379,   526,   526,   379,   379,
     379,   379,   379,   379,   379,   379,   379,   379,   379,   379,
     354,   820,   821,   759,  1041,   738,   740,   784,   742,   787,
     743,   790,   760,  1130,  1131,  1111,   751,  1112,   915,   794,
     747,   756,   748,   223,   795,   315,   316,   181,   182,   802,
     623,   665,   812,   816,   757,   797,   819,   942,   378,   378,
     378,   378,   378,   378,   378,   378,   378,   378,   378,   378,
     378,   378,   378,   814,   823,   792,   803,   804,   826,   170,
     870,   827,   806,   807,   808,   850,   223,   859,   811,   378,
     860,   314,   861,   882,   894,   672,   172,   173,  1089,   896,
     897,   898,   899,   903,   906,   909,   825,   912,   916,   918,
    1008,   920,   921,   919,   922,   832,   833,   931,   835,   962,
     837,   838,   839,   840,   841,   842,   843,   844,   845,   846,
     847,   848,   849,   976,   978,   980,   982,   983,   225,  1006,
     856,  1060,  1019,  1020,  1068,  1067,   170,  1070,  1124,  1071,
    1095,  1104,   871,   872,  1096,  1110,  1094,   354,   314,   354,
    1129,  1134,  1136,   172,   173,  1135,  1137,  1138,  1139,   328,
     332,   333,   334,  1141,  1151,  1159,  1152,  1154,  1168,   855,
    1164,  1169,   857,   858,  1170,  1171,   674,   522,   869,  1176,
    1175,  1181,   315,   316,   181,   182,   875,  1177,  1179,  1183,
     623,   623,   623,  1186,   923,  1185,  1190,  1194,  1195,   928,
    1199,  1200,   930,   623,   623,   623,  1202,   623,  1158,   391,
     393,   710,   786,   933,   303,  1005,   466,  1010,   974,   226,
     940,   975,   593,   941,  1050,   943,   944,   945,   946,   947,
     984,   900,   948,   883,   949,   950,   951,   952,   749,   867,
     520,   559,   498,   958,   165,   166,   167,   168,   532,   315,
     316,   181,   182,   635,   330,   917,   331,   643,   642,   644,
     352,     0,   549,   645,   354,     0,   169,   170,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   171,
       0,   514,     0,     0,   172,   173,     0,     0,     0,     0,
     328,     0,     0,   328,     0,   174,   175,   176,     0,   555,
     555,     0,     0,   332,   623,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   623,     0,  1017,   623,     0,     0,
     623,  1021,     0,   623,   988,   988,   988,   988,  1028,     0,
       0,  1029,  1030,   623,   328,     0,     0,   328,  1031,     0,
       0,     0,     0,   223,   223,     0,     0,   223,   223,     0,
       0,  1039,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1102,  1103,     0,     0,  1105,     0,  1106,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   177,   178,
     179,   180,   181,   182,     0,   165,   166,   167,   168,     0,
     223,     0,     0,   555,     0,   225,   225,     0,     0,   225,
     225,     0,     0,     0,     0,  1073,     0,   169,   170,  1075,
       0,   988,     0,     0,     0,     0,     0,     0,  1082,     0,
     171,     0,   623,   623,   623,   172,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,   176,     0,
       0,     0,   225,     0,     0,  1156,   328,   328,   328,   328,
       0,     0,   328,   223,   223,   223,   223,     0,     0,   311,
       0,     0,     0,  1116,     0,   328,   328,   555,   328,   328,
     328,   328,   328,   328,   328,   328,   328,   328,   328,   328,
     328,   328,   328,   657,   658,   659,   226,   226,     0,     0,
     226,   226,   623,     0,   623,     0,  1114,     0,     0,   328,
       0,     0,     0,     0,  1142,   225,   225,   225,   225,   311,
       0,     0,   328,     0,     0,     0,     0,   555,     0,   177,
     178,   179,   180,   181,   182,     0,     0,     0,   988,     0,
     328,     0,     0,   226,     0,     0,     0,     0,   988,     0,
     328,   223,   223,     0,     0,     0,     0,  1172,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
     413,   414,     0,     0,     0,     0,     0,  1184,   165,   166,
     167,   168,     0,     0,     0,     0,     0,   431,     0,     0,
       0,   988,   988,     0,     0,     0,     0,     0,     0,     0,
     169,   170,     0,   225,   225,     0,   226,   226,   226,   226,
       0,     0,     0,   171,   311,   988,     0,     0,   172,   173,
       0,     0,     0,   988,     0,     0,   328,     0,   988,   174,
     175,   176,   988,     0,     0,     0,     0,   328,   609,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,     0,
     625,   626,     0,     0,     0,     0,     0,   243,   244,   245,
     246,   247,   248,     0,   328,   328,   328,   311,   249,     0,
       0,     0,     0,     0,   328,   328,   311,   311,     0,   311,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   226,   226,     0,     0,     0,     0,
       0,   328,   328,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   177,   178,   683,   180,   181,   182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,     0,     0,   265,   266,
     267,   268,     0,     0,     0,   269,   270,   271,   624,     0,
       0,   272,   273,     0,     0,     0,     0,     0,   274,   275,
     276,   277,     0,     0,     0,     0,   278,   311,     0,     0,
       0,     0,     0,     0,     0,   279,   280,   281,     0,     0,
     282,   283,     0,     0,     0,   328,   284,     0,     0,     0,
       0,     0,     0,     0,   285,     0,     0,     0,     0,     0,
       0,     0,    13,    14,    15,    16,    17,    18,    19,    20,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
       0,     0,   311,   311,     0,     0,     0,     0,     0,   624,
       0,     0,   311,   311,     0,   311,     0,     0,    21,     0,
       0,    22,    23,     0,     0,     0,     0,     0,     0,   311,
       0,   311,     0,     0,     0,     0,    24,     0,    25,   392,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    26,     0,   328,   328,   328,   328,    27,
       0,     0,     0,     0,     0,   328,     0,     0,     0,    28,
       0,   328,     0,     0,     0,     0,     0,   624,   328,   309,
       0,   328,     0,     0,     0,    29,    30,     0,     0,     0,
       0,    31,    32,    33,     0,     0,     0,    34,    35,    36,
       0,     0,    37,    38,    39,    40,    41,     0,     0,     0,
       0,    42,    43,    44,    45,     0,    46,    47,    48,    49,
      50,    51,    52,    53,     0,     0,     0,    54,    55,   372,
       0,    56,    57,    58,    59,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   311,     0,     0,
       0,     0,     0,   311,   311,     0,     0,   311,     0,     0,
     311,     0,     0,     0,     0,     0,     0,     0,     0,    60,
      61,   311,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   311,   311,     0,   311,   311,     0,     0,     0,     0,
       0,     0,   328,   328,     0,     0,   328,     0,   328,   328,
     328,   328,   311,     0,   472,     0,     0,   624,   624,   624,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     624,   624,   624,     0,   624,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   328,     0,   328,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   311,   311,   311,   311,     0,   529,   311,     0,
       0,     0,     0,     0,     0,     0,   537,   538,     0,   540,
       0,     0,     0,  1155,     0,   328,     0,     0,     0,     0,
     328,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   328,     0,     0,   311,   311,   311,   311,
       0,   311,   311,   311,     0,     0,     0,  1178,     0,     0,
       0,     0,     0,     0,     0,     0,   328,     0,   624,   311,
     311,   624,     0,     0,   328,     0,     0,     0,     0,   328,
       0,   624,     0,   328,   624,     0,     0,   624,     0,     0,
     624,     0,     0,     0,     0,     0,     0,     0,   999,     0,
     624,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   637,   311,     0,
     311,   311,   311,     0,   311,     0,     0,     0,     0,   311,
     311,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   311,     0,
       0,   311,   311,   311,   311,   311,   311,     0,     0,   311,
       0,     0,     0,   311,   311,     0,     0,     0,     0,     0,
       0,     0,   680,   681,     0,   999,     0,     0,     0,   688,
       0,     0,   692,   693,     0,   695,     0,     0,     0,   624,
     624,   624,     0,     0,     0,     0,     0,     0,     0,   706,
       0,   707,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   311,     0,   311,     0,     0,     0,   311,   311,     0,
       0,   311,   311,     0,     0,     0,     0,   311,   311,   311,
     311,     0,   311,   311,     0,   311,   311,   311,     0,     0,
     999,     0,     0,     0,     0,   999,     0,     0,     0,     0,
       0,     0,     0,     0,   165,   166,   167,   168,     0,   624,
       0,   624,     0,     0,     0,     0,     0,     0,   311,     0,
       0,     0,     0,   311,   311,   311,   311,   170,     0,     0,
     311,     0,   311,   311,     0,     0,   311,     0,     0,   171,
     999,   514,     0,     0,   172,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   174,   175,   176,     0,     0,
       0,     0,   311,   311,   311,   311,     0,     0,   311,   311,
     311,     0,     0,     0,     0,     0,     0,   805,     0,     0,
       0,     0,     0,   809,   810,     0,     0,   813,   311,   311,
     815,     0,   311,   311,     0,   311,     0,   999,     0,     0,
       0,   824,     0,     0,     0,     0,     0,   311,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   311,
     999,   165,   166,   167,   168,     0,     0,     0,     0,   311,
       0,   851,   852,     0,   853,   854,     0,     0,   177,   178,
     179,   180,   181,   182,   170,   165,   166,   167,   168,     0,
       0,     0,   874,     0,     0,     0,   171,     0,     0,     0,
       0,   172,   173,     0,     0,     0,     0,     0,   170,     0,
       0,     0,   174,   175,   176,     0,     0,     0,     0,     0,
     171,     0,     0,     0,     0,   172,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   620,   176,     0,
       0,     0,   924,   925,   926,   927,     0,     0,   929,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   954,   955,   956,   957,
       0,   959,   960,   961,     0,   177,   178,   179,   180,   181,
     182,     0,     0,     0,     0,     0,     0,     0,   967,   968,
     969,     0,     0,     0,     0,     0,     0,     0,     0,   177,
     178,   179,   180,   181,   182,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1013,     0,
    1014,  1015,  1016,     0,  1018,   199,     0,   204,     0,  1022,
    1023,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     218,   219,   220,     0,     0,     0,     0,     0,  1032,     0,
       0,  1033,  1034,  1035,  1036,  1037,  1038,     0,     0,  1040,
       0,     0,     0,  1042,  1043,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1072,     0,  1074,     0,     0,     0,  1076,  1077,     0,
       0,  1080,  1081,     0,     0,     0,     0,  1083,  1084,  1085,
    1086,     0,  1087,  1088,     0,  1090,  1091,  1092,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1115,     0,
       0,     0,     0,  1117,  1118,  1119,  1120,     0,     0,     0,
    1121,     0,  1122,  1123,     0,     0,  1126,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   359,   360,
     361,     0,     0,   363,     0,     0,   366,     0,     0,     0,
       0,     0,  1143,  1144,  1145,  1146,     0,     0,  1147,  1148,
    1149,     0,     0,     0,     0,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   390,     0,     0,  1160,  1161,
     395,   396,  1162,  1163,     0,  1149,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1173,     0,     0,
     415,   416,     0,     0,     0,     0,     0,     0,     0,  1149,
       0,   426,   427,   429,   430,     0,     0,     0,     0,  1187,
     438,   439,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    -9,     0,     0,     0,     0,    13,    14,    15,    16,
      17,    18,    19,    20,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    21,     0,     0,    22,    23,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      24,     0,    25,    -9,     0,     0,     0,     0,   567,   568,
     569,   570,   571,   572,   573,   574,   575,   576,   577,   578,
     579,   580,     0,     0,     0,   584,   585,    26,   588,     0,
     590,     0,     6,    27,     0,   595,     0,     0,   598,     0,
       0,     0,     0,    28,   603,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    29,
      30,     0,     0,     0,     0,    31,    32,    33,     0,     0,
       0,    34,    35,    36,     0,     0,    37,    38,    39,    40,
      41,     0,     0,     0,     0,    42,    43,    44,    45,     0,
      46,    47,    48,    49,    50,    51,    52,    53,     0,     0,
       0,    54,    55,     0,     0,    56,    57,    58,    59,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    60,    61,   241,     0,     0,     0,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    -8,    -8,    -8,    -8,    -8,    -8,     0,
       0,     0,     0,     0,    -8,    -8,     0,     0,    -8,    -8,
       0,     0,     0,     0,   739,     0,   741,     0,     0,   744,
     745,     0,     0,    -8,     0,    -8,    -8,     0,   754,   755,
       0,     0,     0,   758,     0,     0,   762,   763,   764,     0,
     767,   768,   769,   770,     0,   776,   777,     0,     0,     0,
      -8,     0,   779,   780,     0,     1,    -8,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,     0,     0,     0,     0,     0,     0,     0,
      -8,     0,   830,   831,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,     0,     0,
       0,     0,     0,    13,    14,    15,    16,    17,    18,    19,
      20,     0,     0,     0,     0,     0,     0,     0,   876,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    21,
       0,     0,    22,    23,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    24,     0,    25,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    26,   936,   937,     0,     0,     0,
      27,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      28,     0,     0,     0,     0,     0,     0,   953,     0,     0,
       0,     0,     0,     0,     0,     0,    29,    30,     0,     0,
       0,     0,    31,    32,    33,     0,     0,   963,    34,    35,
      36,     0,     0,    37,    38,    39,    40,    41,     0,     0,
       0,     0,    42,    43,    44,    45,     0,    46,    47,    48,
      49,    50,    51,    52,    53,     0,     0,     0,    54,    55,
       0,     0,    56,    57,    58,    59,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      60,    61
};

static const yytype_int16 yycheck[] =
{
      22,    23,   345,   464,   453,   489,   490,   903,   903,   899,
     491,   492,   493,    16,   559,   199,    19,     8,    62,   899,
     349,   220,   245,   246,   247,   248,   387,   897,   898,   378,
     767,   219,     1,   207,    59,   823,   617,  1095,   769,    42,
     621,  1093,   498,   355,    87,    88,    89,  1099,  1126,    59,
     359,    58,    54,    55,    46,    66,    64,    91,    40,    59,
      52,    59,    73,    57,    36,    37,    38,    39,    73,   170,
      64,    62,     0,    78,    65,    42,    43,    79,    80,    87,
      87,    88,    89,    93,   980,  1163,   542,    87,  1140,    87,
      88,    89,    59,   983,  1152,    57,    16,    13,   763,    59,
      20,    73,    64,     1,    91,     3,   415,   416,    54,    55,
      87,   776,   777,    90,   779,    87,    88,    89,    87,    88,
      89,   780,    64,   190,   191,    70,    71,    54,    70,   172,
      67,    68,    59,    79,    80,    72,   172,  1189,    83,    84,
      85,  1193,   485,   486,   487,   488,  1198,   172,   879,  1045,
    1045,    63,    54,    54,  1050,  1050,    49,    59,    59,   172,
     359,    59,   184,   612,   901,    48,    49,   628,   629,   343,
     499,   190,   191,    71,   397,   398,   399,   400,    76,    77,
    1060,   163,   204,    48,    49,   766,   767,   169,   769,    87,
     978,   190,   191,   215,   982,   544,   218,    87,   541,  1095,
     301,   183,   390,   304,   516,   379,    90,    62,    49,    64,
     384,   876,   172,   173,   174,   175,   198,   199,   877,    87,
    1110,   886,    59,    46,   889,    48,    49,   892,    60,    52,
    1100,   213,    64,   970,   216,   217,    87,   219,   220,    87,
     905,   223,    60,   902,   345,   904,    64,   348,    60,    60,
      77,   233,    64,    64,   183,    53,  1152,    95,   567,   568,
     569,   570,   571,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,    63,   172,   173,   174,   175,    97,  1175,
    1175,   826,   827,  1153,  1154,   830,   831,    96,   217,   598,
      21,    22,    23,    24,    25,  1185,    97,    59,   879,    49,
    1190,    63,    60,    59,  1194,  1185,    64,  1177,    60,    87,
    1190,    89,    64,    59,  1194,   764,    87,    88,    89,   172,
     901,   101,   344,   666,   785,   786,   775,    90,   873,    46,
     995,    48,    49,    50,    51,    52,   190,   191,   360,   361,
     563,   564,   565,   566,   183,   184,   185,   186,   187,   393,
     190,   191,   526,   101,    59,    97,   457,   458,   459,   460,
     382,    97,   463,   385,   190,   191,    71,    81,    82,   568,
     569,    76,    77,   355,    87,   476,   477,   359,    87,    88,
      89,   363,   364,   582,    64,    65,   368,   369,    87,   970,
      97,   936,   937,   938,   939,    48,    49,    50,    35,   381,
     382,    17,   393,    69,   386,   387,   388,   429,   390,   510,
      87,    88,    89,    54,   598,   184,   185,   186,    70,    71,
     180,   181,   523,   426,    59,    59,    70,    71,    70,    71,
     359,   280,   281,   415,   416,   172,   439,    71,   699,   700,
      59,    98,    76,    77,   483,   484,   895,   172,   188,    63,
     551,    97,    97,    87,    88,    89,     4,    97,    63,    97,
       4,     4,   355,    28,    94,   170,   171,   172,   173,   174,
     175,   453,    63,   191,   190,   190,    47,    18,   500,  1024,
    1025,   191,    18,   191,    18,    18,   415,   416,    20,    64,
     713,   714,    60,    63,    63,    59,    74,    60,    75,    87,
      54,   169,   524,   525,    59,   172,    64,    64,   530,   531,
     871,   872,    59,    59,   355,    54,   189,   539,   173,   173,
     719,   172,   721,    63,    71,   172,   627,    87,    63,    76,
      77,    26,   514,   172,   177,   557,    97,   638,   172,   173,
     174,   175,    18,    90,    97,   994,  1007,   996,   172,    61,
     532,   750,   534,   535,    16,   172,    60,   172,    64,    60,
      56,    59,   584,   585,   665,   172,   667,    60,    59,   912,
      59,   553,    62,   595,   675,   676,   919,   751,  1062,   922,
    1061,    63,   172,   172,    27,   567,   568,   569,   570,   571,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   702,   703,   177,   965,   172,   588,    19,   590,    87,
     172,    60,   178,  1097,  1098,  1064,   598,  1066,   792,    57,
     172,   603,   172,   516,    60,   172,   173,   174,   175,    60,
     612,    65,    60,    55,   172,   172,    60,   836,   567,   568,
     569,   570,   571,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,    64,    64,   637,   678,   679,   172,    59,
      97,   172,   684,   685,   686,   172,   559,   172,   690,   598,
     172,    71,   172,   204,   183,   516,    76,    77,  1039,    59,
      59,    59,    56,    56,    15,    87,   708,    69,    60,    55,
      90,    60,    57,    64,    54,   717,   718,    60,   720,   172,
     722,   723,   724,   725,   726,   727,   728,   729,   730,   731,
     732,   733,   734,   182,    56,    56,    56,    56,   559,    14,
     742,    64,    60,    60,    54,    57,    59,    55,  1089,    55,
      64,   172,   754,   755,    57,    64,    72,   719,    71,   721,
     179,    59,    64,    76,    77,    60,    60,    60,    57,   170,
     171,   172,   173,    64,    57,   100,    64,    64,    64,   741,
     179,    60,   744,   745,    57,    55,   516,   749,   750,    57,
      64,   179,   172,   173,   174,   175,   758,    64,    99,    60,
     762,   763,   764,    57,   806,    64,    64,    64,    57,   811,
      57,    57,   814,   775,   776,   777,    57,   779,  1141,   239,
     242,   560,   631,   825,   160,   906,   303,   914,   879,   559,
     832,   880,   425,   835,   982,   837,   838,   839,   840,   841,
     895,   775,   844,   766,   846,   847,   848,   849,   598,   750,
     355,   390,   342,   855,    36,    37,    38,    39,   366,   172,
     173,   174,   175,   470,   171,   796,   171,   480,   479,   481,
     194,    -1,   382,   482,   836,    -1,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    -1,    76,    77,    -1,    -1,    -1,    -1,
     301,    -1,    -1,   304,    -1,    87,    88,    89,    -1,   871,
     872,    -1,    -1,   314,   876,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   886,    -1,   928,   889,    -1,    -1,
     892,   933,    -1,   895,   896,   897,   898,   899,   940,    -1,
      -1,   943,   944,   905,   345,    -1,    -1,   348,   950,    -1,
      -1,    -1,    -1,   826,   827,    -1,    -1,   830,   831,    -1,
      -1,   963,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1053,  1054,    -1,    -1,  1057,    -1,  1059,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   170,   171,
     172,   173,   174,   175,    -1,    36,    37,    38,    39,    -1,
     873,    -1,    -1,   965,    -1,   826,   827,    -1,    -1,   830,
     831,    -1,    -1,    -1,    -1,  1017,    -1,    58,    59,  1021,
      -1,   983,    -1,    -1,    -1,    -1,    -1,    -1,  1030,    -1,
      71,    -1,   994,   995,   996,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    89,    -1,
      -1,    -1,   873,    -1,    -1,  1136,   457,   458,   459,   460,
      -1,    -1,   463,   936,   937,   938,   939,    -1,    -1,   164,
      -1,    -1,    -1,  1075,    -1,   476,   477,  1039,   479,   480,
     481,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   826,   827,    -1,    -1,
     830,   831,  1064,    -1,  1066,    -1,  1068,    -1,    -1,   510,
      -1,    -1,    -1,    -1,  1116,   936,   937,   938,   939,   214,
      -1,    -1,   523,    -1,    -1,    -1,    -1,  1089,    -1,   170,
     171,   172,   173,   174,   175,    -1,    -1,    -1,  1100,    -1,
     541,    -1,    -1,   873,    -1,    -1,    -1,    -1,  1110,    -1,
     551,  1024,  1025,    -1,    -1,    -1,    -1,  1159,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,    -1,    -1,    -1,    -1,  1179,    36,    37,
      38,    39,    -1,    -1,    -1,    -1,    -1,   278,    -1,    -1,
      -1,  1153,  1154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      58,    59,    -1,  1024,  1025,    -1,   936,   937,   938,   939,
      -1,    -1,    -1,    71,   309,  1177,    -1,    -1,    76,    77,
      -1,    -1,    -1,  1185,    -1,    -1,   627,    -1,  1190,    87,
      88,    89,  1194,    -1,    -1,    -1,    -1,   638,   442,   443,
     444,   445,   446,   447,   448,   449,   450,   451,   452,    -1,
     454,   455,    -1,    -1,    -1,    -1,    -1,    29,    30,    31,
      32,    33,    34,    -1,   665,   666,   667,   362,    40,    -1,
      -1,    -1,    -1,    -1,   675,   676,   371,   372,    -1,   374,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1024,  1025,    -1,    -1,    -1,    -1,
      -1,   702,   703,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   170,   171,   172,   173,   174,   175,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,    -1,    -1,   120,   121,
     122,   123,    -1,    -1,    -1,   127,   128,   129,   453,    -1,
      -1,   133,   134,    -1,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,    -1,    -1,    -1,    -1,   148,   472,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   157,   158,   159,    -1,    -1,
     162,   163,    -1,    -1,    -1,   796,   168,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   176,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,     6,     7,     8,     9,    10,    11,    12,
     192,   193,   194,   195,   196,   197,   198,   199,   200,   201,
      -1,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,   534,
      -1,    -1,   537,   538,    -1,   540,    -1,    -1,    41,    -1,
      -1,    44,    45,    -1,    -1,    -1,    -1,    -1,    -1,   554,
      -1,   556,    -1,    -1,    -1,    -1,    59,    -1,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,   896,   897,   898,   899,    92,
      -1,    -1,    -1,    -1,    -1,   906,    -1,    -1,    -1,   102,
      -1,   912,    -1,    -1,    -1,    -1,    -1,   612,   919,   164,
      -1,   922,    -1,    -1,    -1,   118,   119,    -1,    -1,    -1,
      -1,   124,   125,   126,    -1,    -1,    -1,   130,   131,   132,
      -1,    -1,   135,   136,   137,   138,   139,    -1,    -1,    -1,
      -1,   144,   145,   146,   147,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,    -1,    -1,   160,   161,   214,
      -1,   164,   165,   166,   167,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   682,    -1,    -1,
      -1,    -1,    -1,   688,   689,    -1,    -1,   692,    -1,    -1,
     695,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   202,
     203,   706,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   736,   737,    -1,   739,   740,    -1,    -1,    -1,    -1,
      -1,    -1,  1053,  1054,    -1,    -1,  1057,    -1,  1059,  1060,
    1061,  1062,   757,    -1,   309,    -1,    -1,   762,   763,   764,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     775,   776,   777,    -1,   779,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1097,  1098,    -1,  1100,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   807,   808,   809,   810,    -1,   362,   813,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   371,   372,    -1,   374,
      -1,    -1,    -1,  1134,    -1,  1136,    -1,    -1,    -1,    -1,
    1141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1153,  1154,    -1,    -1,   851,   852,   853,   854,
      -1,   856,   857,   858,    -1,    -1,    -1,  1168,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1177,    -1,   873,   874,
     875,   876,    -1,    -1,  1185,    -1,    -1,    -1,    -1,  1190,
      -1,   886,    -1,  1194,   889,    -1,    -1,   892,    -1,    -1,
     895,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   903,    -1,
     905,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   472,   923,    -1,
     925,   926,   927,    -1,   929,    -1,    -1,    -1,    -1,   934,
     935,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   953,    -1,
      -1,   956,   957,   958,   959,   960,   961,    -1,    -1,   964,
      -1,    -1,    -1,   968,   969,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   527,   528,    -1,   980,    -1,    -1,    -1,   534,
      -1,    -1,   537,   538,    -1,   540,    -1,    -1,    -1,   994,
     995,   996,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   554,
      -1,   556,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1016,    -1,  1018,    -1,    -1,    -1,  1022,  1023,    -1,
      -1,  1026,  1027,    -1,    -1,    -1,    -1,  1032,  1033,  1034,
    1035,    -1,  1037,  1038,    -1,  1040,  1041,  1042,    -1,    -1,
    1045,    -1,    -1,    -1,    -1,  1050,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    36,    37,    38,    39,    -1,  1064,
      -1,  1066,    -1,    -1,    -1,    -1,    -1,    -1,  1073,    -1,
      -1,    -1,    -1,  1078,  1079,  1080,  1081,    59,    -1,    -1,
    1085,    -1,  1087,  1088,    -1,    -1,  1091,    -1,    -1,    71,
    1095,    73,    -1,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    87,    88,    89,    -1,    -1,
      -1,    -1,  1117,  1118,  1119,  1120,    -1,    -1,  1123,  1124,
    1125,    -1,    -1,    -1,    -1,    -1,    -1,   682,    -1,    -1,
      -1,    -1,    -1,   688,   689,    -1,    -1,   692,  1143,  1144,
     695,    -1,  1147,  1148,    -1,  1150,    -1,  1152,    -1,    -1,
      -1,   706,    -1,    -1,    -1,    -1,    -1,  1162,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1174,
    1175,    36,    37,    38,    39,    -1,    -1,    -1,    -1,  1184,
      -1,   736,   737,    -1,   739,   740,    -1,    -1,   170,   171,
     172,   173,   174,   175,    59,    36,    37,    38,    39,    -1,
      -1,    -1,   757,    -1,    -1,    -1,    71,    -1,    -1,    -1,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    59,    -1,
      -1,    -1,    87,    88,    89,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    89,    -1,
      -1,    -1,   807,   808,   809,   810,    -1,    -1,   813,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   851,   852,   853,   854,
      -1,   856,   857,   858,    -1,   170,   171,   172,   173,   174,
     175,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   873,   874,
     875,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   170,
     171,   172,   173,   174,   175,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   923,    -1,
     925,   926,   927,    -1,   929,    28,    -1,    30,    -1,   934,
     935,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      43,    44,    45,    -1,    -1,    -1,    -1,    -1,   953,    -1,
      -1,   956,   957,   958,   959,   960,   961,    -1,    -1,   964,
      -1,    -1,    -1,   968,   969,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1016,    -1,  1018,    -1,    -1,    -1,  1022,  1023,    -1,
      -1,  1026,  1027,    -1,    -1,    -1,    -1,  1032,  1033,  1034,
    1035,    -1,  1037,  1038,    -1,  1040,  1041,  1042,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1073,    -1,
      -1,    -1,    -1,  1078,  1079,  1080,  1081,    -1,    -1,    -1,
    1085,    -1,  1087,  1088,    -1,    -1,  1091,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   201,   202,
     203,    -1,    -1,   206,    -1,    -1,   209,    -1,    -1,    -1,
      -1,    -1,  1117,  1118,  1119,  1120,    -1,    -1,  1123,  1124,
    1125,    -1,    -1,    -1,    -1,    -1,   229,   230,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   238,    -1,    -1,  1143,  1144,
     243,   244,  1147,  1148,    -1,  1150,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1162,    -1,    -1,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1174,
      -1,   274,   275,   276,   277,    -1,    -1,    -1,    -1,  1184,
     283,   284,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     0,    -1,    -1,    -1,    -1,     5,     6,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    41,    -1,    -1,    44,    45,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      59,    -1,    61,    62,    -1,    -1,    -1,    -1,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
     413,   414,    -1,    -1,    -1,   418,   419,    86,   421,    -1,
     423,    -1,    91,    92,    -1,   428,    -1,    -1,   431,    -1,
      -1,    -1,    -1,   102,   437,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,   124,   125,   126,    -1,    -1,
      -1,   130,   131,   132,    -1,    -1,   135,   136,   137,   138,
     139,    -1,    -1,    -1,    -1,   144,   145,   146,   147,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,    -1,
      -1,   160,   161,    -1,    -1,   164,   165,   166,   167,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   202,   203,     1,    -1,    -1,    -1,     5,
       6,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    29,    30,    31,    32,    33,    34,    -1,
      -1,    -1,    -1,    -1,    40,    41,    -1,    -1,    44,    45,
      -1,    -1,    -1,    -1,   587,    -1,   589,    -1,    -1,   592,
     593,    -1,    -1,    59,    -1,    61,    62,    -1,   601,   602,
      -1,    -1,    -1,   606,    -1,    -1,   609,   610,   611,    -1,
     613,   614,   615,   616,    -1,   618,   619,    -1,    -1,    -1,
      86,    -1,   625,   626,    -1,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,   168,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     176,    -1,   715,   716,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   192,   193,   194,   195,
     196,   197,   198,   199,   200,   201,   202,   203,    -1,    -1,
      -1,    -1,    -1,     5,     6,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   761,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    41,
      -1,    -1,    44,    45,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    59,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,   828,   829,    -1,    -1,    -1,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,   850,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   118,   119,    -1,    -1,
      -1,    -1,   124,   125,   126,    -1,    -1,   870,   130,   131,
     132,    -1,    -1,   135,   136,   137,   138,   139,    -1,    -1,
      -1,    -1,   144,   145,   146,   147,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,    -1,    -1,   160,   161,
      -1,    -1,   164,   165,   166,   167,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     202,   203
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,    91,   206,   209,   210,     0,    91,    13,   207,   218,
     172,   210,    63,     5,     6,     7,     8,     9,    10,    11,
      12,    41,    44,    45,    59,    61,    86,    92,   102,   118,
     119,   124,   125,   126,   130,   131,   132,   135,   136,   137,
     138,   139,   144,   145,   146,   147,   149,   150,   151,   152,
     153,   154,   155,   156,   160,   161,   164,   165,   166,   167,
     202,   203,   208,   211,   212,   213,   216,   217,   219,   220,
     221,   222,   223,   224,   226,   227,   228,   231,   232,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   264,   265,   266,   267,   268,   269,   270,
     272,   273,   275,   278,   279,   281,   282,   284,   286,   287,
     288,   289,   290,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   327,   328,
     329,   332,   334,   335,   336,   337,   338,   339,   340,   341,
     343,   409,   172,    87,    87,    90,   215,    90,   215,    87,
      87,   215,    87,    59,   390,    36,    37,    38,    39,    58,
      59,    71,    76,    77,    87,    88,    89,   170,   171,   172,
     173,   174,   175,   347,   354,   359,   375,   376,   377,   378,
     379,   383,   392,   393,   405,   406,   354,    77,   344,   390,
      53,   348,    42,    43,   390,    96,   342,    95,    63,   389,
      97,    97,    59,   361,   392,    59,   362,   215,   390,   390,
     390,    90,   172,   347,   355,   359,   376,   101,   101,    97,
      97,    87,    87,    97,   190,   191,   307,    35,   346,   209,
     210,     1,   210,    29,    30,    31,    32,    33,    34,    40,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   120,   121,   122,   123,   127,
     128,   129,   133,   134,   140,   141,   142,   143,   148,   157,
     158,   159,   162,   163,   168,   176,   192,   193,   194,   195,
     196,   197,   198,   199,   200,   201,    21,    22,    23,    24,
      25,    17,   229,   229,    69,   172,   391,   392,    88,   365,
     366,   393,   386,   392,    71,   172,   173,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,   405,   173,
     377,   378,   405,   405,   405,    48,    49,    48,    49,    50,
      59,    87,   383,   392,   354,    54,   381,   382,    59,   384,
      46,    52,   408,   385,   392,   349,   369,   387,   392,   390,
     390,   390,   354,   390,   384,   172,   390,    59,   388,    98,
     172,   392,   365,   354,   392,   351,   370,   371,   383,   392,
     354,   350,   364,   370,   392,   385,   390,   390,   392,   188,
     390,   211,    62,   208,   214,   390,   390,   389,   389,   389,
     389,   346,   346,   346,   346,   346,   346,   346,   346,   346,
     346,   346,   346,   346,   346,   390,   390,    63,    97,    97,
       4,    97,    63,    97,     4,     4,   390,   390,    93,   390,
     390,   346,    28,   280,   280,   280,    94,   285,   390,   390,
      63,   190,   191,   190,   190,   191,   190,   191,   190,   190,
     191,   190,   191,   191,   191,   191,    47,    18,    18,    18,
      18,   394,    16,    20,   230,   238,   230,    90,   394,    60,
      64,    63,   365,    63,   367,    57,    64,    59,    60,    73,
      78,    74,    75,    81,    82,    54,    55,    79,    80,    70,
      71,    83,    84,    85,    67,    68,    72,    87,   382,   384,
     354,   394,   401,    48,    49,    50,    51,   407,   408,   394,
      54,   381,   169,   345,    73,   357,   358,   359,   372,   373,
     374,   387,   392,    59,   351,   385,   392,   354,   354,   365,
     392,   392,   342,   172,   392,   392,    64,   365,   365,    64,
     365,    54,   380,   380,   384,    59,   363,   392,   354,   363,
     392,    59,   354,    59,   274,   392,   274,   392,   189,   350,
     210,   173,   173,   389,   389,   389,   389,   390,   390,   390,
     390,   390,   390,   390,   390,   390,   390,   390,   390,   390,
     390,   351,   351,   172,   390,   390,    63,   291,   390,   172,
     390,    63,   271,   271,   215,   390,   354,    87,   390,    26,
     276,    97,    97,   390,   172,   215,   172,   177,   308,   308,
     308,   308,   308,   308,   308,   308,   308,   308,   308,   308,
      88,   325,   365,   392,   393,   308,   308,    18,   394,   394,
     394,   394,    61,   394,   238,   391,   172,   365,    59,   172,
     394,   394,   397,   396,   398,   399,   400,   400,   401,   401,
     401,   401,   404,   404,   403,   403,   403,   405,   405,   405,
      60,   407,   381,   354,    64,    65,    55,    64,   394,    60,
     392,   356,   359,   372,   376,    56,    59,   394,   354,   354,
     365,   365,   354,   172,   263,   354,   392,    60,   365,   392,
     392,   172,   365,   365,   354,   365,   401,   407,   380,    64,
      87,   333,    59,    59,   394,   392,   365,   365,   354,   355,
     214,   172,   172,   389,   389,   389,   389,   351,   351,   385,
     351,   385,   351,   351,   351,   351,   351,   351,   351,   351,
     351,   351,   351,   351,   385,    63,   354,   354,   172,   390,
     392,   390,   392,   172,   390,   390,   354,   172,   172,   349,
     351,   392,    27,   277,   390,   390,   392,   172,   390,   177,
     178,   309,   390,   390,   390,   325,   331,   390,   390,   390,
     390,   184,   185,   186,   319,   330,   390,   390,   319,   390,
     390,   394,   238,   238,    19,   225,   225,    87,   236,   237,
      60,   360,   392,   394,    57,    60,    66,   172,   394,   394,
     394,   394,    60,   354,   354,   365,   354,   354,   354,   365,
     365,   354,    60,   365,    64,   365,    55,   333,   333,    60,
     394,   394,    60,    64,   365,   354,   172,   172,   389,   389,
     390,   390,   354,   354,   385,   354,   385,   354,   354,   354,
     354,   354,   354,   354,   354,   354,   354,   354,   354,   354,
     172,   365,   365,   365,   365,   392,   354,   392,   392,   172,
     172,   172,   352,   353,   354,   372,   374,   352,   385,   392,
      97,   354,   354,   283,   365,   392,   390,   323,   325,   323,
     324,   325,   204,   330,   183,   187,   310,   318,   319,   315,
     319,   310,   311,   318,   183,   312,    59,    59,    59,    56,
     331,   323,   323,    56,   323,   315,    15,   233,   234,    87,
     238,   238,    69,    62,    64,   384,    60,   395,    55,    64,
      60,    57,    54,   354,   365,   365,   365,   365,   354,   365,
     354,    60,   406,   354,   355,   355,   390,   390,   355,   355,
     354,   354,   385,   354,   354,   354,   354,   354,   354,   354,
     354,   354,   354,   390,   365,   365,   365,   365,   354,   365,
     365,   365,   172,   390,   274,   274,   355,   365,   365,   365,
     323,   315,   180,   181,   311,   312,   182,   323,    56,   323,
      56,   323,    56,    56,   324,   320,   321,   322,   392,   394,
     320,   320,   321,   322,   310,   319,   315,   326,   366,   393,
     315,   323,     1,     3,    87,   394,    14,   235,    90,   401,
     236,   401,   401,   365,   365,   365,   365,   354,   365,    60,
      60,   354,   365,   365,   355,   355,   355,   355,   354,   354,
     354,   354,   365,   365,   365,   365,   365,   365,   365,   354,
     365,   274,   365,   365,   310,   317,   406,   313,   314,   326,
     317,   322,    60,    64,    59,    63,    60,    64,    60,    64,
      64,    70,    71,   316,   325,   323,   325,    57,    54,   238,
      55,    55,   365,   354,   365,   354,   365,   365,   355,   355,
     365,   365,   354,   365,   365,   365,   365,   365,   365,   274,
     365,   365,   365,   326,    72,    64,    57,    70,    71,   326,
      64,    70,   394,   394,   172,   394,   394,   321,   403,   404,
      64,   325,   325,     1,   392,   365,   354,   365,   365,   365,
     365,   365,   365,   365,   274,   368,   365,   316,   313,   179,
     404,   404,   316,   320,    59,    60,    64,    60,    60,    57,
     322,    64,   354,   365,   365,   365,   365,   365,   365,   365,
     368,    57,    64,    64,    64,   405,   394,   316,   401,   100,
     365,   365,   365,   365,   179,   313,   320,   320,    64,    60,
      57,    55,   354,   365,   368,    64,    57,    64,   405,    99,
     326,   179,   320,    60,   354,    64,    57,   365,   321,   322,
      64,   316,   321,   322,    64,    57,   316,   321,   322,    57,
      57,   316,    57
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   205,   206,   207,   208,   208,   209,   209,   210,   210,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   212,   212,   212,   213,   214,   215,   215,   216,   217,
     218,   219,   219,   219,   219,   219,   219,   220,   221,   222,
     223,   224,   225,   225,   226,   227,   227,   228,   228,   229,
     229,   230,   231,   231,   231,   231,   232,   233,   233,   234,
     234,   234,   234,   235,   235,   235,   236,   236,   236,   237,
     237,   238,   238,   239,   239,   239,   239,   239,   239,   239,
     239,   239,   239,   239,   239,   239,   239,   239,   239,   239,
     239,   239,   239,   239,   239,   239,   239,   239,   239,   239,
     239,   239,   239,   239,   239,   239,   239,   239,   239,   239,
     239,   239,   239,   239,   239,   239,   239,   239,   239,   239,
     239,   239,   239,   239,   239,   240,   241,   241,   241,   241,
     242,   242,   243,   244,   245,   246,   246,   247,   247,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   258,   258,   259,   260,   260,   260,   261,   261,   262,
     262,   263,   264,   265,   266,   267,   268,   268,   268,   268,
     268,   268,   269,   270,   271,   271,   272,   273,   273,   274,
     274,   275,   276,   276,   277,   277,   278,   279,   280,   280,
     281,   282,   283,   283,   283,   284,   285,   285,   286,   287,
     288,   288,   288,   289,   290,   290,   290,   290,   290,   290,
     290,   291,   291,   292,   292,   292,   292,   292,   292,   292,
     292,   292,   292,   292,   292,   292,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   307,   308,   308,   309,   309,   310,   311,   311,
     312,   312,   312,   312,   312,   313,   313,   313,   314,   314,
     314,   314,   315,   316,   316,   316,   317,   317,   318,   318,
     318,   318,   319,   319,   319,   319,   319,   319,   320,   320,
     321,   322,   322,   322,   323,   323,   324,   325,   325,   326,
     326,   327,   327,   327,   328,   329,   330,   330,   331,   332,
     333,   333,   333,   334,   334,   334,   334,   334,   334,   334,
     334,   335,   336,   337,   337,   338,   339,   340,   340,   340,
     340,   341,   341,   341,   341,   341,   341,   341,   341,   342,
     342,   343,   343,   344,   344,   345,   345,   346,   346,   347,
     347,   347,   347,   348,   348,   349,   350,   351,   351,   352,
     352,   353,   353,   354,   354,   354,   355,   355,   356,   356,
     356,   357,   357,   358,   358,   359,   360,   361,   362,   363,
     364,   365,   365,   366,   367,   367,   368,   368,   369,   370,
     370,   371,   372,   372,   373,   374,   375,   375,   376,   376,
     376,   376,   376,   376,   377,   377,   377,   378,   378,   378,
     379,   379,   380,   381,   382,   382,   382,   383,   383,   384,
     385,   386,   387,   388,   388,   389,   390,   390,   391,   392,
     392,   393,   393,   394,   395,   395,   396,   396,   397,   397,
     398,   398,   399,   399,   399,   400,   400,   400,   400,   400,
     401,   402,   402,   402,   402,   403,   403,   403,   404,   404,
     404,   404,   405,   405,   405,   405,   406,   406,   406,   406,
     406,   406,   407,   407,   407,   407,   407,   408,   408,   409
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     5,     1,     3,     1,     2,     1,     0,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     5,     2,     1,     1,     1,     1,     2,     2,
       4,     1,     1,     1,     1,     1,     1,     2,     9,     6,
       6,     7,     0,     2,     7,     4,     3,     5,     4,     0,
       2,     2,     4,     4,     2,     3,     2,     0,     1,     2,
       2,     2,     2,     0,     6,     3,     3,     3,     1,     3,
       1,     0,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     7,     7,     8,     9,
       6,     6,     6,     7,     6,     7,     6,     8,     7,     7,
       6,     8,     8,     5,     6,     5,     4,     7,     7,     7,
       6,     6,     6,     1,     4,     4,     4,     6,     6,     8,
       7,     1,     8,    10,     8,     9,     1,     1,     1,     5,
       3,     2,    10,    13,     0,     2,    10,     9,     8,     1,
       5,    13,     0,     1,     0,     1,    10,    11,     0,     1,
       6,     5,     0,     2,     2,     6,     0,     1,     9,    16,
       9,     5,     6,     6,     5,     5,     4,     9,     9,     7,
       7,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     8,     7,     7,
       7,     7,     7,     9,     7,     7,     7,     7,     9,     8,
       4,     1,     1,     0,     2,     0,     1,     7,     9,     1,
      16,    14,    15,    15,    10,     1,     3,     3,     1,     3,
       5,     7,     5,     0,     2,     2,     0,     2,     0,     1,
       1,     1,     4,     6,     4,     6,     4,     6,     1,     1,
       1,     1,     3,     6,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     6,     6,     6,     8,     2,     8,
       0,     2,     2,     4,     4,     3,     6,     6,     6,     7,
       3,     2,     2,     9,     9,     2,     2,    12,    12,    11,
      11,     1,     2,     1,     1,     2,     1,     2,     1,     0,
       1,     0,     5,     0,     1,     0,     1,     0,     1,     1,
       1,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     5,     7,     4,
       4,     1,     3,     2,     2,     4,     0,     2,     1,     3,
       2,     3,     1,     4,     2,     1,     3,     4,     2,     2,
       1,     2,     1,     2,     1,     2,     2,     1,     2,     2,
       3,     4,     3,     7,     1,     5,     3,     5,     3,     5,
       1,     4,     7,     0,     3,     2,     3,     5,     1,     1,
       1,     1,     1,     1,     5,     1,     3,     1,     3,     1,
       3,     1,     3,     3,     1,     3,     3,     3,     3,     1,
       1,     3,     3,     3,     1,     3,     3,     1,     3,     3,
       3,     1,     2,     2,     2,     1,     1,     1,     3,     2,
       4,     1,     1,     1,     1,     1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (pBuilder, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, pBuilder); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, CISA_IR_Builder* pBuilder)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (pBuilder);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, CISA_IR_Builder* pBuilder)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, pBuilder);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, CISA_IR_Builder* pBuilder)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], pBuilder);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, pBuilder); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, CISA_IR_Builder* pBuilder)
{
  YY_USE (yyvaluep);
  YY_USE (pBuilder);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (CISA_IR_Builder* pBuilder)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (pBuilder);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* Listing: NewlinesOpt ListingHeader NewlinesOpt Statements NewlinesOpt  */
#line 677 "CISA.y"
                                                                      {
        TRACE("** Listing Complete\n");
        pBuilder->CISA_post_file_parse();
    }
#line 3100 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 23: /* Scope: ScopeStart error  */
#line 707 "CISA.y"
                       {
        PARSE_ERROR_AT((int)(yyvsp[-1].intval), "unclosed scope");
    }
#line 3108 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 24: /* ScopeStart: LBRACE  */
#line 711 "CISA.y"
           {
        pBuilder->CISA_push_decl_scope();
        (yyval.intval) = CISAlineno;
    }
#line 3117 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 25: /* ScopeEnd: RBRACE  */
#line 715 "CISA.y"
                 {pBuilder->CISA_pop_decl_scope();}
#line 3123 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 28: /* DirectiveKernel: DIRECTIVE_KERNEL IdentOrStringLit  */
#line 726 "CISA.y"
    {
        VISAKernel *cisa_kernel = NULL;
        pBuilder->AddKernel(cisa_kernel, (yyvsp[0].string));
    }
#line 3132 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 29: /* DirectiveGlobalFunction: DIRECTIVE_GLOBAL_FUNC IdentOrStringLit  */
#line 734 "CISA.y"
  {
      VISAFunction *cisa_kernel = NULL;
      pBuilder->AddFunction(cisa_kernel, (yyvsp[0].string));
  }
#line 3141 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 30: /* DirectiveVersion: DIRECTIVE_VERSION DEC_LIT DOT DEC_LIT  */
#line 742 "CISA.y"
   {
       pBuilder->CISA_IR_setVersion((unsigned char)(yyvsp[-2].intval), (unsigned char)(yyvsp[0].intval));
   }
#line 3149 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 37: /* DeclFunction: DIRECTIVE_FUNCDECL STRING_LIT  */
#line 756 "CISA.y"
    {
        // do nothing as it's informational only
    }
#line 3157 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 38: /* DeclVariable: DIRECTIVE_DECL IDENT V_TYPE_EQ_G DECL_DATA_TYPE NUM_ELTS_EQ IntExp AlignAttrOpt AliasAttrOpt GenAttrOpt  */
#line 763 "CISA.y"
    {
       ABORT_ON_FAIL(pBuilder->CISA_general_variable_decl(
           (yyvsp[-7].string), (unsigned int)(yyvsp[-3].intval), (yyvsp[-5].type), (yyvsp[-2].align), (yyvsp[-1].alias).aliasname, (yyvsp[-1].alias).offset, AttrOptVar, CISAlineno));
       AttrOptVar.clear();
    }
#line 3167 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 39: /* DeclAddress: DIRECTIVE_DECL IDENT V_TYPE_EQ_A NUM_ELTS_EQ IntExp GenAttrOpt  */
#line 771 "CISA.y"
   {
       ABORT_ON_FAIL(
           pBuilder->CISA_addr_variable_decl((yyvsp[-4].string), (unsigned int)(yyvsp[-1].intval), ISA_TYPE_UW, AttrOptVar, CISAlineno));
       AttrOptVar.clear();
   }
#line 3177 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 40: /* DeclPredicate: DIRECTIVE_DECL IDENT V_TYPE_EQ_P NUM_ELTS_EQ IntExp GenAttrOpt  */
#line 779 "CISA.y"
   {
       ABORT_ON_FAIL(pBuilder->CISA_predicate_variable_decl((yyvsp[-4].string), (unsigned int)(yyvsp[-1].intval), AttrOptVar, CISAlineno));
       AttrOptVar.clear();
   }
#line 3186 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 41: /* DeclSampler: DIRECTIVE_DECL IDENT V_TYPE_EQ_S NUM_ELTS_EQ IntExp VNameEqOpt GenAttrOpt  */
#line 786 "CISA.y"
   {
       ABORT_ON_FAIL(pBuilder->CISA_sampler_variable_decl((yyvsp[-5].string), (int)(yyvsp[-2].intval), (yyvsp[-1].string), CISAlineno));
   }
#line 3194 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 42: /* VNameEqOpt: %empty  */
#line 789 "CISA.y"
                    {(yyval.string) = "";}
#line 3200 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 43: /* VNameEqOpt: V_NAME_EQ IDENT  */
#line 789 "CISA.y"
                                                 {(yyval.string) = (yyvsp[0].string);}
#line 3206 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 44: /* DeclSurface: DIRECTIVE_DECL IDENT V_TYPE_EQ_T NUM_ELTS_EQ IntExp VNameEqOpt GenAttrOpt  */
#line 793 "CISA.y"
   {
       ABORT_ON_FAIL(pBuilder->CISA_surface_variable_decl((yyvsp[-5].string), (int)(yyvsp[-2].intval), (yyvsp[-1].string), AttrOptVar, CISAlineno));
       AttrOptVar.clear();
   }
#line 3215 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 45: /* DirectiveInput: DIRECTIVE_INPUT IDENT InputOffset InputSize  */
#line 801 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_input_directive((yyvsp[-2].string), (short)(yyvsp[-1].intval), (unsigned short)(yyvsp[0].intval), CISAlineno));
    }
#line 3223 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 46: /* DirectiveInput: DIRECTIVE_INPUT IDENT InputOffset  */
#line 806 "CISA.y"
    {
        int64_t size = 0;
        ABORT_ON_FAIL(pBuilder->CISA_eval_sizeof_decl(CISAlineno, (yyvsp[-1].string), size));
        MUST_HOLD(size < 0x10000, "declaration size is too large");
        ABORT_ON_FAIL(pBuilder->CISA_input_directive((yyvsp[-1].string), (short)(yyvsp[0].intval), (unsigned short)size, CISAlineno));
    }
#line 3234 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 47: /* DirectiveImplicitInput: DIRECTIVE_IMPLICIT IDENT InputOffset InputSize GenAttrOpt  */
#line 818 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_implicit_input_directive(
            (yyvsp[-4].string), (yyvsp[-3].string), (short)(yyvsp[-2].intval), (unsigned short)(yyvsp[-1].intval), CISAlineno));
    }
#line 3243 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 48: /* DirectiveImplicitInput: DIRECTIVE_IMPLICIT IDENT InputOffset GenAttrOpt  */
#line 825 "CISA.y"
    {
        int64_t size = 0;
        ABORT_ON_FAIL(pBuilder->CISA_eval_sizeof_decl(CISAlineno, (yyvsp[-2].string), size));
        MUST_HOLD(size < 0x10000, "declaration size is too large");
        ABORT_ON_FAIL(pBuilder->CISA_input_directive((yyvsp[-2].string), (short)(yyvsp[-1].intval), (unsigned short)size, CISAlineno));
    }
#line 3254 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 49: /* InputOffset: %empty  */
#line 832 "CISA.y"
                    {(yyval.intval) = 0;}
#line 3260 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 50: /* InputOffset: OFFSET_EQ IntExp  */
#line 832 "CISA.y"
                                                 {(yyval.intval) = (yyvsp[0].intval);}
#line 3266 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 51: /* InputSize: SIZE_EQ IntExp  */
#line 833 "CISA.y"
                          {(yyval.intval) = (yyvsp[0].intval);}
#line 3272 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 52: /* DirectiveAttr: DIRECTIVE_KERNEL_ATTR IDENT EQUALS STRING_LIT  */
#line 839 "CISA.y"
                                                  {
        ABORT_ON_FAIL(pBuilder->CISA_attr_directive((yyvsp[-2].string), (yyvsp[0].string), CISAlineno));
    }
#line 3280 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 53: /* DirectiveAttr: DIRECTIVE_KERNEL_ATTR IDENT EQUALS IntExp  */
#line 843 "CISA.y"
                                              {
        ABORT_ON_FAIL(pBuilder->CISA_attr_directiveNum((yyvsp[-2].string), (uint32_t)(yyvsp[0].intval), CISAlineno));
    }
#line 3288 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 54: /* DirectiveAttr: DIRECTIVE_KERNEL_ATTR IDENT  */
#line 847 "CISA.y"
                                {
        ABORT_ON_FAIL(pBuilder->CISA_attr_directive((yyvsp[0].string), nullptr, CISAlineno));
    }
#line 3296 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 55: /* DirectiveAttr: DIRECTIVE_KERNEL_ATTR IDENT EQUALS  */
#line 851 "CISA.y"
                                       {
        ABORT_ON_FAIL(pBuilder->CISA_attr_directive((yyvsp[-1].string), nullptr, CISAlineno));
    }
#line 3304 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 56: /* DirectiveFunc: DIRECTIVE_FUNC IdentOrStringLit  */
#line 857 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_function_directive((yyvsp[0].string), CISAlineno));
    }
#line 3312 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 57: /* AlignAttrOpt: %empty  */
#line 862 "CISA.y"
                     {(yyval.align) = ALIGN_BYTE;}
#line 3318 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 59: /* Align: ALIGN_EQ ALIGN_KEYWORD  */
#line 864 "CISA.y"
                           { // 2GRF, 32word, ...
        (yyval.align) = (yyvsp[0].align);
    }
#line 3326 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 60: /* Align: ALIGN_EQ IDENT  */
#line 868 "CISA.y"
                   { // e.g. byte, word, dword, qword, GRF, GRFx2
       if (!ParseAlign(pBuilder, (yyvsp[0].string), (yyval.align))) {
           PARSE_ERROR((yyvsp[0].string), ": invalid align value");
       }
    }
#line 3336 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 61: /* Align: ALIGN_EQ IntExp  */
#line 874 "CISA.y"
                    {
        // e.g. %sizeof(GRF) or %sizeof(DECL)
        if (!AlignBytesToVisaAlignment((int)(yyvsp[0].intval), (yyval.align))) {
            PARSE_ERROR("invalid align size (must be 1, 2, 4, 8, ..., 128)");
        }
    }
#line 3347 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 62: /* Align: ALIGN_EQ error  */
#line 881 "CISA.y"
                   {
        PARSE_ERROR("syntax error in align attribute");
    }
#line 3355 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 63: /* AliasAttrOpt: %empty  */
#line 888 "CISA.y"
    {
       (yyval.alias).aliasname = NULL;
       (yyval.alias).offset = 0;
    }
#line 3364 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 64: /* AliasAttrOpt: ALIAS_EQ LANGLE Var COMMA IntExpNRA RANGLE  */
#line 893 "CISA.y"
    {
       (yyval.alias).aliasname = (yyvsp[-3].string);
       (yyval.alias).offset = (int)(yyvsp[-1].intval);
    }
#line 3373 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 65: /* AliasAttrOpt: ALIAS_EQ LANGLE error  */
#line 898 "CISA.y"
    {
       PARSE_ERROR("syntax error in alias attribute");
    }
#line 3381 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 66: /* OneAttr: IDENT EQUALS IntExpNRA  */
#line 904 "CISA.y"
    {
      (yyval.pattr_gen) = pBuilder->CISA_Create_Attr((yyvsp[-2].string), (yyvsp[0].intval), nullptr);
    }
#line 3389 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 67: /* OneAttr: IDENT EQUALS STRING_LIT  */
#line 908 "CISA.y"
    {
      (yyval.pattr_gen) = pBuilder->CISA_Create_Attr((yyvsp[-2].string), 0, (yyvsp[0].string));
    }
#line 3397 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 68: /* OneAttr: IDENT  */
#line 912 "CISA.y"
    {
      (yyval.pattr_gen) = pBuilder->CISA_Create_Attr((yyvsp[0].string), 0, nullptr);
    }
#line 3405 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 69: /* AttrOpt: AttrOpt COMMA OneAttr  */
#line 918 "CISA.y"
    {
      AttrOptVar.push_back((yyvsp[0].pattr_gen));
    }
#line 3413 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 70: /* AttrOpt: OneAttr  */
#line 923 "CISA.y"
    {
      AttrOptVar.push_back((yyvsp[0].pattr_gen));
    }
#line 3421 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 71: /* GenAttrOpt: %empty  */
#line 929 "CISA.y"
    {
        (yyval.intval) = 0;
    }
#line 3429 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 72: /* GenAttrOpt: ATTR_EQ LBRACE AttrOpt RBRACE  */
#line 933 "CISA.y"
    {
        (yyval.intval) = 1;
    }
#line 3437 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 125: /* Label: LABEL  */
#line 995 "CISA.y"
             {pBuilder->CISA_create_label((yyvsp[0].string), CISAlineno);}
#line 3443 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 126: /* LogicInstruction: Predicate BINARY_LOGIC_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1000 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-6].pred_reg), (yyvsp[-5].opcode), (yyvsp[-4].sat), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, NULL, CISAlineno);
    }
#line 3452 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 127: /* LogicInstruction: Predicate BINARY_LOGIC_OP SatModOpt ExecSize PredVar PredVar PredVar  */
#line 1006 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-5].opcode), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, (yyvsp[-2].vISADecl), (yyvsp[-1].vISADecl), (yyvsp[0].vISADecl), CISAlineno);
    }
#line 3460 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 128: /* LogicInstruction: Predicate TERNARY_LOGIC_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1011 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-7].pred_reg), (yyvsp[-6].opcode), (yyvsp[-5].sat), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, CISAlineno);
    }
#line 3469 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 129: /* LogicInstruction: Predicate QUATERNARY_LOGIC_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1017 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-8].pred_reg), (yyvsp[-7].opcode), (yyvsp[-6].sat), (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size,
            (yyvsp[-4].genOperand).cisa_gen_opnd, (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3478 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 130: /* UnaryLogicInstruction: Predicate UNARY_LOGIC_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM  */
#line 1024 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].sat), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, NULL, NULL, CISAlineno);
    }
#line 3487 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 131: /* UnaryLogicInstruction: Predicate UNARY_LOGIC_OP SatModOpt ExecSize PredVar PredVar  */
#line 1030 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-4].opcode), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].vISADecl), (yyvsp[0].vISADecl), NULL, CISAlineno);
    }
#line 3496 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 132: /* MathInstruction_2OPND: Predicate MATH2_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM  */
#line 1037 "CISA.y"
    {
        pBuilder->CISA_create_math_instruction((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].sat), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, CISAlineno);
    }
#line 3505 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 133: /* MathInstruction_3OPND: Predicate MATH3_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1044 "CISA.y"
    {
        pBuilder->CISA_create_math_instruction((yyvsp[-6].pred_reg), (yyvsp[-5].opcode), (yyvsp[-4].sat), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3514 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 134: /* ArithInstruction_2OPND: Predicate ARITH2_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM  */
#line 1051 "CISA.y"
    {
        pBuilder->CISA_create_arith_instruction((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].sat), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, NULL, CISAlineno);
    }
#line 3523 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 135: /* ArithInstruction_3OPND: Predicate ARITH3_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1058 "CISA.y"
    {
        MUST_HOLD(!(((yyvsp[-5].opcode) == ISA_LINE) && ((yyvsp[-1].genOperand).type == OPERAND_IMMEDIATE || (yyvsp[-1].genOperand).type == OPERAND_INDIRECT)),
            "wrong type of src0 operand");
        pBuilder->CISA_create_arith_instruction(
            (yyvsp[-6].pred_reg), (yyvsp[-5].opcode), (yyvsp[-4].sat), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, CISAlineno);
    }
#line 3535 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 136: /* ArithInstruction_3OPND: Predicate ARITH5_OP2 ExecSize VecDstOperand_G_I PredVar VecSrcOperand_G_I_IMM  */
#line 1068 "CISA.y"
    {
        pBuilder->CISA_create_arith_instruction2_predDst((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].vISADecl), (yyvsp[0].genOperand).cisa_gen_opnd, nullptr, CISAlineno);
    }
#line 3544 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 137: /* ArithInstruction_4OPND: Predicate ARITH4_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1077 "CISA.y"
     {
         pBuilder->CISA_create_arith_instruction((yyvsp[-7].pred_reg), (yyvsp[-6].opcode), (yyvsp[-5].sat), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
     }
#line 3553 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 138: /* ArithInstruction_4OPND: Predicate ARITH4_OP2 ExecSize VecDstOperand_G_I VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1084 "CISA.y"
     {
        pBuilder->CISA_create_arith_instruction2((yyvsp[-6].pred_reg), (yyvsp[-5].opcode), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
     }
#line 3562 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 139: /* ArithInstruction_4OPND: Predicate ARITH5_OP2 ExecSize VecDstOperand_G_I PredVar VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1091 "CISA.y"
     {
        pBuilder->CISA_create_arith_instruction2_predDst((yyvsp[-6].pred_reg), (yyvsp[-5].opcode), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].vISADecl), (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
     }
#line 3571 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 140: /* DpasInstruction: DPAS_OP ExecSize RawOperand RawOperand RawOperand VecSrcOpndSimple  */
#line 1100 "CISA.y"
    {
        pBuilder->CISA_create_dpas_instruction(
            (yyvsp[-5].dpas_info).opcode, (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].genOperand).cisa_gen_opnd,
            (yyvsp[-5].dpas_info).src2Precision, (yyvsp[-5].dpas_info).src1Precision, (yyvsp[-5].dpas_info).depth, (yyvsp[-5].dpas_info).count, CISAlineno);
    }
#line 3582 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 141: /* BfnInstruction: Predicate BFN_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1110 "CISA.y"
    {
        pBuilder->CISA_create_bfn_instruction((yyvsp[-7].pred_reg), (yyvsp[-6].bfn_info).func_ctrl , (yyvsp[-5].sat), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3591 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 142: /* QwScatterInstruction: Predicate QW_SCATTER_OP DOT DEC_LIT ExecSize Var RawOperand RawOperand  */
#line 1116 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_qword_scatter_instruction(
            (yyvsp[-6].opcode), (yyvsp[-7].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, (uint32_t)(yyvsp[-4].intval), (yyvsp[-2].string), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 3600 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 143: /* FCvtInstruction: FCVT_OP SatModOpt ExecSize VecDstOperand_G VecSrcOperand_G_IMM  */
#line 1123 "CISA.y"
    {
        pBuilder->CISA_create_fcvt_instruction((yyvsp[-3].sat), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3608 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 144: /* AntiTrigInstruction: Predicate ANTI_TRIG_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM  */
#line 1129 "CISA.y"
    {
        pBuilder->CISA_create_invtri_inst((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].sat), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3617 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 145: /* AddrAddInstruction: ADDR_ADD_OP ExecSize VecDstOperand_A VecSrcOperand_G_A_AO VecSrcOperand_G_IMM_AO  */
#line 1138 "CISA.y"
    {
        // a grammatically problematic instruction
        //   addr_add (M1_NM, 1) A0(0)<1> &V127 - 0x10...
        //                                        ^^^^ next operand or V127 offset
        pBuilder->CISA_create_address_instruction((yyvsp[-4].opcode), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3629 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 146: /* SetpInstruction: SETP_OP ExecSize PredVar VecSrcOperand_G_I_IMM  */
#line 1148 "CISA.y"
    {
        pBuilder->CISA_create_setp_instruction(
            (yyvsp[-3].opcode), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size, (yyvsp[-1].vISADecl), (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3638 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 147: /* SelInstruction: Predicate SEL_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1155 "CISA.y"
    {
        pBuilder->CISA_create_sel_instruction((yyvsp[-5].opcode), (yyvsp[-4].sat), (yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3647 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 148: /* MinInstruction: Predicate MIN_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1162 "CISA.y"
    {
        pBuilder->CISA_create_fminmax_instruction(0, ISA_FMINMAX, (yyvsp[-4].sat), (yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3656 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 149: /* MaxInstruction: Predicate MAX_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1170 "CISA.y"
    {
        pBuilder->CISA_create_fminmax_instruction(
            1, ISA_FMINMAX, (yyvsp[-4].sat), (yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3666 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 150: /* MovInstruction: Predicate MOV_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM_A_AO  */
#line 1179 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_mov_instruction(
            (yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size, (yyvsp[-3].sat),
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno));
    }
#line 3676 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 151: /* MovInstruction: Predicate MOV_OP SatModOpt ExecSize VecDstOperand_A VecSrcOperand_G_I_IMM_A_AO  */
#line 1186 "CISA.y"
    {
        pBuilder->CISA_create_mov_instruction(
            (yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size, (yyvsp[-3].sat),
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3686 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 152: /* MovInstruction: Predicate MOV_OP SatModOpt ExecSize VecDstOperand_G_I PredVar  */
#line 1193 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_mov_instruction((yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].vISADecl), CISAlineno));
    }
#line 3694 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 153: /* BreakpointInstruction: BREAKPOINT_OP  */
#line 1199 "CISA.y"
    {
      pBuilder->CISA_create_breakpoint_instruction(CISAlineno);
    }
#line 3702 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 154: /* MovsInstruction: MOVS_OP ExecSize DstStateOperand SrcStateOperand  */
#line 1205 "CISA.y"
    {
        pBuilder->CISA_create_movs_instruction((yyvsp[-2].emask_exec_size).emask, ISA_MOVS, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].StateVar).cisa_gen_opnd, (yyvsp[0].StateVar).cisa_gen_opnd, CISAlineno);
    }
#line 3711 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 155: /* MovsInstruction: MOVS_OP ExecSize VecDstOperand_G SrcStateOperand  */
#line 1211 "CISA.y"
    {
        pBuilder->CISA_create_movs_instruction((yyvsp[-2].emask_exec_size).emask, ISA_MOVS, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].StateVar).cisa_gen_opnd, CISAlineno);
    }
#line 3720 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 156: /* MovsInstruction: MOVS_OP ExecSize DstStateOperand VecSrcOperand_G_I_IMM  */
#line 1217 "CISA.y"
    {
        pBuilder->CISA_create_movs_instruction((yyvsp[-2].emask_exec_size).emask, ISA_MOVS, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].StateVar).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3729 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 157: /* CmpInstruction: CMP_OP ConditionalModifier ExecSize PredVar VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1235 "CISA.y"
    {
        pBuilder->CISA_create_cmp_instruction((yyvsp[-4].cond_mod), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].vISADecl), (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3738 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 158: /* CmpInstruction: CMP_OP ConditionalModifier ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1242 "CISA.y"
    {
        // NOTE: predication not permitted.  Apparently the vISA API doesn't allow for predicated compares
        pBuilder->CISA_create_cmp_instruction(
            (yyvsp[-4].cond_mod), ISA_CMP, (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3749 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 159: /* MediaInstruction: MEDIA_OP MEDIA_MODE TwoDimOffset Var MediaInstructionPlaneID VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM RawOperand  */
#line 1252 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_media_instruction(
            (yyvsp[-7].opcode), (yyvsp[-6].media_mode), (yyvsp[-5].offset).row, (yyvsp[-5].offset).elem, (int)(yyvsp[-3].intval), (yyvsp[-4].string),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno));
    }
#line 3759 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 160: /* MediaInstruction: MEDIA_OP MEDIA_MODE TwoDimOffset Var VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM RawOperand  */
#line 1260 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_media_instruction(
            (yyvsp[-6].opcode), (yyvsp[-5].media_mode), (yyvsp[-4].offset).row, (yyvsp[-4].offset).elem, (int)0, (yyvsp[-3].string),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno));
    }
#line 3769 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 161: /* MediaInstructionPlaneID: DEC_LIT  */
#line 1266 "CISA.y"
                                 {
        MUST_HOLD((yyvsp[0].intval) <= 0xF, "PlaneID must less than 0xF");
        (yyval.intval) = (yyvsp[0].intval);
    }
#line 3778 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 162: /* ScatterInstruction: SCATTER_OP ElemNum ExecSize OwordModifier Var VecSrcOperand_G_I_IMM RawOperand RawOperand  */
#line 1274 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_scatter_instruction(
            (yyvsp[-7].opcode), (int)(yyvsp[-6].intval), (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-4].oword_mod), (yyvsp[-3].string),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 3788 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 163: /* ScatterTypedInstruction: Predicate SCATTER_TYPED_OP SAMPLER_CHANNEL ExecSize Var RawOperand RawOperand RawOperand RawOperand RawOperand  */
#line 1283 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_scatter4_typed_instruction(
            (yyvsp[-8].opcode), (yyvsp[-9].pred_reg), ChannelMask::createFromAPI((yyvsp[-7].s_channel)), (yyvsp[-6].emask_exec_size).emask, (yyvsp[-6].emask_exec_size).exec_size, (yyvsp[-5].string),
            (yyvsp[-4].RawVar), (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 3798 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 164: /* Scatter4ScaledInstruction: Predicate SCATTER4_SCALED_OP SAMPLER_CHANNEL ExecSize Var VecSrcOperand_G_I_IMM RawOperand RawOperand  */
#line 1292 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_scatter4_scaled_instruction(
            (yyvsp[-6].opcode), (yyvsp[-7].pred_reg), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size, ChannelMask::createFromAPI((yyvsp[-5].s_channel)), (yyvsp[-3].string),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 3808 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 165: /* ScatterScaledInstruction: Predicate SCATTER_SCALED_OP DOT DEC_LIT ExecSize Var VecSrcOperand_G_I_IMM RawOperand RawOperand  */
#line 1301 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_scatter_scaled_instruction(
            (yyvsp[-7].opcode), (yyvsp[-8].pred_reg), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size, (uint32_t) (yyvsp[-5].intval), (yyvsp[-3].string),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 3818 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 166: /* SynchronizationInstruction: BARRIER_OP  */
#line 1308 "CISA.y"
               {
        pBuilder->CISA_create_sync_instruction((yyvsp[0].opcode), CISAlineno);
    }
#line 3826 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 167: /* SynchronizationInstruction: SBARRIER_SIGNAL  */
#line 1311 "CISA.y"
                      {
        pBuilder->CISA_create_sbarrier_instruction(true, CISAlineno);
    }
#line 3834 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 168: /* SynchronizationInstruction: SBARRIER_WAIT  */
#line 1314 "CISA.y"
                    {
        pBuilder->CISA_create_sbarrier_instruction(false, CISAlineno);
    }
#line 3842 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 169: /* SynchronizationInstruction: NBARRIER_SIGNAL VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1317 "CISA.y"
                                                                                                              {
        pBuilder->CISA_create_nbarrier_signal((yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3850 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 170: /* SynchronizationInstruction: NBARRIER_SIGNAL VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1320 "CISA.y"
                                                                  {
        pBuilder->CISA_create_nbarrier(false, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3858 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 171: /* SynchronizationInstruction: NBARRIER_WAIT VecSrcOperand_G_I_IMM  */
#line 1323 "CISA.y"
                                          {
        pBuilder->CISA_create_nbarrier(true, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, CISAlineno);
    }
#line 3866 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 172: /* DwordAtomicInstruction: Predicate DWORD_ATOMIC_OP ATOMIC_SUB_OP Atomic16Opt ExecSize Var RawOperand RawOperand RawOperand RawOperand  */
#line 1329 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_dword_atomic_instruction(
            (yyvsp[-9].pred_reg), (yyvsp[-7].atomic_op), (yyvsp[-6].flag), (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-4].string), (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 3875 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 173: /* TypedAtomicInstruction: Predicate TYPED_ATOMIC_OP ATOMIC_SUB_OP Atomic16Opt ExecSize Var RawOperand RawOperand RawOperand RawOperand RawOperand RawOperand RawOperand  */
#line 1336 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_typed_atomic_instruction(
            (yyvsp[-12].pred_reg), (yyvsp[-10].atomic_op), (yyvsp[-9].flag), (yyvsp[-8].emask_exec_size).emask, (yyvsp[-8].emask_exec_size).exec_size, (yyvsp[-7].string),
            (yyvsp[-6].RawVar), (yyvsp[-5].RawVar), (yyvsp[-4].RawVar), (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 3885 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 174: /* Atomic16Opt: %empty  */
#line 1343 "CISA.y"
             {(yyval.flag) = false;}
#line 3891 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 175: /* Atomic16Opt: DOT DEC_LIT  */
#line 1344 "CISA.y"
                  { // .16
        MUST_HOLD(((yyvsp[0].intval) == 16), "only supports 16");
        (yyval.flag) = true;
    }
#line 3900 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 176: /* SampleUnormInstruction: SAMPLE_UNORM_OP SAMPLER_CHANNEL CHANNEL_OUTPUT Var Var VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM RawOperand  */
#line 1351 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_sampleunorm_instruction(
            (yyvsp[-9].opcode), ChannelMask::createFromAPI((yyvsp[-8].s_channel)), (yyvsp[-7].s_channel_output), (yyvsp[-6].string), (yyvsp[-5].string),
            (yyvsp[-4].genOperand).cisa_gen_opnd, (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno));
    }
#line 3910 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 177: /* SampleInstruction: SAMPLE_OP SAMPLER_CHANNEL SIMDMode Var Var RawOperand RawOperand RawOperand RawOperand  */
#line 1364 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_sample_instruction(
            (yyvsp[-8].opcode), ChannelMask::createFromAPI((yyvsp[-7].s_channel)), (int)(yyvsp[-6].intval), (yyvsp[-5].string), (yyvsp[-4].string),
            (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 3920 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 178: /* SampleInstruction: SAMPLE_OP SAMPLER_CHANNEL SIMDMode Var RawOperand RawOperand RawOperand RawOperand  */
#line 1372 "CISA.y"
   {
       ABORT_ON_FAIL(pBuilder->CISA_create_sample_instruction(
           (yyvsp[-7].opcode), ChannelMask::createFromAPI((yyvsp[-6].s_channel)), (int)(yyvsp[-5].intval), "", (yyvsp[-4].string),
           (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
   }
#line 3930 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 179: /* SamplerAddrOperand: Var  */
#line 1379 "CISA.y"
                     {
                      (yyval.sampler_base) = {(yyvsp[0].string), (unsigned int)0};
                     }
#line 3938 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 180: /* SamplerAddrOperand: LPAREN Var COMMA IntExpPrim RPAREN  */
#line 1384 "CISA.y"
                     {
                      (yyval.sampler_base) = {(yyvsp[-3].string), (unsigned int)(yyvsp[-1].intval)};
                     }
#line 3946 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 181: /* Sample3dInstruction: Predicate SAMPLE_3D_OP PixelNullMaskEnableOpt CPSEnableOpt NonUniformSamplerEnableOpt SAMPLER_CHANNEL ExecSize VecSrcOperand_G_I_IMM SamplerAddrOperand SamplerAddrOperand RawOperand RawOperand RawOperandArray  */
#line 1395 "CISA.y"
   {
       const bool success = pBuilder->create3DSampleInstruction(
           (yyvsp[-12].pred_reg), (yyvsp[-11].sample3DOp), (yyvsp[-10].pixel_null_mask), (yyvsp[-9].cps), (yyvsp[-8].non_uniform_sampler), ChannelMask::createFromAPI((yyvsp[-7].s_channel)),
           (yyvsp[-6].emask_exec_size).emask, (yyvsp[-6].emask_exec_size).exec_size, (yyvsp[-5].genOperand).cisa_gen_opnd, (yyvsp[-4].sampler_base).base, (yyvsp[-4].sampler_base).offset,
           (yyvsp[-3].sampler_base).base, (yyvsp[-3].sampler_base).offset,
           (yyvsp[-1].RawVar), (yyvsp[-2].RawVar), (unsigned int)(yyvsp[0].intval), rawOperandArray, CISAlineno);

    ABORT_ON_FAIL(success);
   }
#line 3960 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 182: /* CPSEnableOpt: %empty  */
#line 1405 "CISA.y"
                     {(yyval.cps) = false;}
#line 3966 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 183: /* CPSEnableOpt: CPS  */
#line 1405 "CISA.y"
                                          {(yyval.cps) = true;}
#line 3972 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 184: /* NonUniformSamplerEnableOpt: %empty  */
#line 1407 "CISA.y"
                                   {(yyval.non_uniform_sampler) = false;}
#line 3978 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 185: /* NonUniformSamplerEnableOpt: NON_UNIFORM_SAMPLER  */
#line 1407 "CISA.y"
                                                                       {(yyval.non_uniform_sampler) = true;}
#line 3984 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 186: /* Load3dInstruction: Predicate LOAD_3D_OP PixelNullMaskEnableOpt SAMPLER_CHANNEL ExecSize VecSrcOperand_G_I_IMM SamplerAddrOperand RawOperand RawOperand RawOperandArray  */
#line 1417 "CISA.y"
   {
       const bool success = pBuilder->create3DLoadInstruction(
           (yyvsp[-9].pred_reg), (yyvsp[-8].sample3DOp), (yyvsp[-7].pixel_null_mask), ChannelMask::createFromAPI((yyvsp[-6].s_channel)),
           (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-4].genOperand).cisa_gen_opnd, (yyvsp[-3].sampler_base).base, (yyvsp[-3].sampler_base).offset,
           (yyvsp[-1].RawVar), (yyvsp[-2].RawVar), (unsigned int)(yyvsp[0].intval), rawOperandArray, CISAlineno);

    ABORT_ON_FAIL(success);
   }
#line 3997 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 187: /* Gather43dInstruction: Predicate SAMPLE4_3D_OP PixelNullMaskEnableOpt SAMPLER_CHANNEL ExecSize VecSrcOperand_G_I_IMM SamplerAddrOperand SamplerAddrOperand RawOperand RawOperand RawOperandArray  */
#line 1434 "CISA.y"
   {
       const bool success = pBuilder->createSample4Instruction(
          (yyvsp[-10].pred_reg), (yyvsp[-9].sample3DOp), (yyvsp[-8].pixel_null_mask), ChannelMask::createFromAPI((yyvsp[-7].s_channel)), (yyvsp[-6].emask_exec_size).emask, (yyvsp[-6].emask_exec_size).exec_size,
          (yyvsp[-5].genOperand).cisa_gen_opnd, (yyvsp[-4].sampler_base).base, (yyvsp[-4].sampler_base).offset, (yyvsp[-3].sampler_base).base, (yyvsp[-3].sampler_base).offset,
           (yyvsp[-1].RawVar), (yyvsp[-2].RawVar),
          (unsigned int)(yyvsp[0].intval), rawOperandArray, CISAlineno);

    ABORT_ON_FAIL(success);
   }
#line 4011 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 188: /* PixelNullMaskEnableOpt: %empty  */
#line 1445 "CISA.y"
                               {(yyval.pixel_null_mask) = false;}
#line 4017 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 189: /* PixelNullMaskEnableOpt: PIXEL_NULL_MASK  */
#line 1445 "CISA.y"
                                                               {(yyval.pixel_null_mask) = true;}
#line 4023 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 190: /* ResInfo3dInstruction: RESINFO_OP_3D SAMPLER_CHANNEL ExecSize SamplerAddrOperand RawOperand RawOperand  */
#line 1449 "CISA.y"
   {
        ABORT_ON_FAIL(pBuilder->CISA_create_info_3d_instruction(
            VISA_3D_RESINFO, (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            ChannelMask::createFromAPI((yyvsp[-4].s_channel)), (yyvsp[-2].sampler_base).base, (yyvsp[-2].sampler_base).offset, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
   }
#line 4033 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 191: /* SampleInfo3dInstruction: SAMPLEINFO_OP_3D SAMPLER_CHANNEL ExecSize SamplerAddrOperand RawOperand  */
#line 1457 "CISA.y"
   {
        ABORT_ON_FAIL(pBuilder->CISA_create_info_3d_instruction(
            VISA_3D_SAMPLEINFO, (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            ChannelMask::createFromAPI((yyvsp[-3].s_channel)), (yyvsp[-1].sampler_base).base, (yyvsp[-1].sampler_base).offset, NULL, (yyvsp[0].RawVar), CISAlineno));
   }
#line 4043 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 192: /* RTWriteOperands: %empty  */
#line 1465 "CISA.y"
    {
    }
#line 4050 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 193: /* RTWriteOperands: RTWriteOperands VecSrcOperand_G_IMM  */
#line 1468 "CISA.y"
    {
        RTRWOperandsVec.push_back((yyvsp[0].genOperand).cisa_gen_opnd);
    }
#line 4058 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 194: /* RTWriteOperands: RTWriteOperands RawOperand  */
#line 1472 "CISA.y"
    {
        RTRWOperandsVec.push_back((yyvsp[0].RawVar));
    }
#line 4066 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 195: /* RTWriteInstruction: Predicate RTWRITE_OP_3D RTWriteModeOpt ExecSize Var RTWriteOperands  */
#line 1480 "CISA.y"
   {
       bool result = pBuilder->CISA_create_rtwrite_3d_instruction(
           (yyvsp[-5].pred_reg), (yyvsp[-3].string), (yyvsp[-2].emask_exec_size).emask, (unsigned int)(yyvsp[-2].emask_exec_size).exec_size, (yyvsp[-1].string),
           RTRWOperandsVec, CISAlineno);
       RTRWOperandsVec.clear();
       if (!result)
           YYABORT; // already reported
   }
#line 4079 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 196: /* RTWriteModeOpt: %empty  */
#line 1490 "CISA.y"
                       {(yyval.string) = 0;}
#line 4085 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 198: /* URBWriteInstruction: Predicate URBWRITE_OP_3D ExecSize DEC_LIT DEC_LIT RawOperand RawOperand RawOperand RawOperand  */
#line 1495 "CISA.y"
    {
        pBuilder->CISA_create_urb_write_3d_instruction(
            (yyvsp[-8].pred_reg), (yyvsp[-6].emask_exec_size).emask, (unsigned int)(yyvsp[-6].emask_exec_size).exec_size, (unsigned int)(yyvsp[-5].intval), (unsigned int)(yyvsp[-4].intval),
            (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 4095 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 199: /* AVSInstruction: AVS_OP SAMPLER_CHANNEL Var Var VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM CNTRL VecSrcOperand_G_I_IMM EXECMODE VecSrcOperand_G_I_IMM RawOperand  */
#line 1503 "CISA.y"
    {
        pBuilder->CISA_create_avs_instruction(
            ChannelMask::createFromAPI((yyvsp[-14].s_channel)), (yyvsp[-13].string), (yyvsp[-12].string),
            (yyvsp[-11].genOperand).cisa_gen_opnd, (yyvsp[-10].genOperand).cisa_gen_opnd, (yyvsp[-9].genOperand).cisa_gen_opnd, (yyvsp[-8].genOperand).cisa_gen_opnd,
            (yyvsp[-7].genOperand).cisa_gen_opnd, (yyvsp[-6].genOperand).cisa_gen_opnd, (yyvsp[-5].genOperand).cisa_gen_opnd, (yyvsp[-4].cntrl), (yyvsp[-3].genOperand).cisa_gen_opnd,
            (yyvsp[-2].execMode), (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno);
    }
#line 4107 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 200: /* VMEInstruction: VME_IME_OP VMEOpndIME Var RawOperand RawOperand RawOperand RawOperand RawOperand RawOperand  */
#line 1515 "CISA.y"
   {
       //     1 - OP
       //     2 - StreamMode, SearchCtrl
       //     3 - Surface
       //     4 - UNIInput
       //     5 - IMEInput
       //     6 - ref0
       //     7 - ref1
       //     8 - CostCenter
       //     9 - Output
        ABORT_ON_FAIL(pBuilder->CISA_create_vme_ime_instruction(
            (yyvsp[-8].opcode), (yyvsp[-7].vmeOpndIvb).streamMode, (yyvsp[-7].vmeOpndIvb).searchCtrl, (yyvsp[-5].RawVar), (yyvsp[-4].RawVar), (yyvsp[-6].string), (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
   }
#line 4125 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 201: /* VMEInstruction: VME_SIC_OP Var RawOperand RawOperand RawOperand  */
#line 1531 "CISA.y"
   {
        ABORT_ON_FAIL(pBuilder->CISA_create_vme_sic_instruction((yyvsp[-4].opcode), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[-3].string), (yyvsp[0].RawVar), CISAlineno));
   }
#line 4133 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 202: /* VMEInstruction: VME_FBR_OP VMEOpndFBR Var RawOperand RawOperand RawOperand  */
#line 1537 "CISA.y"
   {
        //    1 - OP
        //    2 - FBRMdMode, FBRSubMbShape, FBRSubPredMode
        //    3 - surface
        //    4 - UNIInput
        //    5 - FBRInput
        //    6 - output
        ABORT_ON_FAIL(pBuilder->CISA_create_vme_fbr_instruction((yyvsp[-5].opcode), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[-3].string),
            (yyvsp[-4].vmeOpndFbr).cisa_fbrMbMode_opnd, (yyvsp[-4].vmeOpndFbr).cisa_fbrSubMbShape_opnd, (yyvsp[-4].vmeOpndFbr).cisa_fbrSubPredMode_opnd, (yyvsp[0].RawVar), CISAlineno));
    }
#line 4148 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 203: /* OwordInstruction: OWORD_OP OwordModifier ExecSize Var VecSrcOperand_G_I_IMM RawOperand  */
#line 1550 "CISA.y"
    {
        ABORT_ON_FAIL(
            pBuilder->CISA_create_oword_instruction((yyvsp[-5].opcode), (yyvsp[-4].oword_mod), (yyvsp[-3].emask_exec_size).exec_size, (yyvsp[-2].string), (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno));
    }
#line 4157 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 204: /* SvmInstruction: SVM_OP SVM_ALIGNED ExecSize VecSrcOperand_G_I_IMM RawOperand  */
#line 1558 "CISA.y"
    {
        pBuilder->CISA_create_svm_block_instruction((SVMSubOpcode)(yyvsp[-4].opcode),
(yyvsp[-2].emask_exec_size).exec_size, false, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno);
    }
#line 4166 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 205: /* SvmInstruction: SVM_OP SVM_UNALIGNED ExecSize VecSrcOperand_G_I_IMM RawOperand  */
#line 1565 "CISA.y"
    {
        pBuilder->CISA_create_svm_block_instruction((SVMSubOpcode)(yyvsp[-4].opcode),
(yyvsp[-2].emask_exec_size).exec_size, true, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno);
    }
#line 4175 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 206: /* SvmInstruction: SVM_OP ExecSize VecSrcOperand_G_I_IMM RawOperand  */
#line 1573 "CISA.y"
    {
        pBuilder->CISA_create_svm_block_instruction((SVMSubOpcode)(yyvsp[-3].opcode),
(yyvsp[-2].emask_exec_size).exec_size, true, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno);
    }
#line 4184 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 207: /* SvmInstruction: Predicate SVM_SCATTER_OP DOT DEC_LIT DOT DEC_LIT ExecSize RawOperand RawOperand  */
#line 1579 "CISA.y"
    {
        pBuilder->CISA_create_svm_scatter_instruction((yyvsp[-8].pred_reg), (SVMSubOpcode)(yyvsp[-7].opcode), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (unsigned int)(yyvsp[-5].intval), (unsigned int)(yyvsp[-3].intval), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 4193 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 208: /* SvmInstruction: Predicate SVM_ATOMIC_OP ATOMIC_SUB_OP AtomicBitwidthOpt ExecSize RawOperand RawOperand RawOperand RawOperand  */
#line 1585 "CISA.y"
    {
        pBuilder->CISA_create_svm_atomic_instruction((yyvsp[-8].pred_reg), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size, (yyvsp[-6].atomic_op), (unsigned short)(yyvsp[-5].intval),
            (yyvsp[-3].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), (yyvsp[-2].RawVar), CISAlineno);
    }
#line 4202 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 209: /* SvmInstruction: Predicate SVM_GATHER4SCALED_OP SAMPLER_CHANNEL ExecSize VecSrcOperand_G_I_IMM RawOperand RawOperand  */
#line 1591 "CISA.y"
    {
        pBuilder->CISA_create_svm_gather4_scaled((yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, ChannelMask::createFromAPI((yyvsp[-4].s_channel)),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 4211 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 210: /* SvmInstruction: Predicate SVM_SCATTER4SCALED_OP SAMPLER_CHANNEL ExecSize VecSrcOperand_G_I_IMM RawOperand RawOperand  */
#line 1597 "CISA.y"
    {
        pBuilder->CISA_create_svm_scatter4_scaled((yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, ChannelMask::createFromAPI((yyvsp[-4].s_channel)),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 4220 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 211: /* AtomicBitwidthOpt: %empty  */
#line 1603 "CISA.y"
             {(yyval.intval) = 32;}
#line 4226 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 212: /* AtomicBitwidthOpt: DOT DEC_LIT  */
#line 1604 "CISA.y"
                  {
        MUST_HOLD((yyvsp[0].intval) == 16 || (yyvsp[0].intval) == 32 || (yyvsp[0].intval) == 64, "only supports 16 or 64");
        (yyval.intval) = (yyvsp[0].intval);
    }
#line 4235 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 227: /* LscUntypedLoad: Predicate LSC_LOAD_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts OVOpt ExecSize LscDataOperand LscUntypedAddrOperand  */
#line 1662 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-5].lsc_sfid), (yyvsp[-6].lsc_subOpcode), (yyvsp[-1].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_inst(
            (yyvsp[-7].pred_reg),  // predicate
            (yyvsp[-6].lsc_subOpcode),  // subop
            (yyvsp[-5].lsc_sfid),  // sfid
            (yyvsp[-4].lsc_caching_opts),  // caching settings
            (yyvsp[-3].ov),  // ov
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[0].lsc_addr_operand).addr,     // address
            (yyvsp[-1].lsc_data_operand).shape,    // data
            (yyvsp[0].lsc_addr_operand).surface,  // surface
            (yyvsp[0].lsc_addr_operand).surfaceIndex, // surface index
            (yyvsp[-1].lsc_data_operand).reg,      // dst
            (yyvsp[0].lsc_addr_operand).regs[0],  // src0
            nullptr,     // src1
            nullptr,     // src2
            CISAlineno);
    }
#line 4261 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 228: /* LscUntypedStridedLoad: Predicate LSC_LOAD_STRIDED_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscUntypedStridedAddrOperand  */
#line 1695 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[-1].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_strided_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[0].lsc_addr_operand).addr,     // address
            (yyvsp[-1].lsc_data_operand).shape,    // data
            (yyvsp[0].lsc_addr_operand).surface,  // surface
            (yyvsp[0].lsc_addr_operand).surfaceIndex, // surface index
            (yyvsp[-1].lsc_data_operand).reg,      // dst
            (yyvsp[0].lsc_addr_operand).regs[0],  // src0 base
            (yyvsp[0].lsc_addr_operand).regs[1],  // src0 stride
            nullptr,     // src1
            CISAlineno);
    }
#line 4286 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 229: /* LscUntypedBlock2dLoad: Predicate LSC_LOAD_BLOCK2D_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscDataOperand2D LscUntypedBlock2dAddrOperand  */
#line 1725 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[-1].lsc_data_operand2d).shape2D.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_block2d_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[-1].lsc_data_operand2d).shape2D,  // data shape
            (yyvsp[-1].lsc_data_operand2d).reg,      // dst
            (yyvsp[0].lsc_block2d_addr_operand).regs,     // src0 surface info / addrs
            nullptr,     // src1
            (yyvsp[0].lsc_block2d_addr_operand).immOffsets[0],
            (yyvsp[0].lsc_block2d_addr_operand).immOffsets[1],
            CISAlineno);
    }
#line 4309 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 230: /* LscUntypedStore: Predicate LSC_STORE_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscUntypedAddrOperand LscDataOperand  */
#line 1753 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[0].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // SFID
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            false,  // ov
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[-1].lsc_addr_operand).addr,     // address
            (yyvsp[0].lsc_data_operand).shape,    // data
            (yyvsp[-1].lsc_addr_operand).surface,  // surface
            (yyvsp[-1].lsc_addr_operand).surfaceIndex, // surface index
            nullptr,     // dst
            (yyvsp[-1].lsc_addr_operand).regs[0],  // src0
            (yyvsp[0].lsc_data_operand).reg,      // src1
            nullptr,     // src2
            CISAlineno);
    }
#line 4335 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 231: /* LscUntypedStridedStore: Predicate LSC_STORE_STRIDED_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscUntypedStridedAddrOperand LscDataOperand  */
#line 1780 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[0].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_strided_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // SFID
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[-1].lsc_addr_operand).addr,     // address
            (yyvsp[0].lsc_data_operand).shape,    // data
            (yyvsp[-1].lsc_addr_operand).surface,  // surface
            (yyvsp[-1].lsc_addr_operand).surfaceIndex, // surface index
            nullptr,     // dst
            (yyvsp[-1].lsc_addr_operand).regs[0],  // src0 base
            (yyvsp[-1].lsc_addr_operand).regs[1],  // src0 stride
            (yyvsp[0].lsc_data_operand).reg,      // src1
            CISAlineno);
    }
#line 4360 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 232: /* LscUntypedBlock2dStore: Predicate LSC_STORE_BLOCK2D_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscUntypedBlock2dAddrOperand LscDataOperand2D  */
#line 1808 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[0].lsc_data_operand2d).shape2D.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_block2d_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[0].lsc_data_operand2d).shape2D,  // data2d
            nullptr,     // dst
            (yyvsp[-1].lsc_block2d_addr_operand).regs,     // src0 addrs
            (yyvsp[0].lsc_data_operand2d).reg,      // src1
            (yyvsp[-1].lsc_block2d_addr_operand).immOffsets[0],
            (yyvsp[-1].lsc_block2d_addr_operand).immOffsets[1],
            CISAlineno);
    }
#line 4383 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 233: /* LscUntypedAtomic: Predicate LSC_ATOMIC_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscUntypedAddrOperand LscPayloadReg LscPayloadReg  */
#line 1837 "CISA.y"
    {
        (yyvsp[-4].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-6].lsc_sfid), (yyvsp[-7].lsc_subOpcode), (yyvsp[-3].lsc_data_operand).shape.order, (yyvsp[-4].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_inst(
            (yyvsp[-8].pred_reg),  // predicate
            (yyvsp[-7].lsc_subOpcode),                // op
            (yyvsp[-6].lsc_sfid),                // sfid
            (yyvsp[-5].lsc_caching_opts),                // caching settings
            false,             // ov
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-4].emask_exec_size).exec_size),
            (yyvsp[-4].emask_exec_size).emask,
            (yyvsp[-2].lsc_addr_operand).addr,         // address info
            (yyvsp[-3].lsc_data_operand).shape,        // data type
            (yyvsp[-2].lsc_addr_operand).surface,      // surface array base
            (yyvsp[-2].lsc_addr_operand).surfaceIndex, // surface index
            (yyvsp[-3].lsc_data_operand).reg,          // dst data
            (yyvsp[-2].lsc_addr_operand).regs[0],      // src0 addr
            (yyvsp[-1].RawVar),              // src1 data
            (yyvsp[0].RawVar),              // src2 data (for icas/fcas)
            CISAlineno);
    }
#line 4409 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 234: /* LscTypedMSRTLoad: Predicate LSC_LOAD_MSRT_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscTypedAddrOperandWithOffsets  */
#line 1864 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[-1].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[0].lsc_typed_operand).addr.type,     // address model
            (yyvsp[0].lsc_typed_operand).addr.size,     // address size
            (yyvsp[-1].lsc_data_operand).shape,         // data type
            (yyvsp[0].lsc_typed_operand).surface,       // surface array base
            (yyvsp[0].lsc_typed_operand).surfaceIndex,  // surface index
            (yyvsp[-1].lsc_data_operand).reg,           // dst data
            (yyvsp[0].lsc_typed_operand).regs[0],       // src0_u
            (yyvsp[0].lsc_typed_operand).uvrOffsets[0], // src0-u imm offsets
            (yyvsp[0].lsc_typed_operand).regs[1],       // src0_v
            (yyvsp[0].lsc_typed_operand).uvrOffsets[1], // src0-v imm offsets
            (yyvsp[0].lsc_typed_operand).regs[2],       // src0_r
            (yyvsp[0].lsc_typed_operand).uvrOffsets[2], // src0-r imm offsets
            (yyvsp[0].lsc_typed_operand).regs[3],       // sample index
            nullptr,          // src1 data
            nullptr,          // src2 data
            CISAlineno);
    }
#line 4441 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 235: /* LscTypedMSRTStore: Predicate LSC_STORE_MSRT_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts ExecSize LscTypedAddrOperandWithOffsets LscDataOperand  */
#line 1897 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[0].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[-1].lsc_typed_operand).addr.type,     // address model
            (yyvsp[-1].lsc_typed_operand).addr.size,     // address size
            (yyvsp[0].lsc_data_operand).shape,         // data type
            (yyvsp[-1].lsc_typed_operand).surface,       // surface array base
            (yyvsp[-1].lsc_typed_operand).surfaceIndex,  // surface index
            nullptr,          // dst
            (yyvsp[-1].lsc_typed_operand).regs[0],       // src0-u
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[0], // src0-u imm offsets
            (yyvsp[-1].lsc_typed_operand).regs[1],       // src0-v
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[1], // src0-v imm offsets
            (yyvsp[-1].lsc_typed_operand).regs[2],       // src0-r
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[2], // src0-r imm offsets
            (yyvsp[-1].lsc_typed_operand).regs[3],       // src0-sample-index
            (yyvsp[0].lsc_data_operand).reg,           // src1 data
            nullptr,          // src2 data
            CISAlineno);
    }
#line 4473 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 236: /* LscTypedLoad: Predicate LSC_LOAD_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscTypedAddrOperandWithOffsets  */
#line 1937 "CISA.y"
    {
        if ((yyvsp[-5].lsc_subOpcode) != LSC_LOAD_QUAD) {
            PARSE_ERROR("unsupported load operation for .tgm");
        }
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[-1].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[0].lsc_typed_operand).addr.type,      // address type
            (yyvsp[0].lsc_typed_operand).addr.size,      // address size
            (yyvsp[-1].lsc_data_operand).shape,          // data
            (yyvsp[0].lsc_typed_operand).surface,        // surface
            (yyvsp[0].lsc_typed_operand).surfaceIndex,   // surface index
            (yyvsp[-1].lsc_data_operand).reg,            // dst
            (yyvsp[0].lsc_typed_operand).regs[0],        // src0_u
            (yyvsp[0].lsc_typed_operand).uvrOffsets[0],  // u offset
            (yyvsp[0].lsc_typed_operand).regs[1],        // src0_v
            (yyvsp[0].lsc_typed_operand).uvrOffsets[1],  // v offset
            (yyvsp[0].lsc_typed_operand).regs[2],        // src0_r
            (yyvsp[0].lsc_typed_operand).uvrOffsets[2],  // r offset
            (yyvsp[0].lsc_typed_operand).regs[3],        // src0_lod
            nullptr,           // src1 data
            nullptr,           // src2 data
            CISAlineno);
    }
#line 4508 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 237: /* LscTypedStore: Predicate LSC_STORE_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts ExecSize LscTypedAddrOperandWithOffsets LscDataOperand  */
#line 1981 "CISA.y"
    {
        if ((yyvsp[-5].lsc_subOpcode) != LSC_STORE_QUAD) {
            PARSE_ERROR("unsupported store operation for .tgm");
        }
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[0].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[-1].lsc_typed_operand).addr.type,     // address model
            (yyvsp[-1].lsc_typed_operand).addr.size,     // address size
            (yyvsp[0].lsc_data_operand).shape,         // data size
            (yyvsp[-1].lsc_typed_operand).surface,       // surface
            (yyvsp[-1].lsc_typed_operand).surfaceIndex,  // surface index
            nullptr,          // dst
            (yyvsp[-1].lsc_typed_operand).regs[0],       // src0_u
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[0], // u offset
            (yyvsp[-1].lsc_typed_operand).regs[1],       // src0_v
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[1], // v offset
            (yyvsp[-1].lsc_typed_operand).regs[2],       // src0-r
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[2], // r offset
            (yyvsp[-1].lsc_typed_operand).regs[3],       // src0_lod
            (yyvsp[0].lsc_data_operand).reg,           // stored data
            nullptr,          // src2
            CISAlineno);
    }
#line 4543 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 238: /* LscTypedAtomic: Predicate LSC_ATOMIC_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscTypedAddrOperandWithOffsets LscPayloadReg LscPayloadReg  */
#line 2026 "CISA.y"
    {
        (yyvsp[-4].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-6].lsc_sfid), (yyvsp[-7].lsc_subOpcode), (yyvsp[-3].lsc_data_operand).shape.order, (yyvsp[-4].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-8].pred_reg),  // predicate
            (yyvsp[-7].lsc_subOpcode),  // subop
            (yyvsp[-6].lsc_sfid),  // sfid
            (yyvsp[-5].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-4].emask_exec_size).exec_size),
            (yyvsp[-4].emask_exec_size).emask,
            (yyvsp[-2].lsc_typed_operand).addr.type, // address model
            (yyvsp[-2].lsc_typed_operand).addr.size,  // address size
            (yyvsp[-3].lsc_data_operand).shape,    // data type
            (yyvsp[-2].lsc_typed_operand).surface,  // surface
            (yyvsp[-2].lsc_typed_operand).surfaceIndex, // surface index
            (yyvsp[-3].lsc_data_operand).reg,      // dst data
            (yyvsp[-2].lsc_typed_operand).regs[0],  // src0 addrs u
            (yyvsp[-2].lsc_typed_operand).uvrOffsets[0], // u offset
            (yyvsp[-2].lsc_typed_operand).regs[1],  // src0 addrs v
            (yyvsp[-2].lsc_typed_operand).uvrOffsets[1], // v offset
            (yyvsp[-2].lsc_typed_operand).regs[2],  // src0 addrs r
            (yyvsp[-2].lsc_typed_operand).uvrOffsets[2], // r offset
            (yyvsp[-2].lsc_typed_operand).regs[3],  // src0 addrs lod
            (yyvsp[-1].RawVar),          // src1 data
            (yyvsp[0].RawVar),          // src2 data
            CISAlineno);
    }
#line 4575 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 239: /* LscTypedReadStateInfo: Predicate LSC_READ_STATE_INFO_MNEMONIC LSC_SFID_TYPED_TOKEN LscPayloadReg LscAddrModelStateful LBRACK LscPayloadNonNullReg RBRACK  */
#line 2062 "CISA.y"
   {
        LSC_CACHE_OPTS caching {LSC_CACHING_DEFAULT,LSC_CACHING_DEFAULT};
        LSC_DATA_SHAPE dataShape {LSC_DATA_SIZE_32b,LSC_DATA_ORDER_TRANSPOSE};
        dataShape.elems = LSC_DATA_ELEMS_16;
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-7].pred_reg),              // predicate
            (yyvsp[-6].lsc_subOpcode),              // subop
            (yyvsp[-5].lsc_sfid),              // sfid
            caching,         // no caching settings
            EXEC_SIZE_1,
            vISA_EMASK_M1_NM,
            (yyvsp[-3].lsc_addr_model).type,           // address type
            LSC_ADDR_SIZE_32b, // address size
            dataShape,         // data type
            (yyvsp[-3].lsc_addr_model).surface,        // surface
            (yyvsp[-3].lsc_addr_model).surfaceIndex,   // SS_IDX
            (yyvsp[-4].RawVar),                // dst data
            (yyvsp[-1].RawVar),                // src0 coords (u, v, r, lod) SIMD1 are packed in
            0,                 // no uvr-offsets
            nullptr,           // no other coords
            0,                 // no uvr-offsets
            nullptr,           // no other coords
            0,                 // no uvr-offsets
            nullptr,           // no other coords
            nullptr,           // no src1 data
            nullptr,           // no src2 data
            CISAlineno);
   }
#line 4608 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 240: /* LscFence: LSC_FENCE_MNEMONIC LscSfid LSC_FENCE_OP_TYPE LSC_FENCE_SCOPE  */
#line 2099 "CISA.y"
    {
        pBuilder->CISA_create_lsc_fence((yyvsp[-2].lsc_sfid), (yyvsp[-1].lsc_fence_op), (yyvsp[0].lsc_scope), CISAlineno);
    }
#line 4616 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 243: /* LscCacheOpts: %empty  */
#line 2106 "CISA.y"
                                    {(yyval.lsc_caching_opts) = pBuilder->CISA_create_caching_opts(CISAlineno);}
#line 4622 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 244: /* LscCacheOpts: LSC_CACHING_OPT LSC_CACHING_OPT  */
#line 2107 "CISA.y"
                                    {(yyval.lsc_caching_opts) = pBuilder->CISA_create_caching_opts((yyvsp[-1].lsc_caching_opt),(yyvsp[0].lsc_caching_opt), CISAlineno);}
#line 4628 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 245: /* OVOpt: %empty  */
#line 2109 "CISA.y"
              {(yyval.ov) = false;}
#line 4634 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 246: /* OVOpt: OV  */
#line 2109 "CISA.y"
                                 {(yyval.ov) = true;}
#line 4640 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 247: /* LscUntypedAddrOperand: LscAddrModelOpt LBRACK LscAddrImmScaleOpt LscPayloadNonNullReg LscAddrImmOffsetOpt RBRACK LSC_ADDR_SIZE_TK  */
#line 2116 "CISA.y"
    {
        (yyval.lsc_addr_operand) = {(yyvsp[-6].lsc_addr_model).surface, (yyvsp[-6].lsc_addr_model).surfaceIndex, {(yyvsp[-3].RawVar)}, {(yyvsp[-6].lsc_addr_model).type, (int)(yyvsp[-4].intval), (int)(yyvsp[-2].intval), (yyvsp[0].lsc_addr_size)}};
    }
#line 4648 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 248: /* LscUntypedStridedAddrOperand: LscAddrModelOpt LBRACK LscAddrImmScaleOpt LscPayloadNonNullReg LscAddrImmOffsetOpt COMMA LscVectorOpRegOrImm32 RBRACK LSC_ADDR_SIZE_TK  */
#line 2125 "CISA.y"
    {
        (yyval.lsc_addr_operand) = {(yyvsp[-8].lsc_addr_model).surface, (yyvsp[-8].lsc_addr_model).surfaceIndex, {(yyvsp[-5].RawVar), (yyvsp[-2].lsc_addr_surface_ident)}, {(yyvsp[-8].lsc_addr_model).type, (int)(yyvsp[-6].intval), (int)(yyvsp[-4].intval), (yyvsp[0].lsc_addr_size)}};
    }
#line 4656 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 249: /* LscUntypedStridedAddrOperand: LscUntypedAddrOperand  */
#line 2128 "CISA.y"
                            {
        (yyval.lsc_addr_operand) = (yyvsp[0].lsc_addr_operand);
        (yyval.lsc_addr_operand).regs[1] = nullptr;
    }
#line 4665 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 250: /* LscUntypedBlock2dAddrOperand: LSC_AM_FLAT LBRACK LscVectorOpReg COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpReg LscAddrImmOffsetOpt COMMA LscVectorOpReg LscAddrImmOffsetOpt RBRACK  */
#line 2152 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {nullptr,0,{(yyvsp[-13].lsc_addr_surface_ident),(yyvsp[-11].lsc_addr_surface_ident),(yyvsp[-9].lsc_addr_surface_ident),(yyvsp[-7].lsc_addr_surface_ident),(yyvsp[-5].lsc_addr_surface_ident),(yyvsp[-2].lsc_addr_surface_ident)},{(int)(yyvsp[-4].intval), (int)(yyvsp[-1].intval)},{LSC_ADDR_TYPE_FLAT,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 4673 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 251: /* LscUntypedBlock2dAddrOperand: LSC_AM_FLAT LBRACK LscVectorOpReg COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpImm32 COMMA LscVectorOpImm32 RBRACK  */
#line 2172 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {nullptr,0,{(yyvsp[-11].lsc_addr_surface_ident),(yyvsp[-9].lsc_addr_surface_ident),(yyvsp[-7].lsc_addr_surface_ident),(yyvsp[-5].lsc_addr_surface_ident),(yyvsp[-3].lsc_addr_surface_ident),(yyvsp[-1].lsc_addr_surface_ident)},{0, 0},{LSC_ADDR_TYPE_FLAT,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 4681 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 252: /* LscUntypedBlock2dAddrOperand: LSC_AM_FLAT LBRACK LscVectorOpReg COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpImm32 COMMA LscVectorOpReg LscAddrImmOffsetOpt RBRACK  */
#line 2192 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {nullptr,0,{(yyvsp[-12].lsc_addr_surface_ident),(yyvsp[-10].lsc_addr_surface_ident),(yyvsp[-8].lsc_addr_surface_ident),(yyvsp[-6].lsc_addr_surface_ident),(yyvsp[-4].lsc_addr_surface_ident),(yyvsp[-2].lsc_addr_surface_ident)},{0, (int)(yyvsp[-1].intval)},{LSC_ADDR_TYPE_FLAT,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 4689 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 253: /* LscUntypedBlock2dAddrOperand: LSC_AM_FLAT LBRACK LscVectorOpReg COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpReg LscAddrImmOffsetOpt COMMA LscVectorOpImm32 RBRACK  */
#line 2212 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {nullptr,0,{(yyvsp[-12].lsc_addr_surface_ident),(yyvsp[-10].lsc_addr_surface_ident),(yyvsp[-8].lsc_addr_surface_ident),(yyvsp[-6].lsc_addr_surface_ident),(yyvsp[-4].lsc_addr_surface_ident),(yyvsp[-1].lsc_addr_surface_ident)},{(int)(yyvsp[-3].intval), 0},{LSC_ADDR_TYPE_FLAT,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 4697 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 254: /* LscUntypedBlock2dAddrOperand: LSC_AM_FLAT LBRACK LscVectorOpReg PLUS LPAREN IntExpUnr COMMA IntExpUnr RPAREN RBRACK  */
#line 2220 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {nullptr,0,{(yyvsp[-7].lsc_addr_surface_ident),nullptr,nullptr,nullptr,nullptr,nullptr},{(int)(yyvsp[-4].intval),(int)(yyvsp[-2].intval)},{LSC_ADDR_TYPE_FLAT,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 4705 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 255: /* LscTypedAddrWithOffsetOperand: LscPayloadNonNullReg  */
#line 2225 "CISA.y"
    {
        (yyval.lsc_typed_addr_operand) = {(yyvsp[0].RawVar), 0};
    }
#line 4713 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 256: /* LscTypedAddrWithOffsetOperand: LscPayloadNonNullReg PLUS IntExpMul  */
#line 2228 "CISA.y"
                                          {
        (yyval.lsc_typed_addr_operand) = {(yyvsp[-2].RawVar), (int)(yyvsp[0].intval)};
    }
#line 4721 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 257: /* LscTypedAddrWithOffsetOperand: LscPayloadNonNullReg MINUS IntExpMul  */
#line 2232 "CISA.y"
    {
        (yyval.lsc_typed_addr_operand) = {(yyvsp[-2].RawVar), (int)-(yyvsp[0].intval)};
    }
#line 4729 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 258: /* LscTypedAddrWithOffsetOperandList: LscTypedAddrWithOffsetOperand  */
#line 2236 "CISA.y"
                                    {
        (yyval.lsc_typed_addr_operand_list) = {{(yyvsp[0].lsc_typed_addr_operand).reg}, {(yyvsp[0].lsc_typed_addr_operand).offset, 0, 0}};
      }
#line 4737 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 259: /* LscTypedAddrWithOffsetOperandList: LscTypedAddrWithOffsetOperand COMMA LscTypedAddrWithOffsetOperand  */
#line 2241 "CISA.y"
      {
        (yyval.lsc_typed_addr_operand_list) = {{(yyvsp[-2].lsc_typed_addr_operand).reg,(yyvsp[0].lsc_typed_addr_operand).reg}, {(yyvsp[-2].lsc_typed_addr_operand).offset, (yyvsp[0].lsc_typed_addr_operand).offset, 0}};
      }
#line 4745 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 260: /* LscTypedAddrWithOffsetOperandList: LscTypedAddrWithOffsetOperand COMMA LscTypedAddrWithOffsetOperand COMMA LscTypedAddrWithOffsetOperand  */
#line 2247 "CISA.y"
    {
        (yyval.lsc_typed_addr_operand_list) = {{(yyvsp[-4].lsc_typed_addr_operand).reg,(yyvsp[-2].lsc_typed_addr_operand).reg,(yyvsp[0].lsc_typed_addr_operand).reg}, {(yyvsp[-4].lsc_typed_addr_operand).offset, (yyvsp[-2].lsc_typed_addr_operand).offset, (yyvsp[0].lsc_typed_addr_operand).offset}};
    }
#line 4753 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 261: /* LscTypedAddrWithOffsetOperandList: LscTypedAddrWithOffsetOperand COMMA LscTypedAddrWithOffsetOperand COMMA LscTypedAddrWithOffsetOperand COMMA LscPayloadNonNullReg  */
#line 2254 "CISA.y"
    {
        (yyval.lsc_typed_addr_operand_list) = {{(yyvsp[-6].lsc_typed_addr_operand).reg,(yyvsp[-4].lsc_typed_addr_operand).reg,(yyvsp[-2].lsc_typed_addr_operand).reg,(yyvsp[0].RawVar)}, {(yyvsp[-6].lsc_typed_addr_operand).offset, (yyvsp[-4].lsc_typed_addr_operand).offset, (yyvsp[-2].lsc_typed_addr_operand).offset}};
    }
#line 4761 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 262: /* LscTypedAddrOperandWithOffsets: LscAddrModelStateful LBRACK LscTypedAddrWithOffsetOperandList RBRACK LSC_ADDR_SIZE_TK  */
#line 2260 "CISA.y"
    {
        (yyval.lsc_typed_operand) = {(yyvsp[-4].lsc_addr_model).surface, (yyvsp[-4].lsc_addr_model).surfaceIndex,
               {(yyvsp[-2].lsc_typed_addr_operand_list).regs[0], (yyvsp[-2].lsc_typed_addr_operand_list).regs[1], (yyvsp[-2].lsc_typed_addr_operand_list).regs[2],(yyvsp[-2].lsc_typed_addr_operand_list).regs[3]},
               {(yyvsp[-2].lsc_typed_addr_operand_list).uvrOffsets[0], (yyvsp[-2].lsc_typed_addr_operand_list).uvrOffsets[1], (yyvsp[-2].lsc_typed_addr_operand_list).uvrOffsets[2]},
               {(yyvsp[-4].lsc_addr_model).type, 1, 0, (yyvsp[0].lsc_addr_size)}};
    }
#line 4772 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 263: /* LscAddrImmOffsetOpt: %empty  */
#line 2271 "CISA.y"
                     {(yyval.intval) =   0;}
#line 4778 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 264: /* LscAddrImmOffsetOpt: PLUS IntExpAdd  */
#line 2272 "CISA.y"
                     {(yyval.intval) =  (yyvsp[0].intval);}
#line 4784 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 265: /* LscAddrImmOffsetOpt: MINUS IntExpMul  */
#line 2273 "CISA.y"
                     {(yyval.intval) = -(yyvsp[0].intval);}
#line 4790 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 266: /* LscAddrImmScaleOpt: %empty  */
#line 2278 "CISA.y"
                     {(yyval.intval) = 1;}
#line 4796 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 267: /* LscAddrImmScaleOpt: IntExpPrim TIMES  */
#line 2279 "CISA.y"
                     {(yyval.intval) = (yyvsp[-1].intval);}
#line 4802 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 268: /* LscAddrModelOpt: %empty  */
#line 2282 "CISA.y"
                 {(yyval.lsc_addr_model) = {LSC_ADDR_TYPE_FLAT, nullptr, 0};}
#line 4808 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 269: /* LscAddrModelOpt: LSC_AM_FLAT  */
#line 2283 "CISA.y"
                 {(yyval.lsc_addr_model) = {LSC_ADDR_TYPE_FLAT, nullptr, 0};}
#line 4814 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 270: /* LscAddrModelOpt: LSC_AM_ARG  */
#line 2284 "CISA.y"
                 {(yyval.lsc_addr_model) = {LSC_ADDR_TYPE_ARG, nullptr, 0};}
#line 4820 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 272: /* LscAddrModelStateful: LSC_AM_BSS LPAREN LscVectorOpRegOrImm32 RPAREN  */
#line 2289 "CISA.y"
                                                     {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_BSS,(yyvsp[-1].lsc_addr_surface_ident), 0};
    }
#line 4828 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 273: /* LscAddrModelStateful: LSC_AM_BSS LPAREN LscVectorOpRegOrImm32 COMMA IntExp RPAREN  */
#line 2292 "CISA.y"
                                                                  {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_BSS, (yyvsp[-3].lsc_addr_surface_ident), (int)(yyvsp[-1].intval)};
    }
#line 4836 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 274: /* LscAddrModelStateful: LSC_AM_SS LPAREN LscVectorOpRegOrImm32 RPAREN  */
#line 2295 "CISA.y"
                                                     {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_SS,(yyvsp[-1].lsc_addr_surface_ident), 0};
    }
#line 4844 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 275: /* LscAddrModelStateful: LSC_AM_SS LPAREN LscVectorOpRegOrImm32 COMMA IntExp RPAREN  */
#line 2298 "CISA.y"
                                                                  {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_SS,(yyvsp[-3].lsc_addr_surface_ident), (int)(yyvsp[-1].intval)};
    }
#line 4852 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 276: /* LscAddrModelStateful: LSC_AM_BTI LPAREN LscVectorOpRegOrImm32 RPAREN  */
#line 2301 "CISA.y"
                                                     {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_BTI,(yyvsp[-1].lsc_addr_surface_ident), 0};
    }
#line 4860 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 277: /* LscAddrModelStateful: LSC_AM_BTI LPAREN LscVectorOpRegOrImm32 COMMA IntExp RPAREN  */
#line 2304 "CISA.y"
                                                                  {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_BTI,(yyvsp[-3].lsc_addr_surface_ident), (int)(yyvsp[-1].intval)};
    }
#line 4868 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 280: /* LscVectorOpImm32: IntExp  */
#line 2313 "CISA.y"
           {
        (yyval.lsc_addr_surface_ident) = pBuilder->CISA_create_immed((yyvsp[0].intval), ISA_TYPE_UD, CISAlineno);
    }
#line 4876 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 281: /* LscVectorOpReg: Var  */
#line 2323 "CISA.y"
        {
        ABORT_ON_FAIL((yyval.lsc_addr_surface_ident) = pBuilder->CISA_create_gen_src_operand(
            (yyvsp[0].string),
            0, 1, 0, // region
            0, 0, // row and col offset
            MODIFIER_NONE, CISAlineno));
    }
#line 4888 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 282: /* LscVectorOpReg: Var DOT DEC_LIT  */
#line 2331 "CISA.y"
                    {
        ABORT_ON_FAIL((yyval.lsc_addr_surface_ident) = pBuilder->CISA_create_gen_src_operand(
            (yyvsp[-2].string),
            0, 1, 0, // region
            0, (unsigned char)(yyvsp[0].intval), // row and col offset
            MODIFIER_NONE, CISAlineno));
    }
#line 4900 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 283: /* LscVectorOpReg: Var LPAREN IntExp COMMA IntExp RPAREN  */
#line 2339 "CISA.y"
                                          {
        MUST_HOLD((yyvsp[-3].intval) <= 255 || (yyvsp[-3].intval) >= 0, "row is out of bounds");
        MUST_HOLD((yyvsp[-1].intval) <= 255 || (yyvsp[-1].intval) >= 0, "col is out of bounds");
        (yyval.lsc_addr_surface_ident) = pBuilder->CISA_create_gen_src_operand(
            (yyvsp[-5].string),
            0, 1, 0,
            (unsigned char)(yyvsp[-3].intval), (unsigned char)(yyvsp[-1].intval), // row and col offset
            MODIFIER_NONE, CISAlineno);
        if ((yyval.lsc_addr_surface_ident) == nullptr) {
            PARSE_ERROR("cannot find surface variable");
        }
    }
#line 4917 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 284: /* LscDataOperand: LscPayloadReg LSC_DATA_SHAPE_TK  */
#line 2353 "CISA.y"
                                     {
        (yyval.lsc_data_operand) = {(yyvsp[-1].RawVar),(yyvsp[0].lsc_data_shape)};
    }
#line 4925 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 285: /* LscDataOperand: LscPayloadReg LSC_DATA_SHAPE_TK_CHMASK  */
#line 2357 "CISA.y"
                                            {
        (yyval.lsc_data_operand) = {(yyvsp[-1].RawVar),(yyvsp[0].lsc_data_shape)};
    }
#line 4933 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 286: /* LscDataOperand2D: LscPayloadReg LSC_DATA_SHAPE_TK_BLOCK2D  */
#line 2363 "CISA.y"
                                            {
        (yyval.lsc_data_operand2d) = {(yyvsp[-1].RawVar),(yyvsp[0].lsc_data_shape2d)};
    }
#line 4941 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 288: /* LscPayloadReg: Var  */
#line 2371 "CISA.y"
        {
        ABORT_ON_FAIL((yyval.RawVar) = pBuilder->CISA_create_RAW_operand((yyvsp[0].string), 0, CISAlineno));
    }
#line 4949 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 290: /* LscPayloadNonNullReg: VarNonNull  */
#line 2378 "CISA.y"
               {
        ABORT_ON_FAIL((yyval.RawVar) = pBuilder->CISA_create_RAW_operand((yyvsp[0].string), 0, CISAlineno));
    }
#line 4957 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 294: /* LscTypedBlock2dLoad: Predicate LSC_LOAD_BLOCK2D_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts LscDataOperandTyped2D LscTypedBlock2dAddrOperand  */
#line 2402 "CISA.y"
    {
        pBuilder->CISA_create_lsc_typed_block2d_inst(
            (yyvsp[-4].lsc_subOpcode),  // subop
            (yyvsp[-2].lsc_caching_opts),  // caching settings
            (yyvsp[0].lsc_block2d_addr_operand).addr.type, // address model
            (yyvsp[-1].lsc_data_operand_typed2d).shape_typed2d,  // data shape
            (yyvsp[0].lsc_block2d_addr_operand).surface,  //surface
            (yyvsp[0].lsc_block2d_addr_operand).surfaceIndex, // surface index
            (yyvsp[-1].lsc_data_operand_typed2d).reg,      // dst
            (yyvsp[0].lsc_block2d_addr_operand).regs[0],     // src0 addrs(block start offset x)
            (yyvsp[0].lsc_block2d_addr_operand).regs[1],     // src0 addrs(block start offset y)
            (yyvsp[0].lsc_block2d_addr_operand).immOffsets[0], // x immediate offset
            (yyvsp[0].lsc_block2d_addr_operand).immOffsets[1], // y immediate offset
            nullptr,     // src1
            CISAlineno);
   }
#line 4978 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 295: /* LscTypedBlock2dStore: Predicate LSC_STORE_BLOCK2D_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts LscTypedBlock2dAddrOperand LscDataOperandTyped2D  */
#line 2431 "CISA.y"
    {
        pBuilder->CISA_create_lsc_typed_block2d_inst(
            (yyvsp[-4].lsc_subOpcode),  // subop
            (yyvsp[-2].lsc_caching_opts),  // caching settings
            (yyvsp[-1].lsc_block2d_addr_operand).addr.type, // address model
            (yyvsp[0].lsc_data_operand_typed2d).shape_typed2d,  // data shape
            (yyvsp[-1].lsc_block2d_addr_operand).surface,  //surface
            (yyvsp[-1].lsc_block2d_addr_operand).surfaceIndex,
            nullptr,     // dst
            (yyvsp[-1].lsc_block2d_addr_operand).regs[0],     // src0 addrs(block start offset x)
            (yyvsp[-1].lsc_block2d_addr_operand).regs[1],     // src0 addrs(block start offset y)
            (yyvsp[-1].lsc_block2d_addr_operand).immOffsets[0], // x immediate offset
            (yyvsp[-1].lsc_block2d_addr_operand).immOffsets[1], // y immediate offset
            (yyvsp[0].lsc_data_operand_typed2d).reg,      // src1
            CISAlineno);
    }
#line 4999 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 296: /* LscTypedBlock2dAddrOperand: LscAddrModelStateful LBRACK LscVectorOpImm32 COMMA LscVectorOpImm32 RBRACK  */
#line 2457 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {(yyvsp[-5].lsc_addr_model).surface, 0, {(yyvsp[-3].lsc_addr_surface_ident),(yyvsp[-1].lsc_addr_surface_ident)},{0,0},{(yyvsp[-5].lsc_addr_model).type,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 5007 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 297: /* LscTypedBlock2dAddrOperand: LscAddrModelStateful LBRACK LscVectorOpReg LscAddrImmOffsetOpt COMMA LscVectorOpReg LscAddrImmOffsetOpt RBRACK  */
#line 2467 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {(yyvsp[-7].lsc_addr_model).surface, (yyvsp[-7].lsc_addr_model).surfaceIndex, {(yyvsp[-5].lsc_addr_surface_ident), (yyvsp[-2].lsc_addr_surface_ident)}, {(int)(yyvsp[-4].intval), (int)(yyvsp[-1].intval)}, {(yyvsp[-7].lsc_addr_model).type, 1, 0, LSC_ADDR_SIZE_64b}};
    }
#line 5015 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 298: /* LscDataOperandTyped2D: LscPayloadReg LSC_DATA_SHAPE_TK_TYPED_BLOCK2D  */
#line 2473 "CISA.y"
                                                  {
        (yyval.lsc_data_operand_typed2d) = {(yyvsp[-1].RawVar),(yyvsp[0].lsc_data_shape_typed2d)};
    }
#line 5023 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 299: /* LscUntypedApndCtrAtomic: Predicate LSC_ATOMIC_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscAddrModelStateful LscDataOperand  */
#line 2485 "CISA.y"
    {
        (yyvsp[-3].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-5].lsc_sfid), (yyvsp[-6].lsc_subOpcode), (yyvsp[-2].lsc_data_operand).shape.order, (yyvsp[-3].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_append_counter_atomic_inst(
            (yyvsp[-6].lsc_subOpcode),          // op
            (yyvsp[-7].pred_reg),          // predicate
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-3].emask_exec_size).exec_size),
            (yyvsp[-3].emask_exec_size).emask,    // execution mask
            (yyvsp[-4].lsc_caching_opts),          // caching settings
            (yyvsp[-1].lsc_addr_model).type,     // address type
            (yyvsp[-2].lsc_data_operand).shape,    // data shape
            (yyvsp[-1].lsc_addr_model).surface,  // surface
            (yyvsp[-1].lsc_addr_model).surfaceIndex,
            (yyvsp[-2].lsc_data_operand).reg,      // dst data
            (yyvsp[0].lsc_data_operand).reg,      // src1 data
            CISAlineno);
    }
#line 5045 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 300: /* SwitchLabels: %empty  */
#line 2505 "CISA.y"
    {
    }
#line 5052 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 301: /* SwitchLabels: COMMA SwitchLabels  */
#line 2508 "CISA.y"
    {
    }
#line 5059 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 302: /* SwitchLabels: IDENT SwitchLabels  */
#line 2511 "CISA.y"
    {
        // parse rule means we see last label first
        switchLabels.push_front((yyvsp[-1].string));
    }
#line 5068 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 303: /* BranchInstruction: Predicate BRANCH_OP ExecSize IdentOrStringLit  */
#line 2518 "CISA.y"
    {
        pBuilder->CISA_create_branch_instruction((yyvsp[-3].pred_reg), (yyvsp[-2].opcode), (yyvsp[-1].emask_exec_size).emask, (yyvsp[-1].emask_exec_size).exec_size, (yyvsp[0].string), false, CISAlineno);
    }
#line 5076 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 304: /* BranchInstruction: Predicate CALL_OP ExecSize IdentOrStringLit  */
#line 2522 "CISA.y"
    {
        pBuilder->CISA_create_branch_instruction((yyvsp[-3].pred_reg), (yyvsp[-2].cisa_call).opcode, (yyvsp[-1].emask_exec_size).emask, (yyvsp[-1].emask_exec_size).exec_size, (yyvsp[0].string), (yyvsp[-2].cisa_call).is_fccall, CISAlineno);
    }
#line 5084 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 305: /* BranchInstruction: Predicate RET_OP ExecSize  */
#line 2526 "CISA.y"
    {
        pBuilder->CISA_Create_Ret((yyvsp[-2].pred_reg), (yyvsp[-1].opcode), (yyvsp[0].emask_exec_size).emask, (yyvsp[0].emask_exec_size).exec_size, CISAlineno);
    }
#line 5092 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 306: /* BranchInstruction: SWITCHJMP_OP ExecSize VecSrcOperand_G_I_IMM LPAREN SwitchLabels RPAREN  */
#line 2530 "CISA.y"
    {
        pBuilder->CISA_create_switch_instruction((yyvsp[-5].opcode), (yyvsp[-4].emask_exec_size).exec_size, (yyvsp[-3].genOperand).cisa_gen_opnd, switchLabels, CISAlineno);
        switchLabels.clear();
    }
#line 5101 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 307: /* BranchInstruction: Predicate FCALL ExecSize IDENT DEC_LIT DEC_LIT  */
#line 2536 "CISA.y"
    {
        pBuilder->CISA_create_fcall_instruction((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, (yyvsp[-2].string), (unsigned)(yyvsp[-1].intval), (unsigned)(yyvsp[0].intval), CISAlineno);
    }
#line 5109 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 308: /* BranchInstruction: Predicate IFCALL ExecSize VecSrcOperand_G_I_IMM DEC_LIT DEC_LIT  */
#line 2541 "CISA.y"
    {
        pBuilder->CISA_create_ifcall_instruction(
        (yyvsp[-5].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, false,
        (yyvsp[-2].genOperand).cisa_gen_opnd, (unsigned)(yyvsp[-1].intval), (unsigned)(yyvsp[0].intval), CISAlineno);
    }
#line 5119 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 309: /* BranchInstruction: Predicate IFCALL UNIFORM ExecSize VecSrcOperand_G_I_IMM DEC_LIT DEC_LIT  */
#line 2548 "CISA.y"
    {
        pBuilder->CISA_create_ifcall_instruction(
        (yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, true,
        (yyvsp[-2].genOperand).cisa_gen_opnd, (unsigned)(yyvsp[-1].intval), (unsigned)(yyvsp[0].intval), CISAlineno);
    }
#line 5129 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 310: /* BranchInstruction: FADDR IdentOrStringLit VecDstOperand_G_I  */
#line 2555 "CISA.y"
    {
        pBuilder->CISA_create_faddr_instruction((yyvsp[-1].string), (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 5137 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 311: /* FILE: FILE_OP STRING_LIT  */
#line 2560 "CISA.y"
    {
        pBuilder->CISA_create_FILE_instruction((yyvsp[-1].opcode), (yyvsp[0].string), CISAlineno);
    }
#line 5145 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 312: /* LOC: LOC_OP DEC_LIT  */
#line 2565 "CISA.y"
    {
        pBuilder->CISA_create_LOC_instruction((yyvsp[-1].opcode), (unsigned)(yyvsp[0].intval), CISAlineno);
    }
#line 5153 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 313: /* RawSendInstruction: Predicate RAW_SEND_STRING ExecSize HEX_LIT DEC_LIT DEC_LIT VecSrcOperand_G_IMM RawOperand RawOperand  */
#line 2571 "CISA.y"
    {
        pBuilder->CISA_create_raw_send_instruction(ISA_RAW_SEND, false, (yyvsp[-6].emask_exec_size).emask, (yyvsp[-6].emask_exec_size).exec_size, (yyvsp[-8].pred_reg),
            (unsigned)(yyvsp[-5].intval), (unsigned char)(yyvsp[-4].intval), (unsigned char)(yyvsp[-3].intval), (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5162 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 314: /* RawSendInstruction: Predicate RAW_SENDC_STRING ExecSize HEX_LIT DEC_LIT DEC_LIT VecSrcOperand_G_IMM RawOperand RawOperand  */
#line 2578 "CISA.y"
    {
        pBuilder->CISA_create_raw_send_instruction(ISA_RAW_SEND, true, (yyvsp[-6].emask_exec_size).emask, (yyvsp[-6].emask_exec_size).exec_size, (yyvsp[-8].pred_reg),
            (unsigned)(yyvsp[-5].intval), (unsigned char)(yyvsp[-4].intval), (unsigned char)(yyvsp[-3].intval), (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5171 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 315: /* LifetimeStartInst: LIFETIME_START_OP IDENT  */
#line 2585 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_lifetime_inst((unsigned char)0, (yyvsp[0].string), CISAlineno));
    }
#line 5179 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 316: /* LifetimeEndInst: LIFETIME_END_OP IDENT  */
#line 2591 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_lifetime_inst((unsigned char)1, (yyvsp[0].string), CISAlineno));
    }
#line 5187 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 317: /* RawSendsInstruction: Predicate RAW_SENDS_STRING ElemNum ElemNum ElemNum ElemNum ExecSize VecSrcOperand_G_IMM VecSrcOperand_G_IMM RawOperand RawOperand RawOperand  */
#line 2597 "CISA.y"
    {
        pBuilder->CISA_create_raw_sends_instruction(
            ISA_RAW_SENDS, false, false, (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-11].pred_reg), (yyvsp[-4].genOperand).cisa_gen_opnd,
            (unsigned char)(yyvsp[-9].intval), (unsigned char)(yyvsp[-8].intval), (unsigned char)(yyvsp[-7].intval), (unsigned char)(yyvsp[-6].intval),
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5198 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 318: /* RawSendsInstruction: Predicate RAW_SENDS_EOT_STRING ElemNum ElemNum ElemNum ElemNum ExecSize VecSrcOperand_G_IMM VecSrcOperand_G_IMM RawOperand RawOperand RawOperand  */
#line 2605 "CISA.y"
    {
        pBuilder->CISA_create_raw_sends_instruction(
            ISA_RAW_SENDS, false, true, (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-11].pred_reg), (yyvsp[-4].genOperand).cisa_gen_opnd,
            (unsigned char)(yyvsp[-9].intval), (unsigned char)(yyvsp[-8].intval), (unsigned char)(yyvsp[-7].intval), (unsigned char)(yyvsp[-6].intval),
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5209 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 319: /* RawSendsInstruction: Predicate RAW_SENDSC_STRING ElemNum ElemNum ElemNum ExecSize VecSrcOperand_G_IMM VecSrcOperand_G_IMM RawOperand RawOperand RawOperand  */
#line 2613 "CISA.y"
    {
        pBuilder->CISA_create_raw_sends_instruction(
            ISA_RAW_SENDS, true, false, (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-10].pred_reg), (yyvsp[-4].genOperand).cisa_gen_opnd,
            0, (unsigned char)(yyvsp[-8].intval), (unsigned char)(yyvsp[-7].intval), (unsigned char)(yyvsp[-6].intval),
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5220 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 320: /* RawSendsInstruction: Predicate RAW_SENDSC_EOT_STRING ElemNum ElemNum ElemNum ExecSize VecSrcOperand_G_IMM VecSrcOperand_G_IMM RawOperand RawOperand RawOperand  */
#line 2621 "CISA.y"
    {
        pBuilder->CISA_create_raw_sends_instruction(
            ISA_RAW_SENDS, true, true, (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-10].pred_reg), (yyvsp[-4].genOperand).cisa_gen_opnd,
            0, (unsigned char)(yyvsp[-8].intval), (unsigned char)(yyvsp[-7].intval), (unsigned char)(yyvsp[-6].intval),
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5231 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 321: /* NullaryInstruction: CACHE_FLUSH_OP  */
#line 2631 "CISA.y"
    {
        pBuilder->CISA_create_NO_OPND_instruction((yyvsp[0].opcode), CISAlineno);
    }
#line 5239 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 322: /* NullaryInstruction: WAIT_OP VecSrcOperand_G_IMM  */
#line 2636 "CISA.y"
    {
        pBuilder->CISA_create_wait_instruction((yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 5247 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 323: /* NullaryInstruction: YIELD_OP  */
#line 2641 "CISA.y"
    {
        pBuilder->CISA_create_yield_instruction((yyvsp[0].opcode), CISAlineno);
    }
#line 5255 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 324: /* NullaryInstruction: FENCE_GLOBAL_OP  */
#line 2646 "CISA.y"
    {
        pBuilder->CISA_create_fence_instruction((yyvsp[0].opcode), 0x0, CISAlineno);
    }
#line 5263 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 325: /* NullaryInstruction: FENCE_GLOBAL_OP FENCE_OPTIONS  */
#line 2651 "CISA.y"
    {
        pBuilder->CISA_create_fence_instruction((yyvsp[-1].opcode), (yyvsp[0].fence_options), CISAlineno);
    }
#line 5271 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 326: /* NullaryInstruction: FENCE_LOCAL_OP  */
#line 2656 "CISA.y"
    {
        pBuilder->CISA_create_fence_instruction((yyvsp[0].opcode), 0x20, CISAlineno);
    }
#line 5279 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 327: /* NullaryInstruction: FENCE_LOCAL_OP FENCE_OPTIONS  */
#line 2661 "CISA.y"
    {
        pBuilder->CISA_create_fence_instruction((yyvsp[-1].opcode), (yyvsp[0].fence_options) | 0x20, CISAlineno);
    }
#line 5287 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 328: /* NullaryInstruction: FENCE_SW_OP  */
#line 2666 "CISA.y"
    {
        pBuilder->CISA_create_fence_instruction((yyvsp[0].opcode), 0x80, CISAlineno);
    }
#line 5295 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 329: /* OwordModifier: %empty  */
#line 2670 "CISA.y"
                      {(yyval.oword_mod) = false;}
#line 5301 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 331: /* Predicate: %empty  */
#line 2677 "CISA.y"
    {
        (yyval.pred_reg) = NULL;
    }
#line 5309 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 332: /* Predicate: LPAREN PredSign PredVar PredCtrlOpt RPAREN  */
#line 2682 "CISA.y"
    {
        (yyval.pred_reg) = pBuilder->CISA_create_predicate_operand((yyvsp[-2].vISADecl), (yyvsp[-3].pred_sign), (yyvsp[-1].pred_ctrl), CISAlineno);
    }
#line 5317 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 333: /* PredSign: %empty  */
#line 2686 "CISA.y"
                 {(yyval.pred_sign) = PredState_NO_INVERSE;}
#line 5323 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 334: /* PredSign: BANG  */
#line 2686 "CISA.y"
                                                     {(yyval.pred_sign) = PredState_INVERSE;}
#line 5329 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 335: /* PredCtrlOpt: %empty  */
#line 2688 "CISA.y"
                    {(yyval.pred_ctrl) = PRED_CTRL_NON;}
#line 5335 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 337: /* SatModOpt: %empty  */
#line 2691 "CISA.y"
                  {(yyval.sat) = false;}
#line 5341 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 338: /* SatModOpt: SAT  */
#line 2691 "CISA.y"
                                      {(yyval.sat) = true;}
#line 5347 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 339: /* SrcModifier: SRCMOD_NEG  */
#line 2694 "CISA.y"
                    {(yyval.src_mod).mod = MODIFIER_NEG;}
#line 5353 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 340: /* SrcModifier: SRCMOD_ABS  */
#line 2695 "CISA.y"
                    {(yyval.src_mod).mod = MODIFIER_ABS;}
#line 5359 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 341: /* SrcModifier: SRCMOD_NEGABS  */
#line 2696 "CISA.y"
                    {(yyval.src_mod).mod = MODIFIER_NEG_ABS;}
#line 5365 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 342: /* SrcModifier: SRCMOD_NOT  */
#line 2697 "CISA.y"
                    {(yyval.src_mod).mod = MODIFIER_NOT;}
#line 5371 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 343: /* ConditionalModifier: %empty  */
#line 2699 "CISA.y"
                            {(yyval.cond_mod) = ISA_CMP_UNDEF;}
#line 5377 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 345: /* VecDstOperand_A: DstAddrOperand  */
#line 2704 "CISA.y"
                                   {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESS;}
#line 5383 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 346: /* VecDstOperand_G: DstGeneralOperand  */
#line 2705 "CISA.y"
                                   {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_GENERAL;}
#line 5389 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 347: /* VecDstOperand_G_I: DstGeneralOperand  */
#line 2707 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_GENERAL;}
#line 5395 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 348: /* VecDstOperand_G_I: DstIndirectOperand  */
#line 2708 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_INDIRECT;}
#line 5401 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 350: /* VecSrcOperand_G_I_IMM_A_AO: SrcAddrOfOperand  */
#line 2713 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESSOF;}
#line 5407 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 352: /* VecSrcOperand_G_I_IMM_A: SrcAddrOperand  */
#line 2717 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESS;}
#line 5413 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 354: /* VecSrcOperand_G_I_IMM: SrcIndirectOperand  */
#line 2721 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_INDIRECT;}
#line 5419 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 355: /* VecSrcOperand_G_I_IMM: SrcImmOperand  */
#line 2722 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_IMMEDIATE;}
#line 5425 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 357: /* VecSrcOperand_G_IMM: SrcImmOperand  */
#line 2726 "CISA.y"
                          {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_IMMEDIATE;}
#line 5431 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 359: /* VecSrcOperand_G_IMM_AO: SrcImmOperand  */
#line 2730 "CISA.y"
                          {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_IMMEDIATE;}
#line 5437 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 360: /* VecSrcOperand_G_IMM_AO: SrcAddrOfOperand  */
#line 2731 "CISA.y"
                          {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESSOF;}
#line 5443 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 362: /* VecSrcOperand_G_A: SrcAddrOperand  */
#line 2735 "CISA.y"
                          {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESS;}
#line 5449 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 364: /* VecSrcOperand_G_A_AO: SrcAddrOfOperand  */
#line 2739 "CISA.y"
                          {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESS;}
#line 5455 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 365: /* VecSrcOperand_G: SrcGeneralOperand  */
#line 2741 "CISA.y"
                                   {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_GENERAL;}
#line 5461 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 366: /* VecSrcOpndSimple: Var TwoDimOffset  */
#line 2744 "CISA.y"
    {
        // simple vector operand with no modifier that has an
        // implicit src region = <1,1,0>
        (yyval.genOperand).type = OPERAND_GENERAL;
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_gen_src_operand(
            (yyvsp[-1].string), 1, 1, 0, (yyvsp[0].offset).row, (yyvsp[0].offset).elem, MODIFIER_NONE, CISAlineno));
    }
#line 5473 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 367: /* VMEOpndIME: LPAREN DEC_LIT COMMA DEC_LIT RPAREN  */
#line 2754 "CISA.y"
    {
        (yyval.vmeOpndIvb).streamMode = (unsigned char)(yyvsp[-3].intval);
        (yyval.vmeOpndIvb).searchCtrl = (unsigned char)(yyvsp[-1].intval);
    }
#line 5482 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 368: /* VMEOpndFBR: LPAREN VecSrcOperand_G_I_IMM COMMA VecSrcOperand_G_I_IMM COMMA VecSrcOperand_G_I_IMM RPAREN  */
#line 2761 "CISA.y"
    {
        (yyval.vmeOpndFbr).cisa_fbrMbMode_opnd = (yyvsp[-5].genOperand).cisa_gen_opnd;
        (yyval.vmeOpndFbr).cisa_fbrSubMbShape_opnd = (yyvsp[-3].genOperand).cisa_gen_opnd;
        (yyval.vmeOpndFbr).cisa_fbrSubPredMode_opnd = (yyvsp[-1].genOperand).cisa_gen_opnd;
    }
#line 5492 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 369: /* SrcStateOperand: Var LPAREN IntExp RPAREN  */
#line 2769 "CISA.y"
    {
        MUST_HOLD((yyvsp[-1].intval) < 0x100, "offset out of bounds");
        (yyval.StateVar).offset = (unsigned char)(yyvsp[-1].intval);
        ABORT_ON_FAIL((yyval.StateVar).cisa_gen_opnd = pBuilder->CISA_create_state_operand((yyvsp[-3].string), (unsigned char)(yyvsp[-1].intval), CISAlineno, false));
    }
#line 5502 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 370: /* DstStateOperand: Var LPAREN IntExp RPAREN  */
#line 2777 "CISA.y"
    {
        MUST_HOLD((yyvsp[-1].intval) < 0x100, "offset out of bounds");
        (yyval.StateVar).offset = (unsigned char)(yyvsp[-1].intval);
        ABORT_ON_FAIL((yyval.StateVar).cisa_gen_opnd = pBuilder->CISA_create_state_operand((yyvsp[-3].string), (unsigned char)(yyvsp[-1].intval), CISAlineno, true));
    }
#line 5512 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 372: /* RawOperand: BUILTIN_NULL DOT DEC_LIT  */
#line 2808 "CISA.y"
    {
        MUST_HOLD((yyvsp[0].intval) == 0, "%null must have 0 as offset");
        (yyval.RawVar) = pBuilder->CISA_create_RAW_NULL_operand(CISAlineno); // can't fail
    }
#line 5521 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 373: /* RawOperandNonNull: VarNonNull RawOperandOffsetSuffix  */
#line 2815 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.RawVar) = pBuilder->CISA_create_RAW_operand((yyvsp[-1].string), (unsigned short)(yyvsp[0].intval), CISAlineno));
    }
#line 5529 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 374: /* RawOperandOffsetSuffix: DOT DEC_LIT  */
#line 2826 "CISA.y"
                {
        MUST_HOLD((yyvsp[0].intval) <= 0x10000, "offset out of bounds");
        (yyval.intval) = (yyvsp[0].intval);
    }
#line 5538 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 375: /* RawOperandOffsetSuffix: DOT LPAREN IntExp RPAREN  */
#line 2831 "CISA.y"
                             {
        MUST_HOLD((yyvsp[-1].intval) <= 0x10000, "offset out of bounds");
        (yyval.intval) = (yyvsp[-1].intval);
    }
#line 5547 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 376: /* RawOperandArray: %empty  */
#line 2839 "CISA.y"
    {
        (yyval.intval) = 0;
    }
#line 5555 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 377: /* RawOperandArray: RawOperandArray RawOperand  */
#line 2844 "CISA.y"
    {
        rawOperandArray[(yyvsp[-1].intval)++] = (VISA_RawOpnd*)(yyvsp[0].RawVar);
        (yyval.intval) = (yyvsp[-1].intval);
    }
#line 5564 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 378: /* DstAddrOperand: AddrVarAccessWithWidth  */
#line 2852 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
          pBuilder->CISA_set_address_operand(
            (yyvsp[0].regAccess).cisa_decl, (yyvsp[0].regAccess).elem, (yyvsp[0].regAccess).row, true, CISAlineno));
    }
#line 5574 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 379: /* DstGeneralOperand: Var TwoDimOffset DstRegion  */
#line 2860 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_dst_general_operand(
            (yyvsp[-2].string), (yyvsp[-1].offset).row, (yyvsp[-1].offset).elem, (unsigned short)(yyvsp[0].intval), CISAlineno));
    }
#line 5583 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 380: /* DstGeneralOperand: Var DstRegion  */
#line 2865 "CISA.y"
                  {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_dst_general_operand(
            (yyvsp[-1].string), 0, 0, (unsigned short)(yyvsp[0].intval), CISAlineno));
    }
#line 5592 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 381: /* DstIndirectOperand: IndirectVarAccess DstRegion DataType  */
#line 2871 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_indirect_dst(
            (yyvsp[-2].regAccess).cisa_decl, MODIFIER_NONE, (yyvsp[-2].regAccess).row, (yyvsp[-2].regAccess).elem, (yyvsp[-2].regAccess).immOff, (unsigned short)(yyvsp[-1].intval), (yyvsp[0].type), CISAlineno));
    }
#line 5601 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 382: /* SrcAddrOfOperand: AddrOfVar  */
#line 2892 "CISA.y"
              {
         (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_set_address_expression((yyvsp[0].regAccess).cisa_decl, 0, CISAlineno);
    }
#line 5609 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 383: /* SrcAddrOfOperand: AddrOfVar LBRACK IntExp RBRACK  */
#line 2896 "CISA.y"
                                   {
         MUST_HOLD((short)(yyvsp[-1].intval) == (yyvsp[-1].intval), "variable address offset is too large");
         (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_set_address_expression((yyvsp[-3].regAccess).cisa_decl, (short)(yyvsp[-1].intval), CISAlineno);
    }
#line 5618 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 384: /* AddrOfVar: AMP Var  */
#line 2902 "CISA.y"
            {
        // Both GENERAL_VAR and SURFACE_VAR are addressable
        (yyval.regAccess).cisa_decl = pBuilder->CISA_find_decl((yyvsp[0].string));
        if ((yyval.regAccess).cisa_decl == nullptr)
            PARSE_ERROR("unbound variable");
        (yyval.regAccess).row = 0;
        (yyval.regAccess).elem = 0;
    }
#line 5631 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 385: /* SrcAddrOperand: AddrVarAccessWithWidth  */
#line 2913 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
            pBuilder->CISA_set_address_operand(
                (yyvsp[0].regAccess).cisa_decl, (yyvsp[0].regAccess).elem, (yyvsp[0].regAccess).row, false, CISAlineno));
    }
#line 5641 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 386: /* SrcGeneralOperand: Var TwoDimOffset SrcRegionDirect  */
#line 2921 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
            pBuilder->CISA_create_gen_src_operand(
                (yyvsp[-2].string), (yyvsp[0].cisa_region).v_stride, (yyvsp[0].cisa_region).width, (yyvsp[0].cisa_region).h_stride, (yyvsp[-1].offset).row, (yyvsp[-1].offset).elem, MODIFIER_NONE, CISAlineno));
    }
#line 5651 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 387: /* SrcGeneralOperand: SrcModifier Var TwoDimOffset SrcRegionDirect  */
#line 2928 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
            pBuilder->CISA_create_gen_src_operand(
                (yyvsp[-2].string), (yyvsp[0].cisa_region).v_stride, (yyvsp[0].cisa_region).width, (yyvsp[0].cisa_region).h_stride, (yyvsp[-1].offset).row, (yyvsp[-1].offset).elem, (yyvsp[-3].src_mod).mod, CISAlineno));
    }
#line 5661 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 388: /* SrcImmOperand: IntExpUnr DataTypeIntOrVector  */
#line 2938 "CISA.y"
    {
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_immed((yyvsp[-1].intval), (yyvsp[0].type), CISAlineno);
    }
#line 5669 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 389: /* SrcImmOperand: HEX_LIT HFTYPE  */
#line 2943 "CISA.y"
                     {
        MUST_HOLD((yyvsp[-1].intval) < 0x10000, "literal too large for half float");
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_immed(
            (unsigned short)(yyvsp[-1].intval), ISA_TYPE_HF, CISAlineno);
    }
#line 5679 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 390: /* SrcImmOperand: FloatLit  */
#line 2951 "CISA.y"
    {
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_float_immed((yyvsp[0].fltval), ISA_TYPE_F, CISAlineno);
    }
#line 5687 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 391: /* SrcImmOperand: MINUS FloatLit  */
#line 2954 "CISA.y"
                     {
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_float_immed(-(yyvsp[0].fltval), ISA_TYPE_F, CISAlineno);
    }
#line 5695 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 392: /* SrcImmOperand: DoubleFloatLit  */
#line 2960 "CISA.y"
    {
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_float_immed((yyvsp[0].fltval), ISA_TYPE_DF, CISAlineno);
    }
#line 5703 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 393: /* SrcImmOperand: MINUS DoubleFloatLit  */
#line 2964 "CISA.y"
    {
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_float_immed(-(yyvsp[0].fltval), ISA_TYPE_DF, CISAlineno);
    }
#line 5711 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 395: /* FloatLit: DEC_LIT FTYPE  */
#line 2971 "CISA.y"
   {
        // "1:f" means 1.4e-45
        int number = (int)(yyvsp[-1].intval);
        float *fp = (float *)&number;
        (yyval.fltval) = *fp;
   }
#line 5722 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 396: /* FloatLit: HEX_LIT FTYPE  */
#line 2978 "CISA.y"
   {
        int number = (int)(yyvsp[-1].intval);
        float *fp = (float *)&number;
        (yyval.fltval) = *fp;
   }
#line 5732 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 398: /* DoubleFloatLit: DEC_LIT DFTYPE  */
#line 2986 "CISA.y"
                    {
        // "1:df" means 5e-324
        int64_t number = (yyvsp[-1].intval);
        double *fp = (double *)&number;
        (yyval.fltval) = *fp;
   }
#line 5743 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 399: /* DoubleFloatLit: HEX_LIT DFTYPE  */
#line 2992 "CISA.y"
                    {
        // to support 0x7ff0000000000000:df
        int64_t number = (yyvsp[-1].intval);
        double *fp = (double *)&number;
        (yyval.fltval) = *fp;
   }
#line 5754 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 400: /* SrcIndirectOperand: IndirectVarAccess SrcRegionIndirect DataType  */
#line 3003 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
            pBuilder->CISA_create_indirect(
                (yyvsp[-2].regAccess).cisa_decl, MODIFIER_NONE, (yyvsp[-2].regAccess).row, (yyvsp[-2].regAccess).elem, (yyvsp[-2].regAccess).immOff,
                (yyvsp[-1].cisa_region).v_stride, (yyvsp[-1].cisa_region).width, (yyvsp[-1].cisa_region).h_stride, (yyvsp[0].type), CISAlineno));
    }
#line 5765 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 401: /* SrcIndirectOperand: SrcModifier IndirectVarAccess SrcRegionIndirect DataType  */
#line 3011 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
            pBuilder->CISA_create_indirect(
                (yyvsp[-2].regAccess).cisa_decl, (yyvsp[-3].src_mod).mod, (yyvsp[-2].regAccess).row, (yyvsp[-2].regAccess).elem, (yyvsp[-2].regAccess).immOff,
                (yyvsp[-1].cisa_region).v_stride, (yyvsp[-1].cisa_region).width, (yyvsp[-1].cisa_region).h_stride, (yyvsp[0].type), CISAlineno));
    }
#line 5776 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 402: /* DstRegion: LANGLE IntExpNRA RANGLE  */
#line 3020 "CISA.y"
    {
        MUST_HOLD(((yyvsp[-1].intval) == 0 || (yyvsp[-1].intval) == 1 || (yyvsp[-1].intval) == 2 || (yyvsp[-1].intval) == 4),
             "Dst HorzStride must be 0, 1, 2, or 4");
        (yyval.intval) = (yyvsp[-1].intval);
    }
#line 5786 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 403: /* SrcRegionDirect: LANGLE IntExp SEMI IntExp COMMA IntExpNRA RANGLE  */
#line 3038 "CISA.y"
    {
        MUST_HOLD(((yyvsp[-5].intval) == 0 || (yyvsp[-5].intval) == 1 || (yyvsp[-5].intval) == 2 || (yyvsp[-5].intval) == 4 || (yyvsp[-5].intval) == 8 || (yyvsp[-5].intval) == 16 || (yyvsp[-5].intval) == 32),
                 "Src Region VertStride must be 0, 1, 2, 4, 8, 16, or 32");
        MUST_HOLD(((yyvsp[-3].intval) == 0 || (yyvsp[-3].intval) == 1 || (yyvsp[-3].intval) == 2 || (yyvsp[-3].intval) == 4 || (yyvsp[-3].intval) == 8 || (yyvsp[-3].intval) == 16),
                 "Src Region Width must be 0, 1, 2, 4, 8 or 16");
        MUST_HOLD(((yyvsp[-1].intval) == 0 || (yyvsp[-1].intval) == 1 || (yyvsp[-1].intval) == 2 || (yyvsp[-1].intval) == 4),
                 "Src Region HorzStride must be 0, 1, 2, or 4");
        (yyval.cisa_region).v_stride = (unsigned)(yyvsp[-5].intval);
        (yyval.cisa_region).width = (unsigned)(yyvsp[-3].intval);
        (yyval.cisa_region).h_stride = (unsigned)(yyvsp[-1].intval);
    }
#line 5802 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 405: /* SrcRegionIndirect: LANGLE IntExp COMMA DEC_LIT RANGLE  */
#line 3055 "CISA.y"
    {
        MUST_HOLD(((yyvsp[-3].intval) == 0 || (yyvsp[-3].intval) == 1 || (yyvsp[-3].intval) == 2 || (yyvsp[-3].intval) == 4 || (yyvsp[-3].intval) == 8 || (yyvsp[-3].intval) == 16),
                 "Width must be 0, 1, 2, 4, 8 or 16");
        MUST_HOLD(((yyvsp[-1].intval) == 0 || (yyvsp[-1].intval) == 1 || (yyvsp[-1].intval) == 2 || (yyvsp[-1].intval) == 4),
                 "HorzStride must be 0, 1, 2, or 4");
        (yyval.cisa_region).v_stride = -1;
        (yyval.cisa_region).width = (unsigned)(yyvsp[-3].intval);
        (yyval.cisa_region).h_stride = (unsigned)(yyvsp[-1].intval);
    }
#line 5816 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 406: /* SrcRegionIndirect: LANGLE IntExpNRA RANGLE  */
#line 3066 "CISA.y"
    {
        MUST_HOLD(((yyvsp[-1].intval) == 0 || (yyvsp[-1].intval) == 1 || (yyvsp[-1].intval) == 2 || (yyvsp[-1].intval) == 4),
             "HorzStride must be 0, 1, 2, or 4");
        (yyval.cisa_region).v_stride = -1;
        (yyval.cisa_region).width = -1;
        (yyval.cisa_region).h_stride = (unsigned)(yyvsp[-1].intval);
    }
#line 5828 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 407: /* IndirectVarAccess: IND_LBRACK AddrVarAccess COMMA IntExp RBRACK  */
#line 3076 "CISA.y"
                                                 {
        (yyval.regAccess) = (yyvsp[-3].regAccess);
        (yyval.regAccess).immOff = (int)(yyvsp[-1].intval);
    }
#line 5837 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 408: /* IndirectVarAccess: IND_LBRACK AddrVarAccess RBRACK  */
#line 3081 "CISA.y"
                                                 {
          (yyval.regAccess) = (yyvsp[-1].regAccess);
          (yyval.regAccess).immOff = 0;
    }
#line 5846 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 409: /* TwoDimOffset: LPAREN IntExp COMMA IntExp RPAREN  */
#line 3086 "CISA.y"
                                                {
        MUST_HOLD((yyvsp[-3].intval) >= 0, "row (register) offset must be positive");
        (yyval.offset).row = (int)(yyvsp[-3].intval);
        MUST_HOLD((yyvsp[-1].intval) >= 0 && (yyvsp[-1].intval) <= 0xFFFF, "sub-register offset out of bounds");
        (yyval.offset).elem = (int)(yyvsp[-1].intval);
    }
#line 5857 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 410: /* PredVar: Var  */
#line 3094 "CISA.y"
        {
        (yyval.vISADecl) = pBuilder->CISA_find_decl((yyvsp[0].string));
        if ((yyval.vISADecl) == nullptr)
            PARSE_ERROR((yyvsp[0].string), ": undefined predicate variable");
        if ((yyval.vISADecl)->type != PREDICATE_VAR)
            PARSE_ERROR((yyvsp[0].string), ": not a predicate variable");
    }
#line 5869 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 411: /* AddrVarAccess: Var LPAREN IntExp RPAREN  */
#line 3103 "CISA.y"
                             {
        (yyval.regAccess).cisa_decl = pBuilder->CISA_find_decl((yyvsp[-3].string));
        if ((yyval.regAccess).cisa_decl == nullptr) {
            PARSE_ERROR((yyvsp[-3].string), ": unbound variable");
        } else if ((yyval.regAccess).cisa_decl->type != ADDRESS_VAR) {
            PARSE_ERROR((yyvsp[-3].string), ": not an address variable");
        }
        (yyval.regAccess).row = 1;
        (yyval.regAccess).elem = (int)(yyvsp[-1].intval);
    }
#line 5884 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 412: /* AddrVarAccessWithWidth: Var LPAREN IntExp RPAREN LANGLE IntExpNRA RANGLE  */
#line 3115 "CISA.y"
                                                     {
        (yyval.regAccess).cisa_decl = pBuilder->CISA_find_decl((yyvsp[-6].string));
        if ((yyval.regAccess).cisa_decl == nullptr) {
            PARSE_ERROR((yyvsp[-6].string), ": unbound variable");
        } else if ((yyval.regAccess).cisa_decl->type != ADDRESS_VAR) {
            PARSE_ERROR((yyvsp[-6].string), ": not an address variable");
        }
        (yyval.regAccess).row = (int)(yyvsp[-1].intval);
        (yyval.regAccess).elem = (int)(yyvsp[-4].intval);
    }
#line 5899 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 413: /* SIMDMode: %empty  */
#line 3129 "CISA.y"
           {(yyval.intval) = 0;}
#line 5905 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 414: /* SIMDMode: LPAREN DEC_LIT RPAREN  */
#line 3132 "CISA.y"
    {
       MUST_HOLD(((yyvsp[-1].intval) == 8 || (yyvsp[-1].intval) == 16 || (yyvsp[-1].intval) == 32),
                 "SIMD mode can only be 8, 16, or 32");
       (yyval.intval) = (yyvsp[-1].intval);
    }
#line 5915 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 415: /* ElemNum: DOT DEC_LIT  */
#line 3143 "CISA.y"
    {
        (yyval.intval) = (yyvsp[0].intval);
    }
#line 5923 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 416: /* ExecSize: LPAREN ExecSizeInt RPAREN  */
#line 3155 "CISA.y"
    {
        (yyval.emask_exec_size).emask = vISA_EMASK_M1;
        (yyval.emask_exec_size).exec_size = (int)(yyvsp[-1].intval);
    }
#line 5932 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 417: /* ExecSize: LPAREN Var COMMA ExecSizeInt RPAREN  */
#line 3161 "CISA.y"
    {
        if (!ParseEMask((yyvsp[-3].string), (yyval.emask_exec_size).emask)) {
            PARSE_ERROR("invalid execution offset info");
        }
        (yyval.emask_exec_size).exec_size = (int)(yyvsp[-1].intval);
    }
#line 5943 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 418: /* ExecSizeInt: DEC_LIT  */
#line 3169 "CISA.y"
    {
        if ((yyvsp[0].intval) != 1 && (yyvsp[0].intval) != 2 && (yyvsp[0].intval) != 4 && (yyvsp[0].intval) != 8 && (yyvsp[0].intval) != 16 && (yyvsp[0].intval) != 32) {
            PARSE_ERROR("invalid execution size");
        }
        (yyval.intval) = (unsigned short)(yyvsp[0].intval);
    }
#line 5954 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 424: /* IntExpCond: IntExpAND QUESTION IntExpAND COLON IntExpCond  */
#line 3183 "CISA.y"
                                                    {(yyval.intval) = (yyvsp[-4].intval) ? (yyvsp[-2].intval) : (yyvsp[0].intval);}
#line 5960 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 426: /* IntExpAND: IntExpAND AMP IntExpXOR  */
#line 3186 "CISA.y"
                               {(yyval.intval) = (yyvsp[-2].intval) & (yyvsp[0].intval);}
#line 5966 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 428: /* IntExpXOR: IntExpXOR CIRC IntExpOR  */
#line 3189 "CISA.y"
                               {(yyval.intval) = (yyvsp[-2].intval) ^ (yyvsp[0].intval);}
#line 5972 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 430: /* IntExpOR: IntExpOR PIPE IntExpCmp  */
#line 3192 "CISA.y"
                                {(yyval.intval) = (yyvsp[-2].intval) | (yyvsp[0].intval);}
#line 5978 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 432: /* IntExpCmp: IntExpRel EQ IntExpRel  */
#line 3195 "CISA.y"
                               {(yyval.intval) = (yyvsp[-2].intval) == (yyvsp[0].intval);}
#line 5984 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 433: /* IntExpCmp: IntExpRel NEQ IntExpRel  */
#line 3196 "CISA.y"
                               {(yyval.intval) = (yyvsp[-2].intval) != (yyvsp[0].intval);}
#line 5990 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 435: /* IntExpRel: IntExpNRA LANGLE IntExpNRA  */
#line 3199 "CISA.y"
                                 {(yyval.intval) = (yyvsp[-2].intval) < (yyvsp[0].intval);}
#line 5996 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 436: /* IntExpRel: IntExpNRA RANGLE IntExpNRA  */
#line 3200 "CISA.y"
                                 {(yyval.intval) = (yyvsp[-2].intval) > (yyvsp[0].intval);}
#line 6002 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 437: /* IntExpRel: IntExpNRA LEQ IntExpNRA  */
#line 3201 "CISA.y"
                                 {(yyval.intval) = (yyvsp[-2].intval) <= (yyvsp[0].intval);}
#line 6008 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 438: /* IntExpRel: IntExpNRA GEQ IntExpNRA  */
#line 3202 "CISA.y"
                                 {(yyval.intval) = (yyvsp[-2].intval) >= (yyvsp[0].intval);}
#line 6014 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 441: /* IntExpShift: IntExpAdd SHL IntExpAdd  */
#line 3225 "CISA.y"
                               {(yyval.intval) = (yyvsp[-2].intval) << (yyvsp[0].intval);}
#line 6020 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 442: /* IntExpShift: IntExpAdd SHRS IntExpAdd  */
#line 3226 "CISA.y"
                               {(yyval.intval) = (int64_t)(yyvsp[-2].intval) >> (int)(yyvsp[0].intval);}
#line 6026 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 443: /* IntExpShift: IntExpAdd SHRZ IntExpAdd  */
#line 3227 "CISA.y"
                               {(yyval.intval) = (int64_t)((uint64_t)(yyvsp[-2].intval) >> (uint64_t)(yyvsp[0].intval));}
#line 6032 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 445: /* IntExpAdd: IntExpAdd PLUS IntExpMul  */
#line 3230 "CISA.y"
                                {(yyval.intval) = (yyvsp[-2].intval) + (yyvsp[0].intval);}
#line 6038 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 446: /* IntExpAdd: IntExpAdd MINUS IntExpMul  */
#line 3231 "CISA.y"
                                {(yyval.intval) = (yyvsp[-2].intval) - (yyvsp[0].intval);}
#line 6044 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 448: /* IntExpMul: IntExpMul TIMES IntExpUnr  */
#line 3234 "CISA.y"
                                {(yyval.intval) = (yyvsp[-2].intval) * (yyvsp[0].intval);}
#line 6050 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 449: /* IntExpMul: IntExpMul SLASH IntExpUnr  */
#line 3235 "CISA.y"
                                {
            if ((yyvsp[0].intval) == 0)
                PARSE_ERROR("division by 0");
            (yyval.intval) = (yyvsp[-2].intval) / (yyvsp[0].intval);
        }
#line 6060 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 450: /* IntExpMul: IntExpMul PERCENT IntExpUnr  */
#line 3240 "CISA.y"
                                  {
            if ((yyvsp[0].intval) == 0)
                PARSE_ERROR("division by 0");
            (yyval.intval) = (yyvsp[-2].intval) % (yyvsp[0].intval);
        }
#line 6070 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 452: /* IntExpUnr: MINUS IntExpUnr  */
#line 3247 "CISA.y"
                      {(yyval.intval) = -(yyvsp[0].intval);}
#line 6076 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 453: /* IntExpUnr: TILDE IntExpUnr  */
#line 3248 "CISA.y"
                      {(yyval.intval) = ~(yyvsp[0].intval);}
#line 6082 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 454: /* IntExpUnr: BANG IntExpUnr  */
#line 3249 "CISA.y"
                      {(yyval.intval) = !((yyvsp[0].intval));}
#line 6088 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 458: /* IntExpPrim: LPAREN IntExp RPAREN  */
#line 3257 "CISA.y"
                           {(yyval.intval) = (yyvsp[-1].intval);}
#line 6094 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 459: /* IntExpPrim: BUILTIN_SIZEOF IDENT  */
#line 3261 "CISA.y"
                           {
        (yyval.intval) = 0;
        ABORT_ON_FAIL(pBuilder->CISA_eval_sizeof_decl(CISAlineno, (yyvsp[0].string), (yyval.intval)));
    }
#line 6103 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 460: /* IntExpPrim: BUILTIN_SIZEOF LPAREN IDENT RPAREN  */
#line 3265 "CISA.y"
                                         {
        // TODO: %AlignOf(...), %Max(..)
        (yyval.intval) = 0;
        ABORT_ON_FAIL(pBuilder->CISA_eval_sizeof_decl(CISAlineno, (yyvsp[-1].string), (yyval.intval)));
    }
#line 6113 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 461: /* IntExpPrim: BUILTIN_DISPATCH_SIMD_SIZE  */
#line 3271 "CISA.y"
                                 {
        // e.g. %DispatchSimdSize
        // N.B. %sizeof happens above
        (yyval.intval) = 0;
        ABORT_ON_FAIL(pBuilder->CISA_lookup_builtin_constant(CISAlineno, "%DispatchSimd", (yyval.intval)));
    }
#line 6124 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 469: /* BuildOptions: BUILD_OPTION_LINE  */
#line 3291 "CISA.y"
    {
        pBuilder->CISA_parse_build_options((yyvsp[0].string));
    }
#line 6132 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;


#line 6136 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (pBuilder, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, pBuilder);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, pBuilder);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (pBuilder, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, pBuilder);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, pBuilder);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 3296 "CISA.y"

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                        Utility Functions                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

void CISAerror(CISA_IR_Builder* pBuilder, char const *s)
{
    pBuilder->RecordParseError(CISAlineno, s);
}

static bool streq(const char *sym0, const char *sym1)
{
  return strcmp(sym0, sym1) == 0;
}

static bool ParseAlign(CISA_IR_Builder* pBuilder, const char *sym, VISA_Align &value)
{
    if (strcmp(sym, "byte") == 0) {
        value = ALIGN_BYTE;
    } else if (strcmp(sym, "word") == 0) {
        value = ALIGN_WORD;
    } else if (strcmp(sym, "dword") == 0) {
        value = ALIGN_DWORD;
    } else if (strcmp(sym, "qword") == 0) {
        value = ALIGN_QWORD;
    } else if (strcmp(sym, "oword") == 0) {
        value = ALIGN_OWORD;
    } else if (strcmp(sym, "GRF") == 0) {
        value = ALIGN_GRF;
    } else if (strcmp(sym, "GRFx2") == 0 || strcmp(sym, "2GRF") == 0) {
        value = ALIGN_2_GRF;
    } else if (strcmp(sym, "hword") == 0) {
        value = ALIGN_HWORD;
    } else if (strcmp(sym, "wordx32") == 0) {
        value = ALIGN_32WORD;
    } else if (strcmp(sym, "wordx64") == 0) {
        value = ALIGN_64WORD;
    } else {
        value = ALIGN_UNDEF;
        return false;
    }
    return true;
}


static bool AlignBytesToVisaAlignment(int bytes, VISA_Align &val)
{
    switch (bytes) {
    case 1:   val = ALIGN_BYTE; break;
    case 2:   val = ALIGN_WORD; break;
    case 4:   val = ALIGN_DWORD; break;
    case 8:   val = ALIGN_QWORD; break;
    case 16:  val = ALIGN_OWORD; break;
    case 32:  val = ALIGN_HWORD; break;
    case 64:  val = ALIGN_32WORD; break;
    case 128: val = ALIGN_64WORD; break;
    default:  val = ALIGN_UNDEF; return false;
    }
    return true;
}



static bool ParseEMask(
    const char* sym,
    VISA_EMask_Ctrl &emask)
{
    if (strcmp(sym, "NoMask") == 0) {
        emask = vISA_EMASK_M1_NM;
        return true;
    }
    for (int i = 0; i < vISA_NUM_EMASK +1; i++)
    {
        if (!strcmp(emask_str[i], sym))
        {
            emask = (VISA_EMask_Ctrl)i;
            return true;
        }
    }

    emask = vISA_NUM_EMASK;
    return false;
}

static int lscCheckExecSize(
    CISA_IR_Builder* pBuilder,
    LSC_SFID sfid,
    LSC_OP op,
    LSC_DATA_ORDER data_order,
    int exec_size)
{
    int is_vector_op =
        op != LSC_LOAD_BLOCK2D &&
        op != LSC_STORE_BLOCK2D;
        // other ops like LSC_LOAD_SURFACE_INFO may be SIMD1
    if (op == LSC_READ_STATE_INFO) {
        exec_size = 1;
    } else if (data_order == LSC_DATA_ORDER_NONTRANSPOSE && is_vector_op) {
        if (exec_size == UNDEFINED_EXEC_SIZE) {
            if (pBuilder->getPlatform() == Xe_DG2) // for DG2 typed is 8, untyped is 16
                exec_size = sfid == LSC_TGM ? 8 : 16;
            else if (pBuilder->getPlatform() >= Xe_PVC) // on PVC typed is 16, untyped is 32
                exec_size = sfid == LSC_TGM ? 16 : 32;
            else
                exec_size = 32; // the world is finally sane
        }
    } else {
        // block and transpose get SIMD by default
        if (exec_size == UNDEFINED_EXEC_SIZE) {
           exec_size = 1; // transpose is implicitly 1 if needed
        }
    }
    return exec_size;
}
