{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An interface for accessible objects containing formatted text.
-- 
-- The @GtkAccessibleText@ interfaces is meant to be implemented by accessible
-- objects that have text formatted with attributes, or non-trivial text contents.
-- 
-- You should use the 'GI.Gtk.Enums.AccessiblePropertyLabel' or the
-- 'GI.Gtk.Enums.AccessiblePropertyDescription' properties for accessible
-- objects containing simple, unformatted text.
-- 
-- /Since: 4.14/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Interfaces.AccessibleText
    ( 

-- * Exported types
    AccessibleText(..)                      ,
    IsAccessibleText                        ,
    toAccessibleText                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [updateCaretPosition]("GI.Gtk.Interfaces.AccessibleText#g:method:updateCaretPosition"), [updateContents]("GI.Gtk.Interfaces.AccessibleText#g:method:updateContents"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateSelectionBound]("GI.Gtk.Interfaces.AccessibleText#g:method:updateSelectionBound"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveAccessibleTextMethod             ,
#endif

-- ** updateCaretPosition #method:updateCaretPosition#

#if defined(ENABLE_OVERLOADING)
    AccessibleTextUpdateCaretPositionMethodInfo,
#endif
    accessibleTextUpdateCaretPosition       ,


-- ** updateContents #method:updateContents#

#if defined(ENABLE_OVERLOADING)
    AccessibleTextUpdateContentsMethodInfo  ,
#endif
    accessibleTextUpdateContents            ,


-- ** updateSelectionBound #method:updateSelectionBound#

#if defined(ENABLE_OVERLOADING)
    AccessibleTextUpdateSelectionBoundMethodInfo,
#endif
    accessibleTextUpdateSelectionBound      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible

#endif

-- interface AccessibleText 
-- | Memory-managed wrapper type.
newtype AccessibleText = AccessibleText (SP.ManagedPtr AccessibleText)
    deriving (Eq)

instance SP.ManagedPtrNewtype AccessibleText where
    toManagedPtr (AccessibleText p) = p

foreign import ccall "gtk_accessible_text_get_type"
    c_gtk_accessible_text_get_type :: IO B.Types.GType

instance B.Types.TypedObject AccessibleText where
    glibType = c_gtk_accessible_text_get_type

instance B.Types.GObject AccessibleText

-- | Type class for types which can be safely cast to t'AccessibleText', for instance with `toAccessibleText`.
class (SP.GObject o, O.IsDescendantOf AccessibleText o) => IsAccessibleText o
instance (SP.GObject o, O.IsDescendantOf AccessibleText o) => IsAccessibleText o

instance O.HasParentTypes AccessibleText
type instance O.ParentTypes AccessibleText = '[Gtk.Accessible.Accessible, GObject.Object.Object]

-- | Cast to t'AccessibleText', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toAccessibleText :: (MIO.MonadIO m, IsAccessibleText o) => o -> m AccessibleText
toAccessibleText = MIO.liftIO . B.ManagedPtr.unsafeCastTo AccessibleText

-- | Convert t'AccessibleText' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AccessibleText) where
    gvalueGType_ = c_gtk_accessible_text_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AccessibleText)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AccessibleText)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AccessibleText ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AccessibleText
type instance O.AttributeList AccessibleText = AccessibleTextAttributeList
type AccessibleTextAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAccessibleTextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAccessibleTextMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveAccessibleTextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAccessibleTextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAccessibleTextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAccessibleTextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAccessibleTextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAccessibleTextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAccessibleTextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAccessibleTextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAccessibleTextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAccessibleTextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAccessibleTextMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveAccessibleTextMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveAccessibleTextMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveAccessibleTextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAccessibleTextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAccessibleTextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAccessibleTextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAccessibleTextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAccessibleTextMethod "updateCaretPosition" o = AccessibleTextUpdateCaretPositionMethodInfo
    ResolveAccessibleTextMethod "updateContents" o = AccessibleTextUpdateContentsMethodInfo
    ResolveAccessibleTextMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveAccessibleTextMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveAccessibleTextMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveAccessibleTextMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveAccessibleTextMethod "updateSelectionBound" o = AccessibleTextUpdateSelectionBoundMethodInfo
    ResolveAccessibleTextMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveAccessibleTextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAccessibleTextMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveAccessibleTextMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveAccessibleTextMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveAccessibleTextMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveAccessibleTextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAccessibleTextMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveAccessibleTextMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveAccessibleTextMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveAccessibleTextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAccessibleTextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAccessibleTextMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveAccessibleTextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAccessibleTextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAccessibleTextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAccessibleTextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAccessibleTextMethod t AccessibleText, O.OverloadedMethod info AccessibleText p) => OL.IsLabel t (AccessibleText -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAccessibleTextMethod t AccessibleText, O.OverloadedMethod info AccessibleText p, R.HasField t AccessibleText p) => R.HasField t AccessibleText p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAccessibleTextMethod t AccessibleText, O.OverloadedMethodInfo info AccessibleText) => OL.IsLabel t (O.MethodProxy info AccessibleText) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method AccessibleText::update_caret_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccessibleText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the accessible object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accessible_text_update_caret_position" gtk_accessible_text_update_caret_position :: 
    Ptr AccessibleText ->                   -- self : TInterface (Name {namespace = "Gtk", name = "AccessibleText"})
    IO ()

-- | Updates the position of the caret.
-- 
-- Implementations of the @GtkAccessibleText@ interface should call this
-- function every time the caret has moved, in order to notify assistive
-- technologies.
-- 
-- /Since: 4.14/
accessibleTextUpdateCaretPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsAccessibleText a) =>
    a
    -- ^ /@self@/: the accessible object
    -> m ()
accessibleTextUpdateCaretPosition self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_accessible_text_update_caret_position self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AccessibleTextUpdateCaretPositionMethodInfo
instance (signature ~ (m ()), MonadIO m, IsAccessibleText a) => O.OverloadedMethod AccessibleTextUpdateCaretPositionMethodInfo a signature where
    overloadedMethod = accessibleTextUpdateCaretPosition

instance O.OverloadedMethodInfo AccessibleTextUpdateCaretPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.AccessibleText.accessibleTextUpdateCaretPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-AccessibleText.html#v:accessibleTextUpdateCaretPosition"
        })


#endif

-- method AccessibleText::update_contents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccessibleText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the accessible object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "change"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "AccessibleTextContentChange" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type of change in the contents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the starting offset of the change, in characters"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the end offset of the change, in characters"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accessible_text_update_contents" gtk_accessible_text_update_contents :: 
    Ptr AccessibleText ->                   -- self : TInterface (Name {namespace = "Gtk", name = "AccessibleText"})
    CUInt ->                                -- change : TInterface (Name {namespace = "Gtk", name = "AccessibleTextContentChange"})
    Word32 ->                               -- start : TBasicType TUInt
    Word32 ->                               -- end : TBasicType TUInt
    IO ()

-- | Notifies assistive technologies of a change in contents.
-- 
-- Implementations of the @GtkAccessibleText@ interface should call this
-- function every time their contents change as the result of an operation,
-- like an insertion or a removal.
-- 
-- Note: If the change is a deletion, this function must be called *before*
-- removing the contents, if it is an insertion, it must be called *after*
-- inserting the new contents.
-- 
-- /Since: 4.14/
accessibleTextUpdateContents ::
    (B.CallStack.HasCallStack, MonadIO m, IsAccessibleText a) =>
    a
    -- ^ /@self@/: the accessible object
    -> Gtk.Enums.AccessibleTextContentChange
    -- ^ /@change@/: the type of change in the contents
    -> Word32
    -- ^ /@start@/: the starting offset of the change, in characters
    -> Word32
    -- ^ /@end@/: the end offset of the change, in characters
    -> m ()
accessibleTextUpdateContents self change start end = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let change' = (fromIntegral . fromEnum) change
    gtk_accessible_text_update_contents self' change' start end
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AccessibleTextUpdateContentsMethodInfo
instance (signature ~ (Gtk.Enums.AccessibleTextContentChange -> Word32 -> Word32 -> m ()), MonadIO m, IsAccessibleText a) => O.OverloadedMethod AccessibleTextUpdateContentsMethodInfo a signature where
    overloadedMethod = accessibleTextUpdateContents

instance O.OverloadedMethodInfo AccessibleTextUpdateContentsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.AccessibleText.accessibleTextUpdateContents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-AccessibleText.html#v:accessibleTextUpdateContents"
        })


#endif

-- method AccessibleText::update_selection_bound
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccessibleText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the accessible object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accessible_text_update_selection_bound" gtk_accessible_text_update_selection_bound :: 
    Ptr AccessibleText ->                   -- self : TInterface (Name {namespace = "Gtk", name = "AccessibleText"})
    IO ()

-- | Updates the boundary of the selection.
-- 
-- Implementations of the @GtkAccessibleText@ interface should call this
-- function every time the selection has moved, in order to notify assistive
-- technologies.
-- 
-- /Since: 4.14/
accessibleTextUpdateSelectionBound ::
    (B.CallStack.HasCallStack, MonadIO m, IsAccessibleText a) =>
    a
    -- ^ /@self@/: the accessible object
    -> m ()
accessibleTextUpdateSelectionBound self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_accessible_text_update_selection_bound self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AccessibleTextUpdateSelectionBoundMethodInfo
instance (signature ~ (m ()), MonadIO m, IsAccessibleText a) => O.OverloadedMethod AccessibleTextUpdateSelectionBoundMethodInfo a signature where
    overloadedMethod = accessibleTextUpdateSelectionBound

instance O.OverloadedMethodInfo AccessibleTextUpdateSelectionBoundMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.AccessibleText.accessibleTextUpdateSelectionBound",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-AccessibleText.html#v:accessibleTextUpdateSelectionBound"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AccessibleText = AccessibleTextSignalList
type AccessibleTextSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


