

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Flags
    ( 

 -- * Flags


-- ** ApplicationInhibitFlags #flag:ApplicationInhibitFlags#

    ApplicationInhibitFlags(..)             ,


-- ** BuilderClosureFlags #flag:BuilderClosureFlags#

    BuilderClosureFlags(..)                 ,


-- ** CellRendererState #flag:CellRendererState#

    CellRendererState(..)                   ,


-- ** DebugFlags #flag:DebugFlags#

    DebugFlags(..)                          ,


-- ** DialogFlags #flag:DialogFlags#

    DialogFlags(..)                         ,


-- ** EventControllerScrollFlags #flag:EventControllerScrollFlags#

    EventControllerScrollFlags(..)          ,


-- ** FontChooserLevel #flag:FontChooserLevel#

    FontChooserLevel(..)                    ,


-- ** IconLookupFlags #flag:IconLookupFlags#

    IconLookupFlags(..)                     ,


-- ** InputHints #flag:InputHints#

    InputHints(..)                          ,


-- ** ListScrollFlags #flag:ListScrollFlags#

    ListScrollFlags(..)                     ,


-- ** PickFlags #flag:PickFlags#

    PickFlags(..)                           ,


-- ** PopoverMenuFlags #flag:PopoverMenuFlags#

    PopoverMenuFlags(..)                    ,


-- ** PrintCapabilities #flag:PrintCapabilities#

    PrintCapabilities(..)                   ,


-- ** ShortcutActionFlags #flag:ShortcutActionFlags#

    ShortcutActionFlags(..)                 ,


-- ** StateFlags #flag:StateFlags#

    StateFlags(..)                          ,


-- ** StyleContextPrintFlags #flag:StyleContextPrintFlags#

    StyleContextPrintFlags(..)              ,


-- ** TextBufferNotifyFlags #flag:TextBufferNotifyFlags#

    TextBufferNotifyFlags(..)               ,


-- ** TextSearchFlags #flag:TextSearchFlags#

    TextSearchFlags(..)                     ,


-- ** TreeModelFlags #flag:TreeModelFlags#

    TreeModelFlags(..)                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Flags TreeModelFlags
{-# DEPRECATED TreeModelFlags ["(Since version 4.10)","There is no replacement"] #-}
-- | These flags indicate various properties of a @GtkTreeModel@.
-- 
-- They are returned by 'GI.Gtk.Interfaces.TreeModel.treeModelGetFlags', and must be
-- static for the lifetime of the object. A more complete description
-- of 'GI.Gtk.Flags.TreeModelFlagsItersPersist' can be found in the overview of
-- this section.
data TreeModelFlags = 
      TreeModelFlagsItersPersist
    -- ^ iterators survive all signals
    --   emitted by the tree
    | TreeModelFlagsListOnly
    -- ^ the model is a list only, and never
    --   has children
    | AnotherTreeModelFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TreeModelFlags where
    fromEnum TreeModelFlagsItersPersist = 1
    fromEnum TreeModelFlagsListOnly = 2
    fromEnum (AnotherTreeModelFlags k) = k

    toEnum 1 = TreeModelFlagsItersPersist
    toEnum 2 = TreeModelFlagsListOnly
    toEnum k = AnotherTreeModelFlags k

instance P.Ord TreeModelFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TreeModelFlags = '[]
instance O.HasParentTypes TreeModelFlags

foreign import ccall "gtk_tree_model_flags_get_type" c_gtk_tree_model_flags_get_type :: 
    IO GType

instance B.Types.TypedObject TreeModelFlags where
    glibType = c_gtk_tree_model_flags_get_type

instance B.Types.BoxedFlags TreeModelFlags

instance IsGFlag TreeModelFlags

-- Flags TextSearchFlags
-- | Flags affecting how a search is done.
-- 
-- If neither @GTK_TEXT_SEARCH_VISIBLE_ONLY@ nor @GTK_TEXT_SEARCH_TEXT_ONLY@
-- are enabled, the match must be exact; the special 0xFFFC character will
-- match embedded paintables or child widgets.
data TextSearchFlags = 
      TextSearchFlagsVisibleOnly
    -- ^ Search only visible data. A search match may
    -- have invisible text interspersed.
    | TextSearchFlagsTextOnly
    -- ^ Search only text. A match may have paintables or
    -- child widgets mixed inside the matched range.
    | TextSearchFlagsCaseInsensitive
    -- ^ The text will be matched regardless of
    -- what case it is in.
    | AnotherTextSearchFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextSearchFlags where
    fromEnum TextSearchFlagsVisibleOnly = 1
    fromEnum TextSearchFlagsTextOnly = 2
    fromEnum TextSearchFlagsCaseInsensitive = 4
    fromEnum (AnotherTextSearchFlags k) = k

    toEnum 1 = TextSearchFlagsVisibleOnly
    toEnum 2 = TextSearchFlagsTextOnly
    toEnum 4 = TextSearchFlagsCaseInsensitive
    toEnum k = AnotherTextSearchFlags k

instance P.Ord TextSearchFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TextSearchFlags = '[]
instance O.HasParentTypes TextSearchFlags

foreign import ccall "gtk_text_search_flags_get_type" c_gtk_text_search_flags_get_type :: 
    IO GType

instance B.Types.TypedObject TextSearchFlags where
    glibType = c_gtk_text_search_flags_get_type

instance B.Types.BoxedFlags TextSearchFlags

instance IsGFlag TextSearchFlags

-- Flags TextBufferNotifyFlags
-- | Values for [callback/@gtk@/.TextBufferCommitNotify] to denote the
-- point of the notification.
-- 
-- /Since: 4.16/
data TextBufferNotifyFlags = 
      TextBufferNotifyFlagsBeforeInsert
    -- ^ Be notified before text
    --   is inserted into the underlying buffer.
    | TextBufferNotifyFlagsAfterInsert
    -- ^ Be notified after text
    --   has been inserted into the underlying buffer.
    | TextBufferNotifyFlagsBeforeDelete
    -- ^ Be notified before text
    --   is deleted from the underlying buffer.
    | TextBufferNotifyFlagsAfterDelete
    -- ^ Be notified after text
    --   has been deleted from the underlying buffer.
    | AnotherTextBufferNotifyFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextBufferNotifyFlags where
    fromEnum TextBufferNotifyFlagsBeforeInsert = 1
    fromEnum TextBufferNotifyFlagsAfterInsert = 2
    fromEnum TextBufferNotifyFlagsBeforeDelete = 4
    fromEnum TextBufferNotifyFlagsAfterDelete = 8
    fromEnum (AnotherTextBufferNotifyFlags k) = k

    toEnum 1 = TextBufferNotifyFlagsBeforeInsert
    toEnum 2 = TextBufferNotifyFlagsAfterInsert
    toEnum 4 = TextBufferNotifyFlagsBeforeDelete
    toEnum 8 = TextBufferNotifyFlagsAfterDelete
    toEnum k = AnotherTextBufferNotifyFlags k

instance P.Ord TextBufferNotifyFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TextBufferNotifyFlags = '[]
instance O.HasParentTypes TextBufferNotifyFlags

foreign import ccall "gtk_text_buffer_notify_flags_get_type" c_gtk_text_buffer_notify_flags_get_type :: 
    IO GType

instance B.Types.TypedObject TextBufferNotifyFlags where
    glibType = c_gtk_text_buffer_notify_flags_get_type

instance B.Types.BoxedFlags TextBufferNotifyFlags

instance IsGFlag TextBufferNotifyFlags

-- Flags StyleContextPrintFlags
-- | Flags that modify the behavior of 'GI.Gtk.Objects.StyleContext.styleContextToString'.
-- 
-- New values may be added to this enumeration.
data StyleContextPrintFlags = 
      StyleContextPrintFlagsNone
    -- ^ Default value.
    | StyleContextPrintFlagsRecurse
    -- ^ Print the entire tree of
    --   CSS nodes starting at the style context\'s node
    | StyleContextPrintFlagsShowStyle
    -- ^ Show the values of the
    --   CSS properties for each node
    | StyleContextPrintFlagsShowChange
    -- ^ Show information about
    --   what changes affect the styles
    | AnotherStyleContextPrintFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum StyleContextPrintFlags where
    fromEnum StyleContextPrintFlagsNone = 0
    fromEnum StyleContextPrintFlagsRecurse = 1
    fromEnum StyleContextPrintFlagsShowStyle = 2
    fromEnum StyleContextPrintFlagsShowChange = 4
    fromEnum (AnotherStyleContextPrintFlags k) = k

    toEnum 0 = StyleContextPrintFlagsNone
    toEnum 1 = StyleContextPrintFlagsRecurse
    toEnum 2 = StyleContextPrintFlagsShowStyle
    toEnum 4 = StyleContextPrintFlagsShowChange
    toEnum k = AnotherStyleContextPrintFlags k

instance P.Ord StyleContextPrintFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes StyleContextPrintFlags = '[]
instance O.HasParentTypes StyleContextPrintFlags

foreign import ccall "gtk_style_context_print_flags_get_type" c_gtk_style_context_print_flags_get_type :: 
    IO GType

instance B.Types.TypedObject StyleContextPrintFlags where
    glibType = c_gtk_style_context_print_flags_get_type

instance B.Types.BoxedFlags StyleContextPrintFlags

instance IsGFlag StyleContextPrintFlags

-- Flags StateFlags
-- | Describes a widget state.
-- 
-- Widget states are used to match the widget against CSS pseudo-classes.
-- Note that GTK extends the regular CSS classes and sometimes uses
-- different names.
data StateFlags = 
      StateFlagsNormal
    -- ^ State during normal operation
    | StateFlagsActive
    -- ^ Widget is active
    | StateFlagsPrelight
    -- ^ Widget has a mouse pointer over it
    | StateFlagsSelected
    -- ^ Widget is selected
    | StateFlagsInsensitive
    -- ^ Widget is insensitive
    | StateFlagsInconsistent
    -- ^ Widget is inconsistent
    | StateFlagsFocused
    -- ^ Widget has the keyboard focus
    | StateFlagsBackdrop
    -- ^ Widget is in a background toplevel window
    | StateFlagsDirLtr
    -- ^ Widget is in left-to-right text direction
    | StateFlagsDirRtl
    -- ^ Widget is in right-to-left text direction
    | StateFlagsLink
    -- ^ Widget is a link
    | StateFlagsVisited
    -- ^ The location the widget points to has already been visited
    | StateFlagsChecked
    -- ^ Widget is checked
    | StateFlagsDropActive
    -- ^ Widget is highlighted as a drop target for DND
    | StateFlagsFocusVisible
    -- ^ Widget has the visible focus
    | StateFlagsFocusWithin
    -- ^ Widget contains the keyboard focus
    | AnotherStateFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum StateFlags where
    fromEnum StateFlagsNormal = 0
    fromEnum StateFlagsActive = 1
    fromEnum StateFlagsPrelight = 2
    fromEnum StateFlagsSelected = 4
    fromEnum StateFlagsInsensitive = 8
    fromEnum StateFlagsInconsistent = 16
    fromEnum StateFlagsFocused = 32
    fromEnum StateFlagsBackdrop = 64
    fromEnum StateFlagsDirLtr = 128
    fromEnum StateFlagsDirRtl = 256
    fromEnum StateFlagsLink = 512
    fromEnum StateFlagsVisited = 1024
    fromEnum StateFlagsChecked = 2048
    fromEnum StateFlagsDropActive = 4096
    fromEnum StateFlagsFocusVisible = 8192
    fromEnum StateFlagsFocusWithin = 16384
    fromEnum (AnotherStateFlags k) = k

    toEnum 0 = StateFlagsNormal
    toEnum 1 = StateFlagsActive
    toEnum 2 = StateFlagsPrelight
    toEnum 4 = StateFlagsSelected
    toEnum 8 = StateFlagsInsensitive
    toEnum 16 = StateFlagsInconsistent
    toEnum 32 = StateFlagsFocused
    toEnum 64 = StateFlagsBackdrop
    toEnum 128 = StateFlagsDirLtr
    toEnum 256 = StateFlagsDirRtl
    toEnum 512 = StateFlagsLink
    toEnum 1024 = StateFlagsVisited
    toEnum 2048 = StateFlagsChecked
    toEnum 4096 = StateFlagsDropActive
    toEnum 8192 = StateFlagsFocusVisible
    toEnum 16384 = StateFlagsFocusWithin
    toEnum k = AnotherStateFlags k

instance P.Ord StateFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes StateFlags = '[]
instance O.HasParentTypes StateFlags

foreign import ccall "gtk_state_flags_get_type" c_gtk_state_flags_get_type :: 
    IO GType

instance B.Types.TypedObject StateFlags where
    glibType = c_gtk_state_flags_get_type

instance B.Types.BoxedFlags StateFlags

instance IsGFlag StateFlags

-- Flags ShortcutActionFlags
-- | Flags that can be passed to action activation.
-- 
-- More flags may be added in the future.
data ShortcutActionFlags = 
      ShortcutActionFlagsExclusive
    -- ^ The action is the only
    --   action that can be activated. If this flag is not set,
    --   a future activation may select a different action.
    | AnotherShortcutActionFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ShortcutActionFlags where
    fromEnum ShortcutActionFlagsExclusive = 1
    fromEnum (AnotherShortcutActionFlags k) = k

    toEnum 1 = ShortcutActionFlagsExclusive
    toEnum k = AnotherShortcutActionFlags k

instance P.Ord ShortcutActionFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ShortcutActionFlags = '[]
instance O.HasParentTypes ShortcutActionFlags

foreign import ccall "gtk_shortcut_action_flags_get_type" c_gtk_shortcut_action_flags_get_type :: 
    IO GType

instance B.Types.TypedObject ShortcutActionFlags where
    glibType = c_gtk_shortcut_action_flags_get_type

instance B.Types.BoxedFlags ShortcutActionFlags

instance IsGFlag ShortcutActionFlags

-- Flags PrintCapabilities
-- | Specifies which features the print dialog should offer.
-- 
-- If neither 'GI.Gtk.Flags.PrintCapabilitiesGeneratePdf' nor
-- 'GI.Gtk.Flags.PrintCapabilitiesGeneratePs' is specified, GTK assumes that all
-- formats are supported.
data PrintCapabilities = 
      PrintCapabilitiesPageSet
    -- ^ Print dialog will offer printing even\/odd pages.
    | PrintCapabilitiesCopies
    -- ^ Print dialog will allow to print multiple copies.
    | PrintCapabilitiesCollate
    -- ^ Print dialog will allow to collate multiple copies.
    | PrintCapabilitiesReverse
    -- ^ Print dialog will allow to print pages in reverse order.
    | PrintCapabilitiesScale
    -- ^ Print dialog will allow to scale the output.
    | PrintCapabilitiesGeneratePdf
    -- ^ The program will send the document to
    --   the printer in PDF format
    | PrintCapabilitiesGeneratePs
    -- ^ The program will send the document to
    --   the printer in Postscript format
    | PrintCapabilitiesPreview
    -- ^ Print dialog will offer a preview
    | PrintCapabilitiesNumberUp
    -- ^ Print dialog will offer printing multiple
    --   pages per sheet
    | PrintCapabilitiesNumberUpLayout
    -- ^ Print dialog will allow to rearrange
    --   pages when printing multiple pages per sheet
    | AnotherPrintCapabilities Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PrintCapabilities where
    fromEnum PrintCapabilitiesPageSet = 1
    fromEnum PrintCapabilitiesCopies = 2
    fromEnum PrintCapabilitiesCollate = 4
    fromEnum PrintCapabilitiesReverse = 8
    fromEnum PrintCapabilitiesScale = 16
    fromEnum PrintCapabilitiesGeneratePdf = 32
    fromEnum PrintCapabilitiesGeneratePs = 64
    fromEnum PrintCapabilitiesPreview = 128
    fromEnum PrintCapabilitiesNumberUp = 256
    fromEnum PrintCapabilitiesNumberUpLayout = 512
    fromEnum (AnotherPrintCapabilities k) = k

    toEnum 1 = PrintCapabilitiesPageSet
    toEnum 2 = PrintCapabilitiesCopies
    toEnum 4 = PrintCapabilitiesCollate
    toEnum 8 = PrintCapabilitiesReverse
    toEnum 16 = PrintCapabilitiesScale
    toEnum 32 = PrintCapabilitiesGeneratePdf
    toEnum 64 = PrintCapabilitiesGeneratePs
    toEnum 128 = PrintCapabilitiesPreview
    toEnum 256 = PrintCapabilitiesNumberUp
    toEnum 512 = PrintCapabilitiesNumberUpLayout
    toEnum k = AnotherPrintCapabilities k

instance P.Ord PrintCapabilities where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PrintCapabilities = '[]
instance O.HasParentTypes PrintCapabilities

foreign import ccall "gtk_print_capabilities_get_type" c_gtk_print_capabilities_get_type :: 
    IO GType

instance B.Types.TypedObject PrintCapabilities where
    glibType = c_gtk_print_capabilities_get_type

instance B.Types.BoxedFlags PrintCapabilities

instance IsGFlag PrintCapabilities

-- Flags PopoverMenuFlags
-- | Flags that affect how t'GI.Gtk.Objects.PopoverMenu.PopoverMenu' widgets built from
-- a t'GI.Gio.Objects.MenuModel.MenuModel' are created and displayed.
data PopoverMenuFlags = 
      PopoverMenuFlagsSliding
    -- ^ Submenus are presented as sliding submenus that replace the main menu.
    -- 
    -- /Since: 4.14/
    | PopoverMenuFlagsNested
    -- ^ Submenus are presented as traditional, nested
    --   popovers.
    | AnotherPopoverMenuFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PopoverMenuFlags where
    fromEnum PopoverMenuFlagsSliding = 0
    fromEnum PopoverMenuFlagsNested = 1
    fromEnum (AnotherPopoverMenuFlags k) = k

    toEnum 0 = PopoverMenuFlagsSliding
    toEnum 1 = PopoverMenuFlagsNested
    toEnum k = AnotherPopoverMenuFlags k

instance P.Ord PopoverMenuFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PopoverMenuFlags = '[]
instance O.HasParentTypes PopoverMenuFlags

foreign import ccall "gtk_popover_menu_flags_get_type" c_gtk_popover_menu_flags_get_type :: 
    IO GType

instance B.Types.TypedObject PopoverMenuFlags where
    glibType = c_gtk_popover_menu_flags_get_type

instance B.Types.BoxedFlags PopoverMenuFlags

instance IsGFlag PopoverMenuFlags

-- Flags PickFlags
-- | Flags that influence the behavior of [method/@widget@/.pick].
data PickFlags = 
      PickFlagsDefault
    -- ^ The default behavior, include widgets that are receiving events
    | PickFlagsInsensitive
    -- ^ Include widgets that are insensitive
    | PickFlagsNonTargetable
    -- ^ Include widgets that are marked as non-targetable. See [property/@widget@/:can-target]
    | AnotherPickFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PickFlags where
    fromEnum PickFlagsDefault = 0
    fromEnum PickFlagsInsensitive = 1
    fromEnum PickFlagsNonTargetable = 2
    fromEnum (AnotherPickFlags k) = k

    toEnum 0 = PickFlagsDefault
    toEnum 1 = PickFlagsInsensitive
    toEnum 2 = PickFlagsNonTargetable
    toEnum k = AnotherPickFlags k

instance P.Ord PickFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PickFlags = '[]
instance O.HasParentTypes PickFlags

foreign import ccall "gtk_pick_flags_get_type" c_gtk_pick_flags_get_type :: 
    IO GType

instance B.Types.TypedObject PickFlags where
    glibType = c_gtk_pick_flags_get_type

instance B.Types.BoxedFlags PickFlags

instance IsGFlag PickFlags

-- Flags ListScrollFlags
-- | List of actions to perform when scrolling to items in
-- a list widget.
-- 
-- /Since: 4.12/
data ListScrollFlags = 
      ListScrollFlagsNone
    -- ^ Don\'t do anything extra
    | ListScrollFlagsFocus
    -- ^ Focus the target item
    | ListScrollFlagsSelect
    -- ^ Select the target item and
    --   unselect all other items.
    | AnotherListScrollFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ListScrollFlags where
    fromEnum ListScrollFlagsNone = 0
    fromEnum ListScrollFlagsFocus = 1
    fromEnum ListScrollFlagsSelect = 2
    fromEnum (AnotherListScrollFlags k) = k

    toEnum 0 = ListScrollFlagsNone
    toEnum 1 = ListScrollFlagsFocus
    toEnum 2 = ListScrollFlagsSelect
    toEnum k = AnotherListScrollFlags k

instance P.Ord ListScrollFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ListScrollFlags = '[]
instance O.HasParentTypes ListScrollFlags

foreign import ccall "gtk_list_scroll_flags_get_type" c_gtk_list_scroll_flags_get_type :: 
    IO GType

instance B.Types.TypedObject ListScrollFlags where
    glibType = c_gtk_list_scroll_flags_get_type

instance B.Types.BoxedFlags ListScrollFlags

instance IsGFlag ListScrollFlags

-- Flags InputHints
-- | Describes hints that might be taken into account by input methods
-- or applications.
-- 
-- Note that input methods may already tailor their behaviour according
-- to the [enum/@inputPurpose@/] of the entry.
-- 
-- Some common sense is expected when using these flags - mixing
-- 'GI.Gtk.Flags.InputHintsLowercase' with any of the uppercase hints makes no sense.
-- 
-- This enumeration may be extended in the future; input methods should
-- ignore unknown values.
data InputHints = 
      InputHintsNone
    -- ^ No special behaviour suggested
    | InputHintsSpellcheck
    -- ^ Suggest checking for typos
    | InputHintsNoSpellcheck
    -- ^ Suggest not checking for typos
    | InputHintsWordCompletion
    -- ^ Suggest word completion
    | InputHintsLowercase
    -- ^ Suggest to convert all text to lowercase
    | InputHintsUppercaseChars
    -- ^ Suggest to capitalize all text
    | InputHintsUppercaseWords
    -- ^ Suggest to capitalize the first
    --   character of each word
    | InputHintsUppercaseSentences
    -- ^ Suggest to capitalize the
    --   first word of each sentence
    | InputHintsInhibitOsk
    -- ^ Suggest to not show an onscreen keyboard
    --   (e.g for a calculator that already has all the keys).
    | InputHintsVerticalWriting
    -- ^ The text is vertical
    | InputHintsEmoji
    -- ^ Suggest offering Emoji support
    | InputHintsNoEmoji
    -- ^ Suggest not offering Emoji support
    | InputHintsPrivate
    -- ^ Request that the input method should not
    --    update personalized data (like typing history)
    | AnotherInputHints Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum InputHints where
    fromEnum InputHintsNone = 0
    fromEnum InputHintsSpellcheck = 1
    fromEnum InputHintsNoSpellcheck = 2
    fromEnum InputHintsWordCompletion = 4
    fromEnum InputHintsLowercase = 8
    fromEnum InputHintsUppercaseChars = 16
    fromEnum InputHintsUppercaseWords = 32
    fromEnum InputHintsUppercaseSentences = 64
    fromEnum InputHintsInhibitOsk = 128
    fromEnum InputHintsVerticalWriting = 256
    fromEnum InputHintsEmoji = 512
    fromEnum InputHintsNoEmoji = 1024
    fromEnum InputHintsPrivate = 2048
    fromEnum (AnotherInputHints k) = k

    toEnum 0 = InputHintsNone
    toEnum 1 = InputHintsSpellcheck
    toEnum 2 = InputHintsNoSpellcheck
    toEnum 4 = InputHintsWordCompletion
    toEnum 8 = InputHintsLowercase
    toEnum 16 = InputHintsUppercaseChars
    toEnum 32 = InputHintsUppercaseWords
    toEnum 64 = InputHintsUppercaseSentences
    toEnum 128 = InputHintsInhibitOsk
    toEnum 256 = InputHintsVerticalWriting
    toEnum 512 = InputHintsEmoji
    toEnum 1024 = InputHintsNoEmoji
    toEnum 2048 = InputHintsPrivate
    toEnum k = AnotherInputHints k

instance P.Ord InputHints where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes InputHints = '[]
instance O.HasParentTypes InputHints

foreign import ccall "gtk_input_hints_get_type" c_gtk_input_hints_get_type :: 
    IO GType

instance B.Types.TypedObject InputHints where
    glibType = c_gtk_input_hints_get_type

instance B.Types.BoxedFlags InputHints

instance IsGFlag InputHints

-- Flags IconLookupFlags
-- | Used to specify options for 'GI.Gtk.Objects.IconTheme.iconThemeLookupIcon'.
data IconLookupFlags = 
      IconLookupFlagsNone
    -- ^ Perform a regular lookup.
    -- 
    -- /Since: 4.18/
    | IconLookupFlagsForceRegular
    -- ^ Try to always load regular icons, even
    --   when symbolic icon names are given
    | IconLookupFlagsForceSymbolic
    -- ^ Try to always load symbolic icons, even
    --   when regular icon names are given
    | IconLookupFlagsPreload
    -- ^ Starts loading the texture in the background
    --   so it is ready when later needed.
    | AnotherIconLookupFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IconLookupFlags where
    fromEnum IconLookupFlagsNone = 0
    fromEnum IconLookupFlagsForceRegular = 1
    fromEnum IconLookupFlagsForceSymbolic = 2
    fromEnum IconLookupFlagsPreload = 4
    fromEnum (AnotherIconLookupFlags k) = k

    toEnum 0 = IconLookupFlagsNone
    toEnum 1 = IconLookupFlagsForceRegular
    toEnum 2 = IconLookupFlagsForceSymbolic
    toEnum 4 = IconLookupFlagsPreload
    toEnum k = AnotherIconLookupFlags k

instance P.Ord IconLookupFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes IconLookupFlags = '[]
instance O.HasParentTypes IconLookupFlags

foreign import ccall "gtk_icon_lookup_flags_get_type" c_gtk_icon_lookup_flags_get_type :: 
    IO GType

instance B.Types.TypedObject IconLookupFlags where
    glibType = c_gtk_icon_lookup_flags_get_type

instance B.Types.BoxedFlags IconLookupFlags

instance IsGFlag IconLookupFlags

-- Flags FontChooserLevel
{-# DEPRECATED FontChooserLevel ["(Since version 4.20)","There is no replacement."] #-}
-- | Specifies the granularity of font selection
-- that is desired in a @GtkFontChooser@.
-- 
-- This enumeration may be extended in the future; applications should
-- ignore unknown values.
data FontChooserLevel = 
      FontChooserLevelFamily
    -- ^ Allow selecting a font family
    | FontChooserLevelStyle
    -- ^ Allow selecting a specific font face
    | FontChooserLevelSize
    -- ^ Allow selecting a specific font size
    | FontChooserLevelVariations
    -- ^ Allow changing OpenType font variation axes
    | FontChooserLevelFeatures
    -- ^ Allow selecting specific OpenType font features
    | AnotherFontChooserLevel Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FontChooserLevel where
    fromEnum FontChooserLevelFamily = 0
    fromEnum FontChooserLevelStyle = 1
    fromEnum FontChooserLevelSize = 2
    fromEnum FontChooserLevelVariations = 4
    fromEnum FontChooserLevelFeatures = 8
    fromEnum (AnotherFontChooserLevel k) = k

    toEnum 0 = FontChooserLevelFamily
    toEnum 1 = FontChooserLevelStyle
    toEnum 2 = FontChooserLevelSize
    toEnum 4 = FontChooserLevelVariations
    toEnum 8 = FontChooserLevelFeatures
    toEnum k = AnotherFontChooserLevel k

instance P.Ord FontChooserLevel where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FontChooserLevel = '[]
instance O.HasParentTypes FontChooserLevel

foreign import ccall "gtk_font_chooser_level_get_type" c_gtk_font_chooser_level_get_type :: 
    IO GType

instance B.Types.TypedObject FontChooserLevel where
    glibType = c_gtk_font_chooser_level_get_type

instance B.Types.BoxedFlags FontChooserLevel

instance IsGFlag FontChooserLevel

-- Flags EventControllerScrollFlags
-- | Describes the behavior of a @GtkEventControllerScroll@.
data EventControllerScrollFlags = 
      EventControllerScrollFlagsNone
    -- ^ Don\'t emit scroll.
    | EventControllerScrollFlagsVertical
    -- ^ Emit scroll with vertical deltas.
    | EventControllerScrollFlagsHorizontal
    -- ^ Emit scroll with horizontal deltas.
    | EventControllerScrollFlagsDiscrete
    -- ^ Only emit deltas that are multiples of 1.
    | EventControllerScrollFlagsKinetic
    -- ^ Emit [decelerate](#g:signal:decelerate) after continuous scroll finishes.
    | EventControllerScrollFlagsPhysicalDirection
    -- ^ A t'GI.Gtk.Flags.EventControllerScrollFlags' value to prefer physical direction over
    -- logical direction (i.e. oblivious to natural scroll).
    -- 
    -- /Since: 4.20/
    | EventControllerScrollFlagsBothAxes
    -- ^ Emit scroll on both axes.
    | AnotherEventControllerScrollFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum EventControllerScrollFlags where
    fromEnum EventControllerScrollFlagsNone = 0
    fromEnum EventControllerScrollFlagsVertical = 1
    fromEnum EventControllerScrollFlagsHorizontal = 2
    fromEnum EventControllerScrollFlagsDiscrete = 4
    fromEnum EventControllerScrollFlagsKinetic = 8
    fromEnum EventControllerScrollFlagsPhysicalDirection = 16
    fromEnum EventControllerScrollFlagsBothAxes = 3
    fromEnum (AnotherEventControllerScrollFlags k) = k

    toEnum 0 = EventControllerScrollFlagsNone
    toEnum 1 = EventControllerScrollFlagsVertical
    toEnum 2 = EventControllerScrollFlagsHorizontal
    toEnum 4 = EventControllerScrollFlagsDiscrete
    toEnum 8 = EventControllerScrollFlagsKinetic
    toEnum 16 = EventControllerScrollFlagsPhysicalDirection
    toEnum 3 = EventControllerScrollFlagsBothAxes
    toEnum k = AnotherEventControllerScrollFlags k

instance P.Ord EventControllerScrollFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes EventControllerScrollFlags = '[]
instance O.HasParentTypes EventControllerScrollFlags

foreign import ccall "gtk_event_controller_scroll_flags_get_type" c_gtk_event_controller_scroll_flags_get_type :: 
    IO GType

instance B.Types.TypedObject EventControllerScrollFlags where
    glibType = c_gtk_event_controller_scroll_flags_get_type

instance B.Types.BoxedFlags EventControllerScrollFlags

instance IsGFlag EventControllerScrollFlags

-- Flags DialogFlags
{-# DEPRECATED DialogFlags ["(Since version 4.20)","There is no replacement."] #-}
-- | Flags used to influence dialog construction.
data DialogFlags = 
      DialogFlagsModal
    -- ^ Make the constructed dialog modal
    | DialogFlagsDestroyWithParent
    -- ^ Destroy the dialog when its parent is destroyed
    | DialogFlagsUseHeaderBar
    -- ^ Create dialog with actions in header
    --   bar instead of action area
    | AnotherDialogFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DialogFlags where
    fromEnum DialogFlagsModal = 1
    fromEnum DialogFlagsDestroyWithParent = 2
    fromEnum DialogFlagsUseHeaderBar = 4
    fromEnum (AnotherDialogFlags k) = k

    toEnum 1 = DialogFlagsModal
    toEnum 2 = DialogFlagsDestroyWithParent
    toEnum 4 = DialogFlagsUseHeaderBar
    toEnum k = AnotherDialogFlags k

instance P.Ord DialogFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DialogFlags = '[]
instance O.HasParentTypes DialogFlags

foreign import ccall "gtk_dialog_flags_get_type" c_gtk_dialog_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DialogFlags where
    glibType = c_gtk_dialog_flags_get_type

instance B.Types.BoxedFlags DialogFlags

instance IsGFlag DialogFlags

-- Flags DebugFlags
-- | Flags to use with 'GI.Gtk.Functions.setDebugFlags'.
-- 
-- Settings these flags causes GTK to print out different
-- types of debugging information. Some of these flags are
-- only available when GTK has been configured with @-Ddebug=true@.
data DebugFlags = 
      DebugFlagsText
    -- ^ Information about GtkTextView
    | DebugFlagsTree
    -- ^ Information about GtkTreeView
    | DebugFlagsKeybindings
    -- ^ Information about keyboard shortcuts
    | DebugFlagsModules
    -- ^ Information about modules and extensions
    | DebugFlagsGeometry
    -- ^ Information about size allocation
    | DebugFlagsIcontheme
    -- ^ Information about icon themes
    | DebugFlagsPrinting
    -- ^ Information about printing
    | DebugFlagsBuilderTrace
    -- ^ Trace GtkBuilder operation
    | DebugFlagsSizeRequest
    -- ^ Information about size requests
    | DebugFlagsNoCssCache
    -- ^ Disable the style property cache
    | DebugFlagsInteractive
    -- ^ Open the GTK inspector
    | DebugFlagsTouchscreen
    -- ^ Show touch UI elements for pointer events.
    -- 
    -- /Since: 4.20/
    | DebugFlagsActions
    -- ^ Information about actions and menu models
    | DebugFlagsLayout
    -- ^ Information from layout managers
    | DebugFlagsSnapshot
    -- ^ Include debug render nodes in the generated snapshots
    | DebugFlagsConstraints
    -- ^ Information from the constraints solver
    | DebugFlagsBuilderObjects
    -- ^ Log unused GtkBuilder objects
    | DebugFlagsA11y
    -- ^ Information about accessibility state changes
    | DebugFlagsIconfallback
    -- ^ Information about icon fallback.
    -- 
    -- /Since: 4.2/
    | DebugFlagsInvertTextDir
    -- ^ Inverts the default text-direction.
    -- 
    -- /Since: 4.8/
    | DebugFlagsCss
    -- ^ Information about deprecated CSS features.
    -- 
    -- /Since: 4.16/
    | DebugFlagsBuilder
    -- ^ Information about deprecated GtkBuilder features.
    -- 
    -- /Since: 4.18/
    | AnotherDebugFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DebugFlags where
    fromEnum DebugFlagsText = 1
    fromEnum DebugFlagsTree = 2
    fromEnum DebugFlagsKeybindings = 4
    fromEnum DebugFlagsModules = 8
    fromEnum DebugFlagsGeometry = 16
    fromEnum DebugFlagsIcontheme = 32
    fromEnum DebugFlagsPrinting = 64
    fromEnum DebugFlagsBuilderTrace = 128
    fromEnum DebugFlagsSizeRequest = 256
    fromEnum DebugFlagsNoCssCache = 512
    fromEnum DebugFlagsInteractive = 1024
    fromEnum DebugFlagsTouchscreen = 2048
    fromEnum DebugFlagsActions = 4096
    fromEnum DebugFlagsLayout = 8192
    fromEnum DebugFlagsSnapshot = 16384
    fromEnum DebugFlagsConstraints = 32768
    fromEnum DebugFlagsBuilderObjects = 65536
    fromEnum DebugFlagsA11y = 131072
    fromEnum DebugFlagsIconfallback = 262144
    fromEnum DebugFlagsInvertTextDir = 524288
    fromEnum DebugFlagsCss = 1048576
    fromEnum DebugFlagsBuilder = 2097152
    fromEnum (AnotherDebugFlags k) = k

    toEnum 1 = DebugFlagsText
    toEnum 2 = DebugFlagsTree
    toEnum 4 = DebugFlagsKeybindings
    toEnum 8 = DebugFlagsModules
    toEnum 16 = DebugFlagsGeometry
    toEnum 32 = DebugFlagsIcontheme
    toEnum 64 = DebugFlagsPrinting
    toEnum 128 = DebugFlagsBuilderTrace
    toEnum 256 = DebugFlagsSizeRequest
    toEnum 512 = DebugFlagsNoCssCache
    toEnum 1024 = DebugFlagsInteractive
    toEnum 2048 = DebugFlagsTouchscreen
    toEnum 4096 = DebugFlagsActions
    toEnum 8192 = DebugFlagsLayout
    toEnum 16384 = DebugFlagsSnapshot
    toEnum 32768 = DebugFlagsConstraints
    toEnum 65536 = DebugFlagsBuilderObjects
    toEnum 131072 = DebugFlagsA11y
    toEnum 262144 = DebugFlagsIconfallback
    toEnum 524288 = DebugFlagsInvertTextDir
    toEnum 1048576 = DebugFlagsCss
    toEnum 2097152 = DebugFlagsBuilder
    toEnum k = AnotherDebugFlags k

instance P.Ord DebugFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DebugFlags = '[]
instance O.HasParentTypes DebugFlags

foreign import ccall "gtk_debug_flags_get_type" c_gtk_debug_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DebugFlags where
    glibType = c_gtk_debug_flags_get_type

instance B.Types.BoxedFlags DebugFlags

instance IsGFlag DebugFlags

-- Flags CellRendererState
{-# DEPRECATED CellRendererState ["(Since version 4.20)","There is no replacement."] #-}
-- | Tells how a cell is to be rendered.
data CellRendererState = 
      CellRendererStateSelected
    -- ^ The cell is currently selected, and
    --  probably has a selection colored background to render to.
    | CellRendererStatePrelit
    -- ^ The mouse is hovering over the cell.
    | CellRendererStateInsensitive
    -- ^ The cell is drawn in an insensitive manner
    | CellRendererStateSorted
    -- ^ The cell is in a sorted row
    | CellRendererStateFocused
    -- ^ The cell is in the focus row.
    | CellRendererStateExpandable
    -- ^ The cell is in a row that can be expanded
    | CellRendererStateExpanded
    -- ^ The cell is in a row that is expanded
    | AnotherCellRendererState Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CellRendererState where
    fromEnum CellRendererStateSelected = 1
    fromEnum CellRendererStatePrelit = 2
    fromEnum CellRendererStateInsensitive = 4
    fromEnum CellRendererStateSorted = 8
    fromEnum CellRendererStateFocused = 16
    fromEnum CellRendererStateExpandable = 32
    fromEnum CellRendererStateExpanded = 64
    fromEnum (AnotherCellRendererState k) = k

    toEnum 1 = CellRendererStateSelected
    toEnum 2 = CellRendererStatePrelit
    toEnum 4 = CellRendererStateInsensitive
    toEnum 8 = CellRendererStateSorted
    toEnum 16 = CellRendererStateFocused
    toEnum 32 = CellRendererStateExpandable
    toEnum 64 = CellRendererStateExpanded
    toEnum k = AnotherCellRendererState k

instance P.Ord CellRendererState where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes CellRendererState = '[]
instance O.HasParentTypes CellRendererState

foreign import ccall "gtk_cell_renderer_state_get_type" c_gtk_cell_renderer_state_get_type :: 
    IO GType

instance B.Types.TypedObject CellRendererState where
    glibType = c_gtk_cell_renderer_state_get_type

instance B.Types.BoxedFlags CellRendererState

instance IsGFlag CellRendererState

-- Flags BuilderClosureFlags
-- | The list of flags that can be passed to 'GI.Gtk.Objects.Builder.builderCreateClosure'.
-- 
-- New values may be added in the future for new features, so external
-- implementations of t'GI.Gtk.Interfaces.BuilderScope.BuilderScope' should test the flags
-- for unknown values and raise a 'GI.Gtk.Enums.BuilderErrorInvalidAttribute' error
-- when they encounter one.
data BuilderClosureFlags = 
      BuilderClosureFlagsSwapped
    -- ^ The closure should be created swapped. See
    --   @/g_cclosure_new_swap()/@ for details.
    | AnotherBuilderClosureFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BuilderClosureFlags where
    fromEnum BuilderClosureFlagsSwapped = 1
    fromEnum (AnotherBuilderClosureFlags k) = k

    toEnum 1 = BuilderClosureFlagsSwapped
    toEnum k = AnotherBuilderClosureFlags k

instance P.Ord BuilderClosureFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BuilderClosureFlags = '[]
instance O.HasParentTypes BuilderClosureFlags

foreign import ccall "gtk_builder_closure_flags_get_type" c_gtk_builder_closure_flags_get_type :: 
    IO GType

instance B.Types.TypedObject BuilderClosureFlags where
    glibType = c_gtk_builder_closure_flags_get_type

instance B.Types.BoxedFlags BuilderClosureFlags

instance IsGFlag BuilderClosureFlags

-- Flags ApplicationInhibitFlags
-- | Types of user actions that may be blocked by @GtkApplication@.
-- 
-- See 'GI.Gtk.Objects.Application.applicationInhibit'.
data ApplicationInhibitFlags = 
      ApplicationInhibitFlagsLogout
    -- ^ Inhibit ending the user session
    --   by logging out or by shutting down the computer
    | ApplicationInhibitFlagsSwitch
    -- ^ Inhibit user switching
    | ApplicationInhibitFlagsSuspend
    -- ^ Inhibit suspending the
    --   session or computer
    | ApplicationInhibitFlagsIdle
    -- ^ Inhibit the session being
    --   marked as idle (and possibly locked)
    | AnotherApplicationInhibitFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ApplicationInhibitFlags where
    fromEnum ApplicationInhibitFlagsLogout = 1
    fromEnum ApplicationInhibitFlagsSwitch = 2
    fromEnum ApplicationInhibitFlagsSuspend = 4
    fromEnum ApplicationInhibitFlagsIdle = 8
    fromEnum (AnotherApplicationInhibitFlags k) = k

    toEnum 1 = ApplicationInhibitFlagsLogout
    toEnum 2 = ApplicationInhibitFlagsSwitch
    toEnum 4 = ApplicationInhibitFlagsSuspend
    toEnum 8 = ApplicationInhibitFlagsIdle
    toEnum k = AnotherApplicationInhibitFlags k

instance P.Ord ApplicationInhibitFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ApplicationInhibitFlags = '[]
instance O.HasParentTypes ApplicationInhibitFlags

foreign import ccall "gtk_application_inhibit_flags_get_type" c_gtk_application_inhibit_flags_get_type :: 
    IO GType

instance B.Types.TypedObject ApplicationInhibitFlags where
    glibType = c_gtk_application_inhibit_flags_get_type

instance B.Types.BoxedFlags ApplicationInhibitFlags

instance IsGFlag ApplicationInhibitFlags


