/* DimHelper.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DimHelper.vala, do not modify */

/*
 * BrightnessController
 * This file is part of budgie-extras
 *
 * Author: Serdar ŞEN github.com/serdarsen
 *
 * Copyright © 2018 Ubuntu Budgie Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include "brightnesscontroller.h"
#include <stdlib.h>
#include <config.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BRIGHTNESS_CONTROLLER_HELPERS_TYPE_COLOR_SETTINGS (brightness_controller_helpers_color_settings_get_type ())
#define BRIGHTNESS_CONTROLLER_HELPERS_COLOR_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BRIGHTNESS_CONTROLLER_HELPERS_TYPE_COLOR_SETTINGS, BrightnessControllerHelpersColorSettings))
#define BRIGHTNESS_CONTROLLER_HELPERS_IS_COLOR_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BRIGHTNESS_CONTROLLER_HELPERS_TYPE_COLOR_SETTINGS))
#define BRIGHTNESS_CONTROLLER_HELPERS_COLOR_SETTINGS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BRIGHTNESS_CONTROLLER_HELPERS_TYPE_COLOR_SETTINGS, BrightnessControllerHelpersColorSettingsIface))

typedef struct _BrightnessControllerHelpersColorSettings BrightnessControllerHelpersColorSettings;
typedef struct _BrightnessControllerHelpersColorSettingsIface BrightnessControllerHelpersColorSettingsIface;

#define BRIGHTNESS_CONTROLLER_HELPERS_TYPE_COLOR_SETTINGS_PROXY (brightness_controller_helpers_color_settings_proxy_get_type ())
typedef GDBusProxy BrightnessControllerHelpersColorSettingsProxy;
typedef GDBusProxyClass BrightnessControllerHelpersColorSettingsProxyClass;
#define _brightness_controller_helpers_subprocess_helper_unref0(var) ((var == NULL) ? NULL : (var = (brightness_controller_helpers_subprocess_helper_unref (var), NULL)))
#define _brightness_controller_helpers_config_helper_unref0(var) ((var == NULL) ? NULL : (var = (brightness_controller_helpers_config_helper_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _brightness_controller_models_flame_unref0(var) ((var == NULL) ? NULL : (var = (brightness_controller_models_flame_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
#define _brightness_controller_helpers_dim_helper_unref0(var) ((var == NULL) ? NULL : (var = (brightness_controller_helpers_dim_helper_unref (var), NULL)))
typedef struct _BrightnessControllerHelpersParamSpecDimHelper BrightnessControllerHelpersParamSpecDimHelper;

struct _BrightnessControllerHelpersColorSettingsIface {
	GTypeInterface parent_iface;
	gboolean (*get_nightlight_active) (BrightnessControllerHelpersColorSettings* self);
};

struct _BrightnessControllerHelpersDimHelperPrivate {
	gboolean _IsAvailable;
	gboolean haveXrandr150;
	BrightnessControllerHelpersSubprocessHelper* subprocessHelper;
	BrightnessControllerHelpersConfigHelper* configHelper;
	BrightnessControllerHelpersColorSettings* color_settings;
};

struct _Block5Data {
	int _ref_count_;
	BrightnessControllerHelpersDimHelper* self;
	gchar** data;
	gint data_length1;
	gint _data_size_;
};

struct _BrightnessControllerHelpersParamSpecDimHelper {
	GParamSpec parent_instance;
};

static GType brightness_controller_helpers_color_settings_type_id = 0;
static gint BrightnessControllerHelpersDimHelper_private_offset;
static gpointer brightness_controller_helpers_dim_helper_parent_class = NULL;
static GType brightness_controller_helpers_dim_helper_type_id = 0;

GType brightness_controller_helpers_color_settings_register_type (GTypeModule * module);
VALA_EXTERN GType brightness_controller_helpers_color_settings_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType brightness_controller_helpers_color_settings_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void brightness_controller_helpers_color_settings_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint brightness_controller_helpers_color_settings_register_object (void* object,
                                                                    GDBusConnection* connection,
                                                                    const gchar* path,
                                                                    GError** error);
VALA_EXTERN gboolean brightness_controller_helpers_color_settings_get_nightlight_active (BrightnessControllerHelpersColorSettings* self);
static void brightness_controller_helpers_color_settings_proxy_g_signal (GDBusProxy* proxy,
                                                                  const gchar* sender_name,
                                                                  const gchar* signal_name,
                                                                  GVariant* parameters);
static gboolean brightness_controller_helpers_color_settings_dbus_proxy_get_nightlight_active (BrightnessControllerHelpersColorSettings* self);
static void brightness_controller_helpers_color_settings_proxy_brightness_controller_helpers_color_settings_interface_init (BrightnessControllerHelpersColorSettingsIface* iface);
static void brightness_controller_helpers_color_settings_dbus_interface_method_call (GDBusConnection* connection,
                                                                              const gchar* sender,
                                                                              const gchar* object_path,
                                                                              const gchar* interface_name,
                                                                              const gchar* method_name,
                                                                              GVariant* parameters,
                                                                              GDBusMethodInvocation* invocation,
                                                                              gpointer user_data);
static GVariant* brightness_controller_helpers_color_settings_dbus_interface_get_property (GDBusConnection* connection,
                                                                                    const gchar* sender,
                                                                                    const gchar* object_path,
                                                                                    const gchar* interface_name,
                                                                                    const gchar* property_name,
                                                                                    GError** error,
                                                                                    gpointer user_data);
static GVariant* _dbus_brightness_controller_helpers_color_settings_get_nightlight_active (BrightnessControllerHelpersColorSettings* self);
static gboolean brightness_controller_helpers_color_settings_dbus_interface_set_property (GDBusConnection* connection,
                                                                                   const gchar* sender,
                                                                                   const gchar* object_path,
                                                                                   const gchar* interface_name,
                                                                                   const gchar* property_name,
                                                                                   GVariant* value,
                                                                                   GError** error,
                                                                                   gpointer user_data);
static void _brightness_controller_helpers_color_settings_unregister_object (gpointer user_data);
static void _brightness_controller_models_flame_unref0_ (gpointer var);
static inline void _g_list_free__brightness_controller_models_flame_unref0_ (GList* self);
static void brightness_controller_helpers_dim_helper_Load (BrightnessControllerHelpersDimHelper* self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void __lambda5_ (BrightnessControllerHelpersDimHelper* self,
                 BrightnessControllerModelsDim* dim);
static void ___lambda5__gfunc (gconstpointer data,
                        gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda4_ (Block5Data* _data5_,
                 BrightnessControllerModelsDim* dim);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda4__gfunc (gconstpointer data,
                        gpointer self);
static void brightness_controller_helpers_dim_helper_finalize (BrightnessControllerHelpersDimHelper * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusMethodInfo * const _brightness_controller_helpers_color_settings_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _brightness_controller_helpers_color_settings_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _brightness_controller_helpers_color_settings_dbus_property_info_nightlight_active = {-1, "NightLightActive", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _brightness_controller_helpers_color_settings_dbus_property_info[] = {&_brightness_controller_helpers_color_settings_dbus_property_info_nightlight_active, NULL};
static const GDBusInterfaceInfo _brightness_controller_helpers_color_settings_dbus_interface_info = {-1, "org.gnome.SettingsDaemon.Color", (GDBusMethodInfo **) (&_brightness_controller_helpers_color_settings_dbus_method_info), (GDBusSignalInfo **) (&_brightness_controller_helpers_color_settings_dbus_signal_info), (GDBusPropertyInfo **) (&_brightness_controller_helpers_color_settings_dbus_property_info), NULL};
static const GDBusInterfaceVTable _brightness_controller_helpers_color_settings_dbus_interface_vtable = {brightness_controller_helpers_color_settings_dbus_interface_method_call, brightness_controller_helpers_color_settings_dbus_interface_get_property, brightness_controller_helpers_color_settings_dbus_interface_set_property};

gboolean
brightness_controller_helpers_color_settings_get_nightlight_active (BrightnessControllerHelpersColorSettings* self)
{
	BrightnessControllerHelpersColorSettingsIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BRIGHTNESS_CONTROLLER_HELPERS_COLOR_SETTINGS_GET_INTERFACE (self);
	if (_iface_->get_nightlight_active) {
		return _iface_->get_nightlight_active (self);
	}
	return FALSE;
}

static void
brightness_controller_helpers_color_settings_default_init (BrightnessControllerHelpersColorSettingsIface * iface,
                                                           gpointer iface_data)
{
}

GType
brightness_controller_helpers_color_settings_get_type (void)
{
	return brightness_controller_helpers_color_settings_type_id;
}

GType
brightness_controller_helpers_color_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BrightnessControllerHelpersColorSettingsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) brightness_controller_helpers_color_settings_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	brightness_controller_helpers_color_settings_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "BrightnessControllerHelpersColorSettings", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (brightness_controller_helpers_color_settings_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (brightness_controller_helpers_color_settings_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) brightness_controller_helpers_color_settings_proxy_get_type);
	g_type_set_qdata (brightness_controller_helpers_color_settings_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SettingsDaemon.Color");
	g_type_set_qdata (brightness_controller_helpers_color_settings_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_brightness_controller_helpers_color_settings_dbus_interface_info));
	g_type_set_qdata (brightness_controller_helpers_color_settings_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) brightness_controller_helpers_color_settings_register_object);
	return brightness_controller_helpers_color_settings_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (BrightnessControllerHelpersColorSettingsProxy, brightness_controller_helpers_color_settings_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (BRIGHTNESS_CONTROLLER_HELPERS_TYPE_COLOR_SETTINGS, brightness_controller_helpers_color_settings_proxy_brightness_controller_helpers_color_settings_interface_init) )
static void
brightness_controller_helpers_color_settings_proxy_class_init (BrightnessControllerHelpersColorSettingsProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = brightness_controller_helpers_color_settings_proxy_g_signal;
}

static void
brightness_controller_helpers_color_settings_proxy_g_signal (GDBusProxy* proxy,
                                                             const gchar* sender_name,
                                                             const gchar* signal_name,
                                                             GVariant* parameters)
{
}

static void
brightness_controller_helpers_color_settings_proxy_class_finalize (BrightnessControllerHelpersColorSettingsProxyClass* klass)
{
}

void
brightness_controller_helpers_color_settings_proxy_register_dynamic_type (GTypeModule* module)
{
	brightness_controller_helpers_color_settings_proxy_register_type (module);
}

static void
brightness_controller_helpers_color_settings_proxy_init (BrightnessControllerHelpersColorSettingsProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_brightness_controller_helpers_color_settings_dbus_interface_info));
}

static gboolean
brightness_controller_helpers_color_settings_dbus_proxy_get_nightlight_active (BrightnessControllerHelpersColorSettings* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "NightLightActive");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Color"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("NightLightActive"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp0_ = FALSE;
			return _tmp0_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
brightness_controller_helpers_color_settings_proxy_brightness_controller_helpers_color_settings_interface_init (BrightnessControllerHelpersColorSettingsIface* iface)
{
	iface->get_nightlight_active = brightness_controller_helpers_color_settings_dbus_proxy_get_nightlight_active;
}

static void
brightness_controller_helpers_color_settings_dbus_interface_method_call (GDBusConnection* connection,
                                                                         const gchar* sender,
                                                                         const gchar* object_path,
                                                                         const gchar* interface_name,
                                                                         const gchar* method_name,
                                                                         GVariant* parameters,
                                                                         GDBusMethodInvocation* invocation,
                                                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_brightness_controller_helpers_color_settings_get_nightlight_active (BrightnessControllerHelpersColorSettings* self)
{
	gboolean result;
	GVariant* _reply;
	result = brightness_controller_helpers_color_settings_get_nightlight_active (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
brightness_controller_helpers_color_settings_dbus_interface_get_property (GDBusConnection* connection,
                                                                          const gchar* sender,
                                                                          const gchar* object_path,
                                                                          const gchar* interface_name,
                                                                          const gchar* property_name,
                                                                          GError** error,
                                                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "NightLightActive") == 0) {
		return _dbus_brightness_controller_helpers_color_settings_get_nightlight_active (object);
	}
	return NULL;
}

static gboolean
brightness_controller_helpers_color_settings_dbus_interface_set_property (GDBusConnection* connection,
                                                                          const gchar* sender,
                                                                          const gchar* object_path,
                                                                          const gchar* interface_name,
                                                                          const gchar* property_name,
                                                                          GVariant* value,
                                                                          GError** error,
                                                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
brightness_controller_helpers_color_settings_register_object (gpointer object,
                                                              GDBusConnection* connection,
                                                              const gchar* path,
                                                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_brightness_controller_helpers_color_settings_dbus_interface_info), &_brightness_controller_helpers_color_settings_dbus_interface_vtable, data, _brightness_controller_helpers_color_settings_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_brightness_controller_helpers_color_settings_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
brightness_controller_helpers_dim_helper_get_instance_private (BrightnessControllerHelpersDimHelper* self)
{
	return G_STRUCT_MEMBER_P (self, BrightnessControllerHelpersDimHelper_private_offset);
}

static void
_brightness_controller_models_flame_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (brightness_controller_models_flame_unref (var), NULL));
}

static inline void
_g_list_free__brightness_controller_models_flame_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _brightness_controller_models_flame_unref0_);
}

BrightnessControllerHelpersDimHelper*
brightness_controller_helpers_dim_helper_construct (GType object_type)
{
	BrightnessControllerHelpersDimHelper* self = NULL;
	BrightnessControllerHelpersSubprocessHelper* _tmp5_;
	BrightnessControllerHelpersConfigHelper* _tmp6_;
	GError* _inner_error0_ = NULL;
	self = (BrightnessControllerHelpersDimHelper*) g_type_create_instance (object_type);
	{
		BrightnessControllerHelpersColorSettings* _tmp0_ = NULL;
		BrightnessControllerHelpersColorSettings* _tmp1_;
		BrightnessControllerHelpersColorSettings* _tmp2_;
		_tmp1_ = (BrightnessControllerHelpersColorSettings*) g_initable_new (BRIGHTNESS_CONTROLLER_HELPERS_TYPE_COLOR_SETTINGS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.gnome.SettingsDaemon.Color", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SettingsDaemon/Color", "g-interface-name", "org.gnome.SettingsDaemon.Color", NULL);
		_tmp0_ = (BrightnessControllerHelpersColorSettings*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->color_settings);
		self->priv->color_settings = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_g_object_unref0 (self->priv->color_settings);
		self->priv->color_settings = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("DimHelper.vala:50: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp5_ = brightness_controller_helpers_subprocess_helper_new ();
	_brightness_controller_helpers_subprocess_helper_unref0 (self->priv->subprocessHelper);
	self->priv->subprocessHelper = _tmp5_;
	_tmp6_ = brightness_controller_helpers_config_helper_new ("budgie-advanced-brightness-controller", "dim");
	_brightness_controller_helpers_config_helper_unref0 (self->priv->configHelper);
	self->priv->configHelper = _tmp6_;
	brightness_controller_helpers_dim_helper_Load (self);
	return self;
}

BrightnessControllerHelpersDimHelper*
brightness_controller_helpers_dim_helper_new (void)
{
	return brightness_controller_helpers_dim_helper_construct (BRIGHTNESS_CONTROLLER_HELPERS_TYPE_DIM_HELPER);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
string_to_bool (const gchar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_strcmp0 (self, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gpointer
_brightness_controller_models_flame_ref0 (gpointer self)
{
	return self ? brightness_controller_models_flame_ref (self) : NULL;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
brightness_controller_helpers_dim_helper_Load (BrightnessControllerHelpersDimHelper* self)
{
	gchar** retrivedDimNames = NULL;
	gchar** _tmp0_;
	gint retrivedDimNames_length1;
	gint _retrivedDimNames_size_;
	gchar** dimObjects = NULL;
	BrightnessControllerHelpersConfigHelper* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint dimObjects_length1;
	gint _dimObjects_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* dimsString = NULL;
	BrightnessControllerHelpersSubprocessHelper* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar** _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar** lines = NULL;
	const gchar* _tmp43_;
	gchar** _tmp44_;
	gchar** _tmp45_;
	gint lines_length1;
	gint _lines_size_;
	gint connectedDeviceCount = 0;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gboolean _tmp74_ = FALSE;
	g_return_if_fail (self != NULL);
	(self->list == NULL) ? NULL : (self->list = (_g_list_free__brightness_controller_models_flame_unref0_ (self->list), NULL));
	self->list = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	retrivedDimNames = _tmp0_;
	retrivedDimNames_length1 = 0;
	_retrivedDimNames_size_ = retrivedDimNames_length1;
	_tmp1_ = self->priv->configHelper;
	_tmp3_ = brightness_controller_helpers_config_helper_Read (_tmp1_, &_tmp2_);
	dimObjects = _tmp3_;
	dimObjects_length1 = _tmp2_;
	_dimObjects_size_ = dimObjects_length1;
	_tmp4_ = dimObjects;
	_tmp4__length1 = dimObjects_length1;
	{
		gchar** obj_collection = NULL;
		gint obj_collection_length1 = 0;
		gint _obj_collection_size_ = 0;
		gint obj_it = 0;
		obj_collection = _tmp4_;
		obj_collection_length1 = _tmp4__length1;
		for (obj_it = 0; obj_it < obj_collection_length1; obj_it = obj_it + 1) {
			gchar* _tmp5_;
			gchar* obj = NULL;
			_tmp5_ = g_strdup (obj_collection[obj_it]);
			obj = _tmp5_;
			{
				gchar** properties = NULL;
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_;
				gint properties_length1;
				gint _properties_size_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				_tmp6_ = obj;
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, " ", 0);
				properties = _tmp8_;
				properties_length1 = _vala_array_length (_tmp7_);
				_properties_size_ = properties_length1;
				_tmp9_ = properties;
				_tmp9__length1 = properties_length1;
				if (_tmp9__length1 > 4) {
					BrightnessControllerModelsDim* dim = NULL;
					BrightnessControllerModelsDim* _tmp10_;
					BrightnessControllerModelsDim* _tmp11_;
					gchar** _tmp12_;
					gint _tmp12__length1;
					const gchar* _tmp13_;
					BrightnessControllerModelsDim* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					BrightnessControllerModelsDim* _tmp18_;
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					BrightnessControllerModelsDim* _tmp21_;
					gchar** _tmp22_;
					gint _tmp22__length1;
					const gchar* _tmp23_;
					BrightnessControllerModelsDim* _tmp24_;
					gchar** _tmp25_;
					gint _tmp25__length1;
					const gchar* _tmp26_;
					BrightnessControllerModelsDim* _tmp27_;
					gchar** _tmp28_;
					gint _tmp28__length1;
					const gchar* _tmp29_;
					BrightnessControllerModelsDim* _tmp30_;
					BrightnessControllerModelsDim* _tmp31_;
					_tmp10_ = brightness_controller_models_dim_new ();
					dim = _tmp10_;
					_tmp11_ = dim;
					_tmp12_ = properties;
					_tmp12__length1 = properties_length1;
					_tmp13_ = _tmp12_[0];
					brightness_controller_models_flame_set_Name ((BrightnessControllerModelsFlame*) _tmp11_, _tmp13_);
					_tmp14_ = dim;
					_tmp15_ = brightness_controller_models_flame_get_Name ((BrightnessControllerModelsFlame*) _tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strdup (_tmp16_);
					_vala_array_add1 (&retrivedDimNames, &retrivedDimNames_length1, &_retrivedDimNames_size_, _tmp17_);
					_tmp18_ = dim;
					_tmp19_ = properties;
					_tmp19__length1 = properties_length1;
					_tmp20_ = _tmp19_[1];
					brightness_controller_models_flame_set_MaxBrightness ((BrightnessControllerModelsFlame*) _tmp18_, g_ascii_strtod (_tmp20_, NULL));
					_tmp21_ = dim;
					_tmp22_ = properties;
					_tmp22__length1 = properties_length1;
					_tmp23_ = _tmp22_[2];
					brightness_controller_models_flame_set_Brightness ((BrightnessControllerModelsFlame*) _tmp21_, g_ascii_strtod (_tmp23_, NULL));
					_tmp24_ = dim;
					_tmp25_ = properties;
					_tmp25__length1 = properties_length1;
					_tmp26_ = _tmp25_[3];
					brightness_controller_models_dim_set_Blue (_tmp24_, g_ascii_strtod (_tmp26_, NULL));
					_tmp27_ = dim;
					_tmp28_ = properties;
					_tmp28__length1 = properties_length1;
					_tmp29_ = _tmp28_[4];
					brightness_controller_models_flame_set_IsActive ((BrightnessControllerModelsFlame*) _tmp27_, string_to_bool (_tmp29_));
					_tmp30_ = dim;
					_tmp31_ = _brightness_controller_models_flame_ref0 (_tmp30_);
					self->list = g_list_append (self->list, _tmp31_);
					_brightness_controller_models_flame_unref0 (dim);
				}
				properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (obj);
			}
		}
	}
	_tmp32_ = self->priv->subprocessHelper;
	_tmp33_ = g_strdup (PACKAGE_BINDIR "/xrandr");
	_tmp34_ = g_strdup ("-q");
	_tmp35_ = g_new0 (gchar*, 2 + 1);
	_tmp35_[0] = _tmp33_;
	_tmp35_[1] = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp36__length1 = 2;
	_tmp37_ = brightness_controller_helpers_subprocess_helper_RunAndGetResult (_tmp32_, _tmp36_, (gint) 2);
	_tmp38_ = _tmp37_;
	_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
	dimsString = _tmp38_;
	_tmp39_ = dimsString;
	_tmp40_ = g_strstrip (_tmp39_);
	_tmp41_ = g_strdup (_tmp40_);
	_g_free0 (dimsString);
	dimsString = _tmp41_;
	_tmp42_ = dimsString;
	if (g_strcmp0 (_tmp42_, "") == 0) {
		_g_free0 (dimsString);
		dimObjects = (_vala_array_free (dimObjects, dimObjects_length1, (GDestroyNotify) g_free), NULL);
		retrivedDimNames = (_vala_array_free (retrivedDimNames, retrivedDimNames_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp43_ = dimsString;
	_tmp45_ = _tmp44_ = g_strsplit (_tmp43_, "\n", 0);
	lines = _tmp45_;
	lines_length1 = _vala_array_length (_tmp44_);
	_lines_size_ = lines_length1;
	connectedDeviceCount = 0;
	_tmp46_ = lines;
	_tmp46__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp46_;
		line_collection_length1 = _tmp46__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp47_;
			gchar* line = NULL;
			_tmp47_ = g_strdup (line_collection[line_it]);
			line = _tmp47_;
			{
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				gchar* _tmp50_;
				const gchar* _tmp51_;
				_tmp48_ = line;
				_tmp49_ = g_strstrip (_tmp48_);
				_tmp50_ = g_strdup (_tmp49_);
				_g_free0 (line);
				line = _tmp50_;
				_tmp51_ = line;
				if (g_strcmp0 (_tmp51_, "") != 0) {
					gchar** words = NULL;
					const gchar* _tmp52_;
					gchar** _tmp53_;
					gchar** _tmp54_;
					gint words_length1;
					gint _words_size_;
					gchar** _tmp55_;
					gint _tmp55__length1;
					_tmp52_ = line;
					_tmp54_ = _tmp53_ = g_strsplit (_tmp52_, " ", 0);
					words = _tmp54_;
					words_length1 = _vala_array_length (_tmp53_);
					_words_size_ = words_length1;
					_tmp55_ = words;
					_tmp55__length1 = words_length1;
					{
						gchar** word_collection = NULL;
						gint word_collection_length1 = 0;
						gint _word_collection_size_ = 0;
						gint word_it = 0;
						word_collection = _tmp55_;
						word_collection_length1 = _tmp55__length1;
						for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
							gchar* _tmp56_;
							gchar* word = NULL;
							_tmp56_ = g_strdup (word_collection[word_it]);
							word = _tmp56_;
							{
								gboolean _tmp57_ = FALSE;
								const gchar* _tmp58_;
								_tmp58_ = word;
								if (g_strcmp0 (_tmp58_, "connected") == 0) {
									gchar** _tmp59_;
									gint _tmp59__length1;
									gchar** _tmp60_;
									gint _tmp60__length1;
									const gchar* _tmp61_;
									_tmp59_ = retrivedDimNames;
									_tmp59__length1 = retrivedDimNames_length1;
									_tmp60_ = words;
									_tmp60__length1 = words_length1;
									_tmp61_ = _tmp60_[0];
									_tmp57_ = !g_strv_contains (_tmp59_, _tmp61_);
								} else {
									_tmp57_ = FALSE;
								}
								if (_tmp57_) {
									BrightnessControllerModelsDim* dim = NULL;
									BrightnessControllerModelsDim* _tmp62_;
									BrightnessControllerModelsDim* _tmp63_;
									gchar** _tmp64_;
									gint _tmp64__length1;
									const gchar* _tmp65_;
									BrightnessControllerModelsDim* _tmp66_;
									BrightnessControllerModelsDim* _tmp67_;
									BrightnessControllerModelsDim* _tmp68_;
									BrightnessControllerModelsDim* _tmp71_;
									BrightnessControllerModelsDim* _tmp72_;
									gint _tmp73_;
									_tmp62_ = brightness_controller_models_dim_new ();
									dim = _tmp62_;
									_tmp63_ = dim;
									_tmp64_ = words;
									_tmp64__length1 = words_length1;
									_tmp65_ = _tmp64_[0];
									brightness_controller_models_flame_set_Name ((BrightnessControllerModelsFlame*) _tmp63_, _tmp65_);
									_tmp66_ = dim;
									brightness_controller_models_flame_set_MaxBrightness ((BrightnessControllerModelsFlame*) _tmp66_, (gdouble) 100);
									_tmp67_ = dim;
									brightness_controller_models_flame_set_Brightness ((BrightnessControllerModelsFlame*) _tmp67_, (gdouble) 100);
									_tmp68_ = dim;
									brightness_controller_models_dim_set_Blue (_tmp68_, (gdouble) 100);
									if (connectedDeviceCount == 0) {
										BrightnessControllerModelsDim* _tmp69_;
										_tmp69_ = dim;
										brightness_controller_models_flame_set_IsActive ((BrightnessControllerModelsFlame*) _tmp69_, TRUE);
									} else {
										BrightnessControllerModelsDim* _tmp70_;
										_tmp70_ = dim;
										brightness_controller_models_flame_set_IsActive ((BrightnessControllerModelsFlame*) _tmp70_, FALSE);
									}
									_tmp71_ = dim;
									_tmp72_ = _brightness_controller_models_flame_ref0 (_tmp71_);
									self->list = g_list_append (self->list, _tmp72_);
									_tmp73_ = connectedDeviceCount;
									connectedDeviceCount = _tmp73_ + 1;
									_brightness_controller_models_flame_unref0 (dim);
								}
								_g_free0 (word);
							}
						}
					}
					words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (line);
			}
		}
	}
	self->priv->haveXrandr150 = TRUE;
	if (self->priv->haveXrandr150) {
		GList* _tmp75_;
		_tmp75_ = self->list;
		_tmp74_ = g_list_length (_tmp75_) > ((guint) 0);
	} else {
		_tmp74_ = FALSE;
	}
	if (_tmp74_) {
		brightness_controller_helpers_dim_helper_set_IsAvailable (self, TRUE);
	} else {
		guint dimListLength = 0U;
		GList* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		brightness_controller_helpers_dim_helper_set_IsAvailable (self, FALSE);
		_tmp76_ = self->list;
		dimListLength = g_list_length (_tmp76_);
		_tmp77_ = bool_to_string (self->priv->haveXrandr150);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_strdup_printf ("%u", dimListLength);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_strconcat ("Dim is not available (Xrandr version >= 1.5.0: ", _tmp78_, ", Number of Dims: ", _tmp80_, ")\n", NULL);
		_tmp82_ = _tmp81_;
		g_message ("DimHelper.vala:141: %s", _tmp82_);
		_g_free0 (_tmp82_);
		_g_free0 (_tmp80_);
		_g_free0 (_tmp78_);
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (dimsString);
	dimObjects = (_vala_array_free (dimObjects, dimObjects_length1, (GDestroyNotify) g_free), NULL);
	retrivedDimNames = (_vala_array_free (retrivedDimNames, retrivedDimNames_length1, (GDestroyNotify) g_free), NULL);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

void
brightness_controller_helpers_dim_helper_SetBrightness (BrightnessControllerHelpersDimHelper* self,
                                                        const gchar* name,
                                                        gdouble brightness,
                                                        gdouble blue)
{
	gdouble aOnePercentOfbrightness = 0.0;
	gdouble aOnePercentOfBlue = 0.0;
	BrightnessControllerHelpersSubprocessHelper* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	aOnePercentOfbrightness = brightness / 100;
	aOnePercentOfBlue = blue / 100;
	_tmp0_ = self->priv->subprocessHelper;
	_tmp1_ = g_strdup (PACKAGE_BINDIR "/xrandr");
	_tmp2_ = g_strdup ("--output");
	_tmp3_ = string_to_string (name);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = g_strdup ("--gamma");
	_tmp6_ = double_to_string (aOnePercentOfBlue);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("1:1:", _tmp7_, NULL);
	_tmp9_ = g_strdup ("--brightness");
	_tmp10_ = double_to_string (aOnePercentOfbrightness);
	_tmp11_ = g_new0 (gchar*, 7 + 1);
	_tmp11_[0] = _tmp1_;
	_tmp11_[1] = _tmp2_;
	_tmp11_[2] = _tmp4_;
	_tmp11_[3] = _tmp5_;
	_tmp11_[4] = _tmp8_;
	_tmp11_[5] = _tmp9_;
	_tmp11_[6] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 7;
	brightness_controller_helpers_subprocess_helper_Run (_tmp0_, _tmp12_, (gint) 7);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp7_);
	brightness_controller_helpers_dim_helper_Save (self);
}

static void
__lambda5_ (BrightnessControllerHelpersDimHelper* self,
            BrightnessControllerModelsDim* dim)
{
	g_return_if_fail (dim != NULL);
	brightness_controller_models_flame_set_IsActive ((BrightnessControllerModelsFlame*) dim, FALSE);
}

static void
___lambda5__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda5_ ((BrightnessControllerHelpersDimHelper*) self, (BrightnessControllerModelsDim*) data);
}

void
brightness_controller_helpers_dim_helper_SetActive (BrightnessControllerHelpersDimHelper* self,
                                                    BrightnessControllerModelsDim* dim)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dim != NULL);
	_tmp0_ = self->list;
	g_list_foreach (_tmp0_, ___lambda5__gfunc, self);
	brightness_controller_models_flame_set_IsActive ((BrightnessControllerModelsFlame*) dim, TRUE);
	brightness_controller_helpers_dim_helper_Save (self);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BrightnessControllerHelpersDimHelper* self;
		self = _data5_->self;
		_data5_->data = (_vala_array_free (_data5_->data, _data5_->data_length1, (GDestroyNotify) g_free), NULL);
		_brightness_controller_helpers_dim_helper_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda4_ (Block5Data* _data5_,
            BrightnessControllerModelsDim* dim)
{
	BrightnessControllerHelpersDimHelper* self;
	gchar* name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* maxBrightness = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* brightness = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* blue = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean isActive = FALSE;
	gboolean _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	self = _data5_->self;
	g_return_if_fail (dim != NULL);
	_tmp0_ = brightness_controller_models_flame_get_Name ((BrightnessControllerModelsFlame*) dim);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = brightness_controller_models_dim_get_MaxBrightnessText (dim);
	_tmp4_ = _tmp3_;
	maxBrightness = _tmp4_;
	_tmp5_ = brightness_controller_models_dim_get_BrightnessText (dim);
	_tmp6_ = _tmp5_;
	brightness = _tmp6_;
	_tmp7_ = brightness_controller_models_dim_get_BlueText (dim);
	_tmp8_ = _tmp7_;
	blue = _tmp8_;
	_tmp9_ = brightness_controller_models_flame_get_IsActive ((BrightnessControllerModelsFlame*) dim);
	_tmp10_ = _tmp9_;
	isActive = _tmp10_;
	_tmp11_ = string_to_string (name);
	_tmp12_ = string_to_string (maxBrightness);
	_tmp13_ = string_to_string (brightness);
	_tmp14_ = string_to_string (blue);
	_tmp15_ = bool_to_string (isActive);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp11_, " ", _tmp12_, " ", _tmp13_, " ", _tmp14_, " ", _tmp16_, NULL);
	_vala_array_add2 (&_data5_->data, &_data5_->data_length1, &_data5_->_data_size_, _tmp17_);
	_g_free0 (_tmp16_);
	_g_free0 (blue);
	_g_free0 (brightness);
	_g_free0 (maxBrightness);
	_g_free0 (name);
}

static void
___lambda4__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda4_ (self, (BrightnessControllerModelsDim*) data);
}

void
brightness_controller_helpers_dim_helper_Save (BrightnessControllerHelpersDimHelper* self)
{
	Block5Data* _data5_;
	gchar** _tmp0_;
	GList* _tmp1_;
	BrightnessControllerHelpersConfigHelper* _tmp2_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = brightness_controller_helpers_dim_helper_ref (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data5_->data = _tmp0_;
	_data5_->data_length1 = 0;
	_data5_->_data_size_ = _data5_->data_length1;
	_tmp1_ = self->list;
	g_list_foreach (_tmp1_, ___lambda4__gfunc, _data5_);
	_tmp2_ = self->priv->configHelper;
	brightness_controller_helpers_config_helper_Write (_tmp2_, _data5_->data, (gint) _data5_->data_length1);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

gboolean
brightness_controller_helpers_dim_helper_NightlightOn (BrightnessControllerHelpersDimHelper* self)
{
	BrightnessControllerHelpersColorSettings* _tmp0_;
	BrightnessControllerHelpersColorSettings* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->color_settings;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->color_settings;
	_tmp2_ = brightness_controller_helpers_color_settings_get_nightlight_active (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

gboolean
brightness_controller_helpers_dim_helper_get_IsAvailable (BrightnessControllerHelpersDimHelper* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_IsAvailable;
	return result;
}

void
brightness_controller_helpers_dim_helper_set_IsAvailable (BrightnessControllerHelpersDimHelper* self,
                                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_IsAvailable = value;
}

static void
brightness_controller_helpers_value_dim_helper_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
brightness_controller_helpers_value_dim_helper_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		brightness_controller_helpers_dim_helper_unref (value->data[0].v_pointer);
	}
}

static void
brightness_controller_helpers_value_dim_helper_copy_value (const GValue* src_value,
                                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = brightness_controller_helpers_dim_helper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
brightness_controller_helpers_value_dim_helper_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
brightness_controller_helpers_value_dim_helper_collect_value (GValue* value,
                                                              guint n_collect_values,
                                                              GTypeCValue* collect_values,
                                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BrightnessControllerHelpersDimHelper * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = brightness_controller_helpers_dim_helper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
brightness_controller_helpers_value_dim_helper_lcopy_value (const GValue* value,
                                                            guint n_collect_values,
                                                            GTypeCValue* collect_values,
                                                            guint collect_flags)
{
	BrightnessControllerHelpersDimHelper ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = brightness_controller_helpers_dim_helper_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
brightness_controller_helpers_param_spec_dim_helper (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags)
{
	BrightnessControllerHelpersParamSpecDimHelper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_DIM_HELPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
brightness_controller_helpers_value_get_dim_helper (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_DIM_HELPER), NULL);
	return value->data[0].v_pointer;
}

void
brightness_controller_helpers_value_set_dim_helper (GValue* value,
                                                    gpointer v_object)
{
	BrightnessControllerHelpersDimHelper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_DIM_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_DIM_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		brightness_controller_helpers_dim_helper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		brightness_controller_helpers_dim_helper_unref (old);
	}
}

void
brightness_controller_helpers_value_take_dim_helper (GValue* value,
                                                     gpointer v_object)
{
	BrightnessControllerHelpersDimHelper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_DIM_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_DIM_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		brightness_controller_helpers_dim_helper_unref (old);
	}
}

static void
brightness_controller_helpers_dim_helper_class_init (BrightnessControllerHelpersDimHelperClass * klass,
                                                     gpointer klass_data)
{
	brightness_controller_helpers_dim_helper_parent_class = g_type_class_peek_parent (klass);
	((BrightnessControllerHelpersDimHelperClass *) klass)->finalize = brightness_controller_helpers_dim_helper_finalize;
	g_type_class_adjust_private_offset (klass, &BrightnessControllerHelpersDimHelper_private_offset);
}

static void
brightness_controller_helpers_dim_helper_instance_init (BrightnessControllerHelpersDimHelper * self,
                                                        gpointer klass)
{
	self->priv = brightness_controller_helpers_dim_helper_get_instance_private (self);
	self->priv->haveXrandr150 = FALSE;
	self->ref_count = 1;
}

static void
brightness_controller_helpers_dim_helper_finalize (BrightnessControllerHelpersDimHelper * obj)
{
	BrightnessControllerHelpersDimHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_DIM_HELPER, BrightnessControllerHelpersDimHelper);
	g_signal_handlers_destroy (self);
	(self->list == NULL) ? NULL : (self->list = (_g_list_free__brightness_controller_models_flame_unref0_ (self->list), NULL));
	_brightness_controller_helpers_subprocess_helper_unref0 (self->priv->subprocessHelper);
	_brightness_controller_helpers_config_helper_unref0 (self->priv->configHelper);
	_g_object_unref0 (self->priv->color_settings);
}

/**
 * DimHelper is a helper to work with
 * xrandr
 * Currently working correctly with xrandr-1.5.0
 *
 */
GType
brightness_controller_helpers_dim_helper_get_type (void)
{
	return brightness_controller_helpers_dim_helper_type_id;
}

GType
brightness_controller_helpers_dim_helper_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { brightness_controller_helpers_value_dim_helper_init, brightness_controller_helpers_value_dim_helper_free_value, brightness_controller_helpers_value_dim_helper_copy_value, brightness_controller_helpers_value_dim_helper_peek_pointer, "p", brightness_controller_helpers_value_dim_helper_collect_value, "p", brightness_controller_helpers_value_dim_helper_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BrightnessControllerHelpersDimHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) brightness_controller_helpers_dim_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BrightnessControllerHelpersDimHelper), 0, (GInstanceInitFunc) brightness_controller_helpers_dim_helper_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	brightness_controller_helpers_dim_helper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BrightnessControllerHelpersDimHelper", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BrightnessControllerHelpersDimHelper_private_offset = sizeof (BrightnessControllerHelpersDimHelperPrivate);
	return brightness_controller_helpers_dim_helper_type_id;
}

gpointer
brightness_controller_helpers_dim_helper_ref (gpointer instance)
{
	BrightnessControllerHelpersDimHelper * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
brightness_controller_helpers_dim_helper_unref (gpointer instance)
{
	BrightnessControllerHelpersDimHelper * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BRIGHTNESS_CONTROLLER_HELPERS_DIM_HELPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

