/* do not edit automatically generated by mc from M2System.  */
/* M2System.def defines the SYSTEM builtin types.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2System_H)
#   define _M2System_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "Ggcctypes.h"

#   if defined (_M2System_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

EXTERN unsigned int M2System_System;
EXTERN unsigned int M2System_Loc;
EXTERN unsigned int M2System_Word;
EXTERN unsigned int M2System_Byte;
EXTERN unsigned int M2System_Address;
EXTERN unsigned int M2System_CSizeT;
EXTERN unsigned int M2System_CSSizeT;
EXTERN unsigned int M2System_COffT;
EXTERN unsigned int M2System_Adr;
EXTERN unsigned int M2System_TSize;
EXTERN unsigned int M2System_TBitSize;
EXTERN unsigned int M2System_AddAdr;
EXTERN unsigned int M2System_SubAdr;
EXTERN unsigned int M2System_DifAdr;
EXTERN unsigned int M2System_MakeAdr;
EXTERN unsigned int M2System_Rotate;
EXTERN unsigned int M2System_Shift;
EXTERN unsigned int M2System_Cast;
EXTERN unsigned int M2System_Throw;

/*
   InitSystem - initializes the base types Word and Byte in the module
                SYSTEM.
*/

EXTERN void M2System_InitSystem (void);

/*
   GetSystemTypeMinMax - returns the minimum and maximum values for a given system type.
*/

EXTERN void M2System_GetSystemTypeMinMax (unsigned int type, unsigned int *min, unsigned int *max);

/*
   IsPseudoSystemFunction - returns true if Sym is a SYSTEM pseudo function.
*/

EXTERN bool M2System_IsPseudoSystemFunction (unsigned int sym);

/*
   IsPseudoSystemProcedure - returns true if Sym is a SYSTEM pseudo procedure.
*/

EXTERN bool M2System_IsPseudoSystemProcedure (unsigned int sym);

/*
   IsPseudoSystemFunctionConstExpression - returns TRUE if this procedure
                                           is legal in a constant expression.
*/

EXTERN bool M2System_IsPseudoSystemFunctionConstExpression (unsigned int sym);

/*
   IsSystemType - returns TRUE if Sym is a SYSTEM (inbuilt) type.
                  It does not search your SYSTEM implementation module.
*/

EXTERN bool M2System_IsSystemType (unsigned int sym);

/*
   IntegerN - returns the symbol associated with INTEGER[N].
              NulSym is returned if the type does not exist.
*/

EXTERN unsigned int M2System_IntegerN (unsigned int bitlength);

/*
   CardinalN - returns the symbol associated with CARDINAL[N].
               NulSym is returned if the type does not exist.
*/

EXTERN unsigned int M2System_CardinalN (unsigned int bitlength);

/*
   WordN - returns the symbol associated with WORD[N].
           NulSym is returned if the type does not exist.
*/

EXTERN unsigned int M2System_WordN (unsigned int bitlength);

/*
   SetN - returns the symbol associated with SET[N].
          NulSym is returned if the type does not exist.
*/

EXTERN unsigned int M2System_SetN (unsigned int bitlength);

/*
   RealN - returns the symbol associated with REAL[N].
           NulSym is returned if the type does not exist.
*/

EXTERN unsigned int M2System_RealN (unsigned int bitlength);

/*
   ComplexN - returns the symbol associated with COMPLEX[N].
              NulSym is returned if the type does not exist.
*/

EXTERN unsigned int M2System_ComplexN (unsigned int bitlength);

/*
   IsIntegerN - returns the TRUE if, sym, is one of the SYSTEM
                INTEGER types (not the base INTEGER type).
*/

EXTERN bool M2System_IsIntegerN (unsigned int sym);

/*
   IsCardinalN - returns the TRUE if, sym, is one of the SYSTEM
                 CARDINAL types (not the base CARDINAL type).
*/

EXTERN bool M2System_IsCardinalN (unsigned int sym);

/*
   IsWordN - returns the TRUE if, sym, is one of the SYSTEM
             WORD[n] types (not the default SYSTEM WORD type).
*/

EXTERN bool M2System_IsWordN (unsigned int sym);

/*
   IsSetN - returns the TRUE if, sym, is one of the SYSTEM
            SET[n] types (not the default SYSTEM BITSET type).
*/

EXTERN bool M2System_IsSetN (unsigned int sym);

/*
   IsRealN - returns the TRUE if, sym, is one of the SYSTEM
             REAL[n] types (not the default base REAL type).
*/

EXTERN bool M2System_IsRealN (unsigned int sym);

/*
   IsComplexN - returns the TRUE if, sym, is one of the SYSTEM
                COMPLEX[n] types (not the default base COMPLEX,
                LONGCOMPLEX or SHORTCOMPLEX types).
*/

EXTERN bool M2System_IsComplexN (unsigned int sym);

/*
   IsGenericSystemType - returns TRUE if, sym, is of type
                         BYTE, WORD or any other length.
*/

EXTERN bool M2System_IsGenericSystemType (unsigned int sym);

/*
   IsSameSizePervasiveType - returns TRUE if a or b are CARDINAL, INTEGER, REAL,
                             LONGREAL, SHORTREAL and the other type is the same
                             size and of the same type.
*/

EXTERN bool M2System_IsSameSizePervasiveType (unsigned int a, unsigned int b);

/*
   IsSameSize - return TRUE if SIZE(a)=SIZE(b)
*/

EXTERN bool M2System_IsSameSize (unsigned int a, unsigned int b);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
