/* do not edit automatically generated by mc from m2decl.  */
/* m2decl.def definition module for m2decl.cc.

Copyright (C) 2011-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_m2decl_H)
#   define _m2decl_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"
#   include "Ggcctypes.h"
#   include "GCDataTypes.h"

#   if defined (_m2decl_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   BuildModuleCtor creates the per module constructor used as part of
   the dynamic linking scaffold.
*/

EXTERN void m2decl_BuildModuleCtor (tree moduleCtor);

/*
   DeclareModuleCtor configures the function to be used as a ctor.
*/

EXTERN tree m2decl_DeclareModuleCtor (tree decl);
EXTERN tree m2decl_DeclareM2linkForcedModuleInitOrder (location_t location, void * RuntimeOverride);
EXTERN tree m2decl_DeclareM2linkStaticInitialization (location_t location, int ScaffoldStatic);
EXTERN tree m2decl_BuildPtrToTypeString (location_t location, void * string, tree type);

/*
    GetBitsPerBitset - returns the number of bits in a BITSET.
*/

EXTERN int m2decl_GetBitsPerBitset (void);

/*
    GetBitsPerInt - returns the number of bits in a INTEGER.
*/

EXTERN int m2decl_GetBitsPerInt (void);

/*
    GetBitsPerUnit - returns the number of bits in a UNIT.
*/

EXTERN int m2decl_GetBitsPerUnit (void);

/*
    GetBitsPerWord - returns the number of bits in a WORD.
*/

EXTERN int m2decl_GetBitsPerWord (void);

/*
    BuildIntegerConstant - return a tree containing the integer value.
*/

EXTERN tree m2decl_BuildIntegerConstant (int value);

/*
    BuildStringConstantType - builds a string constant with a type.
*/

EXTERN tree m2decl_BuildStringConstantType (int length, const char * string, tree type);

/*
    DeclareKnownVariable - declares a variable in scope,
                           funcscope. Note that the global variable,
                           current_function_decl, is altered if
                           isglobal is TRUE.
*/

EXTERN tree m2decl_DeclareKnownVariable (location_t location, const char * name, tree type, bool exported, bool imported, bool istemporary, bool isglobal, tree scope, tree initial);

/*
    DeclareKnownConstant - given a constant, value, of, type, create a constant in the GCC
                           symbol table. Note that the name of the constant is not used
                           as _all_ constants are declared in the global scope. The front end
                           deals with scoping rules - here we declare all constants with no names
                           in the global scope. This allows M2SubExp and constant folding routines
                           the liberty of operating with quadruples which all assume constants can
                           always be referenced.
*/

EXTERN tree m2decl_DeclareKnownConstant (location_t location, tree type, tree value);

/*
    BuildParameterDeclaration - creates and returns one parameter from, name, and, type.
                                It appends this parameter to the internal param_type_list.
                                If name is nul then we assume we are creating a function
                                type declaration and we ignore names.
*/

EXTERN tree m2decl_BuildParameterDeclaration (location_t location, const char * name, tree type, bool isreference);

/*
    BuildStartFunctionDeclaration - initializes global variables ready
                                    for building a function.
*/

EXTERN void m2decl_BuildStartFunctionDeclaration (bool uses_varargs);

/*
    BuildEndFunctionDeclaration - build a function which will return a value of returntype.
                                  The arguments have been created by BuildParameterDeclaration.
*/

EXTERN tree m2decl_BuildEndFunctionDeclaration (location_t location_begin, location_t location_end, const char * name, tree returntype, bool isexternal, bool isnested, bool ispublic, bool isnoreturn);

/*
    RememberVariables -
*/

EXTERN void m2decl_RememberVariables (tree l);

/*
    BuildConstLiteralNumber - returns a GCC TREE built from the string, str.
                              It assumes that, str, represents a legal
                              number in Modula-2. It always returns a
                              positive value.
*/

EXTERN tree m2decl_BuildConstLiteralNumber (location_t location, const char * str, unsigned int base, bool issueError);

/*
    BuildStringConstant - creates a string constant given a, string,
                          and, length.
*/

EXTERN tree m2decl_BuildStringConstant (const char * string, int length);

/*
    BuildCStringConstant - creates a string constant given a, string,
                           and, length.
*/

EXTERN tree m2decl_BuildCStringConstant (const char * string, int length);

/*
    BuildCStringConstant - creates a string constant given a, string,
                           and, length.
*/

EXTERN tree m2decl_GetDeclContext (tree t);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
