/* do not edit automatically generated by mc from M2SymInit.  */
/* M2SymInit.mod records initialization state for variables.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2SymInit_C

#include "GM2SymInit.h"
#   include "GStorage.h"
#   include "GM2Debug.h"
#   include "GM2Printf.h"
#   include "Glibc.h"
#   include "GNameKey.h"
#   include "GM2Base.h"
#   include "GM2Options.h"
#   include "GM2MetaError.h"
#   include "GM2LexBuf.h"
#   include "GDynamicStrings.h"
#   include "GM2Error.h"
#   include "GM2BasicBlock.h"
#   include "GIndexing.h"
#   include "GLists.h"
#   include "GSymbolTable.h"
#   include "GM2Quads.h"
#   include "GM2GCCDeclare.h"

#   define Debugging false
typedef struct M2SymInit_recordDesc_r M2SymInit_recordDesc;

typedef struct M2SymInit__T1_r M2SymInit__T1;

typedef struct M2SymInit__T2_r M2SymInit__T2;

typedef M2SymInit__T2 *M2SymInit_symAlias;

typedef struct M2SymInit__T3_r M2SymInit__T3;

typedef M2SymInit__T3 *M2SymInit_bbEntry;

typedef enum {M2SymInit_scalar, M2SymInit_record} M2SymInit_descType;

typedef M2SymInit__T1 *M2SymInit_InitDesc__opaque;

struct M2SymInit_recordDesc_r {
                                Indexing_Index fieldDesc;
                              };

struct M2SymInit__T2_r {
                         unsigned int keySym;
                         unsigned int alias;
                         M2SymInit_symAlias next;
                       };

struct M2SymInit__T3_r {
                         unsigned int start;
                         unsigned int end;
                         bool first;
                         bool endCall;
                         bool endGoto;
                         bool endCond;
                         bool topOfLoop;
                         unsigned int trashQuad;
                         unsigned int indexBB;
                         unsigned int nextQuad;
                         unsigned int condQuad;
                         unsigned int nextBB;
                         unsigned int condBB;
                         M2SymInit_bbEntry next;
                       };

struct M2SymInit__T1_r {
                         unsigned int sym;
                         unsigned int type;
                         bool initialized;
                         M2SymInit_descType kind;  /* case tag */
                         union {
                                 M2SymInit_recordDesc rec;
                               };
                       };

static Indexing_Index IndirectArray;
static Indexing_Index LArray;
static M2SymInit_symAlias freeList;
static Indexing_Index bbArray;
static M2SymInit_bbEntry bbFreeList;
static Lists_List ignoreList;
static Lists_List errorList;

/*
   PrintSymInit -
*/

extern "C" M2SymInit_InitDesc M2SymInit_InitSymInit (void);

/*
   PrintSymInit -
*/

extern "C" void M2SymInit_KillSymInit (M2SymInit_InitDesc *desc);

/*
   PrintSymInit -
*/

extern "C" void M2SymInit_ConfigSymInit (M2SymInit_InitDesc desc, unsigned int sym);

/*
   PopulateFields -
*/

extern "C" void M2SymInit_SetInitialized (M2SymInit_InitDesc desc);

/*
   PopulateFields -
*/

extern "C" bool M2SymInit_GetInitialized (M2SymInit_InitDesc desc);

/*
   PopulateFields -
*/

extern "C" M2SymInit_InitDesc M2SymInit_GetFieldDesc (M2SymInit_InitDesc desc, unsigned int field);

/*
   PopulateFields -
*/

extern "C" bool M2SymInit_SetFieldInitialized (M2SymInit_InitDesc desc, Lists_List fieldlist);

/*
   SetFieldInitializedNo -
*/

extern "C" bool M2SymInit_GetFieldInitialized (M2SymInit_InitDesc desc, Lists_List fieldlist);

/*
   ScopeBlockVariableAnalysis - checks to see whether a variable is
                                read before it has been initialized.
*/

extern "C" void M2SymInit_ScopeBlockVariableAnalysis (unsigned int Scope, unsigned int Start, unsigned int End);

/*
   PrintSymInit -
*/

extern "C" void M2SymInit_PrintSymInit (M2SymInit_InitDesc desc);

/*
   KillFieldDesc -
*/

static void KillFieldDesc (Indexing_Index *fielddesc);

/*
   PopulateFields -
*/

static void PopulateFields (M2SymInit_InitDesc__opaque desc, unsigned int recsym);

/*
   TrySetInitialized -
*/

static void TrySetInitialized (M2SymInit_InitDesc__opaque desc);

/*
   SetFieldInitializedNo -
*/

static bool SetFieldInitializedNo (M2SymInit_InitDesc__opaque desc, Lists_List fieldlist, unsigned int level);

/*
   SetFieldInitializedNo -
*/

static bool GetFieldInitializedNo (M2SymInit_InitDesc__opaque desc, Lists_List fieldlist, unsigned int level);

/*
   IsGlobalVar -
*/

static bool IsGlobalVar (unsigned int sym);

/*
   RecordFieldContainsVarient -
*/

static bool RecordFieldContainsVarient (unsigned int sym, Lists_List visited);

/*
   RecordContainsVarient -
*/

static bool RecordContainsVarient (unsigned int sym, Lists_List visited);

/*
   VarContainsVarient -
*/

static bool VarContainsVarient (unsigned int sym, Lists_List visited);

/*
   TypeContainsVarient -
*/

static bool TypeContainsVarient (unsigned int sym, Lists_List visited);

/*
   ArrayContainsVarient -
*/

static bool ArrayContainsVarient (unsigned int sym, Lists_List visited);

/*
   PointerContainsVarient -
*/

static bool PointerContainsVarient (unsigned int sym, Lists_List visited);

/*
   doContainsVariant -
*/

static bool doContainsVariant (unsigned int sym, Lists_List visited);

/*
   ContainsVariant - returns TRUE if type sym contains a variant record.
*/

static bool ContainsVariant (unsigned int sym);

/*
   IssueConditional -
*/

static void IssueConditional (unsigned int quad, bool conditional);

/*
   GenerateNoteFlow -
*/

static void GenerateNoteFlow (unsigned int n, bool warning);

/*
   IssueWarning - issue a warning or note at tok location.
*/

static void IssueWarning (unsigned int tok, const char *before_, unsigned int _before_high, const char *after_, unsigned int _after_high, unsigned int sym, bool warning);

/*
   IsUniqueWarning - return TRUE if a warning has not been issued at tok.
                     It remembers tok and subsequent calls will always return FALSE.
*/

static bool IsUniqueWarning (unsigned int tok);

/*
   CheckDeferredRecordAccess -
*/

static void CheckDeferredRecordAccess (unsigned int tok, unsigned int sym, bool canDereference, bool warning, unsigned int i);

/*
   SetVarUninitialized - resets variable init state.
*/

static void SetVarUninitialized (unsigned int sym);

/*
   ComponentFindVar -
*/

static unsigned int ComponentFindVar (unsigned int sym, bool *lvalue, unsigned int tok);

/*
   ComponentCreateFieldList - builds a list of fields accessed by the component var.
                              Each item in the list will be a field of incremental levels
                              though a nested record.  It is not a list of fields
                              at the same level.

                              foo = RECORD
                                       v: RECORD
                                             x, y: CARDINAL ;
                                          END ;
                                       w: CARDINAL ;
                                    END ;

                              { v, x } for example and not { v, w }
*/

static Lists_List ComponentCreateFieldList (unsigned int sym);

/*
   ComponentCreateFieldList - builds a list of fields accessed by the component var.
                              Each item in the list will be a field of incremental levels
                              though a nested record.  It is not a list of fields
                              at the same level.

                              foo = RECORD
                                       v: RECORD
                                             x, y: CARDINAL ;
                                          END ;
                                       w: CARDINAL ;
                                    END ;

                              { v, x } for example and not { v, w }
*/

static void ComponentBuildFieldList (Lists_List lst, unsigned int sym);

/*
   deRefComponent -
*/

static unsigned int deRefComponent (unsigned int component, bool lvalue, unsigned int sym, unsigned int tok);

/*
   SetVarComponentInitialized -
*/

static void SetVarComponentInitialized (unsigned int sym, unsigned int tok);

/*
   GetVarComponentInitialized -
*/

static bool GetVarComponentInitialized (unsigned int sym, unsigned int tok);

/*
   Trace -
*/

static void Trace (const char *message_, unsigned int _message_high, unsigned int sym);

/*
   SetVarInitialized - if the variable has a left mode and can be dereferenced
                       then set the left and right initialization state.
*/

static void SetVarInitialized (unsigned int sym, bool canDereference, unsigned int tok);

/*
   doGetVarInitialized -
*/

static bool doGetVarInitialized (unsigned int sym, unsigned int tok);

/*
   GetVarInitialized -
*/

static bool GetVarInitialized (unsigned int sym, unsigned int tok);

/*
   IsExempt - returns TRUE if sym is a global variable or a parameter or
              a variable with a variant record type.
*/

static bool IsExempt (unsigned int sym);

/*
   CheckBinary -
*/

static void CheckBinary (unsigned int op1tok, unsigned int op1, unsigned int op2tok, unsigned int op2, unsigned int op3tok, unsigned int op3, bool warning, unsigned int i);

/*
   CheckUnary -
*/

static void CheckUnary (unsigned int lhstok, unsigned int lhs, unsigned int rhstok, unsigned int rhs, bool warning, unsigned int i);

/*
   CheckXIndr -
*/

static void CheckXIndr (unsigned int lhstok, unsigned int lhs, unsigned int type, unsigned int rhstok, unsigned int rhs, bool warning, unsigned int i);

/*
   CheckIndrX -
*/

static void CheckIndrX (unsigned int lhstok, unsigned int lhs, unsigned int rhstok, unsigned int rhs, bool warning, unsigned int i);

/*
   CheckRecordField -
*/

static void CheckRecordField (unsigned int op1);

/*
   CheckLastForIterator -
*/

static void CheckLastForIterator (unsigned int op1tok, unsigned int op1, unsigned int op2tok, unsigned int op2, bool warning, unsigned int i);

/*
   CheckBecomes -
*/

static void CheckBecomes (unsigned int destok, unsigned int des, unsigned int exprtok, unsigned int expr, bool warning, unsigned int i);

/*
   CheckComparison -
*/

static void CheckComparison (unsigned int op1tok, unsigned int op1, unsigned int op2tok, unsigned int op2, bool warning, unsigned int i);

/*
   CheckAddr -
*/

static void CheckAddr (unsigned int ptrtok, unsigned int ptr, unsigned int contenttok, unsigned int content);

/*
   DefaultTokPos -
*/

static unsigned int DefaultTokPos (unsigned int preferredPos, unsigned int defaultPos);

/*
   stop -
*/

static void stop (void);

/*
   CheckReadBeforeInitQuad -
*/

static bool CheckReadBeforeInitQuad (unsigned int procSym, unsigned int quad, bool warning, unsigned int i);

/*
   SetParameterVariablesInitialized - sets all shadow variables for parameters as
                                      initialized.
*/

static void SetParameterVariablesInitialized (unsigned int procSym);

/*
   FilterCheckReadBeforeInitQuad -
*/

static bool FilterCheckReadBeforeInitQuad (unsigned int procSym, unsigned int start, bool warning, unsigned int i);

/*
   CheckReadBeforeInitFirstBasicBlock -
*/

static void CheckReadBeforeInitFirstBasicBlock (unsigned int procSym, unsigned int start, unsigned int end, bool warning, unsigned int i);

/*
   bbArrayKill -
*/

static void bbArrayKill (void);

/*
   DumpBBEntry -
*/

static void DumpBBEntry (M2SymInit_bbEntry bbPtr, unsigned int procSym);

/*
   DumpBBArray -
*/

static void DumpBBArray (unsigned int procSym);

/*
   DumpBBSequence -
*/

static void DumpBBSequence (Lists_List lst);

/*
   trashParam -
*/

static void trashParam (unsigned int trashQuad);

/*
   SetVarLRInitialized - this sets up an alias between the parameter
                         value and the pointer for the case:

                         procedure foo (var shadow: PtrToType) ;

                         which allows shadow to be statically analyzed
                         once it is re-assigned.
*/

static void SetVarLRInitialized (unsigned int param);

/*
   TestBBSequence -
*/

static void TestBBSequence (unsigned int procSym, Lists_List lst);

/*
   CreateBBPermultations -
*/

static void CreateBBPermultations (unsigned int procSym, unsigned int i, Lists_List lst);

/*
   GetOp3 -
*/

static unsigned int GetOp3 (unsigned int quad);

/*
   getBBindex - return the basic block index which starts with quad.
*/

static unsigned int getBBindex (unsigned int quad);

/*
   GenerateCFG -
*/

static void GenerateCFG (void);

/*
   NewEntry -
*/

static M2SymInit_bbEntry NewEntry (void);

/*
   IsAllocate - return TRUE is sym is ALLOCATE.
*/

static bool IsAllocate (unsigned int sym);

/*
   IsDeallocate - return TRUE is sym is DEALLOCATE.
*/

static bool IsDeallocate (unsigned int sym);

/*
   DetectTrash -
*/

static void DetectTrash (M2SymInit_bbEntry bbPtr);

/*
   AppendEntry -
*/

static void AppendEntry (M2BasicBlock_BasicBlock bb);

/*
   DumpAlias -
*/

static void DumpAlias (Indexing_Index array, unsigned int aliasIndex);

/*
   doDumpAliases -
*/

static void doDumpAliases (Indexing_Index array);

/*
   DumpAliases -
*/

static void DumpAliases (void);

/*
   newAlias -
*/

static M2SymInit_symAlias newAlias (void);

/*
   initAlias -
*/

static M2SymInit_symAlias initAlias (unsigned int sym);

/*
   killAlias -
*/

static void killAlias (M2SymInit_symAlias sa);

/*
   initBlock -
*/

static void initBlock (void);

/*
   killBlock -
*/

static void killBlock (void);

/*
   killBlock -
*/

static void doKillBlock (Indexing_Index *array);

/*
   addAlias -
*/

static void addAlias (Indexing_Index array, unsigned int sym, unsigned int aliased);

/*
   lookupAlias -
*/

static M2SymInit_symAlias lookupAlias (Indexing_Index array, unsigned int sym);

/*
   doGetAlias -
*/

static unsigned int doGetAlias (Indexing_Index array, unsigned int sym);

/*
   getLAlias - attempts to looks up an alias which is not a temporary variable.
*/

static unsigned int getLAlias (unsigned int sym);

/*
   SetupLAlias -
*/

static void SetupLAlias (unsigned int des, unsigned int exp);

/*
   SetupIndr -
*/

static void SetupIndr (unsigned int ptr, unsigned int content);

/*
   getContent - attempts to return the content pointed to by ptr.
                sym is the original symbol and ptr will be the equivalent lvalue.
*/

static unsigned int getContent (unsigned int ptr, unsigned int sym, unsigned int tok);

/*
   init -
*/

static void init (void);


/*
   KillFieldDesc -
*/

static void KillFieldDesc (Indexing_Index *fielddesc)
{
  unsigned int i;
  unsigned int h;
  M2SymInit_InitDesc__opaque id;

  i = 1;
  h = Indexing_HighIndice ((*fielddesc));
  while (i <= h)
    {
      id = static_cast<M2SymInit_InitDesc__opaque> (Indexing_GetIndice ((*fielddesc), i));
      M2SymInit_KillSymInit (reinterpret_cast<M2SymInit_InitDesc *> (&id));
      i += 1;
    }
  (*fielddesc) = Indexing_KillIndex ((*fielddesc));
}


/*
   PopulateFields -
*/

static void PopulateFields (M2SymInit_InitDesc__opaque desc, unsigned int recsym)
{
  unsigned int field;
  unsigned int i;
  M2SymInit_InitDesc__opaque fdesc;

  M2Debug_Assert (SymbolTable_IsRecord (recsym));
  i = 1;
  do {
    field = SymbolTable_GetNth (recsym, i);
    if (field != SymbolTable_NulSym)
      {
        fdesc = static_cast<M2SymInit_InitDesc__opaque> (M2SymInit_InitSymInit ());
        M2SymInit_ConfigSymInit (static_cast<M2SymInit_InitDesc> (fdesc), field);
        Indexing_IncludeIndiceIntoIndex (desc->rec.fieldDesc, reinterpret_cast <void *> (fdesc));
        i += 1;
      }
  } while (! (field == SymbolTable_NulSym));
}


/*
   TrySetInitialized -
*/

static void TrySetInitialized (M2SymInit_InitDesc__opaque desc)
{
  unsigned int i;
  unsigned int h;
  M2SymInit_InitDesc__opaque fdesc;

  h = Indexing_HighIndice (desc->rec.fieldDesc);
  i = 1;
  while (i <= h)
    {
      fdesc = static_cast<M2SymInit_InitDesc__opaque> (Indexing_GetIndice (desc->rec.fieldDesc, i));
      if (! fdesc->initialized)
        {
          return;
        }
      i += 1;
    }
  desc->initialized = true;
}


/*
   SetFieldInitializedNo -
*/

static bool SetFieldInitializedNo (M2SymInit_InitDesc__opaque desc, Lists_List fieldlist, unsigned int level)
{
  unsigned int nsym;
  M2SymInit_InitDesc__opaque fdesc;

  if (level > (Lists_NoOfItemsInList (fieldlist)))
    {
      return false;
    }
  else
    {
      nsym = static_cast<unsigned int> (Lists_GetItemFromList (fieldlist, level));
      fdesc = static_cast<M2SymInit_InitDesc__opaque> (M2SymInit_GetFieldDesc (static_cast<M2SymInit_InitDesc> (desc), nsym));
      if (fdesc == NULL)
        {
          return false;
        }
      else if (level == (Lists_NoOfItemsInList (fieldlist)))
        {
          /* avoid dangling else.  */
          M2SymInit_SetInitialized (static_cast<M2SymInit_InitDesc> (fdesc));
          TrySetInitialized (desc);
          return desc->initialized;
        }
      else
        {
          /* avoid dangling else.  */
          if (SetFieldInitializedNo (fdesc, fieldlist, level+1))
            {}  /* empty.  */
          TrySetInitialized (desc);
          return desc->initialized;
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetFieldInitializedNo -
*/

static bool GetFieldInitializedNo (M2SymInit_InitDesc__opaque desc, Lists_List fieldlist, unsigned int level)
{
  unsigned int nsym;
  M2SymInit_InitDesc__opaque fdesc;

  if (desc->initialized)
    {
      return true;
    }
  else if (level > (Lists_NoOfItemsInList (fieldlist)))
    {
      /* avoid dangling else.  */
      return false;
    }
  else
    {
      /* avoid dangling else.  */
      nsym = static_cast<unsigned int> (Lists_GetItemFromList (fieldlist, level));
      fdesc = static_cast<M2SymInit_InitDesc__opaque> (M2SymInit_GetFieldDesc (static_cast<M2SymInit_InitDesc> (desc), nsym));
      if (fdesc == NULL)
        {
          /* The pointer variable maybe uninitialized and hence we cannot
            find the record variable.  */
          return false;
        }
      else if (fdesc->initialized)
        {
          /* avoid dangling else.  */
          return true;
        }
      else
        {
          /* avoid dangling else.  */
          return GetFieldInitializedNo (fdesc, fieldlist, level+1);
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsGlobalVar -
*/

static bool IsGlobalVar (unsigned int sym)
{
  return (SymbolTable_IsVar (sym)) && (! (SymbolTable_IsProcedure (SymbolTable_GetVarScope (sym))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   RecordFieldContainsVarient -
*/

static bool RecordFieldContainsVarient (unsigned int sym, Lists_List visited)
{
  M2Debug_Assert (SymbolTable_IsRecordField (sym));
  if (doContainsVariant (SymbolTable_GetSType (sym), visited))
    {
      return true;
    }
  return (SymbolTable_GetVarient (sym)) != SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   RecordContainsVarient -
*/

static bool RecordContainsVarient (unsigned int sym, Lists_List visited)
{
  unsigned int i;
  unsigned int fieldsym;

  M2Debug_Assert (SymbolTable_IsRecord (sym));
  i = 1;
  do {
    fieldsym = SymbolTable_GetNth (sym, i);
    if (fieldsym != SymbolTable_NulSym)
      {
        if (SymbolTable_IsRecordField (fieldsym))
          {
            /* avoid dangling else.  */
            if (RecordFieldContainsVarient (fieldsym, visited))
              {
                return true;
              }
          }
        else if (SymbolTable_IsVarient (fieldsym))
          {
            /* avoid dangling else.  */
            return true;
          }
        i += 1;
      }
  } while (! (fieldsym == SymbolTable_NulSym));
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   VarContainsVarient -
*/

static bool VarContainsVarient (unsigned int sym, Lists_List visited)
{
  M2Debug_Assert (SymbolTable_IsVar (sym));
  return doContainsVariant (SymbolTable_GetSType (sym), visited);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TypeContainsVarient -
*/

static bool TypeContainsVarient (unsigned int sym, Lists_List visited)
{
  M2Debug_Assert (SymbolTable_IsType (sym));
  return doContainsVariant (SymbolTable_GetSType (sym), visited);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ArrayContainsVarient -
*/

static bool ArrayContainsVarient (unsigned int sym, Lists_List visited)
{
  M2Debug_Assert (SymbolTable_IsArray (sym));
  return doContainsVariant (SymbolTable_GetSType (sym), visited);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PointerContainsVarient -
*/

static bool PointerContainsVarient (unsigned int sym, Lists_List visited)
{
  M2Debug_Assert (SymbolTable_IsPointer (sym));
  return doContainsVariant (SymbolTable_GetSType (sym), visited);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doContainsVariant -
*/

static bool doContainsVariant (unsigned int sym, Lists_List visited)
{
  if ((sym != SymbolTable_NulSym) && (! (Lists_IsItemInList (visited, sym))))
    {
      Lists_IncludeItemIntoList (visited, sym);
      if (SymbolTable_IsVar (sym))
        {
          return VarContainsVarient (sym, visited);
        }
      else if (SymbolTable_IsRecord (sym))
        {
          /* avoid dangling else.  */
          return RecordContainsVarient (sym, visited);
        }
      else if (SymbolTable_IsPointer (sym))
        {
          /* avoid dangling else.  */
          return PointerContainsVarient (sym, visited);
        }
      else if (SymbolTable_IsArray (sym))
        {
          /* avoid dangling else.  */
          return ArrayContainsVarient (sym, visited);
        }
      else if (SymbolTable_IsType (sym))
        {
          /* avoid dangling else.  */
          return TypeContainsVarient (sym, visited);
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ContainsVariant - returns TRUE if type sym contains a variant record.
*/

static bool ContainsVariant (unsigned int sym)
{
  Lists_List visited;
  bool result;

  Lists_InitList (&visited);
  result = doContainsVariant (sym, visited);
  Lists_KillList (&visited);
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IssueConditional -
*/

static void IssueConditional (unsigned int quad, bool conditional)
{
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  unsigned int op1tok;
  unsigned int op2tok;
  unsigned int op3tok;
  unsigned int qtok;
  bool constExpr;
  bool overflowChecking;
  DynamicStrings_String s;

  M2Quads_GetQuadOtok (quad, &qtok, &op, &op1, &op2, &op3, &overflowChecking, &constExpr, &op1tok, &op2tok, &op3tok);
  if (IsUniqueWarning (qtok))
    {
      op1tok = DefaultTokPos (op1tok, qtok);
      op2tok = DefaultTokPos (op2tok, qtok);
      op3tok = DefaultTokPos (op3tok, qtok);
      if (! conditional)
        {
          op = M2Quads_Opposite (op);
        }
      s = DynamicStrings_InitString ((const char *) "depending upon the result of {%1Oad} ", 37);
      s = DynamicStrings_ConCat (s, DynamicStrings_Mark (M2Quads_GetM2OperatorDesc (op)));
      s = DynamicStrings_ConCat (s, DynamicStrings_InitString ((const char *) " {%2ad}", 7));
      M2MetaError_MetaErrorStringT2 (qtok, s, op1, op2);
    }
}


/*
   GenerateNoteFlow -
*/

static void GenerateNoteFlow (unsigned int n, bool warning)
{
  unsigned int i;
  M2SymInit_bbEntry ip1Ptr;
  M2SymInit_bbEntry iPtr;

  if (! warning)
    {
      /* Only issue flow messages for non warnings.  */
      i = 1;
      while (i <= n)
        {
          iPtr = static_cast<M2SymInit_bbEntry> (Indexing_GetIndice (bbArray, i));
          if (iPtr->endCond)
            {
              if (i < n)
                {
                  ip1Ptr = static_cast<M2SymInit_bbEntry> (Indexing_GetIndice (bbArray, i+1));
                  IssueConditional (iPtr->end, iPtr->condBB == ip1Ptr->indexBB);
                }
            }
          i += 1;
        }
    }
}


/*
   IssueWarning - issue a warning or note at tok location.
*/

static void IssueWarning (unsigned int tok, const char *before_, unsigned int _before_high, const char *after_, unsigned int _after_high, unsigned int sym, bool warning)
{
  DynamicStrings_String s;
  char before[_before_high+1];
  char after[_after_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (before, before_, _before_high+1);
  memcpy (after, after_, _after_high+1);

  s = DynamicStrings_InitString ((const char *) before, _before_high);
  if (warning)
    {
      s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "{%1Wad}", 7)));
    }
  else
    {
      s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "{%1Oad}", 7)));
    }
  s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) after, _after_high)));
  M2MetaError_MetaErrorStringT1 (tok, s, sym);
}


/*
   IsUniqueWarning - return TRUE if a warning has not been issued at tok.
                     It remembers tok and subsequent calls will always return FALSE.
*/

static bool IsUniqueWarning (unsigned int tok)
{
  if (! (Lists_IsItemInList (errorList, tok)))
    {
      Lists_IncludeItemIntoList (errorList, tok);
      return true;
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckDeferredRecordAccess -
*/

static void CheckDeferredRecordAccess (unsigned int tok, unsigned int sym, bool canDereference, bool warning, unsigned int i)
{
  bool unique;

  if (SymbolTable_IsVar (sym))
    {
      if (Debugging)
        {
          Trace ((const char *) "CheckDeferredRecordAccess %d\\n", 30, sym);
          M2GCCDeclare_PrintSym (sym);
          if (canDereference)
            {
              M2Printf_printf1 ((const char *) "checkReadInit (%d, true)\\n", 26, (const unsigned char *) &sym, (sizeof (sym)-1));
            }
          else
            {
              M2Printf_printf1 ((const char *) "checkReadInit (%d, false)\\n", 27, (const unsigned char *) &sym, (sizeof (sym)-1));
            }
        }
      if (IsExempt (sym))
        {
          Trace ((const char *) "checkReadInit sym is a parameter or not a local variable (%d)", 61, sym);
          /* We assume parameters have been initialized.  */
          SymbolTable_PutVarInitialized (sym, SymbolTable_LeftValue);
          /* SetVarInitialized (sym, TRUE)  */
          SymbolTable_PutVarInitialized (sym, SymbolTable_RightValue);
        }
      else if (SymbolTable_IsUnbounded (SymbolTable_GetSType (sym)))
        {
          /* avoid dangling else.  */
          SetVarInitialized (sym, true, tok);
        }
      else if (SymbolTable_IsComponent (sym))
        {
          /* avoid dangling else.  */
          Trace ((const char *) "checkReadInit IsComponent (%d) is true)", 39, sym);
          if ((! (GetVarComponentInitialized (sym, tok))) && (IsUniqueWarning (tok)))
            {
              GenerateNoteFlow (i, warning);
              IssueWarning (tok, (const char *) "attempting to access ", 21, (const char *) " before it has been initialized", 31, sym, warning);
            }
        }
      else if (((SymbolTable_GetMode (sym)) == SymbolTable_LeftValue) && canDereference)
        {
          /* avoid dangling else.  */
          Trace ((const char *) "checkReadInit GetMode (%d) = LeftValue and canDereference (LeftValue and RightValue VarCheckReadInit)", 101, sym);
          unique = true;
          if (! (SymbolTable_VarCheckReadInit (sym, SymbolTable_LeftValue)))
            {
              unique = IsUniqueWarning (tok);
              if (unique)
                {
                  GenerateNoteFlow (i, warning);
                  IssueWarning (tok, (const char *) "attempting to access the address of ", 36, (const char *) " before it has been initialized", 31, sym, warning);
                }
            }
          if (! (SymbolTable_VarCheckReadInit (sym, SymbolTable_RightValue)))
            {
              if (unique)
                {
                  GenerateNoteFlow (i, warning);
                  IssueWarning (tok, (const char *) "attempting to access ", 21, (const char *) " before it has been initialized", 31, sym, warning);
                }
            }
        }
      else
        {
          /* avoid dangling else.  */
          Trace ((const char *) "checkReadInit call VarCheckReadInit using GetMode (%d)", 54, sym);
          if ((! (SymbolTable_VarCheckReadInit (sym, SymbolTable_GetMode (sym)))) && (IsUniqueWarning (tok)))
            {
              GenerateNoteFlow (i, warning);
              IssueWarning (tok, (const char *) "attempting to access ", 21, (const char *) " before it has been initialized", 31, sym, warning);
            }
        }
    }
}


/*
   SetVarUninitialized - resets variable init state.
*/

static void SetVarUninitialized (unsigned int sym)
{
  if (SymbolTable_IsVar (sym))
    {
      if (! (SymbolTable_IsUnbounded (SymbolTable_GetSType (sym))))
        {
          SymbolTable_VarInitState (sym);
        }
    }
}


/*
   ComponentFindVar -
*/

static unsigned int ComponentFindVar (unsigned int sym, bool *lvalue, unsigned int tok)
{
  unsigned int nsym;
  unsigned int i;

  i = 1;
  do {
    nsym = SymbolTable_GetNth (sym, i);
    (*lvalue) = (SymbolTable_GetMode (nsym)) == SymbolTable_LeftValue;
    nsym = getLAlias (nsym);
    if (nsym == M2Base_Nil)
      {
        M2MetaError_MetaErrorT1 (tok, (const char *) "attempting to dereference {%1Wad} which will be a {%kNIL} pointer", 65, sym);
        return SymbolTable_NulSym;
      }
    else if ((nsym != SymbolTable_NulSym) && (SymbolTable_IsVar (nsym)))
      {
        /* avoid dangling else.  */
        if ((nsym != sym) && (SymbolTable_IsComponent (nsym)))
          {
            return ComponentFindVar (nsym, lvalue, tok);
          }
        else
          {
            return nsym;
          }
      }
    i += 1;
  } while (! (nsym == SymbolTable_NulSym));
  return SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ComponentCreateFieldList - builds a list of fields accessed by the component var.
                              Each item in the list will be a field of incremental levels
                              though a nested record.  It is not a list of fields
                              at the same level.

                              foo = RECORD
                                       v: RECORD
                                             x, y: CARDINAL ;
                                          END ;
                                       w: CARDINAL ;
                                    END ;

                              { v, x } for example and not { v, w }
*/

static Lists_List ComponentCreateFieldList (unsigned int sym)
{
  Lists_List lst;

  Lists_InitList (&lst);
  if ((SymbolTable_IsVar (sym)) && (SymbolTable_IsComponent (sym)))
    {
      ComponentBuildFieldList (lst, sym);
    }
  return lst;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ComponentCreateFieldList - builds a list of fields accessed by the component var.
                              Each item in the list will be a field of incremental levels
                              though a nested record.  It is not a list of fields
                              at the same level.

                              foo = RECORD
                                       v: RECORD
                                             x, y: CARDINAL ;
                                          END ;
                                       w: CARDINAL ;
                                    END ;

                              { v, x } for example and not { v, w }
*/

static void ComponentBuildFieldList (Lists_List lst, unsigned int sym)
{
  unsigned int i;
  unsigned int nsym;

  i = 1;
  do {
    nsym = SymbolTable_GetNth (sym, i);
    if (nsym != SymbolTable_NulSym)
      {
        if (SymbolTable_IsComponent (nsym))
          {
            ComponentBuildFieldList (lst, nsym);
          }
        else if (SymbolTable_IsRecordField (nsym))
          {
            /* avoid dangling else.  */
            Lists_IncludeItemIntoList (lst, nsym);
          }
        i += 1;
      }
  } while (! (nsym == SymbolTable_NulSym));
}


/*
   deRefComponent -
*/

static unsigned int deRefComponent (unsigned int component, bool lvalue, unsigned int sym, unsigned int tok)
{
  if (lvalue)
    {
      return getContent (component, sym, tok);
    }
  else
    {
      return component;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetVarComponentInitialized -
*/

static void SetVarComponentInitialized (unsigned int sym, unsigned int tok)
{
  bool lvalue;
  unsigned int i;
  unsigned int n;
  unsigned int fsym;
  unsigned int vsym;
  Lists_List lst;

  vsym = ComponentFindVar (sym, &lvalue, tok);
  vsym = deRefComponent (vsym, lvalue, sym, tok);
  if (vsym != SymbolTable_NulSym)
    {
      if (Debugging)
        {
          M2Printf_printf0 ((const char *) "*************** vsym is: ", 25);
          M2GCCDeclare_PrintSym (vsym);
        }
      /* Build list accessing the field.  */
      lst = ComponentCreateFieldList (sym);
      if (Debugging)
        {
          M2Printf_printf2 ((const char *) "sym = %d, vsym = %d, fields:", 28, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &vsym, (sizeof (vsym)-1));
        }
      /* Now mark this field in the record variable as initialized.  */
      if (SymbolTable_PutVarFieldInitialized (vsym, SymbolTable_RightValue, lst))
        {
          /* avoid dangling else.  */
          if (Debugging)
            {
              i = 1;
              n = Lists_NoOfItemsInList (lst);
              while (i <= n)
                {
                  fsym = static_cast<unsigned int> (Lists_GetItemFromList (lst, i));
                  M2Printf_printf1 ((const char *) " %d", 3, (const unsigned char *) &fsym, (sizeof (fsym)-1));
                  i += 1;
                }
              M2Printf_printf0 ((const char *) " is initialized\\n", 17);
            }
        }
      else if (Debugging)
        {
          /* avoid dangling else.  */
          M2Printf_printf0 ((const char *) " vsym is not a var\\n", 20);
        }
      Lists_KillList (&lst);
    }
}


/*
   GetVarComponentInitialized -
*/

static bool GetVarComponentInitialized (unsigned int sym, unsigned int tok)
{
  bool lvalue;
  bool init;
  unsigned int component;
  unsigned int vsym;
  Lists_List lst;

  component = ComponentFindVar (sym, &lvalue, tok);
  if ((Lists_IsItemInList (ignoreList, component)) || (IsExempt (component)))
    {
      return true;
    }
  else
    {
      init = false;
      vsym = deRefComponent (component, lvalue, sym, tok);
      if (vsym != SymbolTable_NulSym)
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (IsExempt (vsym))
            {
              init = true;
            }
          else
            {
              /* Create list representing how the field is accessed.  */
              lst = ComponentCreateFieldList (sym);
              /* Now obtain the mark indicating whether this field was initialized.  */
              init = SymbolTable_GetVarFieldInitialized (vsym, SymbolTable_RightValue, lst);
              Lists_KillList (&lst);
            }
        }
      return init;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Trace -
*/

static void Trace (const char *message_, unsigned int _message_high, unsigned int sym)
{
  char message[_message_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);

  if (Debugging)
    {
      M2Printf_printf1 ((const char *) message, _message_high, (const unsigned char *) &sym, (sizeof (sym)-1));
      M2Printf_printf0 ((const char *) "\\n", 2);
    }
}


/*
   SetVarInitialized - if the variable has a left mode and can be dereferenced
                       then set the left and right initialization state.
*/

static void SetVarInitialized (unsigned int sym, bool canDereference, unsigned int tok)
{
  if (SymbolTable_IsVar (sym))
    {
      Lists_RemoveItemFromList (ignoreList, sym);
      if (SymbolTable_IsComponent (sym))
        {
          Trace ((const char *) "SetVarInitialized sym %d is a component and calling SetVarComponentInitialized", 78, sym);
          SetVarComponentInitialized (sym, tok);
        }
      else if (((SymbolTable_GetMode (sym)) == SymbolTable_LeftValue) && canDereference)
        {
          /* avoid dangling else.  */
          Trace ((const char *) "SetVarInitialized sym %d is LeftValue and canDeference and calling PutVarInitialized LeftValue and RightValue", 109, sym);
          SymbolTable_PutVarInitialized (sym, SymbolTable_LeftValue);
          SymbolTable_PutVarInitialized (sym, SymbolTable_RightValue);
        }
      else
        {
          /* avoid dangling else.  */
          Trace ((const char *) "SetVarInitialized sym %d calling PutVarInitialized with its mode", 64, sym);
          SymbolTable_PutVarInitialized (sym, SymbolTable_GetMode (sym));
        }
      if (Debugging)
        {
          M2GCCDeclare_PrintSym (sym);
        }
    }
}


/*
   doGetVarInitialized -
*/

static bool doGetVarInitialized (unsigned int sym, unsigned int tok)
{
  if (SymbolTable_IsVar (sym))
    {
      if (SymbolTable_IsUnbounded (SymbolTable_GetSType (sym)))
        {
          return true;
        }
      else if (SymbolTable_IsComponent (sym))
        {
          /* avoid dangling else.  */
          return GetVarComponentInitialized (sym, tok);
        }
      return SymbolTable_VarCheckReadInit (sym, SymbolTable_GetMode (sym));
    }
  return (SymbolTable_IsConst (sym)) && (SymbolTable_IsConstString (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetVarInitialized -
*/

static bool GetVarInitialized (unsigned int sym, unsigned int tok)
{
  bool init;

  init = doGetVarInitialized (sym, tok);
  if (Debugging)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (init)
        {
          Trace ((const char *) "GetVarInitialized (sym = %d) returning TRUE", 43, sym);
        }
      else
        {
          Trace ((const char *) "GetVarInitialized (sym = %d) returning FALSE", 44, sym);
        }
    }
  return init;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsExempt - returns TRUE if sym is a global variable or a parameter or
              a variable with a variant record type.
*/

static bool IsExempt (unsigned int sym)
{
  /* (IsVarAParam (sym) AND (GetMode (sym) = LeftValue)) OR  */
  return ((sym != SymbolTable_NulSym) && (SymbolTable_IsVar (sym))) && (((((((IsGlobalVar (sym)) || (ContainsVariant (sym))) || (SymbolTable_IsArray (SymbolTable_GetSType (sym)))) || (SymbolTable_IsSet (SymbolTable_GetSType (sym)))) || (SymbolTable_IsUnbounded (SymbolTable_GetSType (sym)))) || (SymbolTable_IsVarArrayRef (sym))) || (Lists_IsItemInList (ignoreList, sym)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckBinary -
*/

static void CheckBinary (unsigned int op1tok, unsigned int op1, unsigned int op2tok, unsigned int op2, unsigned int op3tok, unsigned int op3, bool warning, unsigned int i)
{
  CheckDeferredRecordAccess (op2tok, op2, false, warning, i);
  CheckDeferredRecordAccess (op3tok, op3, false, warning, i);
  SetVarInitialized (op1, false, op1tok);
}


/*
   CheckUnary -
*/

static void CheckUnary (unsigned int lhstok, unsigned int lhs, unsigned int rhstok, unsigned int rhs, bool warning, unsigned int i)
{
  CheckDeferredRecordAccess (rhstok, rhs, false, warning, i);
  SetVarInitialized (lhs, false, lhstok);
}


/*
   CheckXIndr -
*/

static void CheckXIndr (unsigned int lhstok, unsigned int lhs, unsigned int type, unsigned int rhstok, unsigned int rhs, bool warning, unsigned int i)
{
  Lists_List lst;
  unsigned int content;

  CheckDeferredRecordAccess (rhstok, rhs, false, warning, i);
  CheckDeferredRecordAccess (lhstok, lhs, false, warning, i);
  /* Now see if we know what lhs is pointing to and set fields if necessary.  */
  content = getContent (getLAlias (lhs), lhs, lhstok);
  if (((content != SymbolTable_NulSym) && (content != lhs)) && ((SymbolTable_GetSType (content)) == type))
    {
      if (SymbolTable_IsReallyPointer (rhs))
        {
          SetupLAlias (content, rhs);
        }
      if (SymbolTable_IsRecord (type))
        {
          /* Set all fields of content as initialized.  */
          SetVarInitialized (content, false, lhstok);
        }
      else
        {
          /* Set only the field assigned in vsym as initialized.  */
          lst = ComponentCreateFieldList (rhs);
          if (SymbolTable_PutVarFieldInitialized (content, SymbolTable_RightValue, lst))
            {}  /* empty.  */
          Lists_KillList (&lst);
        }
    }
}


/*
   CheckIndrX -
*/

static void CheckIndrX (unsigned int lhstok, unsigned int lhs, unsigned int rhstok, unsigned int rhs, bool warning, unsigned int i)
{
  unsigned int content;

  CheckDeferredRecordAccess (rhstok, rhs, false, warning, i);
  content = getContent (getLAlias (rhs), rhs, rhstok);
  if (content == SymbolTable_NulSym)
    {
      Lists_IncludeItemIntoList (ignoreList, lhs);
    }
  else
    {
      CheckDeferredRecordAccess (rhstok, content, true, warning, i);
      SetVarInitialized (lhs, SymbolTable_VarCheckReadInit (content, SymbolTable_RightValue), lhstok);
      if (SymbolTable_IsReallyPointer (content))
        {
          SetupLAlias (lhs, content);
        }
    }
}


/*
   CheckRecordField -
*/

static void CheckRecordField (unsigned int op1)
{
  SymbolTable_PutVarInitialized (op1, SymbolTable_LeftValue);
}


/*
   CheckLastForIterator -
*/

static void CheckLastForIterator (unsigned int op1tok, unsigned int op1, unsigned int op2tok, unsigned int op2, bool warning, unsigned int i)
{
  SetVarInitialized (op1, false, op1tok);
  M2Debug_Assert (SymbolTable_IsTuple (op2));
  CheckDeferredRecordAccess (op2tok, SymbolTable_GetNth (op2, 1), false, warning, i);
  CheckDeferredRecordAccess (op2tok, SymbolTable_GetNth (op2, 2), false, warning, i);
}


/*
   CheckBecomes -
*/

static void CheckBecomes (unsigned int destok, unsigned int des, unsigned int exprtok, unsigned int expr, bool warning, unsigned int i)
{
  bool lvalue;
  Lists_List lst;
  unsigned int vsym;

  CheckDeferredRecordAccess (exprtok, expr, false, warning, i);
  SetupLAlias (des, expr);
  SetVarInitialized (des, false, destok);
  /* Now see if we know what lhs is pointing to and set fields if necessary.  */
  if (SymbolTable_IsComponent (des))
    {
      vsym = ComponentFindVar (des, &lvalue, destok);
      vsym = deRefComponent (vsym, lvalue, des, destok);
      if (vsym != SymbolTable_NulSym)
        {
          /* Set only the field assigned in vsym as initialized.  */
          lst = ComponentCreateFieldList (des);
          if (SymbolTable_PutVarFieldInitialized (vsym, SymbolTable_RightValue, lst))
            {}  /* empty.  */
          Lists_KillList (&lst);
        }
    }
}


/*
   CheckComparison -
*/

static void CheckComparison (unsigned int op1tok, unsigned int op1, unsigned int op2tok, unsigned int op2, bool warning, unsigned int i)
{
  CheckDeferredRecordAccess (op1tok, op1, false, warning, i);
  CheckDeferredRecordAccess (op2tok, op2, false, warning, i);
}


/*
   CheckAddr -
*/

static void CheckAddr (unsigned int ptrtok, unsigned int ptr, unsigned int contenttok, unsigned int content)
{
  SetVarInitialized (ptr, GetVarInitialized (content, contenttok), ptrtok);
  SetupIndr (ptr, content);
}


/*
   DefaultTokPos -
*/

static unsigned int DefaultTokPos (unsigned int preferredPos, unsigned int defaultPos)
{
  if (preferredPos == M2LexBuf_UnknownTokenNo)
    {
      return defaultPos;
    }
  return preferredPos;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   stop -
*/

static void stop (void)
{
}


/*
   CheckReadBeforeInitQuad -
*/

static bool CheckReadBeforeInitQuad (unsigned int procSym, unsigned int quad, bool warning, unsigned int i)
{
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  unsigned int op1tok;
  unsigned int op2tok;
  unsigned int op3tok;
  unsigned int qtok;
  bool constExpr;
  bool overflowChecking;

  if (quad == 3140)
    {
      stop ();
    }
  if (Debugging)
    {
      M2Printf_printf1 ((const char *) "CheckReadBeforeInitQuad (quad %d)\\n", 35, (const unsigned char *) &quad, (sizeof (quad)-1));
      DumpAliases ();
      SymbolTable_ForeachLocalSymDo (procSym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_PrintSym});
      M2Printf_printf0 ((const char *) "***********************************\\n", 37);
    }
  M2Quads_GetQuadOtok (quad, &qtok, &op, &op1, &op2, &op3, &overflowChecking, &constExpr, &op1tok, &op2tok, &op3tok);
  op1tok = DefaultTokPos (op1tok, qtok);
  op2tok = DefaultTokPos (op2tok, qtok);
  op3tok = DefaultTokPos (op3tok, qtok);
  switch (op)
    {
      case M2Quads_IfInOp:
      case M2Quads_IfNotInOp:
      case M2Quads_IfEquOp:
      case M2Quads_IfNotEquOp:
      case M2Quads_IfLessOp:
      case M2Quads_IfLessEquOp:
      case M2Quads_IfGreOp:
      case M2Quads_IfGreEquOp:
        /* Jumps, calls and branches.  */
        CheckComparison (op1tok, op1, op2tok, op2, warning, i);
        break;

      case M2Quads_LastForIteratorOp:
        CheckLastForIterator (op1tok, op1, op2tok, op2, warning, i);
        M2Debug_Assert (SymbolTable_IsConst (op3));
        break;

      case M2Quads_TryOp:
      case M2Quads_ReturnOp:
      case M2Quads_CallOp:
      case M2Quads_KillLocalVarOp:
      case M2Quads_RetryOp:
      case M2Quads_GotoOp:
        return true;  /* End of basic block.  */
        break;

      case M2Quads_InclOp:
      case M2Quads_ExclOp:
        /* Variable references.  */
        CheckDeferredRecordAccess (op1tok, op1, false, warning, i);
        CheckDeferredRecordAccess (op1tok, op1, true, warning, i);
        CheckDeferredRecordAccess (op3tok, op3, false, warning, i);
        break;

      case M2Quads_NegateOp:
        CheckUnary (op1tok, op1, op3tok, op3, warning, i);
        break;

      case M2Quads_BecomesOp:
        CheckBecomes (op1tok, op1, op3tok, op3, warning, i);
        break;

      case M2Quads_UnboundedOp:
      case M2Quads_FunctValueOp:
      case M2Quads_StandardFunctionOp:
      case M2Quads_HighOp:
      case M2Quads_SizeOp:
        SetVarInitialized (op1, false, op1tok);
        break;

      case M2Quads_AddrOp:
        CheckAddr (op1tok, op1, op3tok, op3);
        break;

      case M2Quads_ReturnValueOp:
        SetVarInitialized (op1, false, op1tok);
        break;

      case M2Quads_NewLocalVarOp:
        SetParameterVariablesInitialized (op3);
        break;

      case M2Quads_ParamOp:
        CheckDeferredRecordAccess (op2tok, op2, false, warning, i);
        CheckDeferredRecordAccess (op3tok, op3, false, warning, i);
        if (((op1 > 0) && (op1 <= (SymbolTable_NoOfParamAny (op2)))) && (SymbolTable_IsVarParamAny (op2, op1)))
          {
            SetVarInitialized (op3, true, op3tok);
          }
        break;

      case M2Quads_ArrayOp:
        CheckDeferredRecordAccess (op3tok, op3, false, warning, i);
        SetVarInitialized (op1, true, op1tok);
        break;

      case M2Quads_RecordFieldOp:
        CheckRecordField (op1);
        break;

      case M2Quads_LogicalShiftOp:
      case M2Quads_LogicalRotateOp:
      case M2Quads_LogicalOrOp:
      case M2Quads_LogicalAndOp:
      case M2Quads_LogicalXorOp:
      case M2Quads_LogicalDiffOp:
      case M2Quads_CoerceOp:
      case M2Quads_ConvertOp:
      case M2Quads_CastOp:
      case M2Quads_AddOp:
      case M2Quads_ArithAddOp:
      case M2Quads_SubOp:
      case M2Quads_MultOp:
      case M2Quads_DivM2Op:
      case M2Quads_ModM2Op:
      case M2Quads_ModFloorOp:
      case M2Quads_DivCeilOp:
      case M2Quads_ModCeilOp:
      case M2Quads_DivFloorOp:
      case M2Quads_ModTruncOp:
      case M2Quads_DivTruncOp:
        CheckBinary (op1tok, op1, op2tok, op2, op3tok, op3, warning, i);
        break;

      case M2Quads_XIndrOp:
        CheckXIndr (op1tok, op1, op2, op3tok, op3, warning, i);
        break;

      case M2Quads_IndrXOp:
        CheckIndrX (op1tok, op1, op3tok, op3, warning, i);
        break;

      case M2Quads_SaveExceptionOp:
        SetVarInitialized (op1, false, op1tok);
        break;

      case M2Quads_RestoreExceptionOp:
        CheckDeferredRecordAccess (op1tok, op1, false, warning, i);
        break;

      case M2Quads_SubrangeLowOp:
      case M2Quads_SubrangeHighOp:
        M2Error_InternalError ((const char *) "quadruples should have been resolved", 36);
        break;

      case M2Quads_ElementSizeOp:
      case M2Quads_BuiltinConstOp:
      case M2Quads_BuiltinTypeInfoOp:
      case M2Quads_StringConvertCnulOp:
      case M2Quads_StringConvertM2nulOp:
      case M2Quads_StringLengthOp:
      case M2Quads_ProcedureScopeOp:
      case M2Quads_InitEndOp:
      case M2Quads_InitStartOp:
      case M2Quads_FinallyStartOp:
      case M2Quads_FinallyEndOp:
      case M2Quads_CatchBeginOp:
      case M2Quads_CatchEndOp:
      case M2Quads_ThrowOp:
      case M2Quads_StartDefFileOp:
      case M2Quads_StartModFileOp:
      case M2Quads_EndFileOp:
      case M2Quads_CodeOnOp:
      case M2Quads_CodeOffOp:
      case M2Quads_ProfileOnOp:
      case M2Quads_ProfileOffOp:
      case M2Quads_OptimizeOnOp:
      case M2Quads_OptimizeOffOp:
      case M2Quads_InlineOp:
      case M2Quads_LineNumberOp:
      case M2Quads_StatementNoteOp:
      case M2Quads_SavePriorityOp:
      case M2Quads_RestorePriorityOp:
      case M2Quads_RangeCheckOp:
      case M2Quads_ModuleScopeOp:
      case M2Quads_ErrorOp:
      case M2Quads_DummyOp:
      case M2Quads_OptParamOp:
      case M2Quads_InitAddressOp:
        break;


      default:
        CaseException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2SymInit.def", 20, 1);
        __builtin_unreachable ();
    }
  return false;  /* Likewise assigning op1 (const) with a type.  */
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetParameterVariablesInitialized - sets all shadow variables for parameters as
                                      initialized.
*/

static void SetParameterVariablesInitialized (unsigned int procSym)
{
  SymbolTable_ForeachLocalSymDo (procSym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) SetVarUninitialized});
  SymbolTable_ForeachParamSymDo (procSym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) SetVarLRInitialized});
}


/*
   FilterCheckReadBeforeInitQuad -
*/

static bool FilterCheckReadBeforeInitQuad (unsigned int procSym, unsigned int start, bool warning, unsigned int i)
{
  M2Quads_QuadOperator Op;
  unsigned int Op1;
  unsigned int Op2;
  unsigned int Op3;

  M2Quads_GetQuad (start, &Op, &Op1, &Op2, &Op3);
  if ((Op != M2Quads_RangeCheckOp) && (Op != M2Quads_StatementNoteOp))
    {
      return CheckReadBeforeInitQuad (procSym, start, warning, i);
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckReadBeforeInitFirstBasicBlock -
*/

static void CheckReadBeforeInitFirstBasicBlock (unsigned int procSym, unsigned int start, unsigned int end, bool warning, unsigned int i)
{
  for (;;)
  {
    if (FilterCheckReadBeforeInitQuad (procSym, start, warning, i))
      {}  /* empty.  */
    if (start == end)
      {
        return;
      }
    else
      {
        start = M2Quads_GetNextQuad (start);
      }
  }
}


/*
   bbArrayKill -
*/

static void bbArrayKill (void)
{
  unsigned int i;
  unsigned int h;
  M2SymInit_bbEntry bbPtr;

  h = Indexing_HighIndice (bbArray);
  i = 1;
  while (i <= h)
    {
      bbPtr = static_cast<M2SymInit_bbEntry> (Indexing_GetIndice (bbArray, i));
      bbPtr->next = bbFreeList;
      bbFreeList = bbPtr;
      i += 1;
    }
  bbArray = Indexing_KillIndex (bbArray);
}


/*
   DumpBBEntry -
*/

static void DumpBBEntry (M2SymInit_bbEntry bbPtr, unsigned int procSym)
{
  M2Printf_printf4 ((const char *) "bb %d: scope %d:  quads: %d .. %d", 33, (const unsigned char *) &bbPtr->indexBB, (sizeof (bbPtr->indexBB)-1), (const unsigned char *) &procSym, (sizeof (procSym)-1), (const unsigned char *) &bbPtr->start, (sizeof (bbPtr->start)-1), (const unsigned char *) &bbPtr->end, (sizeof (bbPtr->end)-1));
  if (bbPtr->first)
    {
      M2Printf_printf0 ((const char *) " first", 6);
    }
  if (bbPtr->endCall)
    {
      M2Printf_printf0 ((const char *) " endcall", 8);
    }
  if (bbPtr->endGoto)
    {
      M2Printf_printf0 ((const char *) " endgoto", 8);
    }
  if (bbPtr->endCond)
    {
      M2Printf_printf0 ((const char *) " endcond", 8);
    }
  if (bbPtr->topOfLoop)
    {
      M2Printf_printf0 ((const char *) " topofloop", 10);
    }
  if (bbPtr->condBB != 0)
    {
      M2Printf_printf1 ((const char *) " cond %d", 8, (const unsigned char *) &bbPtr->condBB, (sizeof (bbPtr->condBB)-1));
    }
  if (bbPtr->nextBB != 0)
    {
      M2Printf_printf1 ((const char *) " next %d", 8, (const unsigned char *) &bbPtr->nextBB, (sizeof (bbPtr->nextBB)-1));
    }
  M2Printf_printf0 ((const char *) "\\n", 2);
}


/*
   DumpBBArray -
*/

static void DumpBBArray (unsigned int procSym)
{
  M2SymInit_bbEntry bbPtr;
  unsigned int i;
  unsigned int n;

  i = 1;
  n = Indexing_HighIndice (bbArray);
  while (i <= n)
    {
      bbPtr = static_cast<M2SymInit_bbEntry> (Indexing_GetIndice (bbArray, i));
      DumpBBEntry (bbPtr, procSym);
      i += 1;
    }
  i = 1;
  while (i <= n)
    {
      bbPtr = static_cast<M2SymInit_bbEntry> (Indexing_GetIndice (bbArray, i));
      M2Printf_printf4 ((const char *) "bb %d: scope %d:  quads: %d .. %d\\n", 35, (const unsigned char *) &bbPtr->indexBB, (sizeof (bbPtr->indexBB)-1), (const unsigned char *) &procSym, (sizeof (procSym)-1), (const unsigned char *) &bbPtr->start, (sizeof (bbPtr->start)-1), (const unsigned char *) &bbPtr->end, (sizeof (bbPtr->end)-1));
      M2Quads_DisplayQuadRange (procSym, bbPtr->start, bbPtr->end);
      i += 1;
    }
}


/*
   DumpBBSequence -
*/

static void DumpBBSequence (Lists_List lst)
{
  unsigned int arrayindex;
  unsigned int listindex;
  unsigned int n;

  n = Lists_NoOfItemsInList (lst);
  listindex = 1;
  M2Printf_printf0 ((const char *) "=============\\n", 15);
  M2Printf_printf0 ((const char *) " checking sequence:", 19);
  while (listindex <= n)
    {
      arrayindex = static_cast<unsigned int> (Lists_GetItemFromList (lst, listindex));
      M2Printf_printf2 ((const char *) " lst[%d] -> %d", 14, (const unsigned char *) &listindex, (sizeof (listindex)-1), (const unsigned char *) &arrayindex, (sizeof (arrayindex)-1));
      listindex += 1;
    }
  M2Printf_printf0 ((const char *) "\\n", 2);
}


/*
   trashParam -
*/

static void trashParam (unsigned int trashQuad)
{
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int proc;
  unsigned int param;
  unsigned int paramValue;
  unsigned int op1tok;
  unsigned int op2tok;
  unsigned int paramtok;
  unsigned int qtok;
  bool constExpr;
  bool overflowChecking;
  unsigned int heapValue;
  unsigned int ptrToHeap;

  if (trashQuad != 0)
    {
      M2Quads_GetQuadOtok (trashQuad, &qtok, &op, &op1, &proc, &param, &overflowChecking, &constExpr, &op1tok, &op2tok, &paramtok);
      heapValue = M2Quads_GetQuadTrash (trashQuad);
      if (Debugging)
        {
          M2Printf_printf1 ((const char *) "heapValue = %d\\n", 16, (const unsigned char *) &heapValue, (sizeof (heapValue)-1));
        }
      if (heapValue != SymbolTable_NulSym)
        {
          SetVarInitialized (param, false, paramtok);
          paramValue = getLAlias (param);
          ptrToHeap = getContent (paramValue, param, paramtok);
          if (ptrToHeap != SymbolTable_NulSym)
            {
              /* avoid gcc warning by using compound statement even if not strictly necessary.  */
              if (IsDeallocate (proc))
                {
                  SetupLAlias (ptrToHeap, M2Base_Nil);
                  SetVarInitialized (ptrToHeap, false, paramtok);
                }
              else
                {
                  SetupIndr (ptrToHeap, heapValue);
                  SetVarInitialized (ptrToHeap, true, paramtok);
                }
            }
        }
    }
  DumpAliases ();
}


/*
   SetVarLRInitialized - this sets up an alias between the parameter
                         value and the pointer for the case:

                         procedure foo (var shadow: PtrToType) ;

                         which allows shadow to be statically analyzed
                         once it is re-assigned.
*/

static void SetVarLRInitialized (unsigned int param)
{
  unsigned int heap;
  unsigned int shadow;

  M2Debug_Assert (SymbolTable_IsParameter (param));
  shadow = SymbolTable_GetParameterShadowVar (param);
  if (shadow != SymbolTable_NulSym)
    {
      Lists_IncludeItemIntoList (ignoreList, shadow);
    }
  heap = SymbolTable_GetParameterHeapVar (param);
  if ((shadow != SymbolTable_NulSym) && (heap != SymbolTable_NulSym))
    {
      SymbolTable_PutVarInitialized (shadow, SymbolTable_GetMode (shadow));
      SymbolTable_PutVarInitialized (heap, SymbolTable_GetMode (heap));
      SetupIndr (shadow, heap);
      Lists_IncludeItemIntoList (ignoreList, heap);
    }
}


/*
   TestBBSequence -
*/

static void TestBBSequence (unsigned int procSym, Lists_List lst)
{
  M2SymInit_bbEntry bbPtr;
  unsigned int bbi;
  unsigned int i;
  unsigned int n;
  bool warning;

  if (Debugging)  /* Should we issue a warning rather than a note?  */
    {
      DumpBBSequence (lst);
    }
  initBlock ();
  SymbolTable_ForeachLocalSymDo (procSym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) SetVarUninitialized});
  SymbolTable_ForeachParamSymDo (procSym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) SetVarLRInitialized});
  n = Lists_NoOfItemsInList (lst);
  i = 1;
  warning = true;
  while (i <= n)
    {
      bbi = static_cast<unsigned int> (Lists_GetItemFromList (lst, i));
      bbPtr = static_cast<M2SymInit_bbEntry> (Indexing_GetIndice (bbArray, bbi));
      CheckReadBeforeInitFirstBasicBlock (procSym, bbPtr->start, bbPtr->end, warning, i);
      if (bbPtr->endCond)
        {
          /* Check to see if we are moving into an conditional block in which case
            we will issue a note.  */
          warning = false;
        }
      else if (bbPtr->endCall && (bbPtr->trashQuad != 0))
        {
          /* avoid dangling else.  */
          trashParam (bbPtr->trashQuad);
        }
      i += 1;
    }
  killBlock ();
}


/*
   CreateBBPermultations -
*/

static void CreateBBPermultations (unsigned int procSym, unsigned int i, Lists_List lst)
{
  Lists_List duplst;
  M2SymInit_bbEntry iPtr;

  if (i == 0)
    {
      TestBBSequence (procSym, lst);
    }
  else
    {
      iPtr = static_cast<M2SymInit_bbEntry> (Indexing_GetIndice (bbArray, i));
      if (iPtr->topOfLoop)
        {
          TestBBSequence (procSym, lst);
        }
      else
        {
          duplst = Lists_DuplicateList (lst);
          Lists_IncludeItemIntoList (duplst, i);
          if (iPtr->endCall && (iPtr->trashQuad == 0))
            {
              TestBBSequence (procSym, duplst);
            }
          else if (iPtr->endGoto)
            {
              /* avoid dangling else.  */
              CreateBBPermultations (procSym, iPtr->nextBB, duplst);
            }
          else if (M2Options_UninitVariableConditionalChecking && iPtr->endCond)
            {
              /* avoid dangling else.  */
              CreateBBPermultations (procSym, iPtr->nextBB, duplst);
              CreateBBPermultations (procSym, iPtr->condBB, duplst);
            }
          else if (iPtr->endCond)
            {
              /* avoid dangling else.  */
              TestBBSequence (procSym, duplst);
            }
          else
            {
              /* avoid dangling else.  */
              /* Fall through.  */
              CreateBBPermultations (procSym, iPtr->nextBB, duplst);
            }
          Lists_KillList (&duplst);
        }
    }
}


/*
   GetOp3 -
*/

static unsigned int GetOp3 (unsigned int quad)
{
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;

  M2Quads_GetQuad (quad, &op, &op1, &op2, &op3);
  return op3;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   getBBindex - return the basic block index which starts with quad.
*/

static unsigned int getBBindex (unsigned int quad)
{
  M2SymInit_bbEntry iPtr;
  unsigned int i;
  unsigned int high;

  i = 1;
  high = Indexing_HighIndice (bbArray);
  while (i <= high)
    {
      iPtr = static_cast<M2SymInit_bbEntry> (Indexing_GetIndice (bbArray, i));
      if (iPtr->start == quad)
        {
          return iPtr->indexBB;
        }
      i += 1;
    }
  return 0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GenerateCFG -
*/

static void GenerateCFG (void)
{
  M2SymInit_bbEntry iPtr;
  unsigned int next;
  unsigned int i;
  unsigned int high;

  i = 1;
  high = Indexing_HighIndice (bbArray);
  while (i <= high)
    {
      iPtr = static_cast<M2SymInit_bbEntry> (Indexing_GetIndice (bbArray, i));
      if ((M2Quads_IsKillLocalVar (iPtr->end)) || (M2Quads_IsReturn (iPtr->end)))
        {}  /* empty.  */
      else
        {
          /* Nothing to do as we have reached the end of this scope.  */
          next = M2Quads_GetNextQuad (iPtr->end);
          iPtr->nextQuad = next;
          iPtr->nextBB = getBBindex (next);
          if (iPtr->endCond)
            {
              iPtr->condQuad = GetOp3 (iPtr->end);
              iPtr->condBB = getBBindex (iPtr->condQuad);
            }
        }
      i += 1;
    }
}


/*
   NewEntry -
*/

static M2SymInit_bbEntry NewEntry (void)
{
  M2SymInit_bbEntry bbPtr;

  if (bbFreeList == NULL)
    {
      Storage_ALLOCATE ((void **) &bbPtr, sizeof (M2SymInit__T3));
    }
  else
    {
      bbPtr = bbFreeList;
      bbFreeList = bbFreeList->next;
    }
  return bbPtr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsAllocate - return TRUE is sym is ALLOCATE.
*/

static bool IsAllocate (unsigned int sym)
{
  return (SymbolTable_IsProcedure (sym)) && ((SymbolTable_GetSymName (sym)) == (NameKey_MakeKey ((const char *) "ALLOCATE", 8)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsDeallocate - return TRUE is sym is DEALLOCATE.
*/

static bool IsDeallocate (unsigned int sym)
{
  return (SymbolTable_IsProcedure (sym)) && ((SymbolTable_GetSymName (sym)) == (NameKey_MakeKey ((const char *) "DEALLOCATE", 10)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DetectTrash -
*/

static void DetectTrash (M2SymInit_bbEntry bbPtr)
{
  unsigned int i;
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;

  if (bbPtr->endCall)
    {
      i = bbPtr->start;
      for (;;)
      {
        M2Quads_GetQuad (i, &op, &op1, &op2, &op3);
        if (((op == M2Quads_ParamOp) && (op1 == 1)) && ((IsAllocate (op2)) || (IsDeallocate (op2))))
          {
            bbPtr->trashQuad = i;
          }
        if (i == bbPtr->end)
          {
            return;
          }
        i = M2Quads_GetNextQuad (i);
      }
    }
}


/*
   AppendEntry -
*/

static void AppendEntry (M2BasicBlock_BasicBlock bb)
{
  M2SymInit_bbEntry bbPtr;
  unsigned int high;

  high = Indexing_HighIndice (bbArray);
  bbPtr = NewEntry ();
  bbPtr->start = M2BasicBlock_GetBasicBlockStart (bb);
  bbPtr->end = M2BasicBlock_GetBasicBlockEnd (bb);
  bbPtr->first = high == 0;
  bbPtr->endCall = M2Quads_IsCall (bbPtr->end);
  bbPtr->endGoto = M2Quads_IsGoto (bbPtr->end);
  bbPtr->endCond = M2Quads_IsConditional (bbPtr->end);
  bbPtr->topOfLoop = M2Quads_IsBackReference (bbPtr->start);
  bbPtr->trashQuad = 0;
  bbPtr->indexBB = high+1;
  bbPtr->nextQuad = 0;
  bbPtr->condQuad = 0;
  bbPtr->nextBB = 0;
  bbPtr->condBB = 0;
  bbPtr->next = NULL;
  DetectTrash (bbPtr);
  Indexing_PutIndice (bbArray, high+1, reinterpret_cast <void *> (bbPtr));
}


/*
   DumpAlias -
*/

static void DumpAlias (Indexing_Index array, unsigned int aliasIndex)
{
  M2SymInit_symAlias sa;

  sa = static_cast<M2SymInit_symAlias> (Indexing_GetIndice (array, aliasIndex));
  M2Printf_printf2 ((const char *) "keySym = %d: alias = %d\\n", 25, (const unsigned char *) &sa->keySym, (sizeof (sa->keySym)-1), (const unsigned char *) &sa->alias, (sizeof (sa->alias)-1));
}


/*
   doDumpAliases -
*/

static void doDumpAliases (Indexing_Index array)
{
  unsigned int i;
  unsigned int n;

  i = 1;
  n = Indexing_HighIndice (array);
  while (i <= n)
    {
      DumpAlias (array, i);
      i += 1;
    }
}


/*
   DumpAliases -
*/

static void DumpAliases (void)
{
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "LArray\\n", 8);
      doDumpAliases (LArray);
      M2Printf_printf0 ((const char *) "IndirectArray\\n", 15);
      doDumpAliases (IndirectArray);
    }
}


/*
   newAlias -
*/

static M2SymInit_symAlias newAlias (void)
{
  M2SymInit_symAlias sa;

  if (freeList == NULL)
    {
      Storage_ALLOCATE ((void **) &sa, sizeof (M2SymInit__T2));
    }
  else
    {
      sa = freeList;
      freeList = freeList->next;
    }
  return sa;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   initAlias -
*/

static M2SymInit_symAlias initAlias (unsigned int sym)
{
  M2SymInit_symAlias sa;

  sa = newAlias ();
  sa->keySym = sym;
  sa->alias = SymbolTable_NulSym;
  sa->next = NULL;
  return sa;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   killAlias -
*/

static void killAlias (M2SymInit_symAlias sa)
{
  sa->next = freeList;
  freeList = sa;
}


/*
   initBlock -
*/

static void initBlock (void)
{
  LArray = Indexing_InitIndex (1);
  IndirectArray = Indexing_InitIndex (1);
  Lists_InitList (&ignoreList);
}


/*
   killBlock -
*/

static void killBlock (void)
{
  doKillBlock (&LArray);
  doKillBlock (&IndirectArray);
  Lists_KillList (&ignoreList);
}


/*
   killBlock -
*/

static void doKillBlock (Indexing_Index *array)
{
  unsigned int i;
  unsigned int n;

  i = 1;
  n = Indexing_HighIndice ((*array));
  while (i <= n)
    {
      killAlias (reinterpret_cast <M2SymInit_symAlias> (Indexing_GetIndice ((*array), i)));
      i += 1;
    }
  (*array) = Indexing_KillIndex ((*array));
}


/*
   addAlias -
*/

static void addAlias (Indexing_Index array, unsigned int sym, unsigned int aliased)
{
  unsigned int i;
  unsigned int n;
  M2SymInit_symAlias sa;

  i = 1;
  n = Indexing_HighIndice (array);
  while (i <= n)
    {
      sa = static_cast<M2SymInit_symAlias> (Indexing_GetIndice (array, i));
      if (sa->keySym == sym)
        {
          sa->alias = aliased;
          return;
        }
      i += 1;
    }
  sa = initAlias (sym);
  Indexing_IncludeIndiceIntoIndex (array, reinterpret_cast <void *> (sa));
  sa->alias = aliased;
}


/*
   lookupAlias -
*/

static M2SymInit_symAlias lookupAlias (Indexing_Index array, unsigned int sym)
{
  unsigned int i;
  unsigned int n;
  M2SymInit_symAlias sa;

  i = 1;
  n = Indexing_HighIndice (array);
  while (i <= n)
    {
      sa = static_cast<M2SymInit_symAlias> (Indexing_GetIndice (array, i));
      if (sa->keySym == sym)
        {
          return sa;
        }
      i += 1;
    }
  return NULL;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doGetAlias -
*/

static unsigned int doGetAlias (Indexing_Index array, unsigned int sym)
{
  M2SymInit_symAlias sa;

  sa = lookupAlias (array, sym);
  if ((sa != NULL) && (sa->alias != SymbolTable_NulSym))
    {
      return sa->alias;
    }
  return SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   getLAlias - attempts to looks up an alias which is not a temporary variable.
*/

static unsigned int getLAlias (unsigned int sym)
{
  unsigned int type;
  unsigned int nsym;

  nsym = sym;
  do {
    sym = nsym;
    type = SymbolTable_GetSType (sym);
    if (((SymbolTable_IsTemporary (sym)) && ((SymbolTable_GetMode (sym)) == SymbolTable_LeftValue)) || ((type != SymbolTable_NulSym) && (SymbolTable_IsReallyPointer (type))))
      {
        nsym = doGetAlias (LArray, sym);
      }
    else
      {
        return sym;
      }
  } while (! (nsym == SymbolTable_NulSym));
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetupLAlias -
*/

static void SetupLAlias (unsigned int des, unsigned int exp)
{
  if ((exp == M2Base_Nil) || ((SymbolTable_IsVar (exp)) && (((SymbolTable_GetMode (des)) == SymbolTable_LeftValue) || (SymbolTable_IsReallyPointer (SymbolTable_GetSType (des))))))
    {
      addAlias (LArray, des, exp);
      DumpAliases ();
    }
}


/*
   SetupIndr -
*/

static void SetupIndr (unsigned int ptr, unsigned int content)
{
  addAlias (IndirectArray, ptr, content);
}


/*
   getContent - attempts to return the content pointed to by ptr.
                sym is the original symbol and ptr will be the equivalent lvalue.
*/

static unsigned int getContent (unsigned int ptr, unsigned int sym, unsigned int tok)
{
  if (ptr == M2Base_Nil)
    {
      M2MetaError_MetaErrorT1 (tok, (const char *) "attempting to dereference {%1Wad} which will be a {%kNIL} pointer", 65, sym);
      return SymbolTable_NulSym;
    }
  else
    {
      return doGetAlias (IndirectArray, ptr);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   init -
*/

static void init (void)
{
  freeList = NULL;
  bbFreeList = NULL;
  Lists_InitList (&errorList);
}


/*
   PrintSymInit -
*/

extern "C" M2SymInit_InitDesc M2SymInit_InitSymInit (void)
{
  M2SymInit_InitDesc__opaque id;

  Storage_ALLOCATE ((void **) &id, sizeof (M2SymInit__T1));
  id->sym = SymbolTable_NulSym;
  id->type = SymbolTable_NulSym;
  id->initialized = true;
  id->kind = M2SymInit_scalar;
  return static_cast<M2SymInit_InitDesc> (id);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PrintSymInit -
*/

extern "C" void M2SymInit_KillSymInit (M2SymInit_InitDesc *desc)
{
  switch (static_cast<M2SymInit_InitDesc__opaque> ((*desc))->kind)
    {
      case M2SymInit_record:
        KillFieldDesc (&static_cast<M2SymInit_InitDesc__opaque> ((*desc))->rec.fieldDesc);
        break;


      default:
        break;
    }
  Storage_DEALLOCATE ((void **) &(*desc), sizeof (M2SymInit__T1));
  (*desc) = static_cast<M2SymInit_InitDesc> (NULL);
}


/*
   PrintSymInit -
*/

extern "C" void M2SymInit_ConfigSymInit (M2SymInit_InitDesc desc, unsigned int sym)
{
  if ((SymbolTable_IsVar (sym)) || (SymbolTable_IsRecordField (sym)))
    {
      static_cast<M2SymInit_InitDesc__opaque> (desc)->sym = sym;
      static_cast<M2SymInit_InitDesc__opaque> (desc)->type = SymbolTable_GetSType (sym);
      static_cast<M2SymInit_InitDesc__opaque> (desc)->initialized = false;
      /* An unknown symbol will have no type.  */
      if (static_cast<M2SymInit_InitDesc__opaque> (desc)->type == SymbolTable_NulSym)
        {
          static_cast<M2SymInit_InitDesc__opaque> (desc)->kind = M2SymInit_scalar;
          static_cast<M2SymInit_InitDesc__opaque> (desc)->initialized = true;  /* For now we don't attempt to handle array types.  */
        }
      else
        {
          if (SymbolTable_IsRecord (static_cast<M2SymInit_InitDesc__opaque> (desc)->type))
            {
              static_cast<M2SymInit_InitDesc__opaque> (desc)->kind = M2SymInit_record;
              static_cast<M2SymInit_InitDesc__opaque> (desc)->rec.fieldDesc = Indexing_InitIndex (1);
              PopulateFields (static_cast<M2SymInit_InitDesc__opaque> (desc), static_cast<M2SymInit_InitDesc__opaque> (desc)->type);
            }
          else
            {
              static_cast<M2SymInit_InitDesc__opaque> (desc)->kind = M2SymInit_scalar;
              if (SymbolTable_IsArray (static_cast<M2SymInit_InitDesc__opaque> (desc)->type))
                {
                  static_cast<M2SymInit_InitDesc__opaque> (desc)->initialized = true;  /* For now we don't attempt to handle array types.  */
                }
            }
        }
    }
}


/*
   PopulateFields -
*/

extern "C" void M2SymInit_SetInitialized (M2SymInit_InitDesc desc)
{
  static_cast<M2SymInit_InitDesc__opaque> (desc)->initialized = true;
}


/*
   PopulateFields -
*/

extern "C" bool M2SymInit_GetInitialized (M2SymInit_InitDesc desc)
{
  if (! static_cast<M2SymInit_InitDesc__opaque> (desc)->initialized)
    {
      if (SymbolTable_IsRecord (static_cast<M2SymInit_InitDesc__opaque> (desc)->type))
        {
          TrySetInitialized (static_cast<M2SymInit_InitDesc__opaque> (desc));
        }
    }
  if (Debugging)
    {
      M2SymInit_PrintSymInit (desc);
    }
  return static_cast<M2SymInit_InitDesc__opaque> (desc)->initialized;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PopulateFields -
*/

extern "C" M2SymInit_InitDesc M2SymInit_GetFieldDesc (M2SymInit_InitDesc desc, unsigned int field)
{
  unsigned int fsym;
  unsigned int i;

  if (SymbolTable_IsRecord (static_cast<M2SymInit_InitDesc__opaque> (desc)->type))
    {
      i = 1;
      do {
        fsym = SymbolTable_GetNth (static_cast<M2SymInit_InitDesc__opaque> (desc)->type, i);
        if (field == fsym)
          {
            return static_cast<M2SymInit_InitDesc> (Indexing_GetIndice (static_cast<M2SymInit_InitDesc__opaque> (desc)->rec.fieldDesc, i));
          }
        i += 1;
      } while (! (fsym == SymbolTable_NulSym));
    }
  return static_cast<M2SymInit_InitDesc> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PopulateFields -
*/

extern "C" bool M2SymInit_SetFieldInitialized (M2SymInit_InitDesc desc, Lists_List fieldlist)
{
  return SetFieldInitializedNo (static_cast<M2SymInit_InitDesc__opaque> (desc), fieldlist, 1);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetFieldInitializedNo -
*/

extern "C" bool M2SymInit_GetFieldInitialized (M2SymInit_InitDesc desc, Lists_List fieldlist)
{
  return GetFieldInitializedNo (static_cast<M2SymInit_InitDesc__opaque> (desc), fieldlist, 1);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ScopeBlockVariableAnalysis - checks to see whether a variable is
                                read before it has been initialized.
*/

extern "C" void M2SymInit_ScopeBlockVariableAnalysis (unsigned int Scope, unsigned int Start, unsigned int End)
{
  M2BasicBlock_BasicBlock bb;
  Lists_List lst;

  if (M2Options_UninitVariableChecking)
    {
      bbArray = Indexing_InitIndex (1);
      bb = M2BasicBlock_InitBasicBlocksFromRange (Scope, Start, End);
      M2BasicBlock_ForeachBasicBlockDo (bb, (M2BasicBlock_BasicBlockProc) {(M2BasicBlock_BasicBlockProc_t) AppendEntry});
      M2BasicBlock_KillBasicBlocks (&bb);
      GenerateCFG ();
      if (Scope != SymbolTable_NulSym)
        {
          Lists_InitList (&lst);
          if (Debugging)
            {
              DumpBBArray (Scope);
              if (M2Options_UninitVariableConditionalChecking)
                {
                  M2Printf_printf0 ((const char *) "UninitVariableConditionalChecking is TRUE\\n", 43);
                }
            }
          CreateBBPermultations (Scope, 1, lst);
          Lists_KillList (&lst);
        }
      bbArrayKill ();
    }
}


/*
   PrintSymInit -
*/

extern "C" void M2SymInit_PrintSymInit (M2SymInit_InitDesc desc)
{
  unsigned int i;
  unsigned int n;

  libc_printf ((const char *) "sym %d: type %d ", 16, static_cast<M2SymInit_InitDesc__opaque> (desc)->sym, static_cast<M2SymInit_InitDesc__opaque> (desc)->type);
  if (static_cast<M2SymInit_InitDesc__opaque> (desc)->kind == M2SymInit_scalar)
    {
      libc_printf ((const char *) "scalar", 6);
    }
  else
    {
      libc_printf ((const char *) "record", 6);
    }
  if (! static_cast<M2SymInit_InitDesc__opaque> (desc)->initialized)
    {
      libc_printf ((const char *) " not", 4);
    }
  libc_printf ((const char *) " initialized\\n", 14);
  if ((static_cast<M2SymInit_InitDesc__opaque> (desc)->type != SymbolTable_NulSym) && (SymbolTable_IsRecord (static_cast<M2SymInit_InitDesc__opaque> (desc)->type)))
    {
      i = 1;
      n = Indexing_HighIndice (static_cast<M2SymInit_InitDesc__opaque> (desc)->rec.fieldDesc);
      while (i <= n)
        {
          M2SymInit_PrintSymInit (static_cast<M2SymInit_InitDesc> (Indexing_GetIndice (static_cast<M2SymInit_InitDesc__opaque> (desc)->rec.fieldDesc, i)));
          i += 1;
        }
    }
}

extern "C" void _M2_M2SymInit_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  init ();
}

extern "C" void _M2_M2SymInit_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
