/* do not edit automatically generated by mc from M2CaseList.  */
/* M2CaseList.mod implement ISO case label lists.

Copyright (C) 2009-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2CaseList_C

#include "GM2CaseList.h"
#   include "GM2Debug.h"
#   include "GM2GCCDeclare.h"
#   include "GM2MetaError.h"
#   include "GM2Error.h"
#   include "GM2Range.h"
#   include "GM2ALU.h"
#   include "GIndexing.h"
#   include "GLists.h"
#   include "GNameKey.h"
#   include "GSymbolConversion.h"
#   include "GDynamicStrings.h"
#   include "Ggcctypes.h"
#   include "Gm2block.h"
#   include "Gm2type.h"
#   include "Gm2expr.h"
#   include "GStorage.h"
#   include "GM2Base.h"
#   include "GM2LexBuf.h"
#   include "GNumberIO.h"
#   include "GSymbolTable.h"

typedef struct M2CaseList__T1_r M2CaseList__T1;

typedef M2CaseList__T1 *M2CaseList_RangePair;

typedef struct M2CaseList__T2_r M2CaseList__T2;

typedef M2CaseList__T2 *M2CaseList_ConflictingPair;

typedef struct M2CaseList__T3_r M2CaseList__T3;

typedef M2CaseList__T3 *M2CaseList_CaseList;

typedef struct M2CaseList__T4_r M2CaseList__T4;

typedef M2CaseList__T4 *M2CaseList_CaseDescriptor;

typedef struct M2CaseList__T5_r M2CaseList__T5;

typedef M2CaseList__T5 *M2CaseList_SetRange;

struct M2CaseList__T1_r {
                          unsigned int low;
                          unsigned int high;
                          unsigned int tokenno;
                        };

struct M2CaseList__T2_r {
                          M2CaseList_RangePair a;
                          M2CaseList_RangePair b;
                        };

struct M2CaseList__T3_r {
                          unsigned int maxRangeId;
                          Indexing_Index rangeArray;
                          M2CaseList_RangePair currentRange;
                          unsigned int varientField;
                        };

struct M2CaseList__T4_r {
                          bool resolved;
                          bool elseClause;
                          unsigned int elseField;
                          unsigned int record;
                          unsigned int varient;
                          unsigned int expression;
                          unsigned int maxCaseId;
                          Indexing_Index caseListArray;
                          M2CaseList_CaseList currentCase;
                          M2CaseList_CaseDescriptor next;
                        };

struct M2CaseList__T5_r {
                          tree low;
                          tree high;
                          M2CaseList_SetRange next;
                        };

static M2CaseList_CaseDescriptor caseStack;
static unsigned int caseId;
static Indexing_Index caseArray;
static Indexing_Index conflictArray;
static M2CaseList_SetRange FreeRangeList;
static DynamicStrings_String errorString;

/*
   PushCase - create a case entity and push it to an internal stack.
              rec is NulSym if this is a CASE statement.
              If rec is a record then it indicates a possible
              varients reside in the record to check.
              Both rec and va might be NulSym and then the expr
              will contain the selector expression to a case statement.
              Return the case id.
*/

extern "C" unsigned int M2CaseList_PushCase (unsigned int rec, unsigned int va, unsigned int expr);

/*
   PopCase - pop the top element of the case entity from the internal
             stack.
*/

extern "C" void M2CaseList_PopCase (void);

/*
   ElseCase - indicates that this case varient does have an else clause.
*/

extern "C" void M2CaseList_ElseCase (unsigned int f);

/*
   BeginCaseList - create a new label list.
*/

extern "C" void M2CaseList_BeginCaseList (unsigned int v);

/*
   EndCaseList - terminate the current label list.
*/

extern "C" void M2CaseList_EndCaseList (void);

/*
   AddRange - add a range to the current label list.
*/

extern "C" void M2CaseList_AddRange (unsigned int r1, unsigned int r2, unsigned int tok);

/*
   CaseBoundsResolved - returns TRUE if all constants in the case list, c,
                        are known to GCC.
*/

extern "C" bool M2CaseList_CaseBoundsResolved (unsigned int tokenno, unsigned int c);

/*
   TypeCaseBounds - returns true if all bounds in case list, c, are
                    compatible with the tagged type.
*/

extern "C" bool M2CaseList_TypeCaseBounds (unsigned int c);

/*
   OverlappingCaseBounds - returns TRUE if there were any overlapping bounds
                           in the case list, c.  It will generate an error
                           messages for each overlapping bound found.
*/

extern "C" bool M2CaseList_OverlappingCaseBounds (unsigned int c);

/*
   MissingCaseBounds - returns true if there were any missing bounds
                       in the varient record case list, c.  It will
                       generate an error message for each missing
                       bounds found.
*/

extern "C" bool M2CaseList_MissingCaseBounds (unsigned int tokenno, unsigned int c);

/*
   MissingCaseStatementBounds - returns true if the case statement has a missing
                                clause.  It will also generate error messages.
*/

extern "C" bool M2CaseList_MissingCaseStatementBounds (unsigned int tokenno, unsigned int c);

/*
   WriteCase - dump out the case list (internal debugging).
*/

extern "C" void M2CaseList_WriteCase (unsigned int c);

/*
   GetVariantTagType - returns the type associated with, variant.
*/

static unsigned int GetVariantTagType (unsigned int variant);

/*
   CheckCaseBoundsResolved - return TRUE if all constants in the case list c are known to GCC.
*/

static bool CheckCaseBoundsResolved (unsigned int tokenno, unsigned int c);

/*
   ConvertNulStr2NulChar -
*/

static void ConvertNulStr2NulChar (unsigned int tokenno, unsigned int c);

/*
   NulStr2NulChar - if sym is a const string of length 0 then return
                    a nul char instead otherwise return sym.
*/

static unsigned int NulStr2NulChar (unsigned int tok, unsigned int sym);

/*
   IsSame - return TRUE if r, s, are in, e.
*/

static bool IsSame (M2CaseList_ConflictingPair e, M2CaseList_RangePair r, M2CaseList_RangePair s);

/*
   SeenBefore -
*/

static bool SeenBefore (M2CaseList_RangePair r, M2CaseList_RangePair s);

/*
   Overlaps -
*/

static bool Overlaps (M2CaseList_RangePair r, M2CaseList_RangePair s);

/*
   GetCaseExpression - return the type from the expression.
*/

static unsigned int GetCaseExpression (M2CaseList_CaseDescriptor p);

/*
   OverlappingCaseBound - returns TRUE if, r, overlaps any case bound in the
                          case statement, c.
*/

static bool OverlappingCaseBound (M2CaseList_RangePair r, unsigned int c);

/*
   NewRanges - return a new range from the freelist or heap.
*/

static M2CaseList_SetRange NewRanges (void);

/*
   NewSet - returns a new set based on type with the low and high fields assigned
            to the min and max values for the type.
*/

static M2CaseList_SetRange NewSet (unsigned int type);

/*
   DisposeRanges - place set and its list onto the free list.
*/

static M2CaseList_SetRange DisposeRanges (M2CaseList_SetRange set);

/*
   RemoveRange - removes the range descriptor h from set and return the
                 possibly new head of set.
*/

static M2CaseList_SetRange RemoveRange (M2CaseList_SetRange set, M2CaseList_SetRange h);

/*
   SubBitRange - subtracts bits, lo..hi, from, set.
*/

static M2CaseList_SetRange SubBitRange (M2CaseList_SetRange set, tree lo, tree hi, unsigned int tokenno);

/*
   CheckLowHigh - checks to see the low value <= high value and issues an error
                  if this is not true.
*/

static void CheckLowHigh (M2CaseList_RangePair rp);

/*
   ExcludeCaseRanges - excludes all case ranges found in, p, from, set
*/

static M2CaseList_SetRange ExcludeCaseRanges (M2CaseList_SetRange set, M2CaseList_CaseDescriptor cd);

/*
   IncludeElement - only include enumeration field into errorString if it lies between low..high.
*/

static void IncludeElement (Lists_List enumList, unsigned int field, tree low, tree high);

/*
   IncludeElements - only include enumeration field values low..high in errorString.
*/

static void IncludeElements (unsigned int type, Lists_List enumList, tree low, tree high);

/*
   ErrorRangeEnum - include enumeration fields Low to High in errorString.
*/

static void ErrorRangeEnum (unsigned int type, M2CaseList_SetRange set, Lists_List enumList);

/*
   ErrorRanges - return a list of all enumeration fields not present in the case statement.
                 The return value will be nil if type is not an enumeration type.
*/

static Lists_List ErrorRanges (unsigned int type, M2CaseList_SetRange set);

/*
   appendString - appends str to errorString.
*/

static void appendString (DynamicStrings_String str);

/*
   appendEnum - appends enum to errorString.
*/

static void appendEnum (unsigned int enum_);

/*
   appendStr - appends str to errorString.
*/

static void appendStr (const char *str_, unsigned int _str_high);

/*
   EnumerateErrors - populate errorString with the contents of enumList.
*/

static void EnumerateErrors (Lists_List enumList);

/*
   NoOfSetElements - return the number of set elements.
*/

static tree NoOfSetElements (M2CaseList_SetRange set);

/*
   isPrintableChar - a cautious isprint.
*/

static bool isPrintableChar (tree value);

/*
   appendTree - append tree value to the errorString.  It attempts to pretty print
                CHAR constants and will fall back to CHR (x) if necessary.
*/

static void appendTree (tree value, unsigned int type);

/*
   SubrangeErrors - create an errorString containing all set ranges.
*/

static void SubrangeErrors (unsigned int subrangetype, M2CaseList_SetRange set);

/*
   EmitMissingRangeErrors - emits a singular/plural error message for an enumeration type.
*/

static void EmitMissingRangeErrors (unsigned int tokenno, unsigned int type, M2CaseList_SetRange set);

/*
   checkTypes - checks to see that, constant, and, type, are compatible.
*/

static bool checkTypes (unsigned int constant, unsigned int type);

/*
   inRange - returns true if, min <= i <= max.
*/

static bool inRange (unsigned int i, unsigned int min, unsigned int max);


/*
   GetVariantTagType - returns the type associated with, variant.
*/

static unsigned int GetVariantTagType (unsigned int variant)
{
  unsigned int tag;

  tag = SymbolTable_GetVarientTag (variant);
  if ((SymbolTable_IsFieldVarient (tag)) || (SymbolTable_IsRecordField (tag)))
    {
      return SymbolTable_GetType (tag);
    }
  else
    {
      return tag;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckCaseBoundsResolved - return TRUE if all constants in the case list c are known to GCC.
*/

static bool CheckCaseBoundsResolved (unsigned int tokenno, unsigned int c)
{
  M2CaseList_CaseDescriptor p;
  M2CaseList_CaseList q;
  M2CaseList_RangePair r;
  unsigned int min;
  unsigned int max;
  unsigned int type;
  unsigned int i;
  unsigned int j;

  p = static_cast<M2CaseList_CaseDescriptor> (Indexing_GetIndice (caseArray, c));
  if (p->varient != SymbolTable_NulSym)
    {
      /* not a CASE statement, but a varient record containing without an ELSE clause  */
      type = GetVariantTagType (p->varient);
      p->resolved = true;
      if (! (SymbolConversion_GccKnowsAbout (type)))
        {
          /* do we need to add, type, to the list of types required to be resolved?  */
          p->resolved = false;
        }
      min = M2GCCDeclare_GetTypeMin (type);
      if (! (SymbolConversion_GccKnowsAbout (min)))
        {
          M2GCCDeclare_TryDeclareConstant (tokenno, min);
          p->resolved = false;
        }
      max = M2GCCDeclare_GetTypeMax (type);
      if (! (SymbolConversion_GccKnowsAbout (max)))
        {
          M2GCCDeclare_TryDeclareConstant (tokenno, max);
          p->resolved = false;
        }
      if (! p->resolved)
        {
          return false;
        }
    }
  i = 1;
  while (i <= p->maxCaseId)
    {
      q = static_cast<M2CaseList_CaseList> (Indexing_GetIndice (p->caseListArray, i));
      j = 1;
      while (j <= q->maxRangeId)
        {
          r = static_cast<M2CaseList_RangePair> (Indexing_GetIndice (q->rangeArray, j));
          if (r->low != SymbolTable_NulSym)
            {
              /* avoid gcc warning by using compound statement even if not strictly necessary.  */
              if (SymbolTable_IsConst (r->low))
                {
                  /* avoid dangling else.  */
                  M2GCCDeclare_TryDeclareConstant (tokenno, r->low);
                  if (! (SymbolConversion_GccKnowsAbout (r->low)))
                    {
                      return false;
                    }
                }
              else
                {
                  if (r->high == SymbolTable_NulSym)
                    {
                      M2MetaError_MetaError1 ((const char *) "the CASE statement variant must be defined by a constant {%1Da:is a {%1d}}", 74, r->low);
                    }
                  else
                    {
                      M2MetaError_MetaError1 ((const char *) "the CASE statement variant low value in a range must be defined by a constant {%1Da:is a {%1d}}", 95, r->low);
                    }
                }
            }
          if (r->high != SymbolTable_NulSym)
            {
              /* avoid gcc warning by using compound statement even if not strictly necessary.  */
              if (SymbolTable_IsConst (r->high))
                {
                  /* avoid dangling else.  */
                  M2GCCDeclare_TryDeclareConstant (tokenno, r->high);
                  if (! (SymbolConversion_GccKnowsAbout (r->high)))
                    {
                      return false;
                    }
                }
              else
                {
                  M2MetaError_MetaError1 ((const char *) "the CASE statement variant high value in a range must be defined by a constant {%1Da:is a {%1d}}", 96, r->high);
                }
            }
          j += 1;
        }
      i += 1;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConvertNulStr2NulChar -
*/

static void ConvertNulStr2NulChar (unsigned int tokenno, unsigned int c)
{
  M2CaseList_CaseDescriptor p;
  M2CaseList_CaseList q;
  M2CaseList_RangePair r;
  unsigned int i;
  unsigned int j;

  p = static_cast<M2CaseList_CaseDescriptor> (Indexing_GetIndice (caseArray, c));
  i = 1;
  while (i <= p->maxCaseId)
    {
      q = static_cast<M2CaseList_CaseList> (Indexing_GetIndice (p->caseListArray, i));
      j = 1;
      while (j <= q->maxRangeId)
        {
          r = static_cast<M2CaseList_RangePair> (Indexing_GetIndice (q->rangeArray, j));
          r->low = NulStr2NulChar (tokenno, r->low);
          r->high = NulStr2NulChar (tokenno, r->high);
          j += 1;
        }
      i += 1;
    }
}


/*
   NulStr2NulChar - if sym is a const string of length 0 then return
                    a nul char instead otherwise return sym.
*/

static unsigned int NulStr2NulChar (unsigned int tok, unsigned int sym)
{
  if (sym != SymbolTable_NulSym)
    {
      if (((SymbolTable_IsConst (sym)) && (SymbolTable_IsConstString (sym))) && (SymbolConversion_GccKnowsAbout (sym)))
        {
          if ((SymbolTable_GetStringLength (tok, sym)) == 0)
            {
              sym = SymbolTable_MakeConstVar (tok, NameKey_NulName);
              SymbolTable_PutConst (sym, M2Base_Char);
              M2ALU_PushCard (0);
              SymbolTable_PopValue (sym);
              M2GCCDeclare_TryDeclareConstant (tok, sym);
              M2Debug_Assert (SymbolConversion_GccKnowsAbout (sym));
            }
        }
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSame - return TRUE if r, s, are in, e.
*/

static bool IsSame (M2CaseList_ConflictingPair e, M2CaseList_RangePair r, M2CaseList_RangePair s)
{
  return ((e->a == r) && (e->b == s)) || ((e->a == s) && (e->b == r));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SeenBefore -
*/

static bool SeenBefore (M2CaseList_RangePair r, M2CaseList_RangePair s)
{
  unsigned int i;
  unsigned int h;
  M2CaseList_ConflictingPair e;

  h = Indexing_HighIndice (conflictArray);
  i = 1;
  while (i <= h)
    {
      e = static_cast<M2CaseList_ConflictingPair> (Indexing_GetIndice (conflictArray, i));
      if (IsSame (e, r, s))
        {
          return true;
        }
      i += 1;
    }
  Storage_ALLOCATE ((void **) &e, sizeof (M2CaseList__T2));
  e->a = r;
  e->b = s;
  Indexing_PutIndice (conflictArray, h+1, reinterpret_cast <void *> (e));
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Overlaps -
*/

static bool Overlaps (M2CaseList_RangePair r, M2CaseList_RangePair s)
{
  unsigned int a;
  unsigned int b;
  unsigned int c;
  unsigned int d;

  a = r->low;
  c = s->low;
  if (r->high == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      b = a;
      if (s->high == SymbolTable_NulSym)
        {
          /* avoid dangling else.  */
          d = c;
          if (M2Range_OverlapsRange (SymbolConversion_Mod2Gcc (a), SymbolConversion_Mod2Gcc (b), SymbolConversion_Mod2Gcc (c), SymbolConversion_Mod2Gcc (d)))
            {
              if (! (SeenBefore (r, s)))
                {
                  M2MetaError_MetaErrorT2 (r->tokenno, (const char *) "case label {%1ad} is a duplicate with {%2ad}", 44, a, c);
                  M2MetaError_MetaErrorT2 (s->tokenno, (const char *) "case label {%1ad} is a duplicate with {%2ad}", 44, c, a);
                }
              return true;
            }
        }
      else
        {
          d = s->high;
          if (M2Range_OverlapsRange (SymbolConversion_Mod2Gcc (a), SymbolConversion_Mod2Gcc (b), SymbolConversion_Mod2Gcc (c), SymbolConversion_Mod2Gcc (d)))
            {
              if (! (SeenBefore (r, s)))
                {
                  M2MetaError_MetaErrorT3 (r->tokenno, (const char *) "case label {%1ad} is a duplicate in the range {%2ad}..{%3ad}", 60, a, c, d);
                  M2MetaError_MetaErrorT3 (s->tokenno, (const char *) "case range {%2ad}..{%3ad} is a duplicate of case label {%1ad}", 61, c, d, a);
                }
              return true;
            }
        }
    }
  else
    {
      b = r->high;
      if (s->high == SymbolTable_NulSym)
        {
          /* avoid dangling else.  */
          d = c;
          if (M2Range_OverlapsRange (SymbolConversion_Mod2Gcc (a), SymbolConversion_Mod2Gcc (b), SymbolConversion_Mod2Gcc (c), SymbolConversion_Mod2Gcc (d)))
            {
              if (! (SeenBefore (r, s)))
                {
                  M2MetaError_MetaErrorT3 (r->tokenno, (const char *) "case range {%1ad}..{%2ad} is a duplicate with case label {%3ad}", 63, a, b, c);
                  M2MetaError_MetaErrorT3 (s->tokenno, (const char *) "case label {%1ad} is a duplicate with case range %{2ad}..{%3ad}", 63, c, a, b);
                }
              return true;
            }
        }
      else
        {
          d = s->high;
          if (M2Range_OverlapsRange (SymbolConversion_Mod2Gcc (a), SymbolConversion_Mod2Gcc (b), SymbolConversion_Mod2Gcc (c), SymbolConversion_Mod2Gcc (d)))
            {
              if (! (SeenBefore (r, s)))
                {
                  M2MetaError_MetaErrorT4 (r->tokenno, (const char *) "case range {%1ad}..{%2ad} overlaps case range {%3ad}..{%4ad}", 60, a, b, c, d);
                  M2MetaError_MetaErrorT4 (s->tokenno, (const char *) "case range {%1ad}..{%2ad} overlaps case range {%3ad}..{%4ad}", 60, c, d, a, b);
                }
              return true;
            }
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetCaseExpression - return the type from the expression.
*/

static unsigned int GetCaseExpression (M2CaseList_CaseDescriptor p)
{
  unsigned int type;

  if (p->expression == SymbolTable_NulSym)
    {
      type = SymbolTable_NulSym;
    }
  else
    {
      type = SymbolTable_SkipType (SymbolTable_GetType (p->expression));
    }
  return type;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OverlappingCaseBound - returns TRUE if, r, overlaps any case bound in the
                          case statement, c.
*/

static bool OverlappingCaseBound (M2CaseList_RangePair r, unsigned int c)
{
  M2CaseList_CaseDescriptor p;
  M2CaseList_CaseList q;
  M2CaseList_RangePair s;
  unsigned int i;
  unsigned int j;
  bool overlap;

  p = static_cast<M2CaseList_CaseDescriptor> (Indexing_GetIndice (caseArray, c));
  overlap = false;
  i = 1;
  while (i <= p->maxCaseId)
    {
      q = static_cast<M2CaseList_CaseList> (Indexing_GetIndice (p->caseListArray, i));
      j = 1;
      while (j <= q->maxRangeId)
        {
          s = static_cast<M2CaseList_RangePair> (Indexing_GetIndice (q->rangeArray, j));
          if ((s != r) && (Overlaps (r, s)))
            {
              overlap = true;
            }
          j += 1;
        }
      i += 1;
    }
  return overlap;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NewRanges - return a new range from the freelist or heap.
*/

static M2CaseList_SetRange NewRanges (void)
{
  M2CaseList_SetRange s;

  if (FreeRangeList == NULL)
    {
      Storage_ALLOCATE ((void **) &s, sizeof (M2CaseList__T5));
    }
  else
    {
      s = FreeRangeList;
      FreeRangeList = FreeRangeList->next;
    }
  s->next = NULL;
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NewSet - returns a new set based on type with the low and high fields assigned
            to the min and max values for the type.
*/

static M2CaseList_SetRange NewSet (unsigned int type)
{
  M2CaseList_SetRange s;

  s = NewRanges ();
  s->low = SymbolConversion_Mod2Gcc (M2GCCDeclare_GetTypeMin (type));
  s->high = SymbolConversion_Mod2Gcc (M2GCCDeclare_GetTypeMax (type));
  s->next = NULL;
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DisposeRanges - place set and its list onto the free list.
*/

static M2CaseList_SetRange DisposeRanges (M2CaseList_SetRange set)
{
  M2CaseList_SetRange t;

  if (set != NULL)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (FreeRangeList == NULL)
        {
          FreeRangeList = set;
        }
      else
        {
          t = set;
          while (t->next != NULL)
            {
              t = t->next;
            }
          t->next = FreeRangeList;
          FreeRangeList = set;
        }
    }
  return NULL;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   RemoveRange - removes the range descriptor h from set and return the
                 possibly new head of set.
*/

static M2CaseList_SetRange RemoveRange (M2CaseList_SetRange set, M2CaseList_SetRange h)
{
  M2CaseList_SetRange i;

  if (h == set)
    {
      set = set->next;
      h->next = NULL;
      h = DisposeRanges (h);
    }
  else
    {
      i = set;
      while (i->next != h)
        {
          i = i->next;
        }
      i->next = h->next;
      i = h;
      h = h->next;
      i->next = NULL;
      i = DisposeRanges (i);
    }
  return set;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SubBitRange - subtracts bits, lo..hi, from, set.
*/

static M2CaseList_SetRange SubBitRange (M2CaseList_SetRange set, tree lo, tree hi, unsigned int tokenno)
{
  M2CaseList_SetRange h;
  M2CaseList_SetRange i;

  h = set;
  /* Check to see if a single set element h is obliterated by lo..hi.  */
  while (h != NULL)
    {
      if ((h->high == NULL) || (M2Range_IsEqual (h->high, h->low)))
        {
          if ((M2Range_IsEqual (h->low, lo)) || (M2Range_OverlapsRange (lo, hi, h->low, h->low)))
            {
              set = RemoveRange (set, h);
              h = set;
            }
          else
            {
              h = h->next;
            }
          /* Now check to see if the lo..hi match exactly with the set range.  */
        }
      else if (((h->high != NULL) && (M2Range_IsEqual (lo, h->low))) && (M2Range_IsEqual (hi, h->high)))
        {
          /* avoid dangling else.  */
          /* Remove h and return as lo..hi have been removed.  */
          return RemoveRange (set, h);
        }
      else
        {
          /* avoid dangling else.  */
          /* All other cases require modifying the existing set range.  */
          if (M2Range_OverlapsRange (lo, hi, h->low, h->high))
            {
              if ((M2Range_IsGreater (h->low, lo)) || (M2Range_IsGreater (hi, h->high)))
                {
                  M2MetaError_MetaErrorT0 (tokenno, (const char *) "variant case range lies outside tag value", 41);
                }
              else
                {
                  if (M2Range_IsEqual (h->low, lo))
                    {
                      M2ALU_PushIntegerTree (hi);
                      M2ALU_PushInt (1);
                      M2ALU_Addn ();
                      h->low = M2ALU_PopIntegerTree ();
                    }
                  else if (M2Range_IsEqual (h->high, hi))
                    {
                      /* avoid dangling else.  */
                      M2ALU_PushIntegerTree (lo);
                      M2ALU_PushInt (1);
                      M2ALU_Sub ();
                      h->high = M2ALU_PopIntegerTree ();
                    }
                  else
                    {
                      /* avoid dangling else.  */
                      /* lo..hi  exist inside range h^.low..h^.high  */
                      i = NewRanges ();
                      i->next = h->next;
                      h->next = i;
                      i->high = h->high;
                      M2ALU_PushIntegerTree (lo);
                      M2ALU_PushInt (1);
                      M2ALU_Sub ();
                      h->high = M2ALU_PopIntegerTree ();
                      M2ALU_PushIntegerTree (hi);
                      M2ALU_PushInt (1);
                      M2ALU_Addn ();
                      i->low = M2ALU_PopIntegerTree ();
                    }
                }
            }
          else
            {
              h = h->next;
            }
        }
    }
  return set;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckLowHigh - checks to see the low value <= high value and issues an error
                  if this is not true.
*/

static void CheckLowHigh (M2CaseList_RangePair rp)
{
  tree lo;
  tree hi;
  unsigned int temp;

  lo = SymbolConversion_Mod2Gcc (rp->low);
  hi = SymbolConversion_Mod2Gcc (rp->high);
  if (M2Range_IsGreater (lo, hi))
    {
      M2MetaError_MetaErrorT2 (rp->tokenno, (const char *) "case range should be low..high rather than high..low, range specified as {%1Euad}..{%2Euad}", 91, rp->low, rp->high);
      temp = rp->high;
      rp->high = rp->low;
      rp->low = temp;
    }
}


/*
   ExcludeCaseRanges - excludes all case ranges found in, p, from, set
*/

static M2CaseList_SetRange ExcludeCaseRanges (M2CaseList_SetRange set, M2CaseList_CaseDescriptor cd)
{
  unsigned int i;
  unsigned int j;
  M2CaseList_CaseList cl;
  M2CaseList_RangePair rp;

  i = 1;
  while (i <= cd->maxCaseId)
    {
      cl = static_cast<M2CaseList_CaseList> (Indexing_GetIndice (cd->caseListArray, i));
      j = 1;
      while (j <= cl->maxRangeId)
        {
          rp = static_cast<M2CaseList_RangePair> (Indexing_GetIndice (cl->rangeArray, j));
          if (rp->high == SymbolTable_NulSym)
            {
              set = SubBitRange (set, SymbolConversion_Mod2Gcc (rp->low), SymbolConversion_Mod2Gcc (rp->low), rp->tokenno);
            }
          else
            {
              CheckLowHigh (rp);
              set = SubBitRange (set, SymbolConversion_Mod2Gcc (rp->low), SymbolConversion_Mod2Gcc (rp->high), rp->tokenno);
            }
          j += 1;
        }
      i += 1;
    }
  return set;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IncludeElement - only include enumeration field into errorString if it lies between low..high.
*/

static void IncludeElement (Lists_List enumList, unsigned int field, tree low, tree high)
{
  tree fieldTree;

  if (field != SymbolTable_NulSym)
    {
      fieldTree = SymbolConversion_Mod2Gcc (field);
      if (M2Range_OverlapsRange (fieldTree, fieldTree, low, high))
        {
          Lists_IncludeItemIntoList (enumList, field);
        }
    }
}


/*
   IncludeElements - only include enumeration field values low..high in errorString.
*/

static void IncludeElements (unsigned int type, Lists_List enumList, tree low, tree high)
{
  unsigned int field;
  unsigned int i;
  unsigned int NoElements;

  NoElements = SymbolTable_NoOfElements (type);
  i = 1;
  while (i <= NoElements)
    {
      field = SymbolTable_GetNth (type, i);
      IncludeElement (enumList, field, low, high);
      i += 1;
    }
}


/*
   ErrorRangeEnum - include enumeration fields Low to High in errorString.
*/

static void ErrorRangeEnum (unsigned int type, M2CaseList_SetRange set, Lists_List enumList)
{
  tree Low;
  tree High;

  Low = set->low;
  High = set->high;
  if (Low == NULL)
    {
      Low = High;
    }
  if (High == NULL)
    {
      High = Low;
    }
  if ((Low != NULL) && (High != NULL))
    {
      IncludeElements (type, enumList, Low, High);
    }
}


/*
   ErrorRanges - return a list of all enumeration fields not present in the case statement.
                 The return value will be nil if type is not an enumeration type.
*/

static Lists_List ErrorRanges (unsigned int type, M2CaseList_SetRange set)
{
  Lists_List enumSet;

  type = SymbolTable_SkipType (type);
  if (SymbolTable_IsEnumeration (type))
    {
      Lists_InitList (&enumSet);
      while (set != NULL)
        {
          ErrorRangeEnum (type, set, enumSet);
          set = set->next;
        }
      return enumSet;
    }
  return static_cast<Lists_List> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   appendString - appends str to errorString.
*/

static void appendString (DynamicStrings_String str)
{
  errorString = DynamicStrings_ConCat (errorString, str);
}


/*
   appendEnum - appends enum to errorString.
*/

static void appendEnum (unsigned int enum_)
{
  appendString (DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (enum_)))));
}


/*
   appendStr - appends str to errorString.
*/

static void appendStr (const char *str_, unsigned int _str_high)
{
  char str[_str_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (str, str_, _str_high+1);

  appendString (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) str, _str_high)));
}


/*
   EnumerateErrors - populate errorString with the contents of enumList.
*/

static void EnumerateErrors (Lists_List enumList)
{
  unsigned int i;
  unsigned int n;

  n = Lists_NoOfItemsInList (enumList);
  if ((enumList != NULL) && (n > 0))
    {
      if (n == 1)
        {
          errorString = DynamicStrings_InitString ((const char *) "{%W}the missing enumeration field is: ", 38);
        }
      else
        {
          errorString = DynamicStrings_InitString ((const char *) "{%W}the missing enumeration fields are: ", 40);
        }
      appendEnum (Lists_GetItemFromList (enumList, 1));
      if (n > 1)
        {
          if (n > 2)
            {
              i = 2;
              while (i <= (n-1))
                {
                  appendStr ((const char *) ", ", 2);
                  appendEnum (Lists_GetItemFromList (enumList, i));
                  i += 1;
                }
            }
          appendStr ((const char *) " and ", 5);
          appendEnum (Lists_GetItemFromList (enumList, n));
        }
    }
}


/*
   NoOfSetElements - return the number of set elements.
*/

static tree NoOfSetElements (M2CaseList_SetRange set)
{
  M2ALU_PushInt (0);
  while (set != NULL)
    {
      if (((set->low != NULL) && (set->high == NULL)) || ((set->low == NULL) && (set->high != NULL)))
        {
          M2ALU_PushInt (1);
          M2ALU_Addn ();
        }
      else if ((set->low != NULL) && (set->high != NULL))
        {
          /* avoid dangling else.  */
          M2ALU_PushIntegerTree (set->high);
          M2ALU_PushIntegerTree (set->low);
          M2ALU_Sub ();
          M2ALU_PushInt (1);
          M2ALU_Addn ();
          M2ALU_Addn ();
        }
      set = set->next;
    }
  return M2ALU_PopIntegerTree ();
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   isPrintableChar - a cautious isprint.
*/

static bool isPrintableChar (tree value)
{
  if (((m2expr_CSTIntToChar (value)) >= 'a') && ((m2expr_CSTIntToChar (value)) <= 'z'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) >= 'A') && ((m2expr_CSTIntToChar (value)) <= 'Z'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) >= '0') && ((m2expr_CSTIntToChar (value)) <= '9'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '!') || ((m2expr_CSTIntToChar (value)) == '@'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '#') || ((m2expr_CSTIntToChar (value)) == '$'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '%') || ((m2expr_CSTIntToChar (value)) == '^'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '&') || ((m2expr_CSTIntToChar (value)) == '*'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '(') || ((m2expr_CSTIntToChar (value)) == ')'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '[') || ((m2expr_CSTIntToChar (value)) == ']'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '{') || ((m2expr_CSTIntToChar (value)) == '}'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '-') || ((m2expr_CSTIntToChar (value)) == '+'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '_') || ((m2expr_CSTIntToChar (value)) == '='))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == ':') || ((m2expr_CSTIntToChar (value)) == ';'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '\'') || ((m2expr_CSTIntToChar (value)) == '"'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == ',') || ((m2expr_CSTIntToChar (value)) == '.'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '<') || ((m2expr_CSTIntToChar (value)) == '>'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '/') || ((m2expr_CSTIntToChar (value)) == '?'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '\\') || ((m2expr_CSTIntToChar (value)) == '|'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == '~') || ((m2expr_CSTIntToChar (value)) == '`'))
  {
  return true;
  }
  else if (((m2expr_CSTIntToChar (value)) == ' '))
  {
  return true;
  }

  else {
    return false;
  }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   appendTree - append tree value to the errorString.  It attempts to pretty print
                CHAR constants and will fall back to CHR (x) if necessary.
*/

static void appendTree (tree value, unsigned int type)
{
  if ((SymbolTable_SkipType (SymbolTable_GetType (type))) == M2Base_Char)
    {
      if (isPrintableChar (value))
        {
          if ((m2expr_CSTIntToChar (value)) == '\'')
            {
              appendString (DynamicStrings_InitStringChar ('"'));
              appendString (DynamicStrings_InitStringChar (m2expr_CSTIntToChar (value)));
              appendString (DynamicStrings_InitStringChar ('"'));
            }
          else
            {
              appendString (DynamicStrings_InitStringChar ('\''));
              appendString (DynamicStrings_InitStringChar (m2expr_CSTIntToChar (value)));
              appendString (DynamicStrings_InitStringChar ('\''));
            }
        }
      else
        {
          appendString (DynamicStrings_InitString ((const char *) "CHR (", 5));
          appendString (DynamicStrings_InitStringCharStar (reinterpret_cast <void *> (m2expr_CSTIntToString (value))));
          appendString (DynamicStrings_InitStringChar (')'));
        }
    }
  else
    {
      appendString (DynamicStrings_InitStringCharStar (reinterpret_cast <void *> (m2expr_CSTIntToString (value))));
    }
}


/*
   SubrangeErrors - create an errorString containing all set ranges.
*/

static void SubrangeErrors (unsigned int subrangetype, M2CaseList_SetRange set)
{
  M2CaseList_SetRange sr;
  unsigned int rangeNo;
  tree nMissing;
  tree zero;
  tree one;

  nMissing = NoOfSetElements (set);
  M2ALU_PushInt (0);
  zero = M2ALU_PopIntegerTree ();
  if (M2Range_IsGreater (nMissing, zero))
    {
      M2ALU_PushInt (1);
      one = M2ALU_PopIntegerTree ();
      if (M2Range_IsGreater (nMissing, one))
        {
          errorString = DynamicStrings_InitString ((const char *) "{%W}there are a total of ", 25);
        }
      else
        {
          errorString = DynamicStrings_InitString ((const char *) "{%W}there is a total of ", 24);
        }
      appendString (DynamicStrings_InitStringCharStar (reinterpret_cast <void *> (m2expr_CSTIntToString (nMissing))));
      appendStr ((const char *) " missing values in the subrange, the {%kCASE} statement needs labels (or an {%kELSE} statement)", 95);
      appendStr ((const char *) " for the following values: ", 27);
      sr = set;
      rangeNo = 0;
      while (sr != NULL)
        {
          rangeNo += 1;
          if (rangeNo > 1)
            {
              /* avoid gcc warning by using compound statement even if not strictly necessary.  */
              if (sr->next == NULL)
                {
                  appendStr ((const char *) " and ", 5);
                }
              else
                {
                  appendStr ((const char *) ", ", 2);
                }
            }
          if (sr->low == NULL)
            {
              appendTree (sr->high, subrangetype);
            }
          else if ((sr->high == NULL) || (M2Range_IsEqual (sr->low, sr->high)))
            {
              /* avoid dangling else.  */
              appendTree (sr->low, subrangetype);
            }
          else
            {
              /* avoid dangling else.  */
              appendTree (sr->low, subrangetype);
              appendStr ((const char *) "..", 2);
              appendTree (sr->high, subrangetype);
            }
          sr = sr->next;
        }
    }
}


/*
   EmitMissingRangeErrors - emits a singular/plural error message for an enumeration type.
*/

static void EmitMissingRangeErrors (unsigned int tokenno, unsigned int type, M2CaseList_SetRange set)
{
  errorString = static_cast<DynamicStrings_String> (NULL);
  if (SymbolTable_IsEnumeration (type))
    {
      EnumerateErrors (ErrorRanges (type, set));
    }
  else if (SymbolTable_IsSubrange (type))
    {
      /* avoid dangling else.  */
      SubrangeErrors (type, set);
    }
  if (errorString != NULL)
    {
      M2MetaError_MetaErrorStringT0 (tokenno, errorString);
    }
}


/*
   checkTypes - checks to see that, constant, and, type, are compatible.
*/

static bool checkTypes (unsigned int constant, unsigned int type)
{
  unsigned int consttype;

  if ((constant != SymbolTable_NulSym) && (SymbolTable_IsConst (constant)))
    {
      consttype = SymbolTable_GetType (constant);
      if (! (M2Base_IsExpressionCompatible (consttype, type)))
        {
          M2MetaError_MetaError2 ((const char *) "the case statement variant tag {%1ad} must be type compatible with the constant {%2Da:is a {%2d}}", 97, type, constant);
          return false;
        }
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   inRange - returns true if, min <= i <= max.
*/

static bool inRange (unsigned int i, unsigned int min, unsigned int max)
{
  return M2Range_OverlapsRange (SymbolConversion_Mod2Gcc (i), SymbolConversion_Mod2Gcc (i), SymbolConversion_Mod2Gcc (min), SymbolConversion_Mod2Gcc (max));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushCase - create a case entity and push it to an internal stack.
              rec is NulSym if this is a CASE statement.
              If rec is a record then it indicates a possible
              varients reside in the record to check.
              Both rec and va might be NulSym and then the expr
              will contain the selector expression to a case statement.
              Return the case id.
*/

extern "C" unsigned int M2CaseList_PushCase (unsigned int rec, unsigned int va, unsigned int expr)
{
  M2CaseList_CaseDescriptor c;

  caseId += 1;
  Storage_ALLOCATE ((void **) &c, sizeof (M2CaseList__T4));
  if (c == NULL)
    {
      M2Error_InternalError ((const char *) "out of memory error", 19);
    }
  else
    {
      c->resolved = false;
      c->elseClause = false;
      c->elseField = SymbolTable_NulSym;
      c->record = rec;
      c->varient = va;
      c->expression = expr;
      c->maxCaseId = 0;
      c->caseListArray = Indexing_InitIndex (1);
      c->next = caseStack;
      c->currentCase = NULL;
      caseStack = c;
      Indexing_PutIndice (caseArray, caseId, reinterpret_cast <void *> (c));
    }
  return caseId;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PopCase - pop the top element of the case entity from the internal
             stack.
*/

extern "C" void M2CaseList_PopCase (void)
{
  if (caseStack == NULL)
    {
      M2Error_InternalError ((const char *) "case stack is empty", 19);
    }
  caseStack = caseStack->next;
}


/*
   ElseCase - indicates that this case varient does have an else clause.
*/

extern "C" void M2CaseList_ElseCase (unsigned int f)
{
  caseStack->elseClause = true;
  caseStack->elseField = f;
}


/*
   BeginCaseList - create a new label list.
*/

extern "C" void M2CaseList_BeginCaseList (unsigned int v)
{
  M2CaseList_CaseList l;

  Storage_ALLOCATE ((void **) &l, sizeof (M2CaseList__T3));
  if (l == NULL)
    {
      M2Error_InternalError ((const char *) "out of memory error", 19);
    }
  l->maxRangeId = 0;
  l->rangeArray = Indexing_InitIndex (1);
  l->currentRange = NULL;
  l->varientField = v;
  caseStack->maxCaseId += 1;
  Indexing_PutIndice (caseStack->caseListArray, caseStack->maxCaseId, reinterpret_cast <void *> (l));
  caseStack->currentCase = l;
}


/*
   EndCaseList - terminate the current label list.
*/

extern "C" void M2CaseList_EndCaseList (void)
{
  caseStack->currentCase = NULL;
}


/*
   AddRange - add a range to the current label list.
*/

extern "C" void M2CaseList_AddRange (unsigned int r1, unsigned int r2, unsigned int tok)
{
  M2CaseList_RangePair r;

  Storage_ALLOCATE ((void **) &r, sizeof (M2CaseList__T1));
  if (r == NULL)
    {
      M2Error_InternalError ((const char *) "out of memory error", 19);
    }
  else
    {
      r->low = r1;
      r->high = r2;
      r->tokenno = tok;
      caseStack->currentCase->maxRangeId += 1;
      Indexing_PutIndice (caseStack->currentCase->rangeArray, caseStack->currentCase->maxRangeId, reinterpret_cast <void *> (r));
      caseStack->currentCase->currentRange = r;
    }
}


/*
   CaseBoundsResolved - returns TRUE if all constants in the case list, c,
                        are known to GCC.
*/

extern "C" bool M2CaseList_CaseBoundsResolved (unsigned int tokenno, unsigned int c)
{
  M2CaseList_CaseDescriptor p;

  p = static_cast<M2CaseList_CaseDescriptor> (Indexing_GetIndice (caseArray, c));
  if (p->resolved)
    {
      return true;
    }
  else
    {
      if (CheckCaseBoundsResolved (tokenno, c))
        {
          ConvertNulStr2NulChar (tokenno, c);
          return true;
        }
      else
        {
          return false;
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TypeCaseBounds - returns true if all bounds in case list, c, are
                    compatible with the tagged type.
*/

extern "C" bool M2CaseList_TypeCaseBounds (unsigned int c)
{
  M2CaseList_CaseDescriptor p;
  M2CaseList_CaseList q;
  M2CaseList_RangePair r;
  unsigned int min;
  unsigned int max;
  unsigned int type;
  unsigned int i;
  unsigned int j;
  bool compatible;

  p = static_cast<M2CaseList_CaseDescriptor> (Indexing_GetIndice (caseArray, c));
  type = SymbolTable_NulSym;
  type = SymbolTable_NulSym;
  if (p->varient != SymbolTable_NulSym)
    {
      /* not a CASE statement, but a varient record containing without an ELSE clause  */
      type = GetVariantTagType (p->varient);
      min = M2GCCDeclare_GetTypeMin (type);
      max = M2GCCDeclare_GetTypeMax (type);
    }
  if (type == SymbolTable_NulSym)
    {
      return true;
    }
  compatible = true;
  i = 1;
  while (i <= p->maxCaseId)
    {
      q = static_cast<M2CaseList_CaseList> (Indexing_GetIndice (p->caseListArray, i));
      j = 1;
      while (j <= q->maxRangeId)
        {
          r = static_cast<M2CaseList_RangePair> (Indexing_GetIndice (q->rangeArray, j));
          if ((r->low != SymbolTable_NulSym) && (! (inRange (r->low, min, max))))
            {
              M2MetaError_MetaError2 ((const char *) "the CASE statement variant range {%1ad} exceeds that of the tag type {%2ad}", 75, r->low, type);
              compatible = false;
            }
          if (! (checkTypes (r->low, type)))
            {
              compatible = false;
            }
          if ((r->high != SymbolTable_NulSym) && (! (inRange (r->high, min, max))))
            {
              M2MetaError_MetaError2 ((const char *) "the CASE statement variant range {%1ad} exceeds that of the tag type {%2ad}", 75, r->high, type);
              compatible = false;
            }
          if (! (checkTypes (r->high, type)))
            {
              compatible = false;
            }
          j += 1;
        }
      i += 1;
    }
  return compatible;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OverlappingCaseBounds - returns TRUE if there were any overlapping bounds
                           in the case list, c.  It will generate an error
                           messages for each overlapping bound found.
*/

extern "C" bool M2CaseList_OverlappingCaseBounds (unsigned int c)
{
  M2CaseList_CaseDescriptor p;
  M2CaseList_CaseList q;
  M2CaseList_RangePair r;
  unsigned int i;
  unsigned int j;
  bool overlap;

  p = static_cast<M2CaseList_CaseDescriptor> (Indexing_GetIndice (caseArray, c));
  overlap = false;
  i = 1;
  while (i <= p->maxCaseId)
    {
      q = static_cast<M2CaseList_CaseList> (Indexing_GetIndice (p->caseListArray, i));
      j = 1;
      while (j <= q->maxRangeId)
        {
          r = static_cast<M2CaseList_RangePair> (Indexing_GetIndice (q->rangeArray, j));
          if (OverlappingCaseBound (r, c))
            {
              overlap = true;
            }
          j += 1;
        }
      i += 1;
    }
  return overlap;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MissingCaseBounds - returns true if there were any missing bounds
                       in the varient record case list, c.  It will
                       generate an error message for each missing
                       bounds found.
*/

extern "C" bool M2CaseList_MissingCaseBounds (unsigned int tokenno, unsigned int c)
{
  M2CaseList_CaseDescriptor p;
  unsigned int type;
  bool missing;
  M2CaseList_SetRange set;

  p = static_cast<M2CaseList_CaseDescriptor> (Indexing_GetIndice (caseArray, c));
  missing = false;
  if (! p->elseClause)
    {
      if ((p->record != SymbolTable_NulSym) && (p->varient != SymbolTable_NulSym))
        {
          /* Not a case statement, but a varient record without an else clause.  */
          type = GetVariantTagType (p->varient);
          set = NewSet (type);
          set = ExcludeCaseRanges (set, p);
          if (set != NULL)
            {
              missing = true;
              M2MetaError_MetaErrorT2 (tokenno, (const char *) "not all variant record alternatives in the {%kCASE} clause are specified, hint you either need to specify each value of {%2ad} or use an {%kELSE} clause", 152, p->varient, type);
              EmitMissingRangeErrors (tokenno, type, set);
            }
          set = DisposeRanges (set);
        }
    }
  return missing;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MissingCaseStatementBounds - returns true if the case statement has a missing
                                clause.  It will also generate error messages.
*/

extern "C" bool M2CaseList_MissingCaseStatementBounds (unsigned int tokenno, unsigned int c)
{
  M2CaseList_CaseDescriptor p;
  unsigned int type;
  bool missing;
  M2CaseList_SetRange set;

  p = static_cast<M2CaseList_CaseDescriptor> (Indexing_GetIndice (caseArray, c));
  missing = false;
  if (! p->elseClause)
    {
      type = GetCaseExpression (p);
      if (type != SymbolTable_NulSym)
        {
          if ((SymbolTable_IsEnumeration (type)) || (SymbolTable_IsSubrange (type)))
            {
              /* A case statement sequence without an else clause but
                  selecting using an enumeration type.  */
              set = NewSet (type);
              set = ExcludeCaseRanges (set, p);
              if (set != NULL)
                {
                  missing = true;
                  M2MetaError_MetaErrorT1 (tokenno, (const char *) "not all {%1Wd} values in the {%kCASE} statements are specified, hint you either need to specify each value of {%1ad} or use an {%kELSE} clause", 142, type);
                  EmitMissingRangeErrors (tokenno, type, set);
                }
              set = DisposeRanges (set);
            }
        }
    }
  return missing;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WriteCase - dump out the case list (internal debugging).
*/

extern "C" void M2CaseList_WriteCase (unsigned int c)
{
  /* this debugging PROCEDURE should be finished.  */
  NumberIO_WriteCard (c, 0);
}

extern "C" void _M2_M2CaseList_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  caseStack = NULL;
  caseId = 0;
  caseArray = Indexing_InitIndex (1);
  conflictArray = Indexing_InitIndex (1);
  FreeRangeList = NULL;
}

extern "C" void _M2_M2CaseList_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
