/* do not edit automatically generated by mc from M2FileName.  */
/* M2FileName.def construct file names.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2FileName_H)
#   define _M2FileName_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GDynamicStrings.h"

#   if defined (_M2FileName_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   CalculateFileName - calculates and returns a new string filename
                       given a module and an extension. This file name
                       length will be operating system specific.
                       String, Extension, is concatenated onto
                       Module and thus it is safe to Mark the extension
                       for garbage collection.
*/

EXTERN DynamicStrings_String M2FileName_CalculateFileName (DynamicStrings_String Module, DynamicStrings_String Extension);

/*
   CalculateStemName - calculates the stem name for given a module.
                       This name length will be operating system and
      	       	       compiler specific.
*/

EXTERN DynamicStrings_String M2FileName_CalculateStemName (DynamicStrings_String Module);

/*
   ExtractExtension - given a, filename, return the filename without
                      the extension, Ext.
*/

EXTERN DynamicStrings_String M2FileName_ExtractExtension (DynamicStrings_String filename, DynamicStrings_String ext);

/*
   ExtractModule - given a, filename, return the module name including any
                   extension. A new string is returned.
*/

EXTERN DynamicStrings_String M2FileName_ExtractModule (DynamicStrings_String filename);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
