pragma Warnings (Off);
pragma Ada_95;
pragma Source_File_Name (ada_main, Spec_File_Name => "b_gnatl.ads");
pragma Source_File_Name (ada_main, Body_File_Name => "b_gnatl.adb");
pragma Suppress (Overflow_Check);

package body ada_main is

   E080 : Short_Integer; pragma Import (Ada, E080, "system__os_lib_E");
   E012 : Short_Integer; pragma Import (Ada, E012, "ada__exceptions_E");
   E016 : Short_Integer; pragma Import (Ada, E016, "system__soft_links_E");
   E025 : Short_Integer; pragma Import (Ada, E025, "system__exception_table_E");
   E050 : Short_Integer; pragma Import (Ada, E050, "ada__assertions_E");
   E041 : Short_Integer; pragma Import (Ada, E041, "ada__containers_E");
   E075 : Short_Integer; pragma Import (Ada, E075, "ada__io_exceptions_E");
   E032 : Short_Integer; pragma Import (Ada, E032, "ada__numerics_E");
   E060 : Short_Integer; pragma Import (Ada, E060, "ada__strings_E");
   E062 : Short_Integer; pragma Import (Ada, E062, "ada__strings__maps_E");
   E065 : Short_Integer; pragma Import (Ada, E065, "ada__strings__maps__constants_E");
   E046 : Short_Integer; pragma Import (Ada, E046, "interfaces__c_E");
   E026 : Short_Integer; pragma Import (Ada, E026, "system__exceptions_E");
   E091 : Short_Integer; pragma Import (Ada, E091, "system__object_reader_E");
   E055 : Short_Integer; pragma Import (Ada, E055, "system__dwarf_lines_E");
   E018 : Short_Integer; pragma Import (Ada, E018, "system__soft_links__initialize_E");
   E040 : Short_Integer; pragma Import (Ada, E040, "system__traceback__symbolic_E");
   E117 : Short_Integer; pragma Import (Ada, E117, "gnat_E");
   E168 : Short_Integer; pragma Import (Ada, E168, "interfaces__c__strings_E");
   E141 : Short_Integer; pragma Import (Ada, E141, "gnat__dynamic_htables_E");
   E124 : Short_Integer; pragma Import (Ada, E124, "types_E");
   E153 : Short_Integer; pragma Import (Ada, E153, "gnatvsn_E");
   E120 : Short_Integer; pragma Import (Ada, E120, "hostparm_E");
   E166 : Short_Integer; pragma Import (Ada, E166, "indepsw_E");
   E119 : Short_Integer; pragma Import (Ada, E119, "opt_E");
   E126 : Short_Integer; pragma Import (Ada, E126, "output_E");
   E132 : Short_Integer; pragma Import (Ada, E132, "widechar_E");
   E128 : Short_Integer; pragma Import (Ada, E128, "namet_E");
   E116 : Short_Integer; pragma Import (Ada, E116, "butil_E");
   E164 : Short_Integer; pragma Import (Ada, E164, "casing_E");
   E145 : Short_Integer; pragma Import (Ada, E145, "fmap_E");
   E143 : Short_Integer; pragma Import (Ada, E143, "osint_E");
   E155 : Short_Integer; pragma Import (Ada, E155, "sdefault_E");
   E157 : Short_Integer; pragma Import (Ada, E157, "targparm_E");
   E139 : Short_Integer; pragma Import (Ada, E139, "fname_E");
   E162 : Short_Integer; pragma Import (Ada, E162, "snames_E");
   E114 : Short_Integer; pragma Import (Ada, E114, "ali_E");
   E172 : Short_Integer; pragma Import (Ada, E172, "switch_E");
   E002 : Short_Integer; pragma Import (Ada, E002, "gnatlink_E");

   Sec_Default_Sized_Stacks : array (1 .. 1) of aliased System.Secondary_Stack.SS_Stack (System.Parameters.Runtime_Default_Sec_Stack_Size);

   Local_Priority_Specific_Dispatching : constant String := "";
   Local_Interrupt_States : constant String := "";

   Is_Elaborated : Boolean := False;

   procedure adafinal is
      procedure s_stalib_adafinal;
      pragma Import (Ada, s_stalib_adafinal, "system__standard_library__adafinal");

      procedure Runtime_Finalize;
      pragma Import (C, Runtime_Finalize, "__gnat_runtime_finalize");

   begin
      if not Is_Elaborated then
         return;
      end if;
      Is_Elaborated := False;
      Runtime_Finalize;
      s_stalib_adafinal;
   end adafinal;

   type No_Param_Proc is access procedure;
   pragma Favor_Top_Level (No_Param_Proc);

   procedure adainit is
      Main_Priority : Integer;
      pragma Import (C, Main_Priority, "__gl_main_priority");
      Time_Slice_Value : Integer;
      pragma Import (C, Time_Slice_Value, "__gl_time_slice_val");
      WC_Encoding : Character;
      pragma Import (C, WC_Encoding, "__gl_wc_encoding");
      Locking_Policy : Character;
      pragma Import (C, Locking_Policy, "__gl_locking_policy");
      Queuing_Policy : Character;
      pragma Import (C, Queuing_Policy, "__gl_queuing_policy");
      Task_Dispatching_Policy : Character;
      pragma Import (C, Task_Dispatching_Policy, "__gl_task_dispatching_policy");
      Priority_Specific_Dispatching : System.Address;
      pragma Import (C, Priority_Specific_Dispatching, "__gl_priority_specific_dispatching");
      Num_Specific_Dispatching : Integer;
      pragma Import (C, Num_Specific_Dispatching, "__gl_num_specific_dispatching");
      Main_CPU : Integer;
      pragma Import (C, Main_CPU, "__gl_main_cpu");
      Interrupt_States : System.Address;
      pragma Import (C, Interrupt_States, "__gl_interrupt_states");
      Num_Interrupt_States : Integer;
      pragma Import (C, Num_Interrupt_States, "__gl_num_interrupt_states");
      Unreserve_All_Interrupts : Integer;
      pragma Import (C, Unreserve_All_Interrupts, "__gl_unreserve_all_interrupts");
      Detect_Blocking : Integer;
      pragma Import (C, Detect_Blocking, "__gl_detect_blocking");
      Default_Stack_Size : Integer;
      pragma Import (C, Default_Stack_Size, "__gl_default_stack_size");
      Default_Secondary_Stack_Size : System.Parameters.Size_Type;
      pragma Import (C, Default_Secondary_Stack_Size, "__gnat_default_ss_size");
      Bind_Env_Addr : System.Address;
      pragma Import (C, Bind_Env_Addr, "__gl_bind_env_addr");
      Interrupts_Default_To_System : Integer;
      pragma Import (C, Interrupts_Default_To_System, "__gl_interrupts_default_to_system");

      procedure Runtime_Initialize (Install_Handler : Integer);
      pragma Import (C, Runtime_Initialize, "__gnat_runtime_initialize");

      Finalize_Library_Objects : No_Param_Proc;
      pragma Import (C, Finalize_Library_Objects, "__gnat_finalize_library_objects");
      Binder_Sec_Stacks_Count : Natural;
      pragma Import (Ada, Binder_Sec_Stacks_Count, "__gnat_binder_ss_count");
      Default_Sized_SS_Pool : System.Address;
      pragma Import (Ada, Default_Sized_SS_Pool, "__gnat_default_ss_pool");

   begin
      if Is_Elaborated then
         return;
      end if;
      Is_Elaborated := True;
      Main_Priority := -1;
      Time_Slice_Value := -1;
      WC_Encoding := 'b';
      Locking_Policy := ' ';
      Queuing_Policy := ' ';
      Task_Dispatching_Policy := ' ';
      Priority_Specific_Dispatching :=
        Local_Priority_Specific_Dispatching'Address;
      Num_Specific_Dispatching := 0;
      Main_CPU := -1;
      Interrupt_States := Local_Interrupt_States'Address;
      Num_Interrupt_States := 0;
      Unreserve_All_Interrupts := 0;
      Detect_Blocking := 0;
      Default_Stack_Size := -1;

      ada_main'Elab_Body;
      Default_Secondary_Stack_Size := System.Parameters.Runtime_Default_Sec_Stack_Size;
      Binder_Sec_Stacks_Count := 1;
      Default_Sized_SS_Pool := Sec_Default_Sized_Stacks'Address;

      Runtime_Initialize (1);

      Finalize_Library_Objects := null;

      Ada.Exceptions'Elab_Spec;
      System.Soft_Links'Elab_Spec;
      System.Exception_Table'Elab_Body;
      E025 := E025 + 1;
      Ada.Assertions'Elab_Spec;
      E050 := E050 + 1;
      Ada.Containers'Elab_Spec;
      E041 := E041 + 1;
      Ada.Io_Exceptions'Elab_Spec;
      E075 := E075 + 1;
      Ada.Numerics'Elab_Spec;
      E032 := E032 + 1;
      Ada.Strings'Elab_Spec;
      E060 := E060 + 1;
      Ada.Strings.Maps'Elab_Spec;
      E062 := E062 + 1;
      Ada.Strings.Maps.Constants'Elab_Spec;
      E065 := E065 + 1;
      Interfaces.C'Elab_Spec;
      System.Exceptions'Elab_Spec;
      E026 := E026 + 1;
      E046 := E046 + 1;
      System.Object_Reader'Elab_Spec;
      E091 := E091 + 1;
      System.Dwarf_Lines'Elab_Spec;
      E055 := E055 + 1;
      System.Os_Lib'Elab_Body;
      E080 := E080 + 1;
      System.Soft_Links.Initialize'Elab_Body;
      E018 := E018 + 1;
      E016 := E016 + 1;
      System.Traceback.Symbolic'Elab_Body;
      E040 := E040 + 1;
      E012 := E012 + 1;
      Gnat'Elab_Spec;
      E117 := E117 + 1;
      Interfaces.C.Strings'Elab_Spec;
      E168 := E168 + 1;
      E141 := E141 + 1;
      Types'Elab_Spec;
      E124 := E124 + 1;
      E153 := E153 + 1;
      Hostparm'Elab_Spec;
      E120 := E120 + 1;
      E166 := E166 + 1;
      Opt'Elab_Spec;
      E119 := E119 + 1;
      Output'Elab_Body;
      E126 := E126 + 1;
      E132 := E132 + 1;
      Namet'Elab_Spec;
      Namet'Elab_Body;
      E128 := E128 + 1;
      E116 := E116 + 1;
      E164 := E164 + 1;
      Osint'Elab_Spec;
      Fmap'Elab_Body;
      E145 := E145 + 1;
      E155 := E155 + 1;
      E157 := E157 + 1;
      Osint'Elab_Body;
      E143 := E143 + 1;
      E139 := E139 + 1;
      Snames'Elab_Body;
      E162 := E162 + 1;
      ALI'ELAB_SPEC;
      ALI'ELAB_BODY;
      E114 := E114 + 1;
      E172 := E172 + 1;
      E002 := E002 + 1;
   end adainit;

   procedure Ada_Main_Program;
   pragma Import (Ada, Ada_Main_Program, "_ada_gnatlink");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer
   is
      procedure Initialize (Addr : System.Address);
      pragma Import (C, Initialize, "__gnat_initialize");

      procedure Finalize;
      pragma Import (C, Finalize, "__gnat_finalize");
      SEH : aliased array (1 .. 2) of Integer;

      Ensure_Reference : aliased System.Address := Ada_Main_Program_Name'Address;
      pragma Volatile (Ensure_Reference);

   begin
      if gnat_argc = 0 then
         gnat_argc := argc;
         gnat_argv := argv;
      end if;
      gnat_envp := envp;

      Initialize (SEH'Address);
      adainit;
      Ada_Main_Program;
      adafinal;
      Finalize;
      return (gnat_exit_status);
   end;

--  BEGIN Object file/option list
   --   ./interfac.o
   --   ./system.o
   --   ./s-stoele.o
   --   ./s-htable.o
   --   ./s-casuti.o
   --   ./s-exctab.o
   --   ./s-excmac.o
   --   ./i-c.o
   --   ./s-secsta.o
   --   ./s-stalib.o
   --   ./a-except.o
   --   ./i-cstrin.o
   --   ./debug.o
   --   ./types.o
   --   ./alloc.o
   --   ./gnatvsn.o
   --   ./hostparm.o
   --   ./indepsw.o
   --   ./opt.o
   --   ./csets.o
   --   ./output.o
   --   ./rident.o
   --   ./table.o
   --   ./widechar.o
   --   ./namet.o
   --   ./butil.o
   --   ./casing.o
   --   ./fmap.o
   --   ./sdefault.o
   --   ./targparm.o
   --   ./osint.o
   --   ./fname.o
   --   ./snames.o
   --   ./ali.o
   --   ./switch.o
   --   ./gnatlink.o
   --   -L./
   --   -L../rts/
   --   -L./
   --   -L/build/gcc/src/gcc/gcc/ada/
   --   -L/usr/lib/gcc/x86_64-pc-linux-gnu/15.2.1/adalib/
   --   -static
   --   -lgnat
   --   -ldl
--  END Object file/option list   

end ada_main;
