/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Hashtable;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.TestOnly;

@TestOnly
@ApiStatus.Internal
public final class Cleanup {
    private static final MethodHandle currentManagerHandle;
    private static final MethodHandle componentKeyStrokeMapHandle;
    private static final MethodHandle containerMapHandle;

    private Cleanup() {
    }

    public static void cleanupSwingDataStructures() throws Throwable {
        Object manager = currentManagerHandle.invoke();
        Map componentKeyStrokeMap = componentKeyStrokeMapHandle.invoke(manager);
        componentKeyStrokeMap.clear();
        Map containerMap = containerMapHandle.invoke(manager);
        containerMap.clear();
    }

    static {
        try {
            Class<?> aClass = Cleanup.class.getClassLoader().loadClass("javax.swing.KeyboardManager");
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(aClass, MethodHandles.lookup());
            currentManagerHandle = lookup.findStatic(aClass, "getCurrentManager", MethodType.methodType(aClass));
            componentKeyStrokeMapHandle = lookup.findGetter(aClass, "componentKeyStrokeMap", Hashtable.class);
            containerMapHandle = lookup.findGetter(aClass, "containerMap", Hashtable.class);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

