/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.sps;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ItemInfo {
    private long startPathId;
    private long fileId;
    private int retryCount;

    public ItemInfo(long startPathId, long fileId) {
        this.startPathId = startPathId;
        this.fileId = fileId;
        this.retryCount = 0;
    }

    public ItemInfo(long startPathId, long fileId, int retryCount) {
        this.startPathId = startPathId;
        this.fileId = fileId;
        this.retryCount = retryCount;
    }

    public long getStartPath() {
        return this.startPathId;
    }

    public long getFile() {
        return this.fileId;
    }

    public boolean isDir() {
        return this.startPathId != this.fileId;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void increRetryCount() {
        ++this.retryCount;
    }
}

