/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.openpgp.CryptlibObjectIdentifiers;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;

public class PGPKeyRingGenerator {
    private final List<PGPSecretKey> keys = new ArrayList<PGPSecretKey>();
    private final PBESecretKeyEncryptor keyEncryptor;
    private final PGPDigestCalculator checksumCalculator;
    private final PGPKeyPair primaryKey;
    private final PGPSignatureSubpacketVector hashedPcks;
    private final PGPSignatureSubpacketVector unhashedPcks;
    private final PGPContentSignerBuilder keySignerBuilder;

    public PGPKeyRingGenerator(int certificationLevel, PGPKeyPair primaryKey, String id, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder keySignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this.primaryKey = this.sanitizeKeyPair(primaryKey);
        this.keyEncryptor = keyEncryptor;
        this.checksumCalculator = checksumCalculator;
        this.keySignerBuilder = keySignerBuilder;
        this.hashedPcks = hashedPcks;
        this.unhashedPcks = unhashedPcks;
        this.keys.add(new PGPSecretKey(certificationLevel, primaryKey, id, checksumCalculator, hashedPcks, unhashedPcks, keySignerBuilder, keyEncryptor));
    }

    public PGPKeyRingGenerator(PGPKeyPair primaryKey, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder keySignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        PGPSignatureGenerator sigGen;
        this.primaryKey = this.sanitizeKeyPair(primaryKey);
        this.keyEncryptor = keyEncryptor;
        this.checksumCalculator = checksumCalculator;
        this.keySignerBuilder = keySignerBuilder;
        this.hashedPcks = hashedPcks;
        this.unhashedPcks = unhashedPcks;
        try {
            sigGen = new PGPSignatureGenerator(keySignerBuilder, primaryKey.getPublicKey());
        }
        catch (Exception e) {
            throw new PGPException("creating signature generator: " + e, e);
        }
        sigGen.init(31, primaryKey.getPrivateKey());
        sigGen.setHashedSubpackets(hashedPcks);
        sigGen.setUnhashedSubpackets(unhashedPcks);
        PGPSecretKey secretKey = new PGPSecretKey(primaryKey.getPrivateKey(), primaryKey.getPublicKey(), checksumCalculator, true, keyEncryptor);
        PGPPublicKey publicKey = secretKey.getPublicKey();
        try {
            PGPSignature certification = sigGen.generateCertification(primaryKey.getPublicKey());
            publicKey = PGPPublicKey.addCertification(publicKey, certification);
        }
        catch (Exception e) {
            throw new PGPException("exception doing direct-key signature: " + e, e);
        }
        secretKey = PGPSecretKey.replacePublicKey(secretKey, publicKey);
        this.keys.add(secretKey);
    }

    public PGPKeyRingGenerator(PGPSecretKeyRing originalSecretRing, PBESecretKeyDecryptor secretKeyDecryptor, PGPDigestCalculator checksumCalculator, PGPContentSignerBuilder keySignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this.primaryKey = this.sanitizeKeyPair(new PGPKeyPair(originalSecretRing.getPublicKey(), originalSecretRing.getSecretKey().extractPrivateKey(secretKeyDecryptor)));
        this.keyEncryptor = keyEncryptor;
        this.checksumCalculator = checksumCalculator;
        this.keySignerBuilder = keySignerBuilder;
        PGPSignature certSig = originalSecretRing.getPublicKey().getSignatures().next();
        ArrayList<SignatureSubpacket> hashedVec = new ArrayList<SignatureSubpacket>();
        PGPSignatureSubpacketVector existing = certSig.getHashedSubPackets();
        for (int i = 0; i != existing.size(); ++i) {
            if (existing.packets[i].getType() == 2) continue;
            hashedVec.add(existing.packets[i]);
        }
        this.hashedPcks = new PGPSignatureSubpacketVector(hashedVec.toArray(new SignatureSubpacket[hashedVec.size()]));
        this.unhashedPcks = certSig.getUnhashedSubPackets();
        this.keys.addAll(originalSecretRing.keys);
    }

    private PGPKeyPair sanitizeKeyPair(PGPKeyPair keyPair) throws PGPException {
        PGPPublicKey pubKey = keyPair.getPublicKey();
        if (pubKey.getVersion() == 6) {
            ECPublicBCPGKey ecKey;
            if (pubKey.getAlgorithm() == 16 || pubKey.getAlgorithm() == 20) {
                throw new PGPException("An implementation MUST NOT generate v6 ElGamal keys");
            }
            if (pubKey.getAlgorithm() == 1 && pubKey.getBitStrength() < 3072) {
                throw new PGPException("An implementation MUST NOT generate v6 RSA keys of a size less than 3072 bits.");
            }
            if (pubKey.getAlgorithm() == 2 || pubKey.getAlgorithm() == 3) {
                throw new PGPException("An implementation MUST NOT generate v6 RSA keys of type RSA_ENCRYPT/RSA_SIGN");
            }
            if (pubKey.getAlgorithm() == 17) {
                throw new PGPException("An implementation MUST NOT generate v6 DSA keys.");
            }
            if (pubKey.getAlgorithm() == 22) {
                throw new PGPException("An implementation MUST NOT generate v6 EDDSA_LEGACY keys.");
            }
            if (pubKey.getAlgorithm() == 18 && (ecKey = (ECPublicBCPGKey)pubKey.publicPk.getKey()).getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                throw new PGPException("An implementation MUST NOT generate v6 ECDH keys over Curve25519Legacy.");
            }
            if (pubKey.getAlgorithm() == 21) {
                throw new PGPException("An implementation MUST NOT generate v6 Diffie-Hellman keys.");
            }
        }
        return keyPair;
    }

    public void addSubKey(PGPKeyPair keyPair) throws PGPException {
        this.addSubKey(this.sanitizeKeyPair(keyPair), this.hashedPcks, this.unhashedPcks);
    }

    public void addSubKey(PGPKeyPair keyPair, PGPContentSignerBuilder bindingSignerBldr) throws PGPException {
        this.addSubKey(this.sanitizeKeyPair(keyPair), this.hashedPcks, this.unhashedPcks, bindingSignerBldr);
    }

    public void addSubKey(PGPKeyPair keyPair, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks) throws PGPException {
        this.addSubKey(this.sanitizeKeyPair(keyPair), hashedPcks, unhashedPcks, null);
    }

    public void addSubKey(PGPKeyPair keyPair, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder bindingSignerBldr) throws PGPException {
        this.sanitizeKeyPair(keyPair);
        try {
            PGPSignatureGenerator sGen = new PGPSignatureGenerator(this.keySignerBuilder, this.primaryKey.getPublicKey());
            sGen.init(24, this.primaryKey.getPrivateKey());
            if (bindingSignerBldr != null) {
                PGPSignatureGenerator pGen = new PGPSignatureGenerator(bindingSignerBldr, keyPair.getPublicKey());
                pGen.init(25, keyPair.getPrivateKey());
                PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator(hashedPcks);
                spGen.addEmbeddedSignature(false, pGen.generateCertification(this.primaryKey.getPublicKey(), keyPair.getPublicKey()));
                sGen.setHashedSubpackets(spGen.generate());
            } else {
                sGen.setHashedSubpackets(hashedPcks);
            }
            sGen.setUnhashedSubpackets(unhashedPcks);
            ArrayList<PGPSignature> subSigs = new ArrayList<PGPSignature>();
            subSigs.add(sGen.generateCertification(this.primaryKey.getPublicKey(), keyPair.getPublicKey()));
            PGPPublicKey pubSubKey = new PGPPublicKey(keyPair.getPublicKey(), null, subSigs);
            pubSubKey.publicPk = new PublicSubkeyPacket(pubSubKey.getVersion(), pubSubKey.getAlgorithm(), pubSubKey.getCreationTime(), pubSubKey.publicPk.getKey());
            this.keys.add(new PGPSecretKey(keyPair.getPrivateKey(), pubSubKey, this.checksumCalculator, this.keyEncryptor));
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception adding subkey: ", e);
        }
    }

    public PGPSecretKeyRing generateSecretKeyRing() {
        return new PGPSecretKeyRing(this.keys);
    }

    public PGPPublicKeyRing generatePublicKeyRing() {
        Iterator<PGPSecretKey> it = this.keys.iterator();
        ArrayList<PGPPublicKey> pubKeys = new ArrayList<PGPPublicKey>();
        pubKeys.add(it.next().getPublicKey());
        while (it.hasNext()) {
            pubKeys.add(it.next().getPublicKey());
        }
        return new PGPPublicKeyRing(pubKeys);
    }
}

