/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import com.ibm.icu.util.ULocale;
import org.jetbrains.annotations.NotNull;

public enum LanguageCode {
    aa("Afar", "Afaraf"),
    ab("Abkhazian", "\u0410\u04a7\u0441\u0443\u0430"),
    ae("Avestan", "Avesta"),
    af("Afrikaans", "Afrikaans"),
    ak("Akan", "Akan"),
    am("Amharic", "\u12a0\u121b\u122d\u129b"),
    an("Aragonese", "Aragon\u00e9s"),
    ar("Arabic", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629"),
    av("Avaric", "\u0430\u0432\u0430\u0440 \u043c\u0430\u0446\u04c0; \u043c\u0430\u0433\u04c0\u0430\u0440\u0443\u043b \u043c\u0430\u0446\u04c0"),
    ay("Aymara", "aymar aru"),
    az("Azerbaijani", "az\u0259rbaycan dili"),
    ba("Bashkir", "\u0431\u0430\u0448\u04a1\u043e\u0440\u0442 \u0442\u0435\u043b\u0435"),
    be("Belarusian", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f"),
    bi("Bislama", "Bislama"),
    bg("Bulgarian", "\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438 \u0435\u0437\u0438\u043a"),
    bm("Bambara", "bamanankan"),
    bn("Bengali", "\u09ac\u09be\u0982\u09b2\u09be"),
    bo("Tibetan", "\u0f56\u0f7c\u0f51\u0f0b\u0f61\u0f72\u0f42"),
    br("Breton", "brezhoneg"),
    bs("Bosnian", "bosanski jezik"),
    ca("Catalan", "Catal\u00e0"),
    ch("Chamorro", "Chamoru"),
    co("Corsican", "corsu; lingua corsa"),
    cr("Cree", "\u14c0\u1426\u1403\u152d\u140d\u140f\u1423"),
    cs("Czech", "\u010desky; \u010de\u0161tina"),
    cu("Church Slavic", "\u0469\u0437\u044b\u043a\u044a \u0441\u043b\u043e\u0432\u0463\u043d\u044c\u0441\u043a\u044a"),
    cv("Chuvash", "\u0447\u04d1\u0432\u0430\u0448 \u0447\u04d7\u043b\u0445\u0438"),
    cy("Welsh", "Cymraeg"),
    da("Danish", "Dansk"),
    de("German", "Deutsch"),
    dv("Divehi", "\u078b\u07a8\u0788\u07ac\u0780\u07a8"),
    dz("Dzongkha", "\u0f62\u0fab\u0f7c\u0f44\u0f0b\u0f41"),
    ee("Ewe", "\u0190\u028b\u025bgb\u025b"),
    el("Greek", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac"),
    en("English", "English"),
    eo("Esperanto", "Esperanto"),
    es("Spanish", "Espa\u00f1ol"),
    et("Estonian", "eesti; eesti keel"),
    eu("Basque", "euskara; euskera"),
    fa("Persian", "\u0641\u0627\u0631\u0633\u06cc"),
    ff("Fulah", "Fulfulde"),
    fi("Finnish", "suomi; suomen kieli"),
    fj("Fijian", "vosa Vakaviti"),
    fo("Faroese", "F\u00f8royskt"),
    fr("French", "Fran\u00e7ais"),
    fy("Western Frisian", "Frysk"),
    ga("Irish", "Gaeilge"),
    gd("Scottish Gaelic", "G\u00e0idhlig"),
    gl("Galician", "Galego"),
    gn("Guaran\u00ed", "Ava\u00f1e'\u1ebd"),
    gu("Gujarati", "\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0"),
    gv("Manx", "Gaelg, Gailck"),
    ha("Hausa", "\u0647\u064e\u0648\u064f\u0633\u064e"),
    he("Hebrew", "\u05e2\u05d1\u05e8\u05d9\u05ea"),
    hi("Hindi", "\u0939\u093f\u0928\u094d\u0926\u0940; \u0939\u093f\u0902\u0926\u0940"),
    ho("Hiri Motu", "Hiri Motu"),
    hr("Croatian", "Hrvatski"),
    ht("Haitian", "Krey\u00f2l ayisyen"),
    hu("Hungarian", "Magyar"),
    hy("Armenian", "\u0540\u0561\u0575\u0565\u0580\u0565\u0576"),
    hz("Herero", "Otjiherero"),
    ia("Interlingua (International Auxiliary Language Association)", "Interlingua"),
    id("Indonesian", "Bahasa Indonesia"),
    ie("Interlingue", "Interlingue"),
    ig("Igbo", "Igbo"),
    ii("Sichuan Yi", "\ua187\ua259"),
    ik("Inupiaq", "I\u00f1upiaq; I\u00f1upiatun"),
    io("Ido", "Ido"),
    is("Icelandic", "\u00cdslenska"),
    it("Italian", "Italiano"),
    iu("Inuktitut", "\u1403\u14c4\u1483\u144e\u1450\u1466"),
    ja("Japanese", "Nihongo"),
    ka("Georgian", "\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8"),
    kg("Kongo", "KiKongo"),
    ki("Kikuyu", "G\u0129k\u0169y\u0169"),
    kj("Kwanyama", "Kuanyama"),
    ku("Kurdish", "\u0643\u0648\u0631\u062f\u06cc"),
    kk("Kazakh", "\u049a\u0430\u0437\u0430\u049b \u0442\u0456\u043b\u0456"),
    kl("Kalaallisut", "kalaallisut; kalaallit oqaasii"),
    km("Khmer", "\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a"),
    kn("Kannada", "\u0c95\u0ca8\u0ccd\u0ca8\u0ca1"),
    ko("Korean", "Kanuri"),
    ks("Kashmiri", "\u043a\u043e\u043c\u0438 \u043a\u044b\u0432"),
    kw("Cornish", "Kernewek"),
    ky("Kirghiz", "\u043a\u044b\u0440\u0433\u044b\u0437 \u0442\u0438\u043b\u0438"),
    la("Latin", "Latine; lingua latina"),
    lb("Luxembourgish", "L\u00ebtzebuergesch"),
    lg("Ganda", "Luganda"),
    li("Limburgish", "Limburgs"),
    ln("Lingala", "Ling\u00e1la"),
    lo("Lao", "\u0e9e\u0eb2\u0eaa\u0eb2\u0ea5\u0eb2\u0ea7"),
    lt("Lithuanian", "Lietuvi\u0173 kalba"),
    lu("Luba-Katanga", "Latvie\u0161u valoda"),
    mg("Malagasy", "Malagasy fiteny"),
    mh("Marshallese", "Kajin M\u0327aje\u013c"),
    mi("M\u0101ori", "Te reo M\u0101ori"),
    mk("Macedonian", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438 \u0458\u0430\u0437\u0438\u043a"),
    ml("Malayalam", "\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02"),
    mn("Mongolian", "\u041c\u043e\u043d\u0433\u043e\u043b"),
    mr("Marathi", "\u092e\u0930\u093e\u0920\u0940"),
    ms("Malay", "\u0628\u0647\u0627\u0633 \u0645\u0644\u0627\u064a\u0648"),
    mt("Maltese", "Malti"),
    my("Burmese", "\u1017\u1019\u102c\u1005\u102c"),
    na("Nauru", "Ekakair\u0169 Naoero"),
    nb("Norwegian Bokm\u00e5l", "Norsk bokm\u00e5l"),
    nd("North Ndebele", "isiNdebele"),
    ne("Nepali", "\u0928\u0947\u092a\u093e\u0932\u0940"),
    ng("Ndonga", "Owambo"),
    nl("Dutch", "Nederlands"),
    nn("Norwegian Nynorsk", "Norsk nynorsk"),
    no("Norwegian", "Norsk"),
    nr("South Ndebele", "isiNdebele"),
    nv("Navajo", "Din\u00e9 bizaad; Din\u00e9k\u02bceh\u01f0\u00ed"),
    ny("Chichewa", "chiChe\u0175a; chinyanja"),
    oc("Occitan", "Occitan"),
    oj("Ojibwa", "\u140a\u14c2\u1511\u14c8\u142f\u14a7\u140e\u14d0"),
    om("Oromo", "Afaan Oromoo"),
    or("Oriya", "\u0b13\u0b21\u0b3c\u0b3f\u0b06"),
    os("Ossetian", "\u0418\u0440\u043e\u043d \u00e6\u0432\u0437\u0430\u0433"),
    pa("Panjabi", "\u092a\u093e\u0934\u093f"),
    pl("Polish", "Polski"),
    ps("Pashto", "\u067e\u069a\u062a\u0648"),
    pt("Portuguese", "Portugu\u00eas"),
    qu("Quechua", "Runa Simi; Kichwa"),
    rm("Raeto-Romance", "rumantsch grischun"),
    rn("Kirundi", "kiRundi"),
    ro("Romanian", "Rom\u00e2n\u0103"),
    ru("Russian", "\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u044f\u0437\u044b\u043a"),
    rw("Kinyarwanda", "Ikinyarwanda"),
    sa("Sanskrit", "\u0938\u0902\u0938\u094d\u0915\u0943\u0924\u092e\u094d"),
    sc("Sardinian", "sardu"),
    sd("Sindhi", "Davvis\u00e1megiella"),
    sg("Sango", "y\u00e2ng\u00e2 t\u00ee s\u00e4ng\u00f6"),
    si("Sinhala", "\u0dc3\u0dd2\u0d82\u0dc4\u0dbd"),
    sk("Slovak", "Sloven\u010dina"),
    sl("Slovenian", "Sloven\u0161\u010dina"),
    sm("Samoan", "gagana fa'a Samoa"),
    sn("Shona", "chiShona"),
    so("Somali", "Soomaaliga; af Soomaali"),
    sq("Albanian", "Shqip"),
    sr("Serbian", "\u0441\u0440\u043f\u0441\u043a\u0438 \u0458\u0435\u0437\u0438\u043a"),
    ss("Swati", "SiSwati"),
    st("Southern Sotho", "Sesotho"),
    su("Sundanese", "Basa Sunda"),
    sv("Swedish", "svenska"),
    sw("Swahili", "Kiswahili"),
    ta("Tamil", "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd"),
    te("Telugu", "\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41"),
    tg("Tajik", "\u0e44\u0e17\u0e22"),
    ti("Tigrinya", "\u1275\u130d\u122d\u129b"),
    tk("Turkmen", "T\u00fcrkmen; \u0422\u04af\u0440\u043a\u043c\u0435\u043d"),
    tn("Tswana", "Setswana"),
    to("Tonga", "faka Tonga"),
    tr("Turkish", "T\u00fcrk\u00e7e"),
    ts("Tsonga", "Xitsonga"),
    tt("Tatar", "Twi"),
    ty("Tahitian", "Reo M\u0101`ohi"),
    ug("Uighur", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"),
    ur("Urdu", "\u0627\u0631\u062f\u0648"),
    uk("Ukrainian", "Ukra\u00efna"),
    uz("Uzbek", "Tshiven\u1e13a"),
    vi("Vietnamese", "Ti\u1ebfng Vi\u1ec7t"),
    vo("Volap\u00fck", "Volap\u00fck"),
    wa("Walloon", "Walon"),
    wo("Wolof", "Wollof"),
    xh("Xhosa", "isiXhosa"),
    yi("Yiddish", "\u05d9\u05d9\u05b4\u05d3\u05d9\u05e9"),
    yo("Yoruba", "Yor\u00f9b\u00e1"),
    za("Zhuang", "Sa\u026f cue\u014b\u0185; Saw cuengh"),
    zh("Chinese", "\u4e2d\u6587 (Zh\u014dngw\u00e9n), \u6c49\u8bed, \u6f22\u8a9e"),
    zu("Zulu", "isiZulu");

    private final String readableName;
    private final String nativeName;

    private LanguageCode(String readableName, String nativeName) {
        this.readableName = readableName;
        this.nativeName = nativeName;
    }

    public String readableName() {
        return this.readableName;
    }

    public String nativeName() {
        return this.nativeName;
    }

    @NotNull
    public String getISO3Language() throws IllegalArgumentException {
        ULocale locale = new ULocale(this.name());
        String isocode = locale.getISO3Language();
        if (isocode.isEmpty()) {
            throw new IllegalArgumentException("Language code '" + this.name() + "' is empty");
        }
        return isocode;
    }

    public static LanguageCode fromNativeName(@NotNull String nativeName) throws IllegalArgumentException {
        for (LanguageCode item : LanguageCode.values()) {
            if (!item.nativeName.equals(nativeName)) continue;
            return item;
        }
        throw new IllegalArgumentException("Language code '" + nativeName + "' not found");
    }
}

