/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DirectionalityHelper {
    public static Directionality getDirectionality(Element element) {
        while (true) {
            Node node;
            String string;
            if ((string = element.getAttribute("dir")).length() != 0) {
                if ("rtl".equalsIgnoreCase(string)) {
                    return Directionality.RTL;
                }
                if ("ltr".equalsIgnoreCase(string)) break;
                if ("auto".equalsIgnoreCase(string)) {
                    return DirectionalityHelper.autoDirection(element);
                }
                if ("bdi".equals(element.getLocalName())) {
                    return DirectionalityHelper.bdiDirection(element);
                }
                if ("input".equals(element.getLocalName()) && "telephone".equalsIgnoreCase(element.getAttribute("type"))) {
                    break;
                }
            } else if ("bdi".equals(element.getLocalName())) {
                return DirectionalityHelper.bdiDirection(element);
            }
            if ((node = element.getParentNode()) == null || node.getNodeType() != 1) break;
            element = (Element)node;
        }
        return Directionality.LTR;
    }

    private static Directionality autoDirection(Element element) {
        String string = element.getLocalName();
        if ("textarea".equals(string)) {
            String string2 = element.getTextContent().trim();
            return DirectionalityHelper.valueDirection(element, string2);
        }
        if ("input".equals(string)) {
            String string3 = element.getAttribute("value");
            return DirectionalityHelper.valueDirection(element, string3);
        }
        byte by = DirectionalityHelper.descendantTextDirection(element);
        switch (by) {
            case 0: {
                return Directionality.LTR;
            }
            case 1: {
                return Directionality.RTL;
            }
        }
        return DirectionalityHelper.parentDirection(element);
    }

    private static Directionality bdiDirection(Element element) {
        byte by = DirectionalityHelper.descendantTextDirection(element);
        switch (by) {
            case 0: {
                return Directionality.LTR;
            }
            case 1: {
                return Directionality.RTL;
            }
        }
        return DirectionalityHelper.parentDirection(element);
    }

    private static byte descendantTextDirection(Element element) {
        block22: {
            if (!element.hasChildNodes()) break block22;
            NodeList nodeList = element.getChildNodes();
            if (nodeList instanceof Iterable) {
                for (Node node : (Iterable)((Object)nodeList)) {
                    switch (node.getNodeType()) {
                        case 1: {
                            byte by;
                            element = (Element)node;
                            String string = element.getLocalName();
                            if ("bdi".equals(string) || "script".equals(string) || "style".equals(string) || "textarea".equals(string) || DirectionalityHelper.hasLtrOrRtlDir(element) || (by = DirectionalityHelper.descendantTextDirection(element)) == -1) break;
                            return by;
                        }
                        case 3: 
                        case 4: {
                            String string = node.getNodeValue();
                            int n = string.length();
                            int n2 = 0;
                            while (n2 < n) {
                                int n3 = string.codePointAt(n2);
                                byte by = Character.getDirectionality(n3);
                                switch (by) {
                                    case 0: {
                                        return 0;
                                    }
                                    case 1: 
                                    case 2: {
                                        return 1;
                                    }
                                }
                                n2 = string.offsetByCodePoints(n2, 1);
                            }
                            break;
                        }
                    }
                }
            } else {
                block18: for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    switch (node.getNodeType()) {
                        case 1: {
                            byte by;
                            element = (Element)node;
                            String string = element.getLocalName();
                            if ("bdi".equals(string) || "script".equals(string) || "style".equals(string) || "textarea".equals(string) || DirectionalityHelper.hasLtrOrRtlDir(element) || (by = DirectionalityHelper.descendantTextDirection(element)) == -1) continue block18;
                            return by;
                        }
                        case 3: 
                        case 4: {
                            String string = node.getNodeValue();
                            int n = string.length();
                            int n4 = 0;
                            while (n4 < n) {
                                int n5 = string.codePointAt(n4);
                                byte by = Character.getDirectionality(n5);
                                switch (by) {
                                    case 0: {
                                        return 0;
                                    }
                                    case 1: 
                                    case 2: {
                                        return 1;
                                    }
                                }
                                n4 = string.offsetByCodePoints(n4, 1);
                            }
                            continue block18;
                        }
                    }
                }
            }
        }
        return -1;
    }

    private static boolean hasLtrOrRtlDir(Element element) {
        String string = element.getAttribute("dir");
        return "ltr".equalsIgnoreCase(string) || "rtl".equalsIgnoreCase(string);
    }

    private static Directionality parentDirection(Element element) {
        Node node = element.getParentNode();
        if (node != null && node.getNodeType() == 1) {
            return DirectionalityHelper.getDirectionality((Element)node);
        }
        return Directionality.LTR;
    }

    private static Directionality valueDirection(Element element, String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.codePointAt(n2);
            byte by = Character.getDirectionality(n3);
            switch (by) {
                case 0: {
                    return Directionality.LTR;
                }
                case 1: 
                case 2: {
                    return Directionality.RTL;
                }
            }
            n2 = string.offsetByCodePoints(n2, 1);
        }
        return DirectionalityHelper.parentDirection(element);
    }

    public static enum Directionality {
        LTR,
        RTL;

    }
}

