﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/deadline/Deadline_EXPORTS.h>
#include <aws/deadline/model/LicenseEndpointStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace deadline {
namespace Model {

/**
 * <p>The details for a license endpoint.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/LicenseEndpointSummary">AWS
 * API Reference</a></p>
 */
class LicenseEndpointSummary {
 public:
  AWS_DEADLINE_API LicenseEndpointSummary() = default;
  AWS_DEADLINE_API LicenseEndpointSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API LicenseEndpointSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The license endpoint ID.</p>
   */
  inline const Aws::String& GetLicenseEndpointId() const { return m_licenseEndpointId; }
  inline bool LicenseEndpointIdHasBeenSet() const { return m_licenseEndpointIdHasBeenSet; }
  template <typename LicenseEndpointIdT = Aws::String>
  void SetLicenseEndpointId(LicenseEndpointIdT&& value) {
    m_licenseEndpointIdHasBeenSet = true;
    m_licenseEndpointId = std::forward<LicenseEndpointIdT>(value);
  }
  template <typename LicenseEndpointIdT = Aws::String>
  LicenseEndpointSummary& WithLicenseEndpointId(LicenseEndpointIdT&& value) {
    SetLicenseEndpointId(std::forward<LicenseEndpointIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the license endpoint.</p>
   */
  inline LicenseEndpointStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(LicenseEndpointStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline LicenseEndpointSummary& WithStatus(LicenseEndpointStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status message of the license endpoint.</p>
   */
  inline const Aws::String& GetStatusMessage() const { return m_statusMessage; }
  inline bool StatusMessageHasBeenSet() const { return m_statusMessageHasBeenSet; }
  template <typename StatusMessageT = Aws::String>
  void SetStatusMessage(StatusMessageT&& value) {
    m_statusMessageHasBeenSet = true;
    m_statusMessage = std::forward<StatusMessageT>(value);
  }
  template <typename StatusMessageT = Aws::String>
  LicenseEndpointSummary& WithStatusMessage(StatusMessageT&& value) {
    SetStatusMessage(std::forward<StatusMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The VCP(virtual private cloud) ID associated with the license endpoint.</p>
   */
  inline const Aws::String& GetVpcId() const { return m_vpcId; }
  inline bool VpcIdHasBeenSet() const { return m_vpcIdHasBeenSet; }
  template <typename VpcIdT = Aws::String>
  void SetVpcId(VpcIdT&& value) {
    m_vpcIdHasBeenSet = true;
    m_vpcId = std::forward<VpcIdT>(value);
  }
  template <typename VpcIdT = Aws::String>
  LicenseEndpointSummary& WithVpcId(VpcIdT&& value) {
    SetVpcId(std::forward<VpcIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_licenseEndpointId;
  bool m_licenseEndpointIdHasBeenSet = false;

  LicenseEndpointStatus m_status{LicenseEndpointStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::String m_statusMessage;
  bool m_statusMessageHasBeenSet = false;

  Aws::String m_vpcId;
  bool m_vpcIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace deadline
}  // namespace Aws
