// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "ImageProperty.h"

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::ImagePropertyPrivate
{
public:
    std::optional<QImage> imageData;
    std::optional<qreal> width;
    std::optional<qreal> height;
    std::optional<qreal> xOffset;
    std::optional<qreal> yOffset;
    std::optional<Union::Properties::ImageFlags> flags;
};

ImageProperty::ImageProperty()
    : d(std::make_unique<ImagePropertyPrivate>())
{
}

ImageProperty::ImageProperty(const ImageProperty &other)
    : d(std::make_unique<ImagePropertyPrivate>())
{
    d->imageData = other.d->imageData;
    d->width = other.d->width;
    d->height = other.d->height;
    d->xOffset = other.d->xOffset;
    d->yOffset = other.d->yOffset;
    d->flags = other.d->flags;
}

ImageProperty::ImageProperty(ImageProperty &&other)
    : d(std::move(other.d))
{
}

ImageProperty::~ImageProperty() = default;

ImageProperty &ImageProperty::operator=(const ImageProperty &other)
{
    if (this != &other) {
        d->imageData = other.d->imageData;
        d->width = other.d->width;
        d->height = other.d->height;
        d->xOffset = other.d->xOffset;
        d->yOffset = other.d->yOffset;
        d->flags = other.d->flags;
    }
    return *this;
}

ImageProperty &ImageProperty::operator=(ImageProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<QImage> ImageProperty::imageData() const
{
    return d->imageData;
}

void ImageProperty::setImageData(const std::optional<QImage> &newValue)
{
    if (newValue == d->imageData) {
        return;
    }

    d->imageData = newValue;
}
std::optional<qreal> ImageProperty::width() const
{
    return d->width;
}

void ImageProperty::setWidth(const std::optional<qreal> &newValue)
{
    if (newValue == d->width) {
        return;
    }

    d->width = newValue;
}
std::optional<qreal> ImageProperty::height() const
{
    return d->height;
}

void ImageProperty::setHeight(const std::optional<qreal> &newValue)
{
    if (newValue == d->height) {
        return;
    }

    d->height = newValue;
}
std::optional<qreal> ImageProperty::xOffset() const
{
    return d->xOffset;
}

void ImageProperty::setXOffset(const std::optional<qreal> &newValue)
{
    if (newValue == d->xOffset) {
        return;
    }

    d->xOffset = newValue;
}
std::optional<qreal> ImageProperty::yOffset() const
{
    return d->yOffset;
}

void ImageProperty::setYOffset(const std::optional<qreal> &newValue)
{
    if (newValue == d->yOffset) {
        return;
    }

    d->yOffset = newValue;
}
std::optional<Union::Properties::ImageFlags> ImageProperty::flags() const
{
    return d->flags;
}

void ImageProperty::setFlags(const std::optional<Union::Properties::ImageFlags> &newValue)
{
    if (newValue == d->flags) {
        return;
    }

    d->flags = newValue;
}

bool ImageProperty::hasAnyValue() const
{
    if (d->imageData.has_value()) {
        return true;
    }
    if (d->width.has_value()) {
        return true;
    }
    if (d->height.has_value()) {
        return true;
    }
    if (d->xOffset.has_value()) {
        return true;
    }
    if (d->yOffset.has_value()) {
        return true;
    }
    if (d->flags.has_value()) {
        return true;
    }
    return false;
}

void ImageProperty::resolveProperties(const ImageProperty &source, ImageProperty &destination)
{
    if (!destination.d->imageData.has_value()) {
        destination.d->imageData = source.d->imageData;
    }
    if (!destination.d->width.has_value()) {
        destination.d->width = source.d->width;
    }
    if (!destination.d->height.has_value()) {
        destination.d->height = source.d->height;
    }
    if (!destination.d->xOffset.has_value()) {
        destination.d->xOffset = source.d->xOffset;
    }
    if (!destination.d->yOffset.has_value()) {
        destination.d->yOffset = source.d->yOffset;
    }
    if (!destination.d->flags.has_value()) {
        destination.d->flags = source.d->flags;
    }
}

ImageProperty ImageProperty::empty()
{
    ImageProperty result;
    result.d->imageData = emptyValue<QImage>();
    result.d->width = emptyValue<qreal>();
    result.d->height = emptyValue<qreal>();
    result.d->xOffset = emptyValue<qreal>();
    result.d->yOffset = emptyValue<qreal>();
    result.d->flags = emptyValue<Union::Properties::ImageFlags>();
    return result;
}

bool Union::Properties::operator==(const ImageProperty &left, const ImageProperty &right)
{
    if (left.imageData() != right.imageData()) {
        return false;
    }
    if (left.width() != right.width()) {
        return false;
    }
    if (left.height() != right.height()) {
        return false;
    }
    if (left.xOffset() != right.xOffset()) {
        return false;
    }
    if (left.yOffset() != right.yOffset()) {
        return false;
    }
    if (left.flags() != right.flags()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, const Union::Properties::ImageProperty &type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << "ImageProperty(" //
                    << "imageData: " << type.imageData() //
                    << ", width: " << type.width() //
                    << ", height: " << type.height() //
                    << ", xOffset: " << type.xOffset() //
                    << ", yOffset: " << type.yOffset() //
                    << ", flags: " << type.flags() //
                    << ")";
    return debug;
}