/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.word;

import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.Word;
import org.graalvm.word.WordBase;
import org.graalvm.word.impl.WordFactoryOpcode;
import org.graalvm.word.impl.WordFactoryOperation;

public final class WordFactory {
    private WordFactory() {
    }

    @WordFactoryOperation(opcode=WordFactoryOpcode.ZERO)
    public static <T extends WordBase> T zero() {
        return Word.box(0L);
    }

    @WordFactoryOperation(opcode=WordFactoryOpcode.ZERO)
    public static <T extends PointerBase> T nullPointer() {
        return (T)((PointerBase)Word.box(0L));
    }

    @WordFactoryOperation(opcode=WordFactoryOpcode.FROM_UNSIGNED)
    public static <T extends UnsignedWord> T unsigned(long val) {
        return (T)((UnsignedWord)Word.box(val));
    }

    @WordFactoryOperation(opcode=WordFactoryOpcode.FROM_UNSIGNED)
    public static <T extends PointerBase> T pointer(long val) {
        return (T)((PointerBase)Word.box(val));
    }

    @WordFactoryOperation(opcode=WordFactoryOpcode.FROM_UNSIGNED)
    public static <T extends UnsignedWord> T unsigned(int val) {
        return (T)((UnsignedWord)Word.box((long)val & 0xFFFFFFFFL));
    }

    @WordFactoryOperation(opcode=WordFactoryOpcode.FROM_SIGNED)
    public static <T extends SignedWord> T signed(long val) {
        return (T)((SignedWord)Word.box(val));
    }

    @WordFactoryOperation(opcode=WordFactoryOpcode.FROM_SIGNED)
    public static <T extends SignedWord> T signed(int val) {
        return (T)((SignedWord)Word.box(val));
    }
}

