/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Locale;

public class ExtraTimeStrings {
    private static final String[] extraParsingFormatsForLanguage_en = new String[]{"h:ma", "h.ma", "ha"};

    public static ArrayList<DateTimeFormatter> getExtraTimeParsingFormatsForLocale(Locale locale) {
        String language = locale.getLanguage();
        String[] definedFormats = null;
        if ("en".equals(language)) {
            definedFormats = extraParsingFormatsForLanguage_en;
        }
        ArrayList<DateTimeFormatter> extraParsingFormatters = new ArrayList<DateTimeFormatter>();
        if (definedFormats == null) {
            return extraParsingFormatters;
        }
        for (String formatString : definedFormats) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(formatString).toFormatter(locale);
            extraParsingFormatters.add(formatter);
        }
        return extraParsingFormatters;
    }

    public static DateTimeFormatter getDefaultFormatForDisplayTime(Locale locale) {
        DateTimeFormatter format = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendLocalized(null, FormatStyle.SHORT).toFormatter(locale);
        String language = locale.getLanguage();
        if ("en".equals(language)) {
            format = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern("h:mma").toFormatter(locale);
        }
        return format;
    }

    public static DateTimeFormatter getDefaultFormatForMenuTimes(Locale locale) {
        return ExtraTimeStrings.getDefaultFormatForDisplayTime(locale);
    }
}

