# - Config file for the rocdecode-host package
# It defines the following variables
#  use rocdecode-host_INCLUDE_DIR  - include directory for rocdecode-host
#  use rocdecode-host_LIB_DIR      - library directory for rocdecode-host
#  use rocdecode-host_LIBRARY      - library to link against
#  use rocdecode-host_LIBRARIES    - library to link against

# compute paths
get_filename_component(rocdecode-host_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

# version
include(${CMAKE_CURRENT_LIST_DIR}/rocdecode-host-config-version.cmake)
set(rocdecode-host_VERSION ${PACKAGE_VERSION})

# targets
include(${CMAKE_CURRENT_LIST_DIR}/rocdecode-host-targets.cmake)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was rocdecode-host-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(rocdecode-host_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(rocdecode-host_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
set_and_check(rocdecode-host_LIBRARY "${PACKAGE_PREFIX_DIR}/lib/librocdecode-host.so")
set_and_check(rocdecode-host_LIBRARIES "${PACKAGE_PREFIX_DIR}/lib/librocdecode-host.so")

if(NOT TARGET rocdecode::rocdecode-host)
  add_library(rocdecode::rocdecode-host INTERFACE IMPORTED)
  set_target_properties(rocdecode::rocdecode-host PROPERTIES INTERFACE_LINK_LIBRARIES ${rocdecode-host_LIBRARY})
endif ()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    rocdecode-host
    FOUND_VAR rocdecode-host_FOUND
    REQUIRED_VARS rocdecode-host_INCLUDE_DIR rocdecode-host_LIB_DIR rocdecode-host_LIBRARY rocdecode-host_LIBRARIES
    VERSION_VAR rocdecode-host_VERSION
    HANDLE_COMPONENTS)
