// java wrapper for vtkTesting object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTesting.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTesting_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTesting",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTesting_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTesting_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_FrontBufferOn_14(JNIEnv* env, jobject obj)
{

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->FrontBufferOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_FrontBufferOff_15(JNIEnv* env, jobject obj)
{

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->FrontBufferOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_GetFrontBuffer_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrontBuffer();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_SetFrontBuffer_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrontBuffer(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_RegressionTest_18(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  int   temp20;
  temp0 = id0;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RegressionTest(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_RegressionTest_19(JNIEnv* env, jobject obj,jdouble id0, jbyteArray id1, jint len1)
{
  double   temp0;
  std::string temp1;
  int   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RegressionTest(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_RegressionTest_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdouble id1)
{
  std::string temp0;
  double   temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = id1;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RegressionTest(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_RegressionTest_111(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdouble id1, jbyteArray id2, jint len2)
{
  std::string temp0;
  double   temp1;
  std::string temp2;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = id1;
  temp2 = vtkJavaUTF8ToString(env, id2, len2);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RegressionTest(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_RegressionTest_112(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkAlgorithm * temp0;
  double   temp1;
  int   temp20;
  temp0 = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RegressionTest(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_RegressionTest_113(JNIEnv* env, jobject obj,jobject id0,jdouble id1, jbyteArray id2, jint len2)
{
  vtkAlgorithm * temp0;
  double   temp1;
  std::string temp2;
  int   temp20;
  temp0 = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = vtkJavaUTF8ToString(env, id2, len2);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RegressionTest(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_CompareAverageOfL2Norm_114(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdouble id2)
{
  vtkDataSet * temp0;
  vtkDataSet * temp1;
  double   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CompareAverageOfL2Norm(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_CompareAverageOfL2Norm_115(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdouble id2)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  double   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CompareAverageOfL2Norm(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_SetRenderWindow_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderWindow(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTesting_GetRenderWindow_117(JNIEnv* env, jobject obj)
{
  vtkRenderWindow * temp20;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTesting_GetMesaVersion_118(JNIEnv* env, jobject obj,jobject id0,jintArray id1)
{
  vtkRenderWindow * temp0;
  int temp1[3];
  bool   temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMesaVersion(temp0,temp1);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_SetValidImageFileName_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValidImageFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTesting_GetValidImageFileName_120(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValidImageFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTesting_GetImageDifference_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageDifference();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_AddArgument_122(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddArgument(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTesting_GetArgument_123(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  char * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArgument(temp0);
  delete[] temp0;
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_CleanArguments_124(JNIEnv* env, jobject obj)
{

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->CleanArguments();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTesting_GetDataRoot_125(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataRoot();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_SetDataRoot_126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataRoot(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTesting_GetTempDirectory_127(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTempDirectory();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_SetTempDirectory_128(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTempDirectory(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_IsValidImageSpecified_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsValidImageSpecified();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_IsInteractiveModeSpecified_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInteractiveModeSpecified();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_IsFlagSpecified_131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsFlagSpecified(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_SetBorderOffset_132(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderOffset(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_GetBorderOffset_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_SetVerbose_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerbose(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTesting_GetVerbose_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerbose();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTesting_GetController_136(JNIEnv* env, jobject obj)
{
  vtkMultiProcessController * temp20;

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetController();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTesting_SetController_137(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMultiProcessController * temp0;
  temp0 = static_cast<vtkMultiProcessController*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTesting* op = static_cast<vtkTesting*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetController(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTesting_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTesting::New());
}
