// java wrapper for vtkGeoMath object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGeoMath.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGeoMath_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGeoMath",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeoMath_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeoMath* op = static_cast<vtkGeoMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeoMath_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeoMath* op = static_cast<vtkGeoMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeoMath_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeoMath* op = static_cast<vtkGeoMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeoMath_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeoMath* op = static_cast<vtkGeoMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGeoMath_EarthRadiusMeters_14(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGeoMath* op = static_cast<vtkGeoMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EarthRadiusMeters();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGeoMath_DistanceSquared_15(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkGeoMath* op = static_cast<vtkGeoMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DistanceSquared(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeoMath_LongLatAltToRect_16(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkGeoMath* op = static_cast<vtkGeoMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->LongLatAltToRect(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGeoMath_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGeoMath::New());
}
