// java wrapper for vtkIOSSWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkIOSSWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkIOSSWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkIOSSWriter",dType)) { return me; }
  if ((res= vtkWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSWriter_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetAssemblyName_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAssemblyName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSWriter_GetAssemblyName_17(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssemblyName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetChooseFieldsToWrite_18(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetChooseFieldsToWrite(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_GetChooseFieldsToWrite_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChooseFieldsToWrite();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_ChooseFieldsToWriteOn_110(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ChooseFieldsToWriteOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_ChooseFieldsToWriteOff_111(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ChooseFieldsToWriteOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_AddSelector_112(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  vtkIOSSReader::EntityType   temp0;
  char * temp1;
  bool   temp20;
  temp0 = static_cast<vtkIOSSReader::EntityType>(id0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddSelector(temp0,temp1);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_ClearSelectors_113(JNIEnv* env, jobject obj,jint id0)
{
  vtkIOSSReader::EntityType   temp0;
  temp0 = static_cast<vtkIOSSReader::EntityType>(id0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearSelectors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetSelector_114(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  vtkIOSSReader::EntityType   temp0;
  char * temp1;
  temp0 = static_cast<vtkIOSSReader::EntityType>(id0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelector(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetNumberOfSelectors_115(JNIEnv* env, jobject obj,jint id0)
{
  vtkIOSSReader::EntityType   temp0;
  int   temp20;
  temp0 = static_cast<vtkIOSSReader::EntityType>(id0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSelectors(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSWriter_GetSelector_116(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  vtkIOSSReader::EntityType   temp0;
  int   temp1;
  const char * temp20;
  temp0 = static_cast<vtkIOSSReader::EntityType>(id0);
  temp1 = id1;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelector(temp0,temp1);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetFieldSelection_117(JNIEnv* env, jobject obj,jint id0)
{
  vtkIOSSReader::EntityType   temp0;
  vtkDataArraySelection * temp20;
  temp0 = static_cast<vtkIOSSReader::EntityType>(id0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldSelection(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetNodeBlockFieldSelection_118(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeBlockFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_AddEdgeBlockSelector_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddEdgeBlockSelector(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_ClearEdgeBlockSelectors_120(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearEdgeBlockSelectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetEdgeBlockSelector_121(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeBlockSelector(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetNumberOfEdgeBlockSelectors_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdgeBlockSelectors();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSWriter_GetEdgeBlockSelector_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeBlockSelector(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetEdgeBlockFieldSelection_124(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeBlockFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_AddFaceBlockSelector_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddFaceBlockSelector(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_ClearFaceBlockSelectors_126(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearFaceBlockSelectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetFaceBlockSelector_127(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFaceBlockSelector(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetNumberOfFaceBlockSelectors_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaceBlockSelectors();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSWriter_GetFaceBlockSelector_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceBlockSelector(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetFaceBlockFieldSelection_130(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceBlockFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_AddElementBlockSelector_131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddElementBlockSelector(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_ClearElementBlockSelectors_132(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearElementBlockSelectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetElementBlockSelector_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElementBlockSelector(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetNumberOfElementBlockSelectors_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElementBlockSelectors();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSWriter_GetElementBlockSelector_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementBlockSelector(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetElementBlockFieldSelection_136(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementBlockFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_AddNodeSetSelector_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddNodeSetSelector(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_ClearNodeSetSelectors_138(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearNodeSetSelectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetNodeSetSelector_139(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNodeSetSelector(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetNumberOfNodeSetSelectors_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNodeSetSelectors();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSWriter_GetNodeSetSelector_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeSetSelector(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetNodeSetFieldSelection_142(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeSetFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_AddEdgeSetSelector_143(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddEdgeSetSelector(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_ClearEdgeSetSelectors_144(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearEdgeSetSelectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetEdgeSetSelector_145(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeSetSelector(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetNumberOfEdgeSetSelectors_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdgeSetSelectors();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSWriter_GetEdgeSetSelector_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSetSelector(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetEdgeSetFieldSelection_148(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSetFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_AddFaceSetSelector_149(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddFaceSetSelector(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_ClearFaceSetSelectors_150(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearFaceSetSelectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetFaceSetSelector_151(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFaceSetSelector(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetNumberOfFaceSetSelectors_152(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaceSetSelectors();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSWriter_GetFaceSetSelector_153(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceSetSelector(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetFaceSetFieldSelection_154(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceSetFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_AddElementSetSelector_155(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddElementSetSelector(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_ClearElementSetSelectors_156(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearElementSetSelectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetElementSetSelector_157(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElementSetSelector(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetNumberOfElementSetSelectors_158(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElementSetSelectors();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSWriter_GetElementSetSelector_159(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementSetSelector(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetElementSetFieldSelection_160(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementSetFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_AddSideSetSelector_161(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddSideSetSelector(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_ClearSideSetSelectors_162(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearSideSetSelectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetSideSetSelector_163(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSideSetSelector(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetNumberOfSideSetSelectors_164(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSideSetSelectors();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkIOSSWriter_GetSideSetSelector_165(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSideSetSelector(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetSideSetFieldSelection_166(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSideSetFieldSelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetRemoveGhosts_167(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRemoveGhosts(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_GetRemoveGhosts_168(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRemoveGhosts();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetOffsetGlobalIds_169(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOffsetGlobalIds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_GetOffsetGlobalIds_170(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffsetGlobalIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_OffsetGlobalIdsOn_171(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->OffsetGlobalIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_OffsetGlobalIdsOff_172(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->OffsetGlobalIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetPreserveOriginalIds_173(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPreserveOriginalIds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_GetPreserveOriginalIds_174(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPreserveOriginalIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_PreserveOriginalIdsOn_175(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->PreserveOriginalIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_PreserveOriginalIdsOff_176(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->PreserveOriginalIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetWriteQAAndInformationRecords_177(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWriteQAAndInformationRecords(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkIOSSWriter_GetWriteQAAndInformationRecords_178(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWriteQAAndInformationRecords();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_WriteQAAndInformationRecordsOn_179(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteQAAndInformationRecordsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_WriteQAAndInformationRecordsOff_180(JNIEnv* env, jobject obj)
{

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteQAAndInformationRecordsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetDisplacementMagnitude_181(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplacementMagnitude(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkIOSSWriter_GetDisplacementMagnitudeMinValue_182(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplacementMagnitudeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkIOSSWriter_GetDisplacementMagnitudeMaxValue_183(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplacementMagnitudeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkIOSSWriter_GetDisplacementMagnitude_184(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplacementMagnitude();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetTimeStepRange_185(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStepRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetTimeStepRange_186(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStepRange(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkIOSSWriter_GetTimeStepRange_187(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStepRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetTimeStepStride_188(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStepStride(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetTimeStepStrideMinValue_189(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStepStrideMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetTimeStepStrideMaxValue_190(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStepStrideMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIOSSWriter_GetTimeStepStride_191(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStepStride();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIOSSWriter_SetController_192(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMultiProcessController * temp0;
  temp0 = static_cast<vtkMultiProcessController*>(vtkJavaGetPointerFromObject(env, id0));

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetController(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIOSSWriter_GetController_193(JNIEnv* env, jobject obj)
{
  vtkMultiProcessController * temp20;

  vtkIOSSWriter* op = static_cast<vtkIOSSWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetController();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkIOSSWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkIOSSWriter::New());
}
