// java wrapper for vtkURI object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkURI.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkURI_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkURI",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkURI_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkURI_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkURI_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkURI_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkURI_PercentEncode_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  std::string   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PercentEncode(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkURI_PercentDecode_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  std::string   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PercentDecode(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkURI_IsReference_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsReference();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkURI_IsRelative_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsRelative();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkURI_IsAbsolute_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsAbsolute();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkURI_IsFull_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsFull();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkURI_IsSameDocRef_110(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSameDocRef();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkURI_IsEmpty_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsEmpty();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkURI_ToString_112(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkURI* op = static_cast<vtkURI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ToString();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkURI_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkURI::New());
}
