// python wrapper for vtkBoostBreadthFirstSearchTree
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkStdString.h"
#include "vtkBoostBreadthFirstSearchTree.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkBoostBreadthFirstSearchTree(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkBoostBreadthFirstSearchTree_ClassNew(); }


static PyObject *
PyvtkBoostBreadthFirstSearchTree_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkBoostBreadthFirstSearchTree::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkBoostBreadthFirstSearchTree::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkBoostBreadthFirstSearchTree *tempr = vtkBoostBreadthFirstSearchTree::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkBoostBreadthFirstSearchTree *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkBoostBreadthFirstSearchTree::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkBoostBreadthFirstSearchTree::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkBoostBreadthFirstSearchTree::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_SetOriginVertex_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOriginVertex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOriginVertex(temp0);
    }
    else
    {
      op->vtkBoostBreadthFirstSearchTree::SetOriginVertex(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkBoostBreadthFirstSearchTree_SetOriginVertex_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOriginVertex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  vtkStdString temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant"))
  {
    if (ap.IsBound())
    {
      op->SetOriginVertex(temp0, *temp1);
    }
    else
    {
      op->vtkBoostBreadthFirstSearchTree::SetOriginVertex(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}

static PyObject *
PyvtkBoostBreadthFirstSearchTree_SetOriginVertex(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkBoostBreadthFirstSearchTree_SetOriginVertex_s1(self, args);
    case 2:
      return PyvtkBoostBreadthFirstSearchTree_SetOriginVertex_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetOriginVertex");
  return nullptr;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_SetCreateGraphVertexIdArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCreateGraphVertexIdArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCreateGraphVertexIdArray(temp0);
    }
    else
    {
      op->vtkBoostBreadthFirstSearchTree::SetCreateGraphVertexIdArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_GetCreateGraphVertexIdArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCreateGraphVertexIdArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCreateGraphVertexIdArray() :
      op->vtkBoostBreadthFirstSearchTree::GetCreateGraphVertexIdArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_CreateGraphVertexIdArrayOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateGraphVertexIdArrayOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CreateGraphVertexIdArrayOn();
    }
    else
    {
      op->vtkBoostBreadthFirstSearchTree::CreateGraphVertexIdArrayOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_CreateGraphVertexIdArrayOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateGraphVertexIdArrayOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CreateGraphVertexIdArrayOff();
    }
    else
    {
      op->vtkBoostBreadthFirstSearchTree::CreateGraphVertexIdArrayOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_SetReverseEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReverseEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReverseEdges(temp0);
    }
    else
    {
      op->vtkBoostBreadthFirstSearchTree::SetReverseEdges(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_GetReverseEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReverseEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetReverseEdges() :
      op->vtkBoostBreadthFirstSearchTree::GetReverseEdges());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_ReverseEdgesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReverseEdgesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReverseEdgesOn();
    }
    else
    {
      op->vtkBoostBreadthFirstSearchTree::ReverseEdgesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearchTree_ReverseEdgesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReverseEdgesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearchTree *op = static_cast<vtkBoostBreadthFirstSearchTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReverseEdgesOff();
    }
    else
    {
      op->vtkBoostBreadthFirstSearchTree::ReverseEdgesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkBoostBreadthFirstSearchTree_Methods[] = {
  {"IsTypeOf", PyvtkBoostBreadthFirstSearchTree_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkBoostBreadthFirstSearchTree_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkBoostBreadthFirstSearchTree_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkBoostBreadthFirstSearchTree\nC++: static vtkBoostBreadthFirstSearchTree *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkBoostBreadthFirstSearchTree_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkBoostBreadthFirstSearchTree\nC++: vtkBoostBreadthFirstSearchTree *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkBoostBreadthFirstSearchTree_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkBoostBreadthFirstSearchTree_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetOriginVertex", PyvtkBoostBreadthFirstSearchTree_SetOriginVertex, METH_VARARGS,
   "SetOriginVertex(self, index:int) -> None\nC++: void SetOriginVertex(vtkIdType index)\nSetOriginVertex(self, arrayName:str, value:vtkVariant) -> None\nC++: void SetOriginVertex(vtkStdString arrayName,\n    vtkVariant value)\n\nSet the index (into the vertex array) of the breadth first search\n'origin' vertex.\n"},
  {"SetCreateGraphVertexIdArray", PyvtkBoostBreadthFirstSearchTree_SetCreateGraphVertexIdArray, METH_VARARGS,
   "SetCreateGraphVertexIdArray(self, _arg:bool) -> None\nC++: virtual void SetCreateGraphVertexIdArray(bool _arg)\n\nStores the graph vertex ids for the tree vertices in an array\nnamed \"GraphVertexId\".  Default is off.\n"},
  {"GetCreateGraphVertexIdArray", PyvtkBoostBreadthFirstSearchTree_GetCreateGraphVertexIdArray, METH_VARARGS,
   "GetCreateGraphVertexIdArray(self) -> bool\nC++: virtual bool GetCreateGraphVertexIdArray()\n\n"},
  {"CreateGraphVertexIdArrayOn", PyvtkBoostBreadthFirstSearchTree_CreateGraphVertexIdArrayOn, METH_VARARGS,
   "CreateGraphVertexIdArrayOn(self) -> None\nC++: virtual void CreateGraphVertexIdArrayOn()\n\n"},
  {"CreateGraphVertexIdArrayOff", PyvtkBoostBreadthFirstSearchTree_CreateGraphVertexIdArrayOff, METH_VARARGS,
   "CreateGraphVertexIdArrayOff(self) -> None\nC++: virtual void CreateGraphVertexIdArrayOff()\n\n"},
  {"SetReverseEdges", PyvtkBoostBreadthFirstSearchTree_SetReverseEdges, METH_VARARGS,
   "SetReverseEdges(self, _arg:bool) -> None\nC++: virtual void SetReverseEdges(bool _arg)\n\nTurn on this option to reverse the edges in the graph.\n"},
  {"GetReverseEdges", PyvtkBoostBreadthFirstSearchTree_GetReverseEdges, METH_VARARGS,
   "GetReverseEdges(self) -> bool\nC++: virtual bool GetReverseEdges()\n\n"},
  {"ReverseEdgesOn", PyvtkBoostBreadthFirstSearchTree_ReverseEdgesOn, METH_VARARGS,
   "ReverseEdgesOn(self) -> None\nC++: virtual void ReverseEdgesOn()\n\n"},
  {"ReverseEdgesOff", PyvtkBoostBreadthFirstSearchTree_ReverseEdgesOff, METH_VARARGS,
   "ReverseEdgesOff(self) -> None\nC++: virtual void ReverseEdgesOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkBoostBreadthFirstSearchTree_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("origin_vertex"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBreadthFirstSearchTree_SetOriginVertex(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBreadthFirstSearchTree_SetOriginVertex(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOriginVertex\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("create_graph_vertex_id_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostBreadthFirstSearchTree_GetCreateGraphVertexIdArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBreadthFirstSearchTree_SetCreateGraphVertexIdArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBreadthFirstSearchTree_SetCreateGraphVertexIdArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCreateGraphVertexIdArray/SetCreateGraphVertexIdArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("reverse_edges"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostBreadthFirstSearchTree_GetReverseEdges(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBreadthFirstSearchTree_SetReverseEdges(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBreadthFirstSearchTree_SetReverseEdges(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReverseEdges/SetReverseEdges\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkBoostBreadthFirstSearchTree_Doc =
  "vtkBoostBreadthFirstSearchTree - Constructs a BFS tree from a graph\n\n"
  "Superclass: vtkTreeAlgorithm\n\n"
  "This vtk class uses the Boost breadth_first_search generic algorithm\n"
  "to perform a breadth first search from a given a 'source' vertex on\n"
  "the input graph (a vtkGraph). The result is a tree with root node\n"
  "corresponding to the start node of the search.\n\n"
  "@sa\n"
  "vtkGraph vtkBoostGraphAdapter\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkBoostBreadthFirstSearchTree_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkInfovisBoostGraphAlgorithms.vtkBoostBreadthFirstSearchTree", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkBoostBreadthFirstSearchTree_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkBoostBreadthFirstSearchTree_StaticNew()
{
  return vtkBoostBreadthFirstSearchTree::New();
}

PyObject *PyvtkBoostBreadthFirstSearchTree_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkBoostBreadthFirstSearchTree_Type, PyvtkBoostBreadthFirstSearchTree_Methods,
    "vtkBoostBreadthFirstSearchTree",
 &PyvtkBoostBreadthFirstSearchTree_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkTreeAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkBoostBreadthFirstSearchTree_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkBoostBreadthFirstSearchTree(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkBoostBreadthFirstSearchTree_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkBoostBreadthFirstSearchTree", o) != 0)
  {
    Py_DECREF(o);
  }

}

