//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/visibilitySchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdVisibilitySchemaTokens,
    HD_VISIBILITY_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdBoolDataSourceHandle
HdVisibilitySchema::GetVisibility() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        HdVisibilitySchemaTokens->visibility);
}

/*static*/
HdContainerDataSourceHandle
HdVisibilitySchema::BuildRetained(
        const HdBoolDataSourceHandle &visibility
)
{
    TfToken _names[1];
    HdDataSourceBaseHandle _values[1];

    size_t _count = 0;

    if (visibility) {
        _names[_count] = HdVisibilitySchemaTokens->visibility;
        _values[_count++] = visibility;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdVisibilitySchema::Builder &
HdVisibilitySchema::Builder::SetVisibility(
    const HdBoolDataSourceHandle &visibility)
{
    _visibility = visibility;
    return *this;
}

HdContainerDataSourceHandle
HdVisibilitySchema::Builder::Build()
{
    return HdVisibilitySchema::BuildRetained(
        _visibility
    );
}

/*static*/
HdVisibilitySchema
HdVisibilitySchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdVisibilitySchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdVisibilitySchemaTokens->visibility))
        : nullptr);
}

/*static*/
const TfToken &
HdVisibilitySchema::GetSchemaToken()
{
    return HdVisibilitySchemaTokens->visibility;
}

/*static*/
const HdDataSourceLocator &
HdVisibilitySchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE