//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/instancedBySchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdInstancedBySchemaTokens,
    HD_INSTANCED_BY_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdPathArrayDataSourceHandle
HdInstancedBySchema::GetPaths() const
{
    return _GetTypedDataSource<HdPathArrayDataSource>(
        HdInstancedBySchemaTokens->paths);
}

HdPathArrayDataSourceHandle
HdInstancedBySchema::GetPrototypeRoots() const
{
    return _GetTypedDataSource<HdPathArrayDataSource>(
        HdInstancedBySchemaTokens->prototypeRoots);
}

/*static*/
HdContainerDataSourceHandle
HdInstancedBySchema::BuildRetained(
        const HdPathArrayDataSourceHandle &paths,
        const HdPathArrayDataSourceHandle &prototypeRoots
)
{
    TfToken _names[2];
    HdDataSourceBaseHandle _values[2];

    size_t _count = 0;

    if (paths) {
        _names[_count] = HdInstancedBySchemaTokens->paths;
        _values[_count++] = paths;
    }

    if (prototypeRoots) {
        _names[_count] = HdInstancedBySchemaTokens->prototypeRoots;
        _values[_count++] = prototypeRoots;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdInstancedBySchema::Builder &
HdInstancedBySchema::Builder::SetPaths(
    const HdPathArrayDataSourceHandle &paths)
{
    _paths = paths;
    return *this;
}

HdInstancedBySchema::Builder &
HdInstancedBySchema::Builder::SetPrototypeRoots(
    const HdPathArrayDataSourceHandle &prototypeRoots)
{
    _prototypeRoots = prototypeRoots;
    return *this;
}

HdContainerDataSourceHandle
HdInstancedBySchema::Builder::Build()
{
    return HdInstancedBySchema::BuildRetained(
        _paths,
        _prototypeRoots
    );
}

/*static*/
HdInstancedBySchema
HdInstancedBySchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdInstancedBySchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdInstancedBySchemaTokens->instancedBy))
        : nullptr);
}

/*static*/
const TfToken &
HdInstancedBySchema::GetSchemaToken()
{
    return HdInstancedBySchemaTokens->instancedBy;
}

/*static*/
const HdDataSourceLocator &
HdInstancedBySchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdInstancedBySchema::GetPathsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdInstancedBySchemaTokens->paths);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE