/* GtkHelper.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from GtkHelper.vala, do not modify */

#include <gtk/gtk.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CUSTOM_MESSAGE_DIALOG (custom_message_dialog_get_type ())
#define CUSTOM_MESSAGE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_MESSAGE_DIALOG, CustomMessageDialog))
#define CUSTOM_MESSAGE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_MESSAGE_DIALOG, CustomMessageDialogClass))
#define IS_CUSTOM_MESSAGE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_MESSAGE_DIALOG))
#define IS_CUSTOM_MESSAGE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_MESSAGE_DIALOG))
#define CUSTOM_MESSAGE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_MESSAGE_DIALOG, CustomMessageDialogClass))

typedef struct _CustomMessageDialog CustomMessageDialog;
typedef struct _CustomMessageDialogClass CustomMessageDialogClass;
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Block1Data {
	int _ref_count_;
	GtkDialog* dlg;
};

VALA_EXTERN void tee_jee_gtk_helper_gtk_do_events (void);
VALA_EXTERN void tee_jee_gtk_helper_gtk_set_busy (gboolean busy,
                                      GtkWindow* win);
VALA_EXTERN void tee_jee_gtk_helper_gtk_messagebox (const gchar* title,
                                        const gchar* message,
                                        GtkWindow* parent_win,
                                        gboolean is_error);
VALA_EXTERN GType custom_message_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CustomMessageDialog, g_object_unref)
VALA_EXTERN CustomMessageDialog* custom_message_dialog_new (const gchar* _msg_title,
                                                const gchar* _msg_body,
                                                GtkMessageType _msg_type,
                                                GtkWindow* parent,
                                                GtkButtonsType _buttons_type);
VALA_EXTERN CustomMessageDialog* custom_message_dialog_construct (GType object_type,
                                                      const gchar* _msg_title,
                                                      const gchar* _msg_body,
                                                      GtkMessageType _msg_type,
                                                      GtkWindow* parent,
                                                      GtkButtonsType _buttons_type);
VALA_EXTERN gchar* tee_jee_gtk_helper_gtk_inputbox (const gchar* title,
                                        const gchar* message,
                                        GtkWindow* parent_win,
                                        gboolean mask_password);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block1Data* _data1_,
                     GtkWidget* w,
                     GdkEventKey* event);
static gboolean ___lambda6__gtk_widget_key_press_event (GtkWidget* _sender,
                                                 GdkEventKey* event,
                                                 gpointer self);
VALA_EXTERN void tee_jee_gtk_helper_wait_and_close_window (gint milliseconds,
                                               GtkWindow* window);
VALA_EXTERN void tee_jee_system_sleep (gint milliseconds);
VALA_EXTERN gboolean tee_jee_gtk_helper_gtk_combobox_set_value (GtkComboBox* combo,
                                                    gint index,
                                                    const gchar* val);
VALA_EXTERN gchar* tee_jee_gtk_helper_gtk_combobox_get_value (GtkComboBox* combo,
                                                  gint index,
                                                  const gchar* default_value);
VALA_EXTERN GtkNotebook* tee_jee_gtk_helper_add_notebook (GtkBox* box,
                                              gboolean show_tabs,
                                              gboolean show_border);
VALA_EXTERN GtkTreeView* tee_jee_gtk_helper_add_treeview (GtkBox* box,
                                              GtkSelectionMode selection_mode);
VALA_EXTERN GtkTreeViewColumn* tee_jee_gtk_helper_add_column_text (GtkTreeView* treeview,
                                                       const gchar* title,
                                                       GtkCellRendererText** cell);
VALA_EXTERN GtkTreeViewColumn* tee_jee_gtk_helper_add_column_icon (GtkTreeView* treeview,
                                                       const gchar* title,
                                                       GtkCellRendererPixbuf** cell);
VALA_EXTERN GtkTreeViewColumn* tee_jee_gtk_helper_add_column_icon_radio_text (GtkTreeView* treeview,
                                                                  const gchar* title,
                                                                  GtkCellRendererPixbuf** cell_pix,
                                                                  GtkCellRendererToggle** cell_radio,
                                                                  GtkCellRendererText** cell_text);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label_scrolled (GtkBox* box,
                                                 const gchar* text,
                                                 gboolean show_border,
                                                 gboolean wrap,
                                                 gint ellipsize_chars);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label (GtkBox* box,
                                        const gchar* text,
                                        gboolean bold,
                                        gboolean italic,
                                        gboolean large);
VALA_EXTERN gchar* tee_jee_gtk_helper_format_text (const gchar* text,
                                       gboolean bold,
                                       gboolean italic,
                                       gboolean large);
VALA_EXTERN gchar* tee_jee_misc_escape_html (const gchar* html);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label_header (GtkBox* box,
                                               const gchar* text,
                                               gboolean large_heading);
VALA_EXTERN GtkRadioButton* tee_jee_gtk_helper_add_radio (GtkBox* box,
                                              const gchar* text,
                                              GtkRadioButton* another_radio_in_group);
VALA_EXTERN GtkCheckButton* tee_jee_gtk_helper_add_checkbox (GtkBox* box,
                                                 const gchar* text);
VALA_EXTERN GtkSpinButton* tee_jee_gtk_helper_add_spin (GtkBox* box,
                                            gdouble min,
                                            gdouble max,
                                            gdouble val,
                                            gint digits,
                                            gdouble step,
                                            gdouble step_page);
VALA_EXTERN GtkButton* tee_jee_gtk_helper_add_button (GtkBox* box,
                                          const gchar* text,
                                          const gchar* tooltip,
                                          GtkSizeGroup* size_group,
                                          GtkImage* icon);
VALA_EXTERN GtkButtonBox* tee_jee_gtk_helper_add_button_box (GtkContainer* box,
                                                 GtkOrientation orientation,
                                                 GtkButtonBoxStyle layout,
                                                 gint spacing);

void
tee_jee_gtk_helper_gtk_do_events (void)
{
	while (TRUE) {
		if (!gtk_events_pending ()) {
			break;
		}
		gtk_main_iteration ();
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
tee_jee_gtk_helper_gtk_set_busy (gboolean busy,
                                 GtkWindow* win)
{
	GdkCursor* cursor = NULL;
	GdkWindow* window = NULL;
	GdkWindow* _tmp4_;
	GdkWindow* _tmp5_;
	GdkWindow* _tmp6_;
	g_return_if_fail (win != NULL);
	cursor = NULL;
	if (busy) {
		GdkDisplay* _tmp0_;
		GdkCursor* _tmp1_;
		_tmp0_ = gdk_display_get_default ();
		_tmp1_ = gdk_cursor_new_from_name (_tmp0_, "wait");
		_g_object_unref0 (cursor);
		cursor = _tmp1_;
	} else {
		GdkDisplay* _tmp2_;
		GdkCursor* _tmp3_;
		_tmp2_ = gdk_display_get_default ();
		_tmp3_ = gdk_cursor_new_from_name (_tmp2_, "default");
		_g_object_unref0 (cursor);
		cursor = _tmp3_;
	}
	_tmp4_ = gtk_widget_get_window ((GtkWidget*) win);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	window = _tmp5_;
	_tmp6_ = window;
	if (_tmp6_ != NULL) {
		GdkWindow* _tmp7_;
		GdkCursor* _tmp8_;
		_tmp7_ = window;
		_tmp8_ = cursor;
		gdk_window_set_cursor (_tmp7_, _tmp8_);
	}
	tee_jee_gtk_helper_gtk_do_events ();
	_g_object_unref0 (window);
	_g_object_unref0 (cursor);
}

void
tee_jee_gtk_helper_gtk_messagebox (const gchar* title,
                                   const gchar* message,
                                   GtkWindow* parent_win,
                                   gboolean is_error)
{
	GtkMessageType type = 0;
	CustomMessageDialog* dlg = NULL;
	CustomMessageDialog* _tmp0_;
	g_return_if_fail (title != NULL);
	g_return_if_fail (message != NULL);
	type = GTK_MESSAGE_INFO;
	if (is_error) {
		type = GTK_MESSAGE_ERROR;
	} else {
		type = GTK_MESSAGE_INFO;
	}
	_tmp0_ = custom_message_dialog_new (title, message, type, parent_win, GTK_BUTTONS_OK);
	g_object_ref_sink (_tmp0_);
	dlg = _tmp0_;
	gtk_dialog_run ((GtkDialog*) dlg);
	gtk_widget_destroy ((GtkWidget*) dlg);
	_g_object_unref0 (dlg);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->dlg);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda6_ (Block1Data* _data1_,
            GtkWidget* w,
            GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->keyval == ((guint) 65293)) {
		GtkDialog* _tmp0_;
		_tmp0_ = _data1_->dlg;
		gtk_dialog_response (_tmp0_, (gint) GTK_RESPONSE_OK);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda6__gtk_widget_key_press_event (GtkWidget* _sender,
                                        GdkEventKey* event,
                                        gpointer self)
{
	gboolean result;
	result = __lambda6_ (self, _sender, event);
	return result;
}

gchar*
tee_jee_gtk_helper_gtk_inputbox (const gchar* title,
                                 const gchar* message,
                                 GtkWindow* parent_win,
                                 gboolean mask_password)
{
	Block1Data* _data1_;
	GtkBox* vbox_main = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkLabel* lbl_input = NULL;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkEntry* txt_input = NULL;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp10_;
	GtkBox* content = NULL;
	GtkDialog* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkBox* _tmp16_;
	GtkLabel* _tmp17_;
	GtkBox* _tmp18_;
	GtkEntry* _tmp19_;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	GtkBox* _tmp22_;
	GtkDialog* _tmp23_;
	GtkDialog* _tmp24_;
	GtkEntry* _tmp25_;
	GtkDialog* _tmp26_;
	gint response = 0;
	GtkDialog* _tmp27_;
	gchar* input_text = NULL;
	GtkEntry* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	GtkDialog* _tmp32_;
	gchar* result;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	vbox_main = _tmp0_;
	_tmp1_ = vbox_main;
	g_object_set ((GtkWidget*) _tmp1_, "margin", 0, NULL);
	_tmp2_ = (GtkLabel*) gtk_label_new (title);
	g_object_ref_sink (_tmp2_);
	lbl_input = _tmp2_;
	_tmp3_ = lbl_input;
	gtk_label_set_xalign (_tmp3_, (gfloat) 0.0);
	_tmp4_ = lbl_input;
	gtk_label_set_label (_tmp4_, message);
	_tmp5_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp5_);
	txt_input = _tmp5_;
	_tmp6_ = txt_input;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp6_, 3);
	_tmp7_ = txt_input;
	gtk_entry_set_visibility (_tmp7_, !mask_password);
	_tmp8_ = (GtkDialog*) gtk_dialog_new_with_buttons (title, parent_win, GTK_DIALOG_MODAL, NULL);
	g_object_ref_sink (_tmp8_);
	_data1_->dlg = _tmp8_;
	_tmp9_ = _data1_->dlg;
	gtk_window_set_title ((GtkWindow*) _tmp9_, title);
	_tmp10_ = _data1_->dlg;
	gtk_window_set_default_size ((GtkWindow*) _tmp10_, 300, -1);
	if (parent_win != NULL) {
		GtkDialog* _tmp11_;
		GtkDialog* _tmp12_;
		_tmp11_ = _data1_->dlg;
		gtk_window_set_transient_for ((GtkWindow*) _tmp11_, parent_win);
		_tmp12_ = _data1_->dlg;
		gtk_window_set_modal ((GtkWindow*) _tmp12_, TRUE);
	}
	_tmp13_ = _data1_->dlg;
	_tmp14_ = gtk_dialog_get_content_area (_tmp13_);
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_box_get_type (), GtkBox));
	content = _tmp15_;
	_tmp16_ = vbox_main;
	_tmp17_ = lbl_input;
	gtk_box_pack_start (_tmp16_, (GtkWidget*) _tmp17_, FALSE, TRUE, (guint) 0);
	_tmp18_ = vbox_main;
	_tmp19_ = txt_input;
	gtk_box_pack_start (_tmp18_, (GtkWidget*) _tmp19_, FALSE, TRUE, (guint) 0);
	_tmp20_ = content;
	_tmp21_ = vbox_main;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = content;
	g_object_set ((GtkWidget*) _tmp22_, "margin", 6, NULL);
	_tmp23_ = _data1_->dlg;
	gtk_dialog_add_button (_tmp23_, _ ("OK"), (gint) GTK_RESPONSE_OK);
	_tmp24_ = _data1_->dlg;
	gtk_dialog_add_button (_tmp24_, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp25_ = txt_input;
	g_signal_connect_data ((GtkWidget*) _tmp25_, "key-press-event", (GCallback) ___lambda6__gtk_widget_key_press_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp26_ = _data1_->dlg;
	gtk_widget_show_all ((GtkWidget*) _tmp26_);
	_tmp27_ = _data1_->dlg;
	response = gtk_dialog_run (_tmp27_);
	_tmp28_ = txt_input;
	_tmp29_ = gtk_entry_get_text (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup (_tmp30_);
	input_text = _tmp31_;
	_tmp32_ = _data1_->dlg;
	gtk_widget_destroy ((GtkWidget*) _tmp32_);
	if (response == ((gint) GTK_RESPONSE_CANCEL)) {
		result = NULL;
		_g_free0 (input_text);
		_g_object_unref0 (content);
		_g_object_unref0 (txt_input);
		_g_object_unref0 (lbl_input);
		_g_object_unref0 (vbox_main);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	} else {
		result = input_text;
		_g_object_unref0 (content);
		_g_object_unref0 (txt_input);
		_g_object_unref0 (lbl_input);
		_g_object_unref0 (vbox_main);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
}

void
tee_jee_gtk_helper_wait_and_close_window (gint milliseconds,
                                          GtkWindow* window)
{
	gint millis = 0;
	g_return_if_fail (window != NULL);
	tee_jee_gtk_helper_gtk_do_events ();
	millis = 0;
	while (TRUE) {
		if (!(millis < milliseconds)) {
			break;
		}
		tee_jee_system_sleep (200);
		millis += 200;
		tee_jee_gtk_helper_gtk_do_events ();
	}
	gtk_widget_destroy ((GtkWidget*) window);
}

gboolean
tee_jee_gtk_helper_gtk_combobox_set_value (GtkComboBox* combo,
                                           gint index,
                                           const gchar* val)
{
	GtkTreeIter iter = {0};
	gchar* comboVal = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	gboolean iterExists = FALSE;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (combo != NULL, FALSE);
	g_return_val_if_fail (val != NULL, FALSE);
	_tmp0_ = gtk_combo_box_get_model (combo);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_tree_model_get_type (), GtkTreeModel));
	model = _tmp2_;
	_tmp3_ = model;
	_tmp5_ = gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	iterExists = _tmp5_;
	while (TRUE) {
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_;
		GtkTreeModel* _tmp11_;
		gboolean _tmp12_;
		if (!iterExists) {
			break;
		}
		_tmp6_ = model;
		_tmp7_ = iter;
		gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &_tmp8_, -1);
		_g_free0 (comboVal);
		comboVal = _tmp8_;
		_tmp9_ = comboVal;
		if (g_strcmp0 (_tmp9_, val) == 0) {
			GtkTreeIter _tmp10_;
			_tmp10_ = iter;
			gtk_combo_box_set_active_iter (combo, &_tmp10_);
			result = TRUE;
			_g_object_unref0 (model);
			_g_free0 (comboVal);
			return result;
		}
		_tmp11_ = model;
		_tmp12_ = gtk_tree_model_iter_next (_tmp11_, &iter);
		iterExists = _tmp12_;
	}
	result = FALSE;
	_g_object_unref0 (model);
	_g_free0 (comboVal);
	return result;
}

gchar*
tee_jee_gtk_helper_gtk_combobox_get_value (GtkComboBox* combo,
                                           gint index,
                                           const gchar* default_value)
{
	gboolean _tmp0_ = FALSE;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter iter = {0};
	gchar* val = NULL;
	gchar* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp8_;
	GtkTreeModel* _tmp9_;
	GtkTreeModel* _tmp10_;
	GtkTreeModel* _tmp11_;
	GtkTreeIter _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* result;
	g_return_val_if_fail (combo != NULL, NULL);
	g_return_val_if_fail (default_value != NULL, NULL);
	_tmp1_ = gtk_combo_box_get_model (combo);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = gtk_combo_box_get_active (combo);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ < 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (default_value);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = g_strdup ("");
	val = _tmp6_;
	gtk_combo_box_get_active_iter (combo, &_tmp7_);
	iter = _tmp7_;
	_tmp8_ = gtk_combo_box_get_model (combo);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_tree_model_get_type (), GtkTreeModel));
	model = _tmp10_;
	_tmp11_ = model;
	_tmp12_ = iter;
	gtk_tree_model_get (_tmp11_, &_tmp12_, index, &_tmp13_, -1);
	_g_free0 (val);
	val = _tmp13_;
	result = val;
	_g_object_unref0 (model);
	return result;
}

GtkNotebook*
tee_jee_gtk_helper_add_notebook (GtkBox* box,
                                 gboolean show_tabs,
                                 gboolean show_border)
{
	GtkNotebook* book = NULL;
	GtkNotebook* _tmp0_;
	GtkNotebook* result;
	g_return_val_if_fail (box != NULL, NULL);
	_tmp0_ = (GtkNotebook*) gtk_notebook_new ();
	g_object_ref_sink (_tmp0_);
	book = _tmp0_;
	g_object_set ((GtkWidget*) book, "margin", 0, NULL);
	gtk_notebook_set_show_tabs (book, show_tabs);
	gtk_notebook_set_show_border (book, show_border);
	gtk_box_pack_start (box, (GtkWidget*) book, TRUE, TRUE, (guint) 0);
	result = book;
	return result;
}

GtkTreeView*
tee_jee_gtk_helper_add_treeview (GtkBox* box,
                                 GtkSelectionMode selection_mode)
{
	GtkTreeView* treeview = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkScrolledWindow* scrollwin = NULL;
	GtkScrolledWindow* _tmp2_;
	GtkTreeView* result;
	g_return_val_if_fail (box != NULL, NULL);
	_tmp0_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp0_);
	treeview = _tmp0_;
	_tmp1_ = gtk_tree_view_get_selection (treeview);
	gtk_tree_selection_set_mode (_tmp1_, selection_mode);
	gtk_tree_view_set_show_expanders (treeview, TRUE);
	gtk_tree_view_set_enable_tree_lines (treeview, TRUE);
	_tmp2_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp2_);
	scrollwin = _tmp2_;
	gtk_scrolled_window_set_shadow_type (scrollwin, GTK_SHADOW_ETCHED_IN);
	gtk_container_add ((GtkContainer*) scrollwin, (GtkWidget*) treeview);
	g_object_set ((GtkWidget*) scrollwin, "expand", TRUE, NULL);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) scrollwin);
	result = treeview;
	_g_object_unref0 (scrollwin);
	return result;
}

GtkTreeViewColumn*
tee_jee_gtk_helper_add_column_text (GtkTreeView* treeview,
                                    const gchar* title,
                                    GtkCellRendererText** cell)
{
	GtkCellRendererText* _vala_cell = NULL;
	GtkTreeViewColumn* col = NULL;
	GtkTreeViewColumn* _tmp0_;
	GtkCellRendererText* _tmp1_;
	GtkTreeViewColumn* result;
	g_return_val_if_fail (treeview != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp0_);
	col = _tmp0_;
	gtk_tree_view_column_set_title (col, title);
	_tmp1_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (_vala_cell);
	_vala_cell = _tmp1_;
	g_object_set ((GtkCellRenderer*) _vala_cell, "xalign", (gfloat) 0.0, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) _vala_cell, FALSE);
	gtk_tree_view_append_column (treeview, col);
	result = col;
	if (cell) {
		*cell = _vala_cell;
	} else {
		_g_object_unref0 (_vala_cell);
	}
	return result;
}

GtkTreeViewColumn*
tee_jee_gtk_helper_add_column_icon (GtkTreeView* treeview,
                                    const gchar* title,
                                    GtkCellRendererPixbuf** cell)
{
	GtkCellRendererPixbuf* _vala_cell = NULL;
	GtkTreeViewColumn* col = NULL;
	GtkTreeViewColumn* _tmp0_;
	GtkCellRendererPixbuf* _tmp1_;
	GtkTreeViewColumn* result;
	g_return_val_if_fail (treeview != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp0_);
	col = _tmp0_;
	gtk_tree_view_column_set_title (col, title);
	_tmp1_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (_vala_cell);
	_vala_cell = _tmp1_;
	g_object_set ((GtkCellRenderer*) _vala_cell, "xpad", (guint) 2, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) _vala_cell, FALSE);
	gtk_tree_view_append_column (treeview, col);
	result = col;
	if (cell) {
		*cell = _vala_cell;
	} else {
		_g_object_unref0 (_vala_cell);
	}
	return result;
}

GtkTreeViewColumn*
tee_jee_gtk_helper_add_column_icon_radio_text (GtkTreeView* treeview,
                                               const gchar* title,
                                               GtkCellRendererPixbuf** cell_pix,
                                               GtkCellRendererToggle** cell_radio,
                                               GtkCellRendererText** cell_text)
{
	GtkCellRendererPixbuf* _vala_cell_pix = NULL;
	GtkCellRendererToggle* _vala_cell_radio = NULL;
	GtkCellRendererText* _vala_cell_text = NULL;
	GtkTreeViewColumn* col = NULL;
	GtkTreeViewColumn* _tmp0_;
	GtkCellRendererPixbuf* _tmp1_;
	GtkCellRendererToggle* _tmp2_;
	GtkCellRendererText* _tmp3_;
	GtkTreeViewColumn* result;
	g_return_val_if_fail (treeview != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp0_);
	col = _tmp0_;
	gtk_tree_view_column_set_title (col, title);
	_tmp1_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (_vala_cell_pix);
	_vala_cell_pix = _tmp1_;
	g_object_set ((GtkCellRenderer*) _vala_cell_pix, "xpad", (guint) 2, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) _vala_cell_pix, FALSE);
	_tmp2_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (_vala_cell_radio);
	_vala_cell_radio = _tmp2_;
	g_object_set ((GtkCellRenderer*) _vala_cell_radio, "xpad", (guint) 2, NULL);
	gtk_cell_renderer_toggle_set_radio (_vala_cell_radio, TRUE);
	gtk_cell_renderer_toggle_set_activatable (_vala_cell_radio, TRUE);
	gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) _vala_cell_radio, FALSE);
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (_vala_cell_text);
	_vala_cell_text = _tmp3_;
	g_object_set ((GtkCellRenderer*) _vala_cell_text, "xalign", (gfloat) 0.0, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) _vala_cell_text, FALSE);
	gtk_tree_view_append_column (treeview, col);
	result = col;
	if (cell_pix) {
		*cell_pix = _vala_cell_pix;
	} else {
		_g_object_unref0 (_vala_cell_pix);
	}
	if (cell_radio) {
		*cell_radio = _vala_cell_radio;
	} else {
		_g_object_unref0 (_vala_cell_radio);
	}
	if (cell_text) {
		*cell_text = _vala_cell_text;
	} else {
		_g_object_unref0 (_vala_cell_text);
	}
	return result;
}

GtkLabel*
tee_jee_gtk_helper_add_label_scrolled (GtkBox* box,
                                       const gchar* text,
                                       gboolean show_border,
                                       gboolean wrap,
                                       gint ellipsize_chars)
{
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkScrolledWindow* _tmp1_;
	GtkScrolledWindow* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkScrolledWindow* _tmp4_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkScrolledWindow* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* result;
	g_return_val_if_fail (box != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	scroll = _tmp0_;
	_tmp1_ = scroll;
	g_object_set (_tmp1_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp2_ = scroll;
	g_object_set (_tmp2_, "vscrollbar-policy", GTK_POLICY_ALWAYS, NULL);
	_tmp3_ = scroll;
	g_object_set ((GtkWidget*) _tmp3_, "expand", TRUE, NULL);
	_tmp4_ = scroll;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp4_);
	_tmp5_ = (GtkLabel*) gtk_label_new (text);
	g_object_ref_sink (_tmp5_);
	label = _tmp5_;
	_tmp6_ = label;
	gtk_label_set_xalign (_tmp6_, (gfloat) 0.0);
	_tmp7_ = label;
	gtk_label_set_yalign (_tmp7_, (gfloat) 0.0);
	_tmp8_ = label;
	g_object_set ((GtkWidget*) _tmp8_, "margin", 6, NULL);
	_tmp9_ = label;
	gtk_label_set_use_markup (_tmp9_, TRUE);
	_tmp10_ = scroll;
	_tmp11_ = label;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	if (wrap) {
		GtkLabel* _tmp12_;
		GtkLabel* _tmp13_;
		_tmp12_ = label;
		g_object_set (_tmp12_, "wrap", TRUE, NULL);
		_tmp13_ = label;
		g_object_set (_tmp13_, "wrap-mode", PANGO_WRAP_WORD, NULL);
	} else {
		GtkLabel* _tmp14_;
		GtkLabel* _tmp15_;
		GtkLabel* _tmp16_;
		_tmp14_ = label;
		g_object_set (_tmp14_, "wrap", FALSE, NULL);
		_tmp15_ = label;
		gtk_label_set_ellipsize (_tmp15_, PANGO_ELLIPSIZE_MIDDLE);
		_tmp16_ = label;
		gtk_label_set_max_width_chars (_tmp16_, ellipsize_chars);
	}
	if (show_border) {
		GtkScrolledWindow* _tmp17_;
		_tmp17_ = scroll;
		gtk_scrolled_window_set_shadow_type (_tmp17_, GTK_SHADOW_ETCHED_IN);
	}
	result = label;
	_g_object_unref0 (scroll);
	return result;
}

GtkLabel*
tee_jee_gtk_helper_add_label (GtkBox* box,
                              const gchar* text,
                              gboolean bold,
                              gboolean italic,
                              gboolean large)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* msg = NULL;
	gchar* _tmp3_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* result;
	g_return_val_if_fail (box != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	if (bold) {
		_tmp0_ = " weight=\"bold\"";
	} else {
		_tmp0_ = "";
	}
	if (italic) {
		_tmp1_ = " style=\"italic\"";
	} else {
		_tmp1_ = "";
	}
	if (large) {
		_tmp2_ = " size=\"x-large\"";
	} else {
		_tmp2_ = "";
	}
	_tmp3_ = g_strdup_printf ("<span%s%s%s>%s</span>", _tmp0_, _tmp1_, _tmp2_, text);
	msg = _tmp3_;
	_tmp4_ = (GtkLabel*) gtk_label_new (msg);
	g_object_ref_sink (_tmp4_);
	label = _tmp4_;
	gtk_label_set_use_markup (label, TRUE);
	gtk_label_set_xalign (label, (gfloat) 0.0);
	g_object_set (label, "wrap", TRUE, NULL);
	g_object_set (label, "wrap-mode", PANGO_WRAP_WORD, NULL);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) label);
	result = label;
	_g_free0 (msg);
	return result;
}

gchar*
tee_jee_gtk_helper_format_text (const gchar* text,
                                gboolean bold,
                                gboolean italic,
                                gboolean large)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* msg = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (text != NULL, NULL);
	if (bold) {
		_tmp0_ = " weight=\"bold\"";
	} else {
		_tmp0_ = "";
	}
	if (italic) {
		_tmp1_ = " style=\"italic\"";
	} else {
		_tmp1_ = "";
	}
	if (large) {
		_tmp2_ = " size=\"x-large\"";
	} else {
		_tmp2_ = "";
	}
	_tmp3_ = tee_jee_misc_escape_html (text);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("<span%s%s%s>%s</span>", _tmp0_, _tmp1_, _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	msg = _tmp6_;
	result = msg;
	return result;
}

GtkLabel*
tee_jee_gtk_helper_add_label_header (GtkBox* box,
                                     const gchar* text,
                                     gboolean large_heading)
{
	GtkLabel* label = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* result;
	g_return_val_if_fail (box != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = tee_jee_misc_escape_html (text);
	_tmp1_ = _tmp0_;
	_tmp2_ = tee_jee_gtk_helper_add_label (box, _tmp1_, TRUE, FALSE, large_heading);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	label = _tmp3_;
	gtk_widget_set_margin_bottom ((GtkWidget*) label, 12);
	result = label;
	return result;
}

GtkRadioButton*
tee_jee_gtk_helper_add_radio (GtkBox* box,
                              const gchar* text,
                              GtkRadioButton* another_radio_in_group)
{
	GtkRadioButton* radio = NULL;
	GtkRadioButton* _tmp2_;
	GtkRadioButton* _tmp3_;
	GtkRadioButton* _tmp4_;
	GList* _tmp5_;
	GtkRadioButton* result;
	g_return_val_if_fail (box != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	radio = NULL;
	if (another_radio_in_group == NULL) {
		GtkRadioButton* _tmp0_;
		_tmp0_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
		g_object_ref_sink (_tmp0_);
		_g_object_unref0 (radio);
		radio = _tmp0_;
	} else {
		GtkRadioButton* _tmp1_;
		_tmp1_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (another_radio_in_group);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (radio);
		radio = _tmp1_;
	}
	_tmp2_ = radio;
	gtk_button_set_label ((GtkButton*) _tmp2_, text);
	_tmp3_ = radio;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp3_);
	_tmp4_ = radio;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp5_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp6_;
				_tmp6_ = child;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_label_get_type ())) {
					GtkLabel* label = NULL;
					GtkWidget* _tmp7_;
					GtkLabel* _tmp8_;
					GtkLabel* _tmp9_;
					_tmp7_ = child;
					_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_label_get_type (), GtkLabel));
					label = _tmp8_;
					_tmp9_ = label;
					gtk_label_set_use_markup (_tmp9_, TRUE);
					_g_object_unref0 (label);
					break;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	result = radio;
	return result;
}

GtkCheckButton*
tee_jee_gtk_helper_add_checkbox (GtkBox* box,
                                 const gchar* text)
{
	GtkCheckButton* chk = NULL;
	GtkCheckButton* _tmp0_;
	GtkCheckButton* _tmp1_;
	GtkCheckButton* _tmp2_;
	GtkCheckButton* _tmp3_;
	GList* _tmp4_;
	GtkCheckButton* result;
	g_return_val_if_fail (box != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = (GtkCheckButton*) gtk_check_button_new_with_label (text);
	g_object_ref_sink (_tmp0_);
	chk = _tmp0_;
	_tmp1_ = chk;
	gtk_button_set_label ((GtkButton*) _tmp1_, text);
	_tmp2_ = chk;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp2_);
	_tmp3_ = chk;
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp4_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp5_;
				_tmp5_ = child;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_label_get_type ())) {
					GtkLabel* label = NULL;
					GtkWidget* _tmp6_;
					GtkLabel* _tmp7_;
					GtkLabel* _tmp8_;
					_tmp6_ = child;
					_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_label_get_type (), GtkLabel));
					label = _tmp7_;
					_tmp8_ = label;
					gtk_label_set_use_markup (_tmp8_, TRUE);
					_g_object_unref0 (label);
					break;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	result = chk;
	return result;
}

GtkSpinButton*
tee_jee_gtk_helper_add_spin (GtkBox* box,
                             gdouble min,
                             gdouble max,
                             gdouble val,
                             gint digits,
                             gdouble step,
                             gdouble step_page)
{
	GtkAdjustment* adj = NULL;
	GtkAdjustment* _tmp0_;
	GtkSpinButton* spin = NULL;
	GtkSpinButton* _tmp1_;
	GtkSpinButton* result;
	g_return_val_if_fail (box != NULL, NULL);
	_tmp0_ = gtk_adjustment_new (val, min, max, step, step_page, (gdouble) 0);
	g_object_ref_sink (_tmp0_);
	adj = _tmp0_;
	_tmp1_ = (GtkSpinButton*) gtk_spin_button_new (adj, step, (guint) digits);
	g_object_ref_sink (_tmp1_);
	spin = _tmp1_;
	g_object_set ((GtkEntry*) spin, "xalign", (gfloat) 0.5, NULL);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) spin);
	result = spin;
	_g_object_unref0 (adj);
	return result;
}

GtkButton*
tee_jee_gtk_helper_add_button (GtkBox* box,
                               const gchar* text,
                               const gchar* tooltip,
                               GtkSizeGroup* size_group,
                               GtkImage* icon)
{
	GtkButton* button = NULL;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* result;
	g_return_val_if_fail (box != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (tooltip != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp0_);
	button = _tmp0_;
	_tmp1_ = button;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp1_);
	_tmp2_ = button;
	gtk_button_set_label (_tmp2_, text);
	_tmp3_ = button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, tooltip);
	if (icon != NULL) {
		GtkButton* _tmp4_;
		GtkButton* _tmp5_;
		_tmp4_ = button;
		gtk_button_set_image (_tmp4_, (GtkWidget*) icon);
		_tmp5_ = button;
		gtk_button_set_always_show_image (_tmp5_, TRUE);
	}
	if (size_group != NULL) {
		GtkButton* _tmp6_;
		_tmp6_ = button;
		gtk_size_group_add_widget (size_group, (GtkWidget*) _tmp6_);
	}
	result = button;
	return result;
}

GtkButtonBox*
tee_jee_gtk_helper_add_button_box (GtkContainer* box,
                                   GtkOrientation orientation,
                                   GtkButtonBoxStyle layout,
                                   gint spacing)
{
	GtkButtonBox* bbox = NULL;
	GtkButtonBox* _tmp0_;
	GtkButtonBox* result;
	g_return_val_if_fail (box != NULL, NULL);
	_tmp0_ = (GtkButtonBox*) gtk_button_box_new (orientation);
	g_object_ref_sink (_tmp0_);
	bbox = _tmp0_;
	gtk_button_box_set_layout (bbox, layout);
	gtk_box_set_spacing ((GtkBox*) bbox, spacing);
	gtk_container_add (box, (GtkWidget*) bbox);
	result = bbox;
	return result;
}

