/* RestoreDeviceBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RestoreDeviceBox.vala, do not modify */

/*
 * RestoreDeviceBox.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <float.h>
#include <math.h>

#define ICON_MANAGER_ICON_HARDDRIVE "drive-harddisk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_RESTORE_DEVICE_BOX (restore_device_box_get_type ())
#define RESTORE_DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTORE_DEVICE_BOX, RestoreDeviceBox))
#define RESTORE_DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTORE_DEVICE_BOX, RestoreDeviceBoxClass))
#define IS_RESTORE_DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTORE_DEVICE_BOX))
#define IS_RESTORE_DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTORE_DEVICE_BOX))
#define RESTORE_DEVICE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTORE_DEVICE_BOX, RestoreDeviceBoxClass))

typedef struct _RestoreDeviceBox RestoreDeviceBox;
typedef struct _RestoreDeviceBoxClass RestoreDeviceBoxClass;
typedef struct _RestoreDeviceBoxPrivate RestoreDeviceBoxPrivate;
enum  {
	RESTORE_DEVICE_BOX_0_PROPERTY,
	RESTORE_DEVICE_BOX_NUM_PROPERTIES
};
static GParamSpec* restore_device_box_properties[RESTORE_DEVICE_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MountEntryPrivate MountEntryPrivate;
typedef struct _Block7Data Block7Data;
typedef struct _DevicePrivate DevicePrivate;

#define TYPE_BOOT_OPTIONS_WINDOW (boot_options_window_get_type ())
#define BOOT_OPTIONS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOT_OPTIONS_WINDOW, BootOptionsWindow))
#define BOOT_OPTIONS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOT_OPTIONS_WINDOW, BootOptionsWindowClass))
#define IS_BOOT_OPTIONS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOT_OPTIONS_WINDOW))
#define IS_BOOT_OPTIONS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOT_OPTIONS_WINDOW))
#define BOOT_OPTIONS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOT_OPTIONS_WINDOW, BootOptionsWindowClass))

typedef struct _BootOptionsWindow BootOptionsWindow;
typedef struct _BootOptionsWindowClass BootOptionsWindowClass;

struct _RestoreDeviceBox {
	GtkBox parent_instance;
	RestoreDeviceBoxPrivate * priv;
};

struct _RestoreDeviceBoxClass {
	GtkBoxClass parent_class;
};

struct _RestoreDeviceBoxPrivate {
	GtkInfoBar* infobar_location;
	GtkLabel* lbl_infobar_location;
	GtkBox* option_box;
	GtkLabel* lbl_header_subvol;
	gboolean show_volume_name;
	GtkSizeGroup* sg_mount_point;
	GtkSizeGroup* sg_device;
	GtkSizeGroup* sg_mount_options;
	GtkWindow* parent_window;
	GtkIconSize tooltip_size;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_estimate_running;
	gboolean thread_estimate_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _MountEntry {
	GObject parent_instance;
	MountEntryPrivate * priv;
	Device* device;
	gchar* mount_point;
	gchar* mount_options;
};

struct _MountEntryClass {
	GObjectClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	RestoreDeviceBox* self;
	GtkComboBox* combo;
	gint index;
};

struct _Device {
	GObject parent_instance;
	DevicePrivate * priv;
	gchar* device;
	gchar* name;
	gchar* kname;
	gchar* pkname;
	gchar* pkname_toplevel;
	gchar* mapped_name;
	gchar* uuid;
	gchar* label;
	gchar* partuuid;
	gchar* partlabel;
	gint major;
	gint minor;
	gchar* device_mapper;
	gchar* device_by_uuid;
	gchar* device_by_label;
	gchar* device_by_partuuid;
	gchar* device_by_partlabel;
	gchar* type;
	gchar* fstype;
	gint order;
	gchar* vendor;
	gchar* model;
	gchar* serial;
	gchar* revision;
	gboolean removable;
	gboolean read_only;
	guint64 size_bytes;
	guint64 used_bytes;
	guint64 available_bytes;
	gchar* used_percent;
	gchar* dist_info;
	GeeArrayList* mount_points;
	GeeArrayList* symlinks;
	Device* parent;
	GeeArrayList* children;
};

struct _DeviceClass {
	GObjectClass parent_class;
};

static gint RestoreDeviceBox_private_offset;
static gpointer restore_device_box_parent_class = NULL;
VALA_EXTERN Main* App;

VALA_EXTERN GType restore_device_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RestoreDeviceBox, g_object_unref)
VALA_EXTERN RestoreDeviceBox* restore_device_box_new (GtkWindow* _parent_window);
VALA_EXTERN RestoreDeviceBox* restore_device_box_construct (GType object_type,
                                                GtkWindow* _parent_window);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label_header (GtkBox* box,
                                               const gchar* text,
                                               gboolean large_heading);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label (GtkBox* box,
                                        const gchar* text,
                                        gboolean bold,
                                        gboolean italic,
                                        gboolean large);
VALA_EXTERN GtkButton* tee_jee_gtk_helper_add_button (GtkBox* box,
                                          const gchar* text,
                                          const gchar* tooltip,
                                          GtkSizeGroup* size_group,
                                          GtkImage* icon);
static void __lambda104_ (RestoreDeviceBox* self);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN void main_update_partitions (Main* self);
VALA_EXTERN void restore_device_box_refresh (RestoreDeviceBox* self,
                                 gboolean reset_device_selections);
static void ___lambda104__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
static void restore_device_box_add_boot_options (RestoreDeviceBox* self);
static void restore_device_box_create_infobar_location (RestoreDeviceBox* self);
static void restore_device_box_create_device_selection_options (RestoreDeviceBox* self,
                                                         gboolean reset_device_selections);
VALA_EXTERN void main_init_boot_options (Main* self);
VALA_EXTERN void main_init_mount_list (Main* self);
VALA_EXTERN gchar* mount_entry_subvolume_name (MountEntry* self);
VALA_EXTERN gchar* mount_entry_lvm_name (MountEntry* self);
static void restore_device_box_add_device_selection_option (RestoreDeviceBox* self,
                                                     MountEntry* entry);
static GtkComboBox* restore_device_box_add_device_combo (RestoreDeviceBox* self,
                                                  GtkBox* box,
                                                  MountEntry* entry);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda105_ (Block7Data* _data7_,
                   GtkCellLayout* cell_layout,
                   GtkCellRenderer* cell,
                   GtkTreeModel* model,
                   GtkTreeIter* iter);
static void ___lambda105__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                              GtkCellRenderer* cell,
                                              GtkTreeModel* tree_model,
                                              GtkTreeIter* iter,
                                              gpointer self);
static gboolean __lambda106_ (Block7Data* _data7_,
                       gint x,
                       gint y,
                       gboolean keyboard_tooltip,
                       GtkTooltip* tooltip);
VALA_EXTERN gchar* device_tooltip_text (Device* self);
static gboolean ___lambda106__gtk_widget_query_tooltip (GtkWidget* _sender,
                                                 gint x,
                                                 gint y,
                                                 gboolean keyboard_tooltip,
                                                 GtkTooltip* tooltip,
                                                 gpointer self);
static void __lambda107_ (RestoreDeviceBox* self,
                   GtkCellLayout* cell_layout,
                   GtkCellRenderer* cell,
                   GtkTreeModel* model,
                   GtkTreeIter* iter);
VALA_EXTERN gchar* device_description_simple_formatted (Device* self);
static void ___lambda107__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                              GtkCellRenderer* cell,
                                              GtkTreeModel* tree_model,
                                              GtkTreeIter* iter,
                                              gpointer self);
VALA_EXTERN gboolean device_has_linux_filesystem (Device* self);
VALA_EXTERN gboolean device_has_children (Device* self);
VALA_EXTERN gboolean device_has_parent (Device* self);
static void __lambda108_ (Block7Data* _data7_,
                   GtkComboBox* path);
VALA_EXTERN gboolean device_is_encrypted_partition (Device* self);
VALA_EXTERN Device* device_luks_unlock (Device* luks_device,
                            const gchar* mapped_name,
                            const gchar* passphrase,
                            GtkWindow* parent_window,
                            gchar** message,
                            gchar** details);
VALA_EXTERN void main_set_dst_root (Main* self,
                        Device* value);
static void ___lambda108__gtk_combo_box_changed (GtkComboBox* _sender,
                                          gpointer self);
static void __lambda109_ (RestoreDeviceBox* self);
VALA_EXTERN GType boot_options_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BootOptionsWindow, g_object_unref)
VALA_EXTERN BootOptionsWindow* boot_options_window_new (void);
VALA_EXTERN BootOptionsWindow* boot_options_window_construct (GType object_type);
static void ___lambda109__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
VALA_EXTERN gboolean restore_device_box_check_and_mount_devices (RestoreDeviceBox* self);
VALA_EXTERN Device* main_get_dst_root (Main* self);
VALA_EXTERN void tee_jee_gtk_helper_gtk_messagebox (const gchar* title,
                                        const gchar* message,
                                        GtkWindow* parent_win,
                                        gboolean is_error);
VALA_EXTERN gboolean device_is_on_encrypted_partition (Device* self);
VALA_EXTERN gboolean main_check_btrfs_layout (Main* self,
                                  Device* dev_root,
                                  Device* dev_home,
                                  gboolean unlock);
VALA_EXTERN Device* main_get_dst_home (Main* self);
VALA_EXTERN gboolean main_mount_target_devices (Main* self,
                                    GtkWindow* parent_win);
static void restore_device_box_finalize (GObject * obj);
static GType restore_device_box_get_type_once (void);

static inline gpointer
restore_device_box_get_instance_private (RestoreDeviceBox* self)
{
	return G_STRUCT_MEMBER_P (self, RestoreDeviceBox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda104_ (RestoreDeviceBox* self)
{
	Main* _tmp0_;
	_tmp0_ = App;
	main_update_partitions (_tmp0_);
	restore_device_box_refresh (self, TRUE);
}

static void
___lambda104__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda104_ ((RestoreDeviceBox*) self);
}

RestoreDeviceBox*
restore_device_box_construct (GType object_type,
                              GtkWindow* _parent_window)
{
	RestoreDeviceBox * self = NULL;
	GtkWindow* _tmp0_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* label = NULL;
	GtkBox* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp9_;
	GtkButton* btn_refresh = NULL;
	GtkBox* _tmp10_;
	GtkSizeGroup* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	Main* _tmp14_;
	GtkBox* _tmp23_;
	GtkBox* _tmp24_;
	GtkBox* _tmp25_;
	GtkBox* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkSizeGroup* _tmp31_;
	GtkLabel* _tmp32_;
	GtkBox* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GtkLabel* _tmp36_;
	GtkLabel* _tmp37_;
	GtkSizeGroup* _tmp38_;
	GtkLabel* _tmp39_;
	GtkBox* _tmp40_;
	GtkLabel* _tmp41_;
	GtkLabel* _tmp42_;
	GtkLabel* _tmp43_;
	GtkLabel* _tmp44_;
	GtkLabel* _tmp45_;
	GtkBox* _tmp46_;
	GtkBox* _tmp47_;
	g_return_val_if_fail (_parent_window != NULL, NULL);
	tee_jee_logging_log_debug ("RestoreDeviceBox: RestoreDeviceBox()");
	self = (RestoreDeviceBox*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 6, NULL);
	_tmp0_ = _g_object_ref0 (_parent_window);
	_g_object_unref0 (self->priv->parent_window);
	self->priv->parent_window = _tmp0_;
	g_object_set ((GtkWidget*) self, "margin", 12, NULL);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp1_);
	hbox = _tmp1_;
	_tmp2_ = hbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = hbox;
	_tmp4_ = tee_jee_gtk_helper_add_label_header (_tmp3_, _ ("Select Target Device"), TRUE);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_tmp6_ = hbox;
	_tmp7_ = tee_jee_gtk_helper_add_label (_tmp6_, "", FALSE, FALSE, FALSE);
	label = _tmp7_;
	_tmp8_ = label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	size_group = _tmp9_;
	_tmp10_ = hbox;
	_tmp11_ = size_group;
	_tmp12_ = tee_jee_gtk_helper_add_button (_tmp10_, _ ("Refresh"), "", _tmp11_, NULL);
	btn_refresh = _tmp12_;
	_tmp13_ = btn_refresh;
	g_signal_connect_object (_tmp13_, "clicked", (GCallback) ___lambda104__gtk_button_clicked, self, 0);
	_tmp14_ = App;
	if (_tmp14_->mirror_system) {
		GtkLabel* _tmp15_;
		GtkLabel* _tmp16_;
		_tmp15_ = tee_jee_gtk_helper_add_label ((GtkBox*) self, _ ("Select the target devices where system will be cloned."), FALSE, FALSE, FALSE);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp16_);
	} else {
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GtkLabel* _tmp21_;
		GtkLabel* _tmp22_;
		_tmp17_ = g_strconcat (_ ("Select the devices where files will be restored."), "\n", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp18_, _ ("Devices from which snapshot was created are pre-selected."), NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = tee_jee_gtk_helper_add_label ((GtkBox*) self, _tmp20_, FALSE, FALSE, FALSE);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
	}
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (hbox);
	hbox = _tmp23_;
	_tmp24_ = hbox;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp24_, 12);
	_tmp25_ = hbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
	_tmp26_ = hbox;
	_tmp27_ = g_strconcat (_ ("Path"), "  ", NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = tee_jee_gtk_helper_add_label (_tmp26_, _tmp28_, TRUE, TRUE, FALSE);
	_g_object_unref0 (label);
	label = _tmp29_;
	_g_free0 (_tmp28_);
	_tmp30_ = label;
	gtk_label_set_xalign (_tmp30_, (gfloat) 0.0);
	_tmp31_ = self->priv->sg_mount_point;
	_tmp32_ = label;
	gtk_size_group_add_widget (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = hbox;
	_tmp34_ = g_strconcat (_ ("Device"), "  ", NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = tee_jee_gtk_helper_add_label (_tmp33_, _tmp35_, TRUE, TRUE, FALSE);
	_g_object_unref0 (label);
	label = _tmp36_;
	_g_free0 (_tmp35_);
	_tmp37_ = label;
	gtk_label_set_xalign (_tmp37_, (gfloat) 0.0);
	_tmp38_ = self->priv->sg_device;
	_tmp39_ = label;
	gtk_size_group_add_widget (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = hbox;
	_tmp41_ = tee_jee_gtk_helper_add_label (_tmp40_, _ ("Subvolume"), TRUE, TRUE, FALSE);
	_g_object_unref0 (label);
	label = _tmp41_;
	_tmp42_ = label;
	gtk_label_set_xalign (_tmp42_, (gfloat) 0.5);
	_tmp43_ = label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp43_, TRUE);
	_tmp44_ = label;
	_tmp45_ = _g_object_ref0 (_tmp44_);
	_g_object_unref0 (self->priv->lbl_header_subvol);
	self->priv->lbl_header_subvol = _tmp45_;
	_tmp46_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->option_box);
	self->priv->option_box = _tmp46_;
	_tmp47_ = self->priv->option_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp47_);
	restore_device_box_add_boot_options (self);
	restore_device_box_create_infobar_location (self);
	tee_jee_logging_log_debug ("RestoreDeviceBox: RestoreDeviceBox(): exit");
	_g_object_unref0 (btn_refresh);
	_g_object_unref0 (size_group);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	return self;
}

RestoreDeviceBox*
restore_device_box_new (GtkWindow* _parent_window)
{
	return restore_device_box_construct (TYPE_RESTORE_DEVICE_BOX, _parent_window);
}

void
restore_device_box_refresh (RestoreDeviceBox* self,
                            gboolean reset_device_selections)
{
	Main* _tmp0_;
	Main* _tmp1_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("RestoreDeviceBox: refresh()");
	_tmp0_ = App;
	main_update_partitions (_tmp0_);
	restore_device_box_create_device_selection_options (self, reset_device_selections);
	_tmp1_ = App;
	main_init_boot_options (_tmp1_);
	tee_jee_logging_log_debug ("RestoreDeviceBox: refresh(): exit");
}

static void
restore_device_box_create_device_selection_options (RestoreDeviceBox* self,
                                                    gboolean reset_device_selections)
{
	GtkLabel* _tmp26_;
	GtkBox* _tmp27_;
	GList* _tmp28_;
	g_return_if_fail (self != NULL);
	if (reset_device_selections) {
		Main* _tmp0_;
		_tmp0_ = App;
		main_init_mount_list (_tmp0_);
	}
	self->priv->show_volume_name = FALSE;
	{
		GeeArrayList* _entry_list = NULL;
		Main* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _entry_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _entry_index = 0;
		_tmp1_ = App;
		_tmp2_ = _tmp1_->mount_list;
		_entry_list = _tmp2_;
		_tmp3_ = _entry_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_entry_size = _tmp5_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			MountEntry* entry = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			MountEntry* _tmp11_;
			Device* _tmp12_;
			_entry_index = _entry_index + 1;
			_tmp6_ = _entry_index;
			_tmp7_ = _entry_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _entry_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _entry_index);
			entry = (MountEntry*) _tmp9_;
			_tmp11_ = entry;
			_tmp12_ = _tmp11_->device;
			if (_tmp12_ != NULL) {
				gboolean _tmp13_ = FALSE;
				MountEntry* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gboolean _tmp19_;
				_tmp14_ = entry;
				_tmp15_ = mount_entry_subvolume_name (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = strlen (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = _tmp18_ > 0;
				_g_free0 (_tmp16_);
				if (_tmp19_) {
					_tmp13_ = TRUE;
				} else {
					MountEntry* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					_tmp20_ = entry;
					_tmp21_ = mount_entry_lvm_name (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = strlen (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp13_ = _tmp24_ > 0;
					_g_free0 (_tmp22_);
				}
				_tmp10_ = _tmp13_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				self->priv->show_volume_name = TRUE;
				_g_object_unref0 (entry);
				break;
			}
			_g_object_unref0 (entry);
		}
	}
	if (self->priv->show_volume_name) {
		GtkLabel* _tmp25_;
		_tmp25_ = self->priv->lbl_header_subvol;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp25_, FALSE);
	}
	_tmp26_ = self->priv->lbl_header_subvol;
	gtk_widget_set_visible ((GtkWidget*) _tmp26_, self->priv->show_volume_name);
	_tmp27_ = self->priv->option_box;
	_tmp28_ = gtk_container_get_children ((GtkContainer*) _tmp27_);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp28_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkWidget* item = NULL;
			item = (GtkWidget*) item_it->data;
			{
				GtkBox* _tmp29_;
				GtkWidget* _tmp30_;
				_tmp29_ = self->priv->option_box;
				_tmp30_ = item;
				gtk_container_remove ((GtkContainer*) _tmp29_, _tmp30_);
			}
		}
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
	}
	{
		GeeArrayList* _entry_list = NULL;
		Main* _tmp31_;
		GeeArrayList* _tmp32_;
		gint _entry_size = 0;
		GeeArrayList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _entry_index = 0;
		_tmp31_ = App;
		_tmp32_ = _tmp31_->mount_list;
		_entry_list = _tmp32_;
		_tmp33_ = _entry_list;
		_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_entry_size = _tmp35_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			MountEntry* entry = NULL;
			GeeArrayList* _tmp38_;
			gpointer _tmp39_;
			MountEntry* _tmp40_;
			_entry_index = _entry_index + 1;
			_tmp36_ = _entry_index;
			_tmp37_ = _entry_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _entry_list;
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _entry_index);
			entry = (MountEntry*) _tmp39_;
			_tmp40_ = entry;
			restore_device_box_add_device_selection_option (self, _tmp40_);
			_g_object_unref0 (entry);
		}
	}
	gtk_widget_show_all ((GtkWidget*) self);
}

static void
restore_device_box_add_device_selection_option (RestoreDeviceBox* self,
                                                MountEntry* entry)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkLabel* label = NULL;
	GtkBox* _tmp3_;
	const gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkSizeGroup* _tmp6_;
	GtkLabel* _tmp7_;
	GtkComboBox* combo = NULL;
	GtkBox* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkSizeGroup* _tmp10_;
	GtkComboBox* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = self->priv->option_box;
	_tmp2_ = box;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
	_tmp3_ = box;
	_tmp4_ = entry->mount_point;
	_tmp5_ = tee_jee_gtk_helper_add_label (_tmp3_, _tmp4_, TRUE, FALSE, FALSE);
	label = _tmp5_;
	_tmp6_ = self->priv->sg_mount_point;
	_tmp7_ = label;
	gtk_size_group_add_widget (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = box;
	_tmp9_ = restore_device_box_add_device_combo (self, _tmp8_, entry);
	combo = _tmp9_;
	_tmp10_ = self->priv->sg_device;
	_tmp11_ = combo;
	gtk_size_group_add_widget (_tmp10_, (GtkWidget*) _tmp11_);
	if (self->priv->show_volume_name) {
		gchar* txt = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gboolean _tmp17_;
		GtkBox* _tmp24_;
		const gchar* _tmp25_;
		GtkLabel* _tmp26_;
		GtkSizeGroup* _tmp27_;
		GtkLabel* _tmp28_;
		_tmp12_ = g_strdup ("");
		txt = _tmp12_;
		_tmp13_ = mount_entry_subvolume_name (entry);
		_tmp14_ = _tmp13_;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_ > 0;
		_g_free0 (_tmp14_);
		if (_tmp17_) {
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp18_ = mount_entry_subvolume_name (entry);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strdup_printf ("%s", _tmp19_);
			_g_free0 (txt);
			txt = _tmp20_;
			_g_free0 (_tmp19_);
		} else {
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp21_ = mount_entry_lvm_name (entry);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strdup_printf ("%s", _tmp22_);
			_g_free0 (txt);
			txt = _tmp23_;
			_g_free0 (_tmp22_);
		}
		_tmp24_ = box;
		_tmp25_ = txt;
		_tmp26_ = tee_jee_gtk_helper_add_label (_tmp24_, _tmp25_, FALSE, FALSE, FALSE);
		_g_object_unref0 (label);
		label = _tmp26_;
		_tmp27_ = self->priv->sg_mount_options;
		_tmp28_ = label;
		gtk_size_group_add_widget (_tmp27_, (GtkWidget*) _tmp28_);
		_g_free0 (txt);
	}
	_g_object_unref0 (combo);
	_g_object_unref0 (label);
	_g_object_unref0 (box);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		RestoreDeviceBox* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->combo);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda105_ (Block7Data* _data7_,
              GtkCellLayout* cell_layout,
              GtkCellRenderer* cell,
              GtkTreeModel* model,
              GtkTreeIter* iter)
{
	RestoreDeviceBox* self;
	Device* dev = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	Device* _tmp4_ = NULL;
	Device* _tmp5_;
	self = _data7_->self;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = _data7_->combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = *iter;
	gtk_tree_model_get (_tmp2_, &_tmp3_, 0, &_tmp4_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp4_;
	_tmp5_ = dev;
	if (_tmp5_ != NULL) {
		Device* _tmp6_;
		const gchar* _tmp7_;
		Device* _tmp8_;
		const gchar* _tmp9_;
		Device* _tmp10_;
		const gchar* _tmp11_;
		_tmp6_ = dev;
		_tmp7_ = _tmp6_->type;
		if (g_strcmp0 (_tmp7_, "disk") == 0) {
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_pixbuf_get_type (), GtkCellRendererPixbuf), "icon-name", ICON_MANAGER_ICON_HARDDRIVE, NULL);
		}
		_tmp8_ = dev;
		_tmp9_ = _tmp8_->type;
		gtk_cell_renderer_set_sensitive ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_pixbuf_get_type (), GtkCellRendererPixbuf), g_strcmp0 (_tmp9_, "disk") != 0);
		_tmp10_ = dev;
		_tmp11_ = _tmp10_->type;
		gtk_cell_renderer_set_visible ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_pixbuf_get_type (), GtkCellRendererPixbuf), g_strcmp0 (_tmp11_, "disk") == 0);
	}
	_g_object_unref0 (dev);
}

static void
___lambda105__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                         GtkCellRenderer* cell,
                                         GtkTreeModel* tree_model,
                                         GtkTreeIter* iter,
                                         gpointer self)
{
	__lambda105_ (self, cell_layout, cell, tree_model, iter);
}

static gboolean
__lambda106_ (Block7Data* _data7_,
              gint x,
              gint y,
              gboolean keyboard_tooltip,
              GtkTooltip* tooltip)
{
	RestoreDeviceBox* self;
	Device* dev = NULL;
	GtkTreeIter iter = {0};
	gboolean selected = FALSE;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	Device* _tmp7_ = NULL;
	Device* _tmp8_;
	gboolean result;
	self = _data7_->self;
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp0_ = _data7_->combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	selected = _tmp2_;
	if (!selected) {
		result = TRUE;
		_g_object_unref0 (dev);
		return result;
	}
	_tmp3_ = _data7_->combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 0, &_tmp7_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp7_;
	gtk_tooltip_set_icon_from_icon_name (tooltip, ICON_MANAGER_ICON_HARDDRIVE, (gint) self->priv->tooltip_size);
	_tmp8_ = dev;
	if (_tmp8_ != NULL) {
		Device* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = dev;
		_tmp10_ = device_tooltip_text (_tmp9_);
		_tmp11_ = _tmp10_;
		gtk_tooltip_set_markup (tooltip, _tmp11_);
		_g_free0 (_tmp11_);
	} else {
		gtk_tooltip_set_markup (tooltip, _ ("Keep this mount path on the root filesystem"));
	}
	result = TRUE;
	_g_object_unref0 (dev);
	return result;
}

static gboolean
___lambda106__gtk_widget_query_tooltip (GtkWidget* _sender,
                                        gint x,
                                        gint y,
                                        gboolean keyboard_tooltip,
                                        GtkTooltip* tooltip,
                                        gpointer self)
{
	gboolean result;
	result = __lambda106_ (self, x, y, keyboard_tooltip, tooltip);
	return result;
}

static void
__lambda107_ (RestoreDeviceBox* self,
              GtkCellLayout* cell_layout,
              GtkCellRenderer* cell,
              GtkTreeModel* model,
              GtkTreeIter* iter)
{
	Device* dev = NULL;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	Device* _tmp2_;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	_tmp2_ = dev;
	if (_tmp2_ != NULL) {
		Device* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		Device* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = dev;
		_tmp4_ = device_description_simple_formatted (_tmp3_);
		_tmp5_ = _tmp4_;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "markup", _tmp5_, NULL);
		_g_free0 (_tmp5_);
		_tmp6_ = dev;
		_tmp7_ = _tmp6_->type;
		gtk_cell_renderer_set_sensitive ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), g_strcmp0 (_tmp7_, "disk") != 0);
	} else {
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "markup", _ ("Keep on Root Device"), NULL);
	}
	_g_object_unref0 (dev);
}

static void
___lambda107__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                         GtkCellRenderer* cell,
                                         GtkTreeModel* tree_model,
                                         GtkTreeIter* iter,
                                         gpointer self)
{
	__lambda107_ ((RestoreDeviceBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda108_ (Block7Data* _data7_,
              GtkComboBox* path)
{
	RestoreDeviceBox* self;
	Device* current_dev = NULL;
	MountEntry* current_entry = NULL;
	GtkTreeIter iter_active = {0};
	gboolean selected = FALSE;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTreeIter iter_combo = {0};
	GtkListStore* store = NULL;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkListStore* _tmp6_;
	GtkListStore* _tmp7_;
	GtkTreeIter _tmp8_;
	Device* _tmp9_ = NULL;
	MountEntry* _tmp10_ = NULL;
	Device* _tmp11_;
	MountEntry* _tmp47_;
	Device* _tmp48_;
	Device* _tmp49_;
	MountEntry* _tmp50_;
	const gchar* _tmp51_;
	self = _data7_->self;
	g_return_if_fail (path != NULL);
	_tmp0_ = _data7_->combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter_active = _tmp1_;
	selected = _tmp2_;
	if (!selected) {
		tee_jee_logging_log_debug ("device combo: active is -1");
		_g_object_unref0 (current_entry);
		_g_object_unref0 (current_dev);
		return;
	}
	_tmp3_ = _data7_->combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_list_store_get_type (), GtkListStore));
	store = _tmp6_;
	_tmp7_ = store;
	_tmp8_ = iter_active;
	gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 0, &_tmp9_, 1, &_tmp10_, -1, -1);
	_g_object_unref0 (current_dev);
	current_dev = _tmp9_;
	_g_object_unref0 (current_entry);
	current_entry = _tmp10_;
	_tmp11_ = current_dev;
	if (device_is_encrypted_partition (_tmp11_)) {
		gchar* msg_out = NULL;
		gchar* msg_err = NULL;
		Device* luks_unlocked = NULL;
		Device* _tmp12_;
		GtkWindow* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		Device* _tmp16_;
		Device* _tmp17_;
		tee_jee_logging_log_debug ("add_device_combo().changed: unlocking encrypted device..");
		_tmp12_ = current_dev;
		_tmp13_ = self->priv->parent_window;
		_tmp16_ = device_luks_unlock (_tmp12_, "", "", _tmp13_, &_tmp14_, &_tmp15_);
		_g_free0 (msg_out);
		msg_out = _tmp14_;
		_g_free0 (msg_err);
		msg_err = _tmp15_;
		luks_unlocked = _tmp16_;
		_tmp17_ = luks_unlocked;
		if (_tmp17_ == NULL) {
			MountEntry* _tmp18_;
			const gchar* _tmp19_;
			tee_jee_logging_log_debug ("add_device_combo().changed: failed to unlock");
			_tmp18_ = current_entry;
			_tmp19_ = _tmp18_->mount_point;
			if (g_strcmp0 (_tmp19_, "/") == 0) {
				_data7_->index = -1;
				{
					gboolean next = FALSE;
					GtkListStore* _tmp20_;
					GtkTreeIter _tmp21_ = {0};
					gboolean _tmp22_;
					_tmp20_ = store;
					_tmp22_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp20_, &_tmp21_);
					iter_combo = _tmp21_;
					next = _tmp22_;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							Device* dev_iter = NULL;
							GtkListStore* _tmp26_;
							GtkTreeIter _tmp27_;
							Device* _tmp28_ = NULL;
							gint _tmp29_;
							gboolean _tmp30_ = FALSE;
							Device* _tmp31_;
							if (!_tmp23_) {
								GtkListStore* _tmp24_;
								gboolean _tmp25_;
								_tmp24_ = store;
								_tmp25_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp24_, &iter_combo);
								next = _tmp25_;
							}
							_tmp23_ = FALSE;
							if (!next) {
								break;
							}
							_tmp26_ = store;
							_tmp27_ = iter_combo;
							gtk_tree_model_get ((GtkTreeModel*) _tmp26_, &_tmp27_, 0, &_tmp28_, -1, -1);
							_g_object_unref0 (dev_iter);
							dev_iter = _tmp28_;
							_tmp29_ = _data7_->index;
							_data7_->index = _tmp29_ + 1;
							_tmp31_ = dev_iter;
							if (_tmp31_ != NULL) {
								Device* _tmp32_;
								const gchar* _tmp33_;
								MountEntry* _tmp34_;
								Device* _tmp35_;
								const gchar* _tmp36_;
								_tmp32_ = dev_iter;
								_tmp33_ = _tmp32_->device;
								_tmp34_ = current_entry;
								_tmp35_ = _tmp34_->device;
								_tmp36_ = _tmp35_->device;
								_tmp30_ = g_strcmp0 (_tmp33_, _tmp36_) == 0;
							} else {
								_tmp30_ = FALSE;
							}
							if (_tmp30_) {
								GtkComboBox* _tmp37_;
								_tmp37_ = _data7_->combo;
								gtk_combo_box_set_active (_tmp37_, _data7_->index);
							}
							_g_object_unref0 (dev_iter);
						}
					}
				}
			} else {
				GtkComboBox* _tmp38_;
				_tmp38_ = _data7_->combo;
				gtk_combo_box_set_active (_tmp38_, 0);
			}
			_g_object_unref0 (luks_unlocked);
			_g_free0 (msg_err);
			_g_free0 (msg_out);
			_g_object_unref0 (store);
			_g_object_unref0 (current_entry);
			_g_object_unref0 (current_dev);
			return;
		} else {
			MountEntry* _tmp39_;
			const gchar* _tmp40_;
			MountEntry* _tmp44_;
			Device* _tmp45_;
			Device* _tmp46_;
			tee_jee_logging_log_debug ("add_device_combo().changed: unlocked");
			_tmp39_ = current_entry;
			_tmp40_ = _tmp39_->mount_point;
			if (g_strcmp0 (_tmp40_, "/") == 0) {
				Main* _tmp41_;
				Device* _tmp42_;
				Main* _tmp43_;
				_tmp41_ = App;
				_tmp42_ = luks_unlocked;
				main_set_dst_root (_tmp41_, _tmp42_);
				_tmp43_ = App;
				main_init_boot_options (_tmp43_);
			}
			_tmp44_ = current_entry;
			_tmp45_ = luks_unlocked;
			_tmp46_ = _g_object_ref0 (_tmp45_);
			_g_object_unref0 (_tmp44_->device);
			_tmp44_->device = _tmp46_;
			restore_device_box_refresh (self, FALSE);
			_g_object_unref0 (luks_unlocked);
			_g_free0 (msg_err);
			_g_free0 (msg_out);
			_g_object_unref0 (store);
			_g_object_unref0 (current_entry);
			_g_object_unref0 (current_dev);
			return;
		}
		_g_object_unref0 (luks_unlocked);
		_g_free0 (msg_err);
		_g_free0 (msg_out);
	}
	_tmp47_ = current_entry;
	_tmp48_ = current_dev;
	_tmp49_ = _g_object_ref0 (_tmp48_);
	_g_object_unref0 (_tmp47_->device);
	_tmp47_->device = _tmp49_;
	_tmp50_ = current_entry;
	_tmp51_ = _tmp50_->mount_point;
	if (g_strcmp0 (_tmp51_, "/") == 0) {
		Main* _tmp52_;
		_tmp52_ = App;
		main_init_boot_options (_tmp52_);
	}
	_g_object_unref0 (store);
	_g_object_unref0 (current_entry);
	_g_object_unref0 (current_dev);
}

static void
___lambda108__gtk_combo_box_changed (GtkComboBox* _sender,
                                     gpointer self)
{
	__lambda108_ (self, _sender);
}

static GtkComboBox*
restore_device_box_add_device_combo (RestoreDeviceBox* self,
                                     GtkBox* box,
                                     MountEntry* entry)
{
	Block7Data* _data7_;
	GtkComboBox* _tmp0_;
	GtkComboBox* _tmp1_;
	GtkCellRendererPixbuf* cell_pix = NULL;
	GtkCellRendererPixbuf* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkCellRendererPixbuf* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkCellRendererPixbuf* _tmp6_;
	GtkCellRendererText* cell_text = NULL;
	GtkCellRendererText* _tmp7_;
	GtkCellRendererText* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkCellRendererText* _tmp10_;
	GtkComboBox* _tmp11_;
	GtkComboBox* _tmp12_;
	GtkComboBox* _tmp13_;
	GtkCellRendererText* _tmp14_;
	GtkListStore* model = NULL;
	GtkListStore* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkListStore* _tmp17_;
	gint active = 0;
	GtkTreeIter iter = {0};
	const gchar* _tmp18_;
	gboolean _tmp76_ = FALSE;
	GtkComboBox* _tmp78_;
	GtkComboBox* _tmp79_;
	GtkComboBox* _tmp80_;
	GtkComboBox* _tmp81_;
	GtkComboBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (box != NULL, NULL);
	g_return_val_if_fail (entry != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp0_);
	_data7_->combo = _tmp0_;
	_tmp1_ = _data7_->combo;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp1_);
	_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp2_);
	cell_pix = _tmp2_;
	_tmp3_ = _data7_->combo;
	_tmp4_ = cell_pix;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) _tmp4_, FALSE);
	_tmp5_ = _data7_->combo;
	_tmp6_ = cell_pix;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp5_, (GtkCellRenderer*) _tmp6_, ___lambda105__gtk_cell_layout_data_func, block7_data_ref (_data7_), block7_data_unref);
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp7_);
	cell_text = _tmp7_;
	_tmp8_ = cell_text;
	g_object_set ((GtkCellRenderer*) _tmp8_, "xalign", (gfloat) 0.0, NULL);
	_tmp9_ = _data7_->combo;
	_tmp10_ = cell_text;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) _tmp10_, FALSE);
	_tmp11_ = _data7_->combo;
	gtk_widget_set_has_tooltip ((GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = _data7_->combo;
	g_signal_connect_data ((GtkWidget*) _tmp12_, "query-tooltip", (GCallback) ___lambda106__gtk_widget_query_tooltip, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp13_ = _data7_->combo;
	_tmp14_ = cell_text;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp13_, (GtkCellRenderer*) _tmp14_, ___lambda107__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp15_ = gtk_list_store_new (2, TYPE_DEVICE, TYPE_MOUNT_ENTRY, -1);
	model = _tmp15_;
	_tmp16_ = _data7_->combo;
	_tmp17_ = model;
	gtk_combo_box_set_model (_tmp16_, (GtkTreeModel*) _tmp17_);
	active = -1;
	_data7_->index = -1;
	_tmp18_ = entry->mount_point;
	if (g_strcmp0 (_tmp18_, "/") != 0) {
		gint _tmp19_;
		GtkListStore* _tmp20_;
		GtkTreeIter _tmp21_ = {0};
		GtkListStore* _tmp22_;
		GtkTreeIter _tmp23_;
		GtkListStore* _tmp24_;
		GtkTreeIter _tmp25_;
		_tmp19_ = _data7_->index;
		_data7_->index = _tmp19_ + 1;
		_tmp20_ = model;
		gtk_list_store_append (_tmp20_, &_tmp21_);
		iter = _tmp21_;
		_tmp22_ = model;
		_tmp23_ = iter;
		gtk_list_store_set (_tmp22_, &_tmp23_, 0, NULL, -1);
		_tmp24_ = model;
		_tmp25_ = iter;
		gtk_list_store_set (_tmp24_, &_tmp25_, 1, entry, -1);
	}
	{
		GeeArrayList* _dev_list = NULL;
		Main* _tmp26_;
		GeeArrayList* _tmp27_;
		gint _dev_size = 0;
		GeeArrayList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _dev_index = 0;
		_tmp26_ = App;
		_tmp27_ = _tmp26_->partitions;
		_dev_list = _tmp27_;
		_tmp28_ = _dev_list;
		_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_dev_size = _tmp30_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			Device* dev = NULL;
			GeeArrayList* _tmp33_;
			gpointer _tmp34_;
			gboolean _tmp35_ = FALSE;
			Device* _tmp36_;
			const gchar* _tmp37_;
			Device* _tmp40_;
			const gchar* _tmp41_;
			gint _tmp47_;
			GtkListStore* _tmp48_;
			GtkTreeIter _tmp49_ = {0};
			GtkListStore* _tmp50_;
			GtkTreeIter _tmp51_;
			Device* _tmp52_;
			GtkListStore* _tmp53_;
			GtkTreeIter _tmp54_;
			Device* _tmp55_;
			_dev_index = _dev_index + 1;
			_tmp31_ = _dev_index;
			_tmp32_ = _dev_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _dev_list;
			_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _dev_index);
			dev = (Device*) _tmp34_;
			_tmp36_ = dev;
			_tmp37_ = _tmp36_->type;
			if (g_strcmp0 (_tmp37_, "loop") == 0) {
				_tmp35_ = TRUE;
			} else {
				Device* _tmp38_;
				const gchar* _tmp39_;
				_tmp38_ = dev;
				_tmp39_ = _tmp38_->fstype;
				_tmp35_ = g_strcmp0 (_tmp39_, "iso9660") == 0;
			}
			if (_tmp35_) {
				_g_object_unref0 (dev);
				continue;
			}
			_tmp40_ = dev;
			_tmp41_ = _tmp40_->type;
			if (g_strcmp0 (_tmp41_, "disk") != 0) {
				gboolean _tmp42_ = FALSE;
				const gchar* _tmp43_;
				Device* _tmp46_;
				_tmp43_ = entry->mount_point;
				if (g_strcmp0 (_tmp43_, "/") == 0) {
					_tmp42_ = TRUE;
				} else {
					const gchar* _tmp44_;
					_tmp44_ = entry->mount_point;
					_tmp42_ = g_strcmp0 (_tmp44_, "/home") == 0;
				}
				if (_tmp42_) {
					Device* _tmp45_;
					_tmp45_ = dev;
					if (!device_has_linux_filesystem (_tmp45_)) {
						_g_object_unref0 (dev);
						continue;
					}
				}
				_tmp46_ = dev;
				if (device_has_children (_tmp46_)) {
					_g_object_unref0 (dev);
					continue;
				}
			}
			_tmp47_ = _data7_->index;
			_data7_->index = _tmp47_ + 1;
			_tmp48_ = model;
			gtk_list_store_append (_tmp48_, &_tmp49_);
			iter = _tmp49_;
			_tmp50_ = model;
			_tmp51_ = iter;
			_tmp52_ = dev;
			gtk_list_store_set (_tmp50_, &_tmp51_, 0, _tmp52_, -1);
			_tmp53_ = model;
			_tmp54_ = iter;
			gtk_list_store_set (_tmp53_, &_tmp54_, 1, entry, -1);
			_tmp55_ = entry->device;
			if (_tmp55_ != NULL) {
				Device* _tmp56_;
				const gchar* _tmp57_;
				Device* _tmp58_;
				const gchar* _tmp59_;
				_tmp56_ = dev;
				_tmp57_ = _tmp56_->uuid;
				_tmp58_ = entry->device;
				_tmp59_ = _tmp58_->uuid;
				if (g_strcmp0 (_tmp57_, _tmp59_) == 0) {
					active = _data7_->index;
				} else {
					gboolean _tmp60_ = FALSE;
					Device* _tmp61_;
					_tmp61_ = dev;
					if (device_has_parent (_tmp61_)) {
						Device* _tmp62_;
						Device* _tmp63_;
						const gchar* _tmp64_;
						Device* _tmp65_;
						const gchar* _tmp66_;
						_tmp62_ = dev;
						_tmp63_ = _tmp62_->parent;
						_tmp64_ = _tmp63_->uuid;
						_tmp65_ = entry->device;
						_tmp66_ = _tmp65_->uuid;
						_tmp60_ = g_strcmp0 (_tmp64_, _tmp66_) == 0;
					} else {
						_tmp60_ = FALSE;
					}
					if (_tmp60_) {
						active = _data7_->index;
					} else {
						gboolean _tmp67_ = FALSE;
						Device* _tmp68_;
						_tmp68_ = dev;
						if (device_has_children (_tmp68_)) {
							Device* _tmp69_;
							GeeArrayList* _tmp70_;
							gpointer _tmp71_;
							Device* _tmp72_;
							const gchar* _tmp73_;
							Device* _tmp74_;
							const gchar* _tmp75_;
							_tmp69_ = dev;
							_tmp70_ = _tmp69_->children;
							_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) _tmp70_, 0);
							_tmp72_ = (Device*) _tmp71_;
							_tmp73_ = _tmp72_->uuid;
							_tmp74_ = entry->device;
							_tmp75_ = _tmp74_->uuid;
							_tmp67_ = g_strcmp0 (_tmp73_, _tmp75_) == 0;
							_g_object_unref0 (_tmp72_);
						} else {
							_tmp67_ = FALSE;
						}
						if (_tmp67_) {
							active = _data7_->index;
						}
					}
				}
			}
			_g_object_unref0 (dev);
		}
	}
	if (active == -1) {
		const gchar* _tmp77_;
		_tmp77_ = entry->mount_point;
		_tmp76_ = g_strcmp0 (_tmp77_, "/") != 0;
	} else {
		_tmp76_ = FALSE;
	}
	if (_tmp76_) {
		active = 0;
	}
	_tmp78_ = _data7_->combo;
	gtk_combo_box_set_active (_tmp78_, active);
	_tmp79_ = _data7_->combo;
	g_signal_connect_data (_tmp79_, "changed", (GCallback) ___lambda108__gtk_combo_box_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp80_ = _data7_->combo;
	_tmp81_ = _g_object_ref0 (_tmp80_);
	result = _tmp81_;
	_g_object_unref0 (model);
	_g_object_unref0 (cell_text);
	_g_object_unref0 (cell_pix);
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}

static void
__lambda109_ (RestoreDeviceBox* self)
{
	BootOptionsWindow* win = NULL;
	BootOptionsWindow* _tmp0_;
	GtkWindow* _tmp1_;
	_tmp0_ = boot_options_window_new ();
	g_object_ref_sink (_tmp0_);
	win = _tmp0_;
	_tmp1_ = self->priv->parent_window;
	gtk_window_set_transient_for ((GtkWindow*) win, _tmp1_);
	_g_object_unref0 (win);
}

static void
___lambda109__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda109_ ((RestoreDeviceBox*) self);
}

static void
restore_device_box_add_boot_options (RestoreDeviceBox* self)
{
	GtkButtonBox* hbox = NULL;
	GtkButtonBox* _tmp0_;
	gchar* tt = NULL;
	gchar* _tmp1_;
	GtkButton* button = NULL;
	GtkButton* _tmp2_;
	GtkButton* btn_boot_options = NULL;
	GtkButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp0_);
	hbox = _tmp0_;
	g_object_set (hbox, "layout-style", GTK_BUTTONBOX_START, NULL);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
	_tmp1_ = g_strdup (_ ("[For Experienced Users] Change these settings if the restored system f" \
"ails to boot."));
	tt = _tmp1_;
	_tmp2_ = tee_jee_gtk_helper_add_button ((GtkBox*) hbox, _ ("Bootloader Options (Advanced)"), tt, NULL, NULL);
	button = _tmp2_;
	g_object_set ((GtkWidget*) button, "margin", 10, NULL);
	_tmp3_ = _g_object_ref0 (button);
	btn_boot_options = _tmp3_;
	g_signal_connect_object (btn_boot_options, "clicked", (GCallback) ___lambda109__gtk_button_clicked, self, 0);
	_g_object_unref0 (btn_boot_options);
	_g_object_unref0 (button);
	_g_free0 (tt);
	_g_object_unref0 (hbox);
}

static void
restore_device_box_create_infobar_location (RestoreDeviceBox* self)
{
	GtkInfoBar* infobar = NULL;
	GtkInfoBar* _tmp0_;
	GtkInfoBar* _tmp1_;
	GtkBox* content = NULL;
	GtkContainer* _tmp2_;
	GtkBox* _tmp3_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkInfoBar*) gtk_info_bar_new ();
	g_object_ref_sink (_tmp0_);
	infobar = _tmp0_;
	gtk_widget_set_no_show_all ((GtkWidget*) infobar, TRUE);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) infobar);
	_tmp1_ = _g_object_ref0 (infobar);
	_g_object_unref0 (self->priv->infobar_location);
	self->priv->infobar_location = _tmp1_;
	_tmp2_ = gtk_info_bar_get_content_area (infobar);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_box_get_type (), GtkBox));
	content = _tmp3_;
	_tmp4_ = tee_jee_gtk_helper_add_label (content, "", FALSE, FALSE, FALSE);
	label = _tmp4_;
	_tmp5_ = _g_object_ref0 (label);
	_g_object_unref0 (self->priv->lbl_infobar_location);
	self->priv->lbl_infobar_location = _tmp5_;
	_g_object_unref0 (label);
	_g_object_unref0 (content);
	_g_object_unref0 (infobar);
}

gboolean
restore_device_box_check_and_mount_devices (RestoreDeviceBox* self)
{
	Main* _tmp0_;
	Device* _tmp1_;
	Device* _tmp2_;
	Main* _tmp3_;
	Device* _tmp4_;
	Main* _tmp20_;
	gboolean _tmp73_ = FALSE;
	Main* _tmp74_;
	gboolean supported = FALSE;
	Main* _tmp84_;
	Main* _tmp85_;
	Device* _tmp86_;
	Device* _tmp87_;
	Main* _tmp88_;
	Device* _tmp89_;
	Device* _tmp90_;
	gboolean status = FALSE;
	Main* _tmp107_;
	GtkWindow* _tmp108_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = App;
	_tmp1_ = main_get_dst_root (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = App;
	_tmp4_ = _tmp3_->sys_root;
	if (_tmp2_ == _tmp4_) {
		result = TRUE;
		return result;
	}
	{
		GeeArrayList* _entry_list = NULL;
		Main* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _entry_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _entry_index = 0;
		_tmp5_ = App;
		_tmp6_ = _tmp5_->mount_list;
		_entry_list = _tmp6_;
		_tmp7_ = _entry_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_entry_size = _tmp9_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			MountEntry* entry = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			gboolean _tmp14_ = FALSE;
			MountEntry* _tmp15_;
			const gchar* _tmp16_;
			_entry_index = _entry_index + 1;
			_tmp10_ = _entry_index;
			_tmp11_ = _entry_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _entry_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _entry_index);
			entry = (MountEntry*) _tmp13_;
			_tmp15_ = entry;
			_tmp16_ = _tmp15_->mount_point;
			if (g_strcmp0 (_tmp16_, "/") == 0) {
				MountEntry* _tmp17_;
				Device* _tmp18_;
				_tmp17_ = entry;
				_tmp18_ = _tmp17_->device;
				_tmp14_ = _tmp18_ == NULL;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				GtkWindow* _tmp19_;
				_tmp19_ = self->priv->parent_window;
				tee_jee_gtk_helper_gtk_messagebox (_ ("Root device not selected"), _ ("Select the device for root file system (/)"), _tmp19_, TRUE);
				result = FALSE;
				_g_object_unref0 (entry);
				return result;
			}
			_g_object_unref0 (entry);
		}
	}
	_tmp20_ = App;
	if (_tmp20_->mirror_system) {
		{
			GeeArrayList* _entry_list = NULL;
			Main* _tmp21_;
			GeeArrayList* _tmp22_;
			gint _entry_size = 0;
			GeeArrayList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _entry_index = 0;
			_tmp21_ = App;
			_tmp22_ = _tmp21_->mount_list;
			_entry_list = _tmp22_;
			_tmp23_ = _entry_list;
			_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_entry_size = _tmp25_;
			_entry_index = -1;
			while (TRUE) {
				gint _tmp26_;
				gint _tmp27_;
				MountEntry* entry = NULL;
				GeeArrayList* _tmp28_;
				gpointer _tmp29_;
				MountEntry* _tmp30_;
				const gchar* _tmp31_;
				gboolean same = FALSE;
				MountEntry* _tmp32_;
				Device* _tmp33_;
				const gchar* _tmp34_;
				Main* _tmp35_;
				Device* _tmp36_;
				const gchar* _tmp37_;
				_entry_index = _entry_index + 1;
				_tmp26_ = _entry_index;
				_tmp27_ = _entry_size;
				if (!(_tmp26_ < _tmp27_)) {
					break;
				}
				_tmp28_ = _entry_list;
				_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _entry_index);
				entry = (MountEntry*) _tmp29_;
				_tmp30_ = entry;
				_tmp31_ = _tmp30_->mount_point;
				if (g_strcmp0 (_tmp31_, "/") != 0) {
					_g_object_unref0 (entry);
					continue;
				}
				same = FALSE;
				_tmp32_ = entry;
				_tmp33_ = _tmp32_->device;
				_tmp34_ = _tmp33_->uuid;
				_tmp35_ = App;
				_tmp36_ = _tmp35_->sys_root;
				_tmp37_ = _tmp36_->uuid;
				if (g_strcmp0 (_tmp34_, _tmp37_) == 0) {
					same = TRUE;
				} else {
					gboolean _tmp38_ = FALSE;
					MountEntry* _tmp39_;
					Device* _tmp40_;
					_tmp39_ = entry;
					_tmp40_ = _tmp39_->device;
					if (device_has_parent (_tmp40_)) {
						Main* _tmp41_;
						Device* _tmp42_;
						_tmp41_ = App;
						_tmp42_ = _tmp41_->sys_root;
						_tmp38_ = device_has_parent (_tmp42_);
					} else {
						_tmp38_ = FALSE;
					}
					if (_tmp38_) {
						MountEntry* _tmp43_;
						Device* _tmp44_;
						const gchar* _tmp45_;
						Main* _tmp46_;
						Device* _tmp47_;
						Device* _tmp48_;
						const gchar* _tmp49_;
						_tmp43_ = entry;
						_tmp44_ = _tmp43_->device;
						_tmp45_ = _tmp44_->uuid;
						_tmp46_ = App;
						_tmp47_ = _tmp46_->sys_root;
						_tmp48_ = _tmp47_->parent;
						_tmp49_ = _tmp48_->uuid;
						if (g_strcmp0 (_tmp45_, _tmp49_) == 0) {
							same = TRUE;
						}
					}
				}
				if (same) {
					GtkWindow* _tmp50_;
					_tmp50_ = self->priv->parent_window;
					tee_jee_gtk_helper_gtk_messagebox (_ ("Target device is same as system device"), _ ("Select another device for root file system (/)"), _tmp50_, TRUE);
					result = FALSE;
					_g_object_unref0 (entry);
					return result;
				}
				_g_object_unref0 (entry);
				break;
			}
		}
	}
	{
		GeeArrayList* _entry_list = NULL;
		Main* _tmp51_;
		GeeArrayList* _tmp52_;
		gint _entry_size = 0;
		GeeArrayList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _entry_index = 0;
		_tmp51_ = App;
		_tmp52_ = _tmp51_->mount_list;
		_entry_list = _tmp52_;
		_tmp53_ = _entry_list;
		_tmp54_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_entry_size = _tmp55_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			MountEntry* entry = NULL;
			GeeArrayList* _tmp58_;
			gpointer _tmp59_;
			gboolean _tmp60_ = FALSE;
			MountEntry* _tmp61_;
			const gchar* _tmp62_;
			_entry_index = _entry_index + 1;
			_tmp56_ = _entry_index;
			_tmp57_ = _entry_size;
			if (!(_tmp56_ < _tmp57_)) {
				break;
			}
			_tmp58_ = _entry_list;
			_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, _entry_index);
			entry = (MountEntry*) _tmp59_;
			_tmp61_ = entry;
			_tmp62_ = _tmp61_->mount_point;
			if (g_strcmp0 (_tmp62_, "/boot") == 0) {
				MountEntry* _tmp63_;
				Device* _tmp64_;
				_tmp63_ = entry;
				_tmp64_ = _tmp63_->device;
				_tmp60_ = _tmp64_ == NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				gboolean _tmp65_ = FALSE;
				Main* _tmp66_;
				Device* _tmp67_;
				Device* _tmp68_;
				_tmp66_ = App;
				_tmp67_ = main_get_dst_root (_tmp66_);
				_tmp68_ = _tmp67_;
				if (_tmp68_ != NULL) {
					Main* _tmp69_;
					Device* _tmp70_;
					Device* _tmp71_;
					_tmp69_ = App;
					_tmp70_ = main_get_dst_root (_tmp69_);
					_tmp71_ = _tmp70_;
					_tmp65_ = device_is_on_encrypted_partition (_tmp71_);
				} else {
					_tmp65_ = FALSE;
				}
				if (_tmp65_) {
					GtkWindow* _tmp72_;
					_tmp72_ = self->priv->parent_window;
					tee_jee_gtk_helper_gtk_messagebox (_ ("Boot device not selected"), _ ("An encrypted device is selected for root file system (/). The boot dir" \
"ectory (/boot) must be mounted on a non-encrypted device for the syste" \
"m to boot successfully.\n" \
"\n" \
"Either select a non-encrypted device for boot directory or select a no" \
"n-encrypted device for root filesystem."), _tmp72_, TRUE);
					result = FALSE;
					_g_object_unref0 (entry);
					return result;
				}
			}
			_g_object_unref0 (entry);
		}
	}
	_tmp74_ = App;
	if (_tmp74_->reinstall_grub2) {
		Main* _tmp75_;
		const gchar* _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		_tmp75_ = App;
		_tmp76_ = _tmp75_->grub_device;
		_tmp77_ = strlen (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp73_ = _tmp78_ == 0;
	} else {
		_tmp73_ = FALSE;
	}
	if (_tmp73_) {
		gchar* title = NULL;
		gchar* _tmp79_;
		gchar* msg = NULL;
		gchar* _tmp80_;
		const gchar* _tmp81_;
		const gchar* _tmp82_;
		GtkWindow* _tmp83_;
		_tmp79_ = g_strdup (_ ("GRUB device not selected"));
		title = _tmp79_;
		_tmp80_ = g_strdup (_ ("Please select the GRUB device"));
		msg = _tmp80_;
		_tmp81_ = title;
		_tmp82_ = msg;
		_tmp83_ = self->priv->parent_window;
		tee_jee_gtk_helper_gtk_messagebox (_tmp81_, _tmp82_, _tmp83_, TRUE);
		result = FALSE;
		_g_free0 (msg);
		_g_free0 (title);
		return result;
	}
	_tmp84_ = App;
	_tmp85_ = App;
	_tmp86_ = main_get_dst_root (_tmp85_);
	_tmp87_ = _tmp86_;
	_tmp88_ = App;
	_tmp89_ = main_get_dst_home (_tmp88_);
	_tmp90_ = _tmp89_;
	supported = main_check_btrfs_layout (_tmp84_, _tmp87_, _tmp90_, FALSE);
	if (!supported) {
		gchar* title = NULL;
		Main* _tmp91_;
		Device* _tmp92_;
		Device* _tmp93_;
		const gchar* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* msg = NULL;
		gchar* _tmp99_;
		const gchar* _tmp100_;
		gchar* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		const gchar* _tmp104_;
		const gchar* _tmp105_;
		GtkWindow* _tmp106_;
		_tmp91_ = App;
		_tmp92_ = main_get_dst_root (_tmp91_);
		_tmp93_ = _tmp92_;
		_tmp94_ = _tmp93_->device;
		_tmp95_ = g_strdup_printf (" (%s)", _tmp94_);
		_tmp96_ = _tmp95_;
		_tmp97_ = g_strconcat (_ ("Unsupported Subvolume Layout"), _tmp96_, NULL);
		_tmp98_ = _tmp97_;
		_g_free0 (_tmp96_);
		title = _tmp98_;
		_tmp99_ = g_strconcat (_ ("Partition has an unsupported subvolume layout."), " ", NULL);
		msg = _tmp99_;
		_tmp100_ = msg;
		_tmp101_ = g_strconcat (_ ("Only ubuntu-type layouts with @ and @home subvolumes are currently sup" \
"ported."), "\n\n", NULL);
		_tmp102_ = _tmp101_;
		_tmp103_ = g_strconcat (_tmp100_, _tmp102_, NULL);
		_g_free0 (msg);
		msg = _tmp103_;
		_g_free0 (_tmp102_);
		_tmp104_ = title;
		_tmp105_ = msg;
		_tmp106_ = self->priv->parent_window;
		tee_jee_gtk_helper_gtk_messagebox (_tmp104_, _tmp105_, _tmp106_, TRUE);
		result = FALSE;
		_g_free0 (msg);
		_g_free0 (title);
		return result;
	}
	_tmp107_ = App;
	_tmp108_ = self->priv->parent_window;
	status = main_mount_target_devices (_tmp107_, _tmp108_);
	if (status == FALSE) {
		gchar* title = NULL;
		gchar* _tmp109_;
		gchar* msg = NULL;
		gchar* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		GtkWindow* _tmp113_;
		_tmp109_ = g_strdup (_ ("Error"));
		title = _tmp109_;
		_tmp110_ = g_strdup (_ ("Failed to mount devices"));
		msg = _tmp110_;
		_tmp111_ = title;
		_tmp112_ = msg;
		_tmp113_ = self->priv->parent_window;
		tee_jee_gtk_helper_gtk_messagebox (_tmp111_, _tmp112_, _tmp113_, TRUE);
		result = FALSE;
		_g_free0 (msg);
		_g_free0 (title);
		return result;
	}
	result = TRUE;
	return result;
}

static void
restore_device_box_class_init (RestoreDeviceBoxClass * klass,
                               gpointer klass_data)
{
	restore_device_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RestoreDeviceBox_private_offset);
	G_OBJECT_CLASS (klass)->finalize = restore_device_box_finalize;
}

static void
restore_device_box_instance_init (RestoreDeviceBox * self,
                                  gpointer klass)
{
	GtkSizeGroup* _tmp0_;
	GtkSizeGroup* _tmp1_;
	GtkSizeGroup* _tmp2_;
	self->priv = restore_device_box_get_instance_private (self);
	self->priv->show_volume_name = FALSE;
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	self->priv->sg_mount_point = _tmp0_;
	_tmp1_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	self->priv->sg_device = _tmp1_;
	_tmp2_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	self->priv->sg_mount_options = _tmp2_;
	self->priv->tooltip_size = gtk_icon_size_register ("ttip", 128, 128);
}

static void
restore_device_box_finalize (GObject * obj)
{
	RestoreDeviceBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RESTORE_DEVICE_BOX, RestoreDeviceBox);
	_g_object_unref0 (self->priv->infobar_location);
	_g_object_unref0 (self->priv->lbl_infobar_location);
	_g_object_unref0 (self->priv->option_box);
	_g_object_unref0 (self->priv->lbl_header_subvol);
	_g_object_unref0 (self->priv->sg_mount_point);
	_g_object_unref0 (self->priv->sg_device);
	_g_object_unref0 (self->priv->sg_mount_options);
	_g_object_unref0 (self->priv->parent_window);
	G_OBJECT_CLASS (restore_device_box_parent_class)->finalize (obj);
}

static GType
restore_device_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RestoreDeviceBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) restore_device_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RestoreDeviceBox), 0, (GInstanceInitFunc) restore_device_box_instance_init, NULL };
	GType restore_device_box_type_id;
	restore_device_box_type_id = g_type_register_static (gtk_box_get_type (), "RestoreDeviceBox", &g_define_type_info, 0);
	RestoreDeviceBox_private_offset = g_type_add_instance_private (restore_device_box_type_id, sizeof (RestoreDeviceBoxPrivate));
	return restore_device_box_type_id;
}

GType
restore_device_box_get_type (void)
{
	static volatile gsize restore_device_box_type_id__once = 0;
	if (g_once_init_enter (&restore_device_box_type_id__once)) {
		GType restore_device_box_type_id;
		restore_device_box_type_id = restore_device_box_get_type_once ();
		g_once_init_leave (&restore_device_box_type_id__once, restore_device_box_type_id);
	}
	return restore_device_box_type_id__once;
}

