/* Paths.c generated by valac 0.56.17, the Vala compiler
 * generated from Paths.vala, do not modify */

/**/
/*  Copyright (C) 2011 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_PATHS_0_PROPERTY,
	PLANK_PATHS_NUM_PROPERTIES
};
static GParamSpec* plank_paths_properties[PLANK_PATHS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

static gpointer plank_paths_parent_class = NULL;
static GFile* plank_paths__HomeFolder;
static GFile* plank_paths__HomeFolder = NULL;
static GFile* plank_paths__DataFolder;
static GFile* plank_paths__DataFolder = NULL;
static GFile* plank_paths__ThemeFolder;
static GFile* plank_paths__ThemeFolder = NULL;
static GFile* plank_paths__ConfigHomeFolder;
static GFile* plank_paths__ConfigHomeFolder = NULL;
static GFile* plank_paths__DataHomeFolder;
static GFile* plank_paths__DataHomeFolder = NULL;
static GFile* plank_paths__CacheHomeFolder;
static GFile* plank_paths__CacheHomeFolder = NULL;
static GeeArrayList* plank_paths__DataDirFolders;
static GeeArrayList* plank_paths__DataDirFolders = NULL;
static GFile* plank_paths__AppConfigFolder;
static GFile* plank_paths__AppConfigFolder = NULL;
static GFile* plank_paths__AppDataFolder;
static GFile* plank_paths__AppDataFolder = NULL;
static GFile* plank_paths__AppThemeFolder;
static GFile* plank_paths__AppThemeFolder = NULL;
static GFile* plank_paths__AppCacheFolder;
static GFile* plank_paths__AppCacheFolder = NULL;
static gchar* plank_paths__AppName;
static gchar* plank_paths__AppName = NULL;

static PlankPaths* plank_paths_new (void);
static PlankPaths* plank_paths_construct (GType object_type);
static void plank_paths_finalize (GObject * obj);
static GType plank_paths_get_type_once (void);
static void _vala_plank_paths_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_plank_paths_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static PlankPaths*
plank_paths_construct (GType object_type)
{
	PlankPaths * self = NULL;
	self = (PlankPaths*) g_object_new (object_type, NULL);
	return self;
}

static PlankPaths*
plank_paths_new (void)
{
	return plank_paths_construct (PLANK_TYPE_PATHS);
}

/**
 * Initialize the class, creating the {@link GLib.File} instances for all
 * common paths.  Also ensure that any writable directory exists.
 *
 * @param app_name the name of the application
 * @param data_folder the path to the application's data folder
 */
void
plank_paths_initialize (const gchar* app_name,
                        const gchar* data_folder)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GeeArrayList* dirs = NULL;
	GeeArrayList* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	GeeArrayList* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	GFile* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	GFile* _tmp34_;
	GFile* _tmp35_;
	GFile* _tmp36_;
	GFile* _tmp37_;
	GFile* _tmp38_;
	GFile* _tmp39_;
	GFile* _tmp40_;
	GFile* _tmp41_;
	GFile* _tmp42_;
	GFile* _tmp43_;
	GFile* _tmp44_;
	GFile* _tmp45_;
	GFile* _tmp46_;
	GFile* _tmp47_;
	GFile* _tmp48_;
	GFile* _tmp49_;
	g_return_if_fail (app_name != NULL);
	g_return_if_fail (data_folder != NULL);
	plank_paths_set_AppName (app_name);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	plank_paths_set_HomeFolder (_tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = g_file_new_for_path (data_folder);
	_tmp4_ = _tmp3_;
	plank_paths_set_DataFolder (_tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = plank_paths_get_DataFolder ();
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_get_child (_tmp6_, "themes");
	_tmp8_ = _tmp7_;
	plank_paths_set_ThemeFolder (_tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = g_get_user_config_dir ();
	_tmp10_ = g_file_new_for_path (_tmp9_);
	_tmp11_ = _tmp10_;
	plank_paths_set_ConfigHomeFolder (_tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = g_get_user_data_dir ();
	_tmp13_ = g_file_new_for_path (_tmp12_);
	_tmp14_ = _tmp13_;
	plank_paths_set_DataHomeFolder (_tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = g_get_user_cache_dir ();
	_tmp16_ = g_file_new_for_path (_tmp15_);
	_tmp17_ = _tmp16_;
	plank_paths_set_CacheHomeFolder (_tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	dirs = _tmp18_;
	_tmp20_ = _tmp19_ = g_get_system_data_dirs ();
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp20_;
		path_collection_length1 = _vala_array_length (_tmp19_);
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			const gchar* path = NULL;
			path = path_collection[path_it];
			{
				GeeArrayList* _tmp21_;
				const gchar* _tmp22_;
				GFile* _tmp23_;
				GFile* _tmp24_;
				_tmp21_ = dirs;
				_tmp22_ = path;
				_tmp23_ = g_file_new_for_path (_tmp22_);
				_tmp24_ = _tmp23_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp24_);
				_g_object_unref0 (_tmp24_);
			}
		}
	}
	_tmp25_ = dirs;
	plank_paths_set_DataDirFolders (_tmp25_);
	_tmp26_ = plank_paths_get_ConfigHomeFolder ();
	_tmp27_ = _tmp26_;
	_tmp28_ = g_file_get_child (_tmp27_, app_name);
	_tmp29_ = _tmp28_;
	plank_paths_set_AppConfigFolder (_tmp29_);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = plank_paths_get_DataHomeFolder ();
	_tmp31_ = _tmp30_;
	_tmp32_ = g_file_get_child (_tmp31_, app_name);
	_tmp33_ = _tmp32_;
	plank_paths_set_AppDataFolder (_tmp33_);
	_g_object_unref0 (_tmp33_);
	_tmp34_ = plank_paths_get_AppDataFolder ();
	_tmp35_ = _tmp34_;
	_tmp36_ = g_file_get_child (_tmp35_, "themes");
	_tmp37_ = _tmp36_;
	plank_paths_set_AppThemeFolder (_tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = plank_paths_get_CacheHomeFolder ();
	_tmp39_ = _tmp38_;
	_tmp40_ = g_file_get_child (_tmp39_, app_name);
	_tmp41_ = _tmp40_;
	plank_paths_set_AppCacheFolder (_tmp41_);
	_g_object_unref0 (_tmp41_);
	_tmp42_ = plank_paths_get_AppConfigFolder ();
	_tmp43_ = _tmp42_;
	plank_paths_ensure_directory_exists (_tmp43_);
	_tmp44_ = plank_paths_get_AppDataFolder ();
	_tmp45_ = _tmp44_;
	plank_paths_ensure_directory_exists (_tmp45_);
	_tmp46_ = plank_paths_get_AppThemeFolder ();
	_tmp47_ = _tmp46_;
	plank_paths_ensure_directory_exists (_tmp47_);
	_tmp48_ = plank_paths_get_AppCacheFolder ();
	_tmp49_ = _tmp48_;
	plank_paths_ensure_directory_exists (_tmp49_);
	_g_object_unref0 (dirs);
}

/**
 * Creates the directory if it does not already exist
 *
 * @param dir the directory to ensure exists
 * @return true if a directory was created, false otherwise
 */
gboolean
plank_paths_ensure_directory_exists (GFile* dir)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (dir != NULL, FALSE);
	if (!g_file_query_exists (dir, NULL)) {
		{
			g_file_make_directory_with_parents (dir, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = TRUE;
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp1_ = g_file_get_path (dir);
			_tmp0_ = _tmp1_;
			if (_tmp0_ == NULL) {
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("");
				_g_free0 (_tmp0_);
				_tmp0_ = _tmp2_;
			}
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_critical ("Paths.vala:153: Could not access or create the directory '%s'. (%s)", _tmp0_, _tmp4_);
			_g_free0 (_tmp0_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp5_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = FALSE;
	return result;
}

GFile*
plank_paths_get_HomeFolder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = plank_paths__HomeFolder;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
plank_paths_set_HomeFolder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (plank_paths__HomeFolder);
	plank_paths__HomeFolder = _tmp0_;
}

GFile*
plank_paths_get_DataFolder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = plank_paths__DataFolder;
	result = _tmp0_;
	return result;
}

void
plank_paths_set_DataFolder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (plank_paths__DataFolder);
	plank_paths__DataFolder = _tmp0_;
}

GFile*
plank_paths_get_ThemeFolder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = plank_paths__ThemeFolder;
	result = _tmp0_;
	return result;
}

void
plank_paths_set_ThemeFolder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (plank_paths__ThemeFolder);
	plank_paths__ThemeFolder = _tmp0_;
}

GFile*
plank_paths_get_ConfigHomeFolder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = plank_paths__ConfigHomeFolder;
	result = _tmp0_;
	return result;
}

void
plank_paths_set_ConfigHomeFolder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (plank_paths__ConfigHomeFolder);
	plank_paths__ConfigHomeFolder = _tmp0_;
}

GFile*
plank_paths_get_DataHomeFolder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = plank_paths__DataHomeFolder;
	result = _tmp0_;
	return result;
}

void
plank_paths_set_DataHomeFolder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (plank_paths__DataHomeFolder);
	plank_paths__DataHomeFolder = _tmp0_;
}

GFile*
plank_paths_get_CacheHomeFolder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = plank_paths__CacheHomeFolder;
	result = _tmp0_;
	return result;
}

void
plank_paths_set_CacheHomeFolder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (plank_paths__CacheHomeFolder);
	plank_paths__CacheHomeFolder = _tmp0_;
}

GeeArrayList*
plank_paths_get_DataDirFolders (void)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	_tmp0_ = plank_paths__DataDirFolders;
	result = _tmp0_;
	return result;
}

void
plank_paths_set_DataDirFolders (GeeArrayList* value)
{
	GeeArrayList* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (plank_paths__DataDirFolders);
	plank_paths__DataDirFolders = _tmp0_;
}

GFile*
plank_paths_get_AppConfigFolder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = plank_paths__AppConfigFolder;
	result = _tmp0_;
	return result;
}

void
plank_paths_set_AppConfigFolder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (plank_paths__AppConfigFolder);
	plank_paths__AppConfigFolder = _tmp0_;
}

GFile*
plank_paths_get_AppDataFolder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = plank_paths__AppDataFolder;
	result = _tmp0_;
	return result;
}

void
plank_paths_set_AppDataFolder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (plank_paths__AppDataFolder);
	plank_paths__AppDataFolder = _tmp0_;
}

GFile*
plank_paths_get_AppThemeFolder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = plank_paths__AppThemeFolder;
	result = _tmp0_;
	return result;
}

void
plank_paths_set_AppThemeFolder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (plank_paths__AppThemeFolder);
	plank_paths__AppThemeFolder = _tmp0_;
}

GFile*
plank_paths_get_AppCacheFolder (void)
{
	GFile* result;
	GFile* _tmp0_;
	_tmp0_ = plank_paths__AppCacheFolder;
	result = _tmp0_;
	return result;
}

void
plank_paths_set_AppCacheFolder (GFile* value)
{
	GFile* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (plank_paths__AppCacheFolder);
	plank_paths__AppCacheFolder = _tmp0_;
}

const gchar*
plank_paths_get_AppName (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = plank_paths__AppName;
	result = _tmp0_;
	return result;
}

void
plank_paths_set_AppName (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (plank_paths__AppName);
	plank_paths__AppName = _tmp0_;
}

static void
plank_paths_class_init (PlankPathsClass * klass,
                        gpointer klass_data)
{
	plank_paths_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_paths_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_paths_set_property;
	G_OBJECT_CLASS (klass)->finalize = plank_paths_finalize;
}

static void
plank_paths_instance_init (PlankPaths * self,
                           gpointer klass)
{
}

static void
plank_paths_finalize (GObject * obj)
{
	PlankPaths * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_PATHS, PlankPaths);
	G_OBJECT_CLASS (plank_paths_parent_class)->finalize (obj);
}

/**
 * A wrapper class that gives static instances of {@link GLib.File}
 * for commonly used paths.  Most paths are retrieved from
 * {@link GLib.Environment}, which on Linux uses the XDG Base Directory
 * specification (see [[http://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html]]).
 *
 * Initializing this class also ensures any writable directories exist.
 */
static GType
plank_paths_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankPathsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_paths_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankPaths), 0, (GInstanceInitFunc) plank_paths_instance_init, NULL };
	GType plank_paths_type_id;
	plank_paths_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankPaths", &g_define_type_info, 0);
	return plank_paths_type_id;
}

GType
plank_paths_get_type (void)
{
	static volatile gsize plank_paths_type_id__once = 0;
	if (g_once_init_enter (&plank_paths_type_id__once)) {
		GType plank_paths_type_id;
		plank_paths_type_id = plank_paths_get_type_once ();
		g_once_init_leave (&plank_paths_type_id__once, plank_paths_type_id);
	}
	return plank_paths_type_id__once;
}

static void
_vala_plank_paths_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	PlankPaths * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_PATHS, PlankPaths);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_paths_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	PlankPaths * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_PATHS, PlankPaths);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

