/* SurfaceCache.c generated by valac 0.56.17, the Vala compiler
 * generated from SurfaceCache.vala, do not modify */

/**/
/*  Copyright (C) 2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "plank-internal.h"
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>
#include <gdk/gdk.h>

#define PLANK_SURFACE_CACHE_MAX_CACHE_AGE ((gint64) (((5 * 60) * 1000) * 1000))
#define PLANK_SURFACE_CACHE_MIN_DRAWING_TIME ((gint64) (10 * 1000))
#define PLANK_SURFACE_CACHE_INSANE_DRAWING_TIME ((gint64) (30 * 1000))
#define PLANK_SURFACE_CACHE_ACCESS_REWARD ((gint64) (500 * 1000))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO (plank_surface_cache_surface_info_get_type ())
#define PLANK_SURFACE_CACHE_SURFACE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO, PlankSurfaceCacheSurfaceInfo))
#define PLANK_SURFACE_CACHE_SURFACE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO, PlankSurfaceCacheSurfaceInfoClass))
#define PLANK_SURFACE_CACHE_IS_SURFACE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO))
#define PLANK_SURFACE_CACHE_IS_SURFACE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO))
#define PLANK_SURFACE_CACHE_SURFACE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO, PlankSurfaceCacheSurfaceInfoClass))

typedef struct _PlankSurfaceCacheSurfaceInfo PlankSurfaceCacheSurfaceInfo;
typedef struct _PlankSurfaceCacheSurfaceInfoClass PlankSurfaceCacheSurfaceInfoClass;
enum  {
	PLANK_SURFACE_CACHE_0_PROPERTY,
	PLANK_SURFACE_CACHE_G_TYPE,
	PLANK_SURFACE_CACHE_G_DUP_FUNC,
	PLANK_SURFACE_CACHE_G_DESTROY_FUNC,
	PLANK_SURFACE_CACHE_FLAGS_PROPERTY,
	PLANK_SURFACE_CACHE_NUM_PROPERTIES
};
static GParamSpec* plank_surface_cache_properties[PLANK_SURFACE_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _plank_surface_cache_surface_info_unref0(var) ((var == NULL) ? NULL : (var = (plank_surface_cache_surface_info_unref (var), NULL)))
typedef struct _PlankSurfaceCacheSurfaceInfoPrivate PlankSurfaceCacheSurfaceInfoPrivate;
typedef struct _PlankSurfaceCacheParamSpecSurfaceInfo PlankSurfaceCacheParamSpecSurfaceInfo;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PlankSurfaceCachePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	PlankSurfaceCacheFlags _flags;
	GeeTreeSet* infos;
	GeeHashMap* cache_map;
	PlankSurfaceCacheSurfaceInfo* last_info;
	GMutex cache_mutex;
	guint clean_up_timer_id;
};

struct _PlankSurfaceCacheSurfaceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PlankSurfaceCacheSurfaceInfoPrivate * priv;
	guint16 width;
	guint16 height;
	guint access_count;
	gint64 last_access_time;
	gint64 drawing_time;
	gdouble scale;
};

struct _PlankSurfaceCacheSurfaceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (PlankSurfaceCacheSurfaceInfo *self);
};

struct _PlankSurfaceCacheParamSpecSurfaceInfo {
	GParamSpec parent_instance;
};

static gint PlankSurfaceCache_private_offset;
static gpointer plank_surface_cache_parent_class = NULL;
static gpointer plank_surface_cache_surface_info_parent_class = NULL;

static gpointer plank_surface_cache_surface_info_ref (gpointer instance);
static void plank_surface_cache_surface_info_unref (gpointer instance);
static GParamSpec* plank_surface_cache_param_spec_surface_info (const gchar* name,
                                                         const gchar* nick,
                                                         const gchar* blurb,
                                                         GType object_type,
                                                         GParamFlags flags) G_GNUC_UNUSED ;
static void plank_surface_cache_value_set_surface_info (GValue* value,
                                                 gpointer v_object) G_GNUC_UNUSED ;
static void plank_surface_cache_value_take_surface_info (GValue* value,
                                                  gpointer v_object) G_GNUC_UNUSED ;
static gpointer plank_surface_cache_value_get_surface_info (const GValue* value) G_GNUC_UNUSED ;
static GType plank_surface_cache_surface_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PlankSurfaceCacheSurfaceInfo* plank_surface_cache_find_match (PlankSurfaceCache* self,
                                                              guint16 width,
                                                              guint16 height,
                                                              gboolean* needs_scaling);
static PlankSurfaceCacheSurfaceInfo* plank_surface_cache_surface_info_new (guint16 width,
                                                                    guint16 height,
                                                                    gint64 last_access_time,
                                                                    gint64 drawing_time);
static PlankSurfaceCacheSurfaceInfo* plank_surface_cache_surface_info_construct (GType object_type,
                                                                          guint16 width,
                                                                          guint16 height,
                                                                          gint64 last_access_time,
                                                                          gint64 drawing_time);
static gint plank_surface_cache_surface_info_compare_with (PlankSurfaceCacheSurfaceInfo* self,
                                                    guint16 width,
                                                    guint16 height);
static void plank_surface_cache_clean_up (PlankSurfaceCache* self);
static guint plank_surface_cache_surface_info_hash (PlankSurfaceCacheSurfaceInfo* s);
static gint plank_surface_cache_surface_info_compare (PlankSurfaceCacheSurfaceInfo* s1,
                                               PlankSurfaceCacheSurfaceInfo* s2);
static void plank_surface_cache_surface_info_finalize (PlankSurfaceCacheSurfaceInfo * obj);
static GType plank_surface_cache_surface_info_get_type_once (void);
static GObject * plank_surface_cache_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static gboolean _plank_surface_cache___lambda8_ (PlankSurfaceCache* self);
static gboolean __plank_surface_cache___lambda8__gsource_func (gpointer self);
static void plank_surface_cache_finalize (GObject * obj);
static GType plank_surface_cache_get_type_once (void);
static void _vala_plank_surface_cache_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_plank_surface_cache_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

/**
 * Controls some internal behaviors of a {@link Plank.SurfaceCache}
 */
static GType
plank_surface_cache_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{PLANK_SURFACE_CACHE_FLAGS_NONE, "PLANK_SURFACE_CACHE_FLAGS_NONE", "none"}, {PLANK_SURFACE_CACHE_FLAGS_ALLOW_DOWNSCALE, "PLANK_SURFACE_CACHE_FLAGS_ALLOW_DOWNSCALE", "allow-downscale"}, {PLANK_SURFACE_CACHE_FLAGS_ALLOW_UPSCALE, "PLANK_SURFACE_CACHE_FLAGS_ALLOW_UPSCALE", "allow-upscale"}, {PLANK_SURFACE_CACHE_FLAGS_ALLOW_SCALE, "PLANK_SURFACE_CACHE_FLAGS_ALLOW_SCALE", "allow-scale"}, {PLANK_SURFACE_CACHE_FLAGS_ADAPTIVE_SCALE, "PLANK_SURFACE_CACHE_FLAGS_ADAPTIVE_SCALE", "adaptive-scale"}, {0, NULL, NULL}};
	GType plank_surface_cache_flags_type_id;
	plank_surface_cache_flags_type_id = g_flags_register_static ("PlankSurfaceCacheFlags", values);
	return plank_surface_cache_flags_type_id;
}

GType
plank_surface_cache_flags_get_type (void)
{
	static volatile gsize plank_surface_cache_flags_type_id__once = 0;
	if (g_once_init_enter (&plank_surface_cache_flags_type_id__once)) {
		GType plank_surface_cache_flags_type_id;
		plank_surface_cache_flags_type_id = plank_surface_cache_flags_get_type_once ();
		g_once_init_leave (&plank_surface_cache_flags_type_id__once, plank_surface_cache_flags_type_id);
	}
	return plank_surface_cache_flags_type_id__once;
}

static inline gpointer
plank_surface_cache_get_instance_private (PlankSurfaceCache* self)
{
	return G_STRUCT_MEMBER_P (self, PlankSurfaceCache_private_offset);
}

PlankSurfaceCache*
plank_surface_cache_construct (GType object_type,
                               GType g_type,
                               GBoxedCopyFunc g_dup_func,
                               GDestroyNotify g_destroy_func,
                               PlankSurfaceCacheFlags flags)
{
	PlankSurfaceCache * self = NULL;
	self = (PlankSurfaceCache*) g_object_new (object_type, "g-type", g_type, "g-dup-func", g_dup_func, "g-destroy-func", g_destroy_func, "flags", flags, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}

PlankSurfaceCache*
plank_surface_cache_new (GType g_type,
                         GBoxedCopyFunc g_dup_func,
                         GDestroyNotify g_destroy_func,
                         PlankSurfaceCacheFlags flags)
{
	return plank_surface_cache_construct (PLANK_TYPE_SURFACE_CACHE, g_type, g_dup_func, g_destroy_func, flags);
}

static gpointer
_plank_surface_cache_surface_info_ref0 (gpointer self)
{
	return self ? plank_surface_cache_surface_info_ref (self) : NULL;
}

PlankSurface*
plank_surface_cache_get_surface (PlankSurfaceCache* self,
                                 GType g_type,
                                 GBoxedCopyFunc g_dup_func,
                                 GDestroyNotify g_destroy_func,
                                 gint width,
                                 gint height,
                                 PlankSurface* model,
                                 PlankDrawFunc draw_func,
                                 gpointer draw_func_target,
                                 PlankDrawDataFunc draw_data_func,
                                 gpointer draw_data_func_target)
{
	PlankSurfaceCacheSurfaceInfo* info = NULL;
	PlankSurfaceCacheSurfaceInfo* current_info = NULL;
	PlankSurface* surface = NULL;
	gboolean needs_scaling = FALSE;
	gboolean _tmp0_ = FALSE;
	PlankSurfaceCacheSurfaceInfo* _tmp1_;
	PlankSurfaceCacheSurfaceInfo* _tmp2_;
	PlankSurfaceCacheSurfaceInfo* _tmp3_;
	PlankSurfaceCacheSurfaceInfo* _tmp4_;
	gint64 access_time = 0LL;
	PlankSurfaceCacheSurfaceInfo* _tmp5_;
	PlankSurface* _tmp14_;
	gint64 finish_time = 0LL;
	gint64 time_elapsed = 0LL;
	gboolean _tmp15_ = FALSE;
	PlankSurfaceCacheSurfaceInfo* _tmp19_;
	PlankSurfaceCacheSurfaceInfo* _tmp20_;
	guint _tmp21_;
	GeeHashMap* _tmp22_;
	PlankSurfaceCacheSurfaceInfo* _tmp23_;
	PlankSurface* _tmp24_;
	GeeTreeSet* _tmp25_;
	PlankSurfaceCacheSurfaceInfo* _tmp26_;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	_vala_return_val_if_fail ((width >= 0) && (height >= 0), "width >= 0 && height >= 0", NULL);
	g_mutex_lock (&self->priv->cache_mutex);
	current_info = NULL;
	surface = NULL;
	needs_scaling = FALSE;
	_tmp1_ = plank_surface_cache_find_match (self, (guint16) width, (guint16) height, &_tmp0_);
	needs_scaling = _tmp0_;
	info = _tmp1_;
	_tmp2_ = info;
	self->priv->last_info = _tmp2_;
	_tmp3_ = info;
	_tmp4_ = _plank_surface_cache_surface_info_ref0 (_tmp3_);
	_plank_surface_cache_surface_info_unref0 (current_info);
	current_info = _tmp4_;
	access_time = g_get_monotonic_time ();
	_tmp5_ = current_info;
	if (_tmp5_ != NULL) {
		PlankSurfaceCacheSurfaceInfo* _tmp6_;
		PlankSurfaceCacheSurfaceInfo* _tmp7_;
		guint _tmp8_;
		GeeHashMap* _tmp9_;
		PlankSurfaceCacheSurfaceInfo* _tmp10_;
		gpointer _tmp11_;
		_tmp6_ = current_info;
		_tmp6_->last_access_time = access_time;
		_tmp7_ = current_info;
		_tmp8_ = _tmp7_->access_count;
		_tmp7_->access_count = _tmp8_ + 1;
		_tmp9_ = self->priv->cache_map;
		_tmp10_ = current_info;
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
		_g_object_unref0 (surface);
		surface = (PlankSurface*) _tmp11_;
		g_mutex_unlock (&self->priv->cache_mutex);
		if (needs_scaling) {
			PlankSurface* _tmp12_;
			PlankSurface* _tmp13_;
			_tmp12_ = surface;
			_tmp13_ = plank_surface_scaled_copy (_tmp12_, width, height);
			result = _tmp13_;
			_g_object_unref0 (surface);
			_plank_surface_cache_surface_info_unref0 (current_info);
			return result;
		} else {
			result = surface;
			_plank_surface_cache_surface_info_unref0 (current_info);
			return result;
		}
	}
	_tmp14_ = draw_func (width, height, model, draw_data_func, draw_data_func_target, draw_func_target);
	_g_object_unref0 (surface);
	surface = _tmp14_;
	finish_time = g_get_monotonic_time ();
	time_elapsed = finish_time - access_time;
	if (time_elapsed >= PLANK_SURFACE_CACHE_INSANE_DRAWING_TIME) {
		PlankSurfaceCacheFlags _tmp16_;
		_tmp16_ = self->priv->_flags;
		_tmp15_ = _tmp16_ == PLANK_SURFACE_CACHE_FLAGS_NONE;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		PlankSurface* _tmp17_;
		gchar* _tmp18_;
		g_warning ("Creating surface took WAY TOO LONG (%" G_GINT64_FORMAT "ms), enabled downscaling for this cache!", time_elapsed / 1000);
		plank_surface_cache_set_flags (self, PLANK_SURFACE_CACHE_FLAGS_ALLOW_DOWNSCALE);
		_tmp17_ = surface;
		_tmp18_ = g_strdup (PLANK_SURFACE_STATS_DRAWING_TIME_EXCEEDED);
		g_object_set_qdata_full ((GObject*) _tmp17_, plank_quark_surface_stats, _tmp18_, g_free);
	}
	_tmp19_ = plank_surface_cache_surface_info_new ((guint16) width, (guint16) height, finish_time, time_elapsed);
	_plank_surface_cache_surface_info_unref0 (current_info);
	current_info = _tmp19_;
	_tmp20_ = current_info;
	_tmp21_ = _tmp20_->access_count;
	_tmp20_->access_count = _tmp21_ + 1;
	_tmp22_ = self->priv->cache_map;
	_tmp23_ = current_info;
	_tmp24_ = surface;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, _tmp23_, _tmp24_);
	_tmp25_ = self->priv->infos;
	_tmp26_ = current_info;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
	g_mutex_unlock (&self->priv->cache_mutex);
	result = surface;
	_plank_surface_cache_surface_info_unref0 (current_info);
	return result;
}

static PlankSurfaceCacheSurfaceInfo*
plank_surface_cache_find_match (PlankSurfaceCache* self,
                                guint16 width,
                                guint16 height,
                                gboolean* needs_scaling)
{
	gboolean _vala_needs_scaling = FALSE;
	GeeTreeSet* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	PlankSurfaceCacheSurfaceInfo* info = NULL;
	PlankSurfaceCacheSurfaceInfo* _tmp3_;
	GeeBidirIterator* infos_it = NULL;
	PlankSurfaceCacheSurfaceInfo* _tmp21_;
	gboolean _tmp27_ = FALSE;
	PlankSurfaceCacheSurfaceInfo* _tmp28_;
	PlankSurfaceCacheSurfaceInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_needs_scaling = FALSE;
	_tmp0_ = self->priv->infos;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = NULL;
		if (needs_scaling) {
			*needs_scaling = _vala_needs_scaling;
		}
		return result;
	}
	_tmp3_ = self->priv->last_info;
	if (_tmp3_ != NULL) {
		PlankSurfaceCacheSurfaceInfo* _tmp4_;
		gboolean _tmp5_ = FALSE;
		PlankSurfaceCacheSurfaceInfo* _tmp6_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		PlankSurfaceCacheFlags _tmp11_;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		PlankSurfaceCacheFlags _tmp17_;
		_tmp4_ = self->priv->last_info;
		info = _tmp4_;
		_tmp6_ = info;
		if (_tmp6_->width == width) {
			PlankSurfaceCacheSurfaceInfo* _tmp7_;
			_tmp7_ = info;
			_tmp5_ = _tmp7_->height == height;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			PlankSurfaceCacheSurfaceInfo* _tmp8_;
			_tmp8_ = info;
			result = _tmp8_;
			if (needs_scaling) {
				*needs_scaling = _vala_needs_scaling;
			}
			return result;
		}
		_tmp11_ = self->priv->_flags;
		if ((_tmp11_ & PLANK_SURFACE_CACHE_FLAGS_ALLOW_DOWNSCALE) != 0) {
			PlankSurfaceCacheSurfaceInfo* _tmp12_;
			_tmp12_ = info;
			_tmp10_ = _tmp12_->width > width;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			PlankSurfaceCacheSurfaceInfo* _tmp13_;
			_tmp13_ = info;
			_tmp9_ = _tmp13_->height > height;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			PlankSurfaceCacheSurfaceInfo* _tmp14_;
			_vala_needs_scaling = TRUE;
			_tmp14_ = info;
			result = _tmp14_;
			if (needs_scaling) {
				*needs_scaling = _vala_needs_scaling;
			}
			return result;
		}
		_tmp17_ = self->priv->_flags;
		if ((_tmp17_ & PLANK_SURFACE_CACHE_FLAGS_ALLOW_UPSCALE) != 0) {
			PlankSurfaceCacheSurfaceInfo* _tmp18_;
			_tmp18_ = info;
			_tmp16_ = _tmp18_->width < width;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			PlankSurfaceCacheSurfaceInfo* _tmp19_;
			_tmp19_ = info;
			_tmp15_ = _tmp19_->height < height;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			PlankSurfaceCacheSurfaceInfo* _tmp20_;
			_vala_needs_scaling = TRUE;
			_tmp20_ = info;
			result = _tmp20_;
			if (needs_scaling) {
				*needs_scaling = _vala_needs_scaling;
			}
			return result;
		}
	}
	_tmp21_ = self->priv->last_info;
	if (_tmp21_ != NULL) {
		GeeTreeSet* _tmp22_;
		PlankSurfaceCacheSurfaceInfo* _tmp23_;
		GeeIterator* _tmp24_;
		_tmp22_ = self->priv->infos;
		_tmp23_ = self->priv->last_info;
		_tmp24_ = gee_abstract_sorted_set_iterator_at ((GeeAbstractSortedSet*) _tmp22_, _tmp23_);
		_g_object_unref0 (infos_it);
		infos_it = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator);
	} else {
		GeeTreeSet* _tmp25_;
		GeeBidirIterator* _tmp26_;
		_tmp25_ = self->priv->infos;
		_tmp26_ = gee_abstract_bidir_sorted_set_bidir_iterator ((GeeAbstractBidirSortedSet*) _tmp25_);
		_g_object_unref0 (infos_it);
		infos_it = _tmp26_;
	}
	_tmp28_ = self->priv->last_info;
	if (_tmp28_ != NULL) {
		PlankSurfaceCacheSurfaceInfo* _tmp29_;
		_tmp29_ = self->priv->last_info;
		_tmp27_ = plank_surface_cache_surface_info_compare_with (_tmp29_, width, height) > 0;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		while (TRUE) {
			GeeBidirIterator* _tmp30_;
			GeeBidirIterator* _tmp31_;
			gpointer _tmp32_;
			gboolean _tmp33_ = FALSE;
			PlankSurfaceCacheSurfaceInfo* _tmp34_;
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			PlankSurfaceCacheFlags _tmp39_;
			gboolean _tmp43_ = FALSE;
			gboolean _tmp44_ = FALSE;
			PlankSurfaceCacheFlags _tmp45_;
			_tmp30_ = infos_it;
			if (!gee_bidir_iterator_previous (_tmp30_)) {
				break;
			}
			_tmp31_ = infos_it;
			_tmp32_ = gee_iterator_get ((GeeIterator*) _tmp31_);
			info = (PlankSurfaceCacheSurfaceInfo*) _tmp32_;
			_tmp34_ = info;
			if (_tmp34_->width == width) {
				PlankSurfaceCacheSurfaceInfo* _tmp35_;
				_tmp35_ = info;
				_tmp33_ = _tmp35_->height == height;
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				PlankSurfaceCacheSurfaceInfo* _tmp36_;
				_tmp36_ = info;
				result = _tmp36_;
				_g_object_unref0 (infos_it);
				if (needs_scaling) {
					*needs_scaling = _vala_needs_scaling;
				}
				return result;
			}
			_tmp39_ = self->priv->_flags;
			if ((_tmp39_ & PLANK_SURFACE_CACHE_FLAGS_ALLOW_DOWNSCALE) != 0) {
				PlankSurfaceCacheSurfaceInfo* _tmp40_;
				_tmp40_ = info;
				_tmp38_ = _tmp40_->width > width;
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				PlankSurfaceCacheSurfaceInfo* _tmp41_;
				_tmp41_ = info;
				_tmp37_ = _tmp41_->height > height;
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				PlankSurfaceCacheSurfaceInfo* _tmp42_;
				_vala_needs_scaling = TRUE;
				_tmp42_ = info;
				result = _tmp42_;
				_g_object_unref0 (infos_it);
				if (needs_scaling) {
					*needs_scaling = _vala_needs_scaling;
				}
				return result;
			}
			_tmp45_ = self->priv->_flags;
			if ((_tmp45_ & PLANK_SURFACE_CACHE_FLAGS_ALLOW_UPSCALE) != 0) {
				PlankSurfaceCacheSurfaceInfo* _tmp46_;
				_tmp46_ = info;
				_tmp44_ = _tmp46_->width < width;
			} else {
				_tmp44_ = FALSE;
			}
			if (_tmp44_) {
				PlankSurfaceCacheSurfaceInfo* _tmp47_;
				_tmp47_ = info;
				_tmp43_ = _tmp47_->height < height;
			} else {
				_tmp43_ = FALSE;
			}
			if (_tmp43_) {
				PlankSurfaceCacheSurfaceInfo* _tmp48_;
				_vala_needs_scaling = TRUE;
				_tmp48_ = info;
				result = _tmp48_;
				_g_object_unref0 (infos_it);
				if (needs_scaling) {
					*needs_scaling = _vala_needs_scaling;
				}
				return result;
			}
		}
	} else {
		while (TRUE) {
			GeeBidirIterator* _tmp49_;
			GeeBidirIterator* _tmp50_;
			gpointer _tmp51_;
			gboolean _tmp52_ = FALSE;
			PlankSurfaceCacheSurfaceInfo* _tmp53_;
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			PlankSurfaceCacheFlags _tmp58_;
			gboolean _tmp62_ = FALSE;
			gboolean _tmp63_ = FALSE;
			PlankSurfaceCacheFlags _tmp64_;
			_tmp49_ = infos_it;
			if (!gee_iterator_next ((GeeIterator*) _tmp49_)) {
				break;
			}
			_tmp50_ = infos_it;
			_tmp51_ = gee_iterator_get ((GeeIterator*) _tmp50_);
			info = (PlankSurfaceCacheSurfaceInfo*) _tmp51_;
			_tmp53_ = info;
			if (_tmp53_->width == width) {
				PlankSurfaceCacheSurfaceInfo* _tmp54_;
				_tmp54_ = info;
				_tmp52_ = _tmp54_->height == height;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				PlankSurfaceCacheSurfaceInfo* _tmp55_;
				_tmp55_ = info;
				result = _tmp55_;
				_g_object_unref0 (infos_it);
				if (needs_scaling) {
					*needs_scaling = _vala_needs_scaling;
				}
				return result;
			}
			_tmp58_ = self->priv->_flags;
			if ((_tmp58_ & PLANK_SURFACE_CACHE_FLAGS_ALLOW_DOWNSCALE) != 0) {
				PlankSurfaceCacheSurfaceInfo* _tmp59_;
				_tmp59_ = info;
				_tmp57_ = _tmp59_->width > width;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				PlankSurfaceCacheSurfaceInfo* _tmp60_;
				_tmp60_ = info;
				_tmp56_ = _tmp60_->height > height;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				PlankSurfaceCacheSurfaceInfo* _tmp61_;
				_vala_needs_scaling = TRUE;
				_tmp61_ = info;
				result = _tmp61_;
				_g_object_unref0 (infos_it);
				if (needs_scaling) {
					*needs_scaling = _vala_needs_scaling;
				}
				return result;
			}
			_tmp64_ = self->priv->_flags;
			if ((_tmp64_ & PLANK_SURFACE_CACHE_FLAGS_ALLOW_UPSCALE) != 0) {
				PlankSurfaceCacheSurfaceInfo* _tmp65_;
				_tmp65_ = info;
				_tmp63_ = _tmp65_->width < width;
			} else {
				_tmp63_ = FALSE;
			}
			if (_tmp63_) {
				PlankSurfaceCacheSurfaceInfo* _tmp66_;
				_tmp66_ = info;
				_tmp62_ = _tmp66_->height < height;
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				PlankSurfaceCacheSurfaceInfo* _tmp67_;
				_vala_needs_scaling = TRUE;
				_tmp67_ = info;
				result = _tmp67_;
				_g_object_unref0 (infos_it);
				if (needs_scaling) {
					*needs_scaling = _vala_needs_scaling;
				}
				return result;
			}
		}
	}
	result = NULL;
	_g_object_unref0 (infos_it);
	if (needs_scaling) {
		*needs_scaling = _vala_needs_scaling;
	}
	return result;
}

void
plank_surface_cache_clear (PlankSurfaceCache* self)
{
	GeeTreeSet* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->cache_mutex);
	_tmp0_ = self->priv->infos;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->cache_map;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp1_);
	self->priv->last_info = NULL;
	g_mutex_unlock (&self->priv->cache_mutex);
}

static void
plank_surface_cache_clean_up (PlankSurfaceCache* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint64 now = 0LL;
	gint size_before = 0;
	GeeHashMap* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint size_current = 0;
	GeeMapIterator* cache_it = NULL;
	GeeHashMap* _tmp6_;
	GeeMapIterator* _tmp7_;
	GeeHashMap* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->cache_mutex);
	_tmp0_ = self->priv->cache_map;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= 1) {
		g_mutex_unlock (&self->priv->cache_mutex);
		return;
	}
	now = g_get_monotonic_time ();
	_tmp3_ = self->priv->cache_map;
	_tmp4_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	size_before = _tmp5_;
	size_current = size_before;
	_tmp6_ = self->priv->cache_map;
	_tmp7_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp6_);
	cache_it = _tmp7_;
	while (TRUE) {
		GeeMapIterator* _tmp8_;
		PlankSurfaceCacheSurfaceInfo* info = NULL;
		GeeMapIterator* _tmp9_;
		gpointer _tmp10_;
		PlankSurfaceCacheSurfaceInfo* _tmp11_;
		PlankSurfaceCacheSurfaceInfo* _tmp12_;
		PlankSurfaceCacheSurfaceInfo* _tmp13_;
		GeeTreeSet* _tmp14_;
		PlankSurfaceCacheSurfaceInfo* _tmp15_;
		GeeMapIterator* _tmp16_;
		gint _tmp17_;
		_tmp8_ = cache_it;
		if (!gee_map_iterator_next (_tmp8_)) {
			break;
		}
		_tmp9_ = cache_it;
		_tmp10_ = gee_map_iterator_get_key (_tmp9_);
		info = (PlankSurfaceCacheSurfaceInfo*) _tmp10_;
		_tmp11_ = info;
		_tmp12_ = info;
		if ((now - _tmp11_->last_access_time) < (PLANK_SURFACE_CACHE_ACCESS_REWARD * _tmp12_->access_count)) {
			_plank_surface_cache_surface_info_unref0 (info);
			continue;
		}
		_tmp13_ = info;
		if (_tmp13_->drawing_time > PLANK_SURFACE_CACHE_MIN_DRAWING_TIME) {
			_plank_surface_cache_surface_info_unref0 (info);
			continue;
		}
		if (size_current <= 1) {
			_plank_surface_cache_surface_info_unref0 (info);
			break;
		}
		_tmp14_ = self->priv->infos;
		_tmp15_ = info;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp14_, _tmp15_);
		_tmp16_ = cache_it;
		gee_map_iterator_unset (_tmp16_);
		_tmp17_ = size_current;
		size_current = _tmp17_ - 1;
		_plank_surface_cache_surface_info_unref0 (info);
	}
	self->priv->last_info = NULL;
	_tmp18_ = self->priv->cache_map;
	_tmp19_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp18_);
	_tmp20_ = _tmp19_;
	plank_logger_verbose ("SurfaceCache.clean_up (%i -> %i) ", size_before, _tmp20_, NULL);
	g_mutex_unlock (&self->priv->cache_mutex);
	_g_object_unref0 (cache_it);
}

PlankSurfaceCacheFlags
plank_surface_cache_get_flags (PlankSurfaceCache* self)
{
	PlankSurfaceCacheFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_flags;
	return result;
}

void
plank_surface_cache_set_flags (PlankSurfaceCache* self,
                               PlankSurfaceCacheFlags value)
{
	PlankSurfaceCacheFlags old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_surface_cache_get_flags (self);
	if (old_value != value) {
		self->priv->_flags = value;
		g_object_notify_by_pspec ((GObject *) self, plank_surface_cache_properties[PLANK_SURFACE_CACHE_FLAGS_PROPERTY]);
	}
}

static PlankSurfaceCacheSurfaceInfo*
plank_surface_cache_surface_info_construct (GType object_type,
                                            guint16 width,
                                            guint16 height,
                                            gint64 last_access_time,
                                            gint64 drawing_time)
{
	PlankSurfaceCacheSurfaceInfo* self = NULL;
	self = (PlankSurfaceCacheSurfaceInfo*) g_type_create_instance (object_type);
	self->width = width;
	self->height = height;
	self->last_access_time = last_access_time;
	self->drawing_time = drawing_time;
	self->access_count = (guint) 0;
	self->scale = 1.0;
	return self;
}

static PlankSurfaceCacheSurfaceInfo*
plank_surface_cache_surface_info_new (guint16 width,
                                      guint16 height,
                                      gint64 last_access_time,
                                      gint64 drawing_time)
{
	return plank_surface_cache_surface_info_construct (PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO, width, height, last_access_time, drawing_time);
}

static guint
plank_surface_cache_surface_info_hash (PlankSurfaceCacheSurfaceInfo* s)
{
	guint n1 = 0U;
	guint n2 = 0U;
	guint _tmp0_ = 0U;
	guint result;
	g_return_val_if_fail (s != NULL, 0U);
	n1 = (guint) s->width;
	n2 = (guint) s->height;
	if (n1 >= n2) {
		_tmp0_ = ((n1 * n1) + n1) + n2;
	} else {
		_tmp0_ = n1 + (n2 * n2);
	}
	result = _tmp0_;
	return result;
}

static gint
plank_surface_cache_surface_info_compare (PlankSurfaceCacheSurfaceInfo* s1,
                                          PlankSurfaceCacheSurfaceInfo* s2)
{
	gint result;
	g_return_val_if_fail (s1 != NULL, 0);
	g_return_val_if_fail (s2 != NULL, 0);
	if (s1 == s2) {
		result = 0;
		return result;
	}
	result = ((2 * (s1->width - s2->width)) + s2->height) - s2->height;
	return result;
}

static gint
plank_surface_cache_surface_info_compare_with (PlankSurfaceCacheSurfaceInfo* self,
                                               guint16 width,
                                               guint16 height)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ((2 * (self->width - width)) + self->height) - height;
	return result;
}

static void
plank_surface_cache_value_surface_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
plank_surface_cache_value_surface_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		plank_surface_cache_surface_info_unref (value->data[0].v_pointer);
	}
}

static void
plank_surface_cache_value_surface_info_copy_value (const GValue* src_value,
                                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = plank_surface_cache_surface_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
plank_surface_cache_value_surface_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
plank_surface_cache_value_surface_info_collect_value (GValue* value,
                                                      guint n_collect_values,
                                                      GTypeCValue* collect_values,
                                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PlankSurfaceCacheSurfaceInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = plank_surface_cache_surface_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
plank_surface_cache_value_surface_info_lcopy_value (const GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	PlankSurfaceCacheSurfaceInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = plank_surface_cache_surface_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
plank_surface_cache_param_spec_surface_info (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags)
{
	PlankSurfaceCacheParamSpecSurfaceInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
plank_surface_cache_value_get_surface_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO), NULL);
	return value->data[0].v_pointer;
}

static void
plank_surface_cache_value_set_surface_info (GValue* value,
                                            gpointer v_object)
{
	PlankSurfaceCacheSurfaceInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		plank_surface_cache_surface_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plank_surface_cache_surface_info_unref (old);
	}
}

static void
plank_surface_cache_value_take_surface_info (GValue* value,
                                             gpointer v_object)
{
	PlankSurfaceCacheSurfaceInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plank_surface_cache_surface_info_unref (old);
	}
}

static void
plank_surface_cache_surface_info_class_init (PlankSurfaceCacheSurfaceInfoClass * klass,
                                             gpointer klass_data)
{
	plank_surface_cache_surface_info_parent_class = g_type_class_peek_parent (klass);
	((PlankSurfaceCacheSurfaceInfoClass *) klass)->finalize = plank_surface_cache_surface_info_finalize;
}

static void
plank_surface_cache_surface_info_instance_init (PlankSurfaceCacheSurfaceInfo * self,
                                                gpointer klass)
{
	self->ref_count = 1;
}

static void
plank_surface_cache_surface_info_finalize (PlankSurfaceCacheSurfaceInfo * obj)
{
	PlankSurfaceCacheSurfaceInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO, PlankSurfaceCacheSurfaceInfo);
	g_signal_handlers_destroy (self);
}

static GType
plank_surface_cache_surface_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { plank_surface_cache_value_surface_info_init, plank_surface_cache_value_surface_info_free_value, plank_surface_cache_value_surface_info_copy_value, plank_surface_cache_value_surface_info_peek_pointer, "p", plank_surface_cache_value_surface_info_collect_value, "p", plank_surface_cache_value_surface_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PlankSurfaceCacheSurfaceInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_surface_cache_surface_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankSurfaceCacheSurfaceInfo), 0, (GInstanceInitFunc) plank_surface_cache_surface_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType plank_surface_cache_surface_info_type_id;
	plank_surface_cache_surface_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PlankSurfaceCacheSurfaceInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return plank_surface_cache_surface_info_type_id;
}

static GType
plank_surface_cache_surface_info_get_type (void)
{
	static volatile gsize plank_surface_cache_surface_info_type_id__once = 0;
	if (g_once_init_enter (&plank_surface_cache_surface_info_type_id__once)) {
		GType plank_surface_cache_surface_info_type_id;
		plank_surface_cache_surface_info_type_id = plank_surface_cache_surface_info_get_type_once ();
		g_once_init_leave (&plank_surface_cache_surface_info_type_id__once, plank_surface_cache_surface_info_type_id);
	}
	return plank_surface_cache_surface_info_type_id__once;
}

static gpointer
plank_surface_cache_surface_info_ref (gpointer instance)
{
	PlankSurfaceCacheSurfaceInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
plank_surface_cache_surface_info_unref (gpointer instance)
{
	PlankSurfaceCacheSurfaceInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PLANK_SURFACE_CACHE_SURFACE_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gboolean
_plank_surface_cache___lambda8_ (PlankSurfaceCache* self)
{
	gboolean result;
	plank_surface_cache_clean_up (self);
	result = TRUE;
	return result;
}

static gboolean
__plank_surface_cache___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = _plank_surface_cache___lambda8_ ((PlankSurfaceCache*) self);
	return result;
}

static GObject *
plank_surface_cache_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankSurfaceCache * self;
	GeeTreeSet* _tmp0_;
	GeeHashMap* _tmp1_;
	parent_class = G_OBJECT_CLASS (plank_surface_cache_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_SURFACE_CACHE, PlankSurfaceCache);
	_tmp0_ = gee_tree_set_new (PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO, NULL, NULL, (GCompareDataFunc) plank_surface_cache_surface_info_compare, NULL, NULL);
	_g_object_unref0 (self->priv->infos);
	self->priv->infos = _tmp0_;
	_tmp1_ = gee_hash_map_new (PLANK_SURFACE_CACHE_TYPE_SURFACE_INFO, (GBoxedCopyFunc) plank_surface_cache_surface_info_ref, (GDestroyNotify) plank_surface_cache_surface_info_unref, PLANK_TYPE_SURFACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) plank_surface_cache_surface_info_hash, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->cache_map);
	self->priv->cache_map = _tmp1_;
	self->priv->last_info = NULL;
	self->priv->clean_up_timer_id = gdk_threads_add_timeout ((guint) ((5 * 60) * 1000), __plank_surface_cache___lambda8__gsource_func, self);
	return obj;
}

static void
plank_surface_cache_class_init (PlankSurfaceCacheClass * klass,
                                gpointer klass_data)
{
	plank_surface_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankSurfaceCache_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_surface_cache_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_surface_cache_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_surface_cache_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_surface_cache_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_SURFACE_CACHE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_SURFACE_CACHE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_SURFACE_CACHE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_SURFACE_CACHE_FLAGS_PROPERTY, plank_surface_cache_properties[PLANK_SURFACE_CACHE_FLAGS_PROPERTY] = g_param_spec_flags ("flags", "flags", "flags", PLANK_TYPE_SURFACE_CACHE_FLAGS, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
plank_surface_cache_instance_init (PlankSurfaceCache * self,
                                   gpointer klass)
{
	self->priv = plank_surface_cache_get_instance_private (self);
	self->priv->clean_up_timer_id = 0U;
}

static void
plank_surface_cache_finalize (GObject * obj)
{
	PlankSurfaceCache * self;
	GeeHashMap* _tmp0_;
	GeeTreeSet* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_SURFACE_CACHE, PlankSurfaceCache);
	if (self->priv->clean_up_timer_id > 0U) {
		g_source_remove (self->priv->clean_up_timer_id);
		self->priv->clean_up_timer_id = 0U;
	}
	_tmp0_ = self->priv->cache_map;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	_tmp1_ = self->priv->infos;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	self->priv->last_info = NULL;
	_g_object_unref0 (self->priv->infos);
	_g_object_unref0 (self->priv->cache_map);
	_vala_clear_GMutex (&self->priv->cache_mutex);
	G_OBJECT_CLASS (plank_surface_cache_parent_class)->finalize (obj);
}

/**
 * Cache multiple sizes of the assumed same image
 */
static GType
plank_surface_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankSurfaceCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_surface_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankSurfaceCache), 0, (GInstanceInitFunc) plank_surface_cache_instance_init, NULL };
	GType plank_surface_cache_type_id;
	plank_surface_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankSurfaceCache", &g_define_type_info, 0);
	PlankSurfaceCache_private_offset = g_type_add_instance_private (plank_surface_cache_type_id, sizeof (PlankSurfaceCachePrivate));
	return plank_surface_cache_type_id;
}

GType
plank_surface_cache_get_type (void)
{
	static volatile gsize plank_surface_cache_type_id__once = 0;
	if (g_once_init_enter (&plank_surface_cache_type_id__once)) {
		GType plank_surface_cache_type_id;
		plank_surface_cache_type_id = plank_surface_cache_get_type_once ();
		g_once_init_leave (&plank_surface_cache_type_id__once, plank_surface_cache_type_id);
	}
	return plank_surface_cache_type_id__once;
}

static void
_vala_plank_surface_cache_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	PlankSurfaceCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_SURFACE_CACHE, PlankSurfaceCache);
	switch (property_id) {
		case PLANK_SURFACE_CACHE_FLAGS_PROPERTY:
		g_value_set_flags (value, plank_surface_cache_get_flags (self));
		break;
		case PLANK_SURFACE_CACHE_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case PLANK_SURFACE_CACHE_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case PLANK_SURFACE_CACHE_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_surface_cache_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	PlankSurfaceCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_SURFACE_CACHE, PlankSurfaceCache);
	switch (property_id) {
		case PLANK_SURFACE_CACHE_FLAGS_PROPERTY:
		plank_surface_cache_set_flags (self, g_value_get_flags (value));
		break;
		case PLANK_SURFACE_CACHE_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case PLANK_SURFACE_CACHE_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case PLANK_SURFACE_CACHE_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

