/* cli-screen-recorder.c generated by valac 0.56.17, the Vala compiler
 * generated from cli-screen-recorder.vala, do not modify */

/*
Peek Copyright (c) 2015-2018 by Philipp Wolfer <ph.wolfer@gmail.com>

This file is part of Peek.

This software is licensed under the GNU General Public License
(version 3 or later). See the LICENSE file in this distribution.
*/

#include "../../application.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PEEK_RECORDING_CLI_SCREEN_RECORDER_0_PROPERTY,
	PEEK_RECORDING_CLI_SCREEN_RECORDER_NUM_PROPERTIES
};
static GParamSpec* peek_recording_cli_screen_recorder_properties[PEEK_RECORDING_CLI_SCREEN_RECORDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _Block1Data {
	int _ref_count_;
	PeekRecordingCliScreenRecorder* self;
	gchar** my_args;
	gint my_args_length1;
	gint _my_args_size_;
};

static gpointer peek_recording_cli_screen_recorder_parent_class = NULL;

static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void ___lambda24_ (Block1Data* _data1_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda24__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void peek_recording_cli_screen_recorder_real_stop_recording (PeekRecordingBaseScreenRecorder* base);
static gboolean peek_recording_cli_screen_recorder_real_is_exit_status_success (PeekRecordingCliScreenRecorder* self,
                                                                         gint status);
static void peek_recording_cli_screen_recorder_finalize (GObject * obj);
static GType peek_recording_cli_screen_recorder_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PeekRecordingCliScreenRecorder* self;
		self = _data1_->self;
		_data1_->my_args = (_vala_array_free (_data1_->my_args, _data1_->my_args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
___lambda24_ (Block1Data* _data1_,
              GObject* obj,
              GAsyncResult* res)
{
	PeekRecordingCliScreenRecorder* self;
	gboolean success = FALSE;
	gint status = 0;
	gint term_sig = 0;
	const gchar* _tmp10_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	success = FALSE;
	status = 0;
	term_sig = 0;
	{
		gboolean _tmp0_ = FALSE;
		GSubprocess* _tmp1_;
		GSubprocess* _tmp2_;
		GSubprocess* _tmp3_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = self->subprocess;
		_tmp0_ = g_subprocess_wait_check_finish (_tmp1_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		success = _tmp0_;
		_tmp2_ = self->subprocess;
		status = g_subprocess_get_exit_status (_tmp2_);
		_tmp3_ = self->subprocess;
		if (g_subprocess_get_if_signaled (_tmp3_)) {
			GSubprocess* _tmp4_;
			_tmp4_ = self->subprocess;
			term_sig = g_subprocess_get_term_sig (_tmp4_);
		}
		_tmp5_ = bool_to_string (success);
		_tmp6_ = _tmp5_;
		g_debug ("cli-screen-recorder.vala:34: recording process exited, term_sig: %d, e" \
"xit_status: %d, success: %s", term_sig, status, _tmp6_);
		_g_free0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "Error: %s\n", _tmp9_);
		status = -1;
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp10_ = ((PeekRecordingBaseScreenRecorder*) self)->temp_file;
	if (_tmp10_ != NULL) {
		GFile* file = NULL;
		const gchar* _tmp11_;
		GFile* _tmp12_;
		_tmp11_ = ((PeekRecordingBaseScreenRecorder*) self)->temp_file;
		_tmp12_ = g_file_new_for_path (_tmp11_);
		file = _tmp12_;
		{
			GFileInfo* file_info = NULL;
			GFile* _tmp13_;
			GFileInfo* _tmp14_;
			const gchar* _tmp15_;
			GFileInfo* _tmp16_;
			_tmp13_ = file;
			_tmp14_ = g_file_query_info (_tmp13_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			file_info = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp15_ = ((PeekRecordingBaseScreenRecorder*) self)->temp_file;
			_tmp16_ = file_info;
			g_debug ("Temporary file %s, %" G_GINT64_FORMAT " bytes", _tmp15_, g_file_info_get_size (_tmp16_));
			_g_object_unref0 (file_info);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			FILE* _tmp17_;
			GError* _tmp18_;
			const gchar* _tmp19_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp17_ = stderr;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			fprintf (_tmp17_, "Error: %s\n", _tmp19_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (file);
	}
	_tmp20_ = peek_recording_base_screen_recorder_get_is_cancelling ((PeekRecordingBaseScreenRecorder*) self);
	_tmp21_ = _tmp20_;
	if (_tmp21_) {
		return;
	}
	if (!success) {
		gchar* message = NULL;
		gchar** _tmp22_;
		gint _tmp22__length1;
		GSubprocess* _tmp23_;
		gchar* _tmp24_;
		GError* reason = NULL;
		const gchar* _tmp25_;
		GError* _tmp26_;
		GError* _tmp27_;
		_tmp22_ = _data1_->my_args;
		_tmp22__length1 = _data1_->my_args_length1;
		_tmp23_ = self->subprocess;
		_tmp24_ = peek_utils_get_command_failed_message (_tmp22_, (gint) _tmp22__length1, _tmp23_);
		message = _tmp24_;
		_tmp25_ = message;
		_tmp26_ = g_error_new_literal (PEEK_RECORDING_ERROR, PEEK_RECORDING_ERROR_RECORDING_ABORTED, _tmp25_);
		reason = _tmp26_;
		_tmp27_ = reason;
		g_signal_emit_by_name ((PeekRecordingScreenRecorder*) self, "recording-aborted", _tmp27_);
		_g_error_free0 (reason);
		_g_free0 (message);
	} else {
		peek_recording_base_screen_recorder_finalize_recording ((PeekRecordingBaseScreenRecorder*) self);
	}
	_g_object_unref0 (self->subprocess);
	self->subprocess = NULL;
	_g_object_unref0 (self->input);
	self->input = NULL;
}

static void
____lambda24__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda24_ (self, source_object, res);
	block1_data_unref (self);
}

void
peek_recording_cli_screen_recorder_spawn_record_command (PeekRecordingCliScreenRecorder* self,
                                                         gchar** argv,
                                                         gint argv_length1,
                                                         GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		Block1Data* _data1_;
		gchar** _tmp0_;
		gint _tmp0__length1;
		GSubprocess* _tmp1_ = NULL;
		GSubprocess* _tmp2_;
		GSubprocess* _tmp3_;
		GSubprocess* _tmp4_;
		GOutputStream* _tmp5_;
		GOutputStream* _tmp6_;
		GSubprocess* _tmp7_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		_tmp0_ = (argv != NULL) ? _vala_array_dup1 (argv + 0, argv_length1 - 0) : argv;
		_tmp0__length1 = argv_length1 - 0;
		_data1_->my_args = _tmp0_;
		_data1_->my_args_length1 = _tmp0__length1;
		_data1_->_my_args_size_ = _data1_->my_args_length1;
		_tmp2_ = g_subprocess_newv (argv, (G_SUBPROCESS_FLAGS_STDIN_PIPE | G_SUBPROCESS_FLAGS_STDOUT_PIPE) | G_SUBPROCESS_FLAGS_STDERR_MERGE, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->subprocess);
		self->subprocess = _tmp3_;
		_tmp4_ = self->subprocess;
		_tmp5_ = g_subprocess_get_stdin_pipe (_tmp4_);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (self->input);
		self->input = _tmp6_;
		_tmp7_ = self->subprocess;
		g_subprocess_wait_check_async (_tmp7_, NULL, ____lambda24__gasync_ready_callback, block1_data_ref (_data1_));
		peek_recording_screen_recorder_set_is_recording ((PeekRecordingScreenRecorder*) self, TRUE);
		g_signal_emit_by_name ((PeekRecordingScreenRecorder*) self, "recording-started");
		_g_object_unref0 (_tmp1_);
		block1_data_unref (_data1_);
		_data1_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = g_error_new_literal (PEEK_RECORDING_ERROR, PEEK_RECORDING_ERROR_INITIALIZING_RECORDING_FAILED, _tmp9_);
		_inner_error0_ = _tmp10_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == PEEK_RECORDING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
peek_recording_cli_screen_recorder_real_stop_recording (PeekRecordingBaseScreenRecorder* base)
{
	PeekRecordingCliScreenRecorder * self;
	GSubprocess* _tmp0_;
	self = (PeekRecordingCliScreenRecorder*) base;
	_tmp0_ = self->subprocess;
	if (_tmp0_ != NULL) {
		GSubprocess* _tmp1_;
		_tmp1_ = self->subprocess;
		g_subprocess_force_exit (_tmp1_);
	}
}

static gboolean
peek_recording_cli_screen_recorder_real_is_exit_status_success (PeekRecordingCliScreenRecorder* self,
                                                                gint status)
{
	gboolean result;
	result = peek_utils_is_exit_status_success (status);
	return result;
}

gboolean
peek_recording_cli_screen_recorder_is_exit_status_success (PeekRecordingCliScreenRecorder* self,
                                                           gint status)
{
	PeekRecordingCliScreenRecorderClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PEEK_RECORDING_CLI_SCREEN_RECORDER_GET_CLASS (self);
	if (_klass_->is_exit_status_success) {
		return _klass_->is_exit_status_success (self, status);
	}
	return FALSE;
}

PeekRecordingCliScreenRecorder*
peek_recording_cli_screen_recorder_construct (GType object_type)
{
	PeekRecordingCliScreenRecorder * self = NULL;
	self = (PeekRecordingCliScreenRecorder*) peek_recording_base_screen_recorder_construct (object_type);
	return self;
}

static void
peek_recording_cli_screen_recorder_class_init (PeekRecordingCliScreenRecorderClass * klass,
                                               gpointer klass_data)
{
	peek_recording_cli_screen_recorder_parent_class = g_type_class_peek_parent (klass);
	((PeekRecordingBaseScreenRecorderClass *) klass)->stop_recording = (void (*) (PeekRecordingBaseScreenRecorder*)) peek_recording_cli_screen_recorder_real_stop_recording;
	((PeekRecordingCliScreenRecorderClass *) klass)->is_exit_status_success = (gboolean (*) (PeekRecordingCliScreenRecorder*, gint)) peek_recording_cli_screen_recorder_real_is_exit_status_success;
	G_OBJECT_CLASS (klass)->finalize = peek_recording_cli_screen_recorder_finalize;
}

static void
peek_recording_cli_screen_recorder_instance_init (PeekRecordingCliScreenRecorder * self,
                                                  gpointer klass)
{
}

static void
peek_recording_cli_screen_recorder_finalize (GObject * obj)
{
	PeekRecordingCliScreenRecorder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PEEK_RECORDING_TYPE_CLI_SCREEN_RECORDER, PeekRecordingCliScreenRecorder);
	_g_object_unref0 (self->subprocess);
	_g_object_unref0 (self->input);
	G_OBJECT_CLASS (peek_recording_cli_screen_recorder_parent_class)->finalize (obj);
}

static GType
peek_recording_cli_screen_recorder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PeekRecordingCliScreenRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) peek_recording_cli_screen_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PeekRecordingCliScreenRecorder), 0, (GInstanceInitFunc) peek_recording_cli_screen_recorder_instance_init, NULL };
	GType peek_recording_cli_screen_recorder_type_id;
	peek_recording_cli_screen_recorder_type_id = g_type_register_static (PEEK_RECORDING_TYPE_BASE_SCREEN_RECORDER, "PeekRecordingCliScreenRecorder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return peek_recording_cli_screen_recorder_type_id;
}

GType
peek_recording_cli_screen_recorder_get_type (void)
{
	static volatile gsize peek_recording_cli_screen_recorder_type_id__once = 0;
	if (g_once_init_enter (&peek_recording_cli_screen_recorder_type_id__once)) {
		GType peek_recording_cli_screen_recorder_type_id;
		peek_recording_cli_screen_recorder_type_id = peek_recording_cli_screen_recorder_get_type_once ();
		g_once_init_leave (&peek_recording_cli_screen_recorder_type_id__once, peek_recording_cli_screen_recorder_type_id);
	}
	return peek_recording_cli_screen_recorder_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

