/* AppDirs.c generated by valac 0.56.18, the Vala compiler
 * generated from AppDirs.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "io.elementary.photos.h"
#include <config.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define RESOURCES_LIBEXECDIR _LIBEXECDIR
#define RESOURCES_LIB _LIB
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_APP_DIRS (app_dirs_get_type ())
#define APP_DIRS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_DIRS, AppDirs))
#define APP_DIRS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_DIRS, AppDirsClass))
#define IS_APP_DIRS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_DIRS))
#define IS_APP_DIRS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_DIRS))
#define APP_DIRS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_DIRS, AppDirsClass))

typedef struct _AppDirs AppDirs;
typedef struct _AppDirsClass AppDirsClass;
typedef struct _AppDirsPrivate AppDirsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _ParamSpecAppDirs ParamSpecAppDirs;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AppDirs {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AppDirsPrivate * priv;
};

struct _AppDirsClass {
	GTypeClass parent_class;
	void (*finalize) (AppDirs *self);
};

struct _ParamSpecAppDirs {
	GParamSpec parent_instance;
};

static gpointer app_dirs_parent_class = NULL;
static GFile* app_dirs_exec_dir;
static GFile* app_dirs_exec_dir = NULL;
static GFile* app_dirs_data_dir;
static GFile* app_dirs_data_dir = NULL;
static GFile* app_dirs_tmp_dir;
static GFile* app_dirs_tmp_dir = NULL;
static GFile* app_dirs_libexec_dir;
static GFile* app_dirs_libexec_dir = NULL;
static GSettings* app_dirs_file_settings;
static GSettings* app_dirs_file_settings = NULL;

VALA_EXTERN gpointer app_dirs_ref (gpointer instance);
VALA_EXTERN void app_dirs_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_app_dirs (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_app_dirs (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_app_dirs (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_app_dirs (const GValue* value);
VALA_EXTERN GType app_dirs_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void app_dirs_init (const gchar* arg0);
VALA_EXTERN void app_dirs_terminate (void);
VALA_EXTERN GFile* app_dirs_get_home_dir (void);
VALA_EXTERN GFile* app_dirs_get_cache_dir (void);
VALA_EXTERN void app_dirs_try_migrate_data (void);
VALA_EXTERN GFile* app_dirs_get_data_dir (void);
VALA_EXTERN void app_dirs_set_data_dir (const gchar* user_data_dir);
VALA_EXTERN void app_dirs_verify_data_dir (void);
VALA_EXTERN void app_dirs_verify_cache_dir (void);
VALA_EXTERN GFile* app_dirs_get_libexec_dir (void);
VALA_EXTERN GFile* app_dirs_get_install_dir (void);
VALA_EXTERN GFile* app_dirs_get_exec_dir (void);
VALA_EXTERN GFile* get_sys_install_dir (GFile* exec_dir);
VALA_EXTERN GFile* app_dirs_get_import_dir (void);
VALA_EXTERN GFile* app_dirs_get_baked_import_dir (gint64 tm);
VALA_EXTERN gboolean app_dirs_is_in_import_dir (GFile* file);
VALA_EXTERN void app_dirs_set_import_dir (const gchar* path);
VALA_EXTERN GFile* app_dirs_get_temp_dir (void);
VALA_EXTERN GFile* app_dirs_get_data_subdir (const gchar* name,
                                 const gchar* subname);
VALA_EXTERN GFile* app_dirs_get_cache_subdir (const gchar* name,
                                  const gchar* subname);
VALA_EXTERN GFile* app_dirs_get_lib_dir (void);
VALA_EXTERN GFile* app_dirs_get_system_plugins_dir (void);
VALA_EXTERN GFile* app_dirs_get_user_plugins_dir (void);
VALA_EXTERN GFile* app_dirs_get_thumbnailer_bin (void);
VALA_EXTERN AppDirs* app_dirs_new (void);
VALA_EXTERN AppDirs* app_dirs_construct (GType object_type);
static void app_dirs_finalize (AppDirs * obj);
static GType app_dirs_get_type_once (void);

void
app_dirs_init (const gchar* arg0)
{
	GSettings* _tmp0_;
	GFile* exec_file = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	g_return_if_fail (arg0 != NULL);
	_tmp0_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_FILES_PREFS_SCHEMA_NAME);
	_g_object_unref0 (app_dirs_file_settings);
	app_dirs_file_settings = _tmp0_;
	_tmp1_ = g_find_program_in_path (arg0);
	_tmp2_ = _tmp1_;
	_tmp3_ = realpath (_tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	exec_file = _tmp6_;
	_tmp7_ = g_file_get_parent (exec_file);
	_g_object_unref0 (app_dirs_exec_dir);
	app_dirs_exec_dir = _tmp7_;
	_g_object_unref0 (exec_file);
}

void
app_dirs_terminate (void)
{
}

GFile*
app_dirs_get_home_dir (void)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GFile*
app_dirs_get_cache_dir (void)
{
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* result;
	_tmp1_ = app_dirs_data_dir;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp2_ = g_get_user_cache_dir ();
		_tmp3_ = g_file_new_for_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_child (_tmp4_, PROJECT_NAME);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
	} else {
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = app_dirs_data_dir;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp7_;
	}
	result = _tmp0_;
	return result;
}

void
app_dirs_try_migrate_data (void)
{
	GFile* new_dir = NULL;
	GFile* _tmp0_;
	GFile* old_dir = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GFile* _tmp6_;
	GFile* cache_dir = NULL;
	GFile* _tmp8_;
	mode_t mask = {0};
	GFile* _tmp9_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GFile* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	gboolean _tmp31_;
	GFile* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	GFile* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GFile* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = app_dirs_get_data_dir ();
	new_dir = _tmp0_;
	_tmp1_ = app_dirs_get_home_dir ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_child (_tmp2_, ".shotwell");
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	old_dir = _tmp4_;
	_tmp6_ = new_dir;
	if (g_file_query_exists (_tmp6_, NULL)) {
		_tmp5_ = TRUE;
	} else {
		GFile* _tmp7_;
		_tmp7_ = old_dir;
		_tmp5_ = !g_file_query_exists (_tmp7_, NULL);
	}
	if (_tmp5_) {
		_g_object_unref0 (old_dir);
		_g_object_unref0 (new_dir);
		return;
	}
	_tmp8_ = app_dirs_get_cache_dir ();
	cache_dir = _tmp8_;
	mask = umask ((mode_t) 0700);
	_tmp9_ = cache_dir;
	if (!g_file_query_exists (_tmp9_, NULL)) {
		{
			GFile* _tmp10_;
			_tmp10_ = cache_dir;
			g_file_make_directory_with_parents (_tmp10_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GFile* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GError* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp11_ = cache_dir;
			_tmp12_ = g_file_get_path (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = err;
			_tmp15_ = _tmp14_->message;
			_tmp16_ = g_strdup_printf (_ ("Unable to create cache directory %s: %s"), _tmp13_, _tmp15_);
			_tmp17_ = _tmp16_;
			app_window_panic (_tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (cache_dir);
			_g_object_unref0 (old_dir);
			_g_object_unref0 (new_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp18_ = old_dir;
	_tmp19_ = g_file_get_child (_tmp18_, "thumbs");
	_tmp20_ = _tmp19_;
	_tmp21_ = g_file_get_path (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = cache_dir;
	_tmp24_ = g_file_get_child (_tmp23_, "thumbs");
	_tmp25_ = _tmp24_;
	_tmp26_ = g_file_get_path (_tmp25_);
	_tmp27_ = _tmp26_;
	g_rename (_tmp22_, _tmp27_);
	_g_free0 (_tmp27_);
	_g_object_unref0 (_tmp25_);
	_g_free0 (_tmp22_);
	_g_object_unref0 (_tmp20_);
	_tmp28_ = new_dir;
	_tmp29_ = g_file_get_parent (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = !g_file_query_exists (_tmp30_, NULL);
	_g_object_unref0 (_tmp30_);
	if (_tmp31_) {
		{
			GFile* _tmp32_;
			GFile* _tmp33_;
			GFile* _tmp34_;
			_tmp32_ = new_dir;
			_tmp33_ = g_file_get_parent (_tmp32_);
			_tmp34_ = _tmp33_;
			g_file_make_directory_with_parents (_tmp34_, NULL, &_inner_error0_);
			_g_object_unref0 (_tmp34_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GFile* _tmp35_;
			GFile* _tmp36_;
			GFile* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			GError* _tmp40_;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp35_ = new_dir;
			_tmp36_ = g_file_get_parent (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_file_get_path (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = err;
			_tmp41_ = _tmp40_->message;
			_tmp42_ = g_strdup_printf (_ ("Unable to create data directory %s: %s"), _tmp39_, _tmp41_);
			_tmp43_ = _tmp42_;
			app_window_panic (_tmp43_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp39_);
			_g_object_unref0 (_tmp37_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (cache_dir);
			_g_object_unref0 (old_dir);
			_g_object_unref0 (new_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp44_ = old_dir;
	_tmp45_ = g_file_get_path (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = new_dir;
	_tmp48_ = g_file_get_path (_tmp47_);
	_tmp49_ = _tmp48_;
	g_rename (_tmp46_, _tmp49_);
	_g_free0 (_tmp49_);
	_g_free0 (_tmp46_);
	_tmp50_ = new_dir;
	_tmp51_ = g_file_get_path (_tmp50_);
	_tmp52_ = _tmp51_;
	g_chmod (_tmp52_, 0700);
	_g_free0 (_tmp52_);
	umask (mask);
	_g_object_unref0 (cache_dir);
	_g_object_unref0 (old_dir);
	_g_object_unref0 (new_dir);
}

void
app_dirs_set_data_dir (const gchar* user_data_dir)
{
	GFile* _tmp0_;
	gchar* path = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_if_fail (user_data_dir != NULL);
	_vala_return_if_fail (!is_string_empty (user_data_dir), "!is_string_empty (user_data_dir)");
	_tmp0_ = app_dirs_data_dir;
	_vala_assert (_tmp0_ == NULL, "data_dir == null");
	_tmp1_ = strip_pretty_path (user_data_dir);
	path = _tmp1_;
	_tmp2_ = path;
	if (!g_path_is_absolute (_tmp2_)) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		_tmp3_ = app_dirs_get_home_dir ();
		_tmp4_ = _tmp3_;
		_tmp5_ = path;
		_tmp6_ = g_file_get_child (_tmp4_, _tmp5_);
		_g_object_unref0 (app_dirs_data_dir);
		app_dirs_data_dir = _tmp6_;
		_g_object_unref0 (_tmp4_);
	} else {
		const gchar* _tmp7_;
		GFile* _tmp8_;
		_tmp7_ = path;
		_tmp8_ = g_file_new_for_path (_tmp7_);
		_g_object_unref0 (app_dirs_data_dir);
		app_dirs_data_dir = _tmp8_;
	}
	_tmp9_ = app_dirs_data_dir;
	_tmp10_ = g_file_get_path (_tmp9_);
	_tmp11_ = _tmp10_;
	g_message ("AppDirs.vala:92: Setting private data directory to %s", _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (path);
}

void
app_dirs_verify_data_dir (void)
{
	GFile* data_dir = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = app_dirs_get_data_dir ();
	data_dir = _tmp0_;
	{
		GFile* _tmp1_;
		_tmp1_ = data_dir;
		if (!g_file_query_exists (_tmp1_, NULL)) {
			GFile* _tmp2_;
			_tmp2_ = data_dir;
			g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = data_dir;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_strdup_printf (_ ("Unable to create data directory %s: %s"), _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		app_window_panic (_tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (data_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (data_dir);
}

void
app_dirs_verify_cache_dir (void)
{
	GFile* cache_dir = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = app_dirs_get_cache_dir ();
	cache_dir = _tmp0_;
	{
		GFile* _tmp1_;
		_tmp1_ = cache_dir;
		if (!g_file_query_exists (_tmp1_, NULL)) {
			GFile* _tmp2_;
			_tmp2_ = cache_dir;
			g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = cache_dir;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_strdup_printf (_ ("Unable to create cache directory %s: %s"), _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		app_window_panic (_tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (cache_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (cache_dir);
}

/**
     * Returns the build directory if not installed yet, or a path
     * to where any helper applets we need will live if installed.
     */
GFile*
app_dirs_get_libexec_dir (void)
{
	GFile* _tmp0_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* result;
	_tmp0_ = app_dirs_libexec_dir;
	if (_tmp0_ == NULL) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = app_dirs_get_install_dir ();
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_ == NULL;
		_g_object_unref0 (_tmp2_);
		if (_tmp3_) {
			GFile* _tmp4_;
			_tmp4_ = app_dirs_get_exec_dir ();
			_g_object_unref0 (app_dirs_libexec_dir);
			app_dirs_libexec_dir = _tmp4_;
		} else {
			GFile* _tmp5_;
			_tmp5_ = g_file_new_for_path (RESOURCES_LIBEXECDIR);
			_g_object_unref0 (app_dirs_libexec_dir);
			app_dirs_libexec_dir = _tmp5_;
		}
	}
	_tmp6_ = app_dirs_libexec_dir;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

GFile*
app_dirs_get_install_dir (void)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	_tmp0_ = app_dirs_exec_dir;
	_tmp1_ = get_sys_install_dir (_tmp0_);
	result = _tmp1_;
	return result;
}

GFile*
app_dirs_get_data_dir (void)
{
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* result;
	_tmp1_ = app_dirs_data_dir;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp2_ = g_get_user_data_dir ();
		_tmp3_ = g_file_new_for_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_child (_tmp4_, PROJECT_NAME);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
	} else {
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = app_dirs_data_dir;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp7_;
	}
	result = _tmp0_;
	return result;
}

GFile*
app_dirs_get_import_dir (void)
{
	gchar* path = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GFile* result;
	_tmp0_ = app_dirs_file_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "import-dir");
	path = _tmp1_;
	_tmp2_ = path;
	if (!is_string_empty (_tmp2_)) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp11_;
		GFile* _tmp12_;
		_tmp3_ = path;
		_tmp4_ = strip_pretty_path (_tmp3_);
		_g_free0 (path);
		path = _tmp4_;
		_tmp5_ = path;
		if (!g_path_is_absolute (_tmp5_)) {
			GFile* _tmp6_;
			GFile* _tmp7_;
			const gchar* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			_tmp6_ = app_dirs_get_home_dir ();
			_tmp7_ = _tmp6_;
			_tmp8_ = path;
			_tmp9_ = g_file_get_child (_tmp7_, _tmp8_);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp7_);
			result = _tmp10_;
			_g_free0 (path);
			return result;
		}
		_tmp11_ = path;
		_tmp12_ = g_file_new_for_path (_tmp11_);
		result = _tmp12_;
		_g_free0 (path);
		return result;
	}
	_tmp13_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (path);
	path = _tmp14_;
	_tmp15_ = path;
	if (!is_string_empty (_tmp15_)) {
		const gchar* _tmp16_;
		GFile* _tmp17_;
		_tmp16_ = path;
		_tmp17_ = g_file_new_for_path (_tmp16_);
		result = _tmp17_;
		_g_free0 (path);
		return result;
	}
	_tmp18_ = app_dirs_get_home_dir ();
	_tmp19_ = _tmp18_;
	_tmp20_ = g_file_get_child (_tmp19_, _ ("Pictures"));
	_tmp21_ = _tmp20_;
	_g_object_unref0 (_tmp19_);
	result = _tmp21_;
	_g_free0 (path);
	return result;
}

GFile*
app_dirs_get_baked_import_dir (gint64 tm)
{
	gchar* pattern = NULL;
	gchar* _tmp0_;
	GDateTime* date = NULL;
	GDateTime* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* result;
	_tmp0_ = g_strdup ("%Y" G_DIR_SEPARATOR_S "%m" G_DIR_SEPARATOR_S "%d");
	pattern = _tmp0_;
	_tmp1_ = g_date_time_new_from_unix_local (tm);
	date = _tmp1_;
	_tmp2_ = app_dirs_get_import_dir ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, G_DIR_SEPARATOR_S, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_date_time_format (date, pattern);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	result = _tmp13_;
	_g_date_time_unref0 (date);
	_g_free0 (pattern);
	return result;
}

gboolean
app_dirs_is_in_import_dir (GFile* file)
{
	GFile* import_dir = NULL;
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = app_dirs_get_import_dir ();
	import_dir = _tmp0_;
	_tmp2_ = import_dir;
	if (g_file_has_prefix (file, _tmp2_)) {
		_tmp1_ = TRUE;
	} else {
		GFile* _tmp3_;
		_tmp3_ = import_dir;
		_tmp1_ = g_file_equal (file, _tmp3_);
	}
	result = _tmp1_;
	_g_object_unref0 (import_dir);
	return result;
}

void
app_dirs_set_import_dir (const gchar* path)
{
	GSettings* _tmp0_;
	g_return_if_fail (path != NULL);
	_tmp0_ = app_dirs_file_settings;
	g_settings_set_string (_tmp0_, "import-dir", path);
}

GFile*
app_dirs_get_exec_dir (void)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	_tmp0_ = app_dirs_exec_dir;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GFile*
app_dirs_get_temp_dir (void)
{
	GFile* _tmp0_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	_tmp0_ = app_dirs_tmp_dir;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		_tmp1_ = g_get_tmp_dir ();
		_tmp2_ = g_strconcat (_tmp1_, "/pantheon-photos-XXXXXX", NULL);
		_tmp3_ = mkdtemp (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_path (_tmp4_);
		_g_object_unref0 (app_dirs_tmp_dir);
		app_dirs_tmp_dir = _tmp5_;
		_g_free0 (_tmp4_);
		{
			GFile* _tmp6_;
			_tmp6_ = app_dirs_tmp_dir;
			if (!g_file_query_exists (_tmp6_, NULL)) {
				GFile* _tmp7_;
				_tmp7_ = app_dirs_tmp_dir;
				g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GFile* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = app_dirs_tmp_dir;
			_tmp9_ = g_file_get_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = err;
			_tmp12_ = _tmp11_->message;
			_tmp13_ = g_strdup_printf (_ ("Unable to create temporary directory %s: %s"), _tmp10_, _tmp12_);
			_tmp14_ = _tmp13_;
			app_window_panic (_tmp14_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp10_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp15_ = app_dirs_tmp_dir;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	result = _tmp16_;
	return result;
}

GFile*
app_dirs_get_data_subdir (const gchar* name,
                          const gchar* subname)
{
	GFile* subdir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = app_dirs_get_data_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, name);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	subdir = _tmp3_;
	if (subname != NULL) {
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = subdir;
		_tmp5_ = g_file_get_child (_tmp4_, subname);
		_g_object_unref0 (subdir);
		subdir = _tmp5_;
	}
	{
		GFile* _tmp6_;
		_tmp6_ = subdir;
		if (!g_file_query_exists (_tmp6_, NULL)) {
			GFile* _tmp7_;
			_tmp7_ = subdir;
			g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = subdir;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = err;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_strdup_printf (_ ("Unable to create data subdirectory %s: %s"), _tmp10_, _tmp12_);
		_tmp14_ = _tmp13_;
		app_window_panic (_tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp10_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (subdir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = subdir;
	return result;
}

GFile*
app_dirs_get_cache_subdir (const gchar* name,
                           const gchar* subname)
{
	GFile* subdir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = app_dirs_get_cache_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, name);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	subdir = _tmp3_;
	if (subname != NULL) {
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = subdir;
		_tmp5_ = g_file_get_child (_tmp4_, subname);
		_g_object_unref0 (subdir);
		subdir = _tmp5_;
	}
	{
		GFile* _tmp6_;
		_tmp6_ = subdir;
		if (!g_file_query_exists (_tmp6_, NULL)) {
			GFile* _tmp7_;
			_tmp7_ = subdir;
			g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = subdir;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = err;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_strdup_printf (_ ("Unable to create data subdirectory %s: %s"), _tmp10_, _tmp12_);
		_tmp14_ = _tmp13_;
		app_window_panic (_tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp10_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (subdir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = subdir;
	return result;
}

GFile*
app_dirs_get_lib_dir (void)
{
	GFile* install_dir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFile* result;
	_tmp0_ = app_dirs_get_install_dir ();
	install_dir = _tmp0_;
	_tmp2_ = install_dir;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp3_ = g_file_new_for_path (RESOURCES_LIB);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_child (_tmp4_, PROJECT_NAME);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
	} else {
		GFile* _tmp6_;
		_tmp6_ = app_dirs_get_exec_dir ();
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp6_;
	}
	result = _tmp1_;
	_g_object_unref0 (install_dir);
	return result;
}

GFile*
app_dirs_get_system_plugins_dir (void)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	_tmp0_ = app_dirs_get_lib_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, "plugins");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

GFile*
app_dirs_get_user_plugins_dir (void)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_child (_tmp2_, PROJECT_NAME);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_child (_tmp4_, "plugins");
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}

GFile*
app_dirs_get_thumbnailer_bin (void)
{
	static const char FILENAME[] = "video-thumbnailer";
	GFile* f = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* result;
	_tmp0_ = app_dirs_get_libexec_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "/thumbnailer/", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, FILENAME, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_new_for_path (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	f = _tmp9_;
	_tmp10_ = f;
	if (!g_file_query_exists (_tmp10_, NULL)) {
		GFile* _tmp11_;
		GFile* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GFile* _tmp19_;
		_tmp11_ = app_dirs_get_libexec_dir ();
		_tmp12_ = _tmp11_;
		_tmp13_ = g_file_get_path (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, "/", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, FILENAME, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_file_new_for_path (_tmp18_);
		_g_object_unref0 (f);
		f = _tmp19_;
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_object_unref0 (_tmp12_);
	}
	result = f;
	return result;
}

AppDirs*
app_dirs_construct (GType object_type)
{
	AppDirs* self = NULL;
	self = (AppDirs*) g_type_create_instance (object_type);
	return self;
}

AppDirs*
app_dirs_new (void)
{
	return app_dirs_construct (TYPE_APP_DIRS);
}

static void
value_app_dirs_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_app_dirs_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		app_dirs_unref (value->data[0].v_pointer);
	}
}

static void
value_app_dirs_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = app_dirs_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_app_dirs_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_app_dirs_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AppDirs * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = app_dirs_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_app_dirs_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	AppDirs ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = app_dirs_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_app_dirs (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecAppDirs* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_APP_DIRS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_app_dirs (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APP_DIRS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_app_dirs (GValue* value,
                    gpointer v_object)
{
	AppDirs * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APP_DIRS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APP_DIRS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		app_dirs_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		app_dirs_unref (old);
	}
}

void
value_take_app_dirs (GValue* value,
                     gpointer v_object)
{
	AppDirs * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APP_DIRS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APP_DIRS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		app_dirs_unref (old);
	}
}

static void
app_dirs_class_init (AppDirsClass * klass,
                     gpointer klass_data)
{
	app_dirs_parent_class = g_type_class_peek_parent (klass);
	((AppDirsClass *) klass)->finalize = app_dirs_finalize;
}

static void
app_dirs_instance_init (AppDirs * self,
                        gpointer klass)
{
	self->ref_count = 1;
}

static void
app_dirs_finalize (AppDirs * obj)
{
	AppDirs * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_DIRS, AppDirs);
	g_signal_handlers_destroy (self);
}

static GType
app_dirs_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_app_dirs_init, value_app_dirs_free_value, value_app_dirs_copy_value, value_app_dirs_peek_pointer, "p", value_app_dirs_collect_value, "p", value_app_dirs_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AppDirsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_dirs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppDirs), 0, (GInstanceInitFunc) app_dirs_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType app_dirs_type_id;
	app_dirs_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AppDirs", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return app_dirs_type_id;
}

GType
app_dirs_get_type (void)
{
	static volatile gsize app_dirs_type_id__once = 0;
	if (g_once_init_enter (&app_dirs_type_id__once)) {
		GType app_dirs_type_id;
		app_dirs_type_id = app_dirs_get_type_once ();
		g_once_init_leave (&app_dirs_type_id__once, app_dirs_type_id);
	}
	return app_dirs_type_id__once;
}

gpointer
app_dirs_ref (gpointer instance)
{
	AppDirs * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
app_dirs_unref (gpointer instance)
{
	AppDirs * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		APP_DIRS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

