/* ECalComponent.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ECalComponent.vala, do not modify */

/*
 * Copyright 2011-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "elementary-calendar.h"
#include <libecal/libecal.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libical-glib/libical-glib.h>
#include <time.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define __vala_ECalComponentId_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentId_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static void _vala_ECalComponentId_free (ECalComponentId* self);

static void
_vala_ECalComponentId_free (ECalComponentId* self)
{
	g_boxed_free (e_cal_component_id_get_type (), self);
}

gboolean
calendar_util_ecalcomponent_equal_func (ECalComponent* a,
                                        ECalComponent* b)
{
	ECalComponentId* _tmp0_;
	ECalComponentId* _tmp1_;
	ECalComponentId* _tmp2_;
	ECalComponentId* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = e_cal_component_get_id (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = e_cal_component_get_id (b);
	_tmp3_ = _tmp2_;
	_tmp4_ = e_cal_component_id_equal (_tmp1_, _tmp3_);
	__vala_ECalComponentId_free0 (_tmp3_);
	__vala_ECalComponentId_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

gint
calendar_util_ecalcomponent_compare_func (ECalComponent* a,
                                          ECalComponent* b)
{
	gboolean _tmp0_ = FALSE;
	ECalComponentId* a_id = NULL;
	ECalComponentId* _tmp3_;
	ECalComponentId* b_id = NULL;
	ECalComponentId* _tmp4_;
	gint res = 0;
	GCompareFunc _tmp5_;
	ECalComponentId* _tmp6_;
	const gchar* _tmp7_;
	ECalComponentId* _tmp8_;
	const gchar* _tmp9_;
	gint result;
	if (a == NULL) {
		_tmp0_ = b != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 1;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (b == NULL) {
			_tmp1_ = a != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = -1;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (b == NULL) {
				_tmp2_ = a == NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = 0;
				return result;
			}
		}
	}
	_tmp3_ = e_cal_component_get_id (a);
	a_id = _tmp3_;
	_tmp4_ = e_cal_component_get_id (b);
	b_id = _tmp4_;
	_tmp5_ = ((GCompareFunc) g_strcmp0);
	_tmp6_ = a_id;
	_tmp7_ = e_cal_component_id_get_uid (_tmp6_);
	_tmp8_ = b_id;
	_tmp9_ = e_cal_component_id_get_uid (_tmp8_);
	res = _tmp5_ (_tmp7_, _tmp9_);
	if (res == 0) {
		GCompareFunc _tmp10_;
		ECalComponentId* _tmp11_;
		const gchar* _tmp12_;
		ECalComponentId* _tmp13_;
		const gchar* _tmp14_;
		_tmp10_ = ((GCompareFunc) g_strcmp0);
		_tmp11_ = a_id;
		_tmp12_ = e_cal_component_id_get_rid (_tmp11_);
		_tmp13_ = b_id;
		_tmp14_ = e_cal_component_id_get_rid (_tmp13_);
		result = _tmp10_ (_tmp12_, _tmp14_);
		__vala_ECalComponentId_free0 (b_id);
		__vala_ECalComponentId_free0 (a_id);
		return result;
	}
	result = res;
	__vala_ECalComponentId_free0 (b_id);
	__vala_ECalComponentId_free0 (a_id);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
calendar_util_ecalcomponent_is_on_day (ECalComponent* component,
                                       GDateTime* day)
{
	CalendarTimeManager* time_manager = NULL;
	CalendarTimeManager* _tmp0_;
	GDateTime* stripped_time = NULL;
	GDateTime* _tmp1_;
	gint64 selected_date_unix = 0LL;
	GDateTime* _tmp2_;
	gint64 selected_date_unix_next = 0LL;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	gint64 _tmp6_;
	ICalComponent* ical_component = NULL;
	ICalComponent* _tmp7_;
	ICalTime* start_time = NULL;
	ICalTime* end_time = NULL;
	ICalTimezone* system_timezone = NULL;
	CalendarTimeManager* _tmp16_;
	ICalTimezone* _tmp17_;
	ICalTimezone* _tmp18_;
	ICalTimezone* _tmp19_;
	time_t start_unix = 0;
	ICalTime* _tmp20_;
	ICalTimezone* _tmp21_;
	time_t end_unix = 0;
	ICalTime* _tmp22_;
	ICalTimezone* _tmp23_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean result;
	g_return_val_if_fail (component != NULL, FALSE);
	g_return_val_if_fail (day != NULL, FALSE);
	_tmp0_ = calendar_time_manager_get_default ();
	time_manager = _tmp0_;
	_tmp1_ = g_date_time_new_local (g_date_time_get_year (day), g_date_time_get_month (day), g_date_time_get_day_of_month (day), 0, 0, (gdouble) 0);
	stripped_time = _tmp1_;
	_tmp2_ = stripped_time;
	selected_date_unix = g_date_time_to_unix (_tmp2_);
	_tmp3_ = stripped_time;
	_tmp4_ = g_date_time_add_days (_tmp3_, 1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_date_time_to_unix (_tmp5_);
	_g_date_time_unref0 (_tmp5_);
	selected_date_unix_next = _tmp6_;
	_tmp7_ = e_cal_component_get_icalcomponent (component);
	ical_component = _tmp7_;
	switch (e_cal_component_get_vtype (component)) {
		case E_CAL_COMPONENT_EVENT:
		{
			ICalComponent* _tmp8_;
			ICalTime* _tmp9_;
			ICalComponent* _tmp10_;
			ICalTime* _tmp11_;
			_tmp8_ = ical_component;
			_tmp9_ = i_cal_component_get_dtstart (_tmp8_);
			_g_object_unref0 (start_time);
			start_time = _tmp9_;
			_tmp10_ = ical_component;
			_tmp11_ = i_cal_component_get_dtend (_tmp10_);
			_g_object_unref0 (end_time);
			end_time = _tmp11_;
			break;
		}
		case E_CAL_COMPONENT_TODO:
		{
			ICalComponent* _tmp12_;
			ICalTime* _tmp13_;
			ICalComponent* _tmp14_;
			ICalTime* _tmp15_;
			_tmp12_ = ical_component;
			_tmp13_ = i_cal_component_get_due (_tmp12_);
			_g_object_unref0 (start_time);
			start_time = _tmp13_;
			_tmp14_ = ical_component;
			_tmp15_ = i_cal_component_get_due (_tmp14_);
			_g_object_unref0 (end_time);
			end_time = _tmp15_;
			break;
		}
		default:
		{
			result = FALSE;
			_g_object_unref0 (end_time);
			_g_object_unref0 (start_time);
			_g_date_time_unref0 (stripped_time);
			return result;
		}
	}
	_tmp16_ = time_manager;
	_tmp17_ = calendar_time_manager_get_system_timezone (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	system_timezone = _tmp19_;
	_tmp20_ = start_time;
	_tmp21_ = system_timezone;
	start_unix = i_cal_time_as_timet_with_zone (_tmp20_, _tmp21_);
	_tmp22_ = end_time;
	_tmp23_ = system_timezone;
	end_unix = i_cal_time_as_timet_with_zone (_tmp22_, _tmp23_);
	if (((gint64) start_unix) < selected_date_unix) {
		_tmp24_ = selected_date_unix_next < ((gint64) end_unix);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		result = TRUE;
		_g_object_unref0 (system_timezone);
		_g_object_unref0 (end_time);
		_g_object_unref0 (start_time);
		_g_date_time_unref0 (stripped_time);
		return result;
	}
	if (((gint64) start_unix) < selected_date_unix) {
		_tmp25_ = selected_date_unix < ((gint64) end_unix);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		result = TRUE;
		_g_object_unref0 (system_timezone);
		_g_object_unref0 (end_time);
		_g_object_unref0 (start_time);
		_g_date_time_unref0 (stripped_time);
		return result;
	}
	if (((gint64) start_unix) < selected_date_unix_next) {
		_tmp26_ = selected_date_unix_next < ((gint64) end_unix);
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		result = TRUE;
		_g_object_unref0 (system_timezone);
		_g_object_unref0 (end_time);
		_g_object_unref0 (start_time);
		_g_date_time_unref0 (stripped_time);
		return result;
	}
	if (((gint64) start_unix) < selected_date_unix_next) {
		_tmp27_ = selected_date_unix < ((gint64) end_unix);
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		result = TRUE;
		_g_object_unref0 (system_timezone);
		_g_object_unref0 (end_time);
		_g_object_unref0 (start_time);
		_g_date_time_unref0 (stripped_time);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (system_timezone);
	_g_object_unref0 (end_time);
	_g_object_unref0 (start_time);
	_g_date_time_unref0 (stripped_time);
	return result;
}

