#![allow(clippy::derived_hash_with_manual_eq)]

mod about_dialog;
mod account_widget;
mod add_dialog;
mod app;
mod article_list;
mod article_view;
mod color;
mod config;
mod content_page;
mod discover;
mod edit_category_dialog;
mod edit_feed_dialog;
mod edit_tag_dialog;
mod enclosure;
mod error;
mod error_dialog;
mod global_actions;
mod gobject_models;
mod i18n;
mod image_dialog;
mod image_widget;
mod infrastructure;
mod login_screen;
mod main_window;
mod reset_page;
mod saved_state;
mod self_stack;
mod settings;
mod share;
mod shortcuts_dialog;
mod sidebar;
mod tag_popover;
mod themes;
mod undo_action;
mod util;
mod welcome_screen;

use crate::app::App;
use crate::config::APP_ID;
use gettextrs::*;
use gtk4::prelude::*;
use log::LevelFilter;

fn main() {
    // nicer backtrace
    color_backtrace::install();

    // Logging
    let env = env_logger::Env::default().default_filter_or("info");
    env_logger::Builder::from_env(env)
        .filter_module("r2d2", LevelFilter::Off)
        .filter_module("html5ever", LevelFilter::Off)
        .init();

    // Gtk setup
    gtk4::init().expect("Error initializing gtk.");
    gtk4::Window::set_default_icon_name(APP_ID);
    glib::set_application_name("Newsflash");
    glib::set_prgname(Some("news-flash"));

    clapper::init().expect("Failed to initialize clapper");

    // Setup translations
    setlocale(LocaleCategory::LcAll, "");
    let localedir = bindtextdomain(config::GETTEXT_PACKAGE, config::LOCALEDIR).expect("Unable to bind the text domain");
    let textdomain = textdomain(config::GETTEXT_PACKAGE).expect("Unable to switch to the text domain");

    log::debug!("LOCALEDIR: {localedir:?}");
    if let Ok(textdomain) = std::str::from_utf8(&textdomain) {
        log::debug!("TEXTDOMAIN: {textdomain}");
    }

    // Run app itself
    App::new().run();
}
