/* apps_page/models/selection.rs
 *
 * Copyright 2025 Mission Center Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

use gtk::gio;
use gtk::prelude::*;
use gtk::subclass::prelude::*;

use crate::apps_page::row_model::{ContentType, RowModel};
use crate::apps_page::AppsPage;

pub fn model(
    apps_page: &AppsPage,
    sort_list_model: impl IsA<gio::ListModel>,
) -> gtk::SingleSelection {
    let selection_model = gtk::SingleSelection::new(Some(sort_list_model));
    selection_model.set_autoselect(true);

    let this = apps_page.downgrade();
    selection_model.connect_selected_item_notify(move |model| {
        let Some(this) = this.upgrade() else {
            return;
        };
        let imp = this.imp();

        let Some(row_model) = model
            .selected_item()
            .and_then(|item| item.downcast::<gtk::TreeListRow>().ok())
            .and_then(|row| row.item())
            .and_then(|obj| obj.downcast::<RowModel>().ok())
        else {
            return;
        };

        if row_model.content_type() == ContentType::SectionHeader {
            imp.action_stop.set_enabled(false);
            imp.action_force_stop.set_enabled(false);
            imp.action_details.set_enabled(false);

            return;
        }

        imp.action_stop.set_enabled(true);
        imp.action_force_stop.set_enabled(true);
        imp.action_details.set_enabled(true);

        imp.selected_item.replace(row_model);
    });

    selection_model
}
