# 14 "url.mll"
 
 open Printf

 type url =
 {
  scheme : string option ;
  authority : string option ;
  path : string ;
  query : string option ;
  fragment : string option ;
 }

 exception Error

# 17 "url.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\001\000\002\000\003\000\004\000\006\000\005\000\007\000\
    \008\000\009\000\010\000\013\000\011\000\014\000\015\000\012\000\
    \016\000\024\000\017\000\019\000\020\000\018\000\021\000\025\000\
    \253\255\254\255\040\000\063\000\255\255";
  Lexing.lex_backtrk =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\255\
    \255\255\255\255\001\000\255\255\255\255";
  Lexing.lex_default =
   "\005\000\001\000\002\000\003\000\003\000\005\000\009\000\007\000\
    \008\000\009\000\009\000\011\000\012\000\013\000\014\000\015\000\
    \016\000\017\000\018\000\019\000\020\000\021\000\022\000\025\000\
    \000\000\000\000\255\255\255\255\000\000";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\001\000\000\000\022\000\001\000\001\000\
    \007\000\001\000\000\000\016\000\007\000\007\000\000\000\004\000\
    \012\000\015\000\012\000\017\000\010\000\003\000\021\000\018\000\
    \000\000\011\000\003\000\018\000\014\000\000\000\026\000\002\000\
    \006\000\000\000\002\000\002\000\008\000\002\000\000\000\020\000\
    \008\000\008\000\000\000\000\000\013\000\000\000\013\000\000\000\
    \000\000\000\000\000\000\019\000\000\000\000\000\000\000\019\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\027\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\027\000\027\000\027\000\027\000\027\000\027\000\028\000\
    \028\000\028\000\028\000\028\000\028\000\028\000\028\000\028\000\
    \028\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \028\000\028\000\028\000\028\000\028\000\028\000\000\000\000\000\
    \000\000\027\000\027\000\027\000\027\000\027\000\027\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \028\000\028\000\028\000\028\000\028\000\028\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\000\000\000\000\
    \255\255\024\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\002\000\003\000\004\000\
    \006\000\005\000\255\255\008\000\009\000\010\000\255\255\000\000\
    \011\000\013\000\014\000\004\000\006\000\005\000\019\000\020\000\
    \255\255\010\000\000\000\017\000\011\000\255\255\023\000\000\000\
    \005\000\255\255\003\000\004\000\006\000\005\000\255\255\017\000\
    \009\000\010\000\255\255\255\255\011\000\255\255\014\000\255\255\
    \255\255\255\255\255\255\020\000\255\255\255\255\255\255\017\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\026\000\
    \026\000\026\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\026\000\026\000\026\000\026\000\026\000\026\000\027\000\
    \027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
    \027\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \027\000\027\000\027\000\027\000\027\000\027\000\255\255\255\255\
    \255\255\026\000\026\000\026\000\026\000\026\000\026\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \027\000\027\000\027\000\027\000\027\000\027\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\001\000\002\000\003\000\004\000\006\000\005\000\007\000\
    \008\000\009\000\010\000\012\000\015\000\011\000\013\000\014\000\
    \016\000\018\000\021\000\019\000\020\000\022\000\255\255\255\255\
    \017\000\023\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    ";
  Lexing.lex_base_code =
   "\000\000\001\000\002\000\003\000\004\000\006\000\005\000\007\000\
    \008\000\009\000\010\000\013\000\011\000\014\000\015\000\012\000\
    \016\000\024\000\017\000\019\000\020\000\018\000\021\000\000\000\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_backtrk_code =
   "\001\000\034\000\052\000\001\000\001\000\001\000\085\000\100\000\
    \117\000\085\000\085\000\134\000\160\000\179\000\134\000\198\000\
    \219\000\238\000\253\000\014\001\238\000\031\001\050\001\000\000\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_default_code =
   "\014\000\049\000\031\000\026\000\026\000\014\000\026\000\049\000\
    \031\000\026\000\026\000\151\000\049\000\031\000\026\000\049\000\
    \049\000\151\000\049\000\031\000\026\000\049\000\049\000\000\000\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_trans_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\021\000\000\000\021\000\021\000\021\000\
    \021\000\021\000\000\000\021\000\021\000\021\000\000\000\026\000\
    \021\000\021\000\021\000\067\000\000\000\026\000\021\000\021\000\
    \000\000\067\000\026\000\021\000\026\000\000\000\000\000\031\000\
    \078\000\000\000\031\000\031\000\031\000\031\000\000\000\026\000\
    \031\000\031\000\000\000\000\000\031\000\000\000\031\000\000\000\
    \000\000\000\000\000\000\031\000\000\000\000\000\000\000\031\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000";
  Lexing.lex_check_code =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\002\000\003\000\004\000\
    \006\000\005\000\255\255\008\000\009\000\010\000\255\255\000\000\
    \011\000\013\000\014\000\004\000\255\255\005\000\019\000\020\000\
    \255\255\010\000\000\000\017\000\011\000\255\255\255\255\000\000\
    \005\000\255\255\003\000\004\000\006\000\005\000\255\255\017\000\
    \009\000\010\000\255\255\255\255\011\000\255\255\014\000\255\255\
    \255\255\255\255\255\255\020\000\255\255\255\255\255\255\017\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\001\000\002\000\003\000\004\000\006\000\005\000\007\000\
    \008\000\009\000\010\000\012\000\015\000\011\000\013\000\014\000\
    \016\000\018\000\021\000\019\000\020\000\022\000\255\255\255\255\
    \017\000";
  Lexing.lex_code =
   "\255\009\255\007\255\005\255\003\255\000\011\001\010\255\017\255\
    \013\255\010\255\255\015\255\014\255\255\013\255\010\255\255\016\
    \255\255\009\255\007\255\003\255\000\011\001\010\005\015\004\014\
    \255\014\255\255\009\255\005\255\003\255\007\013\006\016\000\011\
    \001\010\255\019\255\018\255\013\255\011\255\010\255\255\013\255\
    \011\255\010\255\255\007\255\005\255\003\255\009\012\008\017\000\
    \011\001\010\255\007\255\003\255\009\012\008\017\000\011\001\010\
    \005\015\004\014\255\005\255\003\255\009\012\008\017\007\013\006\
    \016\000\011\001\010\255\007\255\005\255\009\012\008\017\000\011\
    \001\010\003\019\002\018\255\013\255\011\255\010\255\018\255\255\
    \007\255\009\012\008\017\000\011\001\010\005\015\004\014\003\019\
    \002\018\255\005\255\009\012\008\017\007\013\006\016\000\011\001\
    \010\003\019\002\018\255\009\012\008\017\007\013\006\016\000\011\
    \001\010\005\015\004\014\003\019\002\018\255\003\255\009\012\008\
    \017\007\013\006\016\000\011\001\010\005\015\004\014\255\009\255\
    \007\255\005\255\000\011\001\010\003\019\002\018\255\009\255\007\
    \255\000\011\001\010\005\015\004\014\003\019\002\018\255\009\255\
    \005\255\007\013\006\016\000\011\001\010\003\019\002\018\255\009\
    \255\007\013\006\016\000\011\001\010\005\015\004\014\003\019\002\
    \018\255\009\255\003\255\007\013\006\016\000\011\001\010\005\015\
    \004\014\255";
}

let rec break lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 20 (-1);(* L=4 [13] <- p ; [12] <- p ; [11] <- p ; [10] <- p ;  *)
  lexbuf.Lexing.lex_mem.(13) <- lexbuf.Lexing.lex_curr_pos ;
  lexbuf.Lexing.lex_mem.(12) <- lexbuf.Lexing.lex_curr_pos ;
  lexbuf.Lexing.lex_mem.(11) <- lexbuf.Lexing.lex_curr_pos ;
  lexbuf.Lexing.lex_mem.(10) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_break_rec lexbuf 0
and __ocaml_lex_break_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 33 "url.mll"
                     scheme
# 244 "url.ml"
= Lexing.sub_lexeme_opt lexbuf lexbuf.Lexing.lex_mem.(9) lexbuf.Lexing.lex_mem.(8)
and
# 34 "url.mll"
                        authority
# 249 "url.ml"
= Lexing.sub_lexeme_opt lexbuf lexbuf.Lexing.lex_mem.(3) lexbuf.Lexing.lex_mem.(2)
and
# 35 "url.mll"
               path
# 254 "url.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1)
and
# 36 "url.mll"
                query
# 259 "url.ml"
= Lexing.sub_lexeme_opt lexbuf lexbuf.Lexing.lex_mem.(7) lexbuf.Lexing.lex_mem.(6)
and
# 37 "url.mll"
            fragment
# 264 "url.ml"
= Lexing.sub_lexeme_opt lexbuf lexbuf.Lexing.lex_mem.(5) lexbuf.Lexing.lex_mem.(4) in
# 38 "url.mll"
( {scheme; authority; path; query; fragment;} )
# 268 "url.ml"

  | 1 ->
# 39 "url.mll"
     ( raise Error )
# 273 "url.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_break_rec lexbuf __ocaml_lex_state

and do_decode putc lexbuf =
   __ocaml_lex_do_decode_rec putc lexbuf 23
and __ocaml_lex_do_decode_rec putc lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 42 "url.mll"
              a
# 286 "url.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_start_pos + 1)
and
# 42 "url.mll"
                         b
# 291 "url.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_start_pos + 2) in
# 43 "url.mll"
  ( let n =
    try int_of_string (sprintf "0x%c%c" a b) with _ -> assert false in
  putc (Char.chr n) ;
  do_decode putc lexbuf )
# 298 "url.ml"

  | 1 ->
let
# 47 "url.mll"
       c
# 304 "url.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 47 "url.mll"
         ( putc c ; do_decode putc lexbuf )
# 308 "url.ml"

  | 2 ->
# 48 "url.mll"
         ( () )
# 313 "url.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_do_decode_rec putc lexbuf __ocaml_lex_state

;;

# 50 "url.mll"
 
(* See
http://www.lunatech-research.com/archives/2009/02/03/what-every-web-developer-must-know-about-url-encoding/#Thereservedcharactersarenotwhatyouthinktheyare
*)
 let do_encode_fragment putc put c =  match c with
 |  'a'..'z' | 'A'..'Z' | '0'..'9' | '-' | '_' | '~' | '.'
   -> putc c
 | _ -> put (sprintf "%%%02X" (Char.code c))

 let do_encode putc put specific u =
   let len = String.length u in
   for k =0 to len-1 do
     let c = String.unsafe_get u k in
     specific putc put c
   done

 let apply putc put f u =
   begin match u.scheme with
   | None -> ()
   | Some s -> f s ; putc ':'
   end ;
   begin match u.authority with
   | None -> ()
   | Some s -> put "//" ; f s
   end ;
   f u.path ;
   begin match u.query with
   | None -> ()
   | Some s -> putc '?' ; f s
   end ;
   begin match u.fragment with
   | None -> ()
   | Some s -> putc '#' ; f s
   end ;
   ()

 let _encode putc put u =
   let u = break (MyLexing.from_string u) in
   apply putc put (do_encode putc put do_encode_fragment) u

 let _decode putc put u =
   let u = break (MyLexing.from_string u) in
   let do_decode s = do_decode putc (MyLexing.from_string s) in
   apply putc put do_decode u


  let encode_fragment putc put u =
    do_encode putc put do_encode_fragment u

  let decode_fragment putc _put u = do_decode putc (MyLexing.from_string u)

# 372 "url.ml"
